import { AllureExecutable } from "./AllureExecutable";
import { fixtureResult, testResultContainer } from "./AllureResults";
import { AllureTest } from "./AllureTest";
export class AllureGroup {
    runtime;
    testResultContainer;
    constructor(runtime) {
        this.runtime = runtime;
        this.testResultContainer = testResultContainer(runtime.crypto.uuid());
    }
    startGroup(name) {
        const group = new AllureGroup(this.runtime);
        this.testResultContainer.children.push(group.uuid);
        group.name = name || "Unnamed";
        return group;
    }
    startTest(name, start) {
        const test = new AllureTest(this.runtime, start);
        this.testResultContainer.children.push(test.uuid);
        test.name = name || "Unnamed";
        return test;
    }
    endGroup() {
        this.runtime.writeGroup(this.testResultContainer);
    }
    get uuid() {
        return this.testResultContainer.uuid;
    }
    get name() {
        return this.testResultContainer.name || "";
    }
    set name(name) {
        this.testResultContainer.name = name;
    }
    addBefore() {
        const result = fixtureResult();
        this.testResultContainer.befores.push(result);
        return new AllureExecutable(result);
    }
    addAfter() {
        const result = fixtureResult();
        this.testResultContainer.afters.push(result);
        return new AllureExecutable(result);
    }
}
//# sourceMappingURL=AllureGroup.js.map