import { Stage, Status, } from "../model";
import { isPromise } from "../utils";
import { serialize } from "../utils";
import { stepResult } from "./AllureResults";
import { isAllStepsEnded, isAnyStepFailed } from "./utils";
export class AllureExecutable {
    info;
    constructor(info) {
        this.info = info;
    }
    get wrappedItem() {
        return this.info;
    }
    set name(name) {
        this.info.name = name;
    }
    set description(description) {
        this.info.description = description;
    }
    set descriptionHtml(descriptionHtml) {
        this.info.descriptionHtml = descriptionHtml;
    }
    set status(status) {
        this.info.status = status;
    }
    get status() {
        return this.info.status;
    }
    set statusDetails(details) {
        this.info.statusDetails = details;
    }
    set detailsMessage(message) {
        this.info.statusDetails.message = message;
    }
    set detailsTrace(trace) {
        this.info.statusDetails.trace = trace;
    }
    set stage(stage) {
        this.info.stage = stage;
    }
    parameter(name, value, options) {
        this.info.parameters.push({ ...options, name, value: serialize(value) });
    }
    get isAnyStepFailed() {
        return isAnyStepFailed(this.info);
    }
    get isAllStepsEnded() {
        return isAllStepsEnded(this.info);
    }
    addParameter(name, value, options) {
        this.parameter(name, value, options);
    }
    addAttachment(name, options, fileName) {
        if (typeof options === "string") {
            options = { contentType: options };
        }
        this.info.attachments.push({ name, type: options.contentType, source: fileName });
    }
    startStep(name, start) {
        const result = stepResult();
        this.info.steps.push(result);
        const allureStep = new AllureStep(result, start);
        allureStep.name = name;
        return allureStep;
    }
    wrap(fun) {
        return (...args) => {
            this.stage = Stage.RUNNING;
            let result;
            try {
                result = fun(args);
            }
            catch (error) {
                this.stage = Stage.INTERRUPTED;
                this.status = Status.BROKEN;
                if (error) {
                    this.detailsMessage = error.message || "";
                    this.detailsTrace = error.stack || "";
                }
                throw error;
            }
            if (isPromise(result)) {
                const promise = result;
                return promise
                    .then((res) => {
                    this.status = Status.PASSED;
                    this.stage = Stage.FINISHED;
                    return res;
                })
                    .catch((error) => {
                    this.stage = Stage.INTERRUPTED;
                    this.status = Status.BROKEN;
                    if (error) {
                        this.detailsMessage = error.message || "";
                        this.detailsTrace = error.stack || "";
                    }
                    throw error;
                });
            }
            else {
                this.status = Status.PASSED;
                this.stage = Stage.FINISHED;
                return result;
            }
        };
    }
    addStep(step) {
        this.info.steps.push(step);
    }
}
export class AllureStep extends AllureExecutable {
    stepResult;
    constructor(stepResult, start = Date.now()) {
        super(stepResult);
        this.stepResult = stepResult;
        this.stepResult.start = start;
    }
    endStep(stop = Date.now()) {
        this.stepResult.stop = stop;
    }
}
//# sourceMappingURL=AllureExecutable.js.map