import { readFileSync } from "fs";
import properties from "properties";
const sendEvent = (event) => {
    process.send?.(JSON.stringify(event));
};
const sendData = (path, type, data) => {
    sendEvent({ path, type, data: data.toString("base64") });
};
const writeJson = (path, type, data) => {
    sendData(path, type, Buffer.from(JSON.stringify(data)));
};
export class MessageAllureWriter {
    writeAttachment(name, content, encoding = "utf-8") {
        sendData(name, "attachment", typeof content === "string" ? Buffer.from(content, encoding) : content);
    }
    writeAttachmentFromPath(from, distFileName) {
        sendData(distFileName, "attachment", readFileSync(from));
    }
    writeEnvironmentInfo(info) {
        const text = properties.stringify(info, { unicode: true }).toString();
        sendData("environment.properties", "misc", Buffer.from(text));
    }
    writeCategoriesDefinitions(categories) {
        writeJson("categories.json", "misc", categories);
    }
    writeGroup(result) {
        writeJson(`${result.uuid}-container.json`, "container", result);
    }
    writeResult(result) {
        writeJson(`${result.uuid}-result.json`, "result", result);
    }
}
//# sourceMappingURL=MessageAllureWriter.js.map