import { ExecutableItem, Label, Status } from "./model.js";
export declare const md5: (data: string) => string;
export declare const getLabelsFromEnv: () => Label[];
export declare const escapeRegExp: (value: string) => string;
export declare const isAnyStepFailed: (item: ExecutableItem) => boolean;
export declare const isAllStepsEnded: (item: ExecutableItem) => boolean;
export declare const readImageAsBase64: (filePath: string) => Promise<string | undefined>;
export declare const stripAscii: (str: string) => string;
export declare const allureReportFolder: (outputFolder?: string) => string;
export declare const defaultReportFolder: () => string;
export declare const allureIdRegexp: RegExp;
export declare const allureIdRegexpGlobal: RegExp;
export declare const allureLabelRegexp: RegExp;
export declare const allureLabelRegexpGlobal: RegExp;
export declare const getStatusFromError: (error: Error) => Status;
export declare const getSuitesLabels: (suites: string[]) => Label[];
export declare const serialize: (val: unknown) => string;
export declare const extractMetadataFromString: (title: string) => {
    labels: Label[];
    cleanTitle: string;
};
