import { randomUUID } from "crypto";
import { AllureGroup } from "./AllureGroup.js";
import { FileSystemAllureWriter, typeToExtension } from "./writers/index.js";
const buildAttachmentFileName = (options) => {
    if (typeof options === "string") {
        options = { contentType: options };
    }
    const extension = typeToExtension(options);
    return `${randomUUID()}-attachment${extension}`;
};
export class AllureRuntime {
    config;
    writer;
    constructor(config) {
        this.config = config;
        this.writer = config.writer || new FileSystemAllureWriter(config);
    }
    startGroup(name) {
        const allureContainer = new AllureGroup(this);
        allureContainer.name = name || "Unnamed";
        return allureContainer;
    }
    writeResult(result) {
        const modifiedResult = this.config.testMapper !== undefined ? this.config.testMapper(result) : result;
        if (modifiedResult != null) {
            this.writer.writeResult(modifiedResult);
        }
    }
    writeGroup(result) {
        this.writer.writeGroup(result);
    }
    writeAttachment(content, options, encoding) {
        const fileName = buildAttachmentFileName(options);
        this.writer.writeAttachment(fileName, content, encoding);
        return fileName;
    }
    writeAttachmentFromPath(fromPath, options) {
        const fileName = buildAttachmentFileName(options);
        this.writer.writeAttachmentFromPath(fromPath, fileName);
        return fileName;
    }
    writeEnvironmentInfo(info) {
        this.writer.writeEnvironmentInfo(info || process.env);
    }
    writeCategoriesDefinitions(categories) {
        const serializedCategories = categories.map((c) => {
            if (c.messageRegex instanceof RegExp) {
                c.messageRegex = c.messageRegex.source;
            }
            if (c.traceRegex instanceof RegExp) {
                c.traceRegex = c.traceRegex.source;
            }
            return c;
        });
        this.writer.writeCategoriesDefinitions(serializedCategories);
    }
}
//# sourceMappingURL=AllureRuntime.js.map