import { LabelName, LinkType } from "./model.js";
export class Allure {
    runtime;
    constructor(runtime) {
        this.runtime = runtime;
    }
    testCaseId(id) {
        this.currentTest.testCaseId = id;
    }
    historyId(id) {
        this.currentTest.historyId = id;
    }
    epic(epic) {
        this.label(LabelName.EPIC, epic);
    }
    feature(feature) {
        this.label(LabelName.FEATURE, feature);
    }
    story(story) {
        this.label(LabelName.STORY, story);
    }
    suite(name) {
        this.label(LabelName.SUITE, name);
    }
    parentSuite(name) {
        this.label(LabelName.PARENT_SUITE, name);
    }
    subSuite(name) {
        this.label(LabelName.SUB_SUITE, name);
    }
    label(name, value) {
        this.currentTest.addLabel(name, value);
    }
    parameter(name, value, options) {
        this.currentExecutable.parameter(name, value, options);
    }
    link(url, name, type) {
        this.currentTest.addLink(url, name, type);
    }
    issue(name, url) {
        this.link(url, name, LinkType.ISSUE);
    }
    tms(name, url) {
        this.link(url, name, LinkType.TMS);
    }
    description(markdown) {
        this.currentExecutable.description = markdown;
    }
    descriptionHtml(html) {
        this.currentExecutable.descriptionHtml = html;
    }
    owner(owner) {
        this.label(LabelName.OWNER, owner);
    }
    severity(severity) {
        this.label(LabelName.SEVERITY, severity);
    }
    layer(layer) {
        this.label(LabelName.LAYER, layer);
    }
    id(allureId) {
        this.label(LabelName.ALLURE_ID, allureId);
    }
    tag(tag) {
        this.label(LabelName.TAG, tag);
    }
    writeEnvironmentInfo(info) {
        this.runtime.writeEnvironmentInfo(info);
    }
    writeCategoriesDefinitions(categories) {
        this.runtime.writeCategoriesDefinitions(categories);
    }
}
//# sourceMappingURL=Allure.js.map