"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultReportFolder = exports.allureReportFolder = exports.stripAscii = exports.readImageAsBase64 = exports.escapeRegExp = exports.getLabelsFromEnv = void 0;
const promises_1 = require("fs/promises");
const path_1 = __importDefault(require("path"));
const process_1 = require("process");
const getLabelsFromEnv = () => {
    const envKeys = Object.keys(process_1.env);
    const labels = [];
    envKeys.forEach((key) => {
        var _a;
        const labelRegexp = /^ALLURE_LABEL_(?<labelName>.+)$/;
        const match = key.match(labelRegexp);
        if (match) {
            const labelName = (_a = match.groups) === null || _a === void 0 ? void 0 : _a.labelName;
            const envValue = process.env[key];
            if (labelName && envValue) {
                labels.push({ name: labelName.toLocaleLowerCase(), value: envValue });
            }
        }
    });
    return labels;
};
exports.getLabelsFromEnv = getLabelsFromEnv;
const reRegExpChar = /[\\^$.*+?()[\]{}|]/g, reHasRegExpChar = RegExp(reRegExpChar.source);
const escapeRegExp = (value) => {
    return reHasRegExpChar.test(value) ? value.replace(reRegExpChar, "\\$&") : value;
};
exports.escapeRegExp = escapeRegExp;
const readImageAsBase64 = (filePath) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const file = yield (0, promises_1.readFile)(filePath, { encoding: "base64" });
        return file ? `data:image/png;base64,${file}` : undefined;
    }
    catch (e) {
        return undefined;
    }
});
exports.readImageAsBase64 = readImageAsBase64;
const asciiRegex = new RegExp("[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:[a-zA-Z\\d]*(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)|(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))", "g");
const stripAscii = (str) => {
    return str.replace(asciiRegex, "");
};
exports.stripAscii = stripAscii;
const allureReportFolder = (outputFolder) => {
    if (process.env.ALLURE_RESULTS_DIR) {
        return path_1.default.resolve(process.cwd(), process.env.ALLURE_RESULTS_DIR);
    }
    if (outputFolder) {
        return outputFolder;
    }
    return (0, exports.defaultReportFolder)();
};
exports.allureReportFolder = allureReportFolder;
const defaultReportFolder = () => {
    return path_1.default.resolve(process.cwd(), "allure-results");
};
exports.defaultReportFolder = defaultReportFolder;
//# sourceMappingURL=utils.js.map