"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AllureNodeRuntime = void 0;
const crypto_1 = require("crypto");
const AllureRuntime_js_1 = require("../framework/AllureRuntime.js");
class AllureNodeRuntime extends AllureRuntime_js_1.AllureBaseRuntime {
    constructor(config) {
        super(config, {
            uuid: () => {
                return (0, crypto_1.randomUUID)();
            },
            md5: (data) => {
                return (0, crypto_1.createHash)("md5").update(data).digest("hex");
            },
        });
    }
    writeAttachmentFromPath(fromPath, options) {
        const fileName = this.buildAttachmentFileName(options);
        this.writer.writeAttachmentFromPath(fromPath, fileName);
        return fileName;
    }
}
exports.AllureNodeRuntime = AllureNodeRuntime;
//# sourceMappingURL=runtime.js.map