/// <reference types="node" />
import { AllureResults, Category, TestResult, TestResultContainer } from "../../model";
import { AllureWriter } from "../AllureWriter";
export declare class AllureInMemoryAllureWriter implements AllureWriter, AllureResults {
    groups: TestResultContainer[];
    tests: TestResult[];
    attachments: Record<string, Buffer | string>;
    categories?: Category[];
    envInfo?: Record<string, string | undefined>;
    writeGroup(result: TestResultContainer): void;
    writeResult(result: TestResult): void;
    writeAttachment(name: string, content: Buffer | string): void;
    writeAttachmentFromPath(from: string, toFileName: string): void;
    writeCategoriesDefinitions(categories: Category[]): void;
    writeEnvironmentInfo(envInfo?: Record<string, string | undefined>): void;
    reset(): void;
    getMaybeTestByName(name: string): TestResult | undefined;
    getTestByName(name: string): TestResult;
    getMaybeGroupByName(name: string): TestResultContainer | undefined;
    getGroupByName(name: string): TestResultContainer;
}
