"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractMetadataFromString = exports.getSuitesLabels = exports.getStatusFromError = exports.isAllStepsEnded = exports.isAnyStepFailed = exports.allureLabelRegexpGlobal = exports.allureLabelRegexp = exports.allureIdRegexpGlobal = exports.allureIdRegexp = void 0;
const model_1 = require("../model");
exports.allureIdRegexp = /@?allure.id[:=](?<id>[^\s]+)/;
exports.allureIdRegexpGlobal = new RegExp(exports.allureIdRegexp, "g");
exports.allureLabelRegexp = /@?allure.label.(?<name>[^\s]+?)[:=](?<value>[^\s]+)/;
exports.allureLabelRegexpGlobal = new RegExp(exports.allureLabelRegexp, "g");
const isAnyStepFailed = (item) => {
    const isFailed = item.status === model_1.Status.FAILED;
    if (isFailed || item.steps.length === 0) {
        return isFailed;
    }
    return !!item.steps.find((step) => (0, exports.isAnyStepFailed)(step));
};
exports.isAnyStepFailed = isAnyStepFailed;
const isAllStepsEnded = (item) => {
    return item.steps.every((val) => val.stop && (0, exports.isAllStepsEnded)(val));
};
exports.isAllStepsEnded = isAllStepsEnded;
const getStatusFromError = (error) => {
    switch (true) {
        case /assert/gi.test(error.constructor.name):
        case /assert/gi.test(error.name):
        case /assert/gi.test(error.message):
            return model_1.Status.FAILED;
        default:
            return model_1.Status.BROKEN;
    }
};
exports.getStatusFromError = getStatusFromError;
const getSuitesLabels = (suites) => {
    if (suites.length === 0) {
        return [];
    }
    const [parentSuite, suite, ...subSuites] = suites;
    const labels = [];
    if (parentSuite) {
        labels.push({
            name: model_1.LabelName.PARENT_SUITE,
            value: parentSuite,
        });
    }
    if (suite) {
        labels.push({
            name: model_1.LabelName.SUITE,
            value: suite,
        });
    }
    if (subSuites.length > 0) {
        labels.push({
            name: model_1.LabelName.SUB_SUITE,
            value: subSuites.join(" > "),
        });
    }
    return labels;
};
exports.getSuitesLabels = getSuitesLabels;
const extractMetadataFromString = (title) => {
    const labels = [];
    title.split(" ").forEach((val) => {
        var _a, _b;
        const idValue = (_b = (_a = val.match(exports.allureIdRegexp)) === null || _a === void 0 ? void 0 : _a.groups) === null || _b === void 0 ? void 0 : _b.id;
        if (idValue) {
            labels.push({ name: model_1.LabelName.ALLURE_ID, value: idValue });
        }
        const labelMatch = val.match(exports.allureLabelRegexp);
        const { name, value } = (labelMatch === null || labelMatch === void 0 ? void 0 : labelMatch.groups) || {};
        if (name && value) {
            labels === null || labels === void 0 ? void 0 : labels.push({ name, value });
        }
    });
    const cleanTitle = title.replace(exports.allureLabelRegexpGlobal, "").replace(exports.allureIdRegexpGlobal, "").trim();
    return { labels, cleanTitle };
};
exports.extractMetadataFromString = extractMetadataFromString;
//# sourceMappingURL=utils.js.map