/// <reference types="node" />
import { AttachmentOptions, Category, ContentType, ParameterOptions, Status } from "../model";
import { AllureExecutable } from "./AllureExecutable";
import { AllureRuntime } from "./AllureRuntime";
import { AllureTest } from "./AllureTest";
export interface AllureRuntimeApiInterface {
    label(name: string, value: string): void;
    parameter(name: string, value: any, options?: ParameterOptions): void;
    link(url: string, name?: string, type?: string): void;
    attachment(content: string | Buffer, type: string): void;
    epic(epic: string): void;
    feature(feature: string): void;
    story(story: string): void;
    suite(name: string): void;
    parentSuite(name: string): void;
    subSuite(name: string): void;
    owner(owner: string): void;
    severity(severity: string): void;
    layer(layer: string): void;
    id(allureId: string): void;
    tag(tag: string): void;
    issue(name: string, url: string): void;
    tms(name: string, url: string): void;
    description(markdown: string): void;
    descriptionHtml(html: string): void;
    testCaseId(id: string): void;
    historyId(id: string): void;
}
export declare abstract class Allure implements Omit<AllureRuntimeApiInterface, "step" | "attachment"> {
    protected runtime: AllureRuntime;
    protected abstract get currentTest(): AllureTest;
    protected abstract get currentExecutable(): AllureExecutable;
    protected constructor(runtime: AllureRuntime);
    testCaseId(id: string): void;
    historyId(id: string): void;
    epic(epic: string): void;
    feature(feature: string): void;
    story(story: string): void;
    suite(name: string): void;
    parentSuite(name: string): void;
    subSuite(name: string): void;
    label(name: string, value: string): void;
    parameter(name: string, value: any, options?: ParameterOptions): void;
    link(url: string, name?: string, type?: string): void;
    issue(name: string, url: string): void;
    tms(name: string, url: string): void;
    description(markdown: string): void;
    descriptionHtml(html: string): void;
    owner(owner: string): void;
    severity(severity: string): void;
    layer(layer: string): void;
    id(allureId: string): void;
    tag(tag: string): void;
    writeEnvironmentInfo(info: Record<string, string>): void;
    writeCategoriesDefinitions(categories: Category[]): void;
    abstract attachment(name: string, content: Buffer | string, options: ContentType | string | AttachmentOptions): void;
    abstract logStep(name: string, status?: Status): void;
    abstract step<T>(name: string, body: (step: StepInterface) => T): T;
}
export interface StepInterface {
    parameter(name: string, value: string): void;
    name(name: string): void;
}
