"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.testResult = exports.stepResult = exports.fixtureResult = exports.testResultContainer = void 0;
const model_1 = require("../model");
const testResultContainer = (uuid) => {
    return {
        uuid,
        children: [],
        befores: [],
        afters: [],
    };
};
exports.testResultContainer = testResultContainer;
const fixtureResult = () => {
    return {
        status: model_1.Status.BROKEN,
        statusDetails: {},
        stage: model_1.Stage.PENDING,
        steps: [],
        attachments: [],
        parameters: [],
    };
};
exports.fixtureResult = fixtureResult;
const stepResult = () => {
    return {
        status: undefined,
        statusDetails: {},
        stage: model_1.Stage.PENDING,
        steps: [],
        attachments: [],
        parameters: [],
    };
};
exports.stepResult = stepResult;
const testResult = (uuid, historyUuid) => {
    return {
        uuid,
        historyId: historyUuid,
        status: undefined,
        statusDetails: {},
        stage: model_1.Stage.PENDING,
        steps: [],
        attachments: [],
        parameters: [],
        labels: [],
        links: [],
    };
};
exports.testResult = testResult;
//# sourceMappingURL=AllureResults.js.map