"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AllureGroup = void 0;
const AllureExecutable_1 = require("./AllureExecutable");
const AllureResults_1 = require("./AllureResults");
const AllureTest_1 = require("./AllureTest");
class AllureGroup {
    constructor(runtime) {
        this.runtime = runtime;
        this.testResultContainer = (0, AllureResults_1.testResultContainer)(runtime.crypto.uuid());
    }
    startGroup(name) {
        const group = new AllureGroup(this.runtime);
        this.testResultContainer.children.push(group.uuid);
        group.name = name || "Unnamed";
        return group;
    }
    startTest(name, start) {
        const test = new AllureTest_1.AllureTest(this.runtime, start);
        this.testResultContainer.children.push(test.uuid);
        test.name = name || "Unnamed";
        return test;
    }
    endGroup() {
        this.runtime.writeGroup(this.testResultContainer);
    }
    get uuid() {
        return this.testResultContainer.uuid;
    }
    get name() {
        return this.testResultContainer.name || "";
    }
    set name(name) {
        this.testResultContainer.name = name;
    }
    addBefore() {
        const result = (0, AllureResults_1.fixtureResult)();
        this.testResultContainer.befores.push(result);
        return new AllureExecutable_1.AllureExecutable(result);
    }
    addAfter() {
        const result = (0, AllureResults_1.fixtureResult)();
        this.testResultContainer.afters.push(result);
        return new AllureExecutable_1.AllureExecutable(result);
    }
}
exports.AllureGroup = AllureGroup;
//# sourceMappingURL=AllureGroup.js.map