"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseTestPlan = void 0;
const fs_1 = __importDefault(require("fs"));
const parseTestPlan = () => {
    const testPlanPath = process.env.ALLURE_TESTPLAN_PATH;
    if (!testPlanPath) {
        return undefined;
    }
    try {
        const file = fs_1.default.readFileSync(testPlanPath, "utf8");
        const testPlan = JSON.parse(file);
        if ((testPlan.tests || []).length === 0) {
            return undefined;
        }
        return testPlan;
    }
    catch (e) {
        return undefined;
    }
};
exports.parseTestPlan = parseTestPlan;
//# sourceMappingURL=testplan.js.map