"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Allure = void 0;
const model_js_1 = require("./model.js");
class Allure {
    constructor(runtime) {
        this.runtime = runtime;
    }
    testCaseId(id) {
        this.currentTest.testCaseId = id;
    }
    historyId(id) {
        this.currentTest.historyId = id;
    }
    epic(epic) {
        this.label(model_js_1.LabelName.EPIC, epic);
    }
    feature(feature) {
        this.label(model_js_1.LabelName.FEATURE, feature);
    }
    story(story) {
        this.label(model_js_1.LabelName.STORY, story);
    }
    suite(name) {
        this.label(model_js_1.LabelName.SUITE, name);
    }
    parentSuite(name) {
        this.label(model_js_1.LabelName.PARENT_SUITE, name);
    }
    subSuite(name) {
        this.label(model_js_1.LabelName.SUB_SUITE, name);
    }
    label(name, value) {
        this.currentTest.addLabel(name, value);
    }
    parameter(name, value, options) {
        this.currentExecutable.parameter(name, value, options);
    }
    link(url, name, type) {
        this.currentTest.addLink(url, name, type);
    }
    issue(name, url) {
        this.link(url, name, model_js_1.LinkType.ISSUE);
    }
    tms(name, url) {
        this.link(url, name, model_js_1.LinkType.TMS);
    }
    description(markdown) {
        this.currentExecutable.description = markdown;
    }
    descriptionHtml(html) {
        this.currentExecutable.descriptionHtml = html;
    }
    owner(owner) {
        this.label(model_js_1.LabelName.OWNER, owner);
    }
    severity(severity) {
        this.label(model_js_1.LabelName.SEVERITY, severity);
    }
    layer(layer) {
        this.label(model_js_1.LabelName.LAYER, layer);
    }
    id(allureId) {
        this.label(model_js_1.LabelName.ALLURE_ID, allureId);
    }
    tag(tag) {
        this.label(model_js_1.LabelName.TAG, tag);
    }
    writeEnvironmentInfo(info) {
        this.runtime.writeEnvironmentInfo(info);
    }
    writeCategoriesDefinitions(categories) {
        this.runtime.writeCategoriesDefinitions(categories);
    }
}
exports.Allure = Allure;
//# sourceMappingURL=Allure.js.map