/**
 * !!! PLEASE DO NOT EDIT THIS FILE !!!
 *
 * This source file, even though checked in, is auto-generated based on the
 * current development within the WebDriver Bidi spec. Any changes to this
 * file need to come from the specification. You can generate this file by calling
 *
 * ```
 * $ npm run generate:bidi
 * ```
 *
 * from the project root. You can find the scripts that generates this file in
 * ./scripts/bidi/**
 */
declare const protocol: {
    readonly sendCommand: {
        readonly socket: {
            readonly command: "send";
            readonly description: "Send socket commands via WebDriver Bidi";
            readonly ref: "https://github.com/w3c/webdriver-bidi";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "CommandData";
                readonly description: "socket payload";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "CommandResponse";
                readonly description: "WebDriver Bidi response";
            };
        };
    };
    readonly sendAsyncCommand: {
        readonly socket: {
            readonly command: "sendAsync";
            readonly description: "Send asynchronous socket commands via WebDriver Bidi";
            readonly ref: "https://github.com/w3c/webdriver-bidi";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "CommandData";
                readonly description: "socket payload";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Number";
                readonly name: "id";
                readonly description: "id of WebDriver Bidi request";
            };
        };
    };
    readonly "session.status": {
        readonly socket: {
            readonly command: "sessionStatus";
            readonly description: "WebDriver Bidi command to send command method \"session.status\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-session-status";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.EmptyParams`";
                readonly description: "<pre>\\{\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.SessionStatusResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     ready: boolean;\n     message: string;\n   }\n   ```";
            };
        };
    };
    readonly "session.new": {
        readonly socket: {
            readonly command: "sessionNew";
            readonly description: "WebDriver Bidi command to send command method \"session.new\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-session-new";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.SessionNewParameters`";
                readonly description: "<pre>\\{<br />  capabilities: SessionCapabilitiesRequest;<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.SessionNewResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     sessionId: string;\n     capabilities: {\n       acceptInsecureCerts: boolean;\n       browserName: string;\n       browserVersion: string;\n       platformName: string;\n       setWindowRect: boolean;\n       userAgent: string;\n       proxy?: SessionProxyConfiguration;\n       unhandledPromptBehavior?: SessionUserPromptHandler;\n       webSocketUrl?: string;\n     };\n   }\n   ```";
            };
        };
    };
    readonly "session.end": {
        readonly socket: {
            readonly command: "sessionEnd";
            readonly description: "WebDriver Bidi command to send command method \"session.end\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-session-end";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.EmptyParams`";
                readonly description: "<pre>\\{\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "session.subscribe": {
        readonly socket: {
            readonly command: "sessionSubscribe";
            readonly description: "WebDriver Bidi command to send command method \"session.subscribe\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-session-subscribe";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.SessionSubscriptionRequest`";
                readonly description: "<pre>\\{<br />  events: string[];<br />  contexts?: BrowsingContextBrowsingContext[];<br />  userContexts?: BrowserUserContext[];<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.SessionSubscribeResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     subscription: SessionSubscription;\n   }\n   ```";
            };
        };
    };
    readonly "session.unsubscribe": {
        readonly socket: {
            readonly command: "sessionUnsubscribe";
            readonly description: "WebDriver Bidi command to send command method \"session.unsubscribe\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-session-unsubscribe";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.SessionUnsubscribeParameters`";
                readonly description: "<pre>\\\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "browser.close": {
        readonly socket: {
            readonly command: "browserClose";
            readonly description: "WebDriver Bidi command to send command method \"browser.close\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browser-close";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.EmptyParams`";
                readonly description: "<pre>\\{\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "browser.createUserContext": {
        readonly socket: {
            readonly command: "browserCreateUserContext";
            readonly description: "WebDriver Bidi command to send command method \"browser.createUserContext\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browser-createUserContext";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.BrowserCreateUserContextParameters`";
                readonly description: "<pre>\\{<br />  acceptInsecureCerts?: boolean;<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.BrowserCreateUserContextResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   ;\n   ```";
            };
        };
    };
    readonly "browser.getClientWindows": {
        readonly socket: {
            readonly command: "browserGetClientWindows";
            readonly description: "WebDriver Bidi command to send command method \"browser.getClientWindows\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browser-getClientWindows";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.EmptyParams`";
                readonly description: "<pre>\\{\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.BrowserGetClientWindowsResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     clientWindows: BrowserClientWindowInfo[];\n   }\n   ```";
            };
        };
    };
    readonly "browser.getUserContexts": {
        readonly socket: {
            readonly command: "browserGetUserContexts";
            readonly description: "WebDriver Bidi command to send command method \"browser.getUserContexts\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browser-getUserContexts";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.EmptyParams`";
                readonly description: "<pre>\\{\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.BrowserGetUserContextsResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     userContexts: BrowserUserContextInfo[];\n   }\n   ```";
            };
        };
    };
    readonly "browser.removeUserContext": {
        readonly socket: {
            readonly command: "browserRemoveUserContext";
            readonly description: "WebDriver Bidi command to send command method \"browser.removeUserContext\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browser-removeUserContext";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.BrowserRemoveUserContextParameters`";
                readonly description: "<pre>\\{<br />  userContext: BrowserUserContext;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "browser.setClientWindowState": {
        readonly socket: {
            readonly command: "browserSetClientWindowState";
            readonly description: "WebDriver Bidi command to send command method \"browser.setClientWindowState\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browser-setClientWindowState";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.BrowserSetClientWindowStateParameters`";
                readonly description: "<pre>\\{<br />  clientWindow: BrowserClientWindow;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "browsingContext.activate": {
        readonly socket: {
            readonly command: "browsingContextActivate";
            readonly description: "WebDriver Bidi command to send command method \"browsingContext.activate\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browsingContext-activate";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.BrowsingContextActivateParameters`";
                readonly description: "<pre>\\{<br />  context: BrowsingContextBrowsingContext;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "browsingContext.captureScreenshot": {
        readonly socket: {
            readonly command: "browsingContextCaptureScreenshot";
            readonly description: "WebDriver Bidi command to send command method \"browsingContext.captureScreenshot\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browsingContext-captureScreenshot";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.BrowsingContextCaptureScreenshotParameters`";
                readonly description: "<pre>\\{<br />  context: BrowsingContextBrowsingContext;<br />  /\\*\\*<br />   \\* @default 'viewport'<br />   \\*/<br />  origin?: \"viewport\" &#124; \"document\";<br />  format?: BrowsingContextImageFormat;<br />  clip?: BrowsingContextClipRectangle;<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.BrowsingContextCaptureScreenshotResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     data: string;\n   }\n   ```";
            };
        };
    };
    readonly "browsingContext.close": {
        readonly socket: {
            readonly command: "browsingContextClose";
            readonly description: "WebDriver Bidi command to send command method \"browsingContext.close\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browsingContext-close";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.BrowsingContextCloseParameters`";
                readonly description: "<pre>\\{<br />  context: BrowsingContextBrowsingContext;<br />  promptUnload?: boolean;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "browsingContext.create": {
        readonly socket: {
            readonly command: "browsingContextCreate";
            readonly description: "WebDriver Bidi command to send command method \"browsingContext.create\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browsingContext-create";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.BrowsingContextCreateParameters`";
                readonly description: "<pre>\\{<br />  type: BrowsingContextCreateType;<br />  referenceContext?: BrowsingContextBrowsingContext;<br />  background?: boolean;<br />  userContext?: BrowserUserContext;<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.BrowsingContextCreateResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     context: BrowsingContextBrowsingContext;\n   }\n   ```";
            };
        };
    };
    readonly "browsingContext.getTree": {
        readonly socket: {
            readonly command: "browsingContextGetTree";
            readonly description: "WebDriver Bidi command to send command method \"browsingContext.getTree\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browsingContext-getTree";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.BrowsingContextGetTreeParameters`";
                readonly description: "<pre>\\{<br />  maxDepth?: JsUint;<br />  root?: BrowsingContextBrowsingContext;<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.BrowsingContextGetTreeResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     contexts: BrowsingContextInfoList;\n   }\n   ```";
            };
        };
    };
    readonly "browsingContext.handleUserPrompt": {
        readonly socket: {
            readonly command: "browsingContextHandleUserPrompt";
            readonly description: "WebDriver Bidi command to send command method \"browsingContext.handleUserPrompt\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browsingContext-handleUserPrompt";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.BrowsingContextHandleUserPromptParameters`";
                readonly description: "<pre>\\{<br />  context: BrowsingContextBrowsingContext;<br />  accept?: boolean;<br />  userText?: string;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "browsingContext.locateNodes": {
        readonly socket: {
            readonly command: "browsingContextLocateNodes";
            readonly description: "WebDriver Bidi command to send command method \"browsingContext.locateNodes\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browsingContext-locateNodes";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.BrowsingContextLocateNodesParameters`";
                readonly description: "<pre>\\{<br />  context: BrowsingContextBrowsingContext;<br />  locator: BrowsingContextLocator;<br />  maxNodeCount?: JsUint;<br />  serializationOptions?: ScriptSerializationOptions;<br />  startNodes?: ScriptSharedReference[];<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.BrowsingContextLocateNodesResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     nodes: ScriptNodeRemoteValue[];\n   }\n   ```";
            };
        };
    };
    readonly "browsingContext.navigate": {
        readonly socket: {
            readonly command: "browsingContextNavigate";
            readonly description: "WebDriver Bidi command to send command method \"browsingContext.navigate\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browsingContext-navigate";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.BrowsingContextNavigateParameters`";
                readonly description: "<pre>\\{<br />  context: BrowsingContextBrowsingContext;<br />  url: string;<br />  wait?: BrowsingContextReadinessState;<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.BrowsingContextNavigateResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     navigation: BrowsingContextNavigation | null;\n     url: string;\n   }\n   ```";
            };
        };
    };
    readonly "browsingContext.print": {
        readonly socket: {
            readonly command: "browsingContextPrint";
            readonly description: "WebDriver Bidi command to send command method \"browsingContext.print\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browsingContext-print";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.BrowsingContextPrintParameters`";
                readonly description: "<pre>\\{<br />  context: BrowsingContextBrowsingContext;<br />  background?: boolean;<br />  margin?: BrowsingContextPrintMarginParameters;<br />  /\\*\\*<br />   \\* @default 'portrait'<br />   \\*/<br />  orientation?: \"portrait\" &#124; \"landscape\";<br />  page?: BrowsingContextPrintPageParameters;<br />  pageRanges?: (JsUint &#124; string)[];<br />  /\\*\\*<br />   \\* @default 1<br />   \\*/<br />  scale?: number;<br />  /\\*\\*<br />   \\* @default true<br />   \\*/<br />  shrinkToFit?: boolean;<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.BrowsingContextPrintResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     data: string;\n   }\n   ```";
            };
        };
    };
    readonly "browsingContext.reload": {
        readonly socket: {
            readonly command: "browsingContextReload";
            readonly description: "WebDriver Bidi command to send command method \"browsingContext.reload\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browsingContext-reload";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.BrowsingContextReloadParameters`";
                readonly description: "<pre>\\{<br />  context: BrowsingContextBrowsingContext;<br />  ignoreCache?: boolean;<br />  wait?: BrowsingContextReadinessState;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "browsingContext.setViewport": {
        readonly socket: {
            readonly command: "browsingContextSetViewport";
            readonly description: "WebDriver Bidi command to send command method \"browsingContext.setViewport\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browsingContext-setViewport";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.BrowsingContextSetViewportParameters`";
                readonly description: "<pre>\\{<br />  context?: BrowsingContextBrowsingContext;<br />  viewport?: BrowsingContextViewport &#124; null;<br />  devicePixelRatio?: number &#124; null;<br />  userContexts?: BrowserUserContext[];<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "browsingContext.traverseHistory": {
        readonly socket: {
            readonly command: "browsingContextTraverseHistory";
            readonly description: "WebDriver Bidi command to send command method \"browsingContext.traverseHistory\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-browsingContext-traverseHistory";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.BrowsingContextTraverseHistoryParameters`";
                readonly description: "<pre>\\{<br />  context: BrowsingContextBrowsingContext;<br />  delta: JsInt;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "emulation.setGeolocationOverride": {
        readonly socket: {
            readonly command: "emulationSetGeolocationOverride";
            readonly description: "WebDriver Bidi command to send command method \"emulation.setGeolocationOverride\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-emulation-setGeolocationOverride";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.EmulationSetGeolocationOverrideParameters`";
                readonly description: "<pre>\\\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "network.addIntercept": {
        readonly socket: {
            readonly command: "networkAddIntercept";
            readonly description: "WebDriver Bidi command to send command method \"network.addIntercept\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-network-addIntercept";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.NetworkAddInterceptParameters`";
                readonly description: "<pre>\\{<br />  phases: NetworkInterceptPhase[];<br />  contexts?: BrowsingContextBrowsingContext[];<br />  urlPatterns?: NetworkUrlPattern[];<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.NetworkAddInterceptResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     intercept: NetworkIntercept;\n   }\n   ```";
            };
        };
    };
    readonly "network.continueRequest": {
        readonly socket: {
            readonly command: "networkContinueRequest";
            readonly description: "WebDriver Bidi command to send command method \"network.continueRequest\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-network-continueRequest";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.NetworkContinueRequestParameters`";
                readonly description: "<pre>\\{<br />  request: NetworkRequest;<br />  body?: NetworkBytesValue;<br />  cookies?: NetworkCookieHeader[];<br />  headers?: NetworkHeader[];<br />  method?: string;<br />  url?: string;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "network.continueResponse": {
        readonly socket: {
            readonly command: "networkContinueResponse";
            readonly description: "WebDriver Bidi command to send command method \"network.continueResponse\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-network-continueResponse";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.NetworkContinueResponseParameters`";
                readonly description: "<pre>\\{<br />  request: NetworkRequest;<br />  cookies?: NetworkSetCookieHeader[];<br />  credentials?: NetworkAuthCredentials;<br />  headers?: NetworkHeader[];<br />  reasonPhrase?: string;<br />  statusCode?: JsUint;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "network.continueWithAuth": {
        readonly socket: {
            readonly command: "networkContinueWithAuth";
            readonly description: "WebDriver Bidi command to send command method \"network.continueWithAuth\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-network-continueWithAuth";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.NetworkContinueWithAuthParameters`";
                readonly description: "<pre>\\{<br />  request: NetworkRequest;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "network.failRequest": {
        readonly socket: {
            readonly command: "networkFailRequest";
            readonly description: "WebDriver Bidi command to send command method \"network.failRequest\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-network-failRequest";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.NetworkFailRequestParameters`";
                readonly description: "<pre>\\{<br />  request: NetworkRequest;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "network.provideResponse": {
        readonly socket: {
            readonly command: "networkProvideResponse";
            readonly description: "WebDriver Bidi command to send command method \"network.provideResponse\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-network-provideResponse";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.NetworkProvideResponseParameters`";
                readonly description: "<pre>\\{<br />  request: NetworkRequest;<br />  body?: NetworkBytesValue;<br />  cookies?: NetworkSetCookieHeader[];<br />  headers?: NetworkHeader[];<br />  reasonPhrase?: string;<br />  statusCode?: JsUint;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "network.removeIntercept": {
        readonly socket: {
            readonly command: "networkRemoveIntercept";
            readonly description: "WebDriver Bidi command to send command method \"network.removeIntercept\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-network-removeIntercept";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.NetworkRemoveInterceptParameters`";
                readonly description: "<pre>\\{<br />  intercept: NetworkIntercept;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "network.setCacheBehavior": {
        readonly socket: {
            readonly command: "networkSetCacheBehavior";
            readonly description: "WebDriver Bidi command to send command method \"network.setCacheBehavior\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-network-setCacheBehavior";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.NetworkSetCacheBehaviorParameters`";
                readonly description: "<pre>\\{<br />  cacheBehavior: \"default\" &#124; \"bypass\";<br />  contexts?: BrowsingContextBrowsingContext[];<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "script.addPreloadScript": {
        readonly socket: {
            readonly command: "scriptAddPreloadScript";
            readonly description: "WebDriver Bidi command to send command method \"script.addPreloadScript\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-script-addPreloadScript";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.ScriptAddPreloadScriptParameters`";
                readonly description: "<pre>\\{<br />  functionDeclaration: string;<br />  arguments?: ScriptChannelValue[];<br />  contexts?: BrowsingContextBrowsingContext[];<br />  userContexts?: BrowserUserContext[];<br />  sandbox?: string;<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.ScriptAddPreloadScriptResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     script: ScriptPreloadScript;\n   }\n   ```";
            };
        };
    };
    readonly "script.disown": {
        readonly socket: {
            readonly command: "scriptDisown";
            readonly description: "WebDriver Bidi command to send command method \"script.disown\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-script-disown";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.ScriptDisownParameters`";
                readonly description: "<pre>\\{<br />  handles: ScriptHandle[];<br />  target: ScriptTarget;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "script.callFunction": {
        readonly socket: {
            readonly command: "scriptCallFunction";
            readonly description: "WebDriver Bidi command to send command method \"script.callFunction\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-script-callFunction";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.ScriptCallFunctionParameters`";
                readonly description: "<pre>\\{<br />  functionDeclaration: string;<br />  awaitPromise: boolean;<br />  target: ScriptTarget;<br />  arguments?: ScriptLocalValue[];<br />  resultOwnership?: ScriptResultOwnership;<br />  serializationOptions?: ScriptSerializationOptions;<br />  this?: ScriptLocalValue;<br />  userActivation?: boolean;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "script.evaluate": {
        readonly socket: {
            readonly command: "scriptEvaluate";
            readonly description: "WebDriver Bidi command to send command method \"script.evaluate\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-script-evaluate";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.ScriptEvaluateParameters`";
                readonly description: "<pre>\\{<br />  expression: string;<br />  target: ScriptTarget;<br />  awaitPromise: boolean;<br />  resultOwnership?: ScriptResultOwnership;<br />  serializationOptions?: ScriptSerializationOptions;<br />  userActivation?: boolean;<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.ScriptEvaluateResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   ;\n   ```";
            };
        };
    };
    readonly "script.getRealms": {
        readonly socket: {
            readonly command: "scriptGetRealms";
            readonly description: "WebDriver Bidi command to send command method \"script.getRealms\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-script-getRealms";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.ScriptGetRealmsParameters`";
                readonly description: "<pre>\\{<br />  context?: BrowsingContextBrowsingContext;<br />  type?: ScriptRealmType;<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.ScriptGetRealmsResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     realms: ScriptRealmInfo[];\n   }\n   ```";
            };
        };
    };
    readonly "script.removePreloadScript": {
        readonly socket: {
            readonly command: "scriptRemovePreloadScript";
            readonly description: "WebDriver Bidi command to send command method \"script.removePreloadScript\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-script-removePreloadScript";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.ScriptRemovePreloadScriptParameters`";
                readonly description: "<pre>\\{<br />  script: ScriptPreloadScript;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "storage.getCookies": {
        readonly socket: {
            readonly command: "storageGetCookies";
            readonly description: "WebDriver Bidi command to send command method \"storage.getCookies\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-storage-getCookies";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.StorageGetCookiesParameters`";
                readonly description: "<pre>\\{<br />  filter?: StorageCookieFilter;<br />  partition?: StoragePartitionDescriptor;<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.StorageGetCookiesResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     cookies: NetworkCookie[];\n     partitionKey: StoragePartitionKey;\n   }\n   ```";
            };
        };
    };
    readonly "storage.setCookie": {
        readonly socket: {
            readonly command: "storageSetCookie";
            readonly description: "WebDriver Bidi command to send command method \"storage.setCookie\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-storage-setCookie";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.StorageSetCookieParameters`";
                readonly description: "<pre>\\{<br />  cookie: StoragePartialCookie;<br />  partition?: StoragePartitionDescriptor;<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.StorageSetCookieResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     partitionKey: StoragePartitionKey;\n   }\n   ```";
            };
        };
    };
    readonly "storage.deleteCookies": {
        readonly socket: {
            readonly command: "storageDeleteCookies";
            readonly description: "WebDriver Bidi command to send command method \"storage.deleteCookies\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-storage-deleteCookies";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.StorageDeleteCookiesParameters`";
                readonly description: "<pre>\\{<br />  filter?: StorageCookieFilter;<br />  partition?: StoragePartitionDescriptor;<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.StorageDeleteCookiesResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     partitionKey: StoragePartitionKey;\n   }\n   ```";
            };
        };
    };
    readonly "input.performActions": {
        readonly socket: {
            readonly command: "inputPerformActions";
            readonly description: "WebDriver Bidi command to send command method \"input.performActions\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-input-performActions";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.InputPerformActionsParameters`";
                readonly description: "<pre>\\{<br />  context: BrowsingContextBrowsingContext;<br />  actions: InputSourceActions[];<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "input.releaseActions": {
        readonly socket: {
            readonly command: "inputReleaseActions";
            readonly description: "WebDriver Bidi command to send command method \"input.releaseActions\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-input-releaseActions";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.InputReleaseActionsParameters`";
                readonly description: "<pre>\\{<br />  context: BrowsingContextBrowsingContext;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "input.setFiles": {
        readonly socket: {
            readonly command: "inputSetFiles";
            readonly description: "WebDriver Bidi command to send command method \"input.setFiles\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-input-setFiles";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.InputSetFilesParameters`";
                readonly description: "<pre>\\{<br />  context: BrowsingContextBrowsingContext;<br />  element: ScriptSharedReference;<br />  files: string[];<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
    readonly "webExtension.install": {
        readonly socket: {
            readonly command: "webExtensionInstall";
            readonly description: "WebDriver Bidi command to send command method \"webExtension.install\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-webExtension-install";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.WebExtensionInstallParameters`";
                readonly description: "<pre>\\{<br />  extensionData: WebExtensionExtensionData;<br />\\}</pre>";
                readonly required: true;
            }];
            readonly returns: {
                readonly type: "Object";
                readonly name: "local.WebExtensionInstallResult";
                readonly description: "Command return value with the following interface:\n   ```ts\n   {\n     extension: WebExtensionExtension;\n   }\n   ```";
            };
        };
    };
    readonly "webExtension.uninstall": {
        readonly socket: {
            readonly command: "webExtensionUninstall";
            readonly description: "WebDriver Bidi command to send command method \"webExtension.uninstall\" with parameters.";
            readonly ref: "https://w3c.github.io/webdriver-bidi/#command-webExtension-uninstall";
            readonly parameters: readonly [{
                readonly name: "params";
                readonly type: "`remote.WebExtensionUninstallParameters`";
                readonly description: "<pre>\\{<br />  extension: WebExtensionExtension;<br />\\}</pre>";
                readonly required: true;
            }];
        };
    };
};
export default protocol;
//# sourceMappingURL=webdriverBidi.d.ts.map