import type { HookStats, TestStats, SuiteStats, CommandArgs } from '@wdio/reporter';
import type { Options } from '@wdio/types';
import type { AllureGroup, AllureStep, AllureTest, ExecutableItemWrapper, FixtureResult, Label, TestResult } from 'allure-js-commons';
import { Status as AllureStatus } from 'allure-js-commons';
import CompoundError from './compoundError.js';
/**
 * Get allure test status by TestStat object
 * @param test {Object} - TestStat object
 * @param config {Object} - wdio config object
 * @private
 */
export declare const getTestStatus: (test: TestStats | HookStats, config?: Options.Testrunner) => AllureStatus;
/**
 * Check is object is empty
 * @param object {Object}
 * @private
 */
export declare const isEmpty: (object: object) => boolean;
/**
 * Is mocha/jasmine beforeEach hook
 * @param title {String} - hook title
 * @returns {boolean}
 * @private
 */
export declare const isBeforeEachTypeHook: (title: string) => boolean;
/**
 * Is mocha/jasmine beforeAll / beforeEach hook
 * @param title {String} - hook title
 * @returns {boolean}
 * @private
 */
export declare const isBeforeTypeHook: (title: string) => boolean;
/**
 * Is mocha/jasmine beforeEach / afterEach hook
 * @param title {String} - hook title
 * @returns {boolean}
 * @private
 */
export declare const isEachTypeHooks: (title: string) => boolean;
/**
 * Is mocha/jasmine beforeAll / afterAll hook
 * @param title {String} - hook title
 * @returns {boolean}
 * @private
 */
export declare const isAllTypeHooks: (title: string) => boolean;
/**
 * Properly format error from different test runners
 * @param {object} test - TestStat object
 * @returns {Object} - error object
 * @private
 */
export declare const getErrorFromFailedTest: (test: TestStats | HookStats) => Error | CompoundError | undefined;
/**
 * Update the hook information with the new one, it could be use when a hook ends
 * @param {HookStats} newHookStats - New information that will be applied to current hook info
 * @param {ExecutableItemWrapper} hookElement - hook element registered in the report
 * @param {AllureStep} hookRootStep - root hook step
 *
 * @private
 */
export declare const getHookStatus: (newHookStats: HookStats, hookElement: ExecutableItemWrapper, hookRootStep: AllureStep) => void;
export declare const cleanCucumberHooks: (hook: FixtureResult | TestResult) => void;
/**
 * Substitute task id to link template
 * @param {string} template - link template
 * @param {string} id - task id
 * @returns {string} - link after substitution
 * @private
 */
export declare const getLinkByTemplate: (template: string | undefined, id: string) => string;
export declare const findLast: <T>(arr: Array<T>, predicate: (el: T) => boolean) => T | undefined;
export declare const isScreenshotCommand: (command: CommandArgs) => boolean;
export declare const getSuiteLabels: ({ tags }: SuiteStats) => Label[];
export declare const setAllureIds: (test: AllureTest | undefined, suite: AllureGroup | undefined) => void;
//# sourceMappingURL=utils.d.ts.map