import type { SuiteStats, HookStats, RunnerStats, TestStats, BeforeCommandArgs, AfterCommandArgs } from '@wdio/reporter';
import WDIOReporter from '@wdio/reporter';
import type { MetadataMessage } from 'allure-js-commons';
import { AllureGroup, AllureTest, Status as AllureStatus, Stage, ContentType, AllureStep } from 'allure-js-commons';
import { addFeature, addLink, addOwner, addEpic, addSuite, addSubSuite, addParentSuite, addTag, addLabel, addSeverity, addIssue, addTestId, addStory, addAllureId, addDescription, addAttachment, startStep, endStep, addStep, addArgument, step } from './common/api.js';
import { AllureReporterState } from './state.js';
import type { AddAttachmentEventArgs, AddDescriptionEventArgs, AddFeatureEventArgs, AddIssueEventArgs, AddLabelEventArgs, AddSeverityEventArgs, AddEpicEventArgs, AddOwnerEventArgs, AddParentSuiteEventArgs, AddSubSuiteEventArgs, AddLinkEventArgs, AddAllureIdEventArgs, AddSuiteEventArgs, AddTagEventArgs, AddStoryEventArgs, AddTestIdEventArgs, AllureReporterOptions } from './types.js';
export default class AllureReporter extends WDIOReporter {
    private _allure;
    private _capabilities;
    private _isMultiremote?;
    private _config?;
    private _options;
    private _consoleOutput;
    private _originalStdoutWrite;
    _state: AllureReporterState;
    _runningUnits: Array<AllureGroup | AllureTest | AllureStep>;
    constructor(options?: AllureReporterOptions);
    attachLogs(): void;
    attachFile(name: string, content: string | Buffer, contentType: ContentType): void;
    attachJSON(name: string, json: unknown): void;
    attachScreenshot(name: string, content: Buffer): void;
    _startSuite(suiteTitle: string): void;
    _endSuite(): void;
    _startTest(testTitle: string, cid?: string): void;
    _skipTest(): void;
    _endTest(status: AllureStatus, error?: Error, stage?: Stage): void;
    _startStep(testTitle: string): void;
    setTestParameters(cid?: string): void;
    registerListeners(): void;
    onRunnerStart(runner: RunnerStats): void;
    onSuiteStart(suite: SuiteStats): void;
    onSuiteEnd(suite: SuiteStats): void;
    onTestStart(test: TestStats | HookStats): void;
    onTestPass(): void;
    onTestRetry(test: TestStats): void;
    onTestFail(test: TestStats | HookStats): void;
    onTestSkip(test: TestStats): void;
    onBeforeCommand(command: BeforeCommandArgs): void;
    onAfterCommand(command: AfterCommandArgs): void;
    onHookStart(hook: HookStats): void;
    onHookEnd(hook: HookStats): void;
    addLabel({ name, value }: AddLabelEventArgs): void;
    addLink({ name, url, type, }: AddLinkEventArgs): void;
    addAllureId({ id, }: AddAllureIdEventArgs): void;
    addStory({ storyName }: AddStoryEventArgs): void;
    addFeature({ featureName }: AddFeatureEventArgs): void;
    addSeverity({ severity }: AddSeverityEventArgs): void;
    addEpic({ epicName, }: AddEpicEventArgs): void;
    addOwner({ owner, }: AddOwnerEventArgs): void;
    addSuite({ suiteName, }: AddSuiteEventArgs): void;
    addParentSuite({ suiteName, }: AddParentSuiteEventArgs): void;
    addSubSuite({ suiteName, }: AddSubSuiteEventArgs): void;
    addTag({ tag, }: AddTagEventArgs): void;
    addTestId({ testId, linkName, }: AddTestIdEventArgs): void;
    addIssue({ issue, linkName, }: AddIssueEventArgs): void;
    addDescription({ description, descriptionType }: AddDescriptionEventArgs): void;
    addAttachment({ name, content, type }: AddAttachmentEventArgs): void;
    startStep(title: string): void;
    endStep(status: AllureStatus): void;
    addStep({ step }: {
        step: {
            title: string;
            attachment: {
                name: string;
                content: string;
                type: ContentType;
            };
            status: AllureStatus;
        };
    }): void;
    addArgument({ name, value }: {
        name: string;
        value: string;
    }): void;
    addAllureStep(metadata: MetadataMessage): void;
    /**
     * public API attached to the reporter
     * deprecated approach and only here for backwards compatibility
     */
    static addFeature: typeof addFeature;
    static addLink: typeof addLink;
    static addEpic: typeof addEpic;
    static addOwner: typeof addOwner;
    static addTag: typeof addTag;
    static addLabel: typeof addLabel;
    static addSeverity: typeof addSeverity;
    static addIssue: typeof addIssue;
    static addSuite: typeof addSuite;
    static addSubSuite: typeof addSubSuite;
    static addParentSuite: typeof addParentSuite;
    static addTestId: typeof addTestId;
    static addStory: typeof addStory;
    static addDescription: typeof addDescription;
    static addAttachment: typeof addAttachment;
    static startStep: typeof startStep;
    static endStep: typeof endStep;
    static addStep: typeof addStep;
    static addArgument: typeof addArgument;
    static addAllureId: typeof addAllureId;
    static step: typeof step;
}
//# sourceMappingURL=reporter.d.ts.map