const __importMetaUrl = require('url').pathToFileURL(__filename).href;
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/common/api.ts
var api_exports = {};
__export(api_exports, {
  addAllureId: () => addAllureId,
  addArgument: () => addArgument,
  addAttachment: () => addAttachment,
  addDescription: () => addDescription,
  addEnvironment: () => addEnvironment,
  addEpic: () => addEpic,
  addFeature: () => addFeature,
  addIssue: () => addIssue,
  addLabel: () => addLabel,
  addLink: () => addLink,
  addOwner: () => addOwner,
  addParentSuite: () => addParentSuite,
  addSeverity: () => addSeverity,
  addStep: () => addStep,
  addStory: () => addStory,
  addSubSuite: () => addSubSuite,
  addSuite: () => addSuite,
  addTag: () => addTag,
  addTestId: () => addTestId,
  default: () => api_default,
  endStep: () => endStep,
  startStep: () => startStep,
  step: () => step
});
module.exports = __toCommonJS(api_exports);
var import_allure_js_commons = require("allure-js-commons");

// src/constants.ts
var events = {
  addLabel: "allure:addLabel",
  addLink: "allure:addLink",
  addFeature: "allure:addFeature",
  addStory: "allure:addStory",
  addEpic: "allure:addEpic",
  addSuite: "allure:addSuite",
  addSubSuite: "allure:addSubSuite",
  addParentSuite: "allure:addParentSuite",
  addOwner: "allure:addOwner",
  addSeverity: "allure:addSeverity",
  addTag: "allure:addTag",
  addIssue: "allure:addIssue",
  addAllureId: "allure:addAllureId",
  addTestId: "allure:addTestId",
  addDescription: "allure:addDescription",
  addAttachment: "allure:addAttachment",
  startStep: "allure:startStep",
  endStep: "allure:endStep",
  addStep: "allure:addStep",
  addArgument: "allure:addArgument",
  addAllureStep: "allure:addAllureStep"
};

// src/common/api.ts
var tellReporter = (event, msg = {}) => {
  process.emit(event, msg);
};
function addLabel(name, value) {
  tellReporter(events.addLabel, { name, value });
}
function addLink(url, name, type) {
  tellReporter(events.addLink, { url, name, type });
}
function addAllureId(id) {
  tellReporter(events.addAllureId, { id });
}
function addFeature(featureName) {
  tellReporter(events.addFeature, { featureName });
}
function addSeverity(severity) {
  tellReporter(events.addSeverity, { severity });
}
function addIssue(issue) {
  tellReporter(events.addIssue, { issue });
}
function addTestId(testId) {
  tellReporter(events.addTestId, { testId });
}
function addStory(storyName) {
  tellReporter(events.addStory, { storyName });
}
function addSuite(suiteName) {
  tellReporter(events.addSuite, { suiteName });
}
function addParentSuite(suiteName) {
  tellReporter(events.addParentSuite, { suiteName });
}
function addSubSuite(suiteName) {
  tellReporter(events.addSubSuite, { suiteName });
}
function addEpic(epicName) {
  tellReporter(events.addEpic, { epicName });
}
function addOwner(owner) {
  tellReporter(events.addOwner, { owner });
}
function addTag(tag) {
  tellReporter(events.addTag, { tag });
}
function addEnvironment(name, value) {
  console.warn("\u26A0\uFE0F addEnvironment is deprecated and has no longer any functionality. Use reportedEnvironmentVars in wdio config instead. Read more in https://webdriver.io/docs/allure-reporter.");
}
function addDescription(description, descriptionType) {
  tellReporter(events.addDescription, { description, descriptionType });
}
function addAttachment(name, content, type) {
  if (!type) {
    type = content instanceof Buffer ? "image/png" : typeof content === "string" ? "text/plain" : "application/json";
  }
  tellReporter(events.addAttachment, { name, content, type });
}
function startStep(title) {
  tellReporter(events.startStep, title);
}
function endStep(status = import_allure_js_commons.Status.PASSED) {
  if (!Object.values(import_allure_js_commons.Status).includes(status)) {
    throw new Error(`Step status must be ${Object.values(import_allure_js_commons.Status).join(" or ")}. You tried to set "${status}"`);
  }
  tellReporter(events.endStep, status);
}
function addStep(title, {
  content,
  name = "attachment",
  type = "text/plain"
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
} = {}, status = import_allure_js_commons.Status.PASSED) {
  if (!Object.values(import_allure_js_commons.Status).includes(status)) {
    throw new Error(`Step status must be ${Object.values(import_allure_js_commons.Status).join(" or ")}. You tried to set "${status}"`);
  }
  const step2 = content ? { title, attachment: { content, name, type }, status } : { title, status };
  tellReporter(events.addStep, { step: step2 });
}
function addArgument(name, value) {
  tellReporter(events.addArgument, { name, value });
}
async function step(name, body) {
  const runningStep = new import_allure_js_commons.AllureCommandStepExecutable(name);
  await runningStep.run(body, async (message) => tellReporter(events.addAllureStep, message));
}
var api_default = {
  addLabel,
  addLink,
  addAllureId,
  addFeature,
  addSeverity,
  addIssue,
  addTestId,
  addStory,
  addSuite,
  addParentSuite,
  addSubSuite,
  addEpic,
  addOwner,
  addTag,
  addEnvironment,
  addDescription,
  addAttachment,
  startStep,
  endStep,
  addStep,
  addArgument,
  step
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  addAllureId,
  addArgument,
  addAttachment,
  addDescription,
  addEnvironment,
  addEpic,
  addFeature,
  addIssue,
  addLabel,
  addLink,
  addOwner,
  addParentSuite,
  addSeverity,
  addStep,
  addStory,
  addSubSuite,
  addSuite,
  addTag,
  addTestId,
  endStep,
  startStep,
  step
});
