import type { StepBodyFunction } from 'allure-js-commons';
import { Status } from 'allure-js-commons';
/**
 * Assign label to test
 * @name addLabel
 * @param {string} name - label name
 * @param {string} value - label value
 */
export declare function addLabel(name: string, value: string): void;
/**
 * Assign link to test
 * @name addLink
 * @param {string} url - link name
 * @param {string} [name] - link name
 * @param {string} [type] - link type
 */
export declare function addLink(url: string, name?: string, type?: string): void;
/**
 * Assign allure id label to test to link test to existing entity inside the test ops
 * @name addAllureId
 * @param {string} id - inner allure test ops id
 */
export declare function addAllureId(id: string): void;
/**
 * Assign feature to test
 * @name addFeature
 * @param {(string)} featureName - feature name or an array of names
 */
export declare function addFeature(featureName: string): void;
/**
 * Assign severity to test
 * @name addSeverity
 * @param {string} severity - severity value
 */
export declare function addSeverity(severity: string): void;
/**
 * Assign issue id to test
 * @name addIssue
 * @param {string} issue - issue id value
 */
export declare function addIssue(issue: string): void;
/**
 * Assign TMS test id to test
 * @name addTestId
 * @param {string} testId - test id value
 */
export declare function addTestId(testId: string): void;
/**
 * Assign story label to test
 * @name addStory
 * @param {string} storyName - story name for test
 */
export declare function addStory(storyName: string): void;
/**
 * Assign suite label to test
 * @name addSuite
 * @param {string} suiteName - story name for test
 */
export declare function addSuite(suiteName: string): void;
/**
 * Assign parent suite label to test
 * @name addParentSuite
 * @param {string} suiteName - suite name
 */
export declare function addParentSuite(suiteName: string): void;
/**
 * Assign sub-suite label to test
 * @name addSubSuite
 * @param {string} suiteName - sub-suite name
 */
export declare function addSubSuite(suiteName: string): void;
/**
 * Assign epic label to test
 * @name addEpic
 * @param {string} epicName - the epic name
 */
export declare function addEpic(epicName: string): void;
/**
 * Assign owner label to test
 * @name addOwner
 * @param {string} owner - the owner name
 */
export declare function addOwner(owner: string): void;
/**
 * Assign tag label to test
 * @name addTag
 * @param {string} tag - the tag name
 */
export declare function addTag(tag: string): void;
/**
 * Add environment value
 * @name addEnvironment
 * @deprecated addEnvironment is deprecated. Use reportedEnvironmentVars in config instead.
 */
export declare function addEnvironment(name: string, value: string): void;
/**
 * Assign test description to test
 * @name addDescription
 * @param {string} description - description for test
 * @param {string} descriptionType - description type 'text'\'html'\'markdown'
 */
export declare function addDescription(description: string, descriptionType: string): void;
/**
 * Add attachment
 * @name addAttachment
 * @param {string} name         - attachment file name
 * @param {*} content           - attachment content
 * @param {string=} mimeType    - attachment mime type
 */
export declare function addAttachment(name: string, content: string | Buffer | object, type: string): void;
/**
 * Start allure step
 * @name startStep
 * @param {string} title - step name in report
 */
export declare function startStep(title: string): void;
/**
 * End current allure step
 * @name endStep
 * @param {StepStatus} [status='passed'] - step status
 */
export declare function endStep(status?: Status): void;
/**
 * Create allure step
 * @name addStep
 * @param {string} title - step name in report
 * @param {object} [attachmentObject={}] - attachment for step
 * @param {string} attachmentObject.content - attachment content
 * @param {string} [attachmentObject.name='attachment'] - attachment name
 * @param {string} [attachmentObject.type='text/plain'] - attachment type
 * @param {string} [status='passed'] - step status
 */
export declare function addStep(title: string, { content, name, type }?: any, status?: Status): void;
/**
 * Add additional argument to test
 * @name addArgument
 * @param {string} name - argument name
 * @param {string} value - argument value
 */
export declare function addArgument(name: string, value: string): void;
/**
 * Starts allure step execution with any content
 * Can be used to generate any hierarchy of steps
 * @param {string} name - the step name
 * @param {StepBodyFunction} body - the step content function
 */
export declare function step(name: string, body: StepBodyFunction): Promise<void>;
declare const _default: {
    addLabel: typeof addLabel;
    addLink: typeof addLink;
    addAllureId: typeof addAllureId;
    addFeature: typeof addFeature;
    addSeverity: typeof addSeverity;
    addIssue: typeof addIssue;
    addTestId: typeof addTestId;
    addStory: typeof addStory;
    addSuite: typeof addSuite;
    addParentSuite: typeof addParentSuite;
    addSubSuite: typeof addSubSuite;
    addEpic: typeof addEpic;
    addOwner: typeof addOwner;
    addTag: typeof addTag;
    addEnvironment: typeof addEnvironment;
    addDescription: typeof addDescription;
    addAttachment: typeof addAttachment;
    startStep: typeof startStep;
    endStep: typeof endStep;
    addStep: typeof addStep;
    addArgument: typeof addArgument;
    step: typeof step;
};
export default _default;
//# sourceMappingURL=api.d.ts.map