/*
  Human
  homepage: <https://github.com/vladmandic/human>
  author: <https://github.com/vladmandic>'
*/

var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __export = (target, all2) => {
  for (var name in all2)
    __defProp(target, name, { get: all2[name], enumerable: true });
};
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var __accessCheck = (obj, member, msg) => {
  if (!member.has(obj))
    throw TypeError("Cannot " + msg);
};
var __privateGet = (obj, member, getter) => {
  __accessCheck(obj, member, "read from private field");
  return getter ? getter.call(obj) : member.get(obj);
};
var __privateAdd = (obj, member, value) => {
  if (member.has(obj))
    throw TypeError("Cannot add the same private member more than once");
  member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
};
var __privateSet = (obj, member, value, setter) => {
  __accessCheck(obj, member, "write to private field");
  setter ? setter.call(obj, value) : member.set(obj, value);
  return value;
};

// src/util/util.ts
function log(...msg) {
  const dt2 = new Date();
  const ts2 = `${dt2.getHours().toString().padStart(2, "0")}:${dt2.getMinutes().toString().padStart(2, "0")}:${dt2.getSeconds().toString().padStart(2, "0")}.${dt2.getMilliseconds().toString().padStart(3, "0")}`;
  if (msg)
    console.log(ts2, "Human:", ...msg);
}
function join(folder, file) {
  const separator = folder.endsWith("/") ? "" : "/";
  const skipJoin = file.startsWith(".") || file.startsWith("/") || file.startsWith("http:") || file.startsWith("https:") || file.startsWith("file:");
  const path = skipJoin ? `${file}` : `${folder}${separator}${file}`;
  if (!path.toLocaleLowerCase().includes(".json"))
    throw new Error(`modelpath error: expecting json file: ${path}`);
  return path;
}
var now = () => {
  if (typeof performance !== "undefined")
    return performance.now();
  return parseInt((Number(process.hrtime.bigint()) / 1e3 / 1e3).toString());
};
function validate(defaults, config3, parent = "config", msgs = []) {
  for (const key of Object.keys(config3)) {
    if (typeof config3[key] === "object") {
      validate(defaults[key], config3[key], key, msgs);
    } else {
      const defined = defaults && typeof defaults[key] !== "undefined";
      if (!defined)
        msgs.push({ reason: "unknown property", where: `${parent}.${key} = ${config3[key]}` });
      const same = defaults && typeof defaults[key] === typeof config3[key];
      if (defined && !same)
        msgs.push({ reason: "property type mismatch", where: `${parent}.${key} = ${config3[key]}`, expected: typeof defaults[key] });
    }
  }
  if (config3.debug && parent === "config" && msgs.length > 0)
    log("invalid configuration", msgs);
  return msgs;
}
function mergeDeep(...objects) {
  const isObject = (obj) => obj && typeof obj === "object";
  return objects.reduce((prev, obj) => {
    Object.keys(obj || {}).forEach((key) => {
      const pVal = prev[key];
      const oVal = obj[key];
      if (Array.isArray(pVal) && Array.isArray(oVal))
        prev[key] = pVal.concat(...oVal);
      else if (isObject(pVal) && isObject(oVal))
        prev[key] = mergeDeep(pVal, oVal);
      else
        prev[key] = oVal;
    });
    return prev;
  }, {});
}

// src/config.ts
var config = {
  backend: "",
  modelBasePath: "",
  cacheModels: true,
  wasmPath: "",
  wasmPlatformFetch: false,
  debug: true,
  async: true,
  warmup: "full",
  cacheSensitivity: 0.7,
  skipAllowed: false,
  deallocate: false,
  filter: {
    enabled: true,
    equalization: false,
    width: 0,
    height: 0,
    flip: false,
    return: true,
    brightness: 0,
    contrast: 0,
    sharpness: 0,
    blur: 0,
    saturation: 0,
    hue: 0,
    negative: false,
    sepia: false,
    vintage: false,
    kodachrome: false,
    technicolor: false,
    polaroid: false,
    pixelate: 0
  },
  gesture: {
    enabled: true
  },
  face: {
    enabled: true,
    detector: {
      modelPath: "blazeface.json",
      rotation: true,
      maxDetected: 1,
      skipFrames: 99,
      skipTime: 2500,
      minConfidence: 0.2,
      iouThreshold: 0.1,
      mask: false,
      return: false
    },
    mesh: {
      enabled: true,
      modelPath: "facemesh.json"
    },
    iris: {
      enabled: true,
      modelPath: "iris.json"
    },
    emotion: {
      enabled: true,
      minConfidence: 0.1,
      skipFrames: 99,
      skipTime: 1500,
      modelPath: "emotion.json"
    },
    description: {
      enabled: true,
      modelPath: "faceres.json",
      skipFrames: 99,
      skipTime: 3e3,
      minConfidence: 0.1
    },
    antispoof: {
      enabled: false,
      skipFrames: 99,
      skipTime: 4e3,
      modelPath: "antispoof.json"
    },
    liveness: {
      enabled: false,
      skipFrames: 99,
      skipTime: 4e3,
      modelPath: "liveness.json"
    }
  },
  body: {
    enabled: true,
    modelPath: "movenet-lightning.json",
    maxDetected: -1,
    minConfidence: 0.3,
    skipFrames: 1,
    skipTime: 200
  },
  hand: {
    enabled: true,
    rotation: true,
    skipFrames: 99,
    skipTime: 1e3,
    minConfidence: 0.5,
    iouThreshold: 0.2,
    maxDetected: -1,
    landmarks: true,
    detector: {
      modelPath: "handtrack.json"
    },
    skeleton: {
      modelPath: "handlandmark-full.json"
    }
  },
  object: {
    enabled: false,
    modelPath: "mb3-centernet.json",
    minConfidence: 0.2,
    iouThreshold: 0.4,
    maxDetected: 10,
    skipFrames: 99,
    skipTime: 2e3
  },
  segmentation: {
    enabled: false,
    modelPath: "selfie.json",
    blur: 8
  }
};

// dist/tfjs.esm.js
var tfjs_esm_exports = {};
__export(tfjs_esm_exports, {
  Abs: () => io,
  Acos: () => sl,
  Acosh: () => rl,
  AdadeltaOptimizer: () => fb,
  AdagradOptimizer: () => mb,
  AdamOptimizer: () => gb,
  AdamaxOptimizer: () => bb,
  Add: () => Ir,
  AddN: () => ka,
  All: () => al,
  Any: () => il,
  ArgMax: () => Ia,
  ArgMin: () => ol,
  Asin: () => ul,
  Asinh: () => ll,
  Atan: () => cl,
  Atan2: () => pl,
  Atanh: () => dl,
  AvgPool: () => Sa,
  AvgPool3D: () => qd,
  AvgPool3DGrad: () => og,
  AvgPoolGrad: () => ig,
  BackendWasm: () => kde,
  BatchMatMul: () => Ca,
  BatchToSpaceND: () => oo,
  Bincount: () => ug,
  BroadcastArgs: () => lg,
  BroadcastTo: () => A$,
  Callback: () => CW,
  CallbackList: () => zL,
  Cast: () => Na,
  Ceil: () => Ta,
  ClipByValue: () => Sr,
  Complex: () => jd,
  ComplexAbs: () => Kd,
  Concat: () => uo,
  Conv2D: () => $a,
  Conv2DBackpropFilter: () => cg,
  Conv2DBackpropInput: () => _a,
  Conv3D: () => Xd,
  Conv3DBackpropFilterV2: () => dg,
  Conv3DBackpropInputV2: () => pg,
  Cos: () => Aa,
  Cosh: () => Ea,
  CropAndResize: () => co,
  Cumprod: () => hl,
  Cumsum: () => lo,
  CustomCallback: () => BL,
  DataStorage: () => Ud,
  DenseBincount: () => hg,
  DepthToSpace: () => po,
  DepthwiseConv2dNative: () => Ra,
  DepthwiseConv2dNativeBackpropFilter: () => fg,
  DepthwiseConv2dNativeBackpropInput: () => mg,
  Diag: () => gg,
  Dilation2D: () => Yd,
  Dilation2DBackpropFilter: () => Qf,
  Dilation2DBackpropInput: () => Yf,
  ENV: () => Jw,
  EarlyStopping: () => NW,
  Einsum: () => Qd,
  Elu: () => Fa,
  EluGrad: () => bg,
  Environment: () => S$,
  Equal: () => ho,
  Erf: () => fl,
  Exp: () => Oa,
  ExpandDims: () => fo,
  Expm1: () => mo,
  FFT: () => yg,
  Fill: () => ml,
  FlipLeftRight: () => go,
  Floor: () => Pa,
  FloorDiv: () => za,
  FromPixels: () => fd,
  FusedBatchNorm: () => Ma,
  FusedConv2D: () => aa,
  FusedDepthwiseConv2D: () => ia,
  GPGPUContext: () => Kf,
  GatherNd: () => yo,
  GatherV2: () => bo,
  GraphModel: () => E4,
  Greater: () => vo,
  GreaterEqual: () => La,
  History: () => LL,
  IFFT: () => vg,
  Identity: () => Ba,
  Imag: () => Zd,
  InputSpec: () => Dt,
  IsFinite: () => gl,
  IsInf: () => bl,
  IsNan: () => yl,
  KernelBackend: () => nl,
  LRN: () => ep,
  LRNGrad: () => wg,
  LayerVariable: () => AL,
  LayersModel: () => pr,
  LeakyRelu: () => Va,
  Less: () => xo,
  LessEqual: () => wo,
  LinSpace: () => xg,
  Log: () => Wa,
  Log1p: () => vl,
  LogSoftmax: () => E$,
  LogicalAnd: () => ko,
  LogicalNot: () => xl,
  LogicalOr: () => Jd,
  MathBackendCPU: () => L0,
  MathBackendWebGL: () => M1,
  Max: () => Ua,
  MaxPool: () => Ha,
  MaxPool3D: () => tp,
  MaxPool3DGrad: () => Ig,
  MaxPoolGrad: () => kg,
  MaxPoolWithArgmax: () => Sg,
  Maximum: () => Ga,
  Mean: () => qa,
  Min: () => ja,
  Minimum: () => Ka,
  MirrorPad: () => Xa,
  Mod: () => wl,
  MomentumOptimizer: () => yb,
  Multinomial: () => Cg,
  Multiply: () => Ya,
  Neg: () => Io,
  NonMaxSuppressionV3: () => Co,
  NonMaxSuppressionV4: () => kl,
  NonMaxSuppressionV5: () => No,
  NotEqual: () => So,
  OP_SCOPE_SUFFIX: () => l_,
  OneHot: () => $o,
  OnesLike: () => To,
  Optimizer: () => _r,
  OptimizerConstructors: () => Wr,
  Pack: () => _o,
  PadV2: () => Qa,
  Pool: () => $de,
  Pow: () => Za,
  Prelu: () => Ja,
  Prod: () => Ao,
  RMSPropOptimizer: () => vb,
  RNN: () => Ar,
  Range: () => Il,
  Rank: () => e_,
  Real: () => np,
  RealDiv: () => Da,
  Reciprocal: () => Sl,
  Reduction: () => oO,
  Relu: () => ei,
  Relu6: () => ni,
  Reshape: () => Eo,
  ResizeBilinear: () => ti,
  ResizeBilinearGrad: () => Tg,
  ResizeNearestNeighbor: () => Cl,
  ResizeNearestNeighborGrad: () => Ng,
  Reverse: () => Ro,
  RotateWithOffset: () => qo,
  Round: () => Do,
  Rsqrt: () => si,
  SGDOptimizer: () => Ip,
  ScatterNd: () => Fo,
  Select: () => Oo,
  Selu: () => Nl,
  Sequential: () => Ub,
  Sigmoid: () => ai,
  Sign: () => Tl,
  Sin: () => ri,
  Sinh: () => zo,
  Slice: () => Po,
  Softmax: () => ui,
  Softplus: () => $l,
  SpaceToBatchND: () => Mo,
  SparseFillEmptyRows: () => sp,
  SparseReshape: () => _l,
  SparseSegmentMean: () => rp,
  SparseSegmentSum: () => ap,
  SparseToDense: () => ip,
  SplitV: () => Lo,
  Sqrt: () => ii,
  Square: () => Al,
  SquaredDifference: () => li,
  Step: () => hi,
  StridedSlice: () => Bo,
  StringNGrams: () => op,
  StringSplit: () => $g,
  StringToHashBucketFast: () => _g,
  Sub: () => ci,
  Sum: () => oi,
  SymbolicTensor: () => $s,
  Tan: () => Vo,
  Tanh: () => di,
  Tensor: () => et,
  TensorBuffer: () => Vt,
  Tile: () => Cr,
  TopK: () => Wo,
  Transform: () => Uo,
  Transpose: () => pi,
  Unique: () => Ag,
  Unpack: () => Go,
  UnsortedSegmentSum: () => up,
  Variable: () => gd,
  ZerosLike: () => Ho,
  _FusedMatMul: () => ra,
  abs: () => Mt,
  acos: () => GA,
  acosh: () => qA,
  add: () => ie,
  addN: () => KA,
  all: () => qk,
  any: () => pm,
  argMax: () => Hu,
  argMin: () => JA,
  asin: () => tE,
  asinh: () => sE,
  atan: () => aE,
  atan2: () => oE,
  atanh: () => lE,
  avgPool: () => Gg,
  avgPool3d: () => Yk,
  backend: () => zA,
  backend_util: () => S,
  basicLSTMCell: () => qde,
  batchNorm: () => ju,
  batchNorm2d: () => $E,
  batchNorm3d: () => AE,
  batchNorm4d: () => RE,
  batchToSpaceND: () => Hg,
  bincount: () => Qk,
  booleanMaskAsync: () => xpe,
  broadcastArgs: () => OE,
  broadcastTo: () => nd,
  broadcast_util: () => jo,
  browser: () => Nk,
  buffer: () => De,
  callbacks: () => Ape,
  cast: () => ce,
  ceil: () => ME,
  clipByValue: () => Vn,
  clone: () => lr,
  complex: () => oa,
  concat: () => Ft,
  concat1d: () => VE,
  concat2d: () => UE,
  concat3d: () => HE,
  concat4d: () => jE,
  constraints: () => MM,
  conv1d: () => Zk,
  conv2d: () => ca,
  conv2dTranspose: () => Jk,
  conv3d: () => eI,
  conv3dTranspose: () => tR,
  copyRegisteredKernels: () => Ede,
  cos: () => jg,
  cosh: () => nI,
  cosineWindow: () => TI,
  cumprod: () => aR,
  cumsum: () => sI,
  customGrad: () => js,
  data: () => R4,
  denseBincount: () => uR,
  deprecationWarn: () => Gk,
  depthToSpace: () => cR,
  depthwiseConv2d: () => hp,
  deregisterOp: () => Rpe,
  device_util: () => dp,
  diag: () => jde,
  dilation2d: () => fR,
  disableDeprecationWarnings: () => Ode,
  dispose: () => Re,
  disposeVariables: () => Pde,
  div: () => xe,
  divNoNan: () => vR,
  dot: () => Kde,
  dropout: () => nF,
  einsum: () => kR,
  elu: () => fp,
  enableDebugMode: () => Fde,
  enableProdMode: () => Dde,
  enclosingPowerOfTwo: () => sF,
  engine: () => Ss,
  env: () => X,
  equal: () => Kn,
  erf: () => CR,
  exp: () => Xn,
  expandDims: () => Pn,
  expm1: () => _R,
  eye: () => rI,
  fft: () => lb,
  fill: () => Pl,
  findBackend: () => Ude,
  findBackendFactory: () => Gde,
  floor: () => mp,
  floorDiv: () => Hk,
  forceHalfFloat: () => GX,
  fused: () => ha,
  gather: () => Ku,
  gatherND: () => J3,
  gather_util: () => $k,
  getBackend: () => Vde,
  getGradient: () => nx,
  getKernel: () => Zf,
  getKernelsForBackend: () => Jf,
  getThreadsCount: () => Wpe,
  gpgpu_util: () => RK,
  grad: () => Qde,
  grads: () => Zde,
  greater: () => Wn,
  greaterEqual: () => Ko,
  ifft: () => Id,
  imag: () => Kg,
  image: () => qn,
  inTopKAsync: () => kpe,
  initializers: () => qM,
  input: () => OB,
  io: () => En,
  irfft: () => xI,
  isFinite: () => Xde,
  isInf: () => Yde,
  isNaN: () => BR,
  keep: () => Ht,
  kernel_impls: () => xs,
  layers: () => $L,
  leakyRelu: () => Xg,
  less: () => aI,
  lessEqual: () => Xo,
  linalg: () => VO,
  linspace: () => GR,
  loadGraphModel: () => Dpe,
  loadLayersModel: () => $pe,
  localResponseNormalization: () => qR,
  log: () => Yn,
  log1p: () => Yg,
  logSigmoid: () => tpe,
  logSoftmax: () => iI,
  logSumExp: () => iD,
  logicalAnd: () => Ds,
  logicalNot: () => Jg,
  logicalOr: () => cI,
  logicalXor: () => npe,
  losses: () => Cpe,
  matMul: () => We,
  math: () => iA,
  max: () => As,
  maxPool: () => eb,
  maxPool3d: () => dI,
  maxPoolWithArgmax: () => fD,
  maximum: () => $r,
  mean: () => St,
  memory: () => dm,
  meshgrid: () => spe,
  metrics: () => rW,
  min: () => fm,
  minimum: () => bp,
  mirrorPad: () => xD,
  mod: () => kD,
  model: () => Npe,
  models: () => xW,
  moments: () => tb,
  movingAverage: () => wpe,
  mul: () => V,
  multiRNNCell: () => rpe,
  multinomial: () => TD,
  neg: () => kt,
  nextFrame: () => OI,
  norm: () => CI,
  notEqual: () => Xu,
  oneHot: () => vd,
  ones: () => Mn,
  onesLike: () => Qn,
  op: () => L,
  outerProduct: () => ape,
  pad: () => fi,
  pad1d: () => ipe,
  pad2d: () => ope,
  pad3d: () => upe,
  pad4d: () => lpe,
  pool: () => cpe,
  pow: () => pa,
  prelu: () => sb,
  print: () => U_,
  prod: () => pI,
  profile: () => zde,
  rand: () => dpe,
  randomGamma: () => ppe,
  randomNormal: () => KD,
  randomUniform: () => Ml,
  range: () => Yu,
  ready: () => Bde,
  real: () => wd,
  reciprocal: () => ZD,
  registerBackend: () => pp,
  registerCallbackConstructor: () => _pe,
  registerGradient: () => D$,
  registerKernel: () => El,
  registerOp: () => Epe,
  regularizers: () => wW,
  relu: () => Xs,
  relu6: () => hI,
  removeBackend: () => Wde,
  reshape: () => G,
  reverse: () => Zn,
  reverse1d: () => hpe,
  reverse2d: () => fpe,
  reverse3d: () => mpe,
  reverse4d: () => gpe,
  rfft: () => cb,
  round: () => fI,
  rsqrt: () => mI,
  scalar: () => we,
  scatterND: () => X3,
  scatter_util: () => Ak,
  selu: () => gI,
  separableConv2d: () => c3,
  sequential: () => Tpe,
  serialization: () => ae,
  setBackend: () => Lde,
  setPlatform: () => Hde,
  setThreadsCount: () => Vpe,
  setWasmPath: () => Lpe,
  setWasmPaths: () => Bpe,
  setWebGLContext: () => S5,
  setdiff1dAsync: () => p3,
  shared: () => Zy,
  sigmoid: () => qs,
  sign: () => f3,
  signal: () => Spe,
  sin: () => bI,
  sinh: () => yI,
  slice: () => He,
  slice1d: () => ib,
  slice2d: () => vI,
  slice3d: () => ob,
  slice4d: () => kd,
  slice_util: () => wt,
  softmax: () => ub,
  softplus: () => zl,
  spaceToBatchND: () => nb,
  sparse: () => Wc,
  sparseToDense: () => NI,
  spectral: () => Ipe,
  split: () => Bn,
  sqrt: () => dn,
  square: () => ct,
  squaredDifference: () => wI,
  squeeze: () => mr,
  stack: () => Jn,
  step: () => yp,
  stridedSlice: () => D3,
  string: () => Mf,
  sub: () => ge,
  sum: () => ve,
  sumOutType: () => cp,
  tan: () => O3,
  tanh: () => qu,
  tensor: () => fs,
  tensor1d: () => Zt,
  tensor2d: () => Ki,
  tensor3d: () => pA,
  tensor4d: () => bpe,
  tensor5d: () => ype,
  tensor6d: () => vpe,
  tensor_util: () => _s,
  test_util: () => _A,
  tidy: () => j,
  tile: () => ps,
  time: () => Mde,
  topk: () => z3,
  train: () => Pi,
  transpose: () => qe,
  truncatedNormal: () => db,
  unique: () => hx,
  unregisterGradient: () => Ade,
  unregisterKernel: () => _de,
  unsortedSegmentSum: () => V3,
  unstack: () => Fs,
  upcastType: () => cn,
  util: () => w,
  valueAndGrad: () => Jde,
  valueAndGrads: () => epe,
  variable: () => U3,
  variableGrads: () => XR,
  version: () => Gpe,
  version_converter: () => Fpe,
  version_core: () => Rde,
  version_cpu: () => Ope,
  version_layers: () => uS,
  version_wasm: () => Upe,
  version_webgl: () => Ppe,
  webgl: () => zpe,
  webgl_util: () => I5,
  webgpu: () => roe,
  where: () => vn,
  whereAsync: () => II,
  zeros: () => $t,
  zerosLike: () => je
});
var LT = Object.create;
var Vd = Object.defineProperty;
var BT = Object.getOwnPropertyDescriptor;
var Vw = Object.getOwnPropertyNames;
var VT = Object.getPrototypeOf;
var WT = Object.prototype.hasOwnProperty;
var UT = (e) => Vd(e, "__esModule", { value: true });
var zt = (e, t) => function() {
  return t || (0, e[Vw(e)[0]])((t = { exports: {} }).exports, t), t.exports;
};
var Ae = (e, t) => {
  for (var n in t)
    Vd(e, n, { get: t[n], enumerable: true });
};
var GT = (e, t, n, s) => {
  if (t && typeof t == "object" || typeof t == "function")
    for (let r of Vw(t))
      !WT.call(e, r) && (n || r !== "default") && Vd(e, r, { get: () => t[r], enumerable: !(s = BT(t, r)) || s.enumerable });
  return e;
};
var xa = (e, t) => GT(UT(Vd(e != null ? LT(VT(e)) : {}, "default", !t && e && e.__esModule ? { get: () => e.default, enumerable: true } : { value: e, enumerable: true })), e);
var HT = zt({ "src/node_modules/long/src/long.js"(e, t) {
  t.exports = s;
  var n = null;
  try {
    n = new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0, 97, 115, 109, 1, 0, 0, 0, 1, 13, 2, 96, 0, 1, 127, 96, 4, 127, 127, 127, 127, 1, 127, 3, 7, 6, 0, 1, 1, 1, 1, 1, 6, 6, 1, 127, 1, 65, 0, 11, 7, 50, 6, 3, 109, 117, 108, 0, 1, 5, 100, 105, 118, 95, 115, 0, 2, 5, 100, 105, 118, 95, 117, 0, 3, 5, 114, 101, 109, 95, 115, 0, 4, 5, 114, 101, 109, 95, 117, 0, 5, 8, 103, 101, 116, 95, 104, 105, 103, 104, 0, 0, 10, 191, 1, 6, 4, 0, 35, 0, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 126, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 127, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 128, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 129, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 130, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11])), {}).exports;
  } catch (F) {
  }
  function s(F, $, z) {
    this.low = F | 0, this.high = $ | 0, this.unsigned = !!z;
  }
  s.prototype.__isLong__, Object.defineProperty(s.prototype, "__isLong__", { value: true });
  function r(F) {
    return (F && F.__isLong__) === true;
  }
  s.isLong = r;
  var a = {}, i = {};
  function o(F, $) {
    var z, W, q;
    return $ ? (F >>>= 0, (q = 0 <= F && F < 256) && (W = i[F], W) ? W : (z = l(F, (F | 0) < 0 ? -1 : 0, true), q && (i[F] = z), z)) : (F |= 0, (q = -128 <= F && F < 128) && (W = a[F], W) ? W : (z = l(F, F < 0 ? -1 : 0, false), q && (a[F] = z), z));
  }
  s.fromInt = o;
  function u(F, $) {
    if (isNaN(F))
      return $ ? x : v;
    if ($) {
      if (F < 0)
        return x;
      if (F >= g)
        return A;
    } else {
      if (F <= -b)
        return P;
      if (F + 1 >= b)
        return E;
    }
    return F < 0 ? u(-F, $).neg() : l(F % m | 0, F / m | 0, $);
  }
  s.fromNumber = u;
  function l(F, $, z) {
    return new s(F, $, z);
  }
  s.fromBits = l;
  var c = Math.pow;
  function p(F, $, z) {
    if (F.length === 0)
      throw Error("empty string");
    if (F === "NaN" || F === "Infinity" || F === "+Infinity" || F === "-Infinity")
      return v;
    if (typeof $ == "number" ? (z = $, $ = false) : $ = !!$, z = z || 10, z < 2 || 36 < z)
      throw RangeError("radix");
    var W;
    if ((W = F.indexOf("-")) > 0)
      throw Error("interior hyphen");
    if (W === 0)
      return p(F.substring(1), $, z).neg();
    for (var q = u(c(z, 8)), K = v, Y = 0; Y < F.length; Y += 8) {
      var Z = Math.min(8, F.length - Y), te = parseInt(F.substring(Y, Y + Z), z);
      if (Z < 8) {
        var ee = u(c(z, Z));
        K = K.mul(ee).add(u(te));
      } else
        K = K.mul(q), K = K.add(u(te));
    }
    return K.unsigned = $, K;
  }
  s.fromString = p;
  function d(F, $) {
    return typeof F == "number" ? u(F, $) : typeof F == "string" ? p(F, $) : l(F.low, F.high, typeof $ == "boolean" ? $ : F.unsigned);
  }
  s.fromValue = d;
  var h = 1 << 16, f = 1 << 24, m = h * h, g = m * m, b = g / 2, y = o(f), v = o(0);
  s.ZERO = v;
  var x = o(0, true);
  s.UZERO = x;
  var k = o(1);
  s.ONE = k;
  var T = o(1, true);
  s.UONE = T;
  var N = o(-1);
  s.NEG_ONE = N;
  var E = l(-1, 2147483647, false);
  s.MAX_VALUE = E;
  var A = l(-1, -1, true);
  s.MAX_UNSIGNED_VALUE = A;
  var P = l(0, -2147483648, false);
  s.MIN_VALUE = P;
  var R = s.prototype;
  R.toInt = function() {
    return this.unsigned ? this.low >>> 0 : this.low;
  }, R.toNumber = function() {
    return this.unsigned ? (this.high >>> 0) * m + (this.low >>> 0) : this.high * m + (this.low >>> 0);
  }, R.toString = function($) {
    if ($ = $ || 10, $ < 2 || 36 < $)
      throw RangeError("radix");
    if (this.isZero())
      return "0";
    if (this.isNegative())
      if (this.eq(P)) {
        var z = u($), W = this.div(z), q = W.mul(z).sub(this);
        return W.toString($) + q.toInt().toString($);
      } else
        return "-" + this.neg().toString($);
    for (var K = u(c($, 6), this.unsigned), Y = this, Z = ""; ; ) {
      var te = Y.div(K), ee = Y.sub(te.mul(K)).toInt() >>> 0, se = ee.toString($);
      if (Y = te, Y.isZero())
        return se + Z;
      for (; se.length < 6; )
        se = "0" + se;
      Z = "" + se + Z;
    }
  }, R.getHighBits = function() {
    return this.high;
  }, R.getHighBitsUnsigned = function() {
    return this.high >>> 0;
  }, R.getLowBits = function() {
    return this.low;
  }, R.getLowBitsUnsigned = function() {
    return this.low >>> 0;
  }, R.getNumBitsAbs = function() {
    if (this.isNegative())
      return this.eq(P) ? 64 : this.neg().getNumBitsAbs();
    for (var $ = this.high != 0 ? this.high : this.low, z = 31; z > 0 && ($ & 1 << z) == 0; z--)
      ;
    return this.high != 0 ? z + 33 : z + 1;
  }, R.isZero = function() {
    return this.high === 0 && this.low === 0;
  }, R.eqz = R.isZero, R.isNegative = function() {
    return !this.unsigned && this.high < 0;
  }, R.isPositive = function() {
    return this.unsigned || this.high >= 0;
  }, R.isOdd = function() {
    return (this.low & 1) === 1;
  }, R.isEven = function() {
    return (this.low & 1) === 0;
  }, R.equals = function($) {
    return r($) || ($ = d($)), this.unsigned !== $.unsigned && this.high >>> 31 === 1 && $.high >>> 31 === 1 ? false : this.high === $.high && this.low === $.low;
  }, R.eq = R.equals, R.notEquals = function($) {
    return !this.eq($);
  }, R.neq = R.notEquals, R.ne = R.notEquals, R.lessThan = function($) {
    return this.comp($) < 0;
  }, R.lt = R.lessThan, R.lessThanOrEqual = function($) {
    return this.comp($) <= 0;
  }, R.lte = R.lessThanOrEqual, R.le = R.lessThanOrEqual, R.greaterThan = function($) {
    return this.comp($) > 0;
  }, R.gt = R.greaterThan, R.greaterThanOrEqual = function($) {
    return this.comp($) >= 0;
  }, R.gte = R.greaterThanOrEqual, R.ge = R.greaterThanOrEqual, R.compare = function($) {
    if (r($) || ($ = d($)), this.eq($))
      return 0;
    var z = this.isNegative(), W = $.isNegative();
    return z && !W ? -1 : !z && W ? 1 : this.unsigned ? $.high >>> 0 > this.high >>> 0 || $.high === this.high && $.low >>> 0 > this.low >>> 0 ? -1 : 1 : this.sub($).isNegative() ? -1 : 1;
  }, R.comp = R.compare, R.negate = function() {
    return !this.unsigned && this.eq(P) ? P : this.not().add(k);
  }, R.neg = R.negate, R.add = function($) {
    r($) || ($ = d($));
    var z = this.high >>> 16, W = this.high & 65535, q = this.low >>> 16, K = this.low & 65535, Y = $.high >>> 16, Z = $.high & 65535, te = $.low >>> 16, ee = $.low & 65535, se = 0, ne = 0, oe = 0, re = 0;
    return re += K + ee, oe += re >>> 16, re &= 65535, oe += q + te, ne += oe >>> 16, oe &= 65535, ne += W + Z, se += ne >>> 16, ne &= 65535, se += z + Y, se &= 65535, l(oe << 16 | re, se << 16 | ne, this.unsigned);
  }, R.subtract = function($) {
    return r($) || ($ = d($)), this.add($.neg());
  }, R.sub = R.subtract, R.multiply = function($) {
    if (this.isZero())
      return v;
    if (r($) || ($ = d($)), n) {
      var z = n.mul(this.low, this.high, $.low, $.high);
      return l(z, n.get_high(), this.unsigned);
    }
    if ($.isZero())
      return v;
    if (this.eq(P))
      return $.isOdd() ? P : v;
    if ($.eq(P))
      return this.isOdd() ? P : v;
    if (this.isNegative())
      return $.isNegative() ? this.neg().mul($.neg()) : this.neg().mul($).neg();
    if ($.isNegative())
      return this.mul($.neg()).neg();
    if (this.lt(y) && $.lt(y))
      return u(this.toNumber() * $.toNumber(), this.unsigned);
    var W = this.high >>> 16, q = this.high & 65535, K = this.low >>> 16, Y = this.low & 65535, Z = $.high >>> 16, te = $.high & 65535, ee = $.low >>> 16, se = $.low & 65535, ne = 0, oe = 0, re = 0, le = 0;
    return le += Y * se, re += le >>> 16, le &= 65535, re += K * se, oe += re >>> 16, re &= 65535, re += Y * ee, oe += re >>> 16, re &= 65535, oe += q * se, ne += oe >>> 16, oe &= 65535, oe += K * ee, ne += oe >>> 16, oe &= 65535, oe += Y * te, ne += oe >>> 16, oe &= 65535, ne += W * se + q * ee + K * te + Y * Z, ne &= 65535, l(re << 16 | le, ne << 16 | oe, this.unsigned);
  }, R.mul = R.multiply, R.divide = function($) {
    if (r($) || ($ = d($)), $.isZero())
      throw Error("division by zero");
    if (n) {
      if (!this.unsigned && this.high === -2147483648 && $.low === -1 && $.high === -1)
        return this;
      var z = (this.unsigned ? n.div_u : n.div_s)(this.low, this.high, $.low, $.high);
      return l(z, n.get_high(), this.unsigned);
    }
    if (this.isZero())
      return this.unsigned ? x : v;
    var W, q, K;
    if (this.unsigned) {
      if ($.unsigned || ($ = $.toUnsigned()), $.gt(this))
        return x;
      if ($.gt(this.shru(1)))
        return T;
      K = x;
    } else {
      if (this.eq(P)) {
        if ($.eq(k) || $.eq(N))
          return P;
        if ($.eq(P))
          return k;
        var Y = this.shr(1);
        return W = Y.div($).shl(1), W.eq(v) ? $.isNegative() ? k : N : (q = this.sub($.mul(W)), K = W.add(q.div($)), K);
      } else if ($.eq(P))
        return this.unsigned ? x : v;
      if (this.isNegative())
        return $.isNegative() ? this.neg().div($.neg()) : this.neg().div($).neg();
      if ($.isNegative())
        return this.div($.neg()).neg();
      K = v;
    }
    for (q = this; q.gte($); ) {
      W = Math.max(1, Math.floor(q.toNumber() / $.toNumber()));
      for (var Z = Math.ceil(Math.log(W) / Math.LN2), te = Z <= 48 ? 1 : c(2, Z - 48), ee = u(W), se = ee.mul($); se.isNegative() || se.gt(q); )
        W -= te, ee = u(W, this.unsigned), se = ee.mul($);
      ee.isZero() && (ee = k), K = K.add(ee), q = q.sub(se);
    }
    return K;
  }, R.div = R.divide, R.modulo = function($) {
    if (r($) || ($ = d($)), n) {
      var z = (this.unsigned ? n.rem_u : n.rem_s)(this.low, this.high, $.low, $.high);
      return l(z, n.get_high(), this.unsigned);
    }
    return this.sub(this.div($).mul($));
  }, R.mod = R.modulo, R.rem = R.modulo, R.not = function() {
    return l(~this.low, ~this.high, this.unsigned);
  }, R.and = function($) {
    return r($) || ($ = d($)), l(this.low & $.low, this.high & $.high, this.unsigned);
  }, R.or = function($) {
    return r($) || ($ = d($)), l(this.low | $.low, this.high | $.high, this.unsigned);
  }, R.xor = function($) {
    return r($) || ($ = d($)), l(this.low ^ $.low, this.high ^ $.high, this.unsigned);
  }, R.shiftLeft = function($) {
    return r($) && ($ = $.toInt()), ($ &= 63) === 0 ? this : $ < 32 ? l(this.low << $, this.high << $ | this.low >>> 32 - $, this.unsigned) : l(0, this.low << $ - 32, this.unsigned);
  }, R.shl = R.shiftLeft, R.shiftRight = function($) {
    return r($) && ($ = $.toInt()), ($ &= 63) === 0 ? this : $ < 32 ? l(this.low >>> $ | this.high << 32 - $, this.high >> $, this.unsigned) : l(this.high >> $ - 32, this.high >= 0 ? 0 : -1, this.unsigned);
  }, R.shr = R.shiftRight, R.shiftRightUnsigned = function($) {
    if (r($) && ($ = $.toInt()), $ &= 63, $ === 0)
      return this;
    var z = this.high;
    if ($ < 32) {
      var W = this.low;
      return l(W >>> $ | z << 32 - $, z >>> $, this.unsigned);
    } else
      return $ === 32 ? l(z, 0, this.unsigned) : l(z >>> $ - 32, 0, this.unsigned);
  }, R.shru = R.shiftRightUnsigned, R.shr_u = R.shiftRightUnsigned, R.toSigned = function() {
    return this.unsigned ? l(this.low, this.high, false) : this;
  }, R.toUnsigned = function() {
    return this.unsigned ? this : l(this.low, this.high, true);
  }, R.toBytes = function($) {
    return $ ? this.toBytesLE() : this.toBytesBE();
  }, R.toBytesLE = function() {
    var $ = this.high, z = this.low;
    return [z & 255, z >>> 8 & 255, z >>> 16 & 255, z >>> 24, $ & 255, $ >>> 8 & 255, $ >>> 16 & 255, $ >>> 24];
  }, R.toBytesBE = function() {
    var $ = this.high, z = this.low;
    return [$ >>> 24, $ >>> 16 & 255, $ >>> 8 & 255, $ & 255, z >>> 24, z >>> 16 & 255, z >>> 8 & 255, z & 255];
  }, s.fromBytes = function($, z, W) {
    return W ? s.fromBytesLE($, z) : s.fromBytesBE($, z);
  }, s.fromBytesLE = function($, z) {
    return new s($[0] | $[1] << 8 | $[2] << 16 | $[3] << 24, $[4] | $[5] << 8 | $[6] << 16 | $[7] << 24, z);
  }, s.fromBytesBE = function($, z) {
    return new s($[4] << 24 | $[5] << 16 | $[6] << 8 | $[7], $[0] << 24 | $[1] << 16 | $[2] << 8 | $[3], z);
  };
} });
var qT = zt({ "(disabled):src/node_modules/node-fetch/browser.js"() {
} });
var jT = zt({ "(disabled):util"() {
} });
var KT = zt({ "src/node_modules/seedrandom/lib/alea.js"(e, t) {
  (function(n, s, r) {
    function a(l) {
      var c = this, p = u();
      c.next = function() {
        var d = 2091639 * c.s0 + c.c * 23283064365386963e-26;
        return c.s0 = c.s1, c.s1 = c.s2, c.s2 = d - (c.c = d | 0);
      }, c.c = 1, c.s0 = p(" "), c.s1 = p(" "), c.s2 = p(" "), c.s0 -= p(l), c.s0 < 0 && (c.s0 += 1), c.s1 -= p(l), c.s1 < 0 && (c.s1 += 1), c.s2 -= p(l), c.s2 < 0 && (c.s2 += 1), p = null;
    }
    function i(l, c) {
      return c.c = l.c, c.s0 = l.s0, c.s1 = l.s1, c.s2 = l.s2, c;
    }
    function o(l, c) {
      var p = new a(l), d = c && c.state, h = p.next;
      return h.int32 = function() {
        return p.next() * 4294967296 | 0;
      }, h.double = function() {
        return h() + (h() * 2097152 | 0) * 11102230246251565e-32;
      }, h.quick = h, d && (typeof d == "object" && i(d, p), h.state = function() {
        return i(p, {});
      }), h;
    }
    function u() {
      var l = 4022871197, c = function(p) {
        p = String(p);
        for (var d = 0; d < p.length; d++) {
          l += p.charCodeAt(d);
          var h = 0.02519603282416938 * l;
          l = h >>> 0, h -= l, h *= l, l = h >>> 0, h -= l, l += h * 4294967296;
        }
        return (l >>> 0) * 23283064365386963e-26;
      };
      return c;
    }
    s && s.exports ? s.exports = o : r && r.amd ? r(function() {
      return o;
    }) : this.alea = o;
  })(e, typeof t == "object" && t, typeof define == "function" && define);
} });
var XT = zt({ "src/node_modules/seedrandom/lib/xor128.js"(e, t) {
  (function(n, s, r) {
    function a(u) {
      var l = this, c = "";
      l.x = 0, l.y = 0, l.z = 0, l.w = 0, l.next = function() {
        var d = l.x ^ l.x << 11;
        return l.x = l.y, l.y = l.z, l.z = l.w, l.w ^= l.w >>> 19 ^ d ^ d >>> 8;
      }, u === (u | 0) ? l.x = u : c += u;
      for (var p = 0; p < c.length + 64; p++)
        l.x ^= c.charCodeAt(p) | 0, l.next();
    }
    function i(u, l) {
      return l.x = u.x, l.y = u.y, l.z = u.z, l.w = u.w, l;
    }
    function o(u, l) {
      var c = new a(u), p = l && l.state, d = function() {
        return (c.next() >>> 0) / 4294967296;
      };
      return d.double = function() {
        do
          var h = c.next() >>> 11, f = (c.next() >>> 0) / 4294967296, m = (h + f) / (1 << 21);
        while (m === 0);
        return m;
      }, d.int32 = c.next, d.quick = d, p && (typeof p == "object" && i(p, c), d.state = function() {
        return i(c, {});
      }), d;
    }
    s && s.exports ? s.exports = o : r && r.amd ? r(function() {
      return o;
    }) : this.xor128 = o;
  })(e, typeof t == "object" && t, typeof define == "function" && define);
} });
var YT = zt({ "src/node_modules/seedrandom/lib/xorwow.js"(e, t) {
  (function(n, s, r) {
    function a(u) {
      var l = this, c = "";
      l.next = function() {
        var d = l.x ^ l.x >>> 2;
        return l.x = l.y, l.y = l.z, l.z = l.w, l.w = l.v, (l.d = l.d + 362437 | 0) + (l.v = l.v ^ l.v << 4 ^ (d ^ d << 1)) | 0;
      }, l.x = 0, l.y = 0, l.z = 0, l.w = 0, l.v = 0, u === (u | 0) ? l.x = u : c += u;
      for (var p = 0; p < c.length + 64; p++)
        l.x ^= c.charCodeAt(p) | 0, p == c.length && (l.d = l.x << 10 ^ l.x >>> 4), l.next();
    }
    function i(u, l) {
      return l.x = u.x, l.y = u.y, l.z = u.z, l.w = u.w, l.v = u.v, l.d = u.d, l;
    }
    function o(u, l) {
      var c = new a(u), p = l && l.state, d = function() {
        return (c.next() >>> 0) / 4294967296;
      };
      return d.double = function() {
        do
          var h = c.next() >>> 11, f = (c.next() >>> 0) / 4294967296, m = (h + f) / (1 << 21);
        while (m === 0);
        return m;
      }, d.int32 = c.next, d.quick = d, p && (typeof p == "object" && i(p, c), d.state = function() {
        return i(c, {});
      }), d;
    }
    s && s.exports ? s.exports = o : r && r.amd ? r(function() {
      return o;
    }) : this.xorwow = o;
  })(e, typeof t == "object" && t, typeof define == "function" && define);
} });
var QT = zt({ "src/node_modules/seedrandom/lib/xorshift7.js"(e, t) {
  (function(n, s, r) {
    function a(u) {
      var l = this;
      l.next = function() {
        var p = l.x, d = l.i, h, f, m;
        return h = p[d], h ^= h >>> 7, f = h ^ h << 24, h = p[d + 1 & 7], f ^= h ^ h >>> 10, h = p[d + 3 & 7], f ^= h ^ h >>> 3, h = p[d + 4 & 7], f ^= h ^ h << 7, h = p[d + 7 & 7], h = h ^ h << 13, f ^= h ^ h << 9, p[d] = f, l.i = d + 1 & 7, f;
      };
      function c(p, d) {
        var h, f, m = [];
        if (d === (d | 0))
          f = m[0] = d;
        else
          for (d = "" + d, h = 0; h < d.length; ++h)
            m[h & 7] = m[h & 7] << 15 ^ d.charCodeAt(h) + m[h + 1 & 7] << 13;
        for (; m.length < 8; )
          m.push(0);
        for (h = 0; h < 8 && m[h] === 0; ++h)
          ;
        for (h == 8 ? f = m[7] = -1 : f = m[h], p.x = m, p.i = 0, h = 256; h > 0; --h)
          p.next();
      }
      c(l, u);
    }
    function i(u, l) {
      return l.x = u.x.slice(), l.i = u.i, l;
    }
    function o(u, l) {
      u == null && (u = +new Date());
      var c = new a(u), p = l && l.state, d = function() {
        return (c.next() >>> 0) / 4294967296;
      };
      return d.double = function() {
        do
          var h = c.next() >>> 11, f = (c.next() >>> 0) / 4294967296, m = (h + f) / (1 << 21);
        while (m === 0);
        return m;
      }, d.int32 = c.next, d.quick = d, p && (p.x && i(p, c), d.state = function() {
        return i(c, {});
      }), d;
    }
    s && s.exports ? s.exports = o : r && r.amd ? r(function() {
      return o;
    }) : this.xorshift7 = o;
  })(e, typeof t == "object" && t, typeof define == "function" && define);
} });
var ZT = zt({ "src/node_modules/seedrandom/lib/xor4096.js"(e, t) {
  (function(n, s, r) {
    function a(u) {
      var l = this;
      l.next = function() {
        var p = l.w, d = l.X, h = l.i, f, m;
        return l.w = p = p + 1640531527 | 0, m = d[h + 34 & 127], f = d[h = h + 1 & 127], m ^= m << 13, f ^= f << 17, m ^= m >>> 15, f ^= f >>> 12, m = d[h] = m ^ f, l.i = h, m + (p ^ p >>> 16) | 0;
      };
      function c(p, d) {
        var h, f, m, g, b, y = [], v = 128;
        for (d === (d | 0) ? (f = d, d = null) : (d = d + "\0", f = 0, v = Math.max(v, d.length)), m = 0, g = -32; g < v; ++g)
          d && (f ^= d.charCodeAt((g + 32) % d.length)), g === 0 && (b = f), f ^= f << 10, f ^= f >>> 15, f ^= f << 4, f ^= f >>> 13, g >= 0 && (b = b + 1640531527 | 0, h = y[g & 127] ^= f + b, m = h == 0 ? m + 1 : 0);
        for (m >= 128 && (y[(d && d.length || 0) & 127] = -1), m = 127, g = 4 * 128; g > 0; --g)
          f = y[m + 34 & 127], h = y[m = m + 1 & 127], f ^= f << 13, h ^= h << 17, f ^= f >>> 15, h ^= h >>> 12, y[m] = f ^ h;
        p.w = b, p.X = y, p.i = m;
      }
      c(l, u);
    }
    function i(u, l) {
      return l.i = u.i, l.w = u.w, l.X = u.X.slice(), l;
    }
    function o(u, l) {
      u == null && (u = +new Date());
      var c = new a(u), p = l && l.state, d = function() {
        return (c.next() >>> 0) / 4294967296;
      };
      return d.double = function() {
        do
          var h = c.next() >>> 11, f = (c.next() >>> 0) / 4294967296, m = (h + f) / (1 << 21);
        while (m === 0);
        return m;
      }, d.int32 = c.next, d.quick = d, p && (p.X && i(p, c), d.state = function() {
        return i(c, {});
      }), d;
    }
    s && s.exports ? s.exports = o : r && r.amd ? r(function() {
      return o;
    }) : this.xor4096 = o;
  })(e, typeof t == "object" && t, typeof define == "function" && define);
} });
var JT = zt({ "src/node_modules/seedrandom/lib/tychei.js"(e, t) {
  (function(n, s, r) {
    function a(u) {
      var l = this, c = "";
      l.next = function() {
        var d = l.b, h = l.c, f = l.d, m = l.a;
        return d = d << 25 ^ d >>> 7 ^ h, h = h - f | 0, f = f << 24 ^ f >>> 8 ^ m, m = m - d | 0, l.b = d = d << 20 ^ d >>> 12 ^ h, l.c = h = h - f | 0, l.d = f << 16 ^ h >>> 16 ^ m, l.a = m - d | 0;
      }, l.a = 0, l.b = 0, l.c = -1640531527, l.d = 1367130551, u === Math.floor(u) ? (l.a = u / 4294967296 | 0, l.b = u | 0) : c += u;
      for (var p = 0; p < c.length + 20; p++)
        l.b ^= c.charCodeAt(p) | 0, l.next();
    }
    function i(u, l) {
      return l.a = u.a, l.b = u.b, l.c = u.c, l.d = u.d, l;
    }
    function o(u, l) {
      var c = new a(u), p = l && l.state, d = function() {
        return (c.next() >>> 0) / 4294967296;
      };
      return d.double = function() {
        do
          var h = c.next() >>> 11, f = (c.next() >>> 0) / 4294967296, m = (h + f) / (1 << 21);
        while (m === 0);
        return m;
      }, d.int32 = c.next, d.quick = d, p && (typeof p == "object" && i(p, c), d.state = function() {
        return i(c, {});
      }), d;
    }
    s && s.exports ? s.exports = o : r && r.amd ? r(function() {
      return o;
    }) : this.tychei = o;
  })(e, typeof t == "object" && t, typeof define == "function" && define);
} });
var e$ = zt({ "(disabled):crypto"() {
} });
var t$ = zt({ "src/node_modules/seedrandom/seedrandom.js"(e, t) {
  (function(n, s, r) {
    var a = 256, i = 6, o = 52, u = "random", l = r.pow(a, i), c = r.pow(2, o), p = c * 2, d = a - 1, h;
    function f(k, T, N) {
      var E = [];
      T = T == true ? { entropy: true } : T || {};
      var A = y(b(T.entropy ? [k, x(s)] : k == null ? v() : k, 3), E), P = new m(E), R = function() {
        for (var F = P.g(i), $ = l, z = 0; F < c; )
          F = (F + z) * a, $ *= a, z = P.g(1);
        for (; F >= p; )
          F /= 2, $ /= 2, z >>>= 1;
        return (F + z) / $;
      };
      return R.int32 = function() {
        return P.g(4) | 0;
      }, R.quick = function() {
        return P.g(4) / 4294967296;
      }, R.double = R, y(x(P.S), s), (T.pass || N || function(F, $, z, W) {
        return W && (W.S && g(W, P), F.state = function() {
          return g(P, {});
        }), z ? (r[u] = F, $) : F;
      })(R, A, "global" in T ? T.global : this == r, T.state);
    }
    function m(k) {
      var T, N = k.length, E = this, A = 0, P = E.i = E.j = 0, R = E.S = [];
      for (N || (k = [N++]); A < a; )
        R[A] = A++;
      for (A = 0; A < a; A++)
        R[A] = R[P = d & P + k[A % N] + (T = R[A])], R[P] = T;
      (E.g = function(F) {
        for (var $, z = 0, W = E.i, q = E.j, K = E.S; F--; )
          $ = K[W = d & W + 1], z = z * a + K[d & (K[W] = K[q = d & q + $]) + (K[q] = $)];
        return E.i = W, E.j = q, z;
      })(a);
    }
    function g(k, T) {
      return T.i = k.i, T.j = k.j, T.S = k.S.slice(), T;
    }
    function b(k, T) {
      var N = [], E = typeof k, A;
      if (T && E == "object")
        for (A in k)
          try {
            N.push(b(k[A], T - 1));
          } catch (P) {
          }
      return N.length ? N : E == "string" ? k : k + "\0";
    }
    function y(k, T) {
      for (var N = k + "", E, A = 0; A < N.length; )
        T[d & A] = d & (E ^= T[d & A] * 19) + N.charCodeAt(A++);
      return x(T);
    }
    function v() {
      try {
        var k;
        return h && (k = h.randomBytes) ? k = k(a) : (k = new Uint8Array(a), (n.crypto || n.msCrypto).getRandomValues(k)), x(k);
      } catch (E) {
        var T = n.navigator, N = T && T.plugins;
        return [+new Date(), n, N, n.screen, x(s)];
      }
    }
    function x(k) {
      return String.fromCharCode.apply(0, k);
    }
    if (y(r.random(), s), typeof t == "object" && t.exports) {
      t.exports = f;
      try {
        h = e$();
      } catch (k) {
      }
    } else
      typeof define == "function" && define.amd ? define(function() {
        return f;
      }) : r["seed" + u] = f;
  })(typeof self != "undefined" ? self : e, [], Math);
} });
var Wd = zt({ "src/node_modules/seedrandom/index.js"(e, t) {
  var n = KT(), s = XT(), r = YT(), a = QT(), i = ZT(), o = JT(), u = t$();
  u.alea = n, u.xor128 = s, u.xorwow = r, u.xorshift7 = a, u.xor4096 = i, u.tychei = o, t.exports = u;
} });
var Ww = zt({ "(disabled):src/node_modules/string_decoder/index.js"() {
} });
var tg = zt({ "(disabled):fs"() {
} });
var dd = zt({ "(disabled):path"() {
} });
var n$ = zt({ "(disabled):worker_threads"() {
} });
var s$ = zt({ "(disabled):perf_hooks"() {
} });
var r$ = zt({ "(disabled):os"() {
} });
var a$ = zt({ "src/tfjs-backend-wasm/wasm-out/tfjs-backend-wasm-threaded-simd.js"(e, t) {
  var n = (() => {
    var s = typeof document != "undefined" && document.currentScript ? document.currentScript.src : void 0;
    return typeof __filename != "undefined" && (s = s || __filename), function(r) {
      r = r || {};
      function a() {
        return Ce.buffer != nn && rs(Ce.buffer), ic;
      }
      function i() {
        return Ce.buffer != nn && rs(Ce.buffer), oc;
      }
      function o() {
        return Ce.buffer != nn && rs(Ce.buffer), hu;
      }
      function u() {
        return Ce.buffer != nn && rs(Ce.buffer), uc;
      }
      function l() {
        return Ce.buffer != nn && rs(Ce.buffer), lc;
      }
      function c() {
        return Ce.buffer != nn && rs(Ce.buffer), cc;
      }
      function p() {
        return Ce.buffer != nn && rs(Ce.buffer), dc;
      }
      var d = typeof r != "undefined" ? r : {}, h, f;
      d.ready = new Promise(function(C, D) {
        h = C, f = D;
      });
      var m;
      typeof process != "undefined" && process.listeners && (m = { uncaughtException: process.listeners("uncaughtException"), unhandledRejection: process.listeners("unhandledRejection") });
      var g = Object.assign({}, d), b = [], y = "./this.program", v = (C, D) => {
        throw D;
      }, x = typeof window == "object", k = typeof importScripts == "function", T = typeof process == "object" && typeof process.versions == "object" && typeof process.versions.node == "string", N = d.ENVIRONMENT_IS_PTHREAD || false, E = "";
      function A(C) {
        return d.locateFile ? d.locateFile(C, E) : E + C;
      }
      var P, R, F, $;
      function z(C) {
        if (C instanceof ku)
          return;
        ee("exiting due to exception: " + C);
      }
      var W, q, K;
      if (T) {
        k ? E = dd().dirname(E) + "/" : E = __dirname + "/", K = () => {
          q || (W = tg(), q = dd());
        }, P = function(B, Q) {
          return K(), B = q.normalize(B), W.readFileSync(B, Q ? void 0 : "utf8");
        }, F = (D) => {
          var B = P(D, true);
          return B.buffer || (B = new Uint8Array(B)), B;
        }, R = (D, B, Q) => {
          K(), D = q.normalize(D), W.readFile(D, function(ue, pe) {
            ue ? Q(ue) : B(pe.buffer);
          });
        }, process.argv.length > 1 && (y = process.argv[1].replace(/\\/g, "/")), b = process.argv.slice(2), process.on("uncaughtException", function(D) {
          if (!(D instanceof ku))
            throw D;
        }), process.on("unhandledRejection", function(D) {
          throw D;
        }), v = (D, B) => {
          if (Pr())
            throw process.exitCode = D, B;
          z(B), process.exit(D);
        }, d.inspect = function() {
          return "[Emscripten Module object]";
        };
        let C;
        try {
          C = n$();
        } catch (D) {
          throw console.error('The "worker_threads" module is not supported in this node.js build - perhaps a newer version is needed?'), D;
        }
        global.Worker = C.Worker;
      } else
        (x || k) && (k ? E = self.location.href : typeof document != "undefined" && document.currentScript && (E = document.currentScript.src), typeof s != "undefined" && s && (E = s), E.indexOf("blob:") !== 0 ? E = E.substr(0, E.replace(/[?#].*/, "").lastIndexOf("/") + 1) : E = "", T || (P = (C) => {
          var D = new XMLHttpRequest();
          return D.open("GET", C, false), D.send(null), D.responseText;
        }, k && (F = (C) => {
          var D = new XMLHttpRequest();
          return D.open("GET", C, false), D.responseType = "arraybuffer", D.send(null), new Uint8Array(D.response);
        }), R = (C, D, B) => {
          var Q = new XMLHttpRequest();
          Q.open("GET", C, true), Q.responseType = "arraybuffer", Q.onload = () => {
            if (Q.status == 200 || Q.status == 0 && Q.response) {
              D(Q.response);
              return;
            }
            B();
          }, Q.onerror = B, Q.send(null);
        }), $ = (C) => document.title = C);
      T && typeof performance == "undefined" && (global.performance = s$().performance);
      var Y = console.log.bind(console), Z = console.warn.bind(console);
      T && (K(), Y = (C) => W.writeSync(1, C + `
`), Z = (C) => W.writeSync(2, C + `
`));
      var te = d.print || Y, ee = d.printErr || Z;
      Object.assign(d, g), g = null, d.arguments && (b = d.arguments), d.thisProgram && (y = d.thisProgram), d.quit && (v = d.quit);
      var se = 4;
      function ne(C) {
        ne.shown || (ne.shown = {}), ne.shown[C] || (ne.shown[C] = 1, ee(C));
      }
      function oe(C, D) {
        if (typeof WebAssembly.Function == "function") {
          for (var B = { i: "i32", j: "i64", f: "f32", d: "f64" }, Q = { parameters: [], results: D[0] == "v" ? [] : [B[D[0]]] }, ue = 1; ue < D.length; ++ue)
            Q.parameters.push(B[D[ue]]);
          return new WebAssembly.Function(Q, C);
        }
        var pe = [1, 0, 1, 96], ye = D.slice(0, 1), Te = D.slice(1), bt = { i: 127, j: 126, f: 125, d: 124 };
        pe.push(Te.length);
        for (var ue = 0; ue < Te.length; ++ue)
          pe.push(bt[Te[ue]]);
        ye == "v" ? pe.push(0) : pe = pe.concat([1, bt[ye]]), pe[1] = pe.length - 2;
        var us = new Uint8Array([0, 97, 115, 109, 1, 0, 0, 0].concat(pe, [2, 7, 1, 1, 101, 1, 102, 0, 0, 7, 5, 1, 1, 102, 0, 0])), ls = new WebAssembly.Module(us), Bc = new WebAssembly.Instance(ls, { e: { f: C } }), Iu = Bc.exports.f;
        return Iu;
      }
      var re = [], le;
      function me() {
        if (re.length)
          return re.pop();
        try {
          Fn.grow(1);
        } catch (C) {
          throw C instanceof RangeError ? "Unable to grow wasm table. Set ALLOW_TABLE_GROWTH." : C;
        }
        return Fn.length - 1;
      }
      function ke(C, D) {
        for (var B = C; B < C + D; B++) {
          var Q = $i(B);
          Q && le.set(Q, B);
        }
      }
      var Se = 0, Ee = (C) => {
        Se = C;
      }, Pe = Atomics.load, Xe = Atomics.store, Je = Atomics.compareExchange, Ye;
      d.wasmBinary && (Ye = d.wasmBinary);
      var tt = d.noExitRuntime || true;
      typeof WebAssembly != "object" && Ci("no native wasm support detected");
      var Ce, ut, at = false, Jt;
      function Nt(C, D) {
        C || Ci(D);
      }
      function Cn(C) {
        var D = d["_" + C];
        return D;
      }
      function Et(C, D, B, Q, ue) {
        var pe = { string: function($n) {
          var Oi = 0;
          if ($n != null && $n !== 0) {
            var ex = ($n.length << 2) + 1;
            Oi = Fi(ex), Ls($n, Oi, ex);
          }
          return Oi;
        }, array: function($n) {
          var Oi = Fi($n.length);
          return Bs($n, Oi), Oi;
        } };
        function ye($n) {
          return D === "string" ? tn($n) : D === "boolean" ? Boolean($n) : $n;
        }
        var Te = Cn(C), bt = [], us = 0;
        if (Q)
          for (var ls = 0; ls < Q.length; ls++) {
            var Bc = pe[B[ls]];
            Bc ? (us === 0 && (us = Ef()), bt[ls] = Bc(Q[ls])) : bt[ls] = Q[ls];
          }
        var Iu = Te.apply(null, bt);
        function MT($n) {
          return us !== 0 && Pc(us), ye($n);
        }
        return Iu = MT(Iu), Iu;
      }
      function en(C, D, B, Q) {
        B = B || [];
        var ue = B.every(function(ye) {
          return ye === "number";
        }), pe = D !== "string";
        return pe && ue && !Q ? Cn(C) : function() {
          return Et(C, D, B, arguments, Q);
        };
      }
      var Nn = 1;
      function Tn(C) {
        var D = new TextDecoder(C);
        this.decode = (B) => (B.buffer instanceof SharedArrayBuffer && (B = new Uint8Array(B)), D.decode.call(D, B));
      }
      var Yt = typeof TextDecoder != "undefined" ? new Tn("utf8") : void 0;
      function Dn(C, D, B) {
        for (var Q = D + B, ue = D; C[ue] && !(ue >= Q); )
          ++ue;
        if (ue - D > 16 && C.subarray && Yt)
          return Yt.decode(C.subarray(D, ue));
        for (var pe = ""; D < ue; ) {
          var ye = C[D++];
          if (!(ye & 128)) {
            pe += String.fromCharCode(ye);
            continue;
          }
          var Te = C[D++] & 63;
          if ((ye & 224) == 192) {
            pe += String.fromCharCode((ye & 31) << 6 | Te);
            continue;
          }
          var bt = C[D++] & 63;
          if ((ye & 240) == 224 ? ye = (ye & 15) << 12 | Te << 6 | bt : ye = (ye & 7) << 18 | Te << 12 | bt << 6 | C[D++] & 63, ye < 65536)
            pe += String.fromCharCode(ye);
          else {
            var us = ye - 65536;
            pe += String.fromCharCode(55296 | us >> 10, 56320 | us & 1023);
          }
        }
        return pe;
      }
      function tn(C, D) {
        return C ? Dn(i(), C, D) : "";
      }
      function Ms(C, D, B, Q) {
        if (!(Q > 0))
          return 0;
        for (var ue = B, pe = B + Q - 1, ye = 0; ye < C.length; ++ye) {
          var Te = C.charCodeAt(ye);
          if (Te >= 55296 && Te <= 57343) {
            var bt = C.charCodeAt(++ye);
            Te = 65536 + ((Te & 1023) << 10) | bt & 1023;
          }
          if (Te <= 127) {
            if (B >= pe)
              break;
            D[B++] = Te;
          } else if (Te <= 2047) {
            if (B + 1 >= pe)
              break;
            D[B++] = 192 | Te >> 6, D[B++] = 128 | Te & 63;
          } else if (Te <= 65535) {
            if (B + 2 >= pe)
              break;
            D[B++] = 224 | Te >> 12, D[B++] = 128 | Te >> 6 & 63, D[B++] = 128 | Te & 63;
          } else {
            if (B + 3 >= pe)
              break;
            D[B++] = 240 | Te >> 18, D[B++] = 128 | Te >> 12 & 63, D[B++] = 128 | Te >> 6 & 63, D[B++] = 128 | Te & 63;
          }
        }
        return D[B] = 0, B - ue;
      }
      function Ls(C, D, B) {
        return Ms(C, i(), D, B);
      }
      function ki(C) {
        for (var D = 0, B = 0; B < C.length; ++B) {
          var Q = C.charCodeAt(B);
          Q >= 55296 && Q <= 57343 && (Q = 65536 + ((Q & 1023) << 10) | C.charCodeAt(++B) & 1023), Q <= 127 ? ++D : Q <= 2047 ? D += 2 : Q <= 65535 ? D += 3 : D += 4;
        }
        return D;
      }
      var Js = typeof TextDecoder != "undefined" ? new Tn("utf-16le") : void 0;
      function Bs(C, D) {
        a().set(C, D);
      }
      function pu(C, D, B) {
        for (var Q = 0; Q < C.length; ++Q)
          a()[D++ >> 0] = C.charCodeAt(Q);
        B || (a()[D >> 0] = 0);
      }
      function Ii(C, D) {
        return C % D > 0 && (C += D - C % D), C;
      }
      var nn, ic, oc, hu, uc, lc, Fv, cc, dc;
      N && (nn = d.buffer);
      function rs(C) {
        nn = C, d.HEAP8 = ic = new Int8Array(C), d.HEAP16 = hu = new Int16Array(C), d.HEAP32 = lc = new Int32Array(C), d.HEAPU8 = oc = new Uint8Array(C), d.HEAPU16 = uc = new Uint16Array(C), d.HEAPU32 = Fv = new Uint32Array(C), d.HEAPF32 = cc = new Float32Array(C), d.HEAPF64 = dc = new Float64Array(C);
      }
      var pc = d.INITIAL_MEMORY || 16777216;
      if (N)
        Ce = d.wasmMemory, nn = d.buffer;
      else if (d.wasmMemory)
        Ce = d.wasmMemory;
      else if (Ce = new WebAssembly.Memory({ initial: pc / 65536, maximum: 32768, shared: true }), !(Ce.buffer instanceof SharedArrayBuffer))
        throw ee("requested a shared WebAssembly.Memory but the returned buffer is not a SharedArrayBuffer, indicating that while the browser has SharedArrayBuffer it does not have WebAssembly threads support - you may need to set a flag"), T && console.log("(on node you may need: --experimental-wasm-threads --experimental-wasm-bulk-memory and also use a recent version)"), Error("bad memory");
      Ce && (nn = Ce.buffer), pc = nn.byteLength, rs(nn);
      var Fn, Si = [], er = [], th = [], hc = [], Or = false, nh = false, fc = 0;
      function Pr() {
        return tt || fc > 0;
      }
      function sn() {
        if (d.preRun)
          for (typeof d.preRun == "function" && (d.preRun = [d.preRun]); d.preRun.length; )
            Ov(d.preRun.shift());
        vc(Si);
      }
      function fu() {
        Or = true, !N && vc(er);
      }
      function sh() {
        N || ($e.terminateAllThreads(), nh = true);
      }
      function rh() {
        if (!N) {
          if (d.postRun)
            for (typeof d.postRun == "function" && (d.postRun = [d.postRun]); d.postRun.length; )
              mu(d.postRun.shift());
          vc(hc);
        }
      }
      function Ov(C) {
        Si.unshift(C);
      }
      function Pv(C) {
        er.unshift(C);
      }
      function mu(C) {
        hc.unshift(C);
      }
      var tr = 0, mc = null, as = null;
      function gu(C) {
        tr++, d.monitorRunDependencies && d.monitorRunDependencies(tr);
      }
      function zv(C) {
        if (tr--, d.monitorRunDependencies && d.monitorRunDependencies(tr), tr == 0 && (mc !== null && (clearInterval(mc), mc = null), as)) {
          var D = as;
          as = null, D();
        }
      }
      d.preloadedImages = {}, d.preloadedAudios = {};
      function Ci(C) {
        N ? postMessage({ cmd: "onAbort", arg: C }) : d.onAbort && d.onAbort(C), C = "Aborted(" + C + ")", ee(C), at = true, Jt = 1, C += ". Build with -s ASSERTIONS=1 for more info.";
        var D = new WebAssembly.RuntimeError(C);
        throw f(D), D;
      }
      var ah = "data:application/octet-stream;base64,";
      function gc(C) {
        return C.startsWith(ah);
      }
      function bc(C) {
        return C.startsWith("file://");
      }
      var rn;
      rn = "tfjs-backend-wasm-threaded-simd.wasm", gc(rn) || (rn = A(rn));
      function yc(C) {
        try {
          if (C == rn && Ye)
            return new Uint8Array(Ye);
          if (F)
            return F(C);
          throw "both async and sync fetching of the wasm failed";
        } catch (D) {
          Ci(D);
        }
      }
      function Ni() {
        if (!Ye && (x || k)) {
          if (typeof fetch == "function" && !bc(rn))
            return fetch(rn, { credentials: "same-origin" }).then(function(C) {
              if (!C.ok)
                throw "failed to load wasm binary file at '" + rn + "'";
              return C.arrayBuffer();
            }).catch(function() {
              return yc(rn);
            });
          if (R)
            return new Promise(function(C, D) {
              R(rn, function(B) {
                C(new Uint8Array(B));
              }, D);
            });
        }
        return Promise.resolve().then(function() {
          return yc(rn);
        });
      }
      function ih() {
        var C = { env: Ec, wasi_snapshot_preview1: Ec };
        function D(ye, Te) {
          var bt = ye.exports;
          if (d.asm = bt, hh(d.asm.emscripten_tls_init), Fn = d.asm.__indirect_function_table, Pv(d.asm.__wasm_call_ctors), ut = Te, !N) {
            var us = $e.unusedWorkers.length;
            $e.unusedWorkers.forEach(function(ls) {
              $e.loadWasmModuleToWorker(ls, function() {
                --us || zv("wasm-instantiate");
              });
            });
          }
        }
        N || gu("wasm-instantiate");
        function B(ye) {
          D(ye.instance, ye.module);
        }
        function Q(ye) {
          return Ni().then(function(Te) {
            return WebAssembly.instantiate(Te, C);
          }).then(function(Te) {
            return Te;
          }).then(ye, function(Te) {
            ee("failed to asynchronously prepare wasm: " + Te), Ci(Te);
          });
        }
        function ue() {
          return !Ye && typeof WebAssembly.instantiateStreaming == "function" && !gc(rn) && !bc(rn) && typeof fetch == "function" ? fetch(rn, { credentials: "same-origin" }).then(function(ye) {
            var Te = WebAssembly.instantiateStreaming(ye, C);
            return Te.then(B, function(bt) {
              return ee("wasm streaming compile failed: " + bt), ee("falling back to ArrayBuffer instantiation"), Q(B);
            });
          }) : Q(B);
        }
        if (d.instantiateWasm)
          try {
            var pe = d.instantiateWasm(C, D);
            return pe;
          } catch (ye) {
            return ee("Module.instantiateWasm callback failed with error: " + ye), false;
          }
        return ue().catch(f), {};
      }
      var Mv, Lv, oh = {};
      function vc(C) {
        for (; C.length > 0; ) {
          var D = C.shift();
          if (typeof D == "function") {
            D(d);
            continue;
          }
          var B = D.func;
          typeof B == "number" ? D.arg === void 0 ? $i(B)() : $i(B)(D.arg) : B(D.arg === void 0 ? null : D.arg);
        }
      }
      function Ti(C) {
        var D = Ef(), B = C();
        return Pc(D), B;
      }
      function qN(C) {
        return C;
      }
      function Bv(C) {
        var D = /\b_Z[\w\d_]+/g;
        return C.replace(D, function(B) {
          var Q = B;
          return B === Q ? B : Q + " [" + B + "]";
        });
      }
      function uh(C) {
        l()[C >> 2] = 0;
        var D = $e.pthreads[C];
        delete $e.pthreads[C], D.worker.terminate(), Af(C), $e.runningWorkers.splice($e.runningWorkers.indexOf(D.worker), 1), D.worker.pthread = void 0;
      }
      function lh(C) {
        var D = $e.pthreads[C];
        D.worker.postMessage({ cmd: "cancel" });
      }
      function xc(C) {
        var D = $e.pthreads[C];
        if (D) {
          l()[C >> 2] = 0;
          var B = D.worker;
          $e.returnWorkerToPool(B);
        }
      }
      function wc(C) {
        OT(C);
      }
      function ch(C) {
        if (C instanceof ku || C == "unwind")
          return Jt;
        v(1, C);
      }
      var $e = { unusedWorkers: [], runningWorkers: [], tlsInitFunctions: [], init: function() {
        N ? $e.initWorker() : $e.initMainThread();
      }, initMainThread: function() {
        for (var C = 8, D = 0; D < C; ++D)
          $e.allocateUnusedWorker();
      }, initWorker: function() {
        tt = false;
      }, pthreads: {}, setExitStatus: function(C) {
        Jt = C;
      }, terminateAllThreads: function() {
        for (var C in $e.pthreads) {
          var D = $e.pthreads[C];
          D && D.worker && $e.returnWorkerToPool(D.worker);
        }
        for (var B = 0; B < $e.unusedWorkers.length; ++B) {
          var Q = $e.unusedWorkers[B];
          Q.terminate();
        }
        $e.unusedWorkers = [];
      }, returnWorkerToPool: function(C) {
        $e.runWithoutMainThreadQueuedCalls(function() {
          delete $e.pthreads[C.pthread.threadInfoStruct], $e.unusedWorkers.push(C), $e.runningWorkers.splice($e.runningWorkers.indexOf(C), 1), Af(C.pthread.threadInfoStruct), C.pthread = void 0;
        });
      }, runWithoutMainThreadQueuedCalls: function(C) {
        l()[Jv >> 2] = 0;
        try {
          C();
        } finally {
          l()[Jv >> 2] = 1;
        }
      }, receiveObjectTransfer: function(C) {
      }, threadInit: function() {
        for (var C in $e.tlsInitFunctions)
          $e.tlsInitFunctions[C]();
      }, loadWasmModuleToWorker: function(C, D) {
        C.onmessage = (B) => {
          var Q = B.data, ue = Q.cmd;
          if (C.pthread && ($e.currentProxiedOperationCallerThread = C.pthread.threadInfoStruct), Q.targetThread && Q.targetThread != Oc()) {
            var pe = $e.pthreads[Q.targetThread];
            pe ? pe.worker.postMessage(Q, Q.transferList) : ee('Internal error! Worker sent a message "' + ue + '" to target pthread ' + Q.targetThread + ", but that thread no longer exists!"), $e.currentProxiedOperationCallerThread = void 0;
            return;
          }
          ue === "processQueuedMainThreadWork" ? Kv() : ue === "spawnThread" ? Ic(Q) : ue === "cleanupThread" ? xc(Q.thread) : ue === "killThread" ? uh(Q.thread) : ue === "cancelThread" ? lh(Q.thread) : ue === "loaded" ? (C.loaded = true, D && D(C), C.runPthread && (C.runPthread(), delete C.runPthread)) : ue === "print" ? te("Thread " + Q.threadId + ": " + Q.text) : ue === "printErr" ? ee("Thread " + Q.threadId + ": " + Q.text) : ue === "alert" ? alert("Thread " + Q.threadId + ": " + Q.text) : Q.target === "setimmediate" ? C.postMessage(Q) : ue === "onAbort" ? d.onAbort && d.onAbort(Q.arg) : ee("worker sent an unknown command " + ue), $e.currentProxiedOperationCallerThread = void 0;
        }, C.onerror = (B) => {
          var Q = "worker sent an error!";
          throw ee(Q + " " + B.filename + ":" + B.lineno + ": " + B.message), B;
        }, T && (C.on("message", function(B) {
          C.onmessage({ data: B });
        }), C.on("error", function(B) {
          C.onerror(B);
        }), C.on("detachedExit", function() {
        })), C.postMessage({ cmd: "load", urlOrBlob: d.mainScriptUrlOrBlob || s, wasmMemory: Ce, wasmModule: ut });
      }, allocateUnusedWorker: function() {
        var C = A("tfjs-backend-wasm-threaded-simd.worker.js");
        $e.unusedWorkers.push(new Worker(C));
      }, getNewWorker: function() {
        return $e.unusedWorkers.length == 0 && ($e.allocateUnusedWorker(), $e.loadWasmModuleToWorker($e.unusedWorkers[0])), $e.unusedWorkers.pop();
      } };
      function dh() {
        var C = Oc(), D = l()[C + 44 >> 2], B = l()[C + 48 >> 2], Q = D - B;
        Zv(D, Q), Pc(D);
      }
      d.establishStackSpace = dh;
      function kc(C) {
        if (N)
          return Lr(1, 0, C);
        try {
          wc(C);
        } catch (D) {
          ch(D);
        }
      }
      var zr = [];
      function $i(C) {
        var D = zr[C];
        return D || (C >= zr.length && (zr.length = C + 1), zr[C] = D = Fn.get(C)), D;
      }
      function ph(C, D) {
        return $i(C)(D);
      }
      d.invokeEntryPoint = ph;
      function Vv() {
        var C = new Error();
        if (!C.stack) {
          try {
            throw new Error();
          } catch (D) {
            C = D;
          }
          if (!C.stack)
            return "(no stack trace available)";
        }
        return C.stack.toString();
      }
      function hh(C, D, B) {
        $e.tlsInitFunctions.push(C);
      }
      function Wv(C, D) {
        Fn.set(C, D), zr[C] = D;
      }
      var Mr;
      T ? Mr = () => {
        var C = process.hrtime();
        return C[0] * 1e3 + C[1] / 1e6;
      } : N ? Mr = () => performance.now() - d.__performance_now_clock_drift : Mr = () => performance.now();
      var fh = true;
      function mh(C) {
        return l()[jv() >> 2] = C, C;
      }
      function gh(C, D) {
        var B;
        if (C === 0)
          B = Date.now();
        else if ((C === 1 || C === 4) && fh)
          B = Mr();
        else
          return mh(28), -1;
        return l()[D >> 2] = B / 1e3 | 0, l()[D + 4 >> 2] = B % 1e3 * 1e3 * 1e3 | 0, 0;
      }
      function bh(C, D) {
        return gh(C, D);
      }
      function yh(C) {
        Xv(C, !k, 1, !x), $e.threadInit();
      }
      function vh(C) {
        N ? postMessage({ cmd: "cleanupThread", thread: C }) : xc(C);
      }
      function Ic(C) {
        var D = $e.getNewWorker();
        if (!D)
          return 6;
        $e.runningWorkers.push(D);
        var B = $e.pthreads[C.pthread_ptr] = { worker: D, threadInfoStruct: C.pthread_ptr };
        D.pthread = B;
        var Q = { cmd: "run", start_routine: C.startRoutine, arg: C.arg, threadInfoStruct: C.pthread_ptr };
        return D.runPthread = () => {
          Q.time = performance.now(), D.postMessage(Q, C.transferList);
        }, D.loaded && (D.runPthread(), delete D.runPthread), 0;
      }
      function xh(C, D, B, Q) {
        if (typeof SharedArrayBuffer == "undefined")
          return ee("Current environment does not support SharedArrayBuffer, pthreads are not available!"), 6;
        var ue = [], pe = 0;
        if (N && (ue.length === 0 || pe))
          return Yv(687865856, C, D, B, Q);
        if (pe)
          return pe;
        var ye = { startRoutine: B, pthread_ptr: C, arg: Q, transferList: ue };
        return N ? (ye.cmd = "spawnThread", postMessage(ye, ue), 0) : Ic(ye);
      }
      function wh() {
        return 2097152;
      }
      function kh(C, D) {
        if (C == D)
          postMessage({ cmd: "processQueuedMainThreadWork" });
        else if (N)
          postMessage({ targetThread: C, cmd: "processThreadQueue" });
        else {
          var B = $e.pthreads[C], Q = B && B.worker;
          if (!Q)
            return;
          Q.postMessage({ cmd: "processThreadQueue" });
        }
        return 1;
      }
      function Ih() {
        Ci("");
      }
      function Sh() {
        T || k || ne("Blocking on the main thread is very dangerous, see https://emscripten.org/docs/porting/pthreads.html#blocking-on-the-main-browser-thread");
      }
      function Sc() {
        return 2147483648;
      }
      function Ch(C, D, B) {
        i().copyWithin(C, D, D + B);
      }
      function Nh() {
        return T ? r$().cpus().length : navigator.hardwareConcurrency;
      }
      function Lr(C, D) {
        var B = arguments.length - 2, Q = arguments;
        return Ti(function() {
          for (var ue = B, pe = Fi(ue * 8), ye = pe >> 3, Te = 0; Te < B; Te++) {
            var bt = Q[2 + Te];
            p()[ye + Te] = bt;
          }
          return Qv(C, ue, pe, D);
        });
      }
      var bu = [];
      function Th(C, D, B) {
        bu.length = D;
        for (var Q = B >> 3, ue = 0; ue < D; ue++)
          bu[ue] = p()[Q + ue];
        var pe = C < 0, ye = pe ? oh[-C - 1] : qh[C];
        return ye.apply(null, bu);
      }
      function $h(C) {
        try {
          return Ce.grow(C - nn.byteLength + 65535 >>> 16), rs(Ce.buffer), 1;
        } catch (D) {
        }
      }
      function _h(C) {
        var D = i().length;
        if (C = C >>> 0, C <= D)
          return false;
        var B = Sc();
        if (C > B)
          return false;
        for (var Q = 1; Q <= 4; Q *= 2) {
          var ue = D * (1 + 0.2 / Q);
          ue = Math.min(ue, C + 100663296);
          var pe = Math.min(B, Ii(Math.max(C, ue), 65536)), ye = $h(pe);
          if (ye)
            return true;
        }
        return false;
      }
      var Le = { inEventHandler: 0, removeAllEventListeners: function() {
        for (var C = Le.eventHandlers.length - 1; C >= 0; --C)
          Le._removeHandler(C);
        Le.eventHandlers = [], Le.deferredCalls = [];
      }, registerRemoveEventListeners: function() {
        Le.removeEventListenersRegistered || (th.push(Le.removeAllEventListeners), Le.removeEventListenersRegistered = true);
      }, deferredCalls: [], deferCall: function(C, D, B) {
        function Q(ye, Te) {
          if (ye.length != Te.length)
            return false;
          for (var bt in ye)
            if (ye[bt] != Te[bt])
              return false;
          return true;
        }
        for (var ue in Le.deferredCalls) {
          var pe = Le.deferredCalls[ue];
          if (pe.targetFunction == C && Q(pe.argsList, B))
            return;
        }
        Le.deferredCalls.push({ targetFunction: C, precedence: D, argsList: B }), Le.deferredCalls.sort(function(ye, Te) {
          return ye.precedence < Te.precedence;
        });
      }, removeDeferredCalls: function(C) {
        for (var D = 0; D < Le.deferredCalls.length; ++D)
          Le.deferredCalls[D].targetFunction == C && (Le.deferredCalls.splice(D, 1), --D);
      }, canPerformEventHandlerRequests: function() {
        return Le.inEventHandler && Le.currentEventHandler.allowsDeferredCalls;
      }, runDeferredCalls: function() {
        if (!!Le.canPerformEventHandlerRequests())
          for (var C = 0; C < Le.deferredCalls.length; ++C) {
            var D = Le.deferredCalls[C];
            Le.deferredCalls.splice(C, 1), --C, D.targetFunction.apply(null, D.argsList);
          }
      }, eventHandlers: [], removeAllHandlersOnTarget: function(C, D) {
        for (var B = 0; B < Le.eventHandlers.length; ++B)
          Le.eventHandlers[B].target == C && (!D || D == Le.eventHandlers[B].eventTypeString) && Le._removeHandler(B--);
      }, _removeHandler: function(C) {
        var D = Le.eventHandlers[C];
        D.target.removeEventListener(D.eventTypeString, D.eventListenerFunc, D.useCapture), Le.eventHandlers.splice(C, 1);
      }, registerOrRemoveHandler: function(C) {
        var D = function(ue) {
          ++Le.inEventHandler, Le.currentEventHandler = C, Le.runDeferredCalls(), C.handlerFunc(ue), Le.runDeferredCalls(), --Le.inEventHandler;
        };
        if (C.callbackfunc)
          C.eventListenerFunc = D, C.target.addEventListener(C.eventTypeString, D, C.useCapture), Le.eventHandlers.push(C), Le.registerRemoveEventListeners();
        else
          for (var B = 0; B < Le.eventHandlers.length; ++B)
            Le.eventHandlers[B].target == C.target && Le.eventHandlers[B].eventTypeString == C.eventTypeString && Le._removeHandler(B--);
      }, queueEventHandlerOnThread_iiii: function(C, D, B, Q, ue) {
        Ti(function() {
          var pe = Fi(12);
          l()[pe >> 2] = B, l()[pe + 4 >> 2] = Q, l()[pe + 8 >> 2] = ue, _f(C, 637534208, D, Q, pe);
        });
      }, getTargetThreadForEventCallback: function(C) {
        switch (C) {
          case 1:
            return 0;
          case 2:
            return $e.currentProxiedOperationCallerThread;
          default:
            return C;
        }
      }, getNodeNameForTarget: function(C) {
        return C ? C == window ? "#window" : C == screen ? "#screen" : C && C.nodeName ? C.nodeName : "" : "";
      }, fullscreenEnabled: function() {
        return document.fullscreenEnabled || document.webkitFullscreenEnabled;
      } };
      function Ah(C) {
        var D = ki(C) + 1, B = $f(D);
        return Ls(C, B, D), B;
      }
      function Eh(C, D, B, Q) {
        Ti(function() {
          var ue = Fi(12), pe = 0;
          D && (pe = Ah(D)), l()[ue >> 2] = pe, l()[ue + 4 >> 2] = B, l()[ue + 8 >> 2] = Q, _f(C, 657457152, 0, pe, ue);
        });
      }
      function Rh(C, D, B, Q) {
        D = D ? tn(D) : "", Eh(C, D, B, Q);
      }
      function Dh(C) {
        return C > 2 ? tn(C) : C;
      }
      var Fh = [0, typeof document != "undefined" ? document : 0, typeof window != "undefined" ? window : 0];
      function Oh(C) {
        C = Dh(C);
        var D = Fh[C] || (typeof document != "undefined" ? document.querySelector(C) : void 0);
        return D;
      }
      function yu(C) {
        return Oh(C);
      }
      function Cc(C, D, B) {
        var Q = yu(C);
        if (!Q)
          return -4;
        if (Q.canvasSharedPtr && (l()[Q.canvasSharedPtr >> 2] = D, l()[Q.canvasSharedPtr + 4 >> 2] = B), Q.offscreenCanvas || !Q.controlTransferredOffscreen) {
          Q.offscreenCanvas && (Q = Q.offscreenCanvas);
          var ue = false;
          if (Q.GLctxObject && Q.GLctxObject.GLctx) {
            var pe = Q.GLctxObject.GLctx.getParameter(2978);
            ue = pe[0] === 0 && pe[1] === 0 && pe[2] === Q.width && pe[3] === Q.height;
          }
          Q.width = D, Q.height = B, ue && Q.GLctxObject.GLctx.viewport(0, 0, D, B);
        } else if (Q.canvasSharedPtr) {
          var ye = l()[Q.canvasSharedPtr + 8 >> 2];
          return Rh(ye, C, D, B), 1;
        } else
          return -4;
        return 0;
      }
      function Nc(C, D, B) {
        return N ? Lr(2, 1, C, D, B) : Cc(C, D, B);
      }
      function Ph(C, D, B) {
        var Q = yu(C);
        return Q ? Cc(C, D, B) : Nc(C, D, B);
      }
      function zh() {
        throw "unwind";
      }
      function Mh(C) {
        var D = C.getExtension("ANGLE_instanced_arrays");
        if (D)
          return C.vertexAttribDivisor = function(B, Q) {
            D.vertexAttribDivisorANGLE(B, Q);
          }, C.drawArraysInstanced = function(B, Q, ue, pe) {
            D.drawArraysInstancedANGLE(B, Q, ue, pe);
          }, C.drawElementsInstanced = function(B, Q, ue, pe, ye) {
            D.drawElementsInstancedANGLE(B, Q, ue, pe, ye);
          }, 1;
      }
      function Lh(C) {
        var D = C.getExtension("OES_vertex_array_object");
        if (D)
          return C.createVertexArray = function() {
            return D.createVertexArrayOES();
          }, C.deleteVertexArray = function(B) {
            D.deleteVertexArrayOES(B);
          }, C.bindVertexArray = function(B) {
            D.bindVertexArrayOES(B);
          }, C.isVertexArray = function(B) {
            return D.isVertexArrayOES(B);
          }, 1;
      }
      function Bh(C) {
        var D = C.getExtension("WEBGL_draw_buffers");
        if (D)
          return C.drawBuffers = function(B, Q) {
            D.drawBuffersWEBGL(B, Q);
          }, 1;
      }
      function Vh(C) {
        return !!(C.multiDrawWebgl = C.getExtension("WEBGL_multi_draw"));
      }
      var gt = { counter: 1, buffers: [], programs: [], framebuffers: [], renderbuffers: [], textures: [], shaders: [], vaos: [], contexts: {}, offscreenCanvases: {}, queries: [], stringCache: {}, unpackAlignment: 4, recordError: function(D) {
        gt.lastError || (gt.lastError = D);
      }, getNewId: function(C) {
        for (var D = gt.counter++, B = C.length; B < D; B++)
          C[B] = null;
        return D;
      }, getSource: function(C, D, B, Q) {
        for (var ue = "", pe = 0; pe < D; ++pe) {
          var ye = Q ? l()[Q + pe * 4 >> 2] : -1;
          ue += tn(l()[B + pe * 4 >> 2], ye < 0 ? void 0 : ye);
        }
        return ue;
      }, createContext: function(C, D) {
        C.getContextSafariWebGL2Fixed || (C.getContextSafariWebGL2Fixed = C.getContext, C.getContext = function(ue, pe) {
          var ye = C.getContextSafariWebGL2Fixed(ue, pe);
          return ue == "webgl" == ye instanceof WebGLRenderingContext ? ye : null;
        });
        var B = C.getContext("webgl", D);
        if (!B)
          return 0;
        var Q = gt.registerContext(B, D);
        return Q;
      }, registerContext: function(C, D) {
        var B = $f(8);
        l()[B + 4 >> 2] = Oc();
        var Q = { handle: B, attributes: D, version: D.majorVersion, GLctx: C };
        return C.canvas && (C.canvas.GLctxObject = Q), gt.contexts[B] = Q, (typeof D.enableExtensionsByDefault == "undefined" || D.enableExtensionsByDefault) && gt.initExtensions(Q), B;
      }, makeContextCurrent: function(C) {
        return gt.currentContext = gt.contexts[C], d.ctx = Ac = gt.currentContext && gt.currentContext.GLctx, !(C && !Ac);
      }, getContext: function(C) {
        return gt.contexts[C];
      }, deleteContext: function(C) {
        gt.currentContext === gt.contexts[C] && (gt.currentContext = null), typeof Le == "object" && Le.removeAllHandlersOnTarget(gt.contexts[C].GLctx.canvas), gt.contexts[C] && gt.contexts[C].GLctx.canvas && (gt.contexts[C].GLctx.canvas.GLctxObject = void 0), qv(gt.contexts[C].handle), gt.contexts[C] = null;
      }, initExtensions: function(C) {
        if (C || (C = gt.currentContext), !C.initExtensionsDone) {
          C.initExtensionsDone = true;
          var D = C.GLctx;
          Mh(D), Lh(D), Bh(D), D.disjointTimerQueryExt = D.getExtension("EXT_disjoint_timer_query"), Vh(D);
          var B = D.getSupportedExtensions() || [];
          B.forEach(function(Q) {
            !Q.includes("lose_context") && !Q.includes("debug") && D.getExtension(Q);
          });
        }
      } }, Wh = ["default", "low-power", "high-performance"];
      function Uh(C, D) {
        var B = D >> 2, Q = l()[B + 6], ue = { alpha: !!l()[B + 0], depth: !!l()[B + 1], stencil: !!l()[B + 2], antialias: !!l()[B + 3], premultipliedAlpha: !!l()[B + 4], preserveDrawingBuffer: !!l()[B + 5], powerPreference: Wh[Q], failIfMajorPerformanceCaveat: !!l()[B + 7], majorVersion: l()[B + 8], minorVersion: l()[B + 9], enableExtensionsByDefault: l()[B + 10], explicitSwapControl: l()[B + 11], proxyContextToMainThread: l()[B + 12], renderViaOffscreenBackBuffer: l()[B + 13] }, pe = yu(C);
        if (!pe || ue.explicitSwapControl)
          return 0;
        var ye = gt.createContext(pe, ue);
        return ye;
      }
      function Gh(C, D) {
        return Uh(C, D);
      }
      var _i = { mappings: {}, buffers: [null, [], []], printChar: function(C, D) {
        var B = _i.buffers[C];
        D === 0 || D === 10 ? ((C === 1 ? te : ee)(Dn(B, 0)), B.length = 0) : B.push(D);
      }, varargs: void 0, get: function() {
        _i.varargs += 4;
        var C = l()[_i.varargs - 4 >> 2];
        return C;
      }, getStr: function(C) {
        var D = tn(C);
        return D;
      }, get64: function(C, D) {
        return C;
      } };
      function Tc(C) {
        return N ? Lr(3, 1, C) : 0;
      }
      function $c(C, D, B, Q, ue) {
        if (N)
          return Lr(4, 1, C, D, B, Q, ue);
      }
      function _c(C, D, B, Q) {
        if (N)
          return Lr(5, 1, C, D, B, Q);
        for (var ue = 0, pe = 0; pe < B; pe++) {
          var ye = l()[D >> 2], Te = l()[D + 4 >> 2];
          D += 8;
          for (var bt = 0; bt < Te; bt++)
            _i.printChar(C, i()[ye + bt]);
          ue += Te;
        }
        return l()[Q >> 2] = ue, 0;
      }
      function Hh(C) {
        Ee(C);
      }
      $e.init();
      var Ac, qh = [null, kc, Nc, Tc, $c, _c], Uv = false, Ec = { __clock_gettime: bh, __emscripten_init_main_thread_js: yh, __emscripten_thread_cleanup: vh, __pthread_create_js: xh, _emscripten_default_pthread_stack_size: wh, _emscripten_notify_thread_queue: kh, abort: Ih, emscripten_check_blocking_allowed: Sh, emscripten_get_heap_max: Sc, emscripten_get_now: Mr, emscripten_memcpy_big: Ch, emscripten_num_logical_cores: Nh, emscripten_receive_on_main_thread_js: Th, emscripten_resize_heap: _h, emscripten_set_canvas_element_size: Ph, emscripten_unwind_to_js_event_loop: zh, emscripten_webgl_create_context: Gh, exit: wc, fd_close: Tc, fd_seek: $c, fd_write: _c, memory: Ce || d.wasmMemory, setTempRet0: Hh }, Gv = ih(), jh = d.___wasm_call_ctors = function() {
        return (jh = d.___wasm_call_ctors = d.asm.__wasm_call_ctors).apply(null, arguments);
      }, Kh = d._init = function() {
        return (Kh = d._init = d.asm.init).apply(null, arguments);
      }, Xh = d._init_with_threads_count = function() {
        return (Xh = d._init_with_threads_count = d.asm.init_with_threads_count).apply(null, arguments);
      }, Yh = d._get_threads_count = function() {
        return (Yh = d._get_threads_count = d.asm.get_threads_count).apply(null, arguments);
      }, Qh = d._register_tensor = function() {
        return (Qh = d._register_tensor = d.asm.register_tensor).apply(null, arguments);
      }, Zh = d._dispose_data = function() {
        return (Zh = d._dispose_data = d.asm.dispose_data).apply(null, arguments);
      }, Jh = d._dispose = function() {
        return (Jh = d._dispose = d.asm.dispose).apply(null, arguments);
      }, ef = d._Abs = function() {
        return (ef = d._Abs = d.asm.Abs).apply(null, arguments);
      }, tf = d._Add = function() {
        return (tf = d._Add = d.asm.Add).apply(null, arguments);
      }, nf = d._AddN = function() {
        return (nf = d._AddN = d.asm.AddN).apply(null, arguments);
      }, sf = d._All = function() {
        return (sf = d._All = d.asm.All).apply(null, arguments);
      }, rf = d._Any = function() {
        return (rf = d._Any = d.asm.Any).apply(null, arguments);
      }, af = d._ArgMax = function() {
        return (af = d._ArgMax = d.asm.ArgMax).apply(null, arguments);
      }, of = d._AvgPool = function() {
        return (of = d._AvgPool = d.asm.AvgPool).apply(null, arguments);
      }, uf = d._BatchMatMul = function() {
        return (uf = d._BatchMatMul = d.asm.BatchMatMul).apply(null, arguments);
      }, lf = d._Ceil = function() {
        return (lf = d._Ceil = d.asm.Ceil).apply(null, arguments);
      }, cf = d._ClipByValue = function() {
        return (cf = d._ClipByValue = d.asm.ClipByValue).apply(null, arguments);
      }, df = d._Conv2D = function() {
        return (df = d._Conv2D = d.asm.Conv2D).apply(null, arguments);
      }, pf = d._Conv2DBackpropInput = function() {
        return (pf = d._Conv2DBackpropInput = d.asm.Conv2DBackpropInput).apply(null, arguments);
      }, hf = d._Cos = function() {
        return (hf = d._Cos = d.asm.Cos).apply(null, arguments);
      }, ff = d._Cosh = function() {
        return (ff = d._Cosh = d.asm.Cosh).apply(null, arguments);
      }, mf = d._CropAndResize = function() {
        return (mf = d._CropAndResize = d.asm.CropAndResize).apply(null, arguments);
      }, gf = d._Cumprod = function() {
        return (gf = d._Cumprod = d.asm.Cumprod).apply(null, arguments);
      }, bf = d._Cumsum = function() {
        return (bf = d._Cumsum = d.asm.Cumsum).apply(null, arguments);
      }, yf = d._DepthToSpace = function() {
        return (yf = d._DepthToSpace = d.asm.DepthToSpace).apply(null, arguments);
      }, vf = d._DepthwiseConv2dNative = function() {
        return (vf = d._DepthwiseConv2dNative = d.asm.DepthwiseConv2dNative).apply(null, arguments);
      }, xf = d._Elu = function() {
        return (xf = d._Elu = d.asm.Elu).apply(null, arguments);
      }, wf = d._Equal = function() {
        return (wf = d._Equal = d.asm.Equal).apply(null, arguments);
      }, kf = d._Exp = function() {
        return (kf = d._Exp = d.asm.Exp).apply(null, arguments);
      }, If = d._FlipLeftRight = function() {
        return (If = d._FlipLeftRight = d.asm.FlipLeftRight).apply(null, arguments);
      }, Rc = d._Floor = function() {
        return (Rc = d._Floor = d.asm.Floor).apply(null, arguments);
      }, Dc = d._FloorDiv = function() {
        return (Dc = d._FloorDiv = d.asm.FloorDiv).apply(null, arguments);
      }, vu = d._FusedBatchNorm = function() {
        return (vu = d._FusedBatchNorm = d.asm.FusedBatchNorm).apply(null, arguments);
      }, Sf = d._FusedConv2D = function() {
        return (Sf = d._FusedConv2D = d.asm.FusedConv2D).apply(null, arguments);
      }, Cf = d._FusedDepthwiseConv2D = function() {
        return (Cf = d._FusedDepthwiseConv2D = d.asm.FusedDepthwiseConv2D).apply(null, arguments);
      }, Ai = d._Gather = function() {
        return (Ai = d._Gather = d.asm.Gather).apply(null, arguments);
      }, xu = d._GatherNd = function() {
        return (xu = d._GatherNd = d.asm.GatherNd).apply(null, arguments);
      }, wu = d._Greater = function() {
        return (wu = d._Greater = d.asm.Greater).apply(null, arguments);
      }, Hv = d._GreaterEqual = function() {
        return (Hv = d._GreaterEqual = d.asm.GreaterEqual).apply(null, arguments);
      }, Ei = d._LeakyRelu = function() {
        return (Ei = d._LeakyRelu = d.asm.LeakyRelu).apply(null, arguments);
      }, Ri = d._Less = function() {
        return (Ri = d._Less = d.asm.Less).apply(null, arguments);
      }, Nf = d._LessEqual = function() {
        return (Nf = d._LessEqual = d.asm.LessEqual).apply(null, arguments);
      }, H = d._Log = function() {
        return (H = d._Log = d.asm.Log).apply(null, arguments);
      }, J = d._LogicalAnd = function() {
        return (J = d._LogicalAnd = d.asm.LogicalAnd).apply(null, arguments);
      }, de = d._Max = function() {
        return (de = d._Max = d.asm.Max).apply(null, arguments);
      }, Ie = d._MaxPool = function() {
        return (Ie = d._MaxPool = d.asm.MaxPool).apply(null, arguments);
      }, Qe = d._Maximum = function() {
        return (Qe = d._Maximum = d.asm.Maximum).apply(null, arguments);
      }, Ze = d._Mean = function() {
        return (Ze = d._Mean = d.asm.Mean).apply(null, arguments);
      }, Ve = d._Min = function() {
        return (Ve = d._Min = d.asm.Min).apply(null, arguments);
      }, ze = d._Minimum = function() {
        return (ze = d._Minimum = d.asm.Minimum).apply(null, arguments);
      }, Tt = d._MirrorPad = function() {
        return (Tt = d._MirrorPad = d.asm.MirrorPad).apply(null, arguments);
      }, is = d._Multiply = function() {
        return (is = d._Multiply = d.asm.Multiply).apply(null, arguments);
      }, os = d._Neg = function() {
        return (os = d._Neg = d.asm.Neg).apply(null, arguments);
      }, Di = d._NonMaxSuppressionV3 = function() {
        return (Di = d._NonMaxSuppressionV3 = d.asm.NonMaxSuppressionV3).apply(null, arguments);
      }, Br = d._NonMaxSuppressionV4 = function() {
        return (Br = d._NonMaxSuppressionV4 = d.asm.NonMaxSuppressionV4).apply(null, arguments);
      }, Tf = d._NonMaxSuppressionV5 = function() {
        return (Tf = d._NonMaxSuppressionV5 = d.asm.NonMaxSuppressionV5).apply(null, arguments);
      }, an = d._NotEqual = function() {
        return (an = d._NotEqual = d.asm.NotEqual).apply(null, arguments);
      }, nr = d._OneHot = function() {
        return (nr = d._OneHot = d.asm.OneHot).apply(null, arguments);
      }, Fc = d._PadV2 = function() {
        return (Fc = d._PadV2 = d.asm.PadV2).apply(null, arguments);
      }, jN = d._Pow = function() {
        return (jN = d._Pow = d.asm.Pow).apply(null, arguments);
      }, KN = d._Prelu = function() {
        return (KN = d._Prelu = d.asm.Prelu).apply(null, arguments);
      }, XN = d._Prod = function() {
        return (XN = d._Prod = d.asm.Prod).apply(null, arguments);
      }, YN = d._RealDiv = function() {
        return (YN = d._RealDiv = d.asm.RealDiv).apply(null, arguments);
      }, QN = d._Relu = function() {
        return (QN = d._Relu = d.asm.Relu).apply(null, arguments);
      }, ZN = d._Relu6 = function() {
        return (ZN = d._Relu6 = d.asm.Relu6).apply(null, arguments);
      }, JN = d._ResizeBilinear = function() {
        return (JN = d._ResizeBilinear = d.asm.ResizeBilinear).apply(null, arguments);
      }, eT = d._Reverse = function() {
        return (eT = d._Reverse = d.asm.Reverse).apply(null, arguments);
      }, tT = d._RotateWithOffset = function() {
        return (tT = d._RotateWithOffset = d.asm.RotateWithOffset).apply(null, arguments);
      }, nT = d._Round = function() {
        return (nT = d._Round = d.asm.Round).apply(null, arguments);
      }, sT = d._Rsqrt = function() {
        return (sT = d._Rsqrt = d.asm.Rsqrt).apply(null, arguments);
      }, rT = d._ScatterNd = function() {
        return (rT = d._ScatterNd = d.asm.ScatterNd).apply(null, arguments);
      }, aT = d._SelectV2 = function() {
        return (aT = d._SelectV2 = d.asm.SelectV2).apply(null, arguments);
      }, iT = d._Sigmoid = function() {
        return (iT = d._Sigmoid = d.asm.Sigmoid).apply(null, arguments);
      }, oT = d._Sin = function() {
        return (oT = d._Sin = d.asm.Sin).apply(null, arguments);
      }, uT = d._Softmax = function() {
        return (uT = d._Softmax = d.asm.Softmax).apply(null, arguments);
      }, lT = d._SparseFillEmptyRows = function() {
        return (lT = d._SparseFillEmptyRows = d.asm.SparseFillEmptyRows).apply(null, arguments);
      }, cT = d._SparseReshape = function() {
        return (cT = d._SparseReshape = d.asm.SparseReshape).apply(null, arguments);
      }, dT = d._SparseSegmentReduction = function() {
        return (dT = d._SparseSegmentReduction = d.asm.SparseSegmentReduction).apply(null, arguments);
      }, pT = d._Sqrt = function() {
        return (pT = d._Sqrt = d.asm.Sqrt).apply(null, arguments);
      }, hT = d._Square = function() {
        return (hT = d._Square = d.asm.Square).apply(null, arguments);
      }, fT = d._SquaredDifference = function() {
        return (fT = d._SquaredDifference = d.asm.SquaredDifference).apply(null, arguments);
      }, mT = d._Step = function() {
        return (mT = d._Step = d.asm.Step).apply(null, arguments);
      }, gT = d._StridedSlice = function() {
        return (gT = d._StridedSlice = d.asm.StridedSlice).apply(null, arguments);
      }, bT = d._Sub = function() {
        return (bT = d._Sub = d.asm.Sub).apply(null, arguments);
      }, yT = d._Sum = function() {
        return (yT = d._Sum = d.asm.Sum).apply(null, arguments);
      }, vT = d._Tan = function() {
        return (vT = d._Tan = d.asm.Tan).apply(null, arguments);
      }, xT = d._Tanh = function() {
        return (xT = d._Tanh = d.asm.Tanh).apply(null, arguments);
      }, wT = d._Tile = function() {
        return (wT = d._Tile = d.asm.Tile).apply(null, arguments);
      }, kT = d._TopK = function() {
        return (kT = d._TopK = d.asm.TopK).apply(null, arguments);
      }, IT = d._Transform = function() {
        return (IT = d._Transform = d.asm.Transform).apply(null, arguments);
      }, ST = d._Transpose = function() {
        return (ST = d._Transpose = d.asm.Transpose).apply(null, arguments);
      }, CT = d.__FusedMatMul = function() {
        return (CT = d.__FusedMatMul = d.asm._FusedMatMul).apply(null, arguments);
      }, $f = d._malloc = function() {
        return ($f = d._malloc = d.asm.malloc).apply(null, arguments);
      }, qv = d._free = function() {
        return (qv = d._free = d.asm.free).apply(null, arguments);
      }, NT = d._emscripten_tls_init = function() {
        return (NT = d._emscripten_tls_init = d.asm.emscripten_tls_init).apply(null, arguments);
      }, jv = d.___errno_location = function() {
        return (jv = d.___errno_location = d.asm.__errno_location).apply(null, arguments);
      }, Oc = d._pthread_self = function() {
        return (Oc = d._pthread_self = d.asm.pthread_self).apply(null, arguments);
      }, Kv = d._emscripten_main_thread_process_queued_calls = function() {
        return (Kv = d._emscripten_main_thread_process_queued_calls = d.asm.emscripten_main_thread_process_queued_calls).apply(null, arguments);
      }, TT = d.__emscripten_thread_crashed = function() {
        return (TT = d.__emscripten_thread_crashed = d.asm._emscripten_thread_crashed).apply(null, arguments);
      }, Xv = d.__emscripten_thread_init = function() {
        return (Xv = d.__emscripten_thread_init = d.asm._emscripten_thread_init).apply(null, arguments);
      }, $T = d._emscripten_current_thread_process_queued_calls = function() {
        return ($T = d._emscripten_current_thread_process_queued_calls = d.asm.emscripten_current_thread_process_queued_calls).apply(null, arguments);
      }, _T = d._emscripten_main_browser_thread_id = function() {
        return (_T = d._emscripten_main_browser_thread_id = d.asm.emscripten_main_browser_thread_id).apply(null, arguments);
      }, AT = d._emscripten_sync_run_in_main_thread_2 = function() {
        return (AT = d._emscripten_sync_run_in_main_thread_2 = d.asm.emscripten_sync_run_in_main_thread_2).apply(null, arguments);
      }, Yv = d._emscripten_sync_run_in_main_thread_4 = function() {
        return (Yv = d._emscripten_sync_run_in_main_thread_4 = d.asm.emscripten_sync_run_in_main_thread_4).apply(null, arguments);
      }, Qv = d._emscripten_run_in_main_runtime_thread_js = function() {
        return (Qv = d._emscripten_run_in_main_runtime_thread_js = d.asm.emscripten_run_in_main_runtime_thread_js).apply(null, arguments);
      }, _f = d._emscripten_dispatch_to_thread_ = function() {
        return (_f = d._emscripten_dispatch_to_thread_ = d.asm.emscripten_dispatch_to_thread_).apply(null, arguments);
      }, Af = d.__emscripten_thread_free_data = function() {
        return (Af = d.__emscripten_thread_free_data = d.asm._emscripten_thread_free_data).apply(null, arguments);
      }, ET = d.__emscripten_thread_exit = function() {
        return (ET = d.__emscripten_thread_exit = d.asm._emscripten_thread_exit).apply(null, arguments);
      }, RT = d._memalign = function() {
        return (RT = d._memalign = d.asm.memalign).apply(null, arguments);
      }, Zv = d._emscripten_stack_set_limits = function() {
        return (Zv = d._emscripten_stack_set_limits = d.asm.emscripten_stack_set_limits).apply(null, arguments);
      }, Ef = d.stackSave = function() {
        return (Ef = d.stackSave = d.asm.stackSave).apply(null, arguments);
      }, Pc = d.stackRestore = function() {
        return (Pc = d.stackRestore = d.asm.stackRestore).apply(null, arguments);
      }, Fi = d.stackAlloc = function() {
        return (Fi = d.stackAlloc = d.asm.stackAlloc).apply(null, arguments);
      }, DT = d.dynCall_iijjiiii = function() {
        return (DT = d.dynCall_iijjiiii = d.asm.dynCall_iijjiiii).apply(null, arguments);
      }, FT = d.dynCall_jiji = function() {
        return (FT = d.dynCall_jiji = d.asm.dynCall_jiji).apply(null, arguments);
      }, Jv = d.__emscripten_allow_main_runtime_queued_calls = 21456;
      d.cwrap = en, d.keepRuntimeAlive = Pr, d.PThread = $e, d.PThread = $e, d.wasmMemory = Ce, d.ExitStatus = ku;
      var zc;
      function ku(C) {
        this.name = "ExitStatus", this.message = "Program terminated with exit(" + C + ")", this.status = C;
      }
      as = function C() {
        zc || Rf(), zc || (as = C);
      };
      function Rf(C) {
        if (C = C || b, tr > 0)
          return;
        if (N) {
          h(d), fu(), postMessage({ cmd: "loaded" });
          return;
        }
        if (sn(), tr > 0)
          return;
        function D() {
          zc || (zc = true, d.calledRun = true, !at && (fu(), h(d), d.onRuntimeInitialized && d.onRuntimeInitialized(), rh()));
        }
        d.setStatus ? (d.setStatus("Running..."), setTimeout(function() {
          setTimeout(function() {
            d.setStatus("");
          }, 1), D();
        }, 1)) : D();
      }
      d.run = Rf;
      function OT(C, D) {
        if (Jt = C, !D && N)
          throw kc(C), "unwind";
        Pr() || sh(), PT(C);
      }
      function PT(C) {
        Jt = C, Pr() || ($e.terminateAllThreads(), d.onExit && d.onExit(C), at = true), v(C, new ku(C));
      }
      if (d.preInit)
        for (typeof d.preInit == "function" && (d.preInit = [d.preInit]); d.preInit.length > 0; )
          d.preInit.pop()();
      Rf();
      var Mc;
      m && (Mc = { uncaughtException: process.listeners("uncaughtException").filter(function(C) {
        return !m.uncaughtException.indexOf(C) > -1;
      }), unhandledRejection: process.listeners("unhandledRejection").filter(function(C) {
        return !m.unhandledRejection.indexOf(C) > -1;
      }) });
      var Lc;
      if (typeof WasmBackendModule != "undefined")
        Lc = WasmBackendModule;
      else if (typeof r != "undefined")
        Lc = r;
      else
        throw new Error("Could not find wasm module in post.js");
      if (Mc) {
        var zT = Lc._dispose;
        Lc._dispose = function() {
          zT(), Mc.uncaughtException.forEach(function(C) {
            process.removeListener("uncaughtException", C);
          }), Mc.unhandledRejection.forEach(function(C) {
            process.removeListener("unhandledRejection", C);
          });
        };
      }
      return r.ready;
    };
  })();
  typeof e == "object" && typeof t == "object" ? t.exports = n : typeof define == "function" && define.amd ? define([], function() {
    return n;
  }) : typeof e == "object" && (e.WasmBackendModuleThreadedSimd = n);
} });
var i$ = zt({ "src/tfjs-backend-wasm/wasm-out/tfjs-backend-wasm.js"(e, t) {
  var n = (() => {
    var s = typeof document != "undefined" && document.currentScript ? document.currentScript.src : void 0;
    return typeof __filename != "undefined" && (s = s || __filename), function(r) {
      r = r || {};
      var a = typeof r != "undefined" ? r : {}, i, o;
      a.ready = new Promise(function(H, J) {
        i = H, o = J;
      });
      var u;
      typeof process != "undefined" && process.listeners && (u = { uncaughtException: process.listeners("uncaughtException"), unhandledRejection: process.listeners("unhandledRejection") });
      var l = Object.assign({}, a), c = [], p = "./this.program", d = (H, J) => {
        throw J;
      }, h = typeof window == "object", f = typeof importScripts == "function", m = typeof process == "object" && typeof process.versions == "object" && typeof process.versions.node == "string", g = "";
      function b(H) {
        return a.locateFile ? a.locateFile(H, g) : g + H;
      }
      var y, v, x, k;
      function T(H) {
        if (H instanceof xu)
          return;
        R("exiting due to exception: " + H);
      }
      var N, E, A;
      m ? (f ? g = dd().dirname(g) + "/" : g = __dirname + "/", A = () => {
        E || (N = tg(), E = dd());
      }, y = function(J, de) {
        return A(), J = E.normalize(J), N.readFileSync(J, de ? void 0 : "utf8");
      }, x = (H) => {
        var J = y(H, true);
        return J.buffer || (J = new Uint8Array(J)), J;
      }, v = (H, J, de) => {
        A(), H = E.normalize(H), N.readFile(H, function(Ie, Qe) {
          Ie ? de(Ie) : J(Qe.buffer);
        });
      }, process.argv.length > 1 && (p = process.argv[1].replace(/\\/g, "/")), c = process.argv.slice(2), process.on("uncaughtException", function(H) {
        if (!(H instanceof xu))
          throw H;
      }), process.on("unhandledRejection", function(H) {
        throw H;
      }), d = (H, J) => {
        if (hu())
          throw process.exitCode = H, J;
        T(J), process.exit(H);
      }, a.inspect = function() {
        return "[Emscripten Module object]";
      }) : (h || f) && (f ? g = self.location.href : typeof document != "undefined" && document.currentScript && (g = document.currentScript.src), s && (g = s), g.indexOf("blob:") !== 0 ? g = g.substr(0, g.replace(/[?#].*/, "").lastIndexOf("/") + 1) : g = "", y = (H) => {
        var J = new XMLHttpRequest();
        return J.open("GET", H, false), J.send(null), J.responseText;
      }, f && (x = (H) => {
        var J = new XMLHttpRequest();
        return J.open("GET", H, false), J.responseType = "arraybuffer", J.send(null), new Uint8Array(J.response);
      }), v = (H, J, de) => {
        var Ie = new XMLHttpRequest();
        Ie.open("GET", H, true), Ie.responseType = "arraybuffer", Ie.onload = () => {
          if (Ie.status == 200 || Ie.status == 0 && Ie.response) {
            J(Ie.response);
            return;
          }
          de();
        }, Ie.onerror = de, Ie.send(null);
      }, k = (H) => document.title = H);
      var P = a.print || console.log.bind(console), R = a.printErr || console.warn.bind(console);
      Object.assign(a, l), l = null, a.arguments && (c = a.arguments), a.thisProgram && (p = a.thisProgram), a.quit && (d = a.quit);
      var F = 4;
      function $(H) {
        $.shown || ($.shown = {}), $.shown[H] || ($.shown[H] = 1, R(H));
      }
      function z(H, J) {
        if (typeof WebAssembly.Function == "function") {
          for (var de = { i: "i32", j: "i64", f: "f32", d: "f64" }, Ie = { parameters: [], results: J[0] == "v" ? [] : [de[J[0]]] }, Qe = 1; Qe < J.length; ++Qe)
            Ie.parameters.push(de[J[Qe]]);
          return new WebAssembly.Function(Ie, H);
        }
        var Ze = [1, 0, 1, 96], Ve = J.slice(0, 1), ze = J.slice(1), Tt = { i: 127, j: 126, f: 125, d: 124 };
        Ze.push(ze.length);
        for (var Qe = 0; Qe < ze.length; ++Qe)
          Ze.push(Tt[ze[Qe]]);
        Ve == "v" ? Ze.push(0) : Ze = Ze.concat([1, Tt[Ve]]), Ze[1] = Ze.length - 2;
        var is = new Uint8Array([0, 97, 115, 109, 1, 0, 0, 0].concat(Ze, [2, 7, 1, 1, 101, 1, 102, 0, 0, 7, 5, 1, 1, 102, 0, 0])), os = new WebAssembly.Module(is), Di = new WebAssembly.Instance(os, { e: { f: H } }), Br = Di.exports.f;
        return Br;
      }
      var W = [], q;
      function K() {
        if (W.length)
          return W.pop();
        try {
          Js.grow(1);
        } catch (H) {
          throw H instanceof RangeError ? "Unable to grow wasm table. Set ALLOW_TABLE_GROWTH." : H;
        }
        return Js.length - 1;
      }
      function Y(H, J) {
        for (var de = H; de < H + J; de++) {
          var Ie = gu(de);
          Ie && q.set(Ie, de);
        }
      }
      var Z = 0, te = (H) => {
        Z = H;
      }, ee;
      a.wasmBinary && (ee = a.wasmBinary);
      var se = a.noExitRuntime || true;
      typeof WebAssembly != "object" && Or("no native wasm support detected");
      var ne, oe = false, re;
      function le(H, J) {
        H || Or(J);
      }
      function me(H) {
        var J = a["_" + H];
        return J;
      }
      function ke(H, J, de, Ie, Qe) {
        var Ze = { string: function(an) {
          var nr = 0;
          if (an != null && an !== 0) {
            var Fc = (an.length << 2) + 1;
            nr = vu(Fc), tt(an, nr, Fc);
          }
          return nr;
        }, array: function(an) {
          var nr = vu(an.length);
          return at(an, nr), nr;
        } };
        function Ve(an) {
          return J === "string" ? Je(an) : J === "boolean" ? Boolean(an) : an;
        }
        var ze = me(H), Tt = [], is = 0;
        if (Ie)
          for (var os = 0; os < Ie.length; os++) {
            var Di = Ze[de[os]];
            Di ? (is === 0 && (is = Rc()), Tt[os] = Di(Ie[os])) : Tt[os] = Ie[os];
          }
        var Br = ze.apply(null, Tt);
        function Tf(an) {
          return is !== 0 && Dc(is), Ve(an);
        }
        return Br = Tf(Br), Br;
      }
      function Se(H, J, de, Ie) {
        de = de || [];
        var Qe = de.every(function(Ve) {
          return Ve === "number";
        }), Ze = J !== "string";
        return Ze && Qe && !Ie ? me(H) : function() {
          return ke(H, J, de, arguments, Ie);
        };
      }
      var Ee = 1, Pe = typeof TextDecoder != "undefined" ? new TextDecoder("utf8") : void 0;
      function Xe(H, J, de) {
        for (var Ie = J + de, Qe = J; H[Qe] && !(Qe >= Ie); )
          ++Qe;
        if (Qe - J > 16 && H.subarray && Pe)
          return Pe.decode(H.subarray(J, Qe));
        for (var Ze = ""; J < Qe; ) {
          var Ve = H[J++];
          if (!(Ve & 128)) {
            Ze += String.fromCharCode(Ve);
            continue;
          }
          var ze = H[J++] & 63;
          if ((Ve & 224) == 192) {
            Ze += String.fromCharCode((Ve & 31) << 6 | ze);
            continue;
          }
          var Tt = H[J++] & 63;
          if ((Ve & 240) == 224 ? Ve = (Ve & 15) << 12 | ze << 6 | Tt : Ve = (Ve & 7) << 18 | ze << 12 | Tt << 6 | H[J++] & 63, Ve < 65536)
            Ze += String.fromCharCode(Ve);
          else {
            var is = Ve - 65536;
            Ze += String.fromCharCode(55296 | is >> 10, 56320 | is & 1023);
          }
        }
        return Ze;
      }
      function Je(H, J) {
        return H ? Xe(en, H, J) : "";
      }
      function Ye(H, J, de, Ie) {
        if (!(Ie > 0))
          return 0;
        for (var Qe = de, Ze = de + Ie - 1, Ve = 0; Ve < H.length; ++Ve) {
          var ze = H.charCodeAt(Ve);
          if (ze >= 55296 && ze <= 57343) {
            var Tt = H.charCodeAt(++Ve);
            ze = 65536 + ((ze & 1023) << 10) | Tt & 1023;
          }
          if (ze <= 127) {
            if (de >= Ze)
              break;
            J[de++] = ze;
          } else if (ze <= 2047) {
            if (de + 1 >= Ze)
              break;
            J[de++] = 192 | ze >> 6, J[de++] = 128 | ze & 63;
          } else if (ze <= 65535) {
            if (de + 2 >= Ze)
              break;
            J[de++] = 224 | ze >> 12, J[de++] = 128 | ze >> 6 & 63, J[de++] = 128 | ze & 63;
          } else {
            if (de + 3 >= Ze)
              break;
            J[de++] = 240 | ze >> 18, J[de++] = 128 | ze >> 12 & 63, J[de++] = 128 | ze >> 6 & 63, J[de++] = 128 | ze & 63;
          }
        }
        return J[de] = 0, de - Qe;
      }
      function tt(H, J, de) {
        return Ye(H, en, J, de);
      }
      function Ce(H) {
        for (var J = 0, de = 0; de < H.length; ++de) {
          var Ie = H.charCodeAt(de);
          Ie >= 55296 && Ie <= 57343 && (Ie = 65536 + ((Ie & 1023) << 10) | H.charCodeAt(++de) & 1023), Ie <= 127 ? ++J : Ie <= 2047 ? J += 2 : Ie <= 65535 ? J += 3 : J += 4;
        }
        return J;
      }
      var ut = typeof TextDecoder != "undefined" ? new TextDecoder("utf-16le") : void 0;
      function at(H, J) {
        Et.set(H, J);
      }
      function Jt(H, J, de) {
        for (var Ie = 0; Ie < H.length; ++Ie)
          Et[J++ >> 0] = H.charCodeAt(Ie);
        de || (Et[J >> 0] = 0);
      }
      function Nt(H, J) {
        return H % J > 0 && (H += J - H % J), H;
      }
      var Cn, Et, en, Nn, Tn, Yt, Dn, tn, Ms;
      function Ls(H) {
        Cn = H, a.HEAP8 = Et = new Int8Array(H), a.HEAP16 = Nn = new Int16Array(H), a.HEAP32 = Yt = new Int32Array(H), a.HEAPU8 = en = new Uint8Array(H), a.HEAPU16 = Tn = new Uint16Array(H), a.HEAPU32 = Dn = new Uint32Array(H), a.HEAPF32 = tn = new Float32Array(H), a.HEAPF64 = Ms = new Float64Array(H);
      }
      var ki = a.INITIAL_MEMORY || 16777216, Js, Bs = [], pu = [], Ii = [], nn = false, ic = false, oc = 0;
      function hu() {
        return se || oc > 0;
      }
      function uc() {
        if (a.preRun)
          for (typeof a.preRun == "function" && (a.preRun = [a.preRun]); a.preRun.length; )
            dc(a.preRun.shift());
        mu(Bs);
      }
      function lc() {
        nn = true, mu(pu);
      }
      function Fv() {
        ic = true;
      }
      function cc() {
        if (a.postRun)
          for (typeof a.postRun == "function" && (a.postRun = [a.postRun]); a.postRun.length; )
            pc(a.postRun.shift());
        mu(Ii);
      }
      function dc(H) {
        Bs.unshift(H);
      }
      function rs(H) {
        pu.unshift(H);
      }
      function pc(H) {
        Ii.unshift(H);
      }
      var Fn = 0, Si = null, er = null;
      function th(H) {
        Fn++, a.monitorRunDependencies && a.monitorRunDependencies(Fn);
      }
      function hc(H) {
        if (Fn--, a.monitorRunDependencies && a.monitorRunDependencies(Fn), Fn == 0 && (Si !== null && (clearInterval(Si), Si = null), er)) {
          var J = er;
          er = null, J();
        }
      }
      a.preloadedImages = {}, a.preloadedAudios = {};
      function Or(H) {
        a.onAbort && a.onAbort(H), H = "Aborted(" + H + ")", R(H), oe = true, re = 1, H += ". Build with -s ASSERTIONS=1 for more info.";
        var J = new WebAssembly.RuntimeError(H);
        throw o(J), J;
      }
      var nh = "data:application/octet-stream;base64,";
      function fc(H) {
        return H.startsWith(nh);
      }
      function Pr(H) {
        return H.startsWith("file://");
      }
      var sn;
      sn = "tfjs-backend-wasm.wasm", fc(sn) || (sn = b(sn));
      function fu(H) {
        try {
          if (H == sn && ee)
            return new Uint8Array(ee);
          if (x)
            return x(H);
          throw "both async and sync fetching of the wasm failed";
        } catch (J) {
          Or(J);
        }
      }
      function sh() {
        if (!ee && (h || f)) {
          if (typeof fetch == "function" && !Pr(sn))
            return fetch(sn, { credentials: "same-origin" }).then(function(H) {
              if (!H.ok)
                throw "failed to load wasm binary file at '" + sn + "'";
              return H.arrayBuffer();
            }).catch(function() {
              return fu(sn);
            });
          if (v)
            return new Promise(function(H, J) {
              v(sn, function(de) {
                H(new Uint8Array(de));
              }, J);
            });
        }
        return Promise.resolve().then(function() {
          return fu(sn);
        });
      }
      function rh() {
        var H = { env: Ti, wasi_snapshot_preview1: Ti };
        function J(Ve, ze) {
          var Tt = Ve.exports;
          a.asm = Tt, ne = a.asm.memory, Ls(ne.buffer), Js = a.asm.__indirect_function_table, rs(a.asm.__wasm_call_ctors), hc("wasm-instantiate");
        }
        th("wasm-instantiate");
        function de(Ve) {
          J(Ve.instance);
        }
        function Ie(Ve) {
          return sh().then(function(ze) {
            return WebAssembly.instantiate(ze, H);
          }).then(function(ze) {
            return ze;
          }).then(Ve, function(ze) {
            R("failed to asynchronously prepare wasm: " + ze), Or(ze);
          });
        }
        function Qe() {
          return !ee && typeof WebAssembly.instantiateStreaming == "function" && !fc(sn) && !Pr(sn) && typeof fetch == "function" ? fetch(sn, { credentials: "same-origin" }).then(function(Ve) {
            var ze = WebAssembly.instantiateStreaming(Ve, H);
            return ze.then(de, function(Tt) {
              return R("wasm streaming compile failed: " + Tt), R("falling back to ArrayBuffer instantiation"), Ie(de);
            });
          }) : Ie(de);
        }
        if (a.instantiateWasm)
          try {
            var Ze = a.instantiateWasm(H, J);
            return Ze;
          } catch (Ve) {
            return R("Module.instantiateWasm callback failed with error: " + Ve), false;
          }
        return Qe().catch(o), {};
      }
      var Ov, Pv;
      function mu(H) {
        for (; H.length > 0; ) {
          var J = H.shift();
          if (typeof J == "function") {
            J(a);
            continue;
          }
          var de = J.func;
          typeof de == "number" ? J.arg === void 0 ? gu(de)() : gu(de)(J.arg) : de(J.arg === void 0 ? null : J.arg);
        }
      }
      function tr(H) {
        return H;
      }
      function mc(H) {
        var J = /\b_Z[\w\d_]+/g;
        return H.replace(J, function(de) {
          var Ie = de;
          return de === Ie ? de : Ie + " [" + de + "]";
        });
      }
      var as = [];
      function gu(H) {
        var J = as[H];
        return J || (H >= as.length && (as.length = H + 1), as[H] = J = Js.get(H)), J;
      }
      function zv() {
        var H = new Error();
        if (!H.stack) {
          try {
            throw new Error();
          } catch (J) {
            H = J;
          }
          if (!H.stack)
            return "(no stack trace available)";
        }
        return H.stack.toString();
      }
      function Ci(H, J) {
        Js.set(H, J), as[H] = J;
      }
      function ah() {
        Or("");
      }
      function gc(H, J, de) {
        en.copyWithin(H, J, J + de);
      }
      function bc() {
        return 2147483648;
      }
      function rn(H) {
        try {
          return ne.grow(H - Cn.byteLength + 65535 >>> 16), Ls(ne.buffer), 1;
        } catch (J) {
        }
      }
      function yc(H) {
        var J = en.length;
        H = H >>> 0;
        var de = bc();
        if (H > de)
          return false;
        for (var Ie = 1; Ie <= 4; Ie *= 2) {
          var Qe = J * (1 + 0.2 / Ie);
          Qe = Math.min(Qe, H + 100663296);
          var Ze = Math.min(de, Nt(Math.max(H, Qe), 65536)), Ve = rn(Ze);
          if (Ve)
            return true;
        }
        return false;
      }
      var Ni = { mappings: {}, buffers: [null, [], []], printChar: function(H, J) {
        var de = Ni.buffers[H];
        J === 0 || J === 10 ? ((H === 1 ? P : R)(Xe(de, 0)), de.length = 0) : de.push(J);
      }, varargs: void 0, get: function() {
        Ni.varargs += 4;
        var H = Yt[Ni.varargs - 4 >> 2];
        return H;
      }, getStr: function(H) {
        var J = Je(H);
        return J;
      }, get64: function(H, J) {
        return H;
      } };
      function ih(H) {
        return 0;
      }
      function Mv(H, J, de, Ie, Qe) {
      }
      function Lv(H, J, de, Ie) {
        for (var Qe = 0, Ze = 0; Ze < de; Ze++) {
          var Ve = Yt[J >> 2], ze = Yt[J + 4 >> 2];
          J += 8;
          for (var Tt = 0; Tt < ze; Tt++)
            Ni.printChar(H, en[Ve + Tt]);
          Qe += ze;
        }
        return Yt[Ie >> 2] = Qe, 0;
      }
      function oh(H) {
        te(H);
      }
      var vc = false, Ti = { abort: ah, emscripten_memcpy_big: gc, emscripten_resize_heap: yc, fd_close: ih, fd_seek: Mv, fd_write: Lv, setTempRet0: oh }, qN = rh(), Bv = a.___wasm_call_ctors = function() {
        return (Bv = a.___wasm_call_ctors = a.asm.__wasm_call_ctors).apply(null, arguments);
      }, uh = a._init = function() {
        return (uh = a._init = a.asm.init).apply(null, arguments);
      }, lh = a._init_with_threads_count = function() {
        return (lh = a._init_with_threads_count = a.asm.init_with_threads_count).apply(null, arguments);
      }, xc = a._get_threads_count = function() {
        return (xc = a._get_threads_count = a.asm.get_threads_count).apply(null, arguments);
      }, wc = a._register_tensor = function() {
        return (wc = a._register_tensor = a.asm.register_tensor).apply(null, arguments);
      }, ch = a._dispose_data = function() {
        return (ch = a._dispose_data = a.asm.dispose_data).apply(null, arguments);
      }, $e = a._dispose = function() {
        return ($e = a._dispose = a.asm.dispose).apply(null, arguments);
      }, dh = a._Abs = function() {
        return (dh = a._Abs = a.asm.Abs).apply(null, arguments);
      }, kc = a._Add = function() {
        return (kc = a._Add = a.asm.Add).apply(null, arguments);
      }, zr = a._AddN = function() {
        return (zr = a._AddN = a.asm.AddN).apply(null, arguments);
      }, $i = a._All = function() {
        return ($i = a._All = a.asm.All).apply(null, arguments);
      }, ph = a._Any = function() {
        return (ph = a._Any = a.asm.Any).apply(null, arguments);
      }, Vv = a._ArgMax = function() {
        return (Vv = a._ArgMax = a.asm.ArgMax).apply(null, arguments);
      }, hh = a._AvgPool = function() {
        return (hh = a._AvgPool = a.asm.AvgPool).apply(null, arguments);
      }, Wv = a._BatchMatMul = function() {
        return (Wv = a._BatchMatMul = a.asm.BatchMatMul).apply(null, arguments);
      }, Mr = a._Ceil = function() {
        return (Mr = a._Ceil = a.asm.Ceil).apply(null, arguments);
      }, fh = a._ClipByValue = function() {
        return (fh = a._ClipByValue = a.asm.ClipByValue).apply(null, arguments);
      }, mh = a._Conv2D = function() {
        return (mh = a._Conv2D = a.asm.Conv2D).apply(null, arguments);
      }, gh = a._Conv2DBackpropInput = function() {
        return (gh = a._Conv2DBackpropInput = a.asm.Conv2DBackpropInput).apply(null, arguments);
      }, bh = a._Cos = function() {
        return (bh = a._Cos = a.asm.Cos).apply(null, arguments);
      }, yh = a._Cosh = function() {
        return (yh = a._Cosh = a.asm.Cosh).apply(null, arguments);
      }, vh = a._CropAndResize = function() {
        return (vh = a._CropAndResize = a.asm.CropAndResize).apply(null, arguments);
      }, Ic = a._Cumprod = function() {
        return (Ic = a._Cumprod = a.asm.Cumprod).apply(null, arguments);
      }, xh = a._Cumsum = function() {
        return (xh = a._Cumsum = a.asm.Cumsum).apply(null, arguments);
      }, wh = a._DepthToSpace = function() {
        return (wh = a._DepthToSpace = a.asm.DepthToSpace).apply(null, arguments);
      }, kh = a._DepthwiseConv2dNative = function() {
        return (kh = a._DepthwiseConv2dNative = a.asm.DepthwiseConv2dNative).apply(null, arguments);
      }, Ih = a._Elu = function() {
        return (Ih = a._Elu = a.asm.Elu).apply(null, arguments);
      }, Sh = a._Equal = function() {
        return (Sh = a._Equal = a.asm.Equal).apply(null, arguments);
      }, Sc = a._Exp = function() {
        return (Sc = a._Exp = a.asm.Exp).apply(null, arguments);
      }, Ch = a._FlipLeftRight = function() {
        return (Ch = a._FlipLeftRight = a.asm.FlipLeftRight).apply(null, arguments);
      }, Nh = a._Floor = function() {
        return (Nh = a._Floor = a.asm.Floor).apply(null, arguments);
      }, Lr = a._FloorDiv = function() {
        return (Lr = a._FloorDiv = a.asm.FloorDiv).apply(null, arguments);
      }, bu = a._FusedBatchNorm = function() {
        return (bu = a._FusedBatchNorm = a.asm.FusedBatchNorm).apply(null, arguments);
      }, Th = a._FusedConv2D = function() {
        return (Th = a._FusedConv2D = a.asm.FusedConv2D).apply(null, arguments);
      }, $h = a._FusedDepthwiseConv2D = function() {
        return ($h = a._FusedDepthwiseConv2D = a.asm.FusedDepthwiseConv2D).apply(null, arguments);
      }, _h = a._Gather = function() {
        return (_h = a._Gather = a.asm.Gather).apply(null, arguments);
      }, Le = a._GatherNd = function() {
        return (Le = a._GatherNd = a.asm.GatherNd).apply(null, arguments);
      }, Ah = a._Greater = function() {
        return (Ah = a._Greater = a.asm.Greater).apply(null, arguments);
      }, Eh = a._GreaterEqual = function() {
        return (Eh = a._GreaterEqual = a.asm.GreaterEqual).apply(null, arguments);
      }, Rh = a._LeakyRelu = function() {
        return (Rh = a._LeakyRelu = a.asm.LeakyRelu).apply(null, arguments);
      }, Dh = a._Less = function() {
        return (Dh = a._Less = a.asm.Less).apply(null, arguments);
      }, Fh = a._LessEqual = function() {
        return (Fh = a._LessEqual = a.asm.LessEqual).apply(null, arguments);
      }, Oh = a._Log = function() {
        return (Oh = a._Log = a.asm.Log).apply(null, arguments);
      }, yu = a._LogicalAnd = function() {
        return (yu = a._LogicalAnd = a.asm.LogicalAnd).apply(null, arguments);
      }, Cc = a._Max = function() {
        return (Cc = a._Max = a.asm.Max).apply(null, arguments);
      }, Nc = a._MaxPool = function() {
        return (Nc = a._MaxPool = a.asm.MaxPool).apply(null, arguments);
      }, Ph = a._Maximum = function() {
        return (Ph = a._Maximum = a.asm.Maximum).apply(null, arguments);
      }, zh = a._Mean = function() {
        return (zh = a._Mean = a.asm.Mean).apply(null, arguments);
      }, Mh = a._Min = function() {
        return (Mh = a._Min = a.asm.Min).apply(null, arguments);
      }, Lh = a._Minimum = function() {
        return (Lh = a._Minimum = a.asm.Minimum).apply(null, arguments);
      }, Bh = a._MirrorPad = function() {
        return (Bh = a._MirrorPad = a.asm.MirrorPad).apply(null, arguments);
      }, Vh = a._Multiply = function() {
        return (Vh = a._Multiply = a.asm.Multiply).apply(null, arguments);
      }, gt = a._Neg = function() {
        return (gt = a._Neg = a.asm.Neg).apply(null, arguments);
      }, Wh = a._NonMaxSuppressionV3 = function() {
        return (Wh = a._NonMaxSuppressionV3 = a.asm.NonMaxSuppressionV3).apply(null, arguments);
      }, Uh = a._NonMaxSuppressionV4 = function() {
        return (Uh = a._NonMaxSuppressionV4 = a.asm.NonMaxSuppressionV4).apply(null, arguments);
      }, Gh = a._NonMaxSuppressionV5 = function() {
        return (Gh = a._NonMaxSuppressionV5 = a.asm.NonMaxSuppressionV5).apply(null, arguments);
      }, _i = a._NotEqual = function() {
        return (_i = a._NotEqual = a.asm.NotEqual).apply(null, arguments);
      }, Tc = a._OneHot = function() {
        return (Tc = a._OneHot = a.asm.OneHot).apply(null, arguments);
      }, $c = a._PadV2 = function() {
        return ($c = a._PadV2 = a.asm.PadV2).apply(null, arguments);
      }, _c = a._Pow = function() {
        return (_c = a._Pow = a.asm.Pow).apply(null, arguments);
      }, Hh = a._Prelu = function() {
        return (Hh = a._Prelu = a.asm.Prelu).apply(null, arguments);
      }, Ac = a._Prod = function() {
        return (Ac = a._Prod = a.asm.Prod).apply(null, arguments);
      }, qh = a._RealDiv = function() {
        return (qh = a._RealDiv = a.asm.RealDiv).apply(null, arguments);
      }, Uv = a._Relu = function() {
        return (Uv = a._Relu = a.asm.Relu).apply(null, arguments);
      }, Ec = a._Relu6 = function() {
        return (Ec = a._Relu6 = a.asm.Relu6).apply(null, arguments);
      }, Gv = a._ResizeBilinear = function() {
        return (Gv = a._ResizeBilinear = a.asm.ResizeBilinear).apply(null, arguments);
      }, jh = a._Reverse = function() {
        return (jh = a._Reverse = a.asm.Reverse).apply(null, arguments);
      }, Kh = a._RotateWithOffset = function() {
        return (Kh = a._RotateWithOffset = a.asm.RotateWithOffset).apply(null, arguments);
      }, Xh = a._Round = function() {
        return (Xh = a._Round = a.asm.Round).apply(null, arguments);
      }, Yh = a._Rsqrt = function() {
        return (Yh = a._Rsqrt = a.asm.Rsqrt).apply(null, arguments);
      }, Qh = a._ScatterNd = function() {
        return (Qh = a._ScatterNd = a.asm.ScatterNd).apply(null, arguments);
      }, Zh = a._SelectV2 = function() {
        return (Zh = a._SelectV2 = a.asm.SelectV2).apply(null, arguments);
      }, Jh = a._Sigmoid = function() {
        return (Jh = a._Sigmoid = a.asm.Sigmoid).apply(null, arguments);
      }, ef = a._Sin = function() {
        return (ef = a._Sin = a.asm.Sin).apply(null, arguments);
      }, tf = a._Softmax = function() {
        return (tf = a._Softmax = a.asm.Softmax).apply(null, arguments);
      }, nf = a._SparseFillEmptyRows = function() {
        return (nf = a._SparseFillEmptyRows = a.asm.SparseFillEmptyRows).apply(null, arguments);
      }, sf = a._SparseReshape = function() {
        return (sf = a._SparseReshape = a.asm.SparseReshape).apply(null, arguments);
      }, rf = a._SparseSegmentReduction = function() {
        return (rf = a._SparseSegmentReduction = a.asm.SparseSegmentReduction).apply(null, arguments);
      }, af = a._Sqrt = function() {
        return (af = a._Sqrt = a.asm.Sqrt).apply(null, arguments);
      }, of = a._Square = function() {
        return (of = a._Square = a.asm.Square).apply(null, arguments);
      }, uf = a._SquaredDifference = function() {
        return (uf = a._SquaredDifference = a.asm.SquaredDifference).apply(null, arguments);
      }, lf = a._Step = function() {
        return (lf = a._Step = a.asm.Step).apply(null, arguments);
      }, cf = a._StridedSlice = function() {
        return (cf = a._StridedSlice = a.asm.StridedSlice).apply(null, arguments);
      }, df = a._Sub = function() {
        return (df = a._Sub = a.asm.Sub).apply(null, arguments);
      }, pf = a._Sum = function() {
        return (pf = a._Sum = a.asm.Sum).apply(null, arguments);
      }, hf = a._Tan = function() {
        return (hf = a._Tan = a.asm.Tan).apply(null, arguments);
      }, ff = a._Tanh = function() {
        return (ff = a._Tanh = a.asm.Tanh).apply(null, arguments);
      }, mf = a._Tile = function() {
        return (mf = a._Tile = a.asm.Tile).apply(null, arguments);
      }, gf = a._TopK = function() {
        return (gf = a._TopK = a.asm.TopK).apply(null, arguments);
      }, bf = a._Transform = function() {
        return (bf = a._Transform = a.asm.Transform).apply(null, arguments);
      }, yf = a._Transpose = function() {
        return (yf = a._Transpose = a.asm.Transpose).apply(null, arguments);
      }, vf = a.__FusedMatMul = function() {
        return (vf = a.__FusedMatMul = a.asm._FusedMatMul).apply(null, arguments);
      }, xf = a._malloc = function() {
        return (xf = a._malloc = a.asm.malloc).apply(null, arguments);
      }, wf = a._free = function() {
        return (wf = a._free = a.asm.free).apply(null, arguments);
      }, kf = a.___errno_location = function() {
        return (kf = a.___errno_location = a.asm.__errno_location).apply(null, arguments);
      }, If = a._emscripten_main_thread_process_queued_calls = function() {
        return (If = a._emscripten_main_thread_process_queued_calls = a.asm.emscripten_main_thread_process_queued_calls).apply(null, arguments);
      }, Rc = a.stackSave = function() {
        return (Rc = a.stackSave = a.asm.stackSave).apply(null, arguments);
      }, Dc = a.stackRestore = function() {
        return (Dc = a.stackRestore = a.asm.stackRestore).apply(null, arguments);
      }, vu = a.stackAlloc = function() {
        return (vu = a.stackAlloc = a.asm.stackAlloc).apply(null, arguments);
      }, Sf = a.dynCall_iijjiiii = function() {
        return (Sf = a.dynCall_iijjiiii = a.asm.dynCall_iijjiiii).apply(null, arguments);
      }, Cf = a.dynCall_jiji = function() {
        return (Cf = a.dynCall_jiji = a.asm.dynCall_jiji).apply(null, arguments);
      };
      a.cwrap = Se;
      var Ai;
      function xu(H) {
        this.name = "ExitStatus", this.message = "Program terminated with exit(" + H + ")", this.status = H;
      }
      er = function H() {
        Ai || wu(), Ai || (er = H);
      };
      function wu(H) {
        if (H = H || c, Fn > 0 || (uc(), Fn > 0))
          return;
        function J() {
          Ai || (Ai = true, a.calledRun = true, !oe && (lc(), i(a), a.onRuntimeInitialized && a.onRuntimeInitialized(), cc()));
        }
        a.setStatus ? (a.setStatus("Running..."), setTimeout(function() {
          setTimeout(function() {
            a.setStatus("");
          }, 1), J();
        }, 1)) : J();
      }
      a.run = wu;
      function Hv(H) {
        re = H, hu() || (a.onExit && a.onExit(H), oe = true), d(H, new xu(H));
      }
      if (a.preInit)
        for (typeof a.preInit == "function" && (a.preInit = [a.preInit]); a.preInit.length > 0; )
          a.preInit.pop()();
      wu();
      var Ei;
      u && (Ei = { uncaughtException: process.listeners("uncaughtException").filter(function(H) {
        return !u.uncaughtException.indexOf(H) > -1;
      }), unhandledRejection: process.listeners("unhandledRejection").filter(function(H) {
        return !u.unhandledRejection.indexOf(H) > -1;
      }) });
      var Ri;
      if (typeof r != "undefined")
        Ri = r;
      else if (typeof WasmBackendModuleThreadedSimd != "undefined")
        Ri = WasmBackendModuleThreadedSimd;
      else
        throw new Error("Could not find wasm module in post.js");
      if (Ei) {
        var Nf = Ri._dispose;
        Ri._dispose = function() {
          Nf(), Ei.uncaughtException.forEach(function(H) {
            process.removeListener("uncaughtException", H);
          }), Ei.unhandledRejection.forEach(function(H) {
            process.removeListener("unhandledRejection", H);
          });
        };
      }
      return r.ready;
    };
  })();
  typeof e == "object" && typeof t == "object" ? t.exports = n : typeof define == "function" && define.amd ? define([], function() {
    return n;
  }) : typeof e == "object" && (e.WasmBackendModule = n);
} });
var o$ = 1e-7;
var u$ = 1e-4;
var Ud = class {
  constructor(e, t) {
    this.backend = e, this.dataMover = t, this.data = /* @__PURE__ */ new WeakMap(), this.dataIdsCount = 0;
  }
  get(e) {
    return this.data.has(e) || this.dataMover.moveData(this.backend, e), this.data.get(e);
  }
  set(e, t) {
    this.dataIdsCount++, this.data.set(e, t);
  }
  has(e) {
    return this.data.has(e);
  }
  delete(e) {
    return this.dataIdsCount--, this.data.delete(e);
  }
  numDataIds() {
    return this.dataIdsCount;
  }
};
var nl = class {
  refCount(e) {
    return On("refCount");
  }
  incRef(e) {
    return On("incRef");
  }
  timerAvailable() {
    return true;
  }
  time(e) {
    return On("time");
  }
  read(e) {
    return On("read");
  }
  readSync(e) {
    return On("readSync");
  }
  readToGPU(e, t) {
    return On("readToGPU");
  }
  numDataIds() {
    return On("numDataIds");
  }
  disposeData(e, t) {
    return On("disposeData");
  }
  write(e, t, n) {
    return On("write");
  }
  move(e, t, n, s, r) {
    return On("move");
  }
  memory() {
    return On("memory");
  }
  floatPrecision() {
    return On("floatPrecision");
  }
  epsilon() {
    return this.floatPrecision() === 32 ? o$ : u$;
  }
  dispose() {
    return On("dispose");
  }
};
function On(e) {
  throw new Error(`'${e}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`);
}
function Uw(e) {
  let t = e.length, n = 0;
  for (; t > 0; )
    n = Math.random() * t | 0, t--, pd(e, t, n);
}
function l$(e, t) {
  if (e.length !== t.length)
    throw new Error(`Array sizes must match to be shuffled together First array length was ${e.length}Second array length was ${t.length}`);
  let n = e.length, s = 0;
  for (; n > 0; )
    s = Math.random() * n | 0, n--, pd(e, n, s), pd(t, n, s);
}
function Vu(e, t, n) {
  return Math.max(e, Math.min(t, n));
}
function c$(e) {
  return e % 2 === 0 ? e : e + 1;
}
function pd(e, t, n) {
  let s = e[t];
  e[t] = e[n], e[n] = s;
}
function d$(e) {
  let t = 0;
  for (let n = 0; n < e.length; n++)
    t += e[n];
  return t;
}
function p$(e, t) {
  let n = Math.random();
  return t * n + (1 - n) * e;
}
function h$(e, t) {
  let n = 0;
  for (let s = 0; s < e.length; s++) {
    let r = Number(e[s]) - Number(t[s]);
    n += r * r;
  }
  return n;
}
function O(e, t) {
  if (!e)
    throw new Error(typeof t == "string" ? t : t());
}
function pn(e, t, n = "") {
  O(kr(e, t), () => n + ` Shapes ${e} and ${t} must match`);
}
function wa(e) {
  O(e != null, () => "The input to the tensor constructor must be a non-null value.");
}
function sa(e, t = [], n = false) {
  if (t == null && (t = []), Array.isArray(e) || Qt(e) && !n)
    for (let s = 0; s < e.length; ++s)
      sa(e[s], t, n);
  else
    t.push(e);
  return t;
}
function pt(e) {
  if (e.length === 0)
    return 1;
  let t = e[0];
  for (let n = 1; n < e.length; n++)
    t *= e[n];
  return t;
}
function f$(e) {
  return e.length === 0;
}
function kr(e, t) {
  if (e === t)
    return true;
  if (e == null || t == null || e.length !== t.length)
    return false;
  for (let n = 0; n < e.length; n++)
    if (e[n] !== t[n])
      return false;
  return true;
}
function Yi(e) {
  return e % 1 === 0;
}
function m$(e) {
  if (Math.tanh != null)
    return Math.tanh(e);
  if (e === 1 / 0)
    return 1;
  if (e === -1 / 0)
    return -1;
  {
    let t = Math.exp(2 * e);
    return (t - 1) / (t + 1);
  }
}
function g$(e) {
  let t = Math.ceil(Math.sqrt(e));
  return [t, Math.ceil(e / t)];
}
function b$(e) {
  let t = new Uint32Array(e);
  for (let n = 0; n < e; ++n)
    t[n] = n;
  return Uw(t), t;
}
function zu(e, t) {
  return t <= e.length ? e : e + " ".repeat(t - e.length);
}
function y$(e, t = (s) => 0, n) {
  return new Promise((s, r) => {
    let a = 0, i = () => {
      if (e()) {
        s();
        return;
      }
      a++;
      let o = t(a);
      if (n != null && a >= n) {
        r();
        return;
      }
      setTimeout(i, o);
    };
    i();
  });
}
function v$(e, t) {
  let n = 1, s = -1;
  for (let a = 0; a < e.length; ++a)
    if (e[a] >= 0)
      n *= e[a];
    else if (e[a] === -1) {
      if (s !== -1)
        throw Error(`Shapes can only have 1 implicit size. Found -1 at dim ${s} and dim ${a}`);
      s = a;
    } else if (e[a] < 0)
      throw Error(`Shapes can not be < 0. Found ${e[a]} at dim ${a}`);
  if (s === -1) {
    if (t > 0 && t !== n)
      throw Error(`Size(${t}) must match the product of shape ${e}`);
    return e;
  }
  if (n === 0)
    throw Error(`Cannot infer the missing size in [${e}] when there are 0 elements`);
  if (t % n !== 0)
    throw Error(`The implicit shape can't be a fractional number. Got ${t} / ${n}`);
  let r = e.slice();
  return r[s] = t / n, r;
}
function ts(e, t) {
  let n = t.length;
  return e = e == null ? t.map((s, r) => r) : [].concat(e), O(e.every((s) => s >= -n && s < n), () => `All values in axis param must be in range [-${n}, ${n}) but got axis ${e}`), O(e.every((s) => Yi(s)), () => `All values in axis param must be integers but got axis ${e}`), e.map((s) => s < 0 ? n + s : s);
}
function Gw(e, t) {
  let n = [], s = [], r = t != null && Array.isArray(t) && t.length === 0, a = t == null || r ? null : ts(t, e).sort(), i = 0;
  for (let o = 0; o < e.length; ++o) {
    if (a != null) {
      if (a[i] === o && e[o] !== 1)
        throw new Error(`Can't squeeze axis ${o} since its dim '${e[o]}' is not 1`);
      (a[i] == null || a[i] > o) && e[o] === 1 && (n.push(e[o]), s.push(o)), a[i] <= o && i++;
    }
    e[o] !== 1 && (n.push(e[o]), s.push(o));
  }
  return { newShape: n, keptDims: s };
}
function Hw(e, t) {
  let n = null;
  if (e == null || e === "float32")
    n = new Float32Array(t);
  else if (e === "int32")
    n = new Int32Array(t);
  else if (e === "bool")
    n = new Uint8Array(t);
  else
    throw new Error(`Unknown data type ${e}`);
  return n;
}
function qw(e, t) {
  let n = null;
  if (e == null || e === "float32")
    n = new Float32Array(t);
  else if (e === "int32")
    n = new Int32Array(t);
  else if (e === "bool")
    n = new Uint8Array(t);
  else if (e === "string")
    n = new Array(t);
  else
    throw new Error(`Unknown data type ${e}`);
  return n;
}
function jw(e, t) {
  for (let n = 0; n < e.length; n++) {
    let s = e[n];
    if (isNaN(s) || !isFinite(s))
      throw Error(`A tensor of type ${t} being uploaded contains ${s}.`);
  }
}
function Kw(e) {
  return e === "bool" || e === "complex64" || e === "float32" || e === "int32" || e === "string";
}
function x$(e, t) {
  return !(t === "complex64" || t === "float32" && e !== "complex64" || t === "int32" && e !== "float32" && e !== "complex64" || t === "bool" && e === "bool");
}
function Qt(e) {
  return e instanceof Float32Array || e instanceof Int32Array || e instanceof Uint8Array || e instanceof Uint8ClampedArray;
}
function Xf(e) {
  if (e === "float32" || e === "int32")
    return 4;
  if (e === "complex64")
    return 8;
  if (e === "bool")
    return 1;
  throw new Error(`Unknown dtype ${e}`);
}
function Xw(e) {
  if (e == null)
    return 0;
  let t = 0;
  return e.forEach((n) => t += n.length), t;
}
function ir(e) {
  return typeof e == "string" || e instanceof String;
}
function Yw(e) {
  return typeof e == "boolean";
}
function Qw(e) {
  return typeof e == "number";
}
function Gd(e) {
  return Array.isArray(e) ? Gd(e[0]) : e instanceof Float32Array ? "float32" : e instanceof Int32Array || e instanceof Uint8Array || e instanceof Uint8ClampedArray ? "int32" : Qw(e) ? "float32" : ir(e) ? "string" : Yw(e) ? "bool" : "float32";
}
function hr(e) {
  return !!(e && e.constructor && e.call && e.apply);
}
function hd(e, t) {
  for (let n = t; n < e; ++n)
    if (e % n === 0)
      return n;
  return e;
}
function ao(e) {
  let t = e.length;
  if (t < 2)
    return [];
  let n = new Array(t - 1);
  n[t - 2] = e[t - 1];
  for (let s = t - 3; s >= 0; --s)
    n[s] = n[s + 1] * e[s + 1];
  return n;
}
function Zw(e, t, n, s = false) {
  let r = new Array();
  if (t.length === 1) {
    let a = t[0] * (s ? 2 : 1);
    for (let i = 0; i < a; i++)
      r[i] = n[e + i];
  } else {
    let a = t[0], i = t.slice(1), o = i.reduce((u, l) => u * l) * (s ? 2 : 1);
    for (let u = 0; u < a; u++)
      r[u] = Zw(e + u * o, i, n, s);
  }
  return r;
}
function Hi(e, t, n = false) {
  if (e.length === 0)
    return t[0];
  let s = e.reduce((r, a) => r * a) * (n ? 2 : 1);
  if (s === 0)
    return [];
  if (s !== t.length)
    throw new Error(`[${e}] does not match the input size ${t.length}${n ? " for a complex tensor" : ""}.`);
  return Zw(0, e, t, n);
}
function ng(e, t) {
  let n = Hd(e, t);
  for (let s = 0; s < n.length; s++)
    n[s] = 1;
  return n;
}
function Hd(e, t) {
  if (t == null || t === "float32" || t === "complex64")
    return new Float32Array(e);
  if (t === "int32")
    return new Int32Array(e);
  if (t === "bool")
    return new Uint8Array(e);
  throw new Error(`Unknown data type ${t}`);
}
function w$(e, t) {
  let n = e.reduce((s, r) => s * r, 1);
  if (t == null || t === "float32")
    return Hi(e, new Float32Array(n));
  if (t === "int32")
    return Hi(e, new Int32Array(n));
  if (t === "bool")
    return Hi(e, new Uint8Array(n));
  throw new Error(`Unknown data type ${t}`);
}
function sg(e) {
  e.forEach((t) => {
    O(Number.isInteger(t) && t >= 0, () => `Tensor must have a shape comprised of positive integers but got shape [${e}].`);
  });
}
function k$(e, t, n) {
  if (t === 0)
    return 0;
  if (t === 1)
    return e[0];
  let s = e[e.length - 1];
  for (let r = 0; r < e.length - 1; ++r)
    s += n[r] * e[r];
  return s;
}
function I$(e, t, n) {
  if (t === 0)
    return [];
  if (t === 1)
    return [e];
  let s = new Array(t);
  for (let r = 0; r < s.length - 1; ++r)
    s[r] = Math.floor(e / n[r]), e -= s[r] * n[r];
  return s[s.length - 1] = e, s;
}
function rg(e) {
  return e && e.then && typeof e.then == "function";
}
var tx = "tfjsflags";
var S$ = class {
  constructor(e) {
    this.global = e, this.flags = {}, this.flagRegistry = {}, this.urlFlags = {}, this.getQueryParams = C$, this.populateURLFlags();
  }
  setPlatform(e, t) {
    this.platform != null && (X().getBool("IS_TEST") || X().getBool("PROD") || console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${e}.`)), this.platformName = e, this.platform = t;
  }
  registerFlag(e, t, n) {
    if (this.flagRegistry[e] = { evaluationFn: t, setHook: n }, this.urlFlags[e] != null) {
      let s = this.urlFlags[e];
      X().getBool("IS_TEST") || X().getBool("PROD") || console.warn(`Setting feature override from URL ${e}: ${s}.`), this.set(e, s);
    }
  }
  async getAsync(e) {
    return e in this.flags ? this.flags[e] : (this.flags[e] = await this.evaluateFlag(e), this.flags[e]);
  }
  get(e) {
    if (e in this.flags)
      return this.flags[e];
    let t = this.evaluateFlag(e);
    if (rg(t))
      throw new Error(`Flag ${e} cannot be synchronously evaluated. Please use getAsync() instead.`);
    return this.flags[e] = t, this.flags[e];
  }
  getNumber(e) {
    return this.get(e);
  }
  getBool(e) {
    return this.get(e);
  }
  getFlags() {
    return this.flags;
  }
  get features() {
    return this.flags;
  }
  set(e, t) {
    if (this.flagRegistry[e] == null)
      throw new Error(`Cannot set flag ${e} as it has not been registered.`);
    this.flags[e] = t, this.flagRegistry[e].setHook != null && this.flagRegistry[e].setHook(t);
  }
  evaluateFlag(e) {
    if (this.flagRegistry[e] == null)
      throw new Error(`Cannot evaluate flag '${e}': no evaluation function found.`);
    return this.flagRegistry[e].evaluationFn();
  }
  setFlags(e) {
    this.flags = Object.assign({}, e);
  }
  reset() {
    this.flags = {}, this.urlFlags = {}, this.populateURLFlags();
  }
  populateURLFlags() {
    if (typeof this.global == "undefined" || typeof this.global.location == "undefined" || typeof this.global.location.search == "undefined")
      return;
    let e = this.getQueryParams(this.global.location.search);
    tx in e && e[tx].split(",").forEach((n) => {
      let [s, r] = n.split(":");
      this.urlFlags[s] = T$(s, r);
    });
  }
};
function C$(e) {
  let t = {};
  return e.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g, (n, ...s) => (N$(t, s[0], s[1]), s.join("="))), t;
}
function N$(e, t, n) {
  e[decodeURIComponent(t)] = decodeURIComponent(n || "");
}
function T$(e, t) {
  if (t = t.toLowerCase(), t === "true" || t === "false")
    return t === "true";
  if (`${+t}` === t)
    return +t;
  throw new Error(`Could not parse value flag value ${t} for flag ${e}.`);
}
function X() {
  return Jw;
}
var Jw = null;
function $$(e) {
  Jw = e;
}
var Df;
function ek() {
  if (Df == null) {
    let e;
    if (typeof window != "undefined")
      e = window;
    else if (typeof global != "undefined")
      e = global;
    else if (typeof process != "undefined")
      e = process;
    else if (typeof self != "undefined")
      e = self;
    else
      throw new Error("Could not find a global object");
    Df = e;
  }
  return Df;
}
function _$() {
  let e = ek();
  return e._tfGlobals == null && (e._tfGlobals = /* @__PURE__ */ new Map()), e._tfGlobals;
}
function ag(e, t) {
  let n = _$();
  if (n.has(e))
    return n.get(e);
  {
    let s = t();
    return n.set(e, s), n.get(e);
  }
}
var io = "Abs";
var sl = "Acos";
var rl = "Acosh";
var Ir = "Add";
var ka = "AddN";
var al = "All";
var il = "Any";
var Ia = "ArgMax";
var ol = "ArgMin";
var ul = "Asin";
var ll = "Asinh";
var cl = "Atan";
var dl = "Atanh";
var pl = "Atan2";
var Sa = "AvgPool";
var ig = "AvgPoolGrad";
var qd = "AvgPool3D";
var og = "AvgPool3DGrad";
var Ca = "BatchMatMul";
var oo = "BatchToSpaceND";
var ug = "Bincount";
var A$ = "BroadcastTo";
var lg = "BroadcastArgs";
var Na = "Cast";
var Ta = "Ceil";
var Sr = "ClipByValue";
var jd = "Complex";
var Kd = "ComplexAbs";
var uo = "Concat";
var $a = "Conv2D";
var cg = "Conv2DBackpropFilter";
var _a = "Conv2DBackpropInput";
var Xd = "Conv3D";
var dg = "Conv3DBackpropFilterV2";
var pg = "Conv3DBackpropInputV2";
var Aa = "Cos";
var Ea = "Cosh";
var hl = "Cumprod";
var lo = "Cumsum";
var co = "CropAndResize";
var hg = "DenseBincount";
var po = "DepthToSpace";
var Ra = "DepthwiseConv2dNative";
var fg = "DepthwiseConv2dNativeBackpropFilter";
var mg = "DepthwiseConv2dNativeBackpropInput";
var gg = "Diag";
var Yd = "Dilation2D";
var Yf = "Dilation2DBackpropInput";
var Qf = "Dilation2DBackpropFilter";
var Da = "RealDiv";
var Qd = "Einsum";
var Fa = "Elu";
var bg = "EluGrad";
var fl = "Erf";
var ho = "Equal";
var Oa = "Exp";
var fo = "ExpandDims";
var mo = "Expm1";
var yg = "FFT";
var ml = "Fill";
var go = "FlipLeftRight";
var Pa = "Floor";
var za = "FloorDiv";
var Ma = "FusedBatchNorm";
var bo = "GatherV2";
var yo = "GatherNd";
var vo = "Greater";
var La = "GreaterEqual";
var Ba = "Identity";
var vg = "IFFT";
var Zd = "Imag";
var gl = "IsFinite";
var bl = "IsInf";
var yl = "IsNan";
var Va = "LeakyRelu";
var xo = "Less";
var wo = "LessEqual";
var xg = "LinSpace";
var Wa = "Log";
var vl = "Log1p";
var ko = "LogicalAnd";
var xl = "LogicalNot";
var Jd = "LogicalOr";
var E$ = "LogSoftmax";
var ep = "LRN";
var wg = "LRNGrad";
var Ua = "Max";
var Ga = "Maximum";
var Ha = "MaxPool";
var kg = "MaxPoolGrad";
var tp = "MaxPool3D";
var Ig = "MaxPool3DGrad";
var Sg = "MaxPoolWithArgmax";
var qa = "Mean";
var ja = "Min";
var Ka = "Minimum";
var Xa = "MirrorPad";
var wl = "Mod";
var Cg = "Multinomial";
var Ya = "Multiply";
var Io = "Neg";
var So = "NotEqual";
var Co = "NonMaxSuppressionV3";
var kl = "NonMaxSuppressionV4";
var No = "NonMaxSuppressionV5";
var To = "OnesLike";
var $o = "OneHot";
var _o = "Pack";
var Qa = "PadV2";
var $de = "Pool";
var Za = "Pow";
var Ja = "Prelu";
var Ao = "Prod";
var Il = "Range";
var np = "Real";
var Sl = "Reciprocal";
var ei = "Relu";
var Eo = "Reshape";
var Cl = "ResizeNearestNeighbor";
var Ng = "ResizeNearestNeighborGrad";
var ti = "ResizeBilinear";
var Tg = "ResizeBilinearGrad";
var ni = "Relu6";
var Ro = "Reverse";
var Do = "Round";
var si = "Rsqrt";
var Fo = "ScatterNd";
var Oo = "Select";
var Nl = "Selu";
var Po = "Slice";
var ri = "Sin";
var zo = "Sinh";
var Tl = "Sign";
var ai = "Sigmoid";
var $l = "Softplus";
var ii = "Sqrt";
var oi = "Sum";
var Mo = "SpaceToBatchND";
var Lo = "SplitV";
var ui = "Softmax";
var sp = "SparseFillEmptyRows";
var _l = "SparseReshape";
var rp = "SparseSegmentMean";
var ap = "SparseSegmentSum";
var ip = "SparseToDense";
var li = "SquaredDifference";
var Al = "Square";
var Bo = "StridedSlice";
var op = "StringNGrams";
var $g = "StringSplit";
var _g = "StringToHashBucketFast";
var ci = "Sub";
var Vo = "Tan";
var di = "Tanh";
var Cr = "Tile";
var Wo = "TopK";
var Uo = "Transform";
var pi = "Transpose";
var Ag = "Unique";
var Go = "Unpack";
var up = "UnsortedSegmentSum";
var Ho = "ZerosLike";
var hi = "Step";
var fd = "FromPixels";
var qo = "RotateWithOffset";
var ra = "_FusedMatMul";
var aa = "FusedConv2D";
var ia = "FusedDepthwiseConv2D";
function ar(...e) {
  X().getBool("IS_TEST") || X().getBool("PROD") || console.warn(...e);
}
function R$(...e) {
  X().getBool("IS_TEST") || X().getBool("PROD") || console.log(...e);
}
var Qi = ag("kernelRegistry", () => /* @__PURE__ */ new Map());
var Wu = ag("gradRegistry", () => /* @__PURE__ */ new Map());
function Zf(e, t) {
  let n = Eg(e, t);
  return Qi.get(n);
}
function nx(e) {
  return Wu.get(e);
}
function Jf(e) {
  let t = Qi.entries(), n = [];
  for (; ; ) {
    let { done: s, value: r } = t.next();
    if (s)
      break;
    let [a, i] = r, [o] = a.split("_");
    o === e && n.push(i);
  }
  return n;
}
function El(e) {
  let { kernelName: t, backendName: n } = e, s = Eg(t, n);
  Qi.has(s) && ar(`The kernel '${t}' for backend '${n}' is already registered`), Qi.set(s, e);
}
function D$(e) {
  let { kernelName: t } = e;
  Wu.has(t) && X().getBool("DEBUG") && ar(`Overriding the gradient for '${t}'`), Wu.set(t, e);
}
function _de(e, t) {
  let n = Eg(e, t);
  if (!Qi.has(n))
    throw new Error(`The kernel '${e}' for backend '${t}' is not registered`);
  Qi.delete(n);
}
function Ade(e) {
  if (!Wu.has(e))
    throw new Error(`The gradient '${e}' for backend is not registered`);
  Wu.delete(e);
}
function Ede(e, t) {
  Jf(e).forEach((s) => {
    let r = Object.assign({}, s, { backendName: t });
    El(r);
  });
}
function Eg(e, t) {
  return `${t}_${e}`;
}
var w = {};
Ae(w, { arraysEqual: () => kr, assert: () => O, assertNonNegativeIntegerDimensions: () => sg, assertNonNull: () => wa, assertShapesMatch: () => pn, bytesFromStringArray: () => Xw, bytesPerElement: () => Xf, checkConversionForErrors: () => jw, clamp: () => Vu, computeStrides: () => ao, createScalarValue: () => L$, createShuffledIndices: () => b$, decodeString: () => md, distSquared: () => h$, encodeString: () => Dl, fetch: () => V$, fingerPrint64: () => M$, flatten: () => sa, getArrayFromDType: () => qw, getTypedArrayFromDType: () => Hw, hasEncodingLoss: () => x$, hexToLong: () => Rl, indexToLoc: () => I$, inferDtype: () => Gd, inferFromImplicitShape: () => v$, isBoolean: () => Yw, isFunction: () => hr, isInt: () => Yi, isNumber: () => Qw, isPromise: () => rg, isScalarShape: () => f$, isString: () => ir, isTypedArray: () => Qt, isValidDtype: () => Kw, locToIndex: () => k$, makeOnesTypedArray: () => ng, makeZerosNestedTypedArray: () => w$, makeZerosTypedArray: () => Hd, nearestDivisor: () => hd, nearestLargerEven: () => c$, now: () => Uu, parseAxisParam: () => ts, randUniform: () => p$, repeatedTry: () => y$, rightPad: () => zu, shuffle: () => Uw, shuffleCombo: () => l$, sizeFromShape: () => pt, sizeToSquarishShape: () => g$, squeezeShape: () => Gw, sum: () => d$, swap: () => pd, tanh: () => m$, toNestedArray: () => Hi, toTypedArray: () => lp });
var sx = xa(HT());
var qr = sx.default || sx;
function Rl(e) {
  return qr.fromString(e, true, 16);
}
var tk = Rl("c3a5c85c97cb3127");
var Gr = Rl("b492b66fbe98f273");
var on = Rl("9ae16a3b2f90404f");
function em(e) {
  return e.xor(e.shru(47));
}
function nk(e, t, n) {
  let s = e.slice(t, t + n);
  return qr.fromBytes(Array.from(s), true, true);
}
function lt(e, t) {
  return nk(e, t, 8);
}
function rx(e, t) {
  return nk(e, t, 4);
}
function Lt(e, t) {
  return t === 0 ? e : e.shru(t).or(e.shl(64 - t));
}
function ur(e, t, n = Rl("9ddfea08eb382d69")) {
  let s = e.xor(t).mul(n);
  s = s.xor(s.shru(47));
  let r = t.xor(s).mul(n);
  return r = r.xor(r.shru(47)), r = r.mul(n), r;
}
function F$(e, t, n, s, r, a) {
  r = r.add(e), a = Lt(a.add(r).add(s), 21);
  let i = r;
  return r = r.add(t), r = r.add(n), a = a.add(Lt(r, 44)), [r.add(s), a.add(i)];
}
function Vc(e, t, n, s) {
  return F$(lt(e, t), lt(e, t + 8), lt(e, t + 16), lt(e, t + 24), n, s);
}
function O$(e, t = e.length) {
  if (t >= 8) {
    let n = on.add(t * 2), s = lt(e, 0).add(on), r = lt(e, t - 8), a = Lt(r, 37).mul(n).add(s), i = Lt(s, 25).add(r).mul(n);
    return ur(a, i, n);
  }
  if (t >= 4) {
    let n = on.add(t * 2), s = rx(e, 0);
    return ur(s.shl(3).add(t), rx(e, t - 4), n);
  }
  if (t > 0) {
    let n = e[0], s = e[t >> 1], r = e[t - 1], a = n + (s << 8), i = t + (r << 2);
    return em(on.mul(a).xor(tk.mul(i))).mul(on);
  }
  return on;
}
function P$(e, t = e.length) {
  let n = on.add(t * 2), s = lt(e, 0).mul(Gr), r = lt(e, 8), a = lt(e, t - 8).mul(n), i = lt(e, t - 16).mul(on);
  return ur(Lt(s.add(r), 43).add(Lt(a, 30)).add(i), s.add(Lt(r.add(on), 18)).add(a), n);
}
function z$(e, t = e.length) {
  let n = on.add(t * 2), s = lt(e, 0).mul(on), r = lt(e, 8), a = lt(e, t - 8).mul(n), i = lt(e, t - 16).mul(on), o = Lt(s.add(r), 43).add(Lt(a, 30)).add(i), u = ur(o, s.add(Lt(r.add(on), 18)).add(a), n), l = lt(e, 16).mul(n), c = lt(e, 24), p = o.add(lt(e, t - 32)).mul(n), d = u.add(lt(e, t - 24)).mul(n);
  return ur(Lt(l.add(c), 43).add(Lt(p, 30)).add(d), l.add(Lt(c.add(s), 18)).add(p), n);
}
function M$(e, t = e.length) {
  let n = qr.fromNumber(81, true);
  if (t <= 32)
    return t <= 16 ? O$(e, t) : P$(e, t);
  if (t <= 64)
    return z$(e, t);
  let s = n, r = n.mul(Gr).add(113), a = em(r.mul(on).add(113)).mul(on), i = [qr.UZERO, qr.UZERO], o = [qr.UZERO, qr.UZERO];
  s = s.mul(on).add(lt(e, 0));
  let u = 0, l = (t - 1 >> 6) * 64, c = l + (t - 1 & 63) - 63;
  do
    s = Lt(s.add(r).add(i[0]).add(lt(e, u + 8)), 37).mul(Gr), r = Lt(r.add(i[1]).add(lt(e, u + 48)), 42).mul(Gr), s = s.xor(o[1]), r = r.add(i[0]).add(lt(e, u + 40)), a = Lt(a.add(o[0]), 33).mul(Gr), i = Vc(e, u, i[1].mul(Gr), s.add(o[0])), o = Vc(e, u + 32, a.add(o[1]), r.add(lt(e, u + 16))), [a, s] = [s, a], u += 64;
  while (u !== l);
  let p = Gr.add(a.and(255).shl(1));
  return u = c, o[0] = o[0].add(t - 1 & 63), i[0] = i[0].add(o[0]), o[0] = o[0].add(i[0]), s = Lt(s.add(r).add(i[0]).add(lt(e, u + 8)), 37).mul(p), r = Lt(r.add(i[1]).add(lt(e, u + 48)), 42).mul(p), s = s.xor(o[1].mul(9)), r = r.add(i[0].mul(9).add(lt(e, u + 40))), a = Lt(a.add(o[0]), 33).mul(p), i = Vc(e, u, i[1].mul(p), s.add(o[0])), o = Vc(e, u + 32, a.add(o[1]), r.add(lt(e, u + 16))), [a, s] = [s, a], ur(ur(i[0], o[0], p).add(em(r).mul(tk)).add(a), ur(i[1], o[1], p).add(s), p);
}
function L$(e, t) {
  return t === "string" ? Dl(e) : lp([e], t);
}
function B$(e, t) {
  return e instanceof Float32Array && t === "float32" || e instanceof Int32Array && t === "int32" || e instanceof Uint8Array && t === "bool";
}
function lp(e, t) {
  if (t === "string")
    throw new Error("Cannot convert a string[] to a TypedArray");
  if (Array.isArray(e) && (e = sa(e)), X().getBool("DEBUG") && jw(e, t), B$(e, t))
    return e;
  if (t == null || t === "float32" || t === "complex64")
    return new Float32Array(e);
  if (t === "int32")
    return new Int32Array(e);
  if (t === "bool") {
    let n = new Uint8Array(e.length);
    for (let s = 0; s < n.length; ++s)
      Math.round(e[s]) !== 0 && (n[s] = 1);
    return n;
  } else
    throw new Error(`Unknown data type ${t}`);
}
function Uu() {
  return X().platform.now();
}
function V$(e, t) {
  return X().platform.fetch(e, t);
}
function Dl(e, t = "utf-8") {
  return t = t || "utf-8", X().platform.encode(e, t);
}
function md(e, t = "utf-8") {
  return t = t || "utf-8", X().platform.decode(e, t);
}
var W$ = class {
  constructor(e, t) {
    this.backendTimer = e, this.logger = t, t == null && (this.logger = new G$());
  }
  profileKernel(e, t, n) {
    let s, r = () => {
      s = n();
    }, a, i = Uu();
    if (this.backendTimer.timerAvailable())
      a = this.backendTimer.time(r);
    else {
      r();
      for (let u of s)
        u.dataSync();
      a = Promise.resolve({ kernelMs: Uu() - i });
    }
    if (X().getBool("CHECK_COMPUTATION_FOR_ERRORS"))
      for (let u = 0; u < s.length; u++) {
        let l = s[u];
        l.data().then((c) => {
          U$(c, l.dtype, e);
        });
      }
    return { kernelName: e, outputs: s, inputs: t, timeMs: a.then((u) => u.kernelMs), extraInfo: a.then((u) => u.getExtraProfileInfo != null ? u.getExtraProfileInfo() : "") };
  }
  logKernelProfile(e) {
    let { kernelName: t, outputs: n, timeMs: s, inputs: r, extraInfo: a } = e;
    n.forEach((i) => {
      Promise.all([i.data(), s, a]).then((o) => {
        this.logger.logKernelProfile(t, i, o[0], o[1], r, o[2]);
      });
    });
  }
};
function U$(e, t, n) {
  if (t !== "float32")
    return false;
  for (let s = 0; s < e.length; s++) {
    let r = e[s];
    if (isNaN(r) || !isFinite(r))
      return console.warn(`Found ${r} in the result of '${n}'`), true;
  }
  return false;
}
var G$ = class {
  logKernelProfile(e, t, n, s, r, a) {
    let i = typeof s == "number" ? zu(`${s}ms`, 9) : s.error, o = zu(e, 25), u = t.rank, l = t.size, c = zu(t.shape.toString(), 14), p = "";
    for (let d in r) {
      let h = r[d];
      if (h != null) {
        let f = h.shape || t.shape, m = f.length;
        p += `${d}: ${m}D ${m > 0 ? f : ""} `;
      }
    }
    console.log(`%c${o}	%c${i}	%c${u}D ${c}	%c${l}	%c${p}	%c${a}`, "font-weight:bold", "color:red", "color:blue", "color: orange", "color: green", "color: steelblue");
  }
};
function H$(e, t, n) {
  let s = {}, r = {};
  for (let u = 0; u < t.length; u++)
    s[t[u].id] = true;
  for (let u = 0; u < e.length; u++) {
    let l = e[u], c = l.inputs;
    for (let p in c) {
      let d = c[p], h = false;
      for (let f = 0; f < t.length; f++)
        if (s[d.id]) {
          l.outputs.forEach((m) => s[m.id] = true), h = true, r[l.id] = true;
          break;
        }
      if (h)
        break;
    }
  }
  let a = {};
  a[n.id] = true;
  let i = {};
  for (let u = e.length - 1; u >= 0; u--) {
    let l = e[u], c = l.inputs;
    for (let p = 0; p < l.outputs.length; p++)
      if (a[l.outputs[p].id]) {
        for (let d in c)
          a[c[d].id] = true, i[l.id] = true;
        break;
      }
  }
  let o = [];
  for (let u = 0; u < e.length; u++) {
    let l = e[u];
    if (r[l.id] && i[l.id]) {
      let c = {};
      for (let d in l.inputs) {
        let h = l.inputs[d];
        s[h.id] && (c[d] = h);
      }
      let p = Object.assign({}, l);
      p.inputs = c, p.outputs = l.outputs, o.push(p);
    }
  }
  return o;
}
function q$(e, t, n, s) {
  for (let r = t.length - 1; r >= 0; r--) {
    let a = t[r], i = [];
    if (a.outputs.forEach((u) => {
      let l = e[u.id];
      l != null ? i.push(l) : i.push(null);
    }), a.gradient == null)
      throw new Error(`Cannot compute gradient: gradient function not found for ${a.kernelName}.`);
    let o = a.gradient(i);
    for (let u in a.inputs) {
      if (!(u in o))
        throw new Error(`Cannot backprop through input ${u}. Available gradients found: ${Object.keys(o)}.`);
      let l = n(() => o[u]());
      if (l.dtype !== "float32")
        throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input ${u} must have 'float32' dtype, but has '${l.dtype}'`);
      let c = a.inputs[u];
      if (!kr(l.shape, c.shape))
        throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input '${u}' has shape '${l.shape}', which does not match the shape of the input '${c.shape}'`);
      if (e[c.id] == null)
        e[c.id] = l;
      else {
        let p = e[c.id];
        e[c.id] = s(p, l), p.dispose();
      }
    }
  }
}
var ax = 20;
var Su = 3;
var Ff = 7;
function j$(e, t, n, s) {
  let r = ao(t), a = K$(e, t, n, r), i = t.length, o = ed(e, t, n, r, a), u = ["Tensor"];
  return s && (u.push(`  dtype: ${n}`), u.push(`  rank: ${i}`), u.push(`  shape: [${t}]`), u.push("  values:")), u.push(o.map((l) => "    " + l).join(`
`)), u.join(`
`);
}
function K$(e, t, n, s) {
  let r = pt(t), a = s[s.length - 1], i = new Array(a).fill(0), o = t.length, u = n === "complex64" ? _u(e) : e;
  if (o > 1)
    for (let l = 0; l < r / a; l++) {
      let c = l * a;
      for (let p = 0; p < a; p++)
        i[p] = Math.max(i[p], $u(u[c + p], 0, n).length);
    }
  return i;
}
function $u(e, t, n) {
  let s;
  return Array.isArray(e) ? s = `${parseFloat(e[0].toFixed(Ff))} + ${parseFloat(e[1].toFixed(Ff))}j` : ir(e) ? s = `'${e}'` : n === "bool" ? s = sk(e) : s = parseFloat(e.toFixed(Ff)).toString(), zu(s, t);
}
function sk(e) {
  return e === 0 ? "false" : "true";
}
function ed(e, t, n, s, r, a = true) {
  let i = n === "complex64" ? 2 : 1, o = t[0], u = t.length;
  if (u === 0) {
    if (n === "complex64") {
      let m = _u(e);
      return [$u(m[0], 0, n)];
    }
    return n === "bool" ? [sk(e[0])] : [e[0].toString()];
  }
  if (u === 1) {
    if (o > ax) {
      let g = Su * i, b = Array.from(e.slice(0, g)), y = Array.from(e.slice((o - Su) * i, o * i));
      return n === "complex64" && (b = _u(b), y = _u(y)), ["[" + b.map((v, x) => $u(v, r[x], n)).join(", ") + ", ..., " + y.map((v, x) => $u(v, r[o - Su + x], n)).join(", ") + "]"];
    }
    let m = n === "complex64" ? _u(e) : Array.from(e);
    return ["[" + m.map((g, b) => $u(g, r[b], n)).join(", ") + "]"];
  }
  let l = t.slice(1), c = s.slice(1), p = s[0] * i, d = [];
  if (o > ax) {
    for (let m = 0; m < Su; m++) {
      let g = m * p, b = g + p;
      d.push(...ed(e.slice(g, b), l, n, c, r, false));
    }
    d.push("...");
    for (let m = o - Su; m < o; m++) {
      let g = m * p, b = g + p;
      d.push(...ed(e.slice(g, b), l, n, c, r, m === o - 1));
    }
  } else
    for (let m = 0; m < o; m++) {
      let g = m * p, b = g + p;
      d.push(...ed(e.slice(g, b), l, n, c, r, m === o - 1));
    }
  let h = u === 2 ? "," : "";
  d[0] = "[" + d[0] + h;
  for (let m = 1; m < d.length - 1; m++)
    d[m] = " " + d[m] + h;
  let f = `,
`;
  for (let m = 2; m < u; m++)
    f += `
`;
  return d[d.length - 1] = " " + d[d.length - 1] + "]" + (a ? "" : f), d;
}
function _u(e) {
  let t = [];
  for (let n = 0; n < e.length; n += 2)
    t.push([e[n], e[n + 1]]);
  return t;
}
var Vt = class {
  constructor(e, t, n) {
    if (this.dtype = t, this.shape = e.slice(), this.size = pt(e), n != null) {
      let s = n.length;
      O(s === this.size, () => `Length of values '${s}' does not match the size inferred by the shape '${this.size}'.`);
    }
    if (t === "complex64")
      throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");
    this.values = n || qw(t, this.size), this.strides = ao(e);
  }
  set(e, ...t) {
    t.length === 0 && (t = [0]), O(t.length === this.rank, () => `The number of provided coordinates (${t.length}) must match the rank (${this.rank})`);
    let n = this.locToIndex(t);
    this.values[n] = e;
  }
  get(...e) {
    e.length === 0 && (e = [0]);
    let t = 0;
    for (let s of e) {
      if (s < 0 || s >= this.shape[t]) {
        let r = `Requested out of range element at ${e}.   Buffer shape=${this.shape}`;
        throw new Error(r);
      }
      t++;
    }
    let n = e[e.length - 1];
    for (let s = 0; s < e.length - 1; ++s)
      n += this.strides[s] * e[s];
    return this.values[n];
  }
  locToIndex(e) {
    if (this.rank === 0)
      return 0;
    if (this.rank === 1)
      return e[0];
    let t = e[e.length - 1];
    for (let n = 0; n < e.length - 1; ++n)
      t += this.strides[n] * e[n];
    return t;
  }
  indexToLoc(e) {
    if (this.rank === 0)
      return [];
    if (this.rank === 1)
      return [e];
    let t = new Array(this.shape.length);
    for (let n = 0; n < t.length - 1; ++n)
      t[n] = Math.floor(e / this.strides[n]), e -= t[n] * this.strides[n];
    return t[t.length - 1] = e, t;
  }
  get rank() {
    return this.shape.length;
  }
  toTensor() {
    return cs().makeTensor(this.values, this.shape, this.dtype);
  }
};
var cs = null;
var Wi = null;
var X$ = null;
function Y$(e) {
  cs = e;
}
function Q$(e) {
  Wi = e;
}
function Z$(e) {
  X$ = e;
}
var et = class {
  constructor(e, t, n, s) {
    this.kept = false, this.isDisposedInternal = false, this.shape = e.slice(), this.dtype = t || "float32", this.size = pt(e), this.strides = ao(e), this.dataId = n, this.id = s, this.rankType = this.rank < 5 ? this.rank.toString() : "higher";
  }
  get rank() {
    return this.shape.length;
  }
  async buffer() {
    let e = await this.data();
    return Wi.buffer(this.shape, this.dtype, e);
  }
  bufferSync() {
    return Wi.buffer(this.shape, this.dtype, this.dataSync());
  }
  async array() {
    let e = await this.data();
    return Hi(this.shape, e, this.dtype === "complex64");
  }
  arraySync() {
    return Hi(this.shape, this.dataSync(), this.dtype === "complex64");
  }
  async data() {
    this.throwIfDisposed();
    let e = cs().read(this.dataId);
    if (this.dtype === "string") {
      let t = await e;
      try {
        return t.map((n) => md(n));
      } catch (n) {
        throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().");
      }
    }
    return e;
  }
  dataToGPU(e) {
    return this.throwIfDisposed(), cs().readToGPU(this.dataId, e);
  }
  dataSync() {
    this.throwIfDisposed();
    let e = cs().readSync(this.dataId);
    if (this.dtype === "string")
      try {
        return e.map((t) => md(t));
      } catch (t) {
        throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().");
      }
    return e;
  }
  async bytes() {
    this.throwIfDisposed();
    let e = await cs().read(this.dataId);
    return this.dtype === "string" ? e : new Uint8Array(e.buffer);
  }
  dispose() {
    this.isDisposed || (cs().disposeTensor(this), this.isDisposedInternal = true);
  }
  get isDisposed() {
    return this.isDisposedInternal;
  }
  throwIfDisposed() {
    if (this.isDisposed)
      throw new Error("Tensor is disposed.");
  }
  print(e = false) {
    return Wi.print(this, e);
  }
  clone() {
    return this.throwIfDisposed(), Wi.clone(this);
  }
  toString(e = false) {
    let t = this.dataSync();
    return j$(t, this.shape, this.dtype, e);
  }
  cast(e) {
    return this.throwIfDisposed(), Wi.cast(this, e);
  }
  variable(e = true, t, n) {
    return this.throwIfDisposed(), cs().makeVariable(this, e, t, n);
  }
};
Object.defineProperty(et, Symbol.hasInstance, { value: (e) => !!e && e.data != null && e.dataSync != null && e.throwIfDisposed != null });
function J$() {
  return ag("Tensor", () => et);
}
J$();
var gd = class extends et {
  constructor(e, t, n, s) {
    super(e.shape, e.dtype, e.dataId, s), this.trainable = t, this.name = n;
  }
  assign(e) {
    if (e.dtype !== this.dtype)
      throw new Error(`dtype of the new value (${e.dtype}) and previous value (${this.dtype}) must match`);
    if (!kr(e.shape, this.shape))
      throw new Error(`shape of the new value (${e.shape}) and previous value (${this.shape}) must match`);
    cs().disposeTensor(this), this.dataId = e.dataId, cs().incRef(this, null);
  }
  dispose() {
    cs().disposeVariable(this), this.isDisposedInternal = true;
  }
};
Object.defineProperty(gd, Symbol.hasInstance, { value: (e) => e instanceof et && e.assign != null && e.assign instanceof Function });
var _s = {};
Ae(_s, { assertTypesMatch: () => uk, getTensorsInContainer: () => Rg, isTensorInList: () => n_, makeTypesMatch: () => vt });
var e_ = ((e) => (e.R0 = "R0", e.R1 = "R1", e.R2 = "R2", e.R3 = "R3", e.R4 = "R4", e.R5 = "R5", e.R6 = "R6", e))(e_ || {});
var rk = ((e) => (e.float32 = "float32", e.int32 = "int32", e.bool = "int32", e.complex64 = "complex64", e))(rk || {});
var ak = ((e) => (e.float32 = "float32", e.int32 = "int32", e.bool = "bool", e.complex64 = "complex64", e))(ak || {});
var ik = ((e) => (e.float32 = "float32", e.int32 = "float32", e.bool = "float32", e.complex64 = "complex64", e))(ik || {});
var ok = ((e) => (e.float32 = "complex64", e.int32 = "complex64", e.bool = "complex64", e.complex64 = "complex64", e))(ok || {});
var t_ = { float32: ik, int32: rk, bool: ak, complex64: ok };
function cn(e, t) {
  if (e === "string" || t === "string") {
    if (e === "string" && t === "string")
      return "string";
    throw new Error(`Can not upcast ${e} with ${t}`);
  }
  return t_[e][t];
}
function cp(e) {
  return cn(e, "int32");
}
function vt(e, t) {
  if (e.dtype === t.dtype)
    return [e, t];
  let n = cn(e.dtype, t.dtype);
  return [e.cast(n), t.cast(n)];
}
function uk(e, t) {
  O(e.dtype === t.dtype, () => `The dtypes of the first(${e.dtype}) and second(${t.dtype}) input must match`);
}
function n_(e, t) {
  return t.some((n) => n.id === e.id);
}
function Rg(e) {
  let t = [];
  return lk(e, t, /* @__PURE__ */ new Set()), t;
}
function lk(e, t, n) {
  if (e == null)
    return;
  if (e instanceof et) {
    t.push(e);
    return;
  }
  if (!s_(e))
    return;
  let s = e;
  for (let r in s) {
    let a = s[r];
    n.has(a) || (n.add(a), lk(a, t, n));
  }
}
function s_(e) {
  return Array.isArray(e) || typeof e == "object";
}
function Of(e) {
  return e.kernelName != null;
}
var ix = class {
  constructor() {
    this.registeredVariables = {}, this.nextTapeNodeId = 0, this.numBytes = 0, this.numTensors = 0, this.numStringTensors = 0, this.numDataBuffers = 0, this.gradientDepth = 0, this.kernelDepth = 0, this.scopeStack = [], this.numDataMovesStack = [], this.nextScopeId = 0, this.tensorInfo = /* @__PURE__ */ new WeakMap(), this.profiling = false, this.activeProfile = { newBytes: 0, newTensors: 0, peakBytes: 0, kernels: [], result: null, get kernelNames() {
      return Array.from(new Set(this.kernels.map((e) => e.name)));
    } };
  }
  dispose() {
    for (let e in this.registeredVariables)
      this.registeredVariables[e].dispose();
  }
};
var tm = class {
  constructor(e) {
    this.ENV = e, this.registry = {}, this.registryFactory = {}, this.pendingBackendInitId = 0, this.state = new ix();
  }
  async ready() {
    if (this.pendingBackendInit != null)
      return this.pendingBackendInit.then(() => {
      });
    if (this.backendInstance != null)
      return;
    let e = this.getSortedBackends();
    for (let t = 0; t < e.length; t++) {
      let n = e[t];
      if (await this.initializeBackend(n).success) {
        await this.setBackend(n);
        return;
      }
    }
    throw new Error("Could not initialize any backends, all backend initializations failed.");
  }
  get backend() {
    if (this.pendingBackendInit != null)
      throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);
    if (this.backendInstance == null) {
      let { name: e, asyncInit: t } = this.initializeBackendsAndReturnBest();
      if (t)
        throw new Error(`The highest priority backend '${e}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);
      this.setBackend(e);
    }
    return this.backendInstance;
  }
  backendNames() {
    return Object.keys(this.registryFactory);
  }
  findBackend(e) {
    if (!(e in this.registry))
      if (e in this.registryFactory) {
        let { asyncInit: t } = this.initializeBackend(e);
        if (t)
          return null;
      } else
        return null;
    return this.registry[e];
  }
  findBackendFactory(e) {
    return e in this.registryFactory ? this.registryFactory[e].factory : null;
  }
  registerBackend(e, t, n = 1) {
    return e in this.registryFactory ? (ar(`${e} backend was already registered. Reusing existing backend factory.`), false) : (this.registryFactory[e] = { factory: t, priority: n }, true);
  }
  async setBackend(e) {
    if (this.registryFactory[e] == null)
      throw new Error(`Backend name '${e}' not found in registry`);
    if (this.backendName = e, this.registry[e] == null) {
      this.backendInstance = null;
      let { success: t, asyncInit: n } = this.initializeBackend(e);
      if (!(n ? await t : t))
        return false;
    }
    return this.backendInstance = this.registry[e], this.setupRegisteredKernels(), this.profiler = new W$(this.backendInstance), true;
  }
  setupRegisteredKernels() {
    Jf(this.backendName).forEach((t) => {
      t.setupFunc != null && t.setupFunc(this.backendInstance);
    });
  }
  disposeRegisteredKernels(e) {
    Jf(e).forEach((n) => {
      n.disposeFunc != null && n.disposeFunc(this.registry[e]);
    });
  }
  initializeBackend(e) {
    let t = this.registryFactory[e];
    if (t == null)
      throw new Error(`Cannot initialize backend ${e}, no registration found.`);
    try {
      let n = t.factory();
      if (n && !(n instanceof nl) && typeof n.then == "function") {
        let s = ++this.pendingBackendInitId, r = n.then((a) => s < this.pendingBackendInitId ? false : (this.registry[e] = a, this.pendingBackendInit = null, true)).catch((a) => (s < this.pendingBackendInitId || (this.pendingBackendInit = null, ar(`Initialization of backend ${e} failed`), ar(a.stack || a.message)), false));
        return this.pendingBackendInit = r, { success: r, asyncInit: true };
      } else
        return this.registry[e] = n, { success: true, asyncInit: false };
    } catch (n) {
      return ar(`Initialization of backend ${e} failed`), ar(n.stack || n.message), { success: false, asyncInit: false };
    }
  }
  removeBackend(e) {
    if (!(e in this.registryFactory))
      throw new Error(`${e} backend not found in registry`);
    this.backendName === e && this.pendingBackendInit != null && this.pendingBackendInitId++, e in this.registry && (this.disposeRegisteredKernels(e), this.registry[e].dispose(), delete this.registry[e]), delete this.registryFactory[e], this.backendName === e && (this.pendingBackendInit = null, this.backendName = null, this.backendInstance = null);
  }
  getSortedBackends() {
    if (Object.keys(this.registryFactory).length === 0)
      throw new Error("No backend found in registry.");
    return Object.keys(this.registryFactory).sort((e, t) => this.registryFactory[t].priority - this.registryFactory[e].priority);
  }
  initializeBackendsAndReturnBest() {
    let e = this.getSortedBackends();
    for (let t = 0; t < e.length; t++) {
      let n = e[t], { success: s, asyncInit: r } = this.initializeBackend(n);
      if (r || s)
        return { name: n, asyncInit: r };
    }
    throw new Error("Could not initialize any backends, all backend initializations failed.");
  }
  moveData(e, t) {
    let n = this.state.tensorInfo.get(t), s = n.backend, r = this.readSync(t), a = s.refCount(t);
    s.disposeData(t, true), n.backend = e, e.move(t, r, n.shape, n.dtype, a), this.shouldCheckForMemLeaks() && this.state.numDataMovesStack[this.state.numDataMovesStack.length - 1]++;
  }
  tidy(e, t) {
    let n = null;
    if (t == null) {
      if (typeof e != "function")
        throw new Error("Please provide a function to tidy()");
      t = e;
    } else {
      if (typeof e != "string" && !(e instanceof String))
        throw new Error("When calling with two arguments, the first argument to tidy() must be a string");
      if (typeof t != "function")
        throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");
      n = e;
    }
    let s;
    return this.scopedRun(() => this.startScope(n), () => this.endScope(s), () => (s = t(), s instanceof Promise && console.error("Cannot return a Promise inside of tidy."), s));
  }
  scopedRun(e, t, n) {
    e();
    try {
      let s = n();
      return t(), s;
    } catch (s) {
      throw t(), s;
    }
  }
  nextTensorId() {
    return tm.nextTensorId++;
  }
  nextVariableId() {
    return tm.nextVariableId++;
  }
  clone(e) {
    let t = M.runKernel(Ba, { x: e }), n = { x: e }, s = (a) => ({ x: () => {
      let i = "float32", o = { x: a }, u = { dtype: i };
      return M.runKernel(Na, o, u);
    } }), r = [];
    return this.addTapeNode(this.state.activeScope.name, n, [t], s, r, {}), t;
  }
  runKernel(e, t, n) {
    if (this.backendName == null && this.backend, !(Zf(e, this.backendName) != null))
      throw new Error(`Kernel '${e}' not registered for backend '${this.backendName}'`);
    return this.runKernelFunc({ kernelName: e, inputs: t, attrs: n });
  }
  shouldCheckForMemLeaks() {
    return this.ENV.getBool("IS_TEST");
  }
  checkKernelForMemLeak(e, t, n) {
    let s = this.backend.numDataIds(), r = 0;
    n.forEach((o) => {
      r += o.dtype === "complex64" ? 3 : 1;
    });
    let a = this.state.numDataMovesStack[this.state.numDataMovesStack.length - 1], i = s - t - r - a;
    if (i > 0)
      throw new Error(`Backend '${this.backendName}' has an internal memory leak (${i} data ids) after running '${e}'`);
  }
  runKernelFunc(e) {
    let t, n = [], s = this.isTapeOn(), r = this.state.numBytes, a = this.state.numTensors;
    this.shouldCheckForMemLeaks() && this.state.numDataMovesStack.push(0);
    let i;
    this.backendName == null && this.backend;
    let o, u = Of(e) ? e.kernelName : this.state.activeScope != null ? this.state.activeScope.name : "";
    if (Of(e)) {
      let { kernelName: h, inputs: f, attrs: m } = e;
      this.backendName == null && this.backend;
      let g = Zf(h, this.backendName);
      O(g != null, () => `Cannot find registered kernel '${h}' for backend '${this.backendName}'`), i = () => {
        let b = this.backend.numDataIds();
        o = g.kernelFunc({ inputs: f, attrs: m, backend: this.backend });
        let y = Array.isArray(o) ? o : [o];
        this.shouldCheckForMemLeaks() && this.checkKernelForMemLeak(h, b, y);
        let v = y.map((x) => {
          if (x.rank != null)
            return x;
          let { dataId: k, shape: T, dtype: N } = x;
          return this.makeTensorFromDataId(k, T, N);
        });
        if (s) {
          let x = this.getTensorsForGradient(h, f, v);
          n = this.saveTensorsForBackwardMode(x);
        }
        return v;
      };
    } else {
      let { forwardFunc: h } = e, f = (m) => {
        !s || (n = m.map((g) => this.keep(this.clone(g))));
      };
      i = () => {
        let m = this.backend.numDataIds();
        o = this.tidy(() => h(this.backend, f));
        let g = Array.isArray(o) ? o : [o];
        return this.shouldCheckForMemLeaks() && this.checkKernelForMemLeak(u, m, g), g;
      };
    }
    let { inputs: l, attrs: c } = e, p = Of(e) ? null : e.backwardsFunc, d;
    return this.scopedRun(() => this.state.kernelDepth++, () => this.state.kernelDepth--, () => {
      !this.ENV.getBool("DEBUG") && !this.state.profiling ? t = i() : (d = this.profiler.profileKernel(u, l, () => i()), this.ENV.getBool("DEBUG") && this.profiler.logKernelProfile(d), t = d.outputs);
    }), s && this.addTapeNode(u, l, t, p, n, c), this.state.profiling && this.state.activeProfile.kernels.push({ name: u, bytesAdded: this.state.numBytes - r, totalBytesSnapshot: this.state.numBytes, tensorsAdded: this.state.numTensors - a, totalTensorsSnapshot: this.state.numTensors, inputShapes: Object.keys(l).map((h) => l[h] != null ? l[h].shape : null), outputShapes: t.map((h) => h.shape), kernelTimeMs: d.timeMs, extraInfo: d.extraInfo }), Array.isArray(o) ? t : t[0];
  }
  saveTensorsForBackwardMode(e) {
    return e.map((n) => this.keep(this.clone(n)));
  }
  getTensorsForGradient(e, t, n) {
    let s = nx(e);
    if (s != null) {
      let r = s.inputsToSave || [], a = s.outputsToSave || [], i;
      s.saveAllInputs ? (O(Array.isArray(t), () => "saveAllInputs is true, expected inputs to be an array."), i = Object.keys(t).map((u) => t[u])) : i = r.map((u) => t[u]);
      let o = n.filter((u, l) => a[l]);
      return i.concat(o);
    }
    return [];
  }
  makeTensor(e, t, n, s) {
    if (e == null)
      throw new Error("Values passed to engine.makeTensor() are null");
    n = n || "float32", s = s || this.backend;
    let r = e;
    n === "string" && ir(e[0]) && (r = e.map((o) => Dl(o)));
    let a = s.write(r, t, n), i = new et(t, n, a, this.nextTensorId());
    if (this.trackTensor(i, s), n === "string") {
      let o = this.state.tensorInfo.get(a), u = Xw(r);
      this.state.numBytes += u - o.bytes, o.bytes = u;
    }
    return i;
  }
  makeTensorFromDataId(e, t, n, s) {
    n = n || "float32";
    let r = new et(t, n, e, this.nextTensorId());
    return this.trackTensor(r, s), r;
  }
  makeVariable(e, t = true, n, s) {
    n = n || this.nextVariableId().toString(), s != null && s !== e.dtype && (e = e.cast(s));
    let r = new gd(e, t, n, this.nextTensorId());
    if (this.state.registeredVariables[r.name] != null)
      throw new Error(`Variable with name ${r.name} was already registered`);
    return this.state.registeredVariables[r.name] = r, this.incRef(r, this.backend), r;
  }
  trackTensor(e, t) {
    this.state.numTensors++, e.dtype === "string" && this.state.numStringTensors++;
    let n = 0;
    e.dtype !== "complex64" && e.dtype !== "string" && (n = e.size * Xf(e.dtype)), this.state.numBytes += n, this.state.tensorInfo.has(e.dataId) || (this.state.numDataBuffers++, this.state.tensorInfo.set(e.dataId, { backend: t || this.backend, dtype: e.dtype, shape: e.shape, bytes: n })), e instanceof gd || this.track(e);
  }
  incRef(e, t) {
    this.trackTensor(e, t), this.backend.incRef(e.dataId);
  }
  removeDataId(e, t) {
    this.state.tensorInfo.has(e) && this.state.tensorInfo.get(e).backend === t && (this.state.tensorInfo.delete(e), this.state.numDataBuffers--);
  }
  disposeTensor(e) {
    if (!this.state.tensorInfo.has(e.dataId))
      return;
    let t = this.state.tensorInfo.get(e.dataId);
    if (this.state.numTensors--, e.dtype === "string" && (this.state.numStringTensors--, this.state.numBytes -= t.bytes), e.dtype !== "complex64" && e.dtype !== "string") {
      let n = e.size * Xf(e.dtype);
      this.state.numBytes -= n;
    }
    t.backend.disposeData(e.dataId) && this.removeDataId(e.dataId, t.backend);
  }
  disposeVariables() {
    for (let e in this.state.registeredVariables) {
      let t = this.state.registeredVariables[e];
      this.disposeVariable(t);
    }
  }
  disposeVariable(e) {
    this.disposeTensor(e), this.state.registeredVariables[e.name] != null && delete this.state.registeredVariables[e.name];
  }
  memory() {
    let e = this.backend.memory();
    return e.numTensors = this.state.numTensors, e.numDataBuffers = this.state.numDataBuffers, e.numBytes = this.state.numBytes, this.state.numStringTensors > 0 && (e.unreliable = true, e.reasons == null && (e.reasons = []), e.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")), e;
  }
  async profile(e) {
    this.state.profiling = true;
    let t = this.state.numBytes, n = this.state.numTensors;
    this.state.activeProfile.kernels = [], this.state.activeProfile.result = await e(), this.state.profiling = false, this.state.activeProfile.peakBytes = Math.max(...this.state.activeProfile.kernels.map((s) => s.totalBytesSnapshot)), this.state.activeProfile.newBytes = this.state.numBytes - t, this.state.activeProfile.newTensors = this.state.numTensors - n;
    for (let s of this.state.activeProfile.kernels)
      s.kernelTimeMs = await s.kernelTimeMs, s.extraInfo = await s.extraInfo;
    return this.state.activeProfile;
  }
  isTapeOn() {
    return this.state.gradientDepth > 0 && this.state.kernelDepth === 0;
  }
  addTapeNode(e, t, n, s, r, a) {
    let i = { id: this.state.nextTapeNodeId++, kernelName: e, inputs: t, outputs: n, saved: r }, o = nx(e);
    o != null && (s = o.gradFunc), s != null && (i.gradient = (u) => (u = u.map((l, c) => {
      if (l == null) {
        let p = n[c], d = Hd(p.size, p.dtype);
        return this.makeTensor(d, p.shape, p.dtype);
      }
      return l;
    }), s(u.length > 1 ? u : u[0], r, a))), this.state.activeTape.push(i);
  }
  keep(e) {
    return e.kept = true, e;
  }
  startTape() {
    this.state.gradientDepth === 0 && (this.state.activeTape = []), this.state.gradientDepth++;
  }
  endTape() {
    this.state.gradientDepth--;
  }
  startScope(e) {
    let t = { track: [], name: "unnamed scope", id: this.state.nextScopeId++ };
    e && (t.name = e), this.state.scopeStack.push(t), this.state.activeScope = t;
  }
  endScope(e) {
    let t = Rg(e), n = new Set(t.map((r) => r.id));
    for (let r = 0; r < this.state.activeScope.track.length; r++) {
      let a = this.state.activeScope.track[r];
      !a.kept && !n.has(a.id) && a.dispose();
    }
    let s = this.state.scopeStack.pop();
    this.state.activeScope = this.state.scopeStack.length === 0 ? null : this.state.scopeStack[this.state.scopeStack.length - 1], t.forEach((r) => {
      !r.kept && r.scopeId === s.id && this.track(r);
    });
  }
  gradients(e, t, n, s = false) {
    if (O(t.length > 0, () => "gradients() received an empty list of xs."), n != null && n.dtype !== "float32")
      throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);
    let r = this.scopedRun(() => this.startTape(), () => this.endTape(), () => this.tidy("forward", e));
    O(r instanceof et, () => "The result y returned by f() must be a tensor.");
    let a = H$(this.state.activeTape, t, r);
    if (!s && a.length === 0 && t.length > 0)
      throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");
    return this.tidy("backward", () => {
      let i = {};
      i[r.id] = n == null ? r_(r.shape) : n, q$(i, a, (u) => this.tidy(u), a_);
      let o = t.map((u) => i[u.id]);
      return this.state.gradientDepth === 0 && (this.state.activeTape.forEach((u) => {
        for (let l of u.saved)
          l.dispose();
      }), this.state.activeTape = null), { value: r, grads: o };
    });
  }
  customGrad(e) {
    return O(hr(e), () => "The f passed in customGrad(f) must be a function."), (...t) => {
      O(t.every((i) => i instanceof et), () => "The args passed in customGrad(f)(x1, x2,...) must all be tensors");
      let n, s = {};
      t.forEach((i, o) => {
        s[o] = i;
      });
      let r = (i, o) => (n = e(...t, o), O(n.value instanceof et, () => "The function f passed in customGrad(f) must return an object where `obj.value` is a tensor"), O(hr(n.gradFunc), () => "The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function."), n.value), a = (i, o) => {
        let u = n.gradFunc(i, o), l = Array.isArray(u) ? u : [u];
        O(l.length === t.length, () => "The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...)."), O(l.every((p) => p instanceof et), () => "The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors.");
        let c = {};
        return l.forEach((p, d) => {
          c[d] = () => p;
        }), c;
      };
      return this.runKernelFunc({ forwardFunc: r, backwardsFunc: a, inputs: s });
    };
  }
  readSync(e) {
    return this.state.tensorInfo.get(e).backend.readSync(e);
  }
  read(e) {
    return this.state.tensorInfo.get(e).backend.read(e);
  }
  readToGPU(e, t) {
    return this.state.tensorInfo.get(e).backend.readToGPU(e, t);
  }
  async time(e) {
    let t = Uu(), n = await this.backend.time(e);
    return n.wallMs = Uu() - t, n;
  }
  track(e) {
    return this.state.activeScope != null && (e.scopeId = this.state.activeScope.id, this.state.activeScope.track.push(e)), e;
  }
  get registeredVariables() {
    return this.state.registeredVariables;
  }
  reset() {
    this.pendingBackendInitId++, this.state.dispose(), this.ENV.reset(), this.state = new ix();
    for (let e in this.registry)
      this.disposeRegisteredKernels(e), this.registry[e].dispose(), delete this.registry[e];
    this.backendName = null, this.backendInstance = null, this.pendingBackendInit = null;
  }
};
var Dg = tm;
Dg.nextTensorId = 0;
Dg.nextVariableId = 0;
function r_(e) {
  let t = ng(pt(e), "float32");
  return M.makeTensor(t, e, "float32");
}
function ck() {
  let e = ek();
  if (e._tfengine == null) {
    let t = new S$(e);
    e._tfengine = new Dg(t);
  }
  return $$(e._tfengine.ENV), Y$(() => e._tfengine), e._tfengine;
}
var M = ck();
function a_(e, t) {
  let n = { a: e, b: t };
  return M.runKernel(Ir, n);
}
var dp = {};
Ae(dp, { isBrowser: () => dk, isMobile: () => u_, mockIsMobile: () => o_ });
function i_() {
  return typeof navigator != "undefined" && navigator != null;
}
var nm;
function o_(e) {
  nm = e;
}
function u_(e) {
  if (nm !== void 0)
    return nm;
  if (e || i_()) {
    if (e || (e = navigator), e.product === "ReactNative")
      return true;
    let t = e.userAgent || e.vendor || (typeof window != "undefined" ? window.opera : "");
    if (!t) {
      let n = e;
      return n.userAgentData && n.userAgentData.mobile;
    }
    return /(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(t) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(t.substr(0, 4));
  }
  return false;
}
function dk() {
  return typeof window != "undefined" && window.document != null || typeof WorkerGlobalScope != "undefined";
}
var jn = X();
jn.registerFlag("DEBUG", () => false, (e) => {
  e && console.warn("Debugging mode is ON. The output of every math call will be downloaded to CPU and checked for NaNs. This significantly impacts performance.");
});
jn.registerFlag("IS_BROWSER", () => dk());
jn.registerFlag("IS_NODE", () => typeof process != "undefined" && typeof process.versions != "undefined" && typeof process.versions.node != "undefined");
jn.registerFlag("IS_CHROME", () => typeof navigator != "undefined" && navigator != null && navigator.userAgent != null && /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor));
jn.registerFlag("PROD", () => false);
jn.registerFlag("TENSORLIKE_CHECK_SHAPE_CONSISTENCY", () => jn.getBool("DEBUG"));
jn.registerFlag("DEPRECATION_WARNINGS_ENABLED", () => true);
jn.registerFlag("IS_TEST", () => false);
jn.registerFlag("CHECK_COMPUTATION_FOR_ERRORS", () => true);
jn.registerFlag("WRAP_TO_IMAGEBITMAP", () => false);
jn.registerFlag("ENGINE_COMPILE_ONLY", () => false);
function Rs(e, t) {
  let n = e;
  if (Qt(e))
    return t === "string" ? [] : [e.length];
  if (!Array.isArray(e))
    return [];
  let s = [];
  for (; Array.isArray(n) || Qt(n) && t !== "string"; )
    s.push(n.length), n = n[0];
  return Array.isArray(e) && X().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY") && pk(e, s, []), s;
}
function pk(e, t, n) {
  if (n = n || [], !Array.isArray(e) && !Qt(e)) {
    O(t.length === 0, () => `Element arr[${n.join("][")}] is a primitive, but should be an array/TypedArray of ${t[0]} elements`);
    return;
  }
  O(t.length > 0, () => `Element arr[${n.join("][")}] should be a primitive, but is an array of ${e.length} elements`), O(e.length === t[0], () => `Element arr[${n.join("][")}] should have ${t[0]} elements, but has ${e.length} elements`);
  let s = t.slice(1);
  for (let r = 0; r < e.length; ++r)
    pk(e[r], s, n.concat(r));
}
function ox(e, t, n, s) {
  if (e !== "string_or_numeric") {
    if (e == null)
      throw new Error("Expected dtype cannot be null.");
    if (e !== "numeric" && e !== t || e === "numeric" && t === "string")
      throw new Error(`Argument '${n}' passed to '${s}' must be ${e} tensor, but got ${t} tensor`);
  }
}
function _(e, t, n, s = "numeric") {
  if (e instanceof et)
    return ox(s, e.dtype, t, n), e;
  let r = Gd(e);
  if (r !== "string" && ["bool", "int32", "float32"].indexOf(s) >= 0 && (r = s), ox(s, r, t, n), e == null || !Qt(e) && !Array.isArray(e) && typeof e != "number" && typeof e != "boolean" && typeof e != "string") {
    let u = e == null ? "null" : e.constructor.name;
    throw new Error(`Argument '${t}' passed to '${n}' must be a Tensor or TensorLike, but got '${u}'`);
  }
  let a = Rs(e, r);
  !Qt(e) && !Array.isArray(e) && (e = [e]);
  let o = r !== "string" ? lp(e, r) : sa(e, [], true);
  return M.makeTensor(o, a, r);
}
function Gu(e, t, n, s = "numeric") {
  if (!Array.isArray(e))
    throw new Error(`Argument ${t} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);
  return e.map((a, i) => _(a, `${t}[${i}]`, n, s));
}
var l_ = "__op";
function L(e) {
  let t = Object.keys(e);
  if (t.length !== 1)
    throw new Error(`Please provide an object with a single key (operation name) mapping to a function. Got an object with ${t.length} keys.`);
  let n = t[0], s = e[n];
  n.endsWith("_") && (n = n.substring(0, n.length - 1)), n = n + l_;
  let r = (...a) => {
    M.startScope(n);
    try {
      let i = s(...a);
      return rg(i) && console.error("Cannot return a Promise inside of tidy."), M.endScope(i), i;
    } catch (i) {
      throw M.endScope(null), i;
    }
  };
  return Object.defineProperty(r, "name", { value: n, configurable: true }), r;
}
function c_(e, t) {
  let n = _(e, "real", "complex"), s = _(t, "imag", "complex");
  pn(n.shape, s.shape, `real and imag shapes, ${n.shape} and ${s.shape}, must match in call to tf.complex().`);
  let r = { real: n, imag: s };
  return M.runKernel(jd, r);
}
var oa = L({ complex_: c_ });
function Nr(e, t, n, s) {
  if (s == null && (s = Gd(e)), s === "complex64")
    throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");
  if (!Qt(e) && !Array.isArray(e) && typeof e != "number" && typeof e != "boolean" && typeof e != "string")
    throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");
  if (t != null) {
    sg(t);
    let r = pt(t), a = pt(n);
    O(r === a, () => `Based on the provided shape, [${t}], the tensor should have ${r} values but has ${a}`);
    for (let i = 0; i < n.length; ++i) {
      let o = n[i], u = i === n.length - 1 ? o !== pt(t.slice(i)) : true;
      O(n[i] === t[i] || !u, () => `Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${t}). `);
    }
  }
  return !Qt(e) && !Array.isArray(e) && (e = [e]), t = t || n, e = s !== "string" ? lp(e, s) : sa(e, [], true), M.makeTensor(e, t, s);
}
function fs(e, t, n) {
  let s = Rs(e, n);
  return Nr(e, t, s, n);
}
var sm = { float32: 4, float16: 2, int32: 4, uint16: 2, uint8: 1, bool: 1, complex64: 8 };
var bd = 4;
async function d_(e, t) {
  let n = [], s = [], r = Array.isArray(e) ? e.map((i) => i.name) : Object.keys(e);
  for (let i = 0; i < r.length; ++i) {
    let o = r[i], u = Array.isArray(e) ? e[i].tensor : e[o];
    if (u.dtype !== "float32" && u.dtype !== "int32" && u.dtype !== "bool" && u.dtype !== "string" && u.dtype !== "complex64")
      throw new Error(`Unsupported dtype in weight '${o}': ${u.dtype}`);
    let l = { name: o, shape: u.shape, dtype: u.dtype };
    if (u.dtype === "string") {
      let c = new Promise(async (p) => {
        let d = await u.bytes(), h = d.reduce((g, b) => g + b.length, 0) + bd * d.length, f = new Uint8Array(h), m = 0;
        for (let g = 0; g < d.length; g++) {
          let b = d[g], y = new Uint8Array(new Uint32Array([b.length]).buffer);
          f.set(y, m), m += bd, f.set(b, m), m += b.length;
        }
        p(f);
      });
      s.push(c);
    } else
      s.push(u.data());
    t != null && (l.group = t), n.push(l);
  }
  let a = await Promise.all(s);
  return { data: p_(a), specs: n };
}
function hk(e, t) {
  let n = {}, s, r = 0;
  for (let a of t) {
    let i = a.name, o = a.dtype, u = a.shape, l = pt(u), c;
    if ("quantization" in a) {
      let p = a.quantization;
      if (p.dtype === "uint8" || p.dtype === "uint16") {
        if (!("min" in p && "scale" in p))
          throw new Error(`Weight ${a.name} with quantization ${p.dtype} doesn't have corresponding metadata min and scale.`);
      } else if (p.dtype === "float16") {
        if (o !== "float32")
          throw new Error(`Weight ${a.name} is quantized with ${p.dtype} which only supports weights of type float32 not ${o}.`);
      } else
        throw new Error(`Weight ${a.name} has unknown quantization dtype ${p.dtype}. Supported quantization dtypes are: 'uint8', 'uint16', and 'float16'.`);
      let d = sm[p.dtype], h = e.slice(r, r + l * d), f = p.dtype === "uint8" ? new Uint8Array(h) : new Uint16Array(h);
      if (o === "float32")
        if (p.dtype === "uint8" || p.dtype === "uint16") {
          c = new Float32Array(f.length);
          for (let m = 0; m < f.length; m++) {
            let g = f[m];
            c[m] = g * p.scale + p.min;
          }
        } else if (p.dtype === "float16")
          s === void 0 && (s = y_()), c = s(f);
        else
          throw new Error(`Unsupported quantization type ${p.dtype} for weight type float32.`);
      else if (o === "int32") {
        if (p.dtype !== "uint8" && p.dtype !== "uint16")
          throw new Error(`Unsupported quantization type ${p.dtype} for weight type int32.`);
        c = new Int32Array(f.length);
        for (let m = 0; m < f.length; m++) {
          let g = f[m];
          c[m] = Math.round(g * p.scale + p.min);
        }
      } else
        throw new Error(`Unsupported dtype in weight '${i}': ${o}`);
      r += l * d;
    } else if (o === "string") {
      let p = pt(a.shape);
      c = [];
      for (let d = 0; d < p; d++) {
        let h = new Uint32Array(e.slice(r, r + bd))[0];
        r += bd;
        let f = new Uint8Array(e.slice(r, r + h));
        c.push(f), r += h;
      }
    } else {
      let p = sm[o], d = e.slice(r, r + l * p);
      if (o === "float32")
        c = new Float32Array(d);
      else if (o === "int32")
        c = new Int32Array(d);
      else if (o === "bool")
        c = new Uint8Array(d);
      else if (o === "complex64") {
        c = new Float32Array(d);
        let h = new Float32Array(c.length / 2), f = new Float32Array(c.length / 2);
        for (let b = 0; b < h.length; b++)
          h[b] = c[b * 2], f[b] = c[b * 2 + 1];
        let m = fs(h, u, "float32"), g = fs(f, u, "float32");
        n[i] = oa(m, g), m.dispose(), g.dispose();
      } else
        throw new Error(`Unsupported dtype in weight '${i}': ${o}`);
      r += l * p;
    }
    o !== "complex64" && (n[i] = fs(c, u, o));
  }
  return n;
}
function p_(e) {
  if (e === null)
    throw new Error(`Invalid input value: ${JSON.stringify(e)}`);
  let t = 0, n = [];
  e.forEach((a) => {
    if (t += a.byteLength, n.push(a.byteLength === a.buffer.byteLength ? a : new a.constructor(a)), !(a instanceof Float32Array || a instanceof Int32Array || a instanceof Uint8Array))
      throw new Error(`Unsupported TypedArray subtype: ${a.constructor.name}`);
  });
  let s = new Uint8Array(t), r = 0;
  return n.forEach((a) => {
    s.set(new Uint8Array(a.buffer), r), r += a.byteLength;
  }), s.buffer;
}
var Fg = typeof Buffer != "undefined" && (typeof Blob == "undefined" || typeof atob == "undefined" || typeof btoa == "undefined");
function ux(e) {
  return Fg ? Buffer.byteLength(e) : new Blob([e]).size;
}
function h_(e) {
  if (Fg)
    return Buffer.from(e).toString("base64");
  let t = new Uint8Array(e), n = "";
  for (let s = 0, r = t.length; s < r; s++)
    n += String.fromCharCode(t[s]);
  return btoa(n);
}
function f_(e) {
  if (Fg) {
    let s = Buffer.from(e, "base64");
    return s.buffer.slice(s.byteOffset, s.byteOffset + s.byteLength);
  }
  let t = atob(e), n = new Uint8Array(t.length);
  for (let s = 0; s < t.length; ++s)
    n.set([t.charCodeAt(s)], s);
  return n.buffer;
}
function Og(e) {
  if (e.length === 1)
    return e[0];
  let t = 0;
  e.forEach((r) => {
    t += r.byteLength;
  });
  let n = new Uint8Array(t), s = 0;
  return e.forEach((r) => {
    n.set(new Uint8Array(r), s), s += r.byteLength;
  }), n.buffer;
}
function lx(e) {
  let t = "/";
  for (e = e.trim(); e.endsWith(t); )
    e = e.slice(0, e.length - 1);
  let n = e.split(t);
  return n[n.length - 1];
}
function fk(e, t) {
  let n = { modelTopology: e.modelTopology, format: e.format, generatedBy: e.generatedBy, convertedBy: e.convertedBy, weightsManifest: t };
  return e.signature != null && (n.signature = e.signature), e.userDefinedMetadata != null && (n.userDefinedMetadata = e.userDefinedMetadata), e.modelInitializer != null && (n.modelInitializer = e.modelInitializer), e.trainingConfig != null && (n.trainingConfig = e.trainingConfig), n;
}
async function Pg(e, t) {
  let n = { modelTopology: e.modelTopology, format: e.format, generatedBy: e.generatedBy, convertedBy: e.convertedBy };
  if (e.trainingConfig != null && (n.trainingConfig = e.trainingConfig), e.weightsManifest != null) {
    let [s, r] = await t(e.weightsManifest);
    n.weightSpecs = s, n.weightData = r;
  }
  return e.signature != null && (n.signature = e.signature), e.userDefinedMetadata != null && (n.userDefinedMetadata = e.userDefinedMetadata), e.modelInitializer != null && (n.modelInitializer = e.modelInitializer), n;
}
function Fl(e) {
  if (e.modelTopology instanceof ArrayBuffer)
    throw new Error("Expected JSON model topology, received ArrayBuffer.");
  return { dateSaved: new Date(), modelTopologyType: "JSON", modelTopologyBytes: e.modelTopology == null ? 0 : ux(JSON.stringify(e.modelTopology)), weightSpecsBytes: e.weightSpecs == null ? 0 : ux(JSON.stringify(e.weightSpecs)), weightDataBytes: e.weightData == null ? 0 : e.weightData.byteLength };
}
function m_() {
  let e = (n) => {
    let s = n << 13, r = 0;
    for (; (s & 8388608) === 0; )
      r -= 8388608, s <<= 1;
    return s &= -8388609, r += 947912704, s | r;
  }, t = new Uint32Array(2048);
  t[0] = 0;
  for (let n = 1; n < 1024; n++)
    t[n] = e(n);
  for (let n = 1024; n < 2048; n++)
    t[n] = 939524096 + (n - 1024 << 13);
  return t;
}
function g_() {
  let e = new Uint32Array(64);
  e[0] = 0, e[31] = 1199570944, e[32] = 2147483648, e[63] = 3347054592;
  for (let t = 1; t < 31; t++)
    e[t] = t << 23;
  for (let t = 33; t < 63; t++)
    e[t] = 2147483648 + (t - 32 << 23);
  return e;
}
function b_() {
  let e = new Uint32Array(64);
  for (let t = 0; t < 64; t++)
    e[t] = 1024;
  return e[0] = e[32] = 0, e;
}
function y_() {
  let e = m_(), t = g_(), n = b_();
  return (s) => {
    let r = new ArrayBuffer(4 * s.length), a = new Uint32Array(r);
    for (let i = 0; i < s.length; i++) {
      let o = s[i], u = e[n[o >> 10] + (o & 1023)] + t[o >> 10];
      a[i] = u;
    }
    return new Float32Array(r);
  };
}
var xt = class {
  constructor() {
    this.saveRouters = [], this.loadRouters = [];
  }
  static getInstance() {
    return xt.instance == null && (xt.instance = new xt()), xt.instance;
  }
  static registerSaveRouter(e) {
    xt.getInstance().saveRouters.push(e);
  }
  static registerLoadRouter(e) {
    xt.getInstance().loadRouters.push(e);
  }
  static getSaveHandlers(e) {
    return xt.getHandlers(e, "save");
  }
  static getLoadHandlers(e, t) {
    return xt.getHandlers(e, "load", t);
  }
  static getHandlers(e, t, n) {
    let s = [];
    return (t === "load" ? xt.getInstance().loadRouters : xt.getInstance().saveRouters).forEach((a) => {
      let i = a(e, n);
      i !== null && s.push(i);
    }), s;
  }
};
var v_ = (e) => xt.registerSaveRouter(e);
var x_ = (e) => xt.registerLoadRouter(e);
var w_ = (e) => xt.getSaveHandlers(e);
var k_ = (e, t) => xt.getLoadHandlers(e, t);
var rm = "tensorflowjs";
var am = 1;
var Yr = "models_store";
var or = "model_info_store";
function mk() {
  if (!X().getBool("IS_BROWSER"))
    throw new Error("Failed to obtain IndexedDB factory because the current environmentis not a web browser.");
  let e = typeof window == "undefined" ? self : window, t = e.indexedDB || e.mozIndexedDB || e.webkitIndexedDB || e.msIndexedDB || e.shimIndexedDB;
  if (t == null)
    throw new Error("The current browser does not appear to support IndexedDB.");
  return t;
}
function im(e) {
  let t = e.result;
  t.createObjectStore(Yr, { keyPath: "modelPath" }), t.createObjectStore(or, { keyPath: "modelPath" });
}
var ua = class {
  constructor(e) {
    if (this.indexedDB = mk(), e == null || !e)
      throw new Error("For IndexedDB, modelPath must not be null, undefined or empty.");
    this.modelPath = e;
  }
  async save(e) {
    if (e.modelTopology instanceof ArrayBuffer)
      throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");
    return this.databaseAction(this.modelPath, e);
  }
  async load() {
    return this.databaseAction(this.modelPath);
  }
  databaseAction(e, t) {
    return new Promise((n, s) => {
      let r = this.indexedDB.open(rm, am);
      r.onupgradeneeded = () => im(r), r.onsuccess = () => {
        let a = r.result;
        if (t == null) {
          let i = a.transaction(Yr, "readonly"), u = i.objectStore(Yr).get(this.modelPath);
          u.onsuccess = () => {
            if (u.result == null)
              return a.close(), s(new Error(`Cannot find model with path '${this.modelPath}' in IndexedDB.`));
            n(u.result.modelArtifacts);
          }, u.onerror = (l) => (a.close(), s(u.error)), i.oncomplete = () => a.close();
        } else {
          let i = Fl(t), o = a.transaction(or, "readwrite"), u = o.objectStore(or), l = u.put({ modelPath: this.modelPath, modelArtifactsInfo: i }), c;
          l.onsuccess = () => {
            c = a.transaction(Yr, "readwrite");
            let d = c.objectStore(Yr).put({ modelPath: this.modelPath, modelArtifacts: t, modelArtifactsInfo: i });
            d.onsuccess = () => n({ modelArtifactsInfo: i }), d.onerror = (h) => {
              u = o.objectStore(or);
              let f = u.delete(this.modelPath);
              f.onsuccess = () => (a.close(), s(d.error)), f.onerror = (m) => (a.close(), s(d.error));
            };
          }, l.onerror = (p) => (a.close(), s(l.error)), o.oncomplete = () => {
            c == null ? a.close() : c.oncomplete = () => a.close();
          };
        }
      }, r.onerror = (a) => s(r.error);
    });
  }
};
ua.URL_SCHEME = "indexeddb://";
var gk = (e) => X().getBool("IS_BROWSER") && !Array.isArray(e) && e.startsWith(ua.URL_SCHEME) ? I_(e.slice(ua.URL_SCHEME.length)) : null;
xt.registerSaveRouter(gk);
xt.registerLoadRouter(gk);
function I_(e) {
  return new ua(e);
}
function S_(e) {
  return e.startsWith(ua.URL_SCHEME) ? e.slice(ua.URL_SCHEME.length) : e;
}
var C_ = class {
  constructor() {
    this.indexedDB = mk();
  }
  async listModels() {
    return new Promise((e, t) => {
      let n = this.indexedDB.open(rm, am);
      n.onupgradeneeded = () => im(n), n.onsuccess = () => {
        let s = n.result, r = s.transaction(or, "readonly"), i = r.objectStore(or).getAll();
        i.onsuccess = () => {
          let o = {};
          for (let u of i.result)
            o[u.modelPath] = u.modelArtifactsInfo;
          e(o);
        }, i.onerror = (o) => (s.close(), t(i.error)), r.oncomplete = () => s.close();
      }, n.onerror = (s) => t(n.error);
    });
  }
  async removeModel(e) {
    return e = S_(e), new Promise((t, n) => {
      let s = this.indexedDB.open(rm, am);
      s.onupgradeneeded = () => im(s), s.onsuccess = () => {
        let r = s.result, a = r.transaction(or, "readwrite"), i = a.objectStore(or), o = i.get(e), u;
        o.onsuccess = () => {
          if (o.result == null)
            return r.close(), n(new Error(`Cannot find model with path '${e}' in IndexedDB.`));
          {
            let l = i.delete(e), c = () => {
              u = r.transaction(Yr, "readwrite");
              let d = u.objectStore(Yr).delete(e);
              d.onsuccess = () => t(o.result.modelArtifactsInfo), d.onerror = (h) => n(o.error);
            };
            l.onsuccess = c, l.onerror = (p) => (c(), r.close(), n(o.error));
          }
        }, o.onerror = (l) => (r.close(), n(o.error)), a.oncomplete = () => {
          u == null ? r.close() : u.oncomplete = () => r.close();
        };
      }, s.onerror = (r) => n(s.error);
    });
  }
};
var Gs = "/";
var Ui = "tensorflowjs_models";
var bk = "info";
var N_ = "model_topology";
var T_ = "weight_specs";
var $_ = "weight_data";
var __ = "model_metadata";
function yk(e) {
  return { info: [Ui, e, bk].join(Gs), topology: [Ui, e, N_].join(Gs), weightSpecs: [Ui, e, T_].join(Gs), weightData: [Ui, e, $_].join(Gs), modelMetadata: [Ui, e, __].join(Gs) };
}
function vk(e) {
  for (let t of Object.values(e))
    window.localStorage.removeItem(t);
}
function A_(e) {
  let t = e.split(Gs);
  if (t.length < 3)
    throw new Error(`Invalid key format: ${e}`);
  return t.slice(1, t.length - 1).join(Gs);
}
function E_(e) {
  return e.startsWith(la.URL_SCHEME) ? e.slice(la.URL_SCHEME.length) : e;
}
var la = class {
  constructor(e) {
    if (!X().getBool("IS_BROWSER") || typeof window == "undefined" || typeof window.localStorage == "undefined")
      throw new Error("The current environment does not support local storage.");
    if (this.LS = window.localStorage, e == null || !e)
      throw new Error("For local storage, modelPath must not be null, undefined or empty.");
    this.modelPath = e, this.keys = yk(this.modelPath);
  }
  async save(e) {
    if (e.modelTopology instanceof ArrayBuffer)
      throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");
    {
      let t = JSON.stringify(e.modelTopology), n = JSON.stringify(e.weightSpecs), s = Fl(e);
      try {
        this.LS.setItem(this.keys.info, JSON.stringify(s)), this.LS.setItem(this.keys.topology, t), this.LS.setItem(this.keys.weightSpecs, n), this.LS.setItem(this.keys.weightData, h_(e.weightData));
        let r = { format: e.format, generatedBy: e.generatedBy, convertedBy: e.convertedBy, signature: e.signature != null ? e.signature : void 0, userDefinedMetadata: e.userDefinedMetadata != null ? e.userDefinedMetadata : void 0, modelInitializer: e.modelInitializer != null ? e.modelInitializer : void 0, trainingConfig: e.trainingConfig != null ? e.trainingConfig : void 0 };
        return this.LS.setItem(this.keys.modelMetadata, JSON.stringify(r)), { modelArtifactsInfo: s };
      } catch (r) {
        throw vk(this.keys), new Error(`Failed to save model '${this.modelPath}' to local storage: size quota being exceeded is a possible cause of this failure: modelTopologyBytes=${s.modelTopologyBytes}, weightSpecsBytes=${s.weightSpecsBytes}, weightDataBytes=${s.weightDataBytes}.`);
      }
    }
  }
  async load() {
    let e = JSON.parse(this.LS.getItem(this.keys.info));
    if (e == null)
      throw new Error(`In local storage, there is no model with name '${this.modelPath}'`);
    if (e.modelTopologyType !== "JSON")
      throw new Error("BrowserLocalStorage does not support loading non-JSON model topology yet.");
    let t = {}, n = JSON.parse(this.LS.getItem(this.keys.topology));
    if (n == null)
      throw new Error(`In local storage, the topology of model '${this.modelPath}' is missing.`);
    t.modelTopology = n;
    let s = JSON.parse(this.LS.getItem(this.keys.weightSpecs));
    if (s == null)
      throw new Error(`In local storage, the weight specs of model '${this.modelPath}' are missing.`);
    t.weightSpecs = s;
    let r = this.LS.getItem(this.keys.modelMetadata);
    if (r != null) {
      let i = JSON.parse(r);
      t.format = i.format, t.generatedBy = i.generatedBy, t.convertedBy = i.convertedBy, i.signature != null && (t.signature = i.signature), i.userDefinedMetadata != null && (t.userDefinedMetadata = i.userDefinedMetadata), i.modelInitializer != null && (t.modelInitializer = i.modelInitializer), i.trainingConfig != null && (t.trainingConfig = i.trainingConfig);
    }
    let a = this.LS.getItem(this.keys.weightData);
    if (a == null)
      throw new Error(`In local storage, the binary weight values of model '${this.modelPath}' are missing.`);
    return t.weightData = f_(a), t;
  }
};
la.URL_SCHEME = "localstorage://";
var xk = (e) => X().getBool("IS_BROWSER") && !Array.isArray(e) && e.startsWith(la.URL_SCHEME) ? R_(e.slice(la.URL_SCHEME.length)) : null;
xt.registerSaveRouter(xk);
xt.registerLoadRouter(xk);
function R_(e) {
  return new la(e);
}
var D_ = class {
  constructor() {
    O(X().getBool("IS_BROWSER"), () => "Current environment is not a web browser"), O(typeof window == "undefined" || typeof window.localStorage != "undefined", () => "Current browser does not appear to support localStorage"), this.LS = window.localStorage;
  }
  async listModels() {
    let e = {}, t = Ui + Gs, n = Gs + bk;
    for (let s = 0; s < this.LS.length; ++s) {
      let r = this.LS.key(s);
      if (r.startsWith(t) && r.endsWith(n)) {
        let a = A_(r);
        e[a] = JSON.parse(this.LS.getItem(r));
      }
    }
    return e;
  }
  async removeModel(e) {
    e = E_(e);
    let t = yk(e);
    if (this.LS.getItem(t.info) == null)
      throw new Error(`Cannot find model at path '${e}'`);
    let n = JSON.parse(this.LS.getItem(t.info));
    return vk(t), n;
  }
};
var qi = "://";
var zn = class {
  constructor() {
    this.managers = {};
  }
  static getInstance() {
    return zn.instance == null && (zn.instance = new zn()), zn.instance;
  }
  static registerManager(e, t) {
    O(e != null, () => "scheme must not be undefined or null."), e.endsWith(qi) && (e = e.slice(0, e.indexOf(qi))), O(e.length > 0, () => "scheme must not be an empty string.");
    let n = zn.getInstance();
    O(n.managers[e] == null, () => `A model store manager is already registered for scheme '${e}'.`), n.managers[e] = t;
  }
  static getManager(e) {
    let t = this.getInstance().managers[e];
    if (t == null)
      throw new Error(`Cannot find model manager for scheme '${e}'`);
    return t;
  }
  static getSchemes() {
    return Object.keys(this.getInstance().managers);
  }
};
function td(e) {
  if (e.indexOf(qi) === -1)
    throw new Error(`The url string provided does not contain a scheme. Supported schemes are: ${zn.getSchemes().join(",")}`);
  return { scheme: e.split(qi)[0], path: e.split(qi)[1] };
}
async function wk(e, t, n = false) {
  O(e !== t, () => `Old path and new path are the same: '${e}'`);
  let s = xt.getLoadHandlers(e);
  O(s.length > 0, () => `Copying failed because no load handler is found for source URL ${e}.`), O(s.length < 2, () => `Copying failed because more than one (${s.length}) load handlers for source URL ${e}.`);
  let r = s[0], a = xt.getSaveHandlers(t);
  O(a.length > 0, () => `Copying failed because no save handler is found for destination URL ${t}.`), O(a.length < 2, () => `Copying failed because more than one (${s.length}) save handlers for destination URL ${t}.`);
  let i = a[0], o = td(e).scheme, u = td(e).path, l = o === td(e).scheme, c = await r.load();
  n && l && await zn.getManager(o).removeModel(u);
  let p = await i.save(c);
  return n && !l && await zn.getManager(o).removeModel(u), p.modelArtifactsInfo;
}
async function F_() {
  let e = zn.getSchemes(), t = {};
  for (let n of e) {
    let s = await zn.getManager(n).listModels();
    for (let r in s) {
      let a = n + qi + r;
      t[a] = s[r];
    }
  }
  return t;
}
async function O_(e) {
  let t = td(e);
  return zn.getManager(t.scheme).removeModel(t.path);
}
async function P_(e, t) {
  return wk(e, t, false);
}
async function z_(e, t) {
  return wk(e, t, true);
}
var M_ = class {
  fetch(e, t) {
    return fetch(e, t);
  }
  now() {
    return performance.now();
  }
  encode(e, t) {
    if (t !== "utf-8" && t !== "utf8")
      throw new Error(`Browser's encoder only supports utf-8, but got ${t}`);
    return this.textEncoder == null && (this.textEncoder = new TextEncoder()), this.textEncoder.encode(e);
  }
  decode(e, t) {
    return new TextDecoder(t).decode(e);
  }
};
if (X().get("IS_BROWSER")) {
  X().setPlatform("browser", new M_());
  try {
    zn.registerManager(la.URL_SCHEME, new D_());
  } catch (e) {
  }
  try {
    zn.registerManager(ua.URL_SCHEME, new C_());
  } catch (e) {
  }
}
var L_ = { importFetch: () => qT() };
var Pf;
var B_ = class {
  constructor() {
    this.util = jT(), this.textEncoder = new this.util.TextEncoder();
  }
  fetch(e, t) {
    return X().global.fetch != null ? X().global.fetch(e, t) : (Pf == null && (Pf = L_.importFetch()), Pf(e, t));
  }
  now() {
    let e = process.hrtime();
    return e[0] * 1e3 + e[1] / 1e6;
  }
  encode(e, t) {
    if (t !== "utf-8" && t !== "utf8")
      throw new Error(`Node built-in encoder only supports utf-8, but got ${t}`);
    return this.textEncoder.encode(e);
  }
  decode(e, t) {
    return e.length === 0 ? "" : new this.util.TextDecoder(t).decode(e);
  }
};
X().get("IS_NODE") && !X().get("IS_BROWSER") && X().setPlatform("node", new B_());
function De(e, t = "float32", n) {
  return t = t || "float32", sg(e), new Vt(e, t, n);
}
function V_(e, t) {
  let n = _(e, "x", "cast");
  if (!Kw(t))
    throw new Error(`Failed to cast to unknown dtype ${t}`);
  if (t === "string" && n.dtype !== "string" || t !== "string" && n.dtype === "string")
    throw new Error("Only strings can be casted to strings");
  let s = { x: n }, r = { dtype: t };
  return M.runKernel(Na, s, r);
}
var ce = L({ cast_: V_ });
function W_(e) {
  let n = { x: _(e, "x", "clone", "string_or_numeric") };
  return M.runKernel(Ba, n);
}
var lr = L({ clone_: W_ });
function U_(e, t = false) {
  console.log(e.toString(t));
}
ck();
var G_ = { buffer: De, cast: ce, clone: lr, print: U_ };
Q$(G_);
var En = {};
Ae(En, { browserFiles: () => Q_, browserHTTPRequest: () => nA, concatenateArrayBuffers: () => Og, copyModel: () => P_, decodeWeights: () => hk, encodeWeights: () => d_, fromMemory: () => rA, getLoadHandlers: () => k_, getModelArtifactsForJSON: () => Pg, getModelArtifactsInfoForJSON: () => Fl, getSaveHandlers: () => w_, http: () => Mg, isHTTPScheme: () => um, listModels: () => F_, loadWeights: () => Z_, moveModel: () => z_, registerLoadRouter: () => x_, registerSaveRouter: () => v_, removeModel: () => O_, weightsLoaderFactory: () => Ik, withSaveHandler: () => aA });
var H_ = "model";
var q_ = ".json";
var j_ = ".weights.bin";
function cx(e) {
  return new Promise((t) => setTimeout(t)).then(e);
}
var om = class {
  constructor(e) {
    if (!X().getBool("IS_BROWSER"))
      throw new Error("browserDownloads() cannot proceed because the current environment is not a browser.");
    e.startsWith(om.URL_SCHEME) && (e = e.slice(om.URL_SCHEME.length)), (e == null || e.length === 0) && (e = H_), this.modelJsonFileName = e + q_, this.weightDataFileName = e + j_;
  }
  async save(e) {
    if (typeof document == "undefined")
      throw new Error("Browser downloads are not supported in this environment since `document` is not present");
    let t = window.URL.createObjectURL(new Blob([e.weightData], { type: "application/octet-stream" }));
    if (e.modelTopology instanceof ArrayBuffer)
      throw new Error("BrowserDownloads.save() does not support saving model topology in binary formats yet.");
    {
      let n = [{ paths: ["./" + this.weightDataFileName], weights: e.weightSpecs }], s = fk(e, n), r = window.URL.createObjectURL(new Blob([JSON.stringify(s)], { type: "application/json" })), a = this.modelJsonAnchor == null ? document.createElement("a") : this.modelJsonAnchor;
      if (a.download = this.modelJsonFileName, a.href = r, await cx(() => a.dispatchEvent(new MouseEvent("click"))), e.weightData != null) {
        let i = this.weightDataAnchor == null ? document.createElement("a") : this.weightDataAnchor;
        i.download = this.weightDataFileName, i.href = t, await cx(() => i.dispatchEvent(new MouseEvent("click")));
      }
      return { modelArtifactsInfo: Fl(e) };
    }
  }
};
var yd = om;
yd.URL_SCHEME = "downloads://";
var K_ = class {
  constructor(e) {
    if (e == null || e.length < 1)
      throw new Error(`When calling browserFiles, at least 1 file is required, but received ${e}`);
    this.jsonFile = e[0], this.weightsFiles = e.slice(1);
  }
  async load() {
    return new Promise((e, t) => {
      let n = new FileReader();
      n.onload = (s) => {
        let r = JSON.parse(s.target.result), a = r.modelTopology;
        if (a == null) {
          t(new Error(`modelTopology field is missing from file ${this.jsonFile.name}`));
          return;
        }
        if (r.weightsManifest == null) {
          t(new Error(`weightManifest field is missing from file ${this.jsonFile.name}`));
          return;
        }
        if (this.weightsFiles.length === 0) {
          e({ modelTopology: a });
          return;
        }
        let o = Pg(r, (u) => this.loadWeights(u));
        e(o);
      }, n.onerror = (s) => t(`Failed to read model topology and weights manifest JSON from file '${this.jsonFile.name}'. BrowserFiles supports loading Keras-style tf.Model artifacts only.`), n.readAsText(this.jsonFile);
    });
  }
  loadWeights(e) {
    let t = [], n = [];
    for (let a of e)
      t.push(...a.weights), n.push(...a.paths);
    let s = this.checkManifestAndWeightFiles(e), r = n.map((a) => this.loadWeightsFile(a, s[a]));
    return Promise.all(r).then((a) => [t, Og(a)]);
  }
  loadWeightsFile(e, t) {
    return new Promise((n, s) => {
      let r = new FileReader();
      r.onload = (a) => {
        let i = a.target.result;
        n(i);
      }, r.onerror = (a) => s(`Failed to weights data from file of path '${e}'.`), r.readAsArrayBuffer(t);
    });
  }
  checkManifestAndWeightFiles(e) {
    let t = [], n = this.weightsFiles.map((r) => lx(r.name)), s = {};
    for (let r of e)
      r.paths.forEach((a) => {
        let i = lx(a);
        if (t.indexOf(i) !== -1)
          throw new Error(`Duplicate file basename found in weights manifest: '${i}'`);
        if (t.push(i), n.indexOf(i) === -1)
          throw new Error(`Weight file with basename '${i}' is not provided.`);
        s[a] = this.weightsFiles[n.indexOf(i)];
      });
    if (t.length !== this.weightsFiles.length)
      throw new Error(`Mismatch in the number of files in weights manifest (${t.length}) and the number of weight files provided (${this.weightsFiles.length}).`);
    return s;
  }
};
var X_ = (e) => X().getBool("IS_BROWSER") && !Array.isArray(e) && e.startsWith(yd.URL_SCHEME) ? Y_(e.slice(yd.URL_SCHEME.length)) : null;
xt.registerSaveRouter(X_);
function Y_(e = "model") {
  return new yd(e);
}
function Q_(e) {
  return new K_(e);
}
function dx(e, t, n, s) {
  i(e), n = n == null ? 0 : n, s = s == null ? 1 : s, o(n, s);
  let r = 0, a = (u) => (u.then((l) => {
    let c = n + ++r / e.length * (s - n);
    return t(c), l;
  }), u);
  function i(u) {
    O(u != null && Array.isArray(u) && u.length > 0, () => "promises must be a none empty array");
  }
  function o(u, l) {
    O(u >= 0 && u <= 1, () => `Progress fraction must be in range [0, 1], but got startFraction ${u}`), O(l >= 0 && l <= 1, () => `Progress fraction must be in range [0, 1], but got endFraction ${l}`), O(l >= u, () => `startFraction must be no more than endFraction, but got startFraction ${u} and endFraction ${l}`);
  }
  return Promise.all(e.map(a));
}
async function kk(e, t) {
  t == null && (t = {});
  let n = t.fetchFunc == null ? X().platform.fetch : t.fetchFunc, s = e.map((p) => n(p, t.requestInit, { isBinary: true })), r = 0, a = 0.5, o = (t.onProgress == null ? await Promise.all(s) : await dx(s, t.onProgress, r, a)).map((p) => p.arrayBuffer()), u = 0.5, l = 1;
  return t.onProgress == null ? await Promise.all(o) : await dx(o, t.onProgress, u, l);
}
async function Z_(e, t = "", n, s) {
  return Ik((i) => kk(i, { requestInit: s }))(e, t, n);
}
function Ik(e) {
  return async (t, n = "", s) => {
    let r = t.map(() => false), a = {}, i = s != null ? s.map(() => false) : [], o = [];
    if (t.forEach((h, f) => {
      let m = 0;
      h.weights.forEach((g) => {
        let b = "quantization" in g ? g.quantization.dtype : g.dtype, y = sm[b] * pt(g.shape), v = () => {
          r[f] = true, a[f] == null && (a[f] = []), a[f].push({ manifestEntry: g, groupOffset: m, sizeBytes: y });
        };
        s != null ? s.forEach((x, k) => {
          x === g.name && (v(), i[k] = true);
        }) : v(), o.push(g.name), m += y;
      });
    }), !i.every((h) => h)) {
      let h = s.filter((f, m) => !i[m]);
      throw new Error(`Could not find weights in manifest with names: ${h.join(", ")}. 
Manifest JSON has weights with names: ${o.join(", ")}.`);
    }
    let u = r.reduce((h, f, m) => (f && h.push(m), h), []), l = [];
    u.forEach((h) => {
      t[h].paths.forEach((f) => {
        let m = n + (n.endsWith("/") ? "" : "/") + f;
        l.push(m);
      });
    });
    let c = await e(l), p = {}, d = 0;
    return u.forEach((h) => {
      let f = t[h].paths.length, m = 0;
      for (let x = 0; x < f; x++)
        m += c[d + x].byteLength;
      let g = new ArrayBuffer(m), b = new Uint8Array(g), y = 0;
      for (let x = 0; x < f; x++) {
        let k = new Uint8Array(c[d + x]);
        b.set(k, y), y += k.byteLength;
      }
      a[h].forEach((x) => {
        let k = g.slice(x.groupOffset, x.groupOffset + x.sizeBytes), T = hk(k, [x.manifestEntry]);
        for (let N in T)
          p[N] = T[N];
      }), d += f;
    }), p;
  };
}
var J_ = "application/octet-stream";
var eA = "application/json";
var zg = class {
  constructor(e, t) {
    if (this.DEFAULT_METHOD = "POST", t == null && (t = {}), this.weightPathPrefix = t.weightPathPrefix, this.onProgress = t.onProgress, this.weightUrlConverter = t.weightUrlConverter, t.fetchFunc != null ? (O(typeof t.fetchFunc == "function", () => "Must pass a function that matches the signature of `fetch` (see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)"), this.fetch = t.fetchFunc) : this.fetch = X().platform.fetch, O(e != null && e.length > 0, () => "URL path for http must not be null, undefined or empty."), Array.isArray(e) && O(e.length === 2, () => `URL paths for http must have a length of 2, (actual length is ${e.length}).`), this.path = e, t.requestInit != null && t.requestInit.body != null)
      throw new Error("requestInit is expected to have no pre-existing body, but has one.");
    this.requestInit = t.requestInit || {};
  }
  async save(e) {
    if (e.modelTopology instanceof ArrayBuffer)
      throw new Error("BrowserHTTPRequest.save() does not support saving model topology in binary formats yet.");
    let t = Object.assign({ method: this.DEFAULT_METHOD }, this.requestInit);
    t.body = new FormData();
    let n = [{ paths: ["./model.weights.bin"], weights: e.weightSpecs }], s = fk(e, n);
    t.body.append("model.json", new Blob([JSON.stringify(s)], { type: eA }), "model.json"), e.weightData != null && t.body.append("model.weights.bin", new Blob([e.weightData], { type: J_ }), "model.weights.bin");
    let r = await this.fetch(this.path, t);
    if (r.ok)
      return { modelArtifactsInfo: Fl(e), responses: [r] };
    throw new Error(`BrowserHTTPRequest.save() failed due to HTTP response status ${r.status}.`);
  }
  async load() {
    let e = await this.fetch(this.path, this.requestInit);
    if (!e.ok)
      throw new Error(`Request to ${this.path} failed with status code ${e.status}. Please verify this URL points to the model JSON of the model to load.`);
    let t;
    try {
      t = await e.json();
    } catch (r) {
      let a = `Failed to parse model JSON of response from ${this.path}.`;
      throw this.path.endsWith(".pb") ? a += " Your path contains a .pb file extension. Support for .pb models have been removed in TensorFlow.js 1.0 in favor of .json models. You can re-convert your Python TensorFlow model using the TensorFlow.js 1.0 conversion scripts or you can convert your.pb models with the 'pb2json'NPM script in the tensorflow/tfjs-converter repository." : a += " Please make sure the server is serving valid JSON for this request.", new Error(a);
    }
    let n = t.modelTopology, s = t.weightsManifest;
    if (n == null && s == null)
      throw new Error(`The JSON from HTTP path ${this.path} contains neither model topology or manifest for weights.`);
    return Pg(t, (r) => this.loadWeights(r));
  }
  async loadWeights(e) {
    let t = Array.isArray(this.path) ? this.path[1] : this.path, [n, s] = tA(t), r = this.weightPathPrefix || n, a = [];
    for (let l of e)
      a.push(...l.weights);
    let i = [], o = [];
    for (let l of e)
      for (let c of l.paths)
        this.weightUrlConverter != null ? o.push(this.weightUrlConverter(c)) : i.push(r + c + s);
    this.weightUrlConverter && i.push(...await Promise.all(o));
    let u = await kk(i, { requestInit: this.requestInit, fetchFunc: this.fetch, onProgress: this.onProgress });
    return [a, Og(u)];
  }
};
zg.URL_SCHEME_REGEX = /^https?:\/\//;
function tA(e) {
  let t = e.lastIndexOf("/"), n = e.lastIndexOf("?"), s = e.substring(0, t), r = n > t ? e.substring(n) : "";
  return [s + "/", r];
}
function um(e) {
  return e.match(zg.URL_SCHEME_REGEX) != null;
}
var Sk = (e, t) => {
  if (typeof fetch == "undefined" && (t == null || t.fetchFunc == null))
    return null;
  {
    let n = true;
    if (Array.isArray(e) ? n = e.every((s) => um(s)) : n = um(e), n)
      return Mg(e, t);
  }
  return null;
};
xt.registerSaveRouter(Sk);
xt.registerLoadRouter(Sk);
function Mg(e, t) {
  return new zg(e, t);
}
function nA(e, t) {
  return Mg(e, t);
}
var zf = class {
  constructor(e) {
    this.modelArtifacts = e;
  }
  async load() {
    return this.modelArtifacts;
  }
};
var sA = class {
  constructor(e) {
    this.saveHandler = e;
  }
  async save(e) {
    return this.saveHandler(e);
  }
};
function rA(e, t, n, s) {
  return arguments.length === 1 ? e.modelTopology != null || e.weightSpecs != null ? new zf(e) : (console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."), new zf({ modelTopology: e })) : (console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."), new zf({ modelTopology: e, weightSpecs: t, weightData: n, trainingConfig: s }));
}
function aA(e) {
  return new sA(e);
}
var iA = {};
Ae(iA, { confusionMatrix: () => dA });
function oA(e, t, n = false, s = false) {
  let r = _(e, "a", "matMul"), a = _(t, "b", "matMul");
  [r, a] = vt(r, a);
  let i = { a: r, b: a }, o = { transposeA: n, transposeB: s };
  return M.runKernel(Ca, i, o);
}
var We = L({ matMul_: oA });
function uA(e, t, n = 1, s = 0) {
  if (t < 2)
    throw new Error(`Error in oneHot: depth must be >=2, but it is ${t}`);
  let a = { indices: _(e, "indices", "oneHot", "int32") }, i = { depth: t, onValue: n, offValue: s };
  return M.runKernel($o, a, i);
}
var vd = L({ oneHot_: uA });
function lA(e, t) {
  let n = _(e, "x", "transpose");
  if (t == null && (t = n.shape.map((a, i) => i).reverse()), O(n.rank === t.length, () => `Error in transpose: rank of input ${n.rank} must match length of perm ${t}.`), t.forEach((a) => {
    O(a >= 0 && a < n.rank, () => `All entries in 'perm' must be between 0 and ${n.rank - 1} but got ${t}`);
  }), n.rank <= 1)
    return n.clone();
  let s = { x: n }, r = { perm: t };
  return M.runKernel(pi, s, r);
}
var qe = L({ transpose_: lA });
function cA(e, t, n) {
  let s = _(e, "labels", "confusionMatrix"), r = _(t, "predictions", "confusionMatrix");
  O(n == null || n > 0 && Number.isInteger(n), () => `If provided, numClasses must be a positive integer, but got ${n}`), O(s.rank === 1, () => `Expected the rank of labels to be 1, but got ${s.rank}`), O(r.rank === 1, () => `Expected the rank of predictions to be 1, but got ${r.rank}`), O(s.shape[0] === r.shape[0], () => `Mismatch in the number of examples: ${s.shape[0]} vs. ${r.shape[0]}. Labels and predictions should have the same number of elements.`), O(n > 0 && Number.isInteger(n), () => `numClasses is required to be a positive integer, but got ${n}`);
  let a = vd(ce(s, "int32"), n), i = vd(ce(r, "int32"), n), o = qe(a), u = We(o, i);
  return ce(u, "int32");
}
var dA = L({ confusionMatrix_: cA });
var jo = {};
Ae(jo, { assertAndGetBroadcastShape: () => ot, getBroadcastDims: () => Ck, getReductionAxes: () => _t });
function Ck(e, t) {
  let n = e.length, s = [];
  for (let r = 0; r < n; r++) {
    let a = n - 1 - r, i = e[a] || 1;
    (t[t.length - 1 - r] || 1) > 1 && i === 1 && s.unshift(a);
  }
  return s;
}
function _t(e, t) {
  let n = [];
  for (let s = 0; s < t.length; s++) {
    let r = e[e.length - s - 1], a = t.length - s - 1, i = t[a];
    (r == null || r === 1 && i > 1) && n.unshift(a);
  }
  return n;
}
function ot(e, t) {
  let n = [], s = Math.max(e.length, t.length);
  for (let r = 0; r < s; r++) {
    let a = e[e.length - r - 1];
    a == null && (a = 1);
    let i = t[t.length - r - 1];
    if (i == null && (i = 1), a === 1)
      n.unshift(i);
    else if (i === 1)
      n.unshift(a);
    else if (a !== i) {
      let o = `Operands could not be broadcast together with shapes ${e} and ${t}.`;
      throw Error(o);
    } else
      n.unshift(a);
  }
  return n;
}
var Nk = {};
Ae(Nk, { fromPixels: () => vA, fromPixelsAsync: () => bA, toPixels: () => yA });
function pA(e, t, n) {
  if (wa(e), t != null && t.length !== 3)
    throw new Error("tensor3d() requires shape to have three numbers");
  let s = Rs(e, n);
  if (s.length !== 3 && s.length !== 1)
    throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");
  if (s.length === 1 && t == null)
    throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");
  return Nr(e, t, s, n);
}
var Vr;
function Tk(e, t = 3) {
  if (t > 4)
    throw new Error("Cannot construct Tensor with more than 4 channels from pixels.");
  if (e == null)
    throw new Error("pixels passed to tf.browser.fromPixels() can not be null");
  let n = false, s = false, r = false, a = false, i = false, o = false;
  if (e.data instanceof Uint8Array)
    n = true;
  else if (typeof ImageData != "undefined" && e instanceof ImageData)
    s = true;
  else if (typeof HTMLVideoElement != "undefined" && e instanceof HTMLVideoElement)
    r = true;
  else if (typeof HTMLImageElement != "undefined" && e instanceof HTMLImageElement)
    a = true;
  else if (e.getContext != null)
    i = true;
  else if (typeof ImageBitmap != "undefined" && e instanceof ImageBitmap)
    o = true;
  else
    throw new Error(`pixels passed to tf.browser.fromPixels() must be either an HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData in browser, or OffscreenCanvas, ImageData in webworker or {data: Uint32Array, width: number, height: number}, but was ${e.constructor.name}`);
  if (r && r && e.readyState < 2)
    throw new Error("The video element has not loaded data yet. Please wait for `loadeddata` event on the <video> element.");
  if (Zf(fd, M.backendName) != null) {
    let f = { pixels: e }, m = { numChannels: t };
    return M.runKernel(fd, f, m);
  }
  let [l, c] = r ? [e.videoWidth, e.videoHeight] : [e.width, e.height], p;
  if (i)
    p = e.getContext("2d").getImageData(0, 0, l, c).data;
  else if (s || n)
    p = e.data;
  else if (a || r || o) {
    if (Vr == null)
      if (typeof document == "undefined")
        if (typeof OffscreenCanvas != "undefined" && typeof OffscreenCanvasRenderingContext2D != "undefined")
          Vr = new OffscreenCanvas(1, 1).getContext("2d");
        else
          throw new Error("Cannot parse input in current context. Reason: OffscreenCanvas Context2D rendering is not supported.");
      else
        Vr = document.createElement("canvas").getContext("2d");
    Vr.canvas.width = l, Vr.canvas.height = c, Vr.drawImage(e, 0, 0, l, c), p = Vr.getImageData(0, 0, l, c).data;
  }
  let d;
  if (t === 4)
    d = new Int32Array(p);
  else {
    let f = l * c;
    d = new Int32Array(f * t);
    for (let m = 0; m < f; m++)
      for (let g = 0; g < t; ++g)
        d[m * t + g] = p[m * 4 + g];
  }
  return pA(d, [c, l, t], "int32");
}
function hA(e) {
  return e != null && e.data instanceof Uint8Array;
}
function fA() {
  return typeof window != "undefined" && typeof ImageBitmap != "undefined" && window.hasOwnProperty("createImageBitmap");
}
function mA(e) {
  return e != null && e.width !== 0 && e.height !== 0;
}
function gA(e) {
  return fA() && !(e instanceof ImageBitmap) && mA(e) && !hA(e);
}
async function bA(e, t = 3) {
  let n = null;
  if (X().getBool("WRAP_TO_IMAGEBITMAP") && gA(e)) {
    let s;
    try {
      s = await createImageBitmap(e, { premultiplyAlpha: "none" });
    } catch (r) {
      s = null;
    }
    s != null && s.width === e.width && s.height === e.height ? n = s : n = e;
  } else
    n = e;
  return Tk(n, t);
}
async function yA(e, t) {
  let n = _(e, "img", "toPixels");
  if (!(e instanceof et)) {
    let l = n;
    n = ce(l, "int32"), l.dispose();
  }
  if (n.rank !== 2 && n.rank !== 3)
    throw new Error(`toPixels only supports rank 2 or 3 tensors, got rank ${n.rank}.`);
  let [s, r] = n.shape.slice(0, 2), a = n.rank === 2 ? 1 : n.shape[2];
  if (a > 4 || a === 2)
    throw new Error(`toPixels only supports depth of size 1, 3 or 4 but got ${a}`);
  if (n.dtype !== "float32" && n.dtype !== "int32")
    throw new Error(`Unsupported type for toPixels: ${n.dtype}. Please use float32 or int32 tensors.`);
  let i = await n.data(), o = n.dtype === "float32" ? 255 : 1, u = new Uint8ClampedArray(r * s * 4);
  for (let l = 0; l < s * r; ++l) {
    let c = [0, 0, 0, 255];
    for (let d = 0; d < a; d++) {
      let h = i[l * a + d];
      if (n.dtype === "float32") {
        if (h < 0 || h > 1)
          throw new Error(`Tensor values for a float32 Tensor must be in the range [0 - 1] but encountered ${h}.`);
      } else if (n.dtype === "int32" && (h < 0 || h > 255))
        throw new Error(`Tensor values for a int32 Tensor must be in the range [0 - 255] but encountered ${h}.`);
      a === 1 ? (c[0] = h * o, c[1] = h * o, c[2] = h * o) : c[d] = h * o;
    }
    let p = l * 4;
    u[p + 0] = Math.round(c[0]), u[p + 1] = Math.round(c[1]), u[p + 2] = Math.round(c[2]), u[p + 3] = Math.round(c[3]);
  }
  if (t != null) {
    t.width = r, t.height = s;
    let l = t.getContext("2d"), c = new ImageData(u, r, s);
    l.putImageData(c, 0, 0);
  }
  return n !== e && n.dispose(), u;
}
var vA = L({ fromPixels_: Tk });
var $k = {};
Ae($k, { prepareAndValidate: () => _k });
function _k(e, t) {
  let n = e.shape.length, s = t.shape.length;
  if (n < 1)
    throw new Error(`tf.gatherND() expects the input to be rank 1 or higher, but the rank was ${n}.`);
  if (s < 1)
    throw new Error(`tf.gatherND() expects the indices to be rank 1 or higher, but the rank was ${s}.`);
  if (t.dtype !== "int32")
    throw new Error(`tf.gatherND() expects the indices to be int32 type, but the dtype was ${t.dtype}.`);
  if (t.shape[s - 1] > n)
    throw new Error(`index innermost dimension length must be <= tensor rank; saw: ${t.shape[s - 1]} vs. ${n}`);
  if (pt(e.shape) === 0)
    throw new Error(`Requested more than 0 entries, but input is empty. Input shape: ${e.shape}.`);
  let r = t.shape, a = r[r.length - 1], i = 1;
  for (let p = 0; p < r.length - 1; ++p)
    i *= r[p];
  let o = e.shape, u = r.slice();
  u.pop();
  let l = 1;
  for (let p = a; p < n; ++p)
    l *= o[p], u.push(o[p]);
  let c = [...ao(e.shape).map((p) => p / l), 1].slice(0, a);
  return [u, i, l, c];
}
var Ak = {};
Ae(Ak, { calculateShapes: () => Ek, validateInput: () => Bg, validateUpdateShape: () => Lg });
function Lg(e, t, n) {
  let s = t.rank > 1 ? t.shape[t.rank - 1] : 1, r = t.rank > 1 ? t.rank - 1 : 1, a = `Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: ${n.shape}, indices.shape: ${t.shape}, shape: ${e}, sliceDim: ${s}, and batchDim: ${r}.`;
  if (n.rank < r)
    throw new Error(a + ` update.rank < ${r}. `);
  if (e.length < s + (n.rank - r))
    throw new Error(a + ` Output shape length < ${s + (n.rank - r)}`);
  if (n.rank !== r + e.length - s)
    throw new Error(a + ` update.rank != ${r + e.length - s}`);
  for (let i = 0; i < r; ++i)
    if (n.shape[i] !== t.shape[i])
      throw new Error(a + ` updates.shape[${i}] (${n.shape[i]}) != indices.shape[${i}] (${t.shape[i]}).`);
  for (let i = 0; i < n.rank - r; ++i)
    if (n.shape[i + r] !== e[i + s])
      throw new Error(a + ` updates.shape[${i + r}] (${n.shape[i + r]}) != shape[${i + r}] (${e[i + r]})`);
}
function Bg(e, t, n) {
  if (t.rank < 1)
    throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${t.rank}.`);
  if (e.rank < 1)
    throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${e.rank}.`);
  if (t.dtype !== "int32")
    throw new Error(`The dtype of 'indices' should be int32, but got dtype: ${t.dtype}`);
  if (n.length < 1)
    throw new Error(`Output rank must be greater or equal to 1, but got shape: ${n}`);
  if (n.length === 0) {
    if (t.size === 0)
      throw new Error(`Indices specified for empty output. indices shape: ${t.shape}`);
    if (e.size === 0)
      throw new Error(`Updates specified for empty output. updates shape: ${e.shape}`);
  }
  Lg(n, t, e);
}
function Ek(e, t, n) {
  let s = t.shape.length, r = s > 1 ? t.shape[s - 1] : 1, a = n.length, i = 1;
  for (let p = r; p < a; ++p)
    i *= n[p];
  let o = r < 1 ? 1 : r, u = pt(t.shape) / o, l = [...ao(n.slice(0, r)), 1], c = pt(n);
  return { sliceRank: r, numUpdates: u, sliceSize: i, strides: l, outputSize: c };
}
var wt = {};
Ae(wt, { assertParamsValid: () => wA, computeFlatOffset: () => NA, computeOutShape: () => IA, getNormalizedAxes: () => SA, isSliceContinous: () => CA, maskToAxes: () => kA, parseSliceParams: () => Bk, sliceInfo: () => TA, startForAxis: () => Mk, startIndicesWithElidedDims: () => Ok, stopForAxis: () => Lk, stopIndicesWithElidedDims: () => Pk, stridesForAxis: () => zk, stridesWithElidedDims: () => Rk });
var lm = -2;
var xA = -1;
function wA(e, t, n) {
  let s = e.shape.length;
  O(s === t.length, () => `Error in slice${s}D: Length of begin ${t} must match the rank of the array (${s}).`), O(s === n.length, () => `Error in slice${s}D: Length of size ${n} must match the rank of the array (${s}).`);
  for (let r = 0; r < s; ++r)
    O(t[r] + n[r] <= e.shape[r], () => `Error in slice${s}D: begin[${r}] + size[${r}] (${t[r] + n[r]}) would overflow input.shape[${r}] (${e.shape[r]})`);
}
function kA(e) {
  let t = [], n = 0;
  for (; e > 0; )
    e & 1 && t.push(n), e /= 2, n++;
  return t;
}
function IA(e, t, n) {
  let s = [];
  for (let r = 0; r < e.length; r++)
    s[r] = Math.ceil((t[r] - e[r]) / n[r]);
  return s;
}
function Rk(e, t, n, s) {
  let r = [...e];
  for (let a = r.length; a < s.length; a++)
    r.push(1);
  for (let a = 0; a < n; a++)
    a === 0 ? r[t] = 1 : (r.splice(t, 0, 1), r.pop());
  return r;
}
function Dk(e, t, n) {
  return n <= e ? n : n - (t - 1);
}
function Fk(e, t) {
  let n = [];
  for (let s = 0; s < e; s++)
    n.push(t + s);
  return n;
}
function SA(e, t, n, s, r, a, i, o, u) {
  let l = e.length, c = new Array(l), p = new Array(l), d = new Array(l);
  if (t.length && n > 0) {
    let h = t[0], f = n + 1;
    c = Ok(i, h, f, s, e), p = Pk(o, h, f, r, e), d = Rk(a, h, f, e);
  } else
    for (let h = 0; h < l; h++)
      c[h] = Mk(i, s, a, e, h, u), p[h] = Lk(o, r, a, e, h, u), d[h] = zk(a, h, u);
  return { begin: c, end: p, strides: d };
}
function Ok(e, t, n, s, r) {
  let a = [...r], i = Fk(n, t);
  for (let o = 0; o < a.length; o++)
    if (i.indexOf(o) > -1)
      a[o] = 0;
    else {
      let u = Dk(t, n, o), l = s[u];
      e & 1 << u && (l = 0), a[o] = l;
    }
  return a;
}
function Pk(e, t, n, s, r) {
  let a = [...r], i = Fk(n, t);
  for (let o = 0; o < a.length; o++)
    if (i.indexOf(o) > -1)
      a[o] = Number.MAX_SAFE_INTEGER;
    else {
      let u = Dk(t, n, o), l = s[u];
      e & 1 << u && (l = Number.MAX_SAFE_INTEGER), a[o] = l;
    }
  for (let o = 0; o < a.length; o++) {
    let u = r[o];
    a[o] < 0 && (a[o] += u), a[o] = Vu(0, a[o], r[o]);
  }
  return a;
}
function zk(e, t, n) {
  let s = e[t];
  return (n & 1 << t || s == null) && (s = 1), s;
}
function Mk(e, t, n, s, r, a) {
  let i = t[r], o = n[r] || 1;
  (e & 1 << r || a & 1 << r || i == null) && (o > 0 ? i = Number.MIN_SAFE_INTEGER : i = Number.MAX_SAFE_INTEGER);
  let u = s[r];
  return i < 0 && (i += u), i = Vu(0, i, u - 1), i;
}
function Lk(e, t, n, s, r, a) {
  let i = t[r], o = n[r] || 1;
  (e & 1 << r || a & 1 << r || i == null) && (o > 0 ? i = Number.MAX_SAFE_INTEGER : i = Number.MIN_SAFE_INTEGER);
  let u = s[r];
  return i < 0 && (i += u), o > 0 ? i = Vu(0, i, u) : i = Vu(-1, i, u - 1), i;
}
function CA(e, t, n) {
  let s = n.length;
  for (let r = 0; r < n.length; r++)
    if (n[r] > 1) {
      s = r;
      break;
    }
  for (let r = s + 1; r < n.length; r++)
    if (t[r] > 0 || n[r] !== e[r])
      return false;
  return true;
}
function NA(e, t) {
  let n = e.length > 0 ? e[e.length - 1] : 1;
  for (let s = 0; s < e.length - 1; s++)
    n += e[s] * t[s];
  return n;
}
function Bk(e, t, n) {
  let s, r = e.shape.length;
  typeof t == "number" ? s = [t, ...new Array(r - 1).fill(0)] : t.length < r ? s = t.concat(new Array(r - t.length).fill(0)) : s = t.slice(), s.forEach((i) => {
    O(i !== -1, () => "slice() does not support negative begin indexing.");
  });
  let a;
  return n == null ? a = new Array(r).fill(-1) : typeof n == "number" ? a = [n, ...new Array(r - 1).fill(-1)] : n.length < r ? a = n.concat(new Array(r - n.length).fill(-1)) : a = n, a = a.map((i, o) => i >= 0 ? i : (O(i === -1, () => `Negative size values should be exactly -1 but got ${i} for the slice() size at index ${o}.`), e.shape[o] - s[o])), [s, a];
}
function TA(e, t, n, s, r, a, i, o, u) {
  let l;
  if (s == null ? (l = new Array(t.length), l.fill(1)) : l = s, i != null && (i & i - 1) !== 0)
    throw new Error("Multiple ellipses in slice is not allowed.");
  let c = false, p = { dims: l.length, numAddAxisAfterEllipsis: 0, begin: t.slice(), end: n.slice(), strides: l.slice(), beginMask: r, endMask: a, ellipsisMask: i, newAxisMask: o, shrinkAxisMask: u };
  for (let v = 0; v < p.dims; v++)
    c && (1 << v & o) !== 0 && p.numAddAxisAfterEllipsis++, 1 << v & i && (c = true);
  c || (p.ellipsisMask |= 1 << p.dims, p.dims++);
  let d = { dims: e.length, beginMask: 0, endMask: 0, beginValid: false, endValid: false };
  $A(p, d);
  let h = true, f = true, m = true, g = [], b = [];
  for (let v = 0; v < e.length; ++v) {
    if (d.strides[v] === 0)
      throw Error(`strides[${v}] must be non-zero`);
    let x = !!(d.shrinkAxisMask & 1 << v), k = e[v];
    if (k === -1) {
      g.push(x ? 1 : -1);
      continue;
    }
    let T = [d.beginMask & 1 << v, d.endMask & 1 << v], N = [d.strides[v] > 0 ? 0 : -1, d.strides[v] > 0 ? k : k - 1];
    if (x && d.strides[v] <= 0)
      throw Error("only stride 1 allowed on non-range indexing.");
    m = m && d.strides[v] === 1;
    let E = !!(d.beginMask & 1 << v && d.endMask & 1 << v);
    if (d.beginValid && d.endValid) {
      if (x) {
        let F = d.begin[v] < 0 ? k + d.begin[v] : d.begin[v];
        if (d.begin[v] = F, d.end[v] = d.begin[v] + 1, F < 0 || F >= k)
          throw Error(`slice index ${d.begin[v]} of dimension ${v} out of bounds.`);
      } else
        d.begin[v] = px(d.begin[v], 0, d.strides[v], k, T, N), d.end[v] = px(d.end[v], 1, d.strides[v], k, T, N);
      let R = d.strides[v] === 1 && d.begin[v] === 0 && d.end[v] === k;
      h = h && R, f = f && (v === 0 && d.strides[v] === 1 || R);
    } else
      h = h && d.strides[v] === 1 && E, f = f && (v === 0 && d.strides[v] === 1 || E);
    let A, P = false;
    if (d.beginValid && d.endValid ? (A = d.end[v] - d.begin[v], P = true) : x ? (A = 1, P = true) : E && k >= 0 && (d.strides[v] < 0 ? A = -k : A = k, P = true), P) {
      let R;
      A === 0 || A < 0 != d.strides[v] < 0 ? R = 0 : R = Math.trunc(A / d.strides[v]) + (A % d.strides[v] !== 0 ? 1 : 0), g.push(R);
    } else
      g.push(-1);
  }
  for (let v = 0; v < d.finalShapeGatherIndices.length; ++v) {
    let x = d.finalShapeGatherIndices[v];
    x >= 0 ? b.push(g[x]) : x === lm && b.push(1);
  }
  return { finalShapeSparse: b.filter((v, x) => d.finalShapeGatherIndices[x] !== lm), finalShape: b, isIdentity: h, sliceDim0: f, isSimpleSlice: m, begin: d.begin, end: d.end, strides: d.strides };
}
function $A(e, t) {
  t.beginMask = 0, t.endMask = 0, t.shrinkAxisMask = 0;
  let n = 0;
  t.beginValid = e.begin != null, t.endValid = e.end != null, t.begin = new Array(t.dims), t.end = new Array(t.dims), t.strides = new Array(t.dims), t.finalShapeGatherIndices = [], t.finalShapeGatherIndicesSparse = [], t.inputShapeGatherIndicesSparse = new Array(t.dims);
  for (let s = 0; s < e.dims; s++)
    if (1 << s & e.ellipsisMask) {
      let r = Math.min(t.dims - (e.dims - s) + 1 + e.numAddAxisAfterEllipsis, t.dims);
      for (; n < r; n++)
        t.begin[n] = 0, t.end[n] = 0, t.strides[n] = 1, t.beginMask |= 1 << n, t.endMask |= 1 << n, t.finalShapeGatherIndices.push(n), t.finalShapeGatherIndicesSparse.push(-1), t.inputShapeGatherIndicesSparse[n] = s;
    } else if (1 << s & e.newAxisMask)
      t.finalShapeGatherIndices.push(lm), t.finalShapeGatherIndicesSparse.push(-1);
    else {
      if (n === t.begin.length)
        throw Error(`Index out of range using input dim ${n}; input has only ${t.dims} dims, ${t.begin.length}.`);
      e.begin != null && (t.begin[n] = e.begin[s]), e.end != null && (t.end[n] = e.end[s]), t.strides[n] = e.strides[s], e.beginMask & 1 << s && (t.beginMask |= 1 << n), e.endMask & 1 << s && (t.endMask |= 1 << n), e.shrinkAxisMask & 1 << s ? (t.finalShapeGatherIndices.push(xA), t.finalShapeGatherIndicesSparse.push(-1), t.shrinkAxisMask |= 1 << n) : (t.finalShapeGatherIndices.push(n), t.finalShapeGatherIndicesSparse.push(s)), t.inputShapeGatherIndicesSparse[n] = s, n++;
    }
}
function px(e, t, n, s, r, a) {
  if (r[t])
    return n > 0 ? a[t] : a[t + 1 & 1];
  {
    let i = e < 0 ? s + e : e;
    return i < a[0] ? a[0] : i > a[1] ? a[1] : i;
  }
}
var ae = {};
Ae(ae, { Serializable: () => Vk, SerializationMap: () => jr, registerClass: () => Tr });
var Vk = class {
  getClassName() {
    return this.constructor.className;
  }
  static fromConfig(e, t) {
    return new e(t);
  }
};
var jr = class {
  constructor() {
    this.classNameMap = {};
  }
  static getMap() {
    return jr.instance == null && (jr.instance = new jr()), jr.instance;
  }
  static register(e) {
    jr.getMap().classNameMap[e.className] = [e, e.fromConfig];
  }
};
function Tr(e) {
  O(e.className != null, () => "Class being registered does not have the static className property defined."), O(typeof e.className == "string", () => "className is required to be a string, but got type " + typeof e.className), O(e.className.length > 0, () => "Class being registered has an empty-string as its className, which is disallowed."), jr.register(e);
}
var _A = {};
Ae(_A, { TEST_EPSILON_FLOAT16: () => Wk, encodeStrings: () => Uk, expectArrayBuffersEqual: () => PA, expectArraysClose: () => EA, expectArraysEqual: () => DA, expectNumbersClose: () => FA, expectPromiseToFail: () => RA, expectValuesInRange: () => OA, testEpsilon: () => Vg });
var AA = 1e-3;
var Wk = 0.1;
function EA(e, t, n) {
  return n == null && (n = Vg()), cm(e, t, (s, r) => Wg(s, r, n));
}
function Vg() {
  return M.backend.floatPrecision() === 32 ? AA : Wk;
}
function cm(e, t, n) {
  let s = true;
  if ((Qt(e) || Qt(t)) && (s = false), Qt(e) && Qt(t) && (s = true), s) {
    let i = e.constructor.name, o = t.constructor.name;
    if (i !== o)
      throw new Error(`Arrays are of different type. Actual: ${i}. Expected: ${o}`);
  }
  if (Array.isArray(e) && Array.isArray(t)) {
    let i = Rs(e), o = Rs(t);
    if (!kr(i, o))
      throw new Error(`Arrays have different shapes. Actual: [${i}]. Expected: [${o}]`);
  }
  let r = Qt(e) ? e : sa(e), a = Qt(t) ? t : sa(t);
  if (r.length !== a.length)
    throw new Error(`Arrays have different lengths actual: ${r.length} vs expected: ${a.length}.
Actual:   ${r}.
Expected: ${a}.`);
  for (let i = 0; i < a.length; ++i) {
    let o = r[i], u = a[i];
    if (!n(o, u))
      throw new Error(`Arrays differ: actual[${i}] = ${o}, expected[${i}] = ${u}.
Actual:   ${r}.
Expected: ${a}.`);
  }
}
function RA(e, t) {
  e().then(() => t.fail(), () => t());
}
function DA(e, t) {
  let n = typeof t == "string" || typeof t == "number" || typeof t == "boolean" ? [t] : t;
  return ir(e) || ir(e[0]) || ir(t) || ir(t[0]) ? cm(e, n, (s, r) => s == r) : cm(e, t, (s, r) => Wg(s, r, 0));
}
function FA(e, t, n) {
  if (n == null && (n = Vg()), !Wg(e, t, n))
    throw new Error(`Numbers differ: actual === ${e}, expected === ${t}`);
}
function Wg(e, t, n) {
  return !isFinite(e) && !isFinite(t) ? true : !(isNaN(e) || isNaN(t) || Math.abs(e - t) > n);
}
function OA(e, t, n) {
  for (let s = 0; s < e.length; s++)
    if (e[s] < t || e[s] > n)
      throw new Error(`Value out of range:${e[s]} low: ${t}, high: ${n}`);
}
function PA(e, t) {
  let n = new Float32Array(e), s = new Float32Array(t);
  if (n.length !== s.length)
    throw new Error(`Expected ArrayBuffer to be of length ${s.length}, but it was ${n.length}`);
  for (let r = 0; r < s.length; r++)
    if (n[r] !== s[r])
      throw new Error(`Expected ArrayBuffer value at ${r} to be ${s[r]} but got ${n[r]} instead`);
}
function Uk(e) {
  for (let t = 0; t < e.length; t++) {
    let n = e[t];
    Array.isArray(n) ? Uk(n) : e[t] = Dl(n);
  }
  return e;
}
var Rde = "0.0.0";
function Dde() {
  X().set("PROD", true);
}
function Fde() {
  X().set("DEBUG", true);
}
function Ode() {
  X().set("DEPRECATION_WARNINGS_ENABLED", false), console.warn("TensorFlow.js deprecation warnings have been disabled.");
}
function Gk(e) {
  X().getBool("DEPRECATION_WARNINGS_ENABLED") && console.warn(e + " You can disable deprecation warnings with tf.disableDeprecationWarnings().");
}
Z$(Gk);
function Pde() {
  M.disposeVariables();
}
function Ss() {
  return M;
}
function dm() {
  return M.memory();
}
function zde(e) {
  return M.profile(e);
}
function j(e, t) {
  return M.tidy(e, t);
}
function Re(e) {
  Rg(e).forEach((n) => n.dispose());
}
function Ht(e) {
  return M.keep(e);
}
function Mde(e) {
  return M.time(e);
}
function Lde(e) {
  return M.setBackend(e);
}
function Bde() {
  return M.ready();
}
function Vde() {
  return M.backendName;
}
function Wde(e) {
  M.removeBackend(e);
}
function Ude(e) {
  return M.findBackend(e);
}
function Gde(e) {
  return M.findBackendFactory(e);
}
function pp(e, t, n = 1) {
  return M.registerBackend(e, t, n);
}
function zA() {
  return M.backend;
}
function Hde(e, t) {
  X().setPlatform(e, t);
}
function MA(e, t) {
  let n = _(e, "a", "add"), s = _(t, "b", "add");
  [n, s] = vt(n, s);
  let r = { a: n, b: s };
  return M.runKernel(Ir, r);
}
var ie = L({ add_: MA });
function LA(e, t) {
  let n = _(e, "a", "floorDiv"), s = _(t, "b", "floorDiv");
  [n, s] = vt(n, s);
  let r = { a: n, b: s };
  return M.runKernel(za, r);
}
var Hk = L({ floorDiv_: LA });
function BA(e, t) {
  let n = _(e, "a", "div"), s = _(t, "b", "div");
  if ([n, s] = vt(n, s), n.dtype === "int32" && s.dtype === "int32")
    return Hk(n, s);
  let r = { a: n, b: s }, a = {};
  return M.runKernel(Da, r, a);
}
var xe = L({ div_: BA });
function VA(e, t) {
  let n = _(e, "a", "mul"), s = _(t, "b", "mul");
  [n, s] = vt(n, s);
  let r = { a: n, b: s };
  return M.runKernel(Ya, r);
}
var V = L({ mul_: VA });
function WA(e) {
  let t = _(e, "x", "abs");
  if (t.dtype === "complex64") {
    let n = { x: t };
    return M.runKernel(Kd, n);
  } else {
    let n = { x: t };
    return M.runKernel(io, n);
  }
}
var Mt = L({ abs_: WA });
function UA(e) {
  let n = { x: _(e, "x", "acos") };
  return M.runKernel(sl, n);
}
var GA = L({ acos_: UA });
function HA(e) {
  let n = { x: _(e, "x", "acosh") };
  return M.runKernel(rl, n);
}
var qA = L({ acosh_: HA });
function jA(e) {
  O(Array.isArray(e), () => "The argument passed to tf.addN() must be a list of tensors"), O(e.length >= 1, () => `Must pass at least one tensor to tf.addN(), but got ${e.length}`);
  let t = e.map((r, a) => _(r, `tensors${a}`, "addN")), n = t[0];
  t.forEach((r) => {
    if (r.dtype !== n.dtype)
      throw new Error("All tensors passed to tf.addN() must have the same dtype");
  }), t.forEach((r) => {
    if (!kr(r.shape, n.shape))
      throw new Error("All tensors passed to tf.addN() must have the same shape");
  });
  let s = t;
  return M.runKernel(ka, s);
}
var KA = L({ addN_: jA });
function XA(e, t = null, n = false) {
  let r = { x: _(e, "x", "all", "bool") }, a = { axis: t, keepDims: n };
  return M.runKernel(al, r, a);
}
var qk = L({ all_: XA });
function YA(e, t = null, n = false) {
  let r = { x: _(e, "x", "any", "bool") }, a = { axis: t, keepDims: n };
  return M.runKernel(il, r, a);
}
var pm = L({ any_: YA });
function QA(e, t = 0) {
  let s = { x: _(e, "x", "argMax") }, r = { axis: t };
  return M.runKernel(Ia, s, r);
}
var Hu = L({ argMax_: QA });
function ZA(e, t = 0) {
  let s = { x: _(e, "x", "argMin") }, r = { axis: t };
  return M.runKernel(ol, s, r);
}
var JA = L({ argMin_: ZA });
function eE(e) {
  let n = { x: _(e, "x", "asin") };
  return M.runKernel(ul, n);
}
var tE = L({ asin_: eE });
function nE(e) {
  let n = { x: _(e, "x", "asinh") };
  return M.runKernel(ll, n);
}
var sE = L({ asinh_: nE });
function rE(e) {
  let n = { x: _(e, "x", "atan") };
  return M.runKernel(cl, n);
}
var aE = L({ atan_: rE });
function iE(e, t) {
  let n = _(e, "a", "atan2"), s = _(t, "b", "atan2");
  [n, s] = vt(n, s);
  let r = { a: n, b: s };
  return M.runKernel(pl, r);
}
var oE = L({ atan2_: iE });
function uE(e) {
  let n = { x: _(e, "x", "atanh") };
  return M.runKernel(dl, n);
}
var lE = L({ atanh_: uE });
function cE(e, t, n, s, r = "NHWC", a) {
  let i = e[3], o = [...t, i], u = Xk(r);
  return Ol(e, o, n, a, s, null, null, u);
}
function jk(e, t, n, s, r, a, i = "channelsLast") {
  let [o, u] = xd(t), l;
  if (i === "channelsLast")
    l = [o, u, e[3], e[3]];
  else if (i === "channelsFirst")
    l = [o, u, e[1], e[1]];
  else
    throw new Error(`Unknown dataFormat ${i}`);
  return Ol(e, l, n, s, r, a, false, i);
}
function dE(e, t, n, s, r, a, i = "NDHWC") {
  let [o, u, l] = hm(t), c, p;
  if (i === "NDHWC")
    p = "channelsLast", c = [o, u, l, e[4], e[4]];
  else if (i === "NCDHW")
    p = "channelsFirst", c = [o, u, l, e[1], e[1]];
  else
    throw new Error(`Unknown dataFormat ${i}`);
  return Kk(e, c, n, s, r, false, p, a);
}
function Ol(e, t, n, s, r, a, i = false, o = "channelsLast") {
  let [u, l, c, p] = [-1, -1, -1, -1];
  if (o === "channelsLast")
    [u, l, c, p] = e;
  else if (o === "channelsFirst")
    [u, p, l, c] = e;
  else
    throw new Error(`Unknown dataFormat ${o}`);
  let [d, h, , f] = t, [m, g] = xd(n), [b, y] = xd(s), v = ji(d, b), x = ji(h, y), { padInfo: k, outHeight: T, outWidth: N } = fE(r, l, c, m, g, v, x, a, o), E = i ? f * p : f, A;
  return o === "channelsFirst" ? A = [u, E, T, N] : o === "channelsLast" && (A = [u, T, N, E]), { batchSize: u, dataFormat: o, inHeight: l, inWidth: c, inChannels: p, outHeight: T, outWidth: N, outChannels: E, padInfo: k, strideHeight: m, strideWidth: g, filterHeight: d, filterWidth: h, effectiveFilterHeight: v, effectiveFilterWidth: x, dilationHeight: b, dilationWidth: y, inShape: e, outShape: A, filterShape: t };
}
function Kk(e, t, n, s, r, a = false, i = "channelsLast", o) {
  let [u, l, c, p, d] = [-1, -1, -1, -1, -1];
  if (i === "channelsLast")
    [u, l, c, p, d] = e;
  else if (i === "channelsFirst")
    [u, d, l, c, p] = e;
  else
    throw new Error(`Unknown dataFormat ${i}`);
  let [h, f, m, , g] = t, [b, y, v] = hm(n), [x, k, T] = hm(s), N = ji(h, x), E = ji(f, k), A = ji(m, T), { padInfo: P, outDepth: R, outHeight: F, outWidth: $ } = mE(r, l, c, p, b, y, v, N, E, A, o), z = a ? g * d : g, W;
  return i === "channelsFirst" ? W = [u, z, R, F, $] : i === "channelsLast" && (W = [u, R, F, $, z]), { batchSize: u, dataFormat: i, inDepth: l, inHeight: c, inWidth: p, inChannels: d, outDepth: R, outHeight: F, outWidth: $, outChannels: z, padInfo: P, strideDepth: b, strideHeight: y, strideWidth: v, filterDepth: h, filterHeight: f, filterWidth: m, effectiveFilterDepth: N, effectiveFilterHeight: E, effectiveFilterWidth: A, dilationDepth: x, dilationHeight: k, dilationWidth: T, inShape: e, outShape: W, filterShape: t };
}
function pE(e, t, n, s, r) {
  s == null && (s = Ug(e, t, n));
  let a = e[0], i = e[1], o = Jr((a - t + 2 * s) / n + 1, r), u = Jr((i - t + 2 * s) / n + 1, r);
  return [o, u];
}
function hE(e, t, n, s, r, a) {
  r == null && (r = Ug(e, t, s));
  let i = e[0], o = e[1], u = e[2], l = Jr((i - t + 2 * r) / s + 1, a), c = Jr((o - t + 2 * r) / s + 1, a), p = Jr((u - t + 2 * r) / s + 1, a);
  return [l, c, p, n];
}
function Ug(e, t, n, s = 1) {
  let r = ji(t, s);
  return Math.floor((e[0] * (n - 1) - n + r) / 2);
}
function xd(e) {
  return typeof e == "number" ? [e, e, e] : e.length === 2 ? [e[0], e[1], 1] : e;
}
function hm(e) {
  return typeof e == "number" ? [e, e, e] : e;
}
function ji(e, t) {
  return t <= 1 ? e : e + (e - 1) * (t - 1);
}
function fE(e, t, n, s, r, a, i, o, u) {
  let l, c, p;
  if (typeof e == "number") {
    l = { top: e, bottom: e, left: e, right: e, type: e === 0 ? "VALID" : "NUMBER" };
    let h = pE([t, n], a, s, e, o);
    c = h[0], p = h[1];
  } else if (e === "same") {
    c = Math.ceil(t / s), p = Math.ceil(n / r);
    let d = Math.max(0, (c - 1) * s + a - t), h = Math.max(0, (p - 1) * r + i - n), f = Math.floor(d / 2), m = d - f, g = Math.floor(h / 2), b = h - g;
    l = { top: f, bottom: m, left: g, right: b, type: "SAME" };
  } else if (e === "valid")
    l = { top: 0, bottom: 0, left: 0, right: 0, type: "VALID" }, c = Math.ceil((t - a + 1) / s), p = Math.ceil((n - i + 1) / r);
  else if (typeof e == "object") {
    let d = u === "channelsLast" ? e[1][0] : e[2][0], h = u === "channelsLast" ? e[1][1] : e[2][1], f = u === "channelsLast" ? e[2][0] : e[3][0], m = u === "channelsLast" ? e[2][1] : e[3][1];
    l = { top: d, bottom: h, left: f, right: m, type: d === 0 && h === 0 && f === 0 && m === 0 ? "VALID" : "EXPLICIT" }, c = Jr((t - a + d + h) / s + 1, o), p = Jr((n - i + f + m) / r + 1, o);
  } else
    throw Error(`Unknown padding parameter: ${e}`);
  return { padInfo: l, outHeight: c, outWidth: p };
}
function mE(e, t, n, s, r, a, i, o, u, l, c) {
  let p, d, h, f;
  if (typeof e == "number") {
    p = { top: e, bottom: e, left: e, right: e, front: e, back: e, type: e === 0 ? "VALID" : "NUMBER" };
    let g = hE([t, n, s, 1], o, 1, r, e, c);
    d = g[0], h = g[1], f = g[2];
  } else if (e === "same") {
    d = Math.ceil(t / r), h = Math.ceil(n / a), f = Math.ceil(s / i);
    let m = (d - 1) * r + o - t, g = (h - 1) * a + u - n, b = (f - 1) * i + l - s, y = Math.floor(m / 2), v = m - y, x = Math.floor(g / 2), k = g - x, T = Math.floor(b / 2), N = b - T;
    p = { top: x, bottom: k, left: T, right: N, front: y, back: v, type: "SAME" };
  } else if (e === "valid")
    p = { top: 0, bottom: 0, left: 0, right: 0, front: 0, back: 0, type: "VALID" }, d = Math.ceil((t - o + 1) / r), h = Math.ceil((n - u + 1) / a), f = Math.ceil((s - l + 1) / i);
  else
    throw Error(`Unknown padding parameter: ${e}`);
  return { padInfo: p, outDepth: d, outHeight: h, outWidth: f };
}
function Jr(e, t) {
  if (!t)
    return Math.trunc(e);
  switch (t) {
    case "round":
      return Math.round(e);
    case "ceil":
      return Math.ceil(e);
    case "floor":
      return Math.floor(e);
    default:
      throw new Error(`Unknown roundingMode ${t}`);
  }
}
function fr(e) {
  let [t, n, s] = xd(e);
  return t === 1 && n === 1 && s === 1;
}
function Ps(e, t) {
  return fr(e) || fr(t);
}
function Xk(e) {
  if (e === "NHWC")
    return "channelsLast";
  if (e === "NCHW")
    return "channelsFirst";
  throw new Error(`Unknown dataFormat ${e}`);
}
function hn(e, t, n) {
  if (n != null) {
    if (typeof t == "string")
      throw Error(`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`);
    if (typeof t == "number")
      O(Yi(t), () => `Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`);
    else if (typeof t == "object")
      t.forEach((s) => {
        s.forEach((r) => {
          O(Yi(r), () => `Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${r}.`);
        });
      });
    else
      throw Error(`Error in ${e}: Unknown padding parameter: ${t}`);
  }
}
function gE(e, t) {
  let s = { x: _(e, "x", "reshape", "string_or_numeric") }, r = { shape: t };
  return M.runKernel(Eo, s, r);
}
var G = L({ reshape_: gE });
function bE(e, t, n, s, r) {
  let a = _(e, "x", "avgPool", "float32"), i = 1;
  O(Ps(n, i), () => `Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`);
  let o = a, u = false;
  a.rank === 3 && (u = true, o = G(a, [1, a.shape[0], a.shape[1], a.shape[2]])), O(o.rank === 4, () => `Error in avgPool: x must be rank 4 but got rank ${o.rank}.`), hn("avgPool", s, r);
  let l = { x: o }, c = { filterSize: t, strides: n, pad: s, dimRoundingMode: r }, p = M.runKernel(Sa, l, c);
  return p = ce(p, a.dtype), u ? G(p, [p.shape[1], p.shape[2], p.shape[3]]) : p;
}
var Gg = L({ avgPool_: bE });
function yE(e, t, n, s, r, a = "NDHWC") {
  let i = _(e, "x", "avgPool3d", "float32"), o = i, u = false;
  i.rank === 4 && (u = true, o = G(i, [1, i.shape[0], i.shape[1], i.shape[2], i.shape[3]])), O(o.rank === 5, () => `Error in avgPool3d: x must be rank 5 but got rank ${o.rank}.`), O(a === "NDHWC", () => `Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of ${a}`), hn("avgPool3d", s, r);
  let l = { x: o }, c = { filterSize: t, strides: n, pad: s, dimRoundingMode: r, dataFormat: a }, p = M.runKernel(qd, l, c);
  return p = ce(p, o.dtype), u ? G(p, [p.shape[1], p.shape[2], p.shape[3], p.shape[4]]) : p;
}
var Yk = L({ avgPool3d_: yE });
function vE(e, t = 0) {
  O(e.length >= 1, () => "Pass at least one tensor to concat");
  let n = Gu(e, "tensors", "concat", "string_or_numeric");
  if (n[0].dtype === "complex64" && n.forEach((a) => {
    if (a.dtype !== "complex64")
      throw new Error(`Cannot concatenate complex64 tensors with a tensor
          with dtype ${a.dtype}. `);
  }), n.length === 1)
    return lr(n[0]);
  let s = n, r = { axis: t };
  return M.runKernel(uo, s, r);
}
var Ft = L({ concat_: vE });
function xE(e) {
  let n = { x: _(e, "x", "sigmoid", "float32") };
  return M.runKernel(ai, n);
}
var qs = L({ sigmoid_: xE });
function wE(e, t, n) {
  let s = _(e, "x", "slice", "string_or_numeric");
  if (s.rank === 0)
    throw new Error("Slicing scalar is not possible");
  let r = { x: s }, a = { begin: t, size: n };
  return M.runKernel(Po, r, a);
}
var He = L({ slice_: wE });
function kE(e) {
  let n = { x: _(e, "x", "tanh", "float32") };
  return M.runKernel(di, n);
}
var qu = L({ tanh_: kE });
function IE(e, t, n, s, r, a) {
  let i = _(e, "forgetBias", "basicLSTMCell"), o = _(t, "lstmKernel", "basicLSTMCell"), u = _(n, "lstmBias", "basicLSTMCell"), l = _(s, "data", "basicLSTMCell"), c = _(r, "c", "basicLSTMCell"), p = _(a, "h", "basicLSTMCell"), d = Ft([l, p], 1), h = We(d, o), f = ie(h, u), m = f.shape[0], g = f.shape[1] / 4, b = [m, g], y = He(f, [0, 0], b), v = He(f, [0, g], b), x = He(f, [0, g * 2], b), k = He(f, [0, g * 3], b), T = ie(V(qs(y), qu(v)), V(c, qs(ie(i, x)))), N = V(qu(T), qs(k));
  return [T, N];
}
var qde = L({ basicLSTMCell_: IE });
function SE(e, t, n) {
  let s = _(e, "x", "batchToSpaceND"), r = t.reduce((o, u) => o * u);
  O(s.rank >= 1 + t.length, () => `input rank is ${s.rank} but should be > than blockShape.length ${t.length}`), O(n.length === t.length, () => `crops.length is ${n.length} but should be equal to blockShape.length  ${t.length}`), O(s.shape[0] % r === 0, () => `input tensor batch is ${s.shape[0]} but is not divisible by the product of the elements of blockShape ${t.join(" * ")} === ${r}`);
  let a = { x: s }, i = { blockShape: t, crops: n };
  return M.runKernel(oo, a, i);
}
var Hg = L({ batchToSpaceND_: SE });
function CE(e) {
  let t;
  return e.rank === 0 || e.rank === 1 ? t = G(e, [1, 1, 1, e.size]) : e.rank === 2 ? t = G(e, [1, 1, e.shape[0], e.shape[1]]) : e.rank === 3 ? t = G(e, [1, e.shape[0], e.shape[1], e.shape[2]]) : t = e, t;
}
function NE(e, t, n, s, r, a) {
  a == null && (a = 1e-3);
  let i = _(e, "x", "batchNorm"), o = _(t, "mean", "batchNorm"), u = _(n, "variance", "batchNorm"), l;
  r != null && (l = _(r, "scale", "batchNorm"));
  let c;
  s != null && (c = _(s, "offset", "batchNorm")), O(o.rank === u.rank, () => "Batch normalization gradient requires mean and variance to have equal ranks."), O(c == null || o.rank === c.rank, () => "Batch normalization gradient requires mean and offset to have equal ranks."), O(l == null || o.rank === l.rank, () => "Batch normalization gradient requires mean and scale to have equal ranks.");
  let d = { x: CE(i), scale: l, offset: c, mean: o, variance: u }, h = { varianceEpsilon: a }, f = M.runKernel(Ma, d, h);
  return G(f, i.shape);
}
var ju = L({ batchNorm_: NE });
function TE(e, t, n, s, r, a) {
  let i = _(e, "x", "batchNorm"), o = _(t, "mean", "batchNorm"), u = _(n, "variance", "batchNorm"), l;
  r != null && (l = _(r, "scale", "batchNorm"));
  let c;
  return s != null && (c = _(s, "offset", "batchNorm")), O(i.rank === 2, () => `Error in batchNorm2D: x must be rank 2 but got rank ${i.rank}.`), O(o.rank === 2 || o.rank === 1, () => `Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${o.rank}.`), O(u.rank === 2 || u.rank === 1, () => `Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${u.rank}.`), l != null && O(l.rank === 2 || l.rank === 1, () => `Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${l.rank}.`), c != null && O(c.rank === 2 || c.rank === 1, () => `Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${c.rank}.`), ju(i, o, u, c, l, a);
}
var $E = L({ batchNorm2d_: TE });
function _E(e, t, n, s, r, a) {
  let i = _(e, "x", "batchNorm"), o = _(t, "mean", "batchNorm"), u = _(n, "variance", "batchNorm"), l;
  r != null && (l = _(r, "scale", "batchNorm"));
  let c;
  return s != null && (c = _(s, "offset", "batchNorm")), O(i.rank === 3, () => `Error in batchNorm3D: x must be rank 3 but got rank ${i.rank}.`), O(o.rank === 3 || o.rank === 1, () => `Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${o.rank}.`), O(u.rank === 3 || u.rank === 1, () => `Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${u.rank}.`), l != null && O(l.rank === 3 || l.rank === 1, () => `Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${l.rank}.`), c != null && O(c.rank === 3 || c.rank === 1, () => `Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${c.rank}.`), ju(i, o, u, c, l, a);
}
var AE = L({ batchNorm3d_: _E });
function EE(e, t, n, s, r, a) {
  let i = _(e, "x", "batchNorm"), o = _(t, "mean", "batchNorm"), u = _(n, "variance", "batchNorm"), l;
  r != null && (l = _(r, "scale", "batchNorm"));
  let c;
  return s != null && (c = _(s, "offset", "batchNorm")), O(i.rank === 4, () => `Error in batchNorm4D: x must be rank 4 but got rank ${i.rank}.`), O(o.rank === 4 || o.rank === 1, () => `Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${o.rank}.`), O(u.rank === 4 || u.rank === 1, () => `Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${u.rank}.`), l != null && O(l.rank === 4 || l.rank === 1, () => `Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${l.rank}.`), c != null && O(c.rank === 4 || c.rank === 1, () => `Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${c.rank}.`), ju(i, o, u, c, l, a);
}
var RE = L({ batchNorm4d_: EE });
function DE(e, t, n) {
  let s = _(e, "x", "bincount"), r = _(t, "weights", "bincount");
  O(s.dtype === "int32", () => `Error in bincount: input dtype must be int32, but got ${s.dtype}`), O(n >= 0, () => `size must be non-negative, but got ${n}.`), O(r.size === s.size || r.size === 0, () => `Error in bincount: weights must have the same size as input or0-length, but got input shape: ${s.shape}, weights shape: ${r.shape}.`);
  let a = { x: s, weights: r }, i = { size: n };
  return M.runKernel(ug, a, i);
}
var Qk = L({ bincount_: DE });
function FE(e, t) {
  let n = _(e, "s0", "broadcastArgs", "int32"), s = _(t, "s1", "broadcastArgs", "int32");
  if (n.rank !== 1)
    throw new Error(`broadcastArgs(): first input must be a vector (rank=1). Has rank ${n.rank}`);
  if (s.rank !== 1)
    throw new Error(`broadcastArgs(): second input must be a vector (rank=1). Has rank ${s.rank}`);
  let r = { s0: n, s1: s };
  return M.runKernel(lg, r);
}
var OE = L({ broadcastArgs_: FE });
function PE(e, t) {
  let n = _(e, "broadcastTo", "x"), s = n.shape;
  if (t.some((l) => !(l > 0) || l % 1 !== 0))
    throw new Error(`broadcastTo(): Invalid broadcast shape [${t}].`);
  if (t.length < n.rank)
    throw new Error(`broadcastTo(): shape.length=${t.length} < input.rank=${n.rank}.`);
  if (t.length > n.rank) {
    let l = n.shape.slice();
    for (; l.length < t.length; )
      l.unshift(1);
    n = G(n, l);
  }
  let r = n.shape, a = Array.from(t);
  for (let l = t.length - 1; l >= 0; l--)
    if (r[l] === t[l])
      a[l] = 1;
    else if (n.shape[l] !== 1)
      throw new Error(`broadcastTo(): [${s}] cannot be broadcast to [${t}].`);
  if (a.map((l, c) => l > 1 ? c : -1).filter((l) => l >= 0).length === 0)
    return lr(n);
  let o = { x: n }, u = { reps: a };
  return M.runKernel(Cr, o, u);
}
var nd = L({ broadcastTo_: PE });
function zE(e) {
  let n = { x: _(e, "x", "ceil", "float32") };
  return M.runKernel(Ta, n);
}
var ME = L({ ceil_: zE });
function LE(e, t, n) {
  let s = _(e, "x", "clipByValue");
  O(t <= n, () => `Error in clip: min (${t}) must be less than or equal to max (${n}).`);
  let r = { x: s }, a = { clipValueMin: t, clipValueMax: n };
  return M.runKernel(Sr, r, a);
}
var Vn = L({ clipByValue_: LE });
function BE(e) {
  return Ft(e, 0);
}
var VE = L({ concat1d_: BE });
function WE(e, t) {
  return Ft(e, t);
}
var UE = L({ concat2d_: WE });
function GE(e, t) {
  return Ft(e, t);
}
var HE = L({ concat3d_: GE });
function qE(e, t) {
  return Ft(e, t);
}
var jE = L({ concat4d_: qE });
function KE(e, t, n, s, r = "NHWC", a = [1, 1], i) {
  let o = _(e, "x", "conv2d", "float32"), u = _(t, "filter", "conv2d", "float32"), l = o, c = false;
  o.rank === 3 && (c = true, l = G(o, [1, o.shape[0], o.shape[1], o.shape[2]])), O(l.rank === 4, () => `Error in conv2d: input must be rank 4, but got rank ${l.rank}.`), O(u.rank === 4, () => `Error in conv2d: filter must be rank 4, but got rank ${u.rank}.`), hn("conv2d", s, i);
  let p = r === "NHWC" ? l.shape[3] : l.shape[1];
  O(p === u.shape[2], () => `Error in conv2d: depth of input (${p}) must match input depth for filter ${u.shape[2]}.`), O(Ps(n, a), () => `Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`);
  let d = { x: l, filter: u }, h = { strides: n, pad: s, dataFormat: r, dilations: a, dimRoundingMode: i }, f = M.runKernel($a, d, h);
  return c ? G(f, [f.shape[1], f.shape[2], f.shape[3]]) : f;
}
var ca = L({ conv2d_: KE });
function XE(e, t, n, s, r = "NWC", a = 1, i) {
  let o = _(e, "x", "conv1d"), u = _(t, "filter", "conv1d"), l = o, c = false;
  o.rank === 2 && (c = true, l = G(o, [1, o.shape[0], o.shape[1]])), O(l.rank === 3, () => `Error in conv1d: input must be rank 3, but got rank ${l.rank}.`), O(u.rank === 3, () => `Error in conv1d: filter must be rank 3, but got rank ${u.rank}.`), hn("conv1d", s, i), O(l.shape[2] === u.shape[1], () => `Error in conv1d: depth of input (${l.shape[2]}) must match input depth for filter ${u.shape[1]}.`), O(Ps(n, a), () => `Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${a}'`), O(r === "NWC", () => `Error in conv1d: got dataFormat of ${r} but only NWC is currently supported.`);
  let p = G(u, [1, u.shape[0], u.shape[1], u.shape[2]]), d = G(l, [l.shape[0], 1, l.shape[1], l.shape[2]]), g = ca(d, p, [1, n], s, "NHWC", [1, a], i);
  return c ? G(g, [g.shape[2], g.shape[3]]) : G(g, [g.shape[0], g.shape[2], g.shape[3]]);
}
var Zk = L({ conv1d_: XE });
function YE(e, t, n, s, r, a = "NHWC", i) {
  O(e.length === t.rank, () => `Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`);
  let o = e, u = t, l = false;
  t.rank === 3 && (l = true, u = G(t, [1, t.shape[0], t.shape[1], t.shape[2]]), o = [1, e[0], e[1], e[2]]), O(o.length === 4, () => `Error in conv2dDerInput: inShape must be length 4, but got length ${o.length}.`), O(u.rank === 4, () => `Error in conv2dDerInput: dy must be rank 4, but got rank ${u.rank}`), O(n.rank === 4, () => `Error in conv2dDerInput: filter must be rank 4, but got rank ${n.rank}`);
  let c = a === "NHWC" ? o[3] : o[1], p = a === "NHWC" ? u.shape[3] : u.shape[1];
  O(c === n.shape[2], () => `Error in conv2dDerInput: depth of input (${c}) must match input depth for filter ${n.shape[2]}.`), O(p === n.shape[3], () => `Error in conv2dDerInput: depth of output (${p}) must match output depth for filter ${n.shape[3]}.`), hn("conv2dDerInput", r, i);
  let d = { dy: u, filter: n }, h = { strides: s, pad: r, dataFormat: a, dimRoundingMode: i, inputShape: o }, f = M.runKernel(_a, d, h);
  return l ? G(f, [f.shape[1], f.shape[2], f.shape[3]]) : f;
}
var qg = L({ conv2DBackpropInput_: YE });
function QE(e, t, n, s, r, a) {
  let i = _(e, "x", "conv2dTranspose"), o = _(t, "filter", "conv2dTranspose");
  return qg(n, i, o, s, r, "NHWC", a);
}
var Jk = L({ conv2dTranspose_: QE });
function ZE(e, t, n, s, r = "NDHWC", a = [1, 1, 1]) {
  let i = _(e, "x", "conv3d"), o = _(t, "filter", "conv3d"), u = i, l = false;
  i.rank === 4 && (l = true, u = G(i, [1, i.shape[0], i.shape[1], i.shape[2], i.shape[3]])), O(u.rank === 5, () => `Error in conv3d: input must be rank 5, but got rank ${u.rank}.`), O(o.rank === 5, () => `Error in conv3d: filter must be rank 5, but got rank ${o.rank}.`), O(u.shape[4] === o.shape[3], () => `Error in conv3d: depth of input (${u.shape[4]}) must match input depth for filter ${o.shape[3]}.`), O(Ps(n, a), () => `Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`), O(r === "NDHWC", () => `Error in conv3d: got dataFormat of ${r} but only NDHWC is currently supported.`);
  let c = { x: u, filter: o }, p = { strides: n, pad: s, dataFormat: r, dilations: a }, d = M.runKernel(Xd, c, p);
  return l ? G(d, [d.shape[1], d.shape[2], d.shape[3], d.shape[4]]) : d;
}
var eI = L({ conv3d_: ZE });
function JE(e, t, n, s, r) {
  O(e.length === t.rank, () => `Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`);
  let a = e, i = t, o = false;
  t.rank === 4 && (o = true, i = G(t, [1, t.shape[0], t.shape[1], t.shape[2], t.shape[3]]), a = [1, e[0], e[1], e[2], e[3]]);
  let u = a[4], l = i.shape[4];
  O(a.length === 5, () => `Error in conv3dDerInput: inShape must be length 5, but got length ${a.length}.`), O(i.rank === 5, () => `Error in conv3dDerInput: dy must be rank 5, but got rank ${i.rank}`), O(n.rank === 5, () => `Error in conv3dDerInput: filter must be rank 5, but got rank ${n.rank}`), O(u === n.shape[3], () => `Error in conv3dDerInput: depth of input (${u}) must match input depth for filter ${n.shape[3]}.`), O(l === n.shape[4], () => `Error in conv3dDerInput: depth of output (${l}) must match output depth for filter ${n.shape[4]}.`);
  let c = { dy: i, filter: n }, p = { pad: r, strides: s, inputShape: a }, d = M.runKernel(pg, c, p);
  return o ? G(d, [d.shape[1], d.shape[2], d.shape[3], d.shape[4]]) : d;
}
var tI = L({ conv3DBackpropInput_: JE });
function eR(e, t, n, s, r) {
  let a = _(e, "x", "conv3dTranspose"), i = _(t, "filter", "conv3dTranspose");
  return tI(n, a, i, s, r);
}
var tR = L({ conv3dTranspose_: eR });
function nR(e) {
  let n = { x: _(e, "x", "cos", "float32") };
  return M.runKernel(Aa, n);
}
var jg = L({ cos_: nR });
function sR(e) {
  let n = { x: _(e, "x", "cosh", "float32") };
  return M.runKernel(Ea, n);
}
var nI = L({ cosh_: sR });
function rR(e, t = 0, n = false, s = false) {
  let a = { x: _(e, "x", "cumprod") }, i = { axis: t, exclusive: n, reverse: s };
  return M.runKernel(hl, a, i);
}
var aR = L({ cumprod_: rR });
function iR(e, t = 0, n = false, s = false) {
  let a = { x: _(e, "x", "cumsum") }, i = { axis: t, exclusive: n, reverse: s };
  return M.runKernel(lo, a, i);
}
var sI = L({ cumsum_: iR });
function oR(e, t, n, s = false) {
  let r = _(e, "x", "denseBincount"), a = _(t, "weights", "denseBincount");
  O(r.dtype === "int32", () => `Error in denseBincount: input dtype must be int32, but got ${r.dtype}`), O(r.rank <= 2, () => `Error in denseBincount: input must be at most rank 2, but got rank ${r.rank}.`), O(n >= 0, () => `size must be non-negative, but got ${n}.`), O(a.size === r.size || a.size === 0, () => `Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${r.shape}, weights shape: ${a.shape}.`);
  let i = { x: r, weights: a }, o = { size: n, binaryOutput: s };
  return M.runKernel(hg, i, o);
}
var uR = L({ denseBincount_: oR });
function lR(e, t, n = "NHWC") {
  let s = _(e, "x", "depthToSpace", "float32"), r = n === "NHWC" ? s.shape[1] : s.shape[2], a = n === "NHWC" ? s.shape[2] : s.shape[3], i = n === "NHWC" ? s.shape[3] : s.shape[1];
  O(t > 1, () => `blockSize should be > 1 for depthToSpace, but was: ${t}`), O(r * t >= 0, () => `Negative dimension size caused by overflow when multiplying
    ${r} and ${t}  for depthToSpace with input shape
    ${s.shape}`), O(a * t >= 0, () => `Negative dimension size caused by overflow when multiplying
    ${a} and ${t} for depthToSpace with input shape
        ${s.shape}`), O(i % (t * t) === 0, () => `Dimension size must be evenly divisible by ${t * t} but is ${i} for depthToSpace with input shape ${s.shape}`);
  let o = { x: s }, u = { blockSize: t, dataFormat: n };
  return M.runKernel(po, o, u);
}
var cR = L({ depthToSpace_: lR });
function dR(e, t, n, s, r = "NHWC", a = [1, 1], i) {
  let o = _(e, "x", "depthwiseConv2d", "float32"), u = _(t, "filter", "depthwiseConv2d", "float32"), l = o, c = false;
  o.rank === 3 && (c = true, l = G(o, [1, o.shape[0], o.shape[1], o.shape[2]])), O(l.rank === 4, () => `Error in depthwiseConv2d: input must be rank 4, but got rank ${l.rank}.`), O(u.rank === 4, () => `Error in depthwiseConv2d: filter must be rank 4, but got rank ${u.rank}.`), O(l.shape[3] === u.shape[2], () => `Error in depthwiseConv2d: number of input channels (${l.shape[3]}) must match the inChannels dimension in filter ${u.shape[2]}.`), hn("depthwiseConv2d", s, i);
  let p = { x: l, filter: u }, d = { strides: n, pad: s, dataFormat: r, dilations: a, dimRoundingMode: i }, h = M.runKernel(Ra, p, d);
  return c ? G(h, [h.shape[1], h.shape[2], h.shape[3]]) : h;
}
var hp = L({ depthwiseConv2d_: dR });
function pR(e) {
  let n = { x: _(e, "x", "diag") };
  return M.runKernel(gg, n);
}
var jde = L({ diag_: pR });
function hR(e, t, n, s, r = [1, 1], a = "NHWC") {
  let i = _(e, "x", "dilation2d"), o = _(t, "filter", "dilation2d");
  O(i.rank === 3 || i.rank === 4, () => `Error in dilation2d: input must be rank 3 or 4, but got rank ${i.rank}.`), O(o.rank === 3, () => `Error in dilation2d: filter must be rank 3, but got rank ${o.rank}.`), O(a === "NHWC", () => `Error in dilation2d: Only NHWC is currently supported, but got dataFormat of ${a}`);
  let u = i, l = false;
  i.rank === 3 && (u = G(i, [1, i.shape[0], i.shape[1], i.shape[2]]), l = true);
  let c = { x: u, filter: o }, p = { strides: n, pad: s, dilations: r }, d = M.runKernel(Yd, c, p);
  return l ? G(d, [d.shape[1], d.shape[2], d.shape[3]]) : d;
}
var fR = L({ dilation2d_: hR });
function mR(e, t) {
  let n = _(e, "a", "equal", "string_or_numeric"), s = _(t, "b", "equal", "string_or_numeric");
  [n, s] = vt(n, s), ot(n.shape, s.shape);
  let r = { a: n, b: s };
  return M.runKernel(ho, r);
}
var Kn = L({ equal_: mR });
function gR(e, t, n) {
  let s = _(t, "a", "where"), r = _(n, "b", "where"), a = _(e, "condition", "where", "bool"), i = ot(ot(a.shape, s.shape), r.shape), o = nd(a, i), u = nd(s, i), l = nd(r, i), c = { condition: o, t: u, e: l };
  return M.runKernel(Oo, c);
}
var vn = L({ where_: gR });
function bR(e) {
  let n = { x: _(e, "x", "zerosLike") };
  return M.runKernel(Ho, n);
}
var je = L({ zerosLike_: bR });
function yR(e, t) {
  let n = _(e, "a", "div"), s = _(t, "b", "div");
  [n, s] = vt(n, s);
  let r = xe(n, s), a = je(r), i = Kn(s, a);
  return vn(i, a, r);
}
var vR = L({ divNoNan_: yR });
function xR(e, t) {
  let n = _(e, "t1", "dot"), s = _(t, "t2", "dot");
  O((n.rank === 1 || n.rank === 2) && (s.rank === 1 || s.rank === 2), () => `Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${s.rank}.`);
  let r = n.rank === 1 ? n.size : n.shape[1], a = s.rank === 1 ? s.size : s.shape[0];
  if (O(r === a, () => `Error in dot: inner dimensions of inputs must match, but got ${r} and ${a}.`), n.rank === 1 && s.rank === 1) {
    let i = G(n, [1, -1]), o = G(s, [-1, 1]), u = We(i, o);
    return G(u, []);
  } else if (n.rank === 1 && s.rank === 2) {
    let i = G(n, [1, -1]), o = G(s, [s.shape[0], s.shape[1]]), u = We(i, o);
    return G(u, [u.size]);
  } else if (n.rank === 2 && s.rank === 1) {
    let i = G(s, [-1, 1]), o = We(n, i);
    return G(o, [o.size]);
  } else {
    let i = G(s, [s.shape[0], s.shape[1]]);
    return We(n, i);
  }
}
var Kde = L({ dot_: xR });
function wR(e, ...t) {
  let n = t.map((r, a) => _(r, `tensors${a}`, "einsum")), s = { equation: e };
  return M.runKernel(Qd, n, s);
}
var kR = L({ einsum_: wR });
function IR(e) {
  let n = { x: _(e, "x", "elu", "float32") };
  return M.runKernel(Fa, n);
}
var fp = L({ elu_: IR });
function SR(e) {
  let t = _(e, "x", "erf");
  O(t.dtype === "int32" || t.dtype === "float32", () => "Input dtype must be `int32` or `float32`."), t.dtype === "int32" && (t = ce(t, "float32"));
  let n = { x: t };
  return M.runKernel(fl, n);
}
var CR = L({ erf_: SR });
function NR(e) {
  let n = { x: _(e, "x", "exp") };
  return M.runKernel(Oa, n);
}
var Xn = L({ exp_: NR });
function TR(e, t = 0) {
  let n = _(e, "x", "expandDims", "string_or_numeric");
  O(t <= n.rank, () => "Axis must be <= rank of the tensor");
  let s = { input: n }, r = { dim: t };
  return M.runKernel(fo, s, r);
}
var Pn = L({ expandDims_: TR });
function $R(e) {
  let n = { x: _(e, "x", "expm1") };
  return M.runKernel(mo, n);
}
var _R = L({ expm1_: $R });
function AR(e, t) {
  let n = _(e, "x", "tile", "string_or_numeric");
  O(n.rank === t.length, () => `Error in transpose: rank of input ${n.rank} must match length of reps ${t}.`);
  let s = { x: n }, r = { reps: t };
  return M.runKernel(Cr, s, r);
}
var ps = L({ tile_: AR });
function ER(e, t, n, s = "float32") {
  t == null && (t = e);
  let r = De([e, t], s), a = e <= t ? e : t;
  for (let o = 0; o < a; ++o)
    r.set(1, o, o);
  let i = G(r.toTensor(), [e, t]);
  if (n == null)
    return i;
  if (n.length === 1)
    return ps(Pn(i, 0), [n[0], 1, 1]);
  if (n.length === 2)
    return ps(Pn(Pn(i, 0), 0), [n[0], n[1], 1, 1]);
  if (n.length === 3)
    return ps(Pn(Pn(Pn(i, 0), 0), 0), [n[0], n[1], n[2], 1, 1]);
  throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`);
}
var rI = L({ eye_: ER });
function Pl(e, t, n) {
  let s = { shape: e, value: t, dtype: n };
  return M.runKernel(ml, {}, s);
}
function RR(e) {
  let n = { x: _(e, "x", "floor", "float32") };
  return M.runKernel(Pa, n);
}
var mp = L({ floor_: RR });
function DR(e, t, n = 0, s = 0) {
  let r = _(e, "x", "gather"), a = _(t, "indices", "gather", "int32"), i = { x: r, indices: a }, o = { axis: n, batchDims: s };
  return M.runKernel(bo, i, o);
}
var Ku = L({ gather_: DR });
function FR(e, t) {
  let n = _(e, "a", "greater", "string_or_numeric"), s = _(t, "b", "greater", "string_or_numeric");
  [n, s] = vt(n, s), ot(n.shape, s.shape);
  let r = { a: n, b: s };
  return M.runKernel(vo, r);
}
var Wn = L({ greater_: FR });
function OR(e, t) {
  let n = _(e, "a", "greaterEqual", "string_or_numeric"), s = _(t, "b", "greaterEqual", "string_or_numeric");
  [n, s] = vt(n, s), ot(n.shape, s.shape);
  let r = { a: n, b: s };
  return M.runKernel(La, r);
}
var Ko = L({ greaterEqual_: OR });
function PR(e) {
  let n = { input: _(e, "input", "imag") };
  return M.runKernel(Zd, n);
}
var Kg = L({ imag_: PR });
function zR(e) {
  let n = { x: _(e, "x", "isFinite") };
  return M.runKernel(gl, n);
}
var Xde = L({ isFinite_: zR });
function MR(e) {
  let n = { x: _(e, "x", "isInf") };
  return M.runKernel(bl, n);
}
var Yde = L({ isInf_: MR });
function LR(e) {
  let n = { x: _(e, "x", "isNaN") };
  return M.runKernel(yl, n);
}
var BR = L({ isNaN_: LR });
function VR(e, t = 0.2) {
  let s = { x: _(e, "x", "leakyRelu") }, r = { alpha: t };
  return M.runKernel(Va, s, r);
}
var Xg = L({ leakyRelu_: VR });
function WR(e, t) {
  let n = _(e, "a", "less", "string_or_numeric"), s = _(t, "b", "less", "string_or_numeric");
  [n, s] = vt(n, s), ot(n.shape, s.shape);
  let r = { a: n, b: s };
  return M.runKernel(xo, r);
}
var aI = L({ less_: WR });
function UR(e, t) {
  let n = _(e, "a", "lessEqual", "string_or_numeric"), s = _(t, "b", "lessEqual", "string_or_numeric");
  [n, s] = vt(n, s), ot(n.shape, s.shape);
  let r = { a: n, b: s };
  return M.runKernel(wo, r);
}
var Xo = L({ lessEqual_: UR });
function GR(e, t, n) {
  if (n <= 0)
    throw new Error("The number of values should be positive.");
  let s = { start: e, stop: t, num: n };
  return M.runKernel(xg, {}, s);
}
function HR(e, t = 5, n = 1, s = 1, r = 0.5) {
  let a = _(e, "x", "localResponseNormalization");
  O(a.rank === 4 || a.rank === 3, () => `Error in localResponseNormalization: x must be rank 3 or 4 but got
               rank ${a.rank}.`), O(Yi(t), () => `Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${t}.`);
  let i = a, o = false;
  a.rank === 3 && (o = true, i = G(a, [1, a.shape[0], a.shape[1], a.shape[2]]));
  let u = { x: i }, l = { depthRadius: t, bias: n, alpha: s, beta: r }, c = M.runKernel(ep, u, l);
  return o ? G(c, [c.shape[1], c.shape[2], c.shape[3]]) : c;
}
var qR = L({ localResponseNormalization_: HR });
function jR(e) {
  let n = { x: _(e, "x", "log", "float32") };
  return M.runKernel(Wa, n);
}
var Yn = L({ log_: jR });
function KR(e) {
  let n = { x: _(e, "x", "log1p") };
  return M.runKernel(vl, n);
}
var Yg = L({ log1p_: KR });
function Qde(e) {
  return O(hr(e), () => "The f passed in grad(f) must be a function"), (t, n) => {
    let s = _(t, "x", "tf.grad", "string_or_numeric"), r = n != null ? _(n, "dy", "tf.grad") : null;
    return M.tidy(() => {
      let { value: a, grads: i } = M.gradients(() => e(s), [s], r);
      return r != null && pn(a.shape, r.shape, "The shape of dy passed in grad(f)(x, dy) must match the shape returned by f(x)"), gp(i), i[0];
    });
  };
}
function Zde(e) {
  return O(hr(e), () => "The f passed in grads(f) must be a function"), (t, n) => {
    O(Array.isArray(t), () => "The args passed in grads(f)(args) must be an array of `Tensor`s or `TensorLike`s");
    let s = Gu(t, "args", "tf.grads", "string_or_numeric"), r = n != null ? _(n, "dy", "tf.grads") : null;
    return M.tidy(() => {
      let { value: a, grads: i } = M.gradients(() => e(...s), s, r);
      return r != null && pn(a.shape, r.shape, "The shape of dy passed in grads(f)([x1,...], dy) must match the shape returned by f([x1,...])"), gp(i), i;
    });
  };
}
function Jde(e) {
  return O(hr(e), () => "The f passed in valueAndGrad(f) must be a function"), (t, n) => {
    O(t instanceof et, () => "The x passed in valueAndGrad(f)(x) must be a tensor"), O(n == null || n instanceof et, () => "The dy passed in valueAndGrad(f)(x, dy) must be a tensor");
    let { grads: s, value: r } = M.gradients(() => e(t), [t], n);
    return gp(s), { grad: s[0], value: r };
  };
}
function epe(e) {
  return O(hr(e), () => "The f passed in valueAndGrads(f) must be a function"), (t, n) => {
    O(Array.isArray(t) && t.every((r) => r instanceof et), () => "The args passed in valueAndGrads(f)(args) must be array of tensors"), O(n == null || n instanceof et, () => "The dy passed in valueAndGrads(f)(args, dy) must be a tensor");
    let s = M.gradients(() => e(...t), t, n);
    return n != null && pn(s.value.shape, n.shape, "The shape of dy passed in valueAndGrads(f)([x1,...], dy) must match the shape returned by f([x1,...])"), gp(s.grads), s;
  };
}
function XR(e, t) {
  O(hr(e), () => "The f passed in variableGrads(f) must be a function"), O(t == null || Array.isArray(t) && t.every((l) => l instanceof gd), () => "The varList passed in variableGrads(f, varList) must be an array of variables");
  let n = t != null;
  if (!n) {
    t = [];
    for (let l in M.registeredVariables)
      t.push(M.registeredVariables[l]);
  }
  let s = n ? t.filter((l) => !l.trainable) : null, r = t.length;
  t = t.filter((l) => l.trainable), O(t.length > 0, () => `variableGrads() expects at least one of the input variables to be trainable, but none of the ${r} variables is trainable.`);
  let a = true, { value: i, grads: o } = M.gradients(e, t, null, a);
  O(o.some((l) => l != null), () => "Cannot find a connection between any variable and the result of the loss function y=f(x). Please make sure the operations that use variables are inside the function f passed to minimize()."), O(i.rank === 0, () => `The f passed in variableGrads(f) must return a scalar, but it returned a rank-${i.rank} tensor`);
  let u = {};
  return t.forEach((l, c) => {
    o[c] != null && (u[l.name] = o[c]);
  }), s != null && s.forEach((l) => u[l.name] = null), { value: i, grads: u };
}
function js(e) {
  return M.customGrad(e);
}
function gp(e) {
  if (e.filter((n) => n == null).length > 0)
    throw new Error(`Cannot compute gradient of y=f(x) with respect to x. Make sure that
    the f you passed encloses all operations that lead from x to y.`);
}
function YR(e) {
  let n = { x: _(e, "x", "neg") };
  return M.runKernel(Io, n);
}
var kt = L({ neg_: YR });
function QR(e) {
  let n = { x: _(e, "x", "softplus") };
  return M.runKernel($l, n);
}
var zl = L({ softplus_: QR });
function ZR(e) {
  let t = _(e, "x", "logSigmoid");
  return js((s) => ({ value: kt(zl(kt(s))), gradFunc: (i) => V(i, qs(kt(s))) }))(t);
}
var tpe = L({ logSigmoid_: ZR });
function JR(e, t = null, n = false) {
  let r = { x: _(e, "x", "max") }, a = { reductionIndices: t, keepDims: n };
  return M.runKernel(Ua, r, a);
}
var As = L({ max_: JR });
function eD(e, t) {
  let n = _(e, "a", "sub"), s = _(t, "b", "sub");
  [n, s] = vt(n, s);
  let r = { a: n, b: s };
  return M.runKernel(ci, r);
}
var ge = L({ sub_: eD });
function tD(e, t = null, n = false) {
  let s = _(e, "x", "sum");
  s.dtype === "bool" && (s = ce(s, "int32"));
  let r = { x: s }, a = { axis: t, keepDims: n };
  return M.runKernel(oi, r, a);
}
var ve = L({ sum_: tD });
function nD(e, t = -1) {
  let n = _(e, "logits", "logSoftmax");
  if (t === -1 && (t = n.rank - 1), t !== n.rank - 1)
    throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${t}`);
  return js((r, a) => {
    let o = As(r, t, true), u = ge(r, o), l = ge(ce(u, "float32"), Yn(ve(Xn(u), t, true)));
    return a([l]), { value: l, gradFunc: (p, d) => {
      let [h] = d, f = true, m = Xn(h);
      return ge(p, V(ve(p, t, f), m));
    } };
  })(n);
}
var iI = L({ logSoftmax_: nD });
function Qg(e, t) {
  for (let n = 0; n < e.length; ++n)
    if (e[e.length - n - 1] !== t - 1 - n)
      return false;
  return true;
}
function oI(e, t, n) {
  let s = e.length + t.length, r = [], a = 0, i = 0;
  for (let o = 0; o < s; o++)
    n.indexOf(o) === -1 ? r.push(e[a++]) : r.push(t[i++]);
  return r;
}
function uI(e, t) {
  let n = [], s = e.length;
  for (let a = 0; a < s; a++)
    t.indexOf(a) === -1 && n.push(e[a]);
  let r = t.map((a) => e[a]);
  return [n, r];
}
function da(e, t) {
  let n = t.map((s) => 1);
  return oI(e, n, t);
}
function sD(e, t, n) {
  O(Qg(t, n), () => `${e} supports only inner-most axes for now. Got axes ${t} and rank-${n} input.`);
}
function lI(e, t) {
  if (Qg(e, t))
    return null;
  let n = [];
  for (let s = 0; s < t; ++s)
    e.indexOf(s) === -1 && n.push(s);
  return e.forEach((s) => n.push(s)), n;
}
function Zg(e) {
  return e.map((t, n) => [n, t]).sort((t, n) => t[1] - n[1]).map((t) => t[0]);
}
function rD(e, t) {
  let n = [];
  for (let s = t - e; s < t; ++s)
    n.push(s);
  return n;
}
function aD(e, t = null, n = false) {
  let s = _(e, "x", "logSumExp"), r = ts(t, s.shape), a = As(s, r, true), i = ge(s, a), o = Xn(i), u = ve(o, r), l = Yn(u), c = ie(G(a, l.shape), l);
  if (n) {
    let p = da(c.shape, r);
    return G(c, p);
  }
  return c;
}
var iD = L({ logSumExp_: aD });
function oD(e, t) {
  let n = _(e, "a", "logicalAnd", "bool"), s = _(t, "b", "logicalAnd", "bool");
  ot(n.shape, s.shape);
  let r = { a: n, b: s };
  return M.runKernel(ko, r);
}
var Ds = L({ logicalAnd_: oD });
function uD(e) {
  let n = { x: _(e, "x", "logicalNot", "bool") };
  return M.runKernel(xl, n);
}
var Jg = L({ logicalNot_: uD });
function lD(e, t) {
  let n = _(e, "a", "logicalOr", "bool"), s = _(t, "b", "logicalOr", "bool");
  ot(n.shape, s.shape);
  let r = { a: n, b: s };
  return M.runKernel(Jd, r);
}
var cI = L({ logicalOr_: lD });
function cD(e, t) {
  let n = _(e, "a", "logicalXor", "bool"), s = _(t, "b", "logicalXor", "bool");
  return ot(n.shape, s.shape), Ds(cI(e, t), Jg(Ds(e, t)));
}
var npe = L({ logicalXor_: cD });
function dD(e, t, n, s, r) {
  let a = _(e, "x", "maxPool"), i = 1, o = a, u = false;
  a.rank === 3 && (u = true, o = G(a, [1, a.shape[0], a.shape[1], a.shape[2]])), O(o.rank === 4, () => `Error in maxPool: input must be rank 4 but got rank ${o.rank}.`), O(Ps(n, i), () => `Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`), hn("maxPool", s, r);
  let l = { x: o }, c = { filterSize: t, strides: n, pad: s, dimRoundingMode: r }, p = M.runKernel(Ha, l, c);
  return u ? G(p, [p.shape[1], p.shape[2], p.shape[3]]) : p;
}
var eb = L({ maxPool_: dD });
function pD(e, t = [1, 1, 1], n, s, r, a = "NDHWC") {
  let i = _(e, "x", "maxPool3d"), o = i, u = false;
  i.rank === 4 && (u = true, o = G(i, [1, i.shape[0], i.shape[1], i.shape[2], i.shape[3]])), O(o.rank === 5, () => `Error in maxPool3d: x must be rank 5 but got rank ${o.rank}.`), O(a === "NDHWC", () => `Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of ${a}`), hn("maxPool3d", s, r);
  let l = { x: o }, c = { filterSize: t, strides: n, pad: s, dimRoundingMode: r, dataFormat: a }, p = M.runKernel(tp, l, c);
  return u ? G(p, [p.shape[1], p.shape[2], p.shape[3], p.shape[4]]) : p;
}
var dI = L({ maxPool3d_: pD });
function hD(e, t, n, s, r = false) {
  let i = { x: _(e, "x", "maxPoolWithArgmax") }, o = { filterSize: t, strides: n, pad: s, includeBatchInIndex: r }, u = M.runKernel(Sg, i, o);
  return { result: u[0], indexes: u[1] };
}
var fD = L({ maxPoolWithArgmax_: hD });
function mD(e, t) {
  let n = _(e, "a", "maximum"), s = _(t, "b", "maximum");
  [n, s] = vt(n, s), n.dtype === "bool" && (n = ce(n, "int32"), s = ce(s, "int32")), ot(n.shape, s.shape);
  let r = { a: n, b: s };
  return M.runKernel(Ga, r);
}
var $r = L({ maximum_: mD });
function gD(e, t = null, n = false) {
  let r = { x: _(e, "x", "mean") }, a = { axis: t, keepDims: n };
  return M.runKernel(qa, r, a);
}
var St = L({ mean_: gD });
function $t(e, t = "float32") {
  if (t === "complex64") {
    let s = $t(e, "float32"), r = $t(e, "float32");
    return oa(s, r);
  }
  let n = Hd(pt(e), t);
  return M.makeTensor(n, e, t);
}
function Mn(e, t = "float32") {
  if (t === "complex64") {
    let s = Mn(e, "float32"), r = $t(e, "float32");
    return oa(s, r);
  }
  let n = ng(pt(e), t);
  return M.makeTensor(n, e, t);
}
function spe(e, t, { indexing: n = "xy" } = {}) {
  if (n !== "xy" && n !== "ij")
    throw new TypeError(`${n} is not a valid third argument to meshgrid`);
  if (e === void 0)
    return [];
  let s = _(e, "x", "meshgrid", e instanceof et ? e.dtype : "float32");
  if (t === void 0)
    return [s];
  let r = _(t, "y", "meshgrid", t instanceof et ? t.dtype : "float32"), a = pt(s.shape), i = pt(r.shape);
  return n === "xy" ? (s = G(s, [1, -1]), r = G(r, [-1, 1]), [We(Mn([i, 1], s.dtype), s), We(r, Mn([1, a], r.dtype))]) : (s = G(s, [-1, 1]), r = G(r, [1, -1]), [We(s, Mn([1, i], s.dtype)), We(Mn([a, 1], r.dtype), r)]);
}
function bD(e, t = null, n = false) {
  let r = { x: _(e, "x", "min") }, a = { axis: t, keepDims: n };
  return M.runKernel(ja, r, a);
}
var fm = L({ min_: bD });
function yD(e, t) {
  let n = _(e, "a", "minimum"), s = _(t, "b", "minimum");
  [n, s] = vt(n, s), n.dtype === "bool" && (n = ce(n, "int32"), s = ce(s, "int32")), ot(n.shape, s.shape);
  let r = { a: n, b: s };
  return M.runKernel(Ka, r);
}
var bp = L({ minimum_: yD });
function vD(e, t, n) {
  O(n === "reflect" || n === "symmetric", () => `Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`);
  let s = _(e, "x", "mirrorPad");
  if (s.rank === 0)
    throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");
  O(t.length === s.rank, () => `Padding doesn't match input. Must be ${s.rank}. Got ${t.length}.`);
  let r = n === "reflect" ? 1 : 0;
  for (let o = 0; o < s.rank; o++)
    O(t[o].length === 2, () => "Invalid number of paddings. Must be length of 2 each."), O(t[o][0] >= 0 && t[o][0] <= s.shape[o] - r && t[o][1] >= 0 && t[o][1] <= s.shape[o] - r, () => `Padding in dimension ${o} cannot be greater than or equal to ${s.shape[o] - r} or less than 0 for input of shape ${s.shape}`);
  let a = { paddings: t, mode: n }, i = { x: s };
  return M.runKernel(Xa, i, a);
}
var xD = L({ mirrorPad_: vD });
function wD(e, t) {
  let n = _(e, "a", "mod"), s = _(t, "b", "mod");
  [n, s] = vt(n, s);
  let r = { a: n, b: s };
  return M.runKernel(wl, r);
}
var kD = L({ mod_: wD });
function ID(e) {
  let t = _(e, "x", "square"), n = {};
  return M.runKernel("Square", { x: t }, n);
}
var ct = L({ square_: ID });
function SD(e, t = null, n = false) {
  e = _(e, "x", "moments");
  let s = ts(t, e.shape), r = St(e, s, n), a = r.shape;
  n || (a = da(r.shape, s));
  let i = ct(ge(ce(e, "float32"), G(r, a))), o = St(i, s, n);
  return { mean: r, variance: o };
}
var tb = L({ moments_: SD });
function CD(e, t, n, s) {
  let r = _(t, "data", "multiRNNCell"), a = Gu(n, "c", "multiRNNCell"), i = Gu(s, "h", "multiRNNCell"), o = r, u = [];
  for (let p = 0; p < e.length; p++) {
    let d = e[p](o, a[p], i[p]);
    u.push(d[0]), u.push(d[1]), o = d[1];
  }
  let l = [], c = [];
  for (let p = 0; p < u.length; p += 2)
    l.push(u[p]), c.push(u[p + 1]);
  return [l, c];
}
var rpe = L({ multiRNNCell_: CD });
function ND(e, t, n, s = false) {
  let r = _(e, "logits", "multinomial"), a = r.size, i = r.rank;
  if (a < 2)
    throw new Error(`Error in multinomial: you need at least 2 outcomes, but got ${a}.`);
  if (i > 2)
    throw new Error(`Rank of probabilities must be 1 or 2, but is ${i}`);
  n = n || Math.random();
  let u = { logits: i === 1 ? G(r, [1, -1]) : r }, l = { numSamples: t, seed: n, normalized: s }, c = M.runKernel(Cg, u, l);
  return i === 1 ? G(c, [c.size]) : c;
}
var TD = L({ multinomial_: ND });
function $D(e, t) {
  let n = _(e, "a", "notEqual", "string_or_numeric"), s = _(t, "b", "notEqual", "string_or_numeric");
  [n, s] = vt(n, s), ot(n.shape, s.shape);
  let r = { a: n, b: s };
  return M.runKernel(So, r);
}
var Xu = L({ notEqual_: $D });
function _D(e) {
  let n = { x: _(e, "x", "onesLike") };
  return M.runKernel(To, n);
}
var Qn = L({ onesLike_: _D });
function AD(e, t) {
  let n = _(e, "v1", "outerProduct"), s = _(t, "v2", "outerProduct");
  O(n.rank === 1 && s.rank === 1, () => `Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${s.rank}.`);
  let r = G(n, [-1, 1]), a = G(s, [1, -1]);
  return We(r, a);
}
var ape = L({ outerProduct_: AD });
function ED(e, t, n = 0) {
  let s = _(e, "x", "pad");
  if (s.rank === 0)
    throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");
  let r = { paddings: t, constantValue: n }, a = { x: s };
  return M.runKernel(Qa, a, r);
}
var fi = L({ pad_: ED });
function RD(e, t, n = 0) {
  return O(t.length === 2, () => "Invalid number of paddings. Must be length of 2."), fi(e, [t], n);
}
var ipe = L({ pad1d_: RD });
function DD(e, t, n = 0) {
  return O(t.length === 2 && t[0].length === 2 && t[1].length === 2, () => "Invalid number of paddings. Must be length of 2 each."), fi(e, t, n);
}
var ope = L({ pad2d_: DD });
function FD(e, t, n = 0) {
  return O(t.length === 3 && t[0].length === 2 && t[1].length === 2 && t[2].length === 2, () => "Invalid number of paddings. Must be length of 2 each."), fi(e, t, n);
}
var upe = L({ pad3d_: FD });
function OD(e, t, n = 0) {
  return O(t.length === 4 && t[0].length === 2 && t[1].length === 2 && t[2].length === 2 && t[3].length === 2, () => "Invalid number of paddings. Must be length of 2 each."), fi(e, t, n);
}
var lpe = L({ pad4d_: OD });
function PD(e, t, n) {
  let s = _(e, "x", "spaceToBatchND");
  O(s.rank >= 1 + t.length, () => `input rank ${s.rank} should be > than [blockShape] ${t.length}`), O(n.length === t.length, () => `paddings.shape[0] ${n.length} must be equal to [blockShape] ${t.length}`), O(s.shape.reduce((i, o, u) => u > 0 && u <= t.length ? i && (o + n[u - 1][0] + n[u - 1][1]) % t[u - 1] === 0 : i, true), () => `input spatial dimensions ${s.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${t.toString()}`);
  let r = { x: s }, a = { blockShape: t, paddings: n };
  return M.runKernel(Mo, r, a);
}
var nb = L({ spaceToBatchND_: PD });
function zD(e, t, n, s, r, a, i) {
  r == null && (r = [1, 1]), a == null && (a = 1), s === 0 && (s = "valid");
  let o = _(e, "x", "maxPool"), u = o, l = false;
  o.rank === 3 && (l = true, u = G(o, [1, o.shape[0], o.shape[1], o.shape[2]])), O(Ps(a, r), () => `Error in pool: Either strides or dilations must be 1. Got strides ${a} and dilations '${r}'`);
  let c = jk(u.shape, t, a, r, s), p = [c.dilationHeight, c.dilationWidth], d;
  s === "same" ? d = LD([c.filterHeight, c.filterWidth], p) : d = [[0, 0], [0, 0]];
  let h = p[0] === 1 && p[1] === 1, [f, m] = MD([c.inHeight, c.inWidth], p, d), g = h ? s : "valid", b = h ? u : nb(u, p, f), v = (n === "avg" ? () => Gg(b, t, a, g, i) : () => eb(b, t, a, g, i))(), x = h ? v : Hg(v, p, m);
  return l ? G(x, [x.shape[1], x.shape[2], x.shape[3]]) : x;
}
function MD(e, t, n) {
  let s = n.map((c) => c[0]), r = n.map((c) => c[1]), a = e.concat(s, r), i = t.map((c, p) => (c - a[p] % c) % c), o = r.map((c, p) => c + i[p]), u = t.map((c, p) => [s[p], o[p]]), l = t.map((c, p) => [0, i[p]]);
  return [u, l];
}
function LD(e, t) {
  let s = e.map((i, o) => i + (i - 1) * (t[o] - 1)).map((i) => i - 1), r = s.map((i) => Math.floor(i / 2)), a = s.map((i, o) => i - r[o]);
  return s.map((i, o) => [r[o], a[o]]);
}
var cpe = L({ pool_: zD });
function BD(e, t) {
  let n = _(e, "base", "pow"), s = _(t, "exp", "pow");
  [n, s] = vt(n, s);
  let r = { a: n, b: s };
  return M.runKernel(Za, r);
}
var pa = L({ pow_: BD });
function VD(e, t) {
  let n = _(e, "x", "prelu"), s = _(t, "alpha", "prelu"), r = { x: n, alpha: s };
  return M.runKernel(Ja, r);
}
var sb = L({ prelu_: VD });
function WD(e, t = null, n = false) {
  let s = _(e, "x", "prod");
  s.dtype === "bool" && (s = ce(s, "int32"));
  let r = { x: s }, a = { axis: t, keepDims: n };
  return M.runKernel(Ao, r, a);
}
var pI = L({ prod_: WD });
function UD(e, t, n) {
  let s = pt(e), r = null;
  if (n == null || n === "float32")
    r = new Float32Array(s);
  else if (n === "int32")
    r = new Int32Array(s);
  else if (n === "bool")
    r = new Uint8Array(s);
  else
    throw new Error(`Unknown data type ${n}`);
  for (let a = 0; a < s; a++)
    r[a] = t();
  return M.makeTensor(r, e, n);
}
var dpe = L({ rand_: UD });
var rb = xa(Wd());
var ab = class {
  constructor(e, t, n, s, r) {
    this.mean = e, this.stdDev = t, this.dtype = n, this.nextVal = NaN, this.truncated = s, this.truncated && (this.upper = this.mean + this.stdDev * 2, this.lower = this.mean - this.stdDev * 2);
    let a = r || Math.random();
    this.random = rb.alea(a.toString());
  }
  nextValue() {
    if (!isNaN(this.nextVal)) {
      let s = this.nextVal;
      return this.nextVal = NaN, s;
    }
    let e, t, n = false;
    for (; !n; ) {
      let s, r, a;
      do
        s = 2 * this.random() - 1, r = 2 * this.random() - 1, a = s * s + r * r;
      while (a >= 1 || a === 0);
      let i = Math.sqrt(-2 * Math.log(a) / a);
      e = this.mean + this.stdDev * s * i, t = this.mean + this.stdDev * r * i, (!this.truncated || this.isValidTruncated(e)) && (n = true);
    }
    return (!this.truncated || this.isValidTruncated(t)) && (this.nextVal = this.convertValue(t)), this.convertValue(e);
  }
  convertValue(e) {
    return this.dtype == null || this.dtype === "float32" ? e : Math.round(e);
  }
  isValidTruncated(e) {
    return e <= this.upper && e >= this.lower;
  }
};
var GD = class {
  constructor(e, t, n, s) {
    this.alpha = e, this.beta = 1 / t, this.dtype = n;
    let r = s || Math.random();
    this.randu = rb.alea(r.toString()), this.randn = new ab(0, 1, n, false, this.randu()), e < 1 ? this.d = e + 2 / 3 : this.d = e - 1 / 3, this.c = 1 / Math.sqrt(9 * this.d);
  }
  nextValue() {
    let e, t, n, s, r, a;
    for (; ; ) {
      do
        s = this.randn.nextValue(), a = 1 + this.c * s;
      while (a <= 0);
      if (a *= a * a, e = s * s, t = 1 - 0.331 * e * e, n = 0.5 * e + this.d * (1 - a + Math.log(a)), r = this.randu(), r < t || Math.log(r) < n)
        break;
    }
    return a = 1 / this.beta * this.d * a, this.alpha < 1 && (a *= Math.pow(this.randu(), 1 / this.alpha)), this.convertValue(a);
  }
  convertValue(e) {
    return this.dtype === "float32" ? e : Math.round(e);
  }
};
var HD = class {
  constructor(e = 0, t = 1, n, s) {
    if (this.canReturnFloat = () => this.dtype == null || this.dtype === "float32", this.min = e, this.range = t - e, this.dtype = n, s == null && (s = Math.random()), typeof s == "number" && (s = s.toString()), !this.canReturnFloat() && this.range <= 1)
      throw new Error(`The difference between ${e} - ${t} <= 1 and dtype is not float`);
    this.random = rb.alea(s);
  }
  convertValue(e) {
    return this.canReturnFloat() ? e : Math.round(e);
  }
  nextValue() {
    return this.convertValue(this.min + this.range * this.random());
  }
};
function qD(e, t, n = 1, s = "float32", r) {
  if (n == null && (n = 1), s == null && (s = "float32"), s !== "float32" && s !== "int32")
    throw new Error(`Unsupported data type ${s}`);
  let a = new GD(t, n, s, r), i = De(e, s);
  for (let o = 0; o < i.values.length; o++)
    i.values[o] = a.nextValue();
  return i.toTensor();
}
var ppe = L({ randomGamma_: qD });
function jD(e, t = 0, n = 1, s, r) {
  if (s != null && s === "bool")
    throw new Error(`Unsupported data type ${s}`);
  let a = new ab(t, n, s, false, r), i = De(e, s);
  for (let o = 0; o < i.values.length; o++)
    i.values[o] = a.nextValue();
  return i.toTensor();
}
var KD = L({ randomNormal_: jD });
function XD(e, t = 0, n = 1, s = "float32", r) {
  let a = De(e, s), i = new HD(t, n, null, r);
  for (let o = 0; o < a.values.length; o++)
    a.values[o] = i.nextValue();
  return a.toTensor();
}
var Ml = L({ randomUniform_: XD });
function Yu(e, t, n = 1, s = "float32") {
  if (n === 0)
    throw new Error("Cannot have a step of zero");
  let r = { start: e, stop: t, step: n, dtype: s };
  return M.runKernel(Il, {}, r);
}
function YD(e) {
  let n = { input: _(e, "input", "real") };
  return M.runKernel(np, n);
}
var wd = L({ real_: YD });
function QD(e) {
  let n = { x: _(e, "x", "reciprocal") };
  return M.runKernel(Sl, n);
}
var ZD = L({ reciprocal_: QD });
function JD(e) {
  let n = { x: _(e, "x", "relu") };
  return M.runKernel(ei, n);
}
var Xs = L({ relu_: JD });
function e3(e) {
  let n = { x: _(e, "x", "relu6") };
  return M.runKernel(ni, n);
}
var hI = L({ relu6_: e3 });
function t3(e, t) {
  let s = { x: _(e, "x", "reverse") }, r = { dims: t };
  return M.runKernel(Ro, s, r);
}
var Zn = L({ reverse_: t3 });
function n3(e) {
  let t = _(e, "x", "reverse");
  return O(t.rank === 1, () => `Error in reverse1D: x must be rank 1 but got rank ${t.rank}.`), Zn(t, 0);
}
var hpe = L({ reverse1d_: n3 });
function s3(e, t) {
  let n = _(e, "x", "reverse");
  return O(n.rank === 2, () => `Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`), Zn(n, t);
}
var fpe = L({ reverse2d_: s3 });
function r3(e, t) {
  let n = _(e, "x", "reverse");
  return O(n.rank === 3, () => `Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`), Zn(n, t);
}
var mpe = L({ reverse3d_: r3 });
function a3(e, t) {
  let n = _(e, "x", "reverse");
  return O(n.rank === 4, () => `Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`), Zn(n, t);
}
var gpe = L({ reverse4d_: a3 });
function i3(e) {
  let n = { x: _(e, "x", "round") };
  return M.runKernel(Do, n);
}
var fI = L({ round_: i3 });
function o3(e) {
  let n = { x: _(e, "x", "rsqrt", "float32") };
  return M.runKernel(si, n);
}
var mI = L({ rsqrt_: o3 });
function we(e, t) {
  if ((Qt(e) && t !== "string" || Array.isArray(e)) && t !== "complex64")
    throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");
  if (t === "string" && Qt(e) && !(e instanceof Uint8Array))
    throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");
  return Nr(e, [], [], t);
}
function u3(e) {
  let n = { x: _(e, "x", "selu") };
  return M.runKernel(Nl, n);
}
var gI = L({ selu_: u3 });
function l3(e, t, n, s, r, a = [1, 1], i = "NHWC") {
  let o = _(e, "x", "separableConv2d"), u = _(t, "depthwiseFilter", "separableConv2d"), l = _(n, "pointwiseFilter", "separableConv2d"), c = o, p = false;
  if (o.rank === 3 && (p = true, c = G(o, [1, o.shape[0], o.shape[1], o.shape[2]])), i === "NCHW")
    throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");
  O(c.rank === 4, () => `Error in separableConv2d: input must be rank 4, but got rank ${c.rank}.`), O(u.rank === 4, () => `Error in separableConv2d: depthwise filter must be rank 4, but got rank ${u.rank}.`), O(l.rank === 4, () => `Error in separableConv2d: pointwise filter must be rank 4, but got rank ${u.rank}.`), O(l.shape[0] === 1, () => `Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${l.shape[0]}.`), O(l.shape[1] === 1, () => `Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${l.shape[1]}.`);
  let d = u.shape[2], h = u.shape[3];
  O(l.shape[2] === d * h, () => `Error in separableConv2d: the third dimension of pointwise filter must be ${d * h}, but got ${l.shape[2]}.`);
  let f = hp(c, u, s, r, i, a), g = ca(f, l, 1, "valid", i);
  return p ? G(g, [g.shape[1], g.shape[2], g.shape[3]]) : g;
}
var c3 = L({ separableConv2d_: l3 });
async function d3(e, t) {
  let n = _(e, "x", "setdiff1d"), s = _(t, "y", "setdiff1d");
  O(n.dtype === s.dtype, () => `x and y should have the same dtype, but got x (${n.dtype}) and y (${s.dtype}).`), O(n.rank === 1, () => `x should be 1D tensor, but got x (${n.shape}).`), O(s.rank === 1, () => `y should be 1D tensor, but got y (${s.shape}).`);
  let r = await n.data(), a = await s.data(), i = new Set(a), o = 0;
  for (let c = 0; c < r.length; c++)
    i.has(r[c]) || o++;
  let u = new Vt([o], n.dtype), l = new Vt([o], "int32");
  for (let c = 0, p = 0; c < r.length; c++)
    i.has(r[c]) || (u.values[p] = r[c], l.values[p] = c, p++);
  return [u.toTensor(), l.toTensor()];
}
var p3 = d3;
function h3(e) {
  let n = { x: _(e, "x", "sign") };
  return M.runKernel(Tl, n);
}
var f3 = L({ sign_: h3 });
function m3(e) {
  let n = { x: _(e, "x", "sin", "float32") };
  return M.runKernel(ri, n);
}
var bI = L({ sin_: m3 });
function g3(e) {
  let n = { x: _(e, "x", "sinh") };
  return M.runKernel(zo, n);
}
var yI = L({ sinh_: g3 });
function b3(e, t, n) {
  let s = _(e, "x", "slice1d");
  return O(s.rank === 1, () => `slice1d expects a rank-1 tensor, but got a rank-${s.rank} tensor`), He(s, [t], [n]);
}
var ib = L({ slice1d_: b3 });
function y3(e, t, n) {
  let s = _(e, "x", "slice2d");
  return O(s.rank === 2, () => `slice2d expects a rank-2 tensor, but got a rank-${s.rank} tensor`), He(s, t, n);
}
var vI = L({ slice2d_: y3 });
function v3(e, t, n) {
  let s = _(e, "x", "slice3d");
  return O(s.rank === 3, () => `slice3d expects a rank-3 tensor, but got a rank-${s.rank} tensor`), He(s, t, n);
}
var ob = L({ slice3d_: v3 });
function x3(e, t, n) {
  let s = _(e, "x", "slice4d");
  return O(s.rank === 4, () => `slice4d expects a rank-4 tensor, but got a rank-${s.rank} tensor`), He(s, t, n);
}
var kd = L({ slice4d_: x3 });
function w3(e, t = -1) {
  let n = _(e, "logits", "softmax", "float32");
  if (t === -1 && (t = n.rank - 1), t !== n.rank - 1)
    throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${t}`);
  let s = { logits: n }, r = { dim: t };
  return M.runKernel(ui, s, r);
}
var ub = L({ softmax_: w3 });
function k3(e) {
  O(e.dtype === "complex64", () => `The dtype for tf.spectral.fft() must be complex64 but got ${e.dtype}.`);
  let t = { input: e };
  return M.runKernel(yg, t);
}
var lb = L({ fft_: k3 });
function I3(e) {
  O(e.dtype === "complex64", () => `The dtype for tf.spectral.ifft() must be complex64 but got ${e.dtype}.`);
  let t = { input: e };
  return M.runKernel(vg, t);
}
var Id = L({ ifft_: I3 });
function S3(e) {
  let t = e.shape[e.shape.length - 1], n = e.size / t, s;
  if (t <= 2) {
    let r = G(e, [n, t]);
    s = Id(r);
  } else {
    let r = [n, 2 * (t - 1)], a = G(wd(e), [n, t]), i = G(Kg(e), [n, t]), o = Zn(He(a, [0, 1], [n, t - 2]), 1), u = V(Zn(He(i, [0, 1], [n, t - 2]), 1), we(-1)), l = Ft([a, o], 1), c = Ft([i, u], 1), p = G(oa(l, c), [r[0], r[1]]);
    s = Id(p);
  }
  if (s = wd(s), e.rank === 3 && e.shape[0] !== 0) {
    let r = s, a = e.shape[0];
    s = G(s, [a, s.shape[0] / a, s.shape[1]]), r.dispose();
  }
  return s;
}
var xI = L({ irfft_: S3 });
function C3(e, t, n = 0) {
  let r = { x: _(e, "x", "split") }, a = { numOrSizeSplits: t, axis: n };
  return M.runKernel(Lo, r, a);
}
var Bn = L({ split_: C3 });
function N3(e, t) {
  O(e.dtype === "float32", () => `The dtype for rfft() must be real value but got ${e.dtype}`);
  let n = e.shape[e.shape.length - 1], s = e.size / n, r;
  if (t != null && t < n) {
    let f = e.shape.map((g) => 0), m = e.shape.map((g) => g);
    m[e.shape.length - 1] = t, r = He(e, f, m), n = t;
  } else if (t != null && t > n) {
    let f = e.shape.map((m) => m);
    f[e.shape.length - 1] = t - n, r = Ft([e, $t(f)], e.shape.length - 1), n = t;
  } else
    r = e;
  let a = je(r), i = G(oa(r, a), [s, n]), o = lb(i), u = Math.floor(n / 2) + 1, l = wd(o), c = Kg(o), p = Bn(l, [u, n - u], l.shape.length - 1), d = Bn(c, [u, n - u], c.shape.length - 1), h = r.shape.slice();
  return h[r.shape.length - 1] = u, G(oa(p[0], d[0]), h);
}
var cb = L({ rfft_: N3 });
function T3(e) {
  let n = { x: _(e, "x", "sqrt", "float32") };
  return M.runKernel(ii, n);
}
var dn = L({ sqrt_: T3 });
function $3(e, t) {
  let n = _(e, "a", "squaredDifference"), s = _(t, "b", "squaredDifference");
  [n, s] = vt(n, s), ot(n.shape, s.shape);
  let r = { a: n, b: s }, a = {};
  return M.runKernel(li, r, a);
}
var wI = L({ squaredDifference_: $3 });
function _3(e, t) {
  let n = _(e, "x", "squeeze");
  return G(n, Gw(n.shape, t).newShape);
}
var mr = L({ squeeze_: _3 });
function A3(e, t = 0) {
  let n = Gu(e, "tensors", "stack", "string_or_numeric");
  O(n.length >= 1, () => "Pass at least one tensor to tf.stack"), n.length > 0 && O(t <= n[0].rank, () => "Axis must be <= rank of the tensor");
  let s = n, r = { axis: t };
  return M.runKernel(_o, s, r);
}
var Jn = L({ stack_: A3 });
function E3(e, t = 0) {
  let s = { x: _(e, "x", "step") }, r = { alpha: t };
  return M.runKernel(hi, s, r);
}
var yp = L({ step_: E3 });
function R3(e, t, n, s, r = 0, a = 0, i = 0, o = 0, u = 0) {
  let c = { x: _(e, "x", "stridedSlice", "string_or_numeric") }, p = { begin: t, end: n, strides: s, beginMask: r, endMask: a, ellipsisMask: i, newAxisMask: o, shrinkAxisMask: u };
  return M.runKernel(Bo, c, p);
}
var D3 = L({ stridedSlice_: R3 });
function F3(e) {
  let n = { x: _(e, "x", "tan", "float32") };
  return M.runKernel(Vo, n);
}
var O3 = L({ tan_: F3 });
function Zt(e, t) {
  wa(e);
  let n = Rs(e, t);
  if (n.length !== 1)
    throw new Error("tensor1d() requires values to be a flat/TypedArray");
  return Nr(e, null, n, t);
}
function Ki(e, t, n) {
  if (wa(e), t != null && t.length !== 2)
    throw new Error("tensor2d() requires shape to have two numbers");
  let s = Rs(e, n);
  if (s.length !== 2 && s.length !== 1)
    throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");
  if (s.length === 1 && t == null)
    throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");
  return Nr(e, t, s, n);
}
function bpe(e, t, n) {
  if (wa(e), t != null && t.length !== 4)
    throw new Error("tensor4d() requires shape to have four numbers");
  let s = Rs(e, n);
  if (s.length !== 4 && s.length !== 1)
    throw new Error("tensor4d() requires values to be number[][][][] or flat/TypedArray");
  if (s.length === 1 && t == null)
    throw new Error("tensor4d() requires shape to be provided when `values` are a flat array");
  return Nr(e, t, s, n);
}
function ype(e, t, n) {
  if (wa(e), t != null && t.length !== 5)
    throw new Error("tensor5d() requires shape to have five numbers");
  let s = Rs(e, n);
  if (s.length !== 5 && s.length !== 1)
    throw new Error("tensor5d() requires values to be number[][][][][] or flat/TypedArray");
  if (s.length === 1 && t == null)
    throw new Error("tensor5d() requires shape to be provided when `values` are a flat array");
  return Nr(e, t, s, n);
}
function vpe(e, t, n) {
  if (wa(e), t != null && t.length !== 6)
    throw new Error("tensor6d() requires shape to have six numbers");
  let s = Rs(e, n);
  if (s.length !== 6 && s.length !== 1)
    throw new Error("tensor6d() requires values to be number[][][][][][] or flat/TypedArray");
  if (s.length === 1 && t == null)
    throw new Error("tensor6d() requires shape to be provided when `values` are a flat array");
  return t = t || s, Nr(e, t, s, n);
}
function P3(e, t = 1, n = true) {
  let s = _(e, "x", "topk");
  if (s.rank === 0)
    throw new Error("topk() expects the input to be of rank 1 or higher");
  let r = s.shape[s.shape.length - 1];
  if (t < 0)
    throw new Error(`'k' passed to topk() must be >= 0 but got ${t}`);
  if (t > r)
    throw new Error(`'k' passed to topk() must be <= the last dimension (${r}) but got ${t}`);
  let a = { x: s }, i = { k: t, sorted: n }, [o, u] = M.runKernel(Wo, a, i);
  return { values: o, indices: u };
}
var z3 = L({ topk_: P3 });
function M3(e, t = 0, n = 1, s, r) {
  if (s != null && s === "bool")
    throw new Error("Unsupported data type $ { dtype }");
  let a = new ab(t, n, s, true, r), i = De(e, s);
  for (let o = 0; o < i.values.length; o++)
    i.values[o] = a.nextValue();
  return i.toTensor();
}
var db = L({ truncatedNormal_: M3 });
function L3(e, t = 0) {
  let n = _(e, "x", "unique", "string_or_numeric");
  O(n.rank > 0, () => "The input tensor must be at least 1D");
  let s = { x: n }, r = { axis: t }, [a, i] = M.runKernel(Ag, s, r);
  return { values: a, indices: i };
}
var hx = L({ unique_: L3 });
function B3(e, t, n) {
  let s = _(e, "x", "unsortedSegmentSum"), r = _(t, "segmentIds", "unsortedSegmentSum", "int32");
  O(Yi(n), () => "numSegments must be of dtype int");
  let a = { x: s, segmentIds: r }, i = { numSegments: n };
  return M.runKernel(up, a, i);
}
var V3 = L({ unsortedSegmentSum_: B3 });
function W3(e, t = 0) {
  let n = _(e, "x", "unstack", "string_or_numeric");
  O(t >= -n.shape.length && t < n.shape.length, () => `Axis = ${t} is not in [-${n.shape.length}, ${n.shape.length})`);
  let s = { value: n }, r = { axis: t };
  return M.runKernel(Go, s, r);
}
var Fs = L({ unstack_: W3 });
function U3(e, t = true, n, s) {
  return M.makeVariable(e, t, n, s);
}
function kI(e, t) {
  let n = [];
  for (let a = 0; a < t.length; a++)
    t[a] && n.push(a);
  let s = De(e, "int32"), r = De([n.length, e.length], "int32");
  for (let a = 0; a < n.length; a++) {
    let i = s.indexToLoc(n[a]), o = a * e.length;
    r.values.set(i, o);
  }
  return r.toTensor();
}
async function G3(e) {
  let t = _(e, "condition", "whereAsync", "bool"), n = await t.data(), s = kI(t.shape, n);
  return e !== t && t.dispose(), s;
}
var II = G3;
async function H3(e, t, n) {
  let s = _(e, "tensor", "boolMask"), r = _(t, "mask", "boolMask", "bool"), a = n == null ? 0 : n, i = r.rank, o = s.shape;
  O(i > 0, () => "mask cannot be scalar"), pn(o.slice(a, a + i), r.shape, "mask's shape must match the first K dimensions of tensor's shape,");
  let u = 1;
  for (let m = a; m < a + i; m++)
    u *= o[m];
  let l = o.slice(0, a).concat([u], o.slice(a + i)), c = G(s, l), p = G(r, [-1]), d = await II(p), h = mr(d, [1]), f = Ku(c, h, a);
  return e !== s && s.dispose(), t !== r && r.dispose(), h.dispose(), c.dispose(), p.dispose(), d.dispose(), f;
}
var xpe = H3;
function q3(e, t = "euclidean", n = null, s = false) {
  e = _(e, "x", "norm");
  let r = SI(e, t, n), a = r.shape;
  if (s) {
    let i = ts(n, e.shape);
    a = da(r.shape, i);
  }
  return G(r, a);
}
function SI(e, t, n = null) {
  if (e.rank === 0)
    return Mt(e);
  if (e.rank !== 1 && n === null)
    return SI(G(e, [-1]), t, n);
  if (e.rank === 1 || typeof n == "number" || Array.isArray(n) && n.length === 1) {
    if (t === 1)
      return ve(Mt(e), n);
    if (t === 1 / 0)
      return As(Mt(e), n);
    if (t === -1 / 0)
      return fm(Mt(e), n);
    if (t === "euclidean" || t === 2)
      return dn(ve(pa(Mt(e), we(2, "int32")), n));
    throw new Error(`Error in norm: invalid ord value: ${t}`);
  }
  if (Array.isArray(n) && n.length === 2) {
    if (t === 1)
      return As(ve(Mt(e), n[0]), n[1] - 1);
    if (t === 1 / 0)
      return As(ve(Mt(e), n[1]), n[0]);
    if (t === -1 / 0)
      return fm(ve(Mt(e), n[1]), n[0]);
    if (t === "fro" || t === "euclidean")
      return dn(ve(ct(e), n));
    throw new Error(`Error in norm: invalid ord value: ${t}`);
  }
  throw new Error(`Error in norm: invalid axis: ${n}`);
}
var CI = L({ norm_: q3 });
function j3(e, t, n, s, r = true) {
  let a = _(e, "v", "movingAverage"), i = _(t, "x", "movingAverage"), o = _(n, "decay", "movingAverage");
  uk(a, i), O(kr(a.shape, i.shape), () => "Shape mismatch in v and x");
  let u = we(1), l = ge(u, o), c = V(ge(i, a), l);
  if (r) {
    O(s != null, () => "When using zeroDebias: true, step is required.");
    let p = _(s, "step", "movingAverage");
    c = xe(c, ge(u, pa(o, p)));
  }
  return ie(a, c);
}
var wpe = L({ movingAverage_: j3 });
function K3(e, t, n) {
  let s = _(e, "indices", "scatterND", "int32"), r = _(t, "updates", "scatterND");
  Bg(r, s, n);
  let a = { indices: s, updates: r }, i = { shape: n };
  return M.runKernel(Fo, a, i);
}
var X3 = L({ scatterND_: K3 });
function Y3(e, t, n, s) {
  if (e.dtype !== "int32")
    throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${e.dtype}.`);
  if (e.rank > 2)
    throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${e.shape}.`);
  let r = e.rank > 0 ? e.shape[0] : 1, a = e.rank > 1 ? e.shape[1] : 1;
  if (n.length !== a)
    throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${a}.`);
  let i = t.size;
  if (!(t.rank === 0 || t.rank === 1 && i === r))
    throw new Error(`sparseValues has incorrect shape ${t.shape}, should be [] or [${r}]`);
  if (t.dtype !== s.dtype)
    throw new Error("sparseValues.dtype must match defaultValues.dtype");
}
function Q3(e, t, n, s = 0) {
  let r = _(e, "sparseIndices", "sparseToDense", "int32"), a = _(t, "sparseValues", "sparseToDense"), i = _(s, "defaultValue", "sparseToDense", a.dtype);
  Y3(r, a, n, i);
  let o = { sparseIndices: r, sparseValues: a, defaultValue: i }, u = { outputShape: n };
  return M.runKernel(ip, o, u);
}
var NI = L({ sparseToDense_: Q3 });
function Z3(e, t) {
  let n = _(t, "indices", "gatherND", "int32"), r = { params: _(e, "x", "gatherND", "string_or_numeric"), indices: n };
  return M.runKernel(yo, r);
}
var J3 = L({ gatherND_: Z3 });
function eF(e, t) {
  if (t == null)
    return e.shape.slice();
  if (kr(e.shape, t))
    return t;
  if (e.shape.length === t.length) {
    let n = [];
    for (let s = 0; s < e.shape.length; s++)
      t[s] == null && e.shape[s] != null ? n.push(e.shape[s]) : n.push(t[s]);
    return n;
  }
  return t;
}
function tF(e, t, n, s) {
  let r = _(e, "x", "dropout");
  if (O(r.dtype === "float32", () => `x has to be a floating point tensor since it's going to be scaled, but got a ${r.dtype} tensor instead.`), O(t >= 0 && t < 1, () => `rate must be a float in the range [0, 1), but got ${t}.`), t === 0)
    return e instanceof et ? r.clone() : r;
  let a = eF(r, n), i = 1 - t, o = xe(mp(ie(Ml(a, 0, 1, "float32", s), i)), i);
  return V(r, o);
}
var nF = L({ dropout_: tF });
function sF(e) {
  return Math.floor(Math.pow(2, Math.ceil(Math.log(e) / Math.log(2))));
}
function TI(e, t, n) {
  let s = 1 - e % 2, r = new Float32Array(e);
  for (let a = 0; a < e; ++a) {
    let i = 2 * Math.PI * a / (e + s - 1);
    r[a] = t - n * Math.cos(i);
  }
  return Zt(r, "float32");
}
async function rF(e, t, n = 1) {
  let s = _(e, "predictions", "inTopK"), r = _(t, "targets", "inTopK");
  O(s.rank > 1, () => `inTopK() expects the predictions to be of rank 2 or higher, but got ${s.rank}`), O(s.rank - 1 === r.rank, () => `predictions rank should be 1 larger than targets rank, but got predictions rank ${s.rank} and targets rank ${r.rank}`), pn(s.shape.slice(0, s.shape.length - 1), r.shape, "predictions's shape should be align with the targets' shape, except the last dimension.");
  let a = s.shape[s.shape.length - 1];
  O(n > 0 && n <= a, () => `'k' passed to inTopK() must be > 0 && <= the predictions last dimension (${a}), but got ${n}`);
  let i = await s.data(), o = await r.data(), [u, l] = [i.length / a, a], c = Hw("bool", u);
  for (let p = 0; p < u; p++) {
    let d = p * l, h = i.subarray(d, d + l), f = [];
    for (let m = 0; m < h.length; m++)
      f.push({ value: h[m], index: m });
    f.sort((m, g) => g.value - m.value), c[p] = 0;
    for (let m = 0; m < n; m++)
      if (f[m].index === o[p]) {
        c[p] = 1;
        break;
      }
  }
  return e !== s && s.dispose(), t !== r && r.dispose(), fs(c, r.shape, "bool");
}
var kpe = rF;
var ha = {};
Ae(ha, { conv2d: () => oF, depthwiseConv2d: () => dF, matMul: () => hF });
function aF(e, t, n, s, r, a = "NHWC", i) {
  let o = e;
  e.rank === 3 && (o = G(e, [1, e.shape[0], e.shape[1], e.shape[2]]));
  let u = t;
  u.rank === 3 && (u = G(t, [1, t.shape[0], t.shape[1], t.shape[2]])), O(o.rank === 4, () => `Error in conv2dDerFilter: input must be rank 4, but got shape ${o.shape}.`), O(u.rank === 4, () => `Error in conv2dDerFilter: dy must be rank 4, but got shape ${u.shape}.`), O(n.length === 4, () => `Error in conv2dDerFilter: filterShape must be length 4, but got ${n}.`);
  let l = a === "NHWC" ? o.shape[3] : o.shape[1], c = a === "NHWC" ? u.shape[3] : u.shape[1];
  O(l === n[2], () => `Error in conv2dDerFilter: depth of input ${l}) must match input depth in filter (${n[2]}.`), O(c === n[3], () => `Error in conv2dDerFilter: depth of dy (${c}) must match output depth for filter (${n[3]}).`), hn("conv2dDerFilter", r, i);
  let p = { x: o, dy: u }, d = { strides: s, pad: r, dataFormat: a, dimRoundingMode: i, filterShape: n };
  return M.runKernel(cg, p, d);
}
var pb = L({ conv2DBackpropFilter_: aF });
function vp(e, t, n) {
  if (n == null || n === "linear")
    return e;
  if (n === "relu")
    return V(e, yp(t));
  throw new Error(`Cannot compute gradient for fused activation ${n}.`);
}
function xp(e, t) {
  let n = t, s = _t(e.shape, t.shape);
  return s.length > 0 && (n = ve(n, s)), G(n, e.shape);
}
function wp(e, t, n, s) {
  if (t === "linear")
    return e;
  if (t === "relu")
    return Xs(e);
  if (t === "elu")
    return fp(e);
  if (t === "relu6")
    return hI(e);
  if (t === "prelu")
    return sb(e, n);
  if (t === "leakyrelu")
    return Xg(e, s);
  if (t === "sigmoid")
    return qs(e);
  throw new Error(`Unknown fused activation ${t}.`);
}
var kp = (e, t) => !(e > 0) || t === "linear";
function iF({ x: e, filter: t, strides: n, pad: s, dataFormat: r = "NHWC", dilations: a = [1, 1], dimRoundingMode: i, bias: o, activation: u = "linear", preluActivationWeights: l, leakyreluAlpha: c }) {
  if (u = u || "linear", kp(M.state.gradientDepth, u) === false) {
    let k = ca(e, t, n, s, r, a, i);
    return o != null && (k = ie(k, o)), wp(k, u, l, c);
  }
  let p = _(e, "x", "conv2d", "float32"), d = _(t, "filter", "conv2d", "float32"), h = p, f = false;
  p.rank === 3 && (f = true, h = G(p, [1, p.shape[0], p.shape[1], p.shape[2]])), O(h.rank === 4, () => `Error in fused conv2d: input must be rank 4, but got rank ${h.rank}.`), O(d.rank === 4, () => `Error in fused conv2d: filter must be rank 4, but got rank ${d.rank}.`), hn("fused conv2d", s, i), O(h.shape[3] === d.shape[2], () => `Error in conv2d: depth of input (${h.shape[3]}) must match input depth for filter ${d.shape[2]}.`), O(Ps(n, a), () => `Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`), O(r === "NHWC", () => `Error in conv2d: got dataFormat of ${r} but only NHWC is currently supported.`);
  let m = Ol(h.shape, d.shape, n, a, s, i), g;
  o != null && (g = _(o, "bias", "fused conv2d"), [g] = vt(g, p), ot(m.outShape, g.shape));
  let b;
  l != null && (b = _(l, "prelu weights", "fused conv2d"));
  let y = (k, T) => {
    let [N, E, A, P] = T, R = vp(k, A, u);
    O(fr(a), () => `Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`);
    let F = qg(E.shape, R, N, n, s), $ = pb(E, R, N.shape, n, s), z = [F, $];
    if (P != null) {
      let W = xp(P, R);
      z.push(W);
    }
    return z;
  }, v = { x: h, filter: d, bias: g, preluActivationWeights: b }, x = { strides: n, pad: s, dataFormat: r, dilations: a, dimRoundingMode: i, activation: u, leakyreluAlpha: c };
  return o == null ? js((T, N, E) => {
    let A = M.runKernel(aa, v, x);
    return E([N, T, A]), f && (A = G(A, [A.shape[1], A.shape[2], A.shape[3]])), { value: A, gradFunc: y };
  })(h, d) : js((T, N, E, A) => {
    let P = M.runKernel(aa, v, x);
    return A([N, T, P, E]), f && (P = G(P, [P.shape[1], P.shape[2], P.shape[3]])), { value: P, gradFunc: y };
  })(h, d, g);
}
var oF = L({ fusedConv2d_: iF });
function uF(e, t, n, s, r, a = [1, 1], i) {
  let o = e;
  e.rank === 3 && (o = G(e, [1, e.shape[0], e.shape[1], e.shape[2]]));
  let u = t;
  u.rank === 3 && (u = G(t, [1, t.shape[0], t.shape[1], t.shape[2]]));
  let l = { x: o, dy: u }, c = { strides: s, pad: r, dimRoundingMode: i, dilations: a, filterShape: n };
  return M.runKernel(fg, l, c);
}
var $I = L({ depthwiseConv2dNativeBackpropFilter_: uF });
function lF(e, t, n, s, r, a = [1, 1], i) {
  let o = t, u = false;
  t.rank === 3 && (u = true, o = G(t, [1, t.shape[0], t.shape[1], t.shape[2]]));
  let l = { dy: o, filter: n }, c = { strides: s, pad: r, dimRoundingMode: i, dilations: a, inputShape: e }, p = M.runKernel(mg, l, c);
  return u ? G(p, [p.shape[1], p.shape[2], p.shape[3]]) : p;
}
var _I = L({ depthwiseConv2dNativeBackpropInput_: lF });
function cF({ x: e, filter: t, strides: n, pad: s, dataFormat: r = "NHWC", dilations: a = [1, 1], dimRoundingMode: i, bias: o, activation: u = "linear", preluActivationWeights: l, leakyreluAlpha: c }) {
  if (kp(M.state.gradientDepth, u) === false) {
    let k = hp(e, t, n, s, r, a, i);
    return o != null && (k = ie(k, o)), wp(k, u, l, c);
  }
  let p = _(e, "x", "depthwiseConv2d", "float32"), d = _(t, "filter", "depthwiseConv2d", "float32"), h = p, f = false;
  p.rank === 3 && (f = true, h = G(p, [1, p.shape[0], p.shape[1], p.shape[2]])), O(h.rank === 4, () => `Error in fused depthwiseConv2d: input must be rank 4, but got rank ${h.rank}.`), O(d.rank === 4, () => `Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${d.rank}.`), O(h.shape[3] === d.shape[2], () => `Error in fused depthwiseConv2d: number of input channels (${h.shape[3]}) must match the inChannels dimension in filter ${d.shape[2]}.`), a == null && (a = [1, 1]), O(Ps(n, a), () => `Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`), hn("fused depthwiseConv2d", s, i);
  let m = Ol(h.shape, d.shape, n, a, s, i, true), g;
  o != null && (g = _(o, "bias", "fused conv2d"), [g] = vt(g, p), ot(m.outShape, g.shape));
  let b;
  l != null && (b = _(l, "prelu weights", "fused depthwiseConv2d"));
  let y = (k, T) => {
    O(fr(a), () => `Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${a}'`);
    let [N, E, A, P] = T, R = vp(k, A, u), F = _I(E.shape, R, N, n, s, a, i), $ = $I(E, R, N.shape, n, s, a, i);
    if (P != null) {
      let z = xp(g, R);
      return [F, $, z];
    }
    return [F, $];
  }, v = { x: h, filter: d, bias: g, preluActivationWeights: b }, x = { strides: n, pad: s, dataFormat: r, dilations: a, dimRoundingMode: i, activation: u, leakyreluAlpha: c };
  return o == null ? js((T, N, E) => {
    let A = M.runKernel(ia, v, x);
    return E([N, T, A]), f && (A = G(A, [A.shape[1], A.shape[2], A.shape[3]])), { value: A, gradFunc: y };
  })(h, d) : js((T, N, E, A) => {
    let P = M.runKernel(ia, v, x);
    return A([N, T, P, E]), f && (P = G(P, [P.shape[1], P.shape[2], P.shape[3]])), { value: P, gradFunc: y };
  })(h, d, g);
}
var dF = L({ fusedDepthwiseConv2d_: cF });
function pF({ a: e, b: t, transposeA: n = false, transposeB: s = false, bias: r, activation: a = "linear", preluActivationWeights: i, leakyreluAlpha: o }) {
  if (kp(M.state.gradientDepth, a) === false) {
    let R = We(e, t, n, s);
    return r != null && (R = ie(R, r)), wp(R, a, i, o);
  }
  let u = _(e, "a", "fused matMul"), l = _(t, "b", "fused matMul");
  [u, l] = vt(u, l);
  let c = n ? u.shape[u.rank - 2] : u.shape[u.rank - 1], p = s ? l.shape[l.rank - 1] : l.shape[l.rank - 2], d = n ? u.shape[u.rank - 1] : u.shape[u.rank - 2], h = s ? l.shape[l.rank - 2] : l.shape[l.rank - 1], f = u.shape.slice(0, -2), m = l.shape.slice(0, -2), g = pt(f), b = pt(m);
  O(c === p, () => `Error in fused matMul: inner shapes (${c}) and (${p}) of Tensors with shapes ${u.shape} and ${l.shape} and transposeA=${n} and transposeB=${s} must match.`);
  let v = ot(u.shape.slice(0, -2), l.shape.slice(0, -2)).concat([d, h]), x = n ? G(u, [g, c, d]) : G(u, [g, d, c]), k = s ? G(l, [b, h, p]) : G(l, [b, p, h]), T;
  r != null && (T = _(r, "bias", "fused matMul"), [T] = vt(T, u), ot(v, T.shape));
  let N;
  i != null && (N = _(i, "prelu weights", "fused matMul"));
  let E = (R, F) => {
    let [$, z, W, q] = F, K = vp(G(R, W.shape), W, a), Y, Z;
    if (!n && !s ? (Y = We(K, z, false, true), Z = We($, K, true, false)) : !n && s ? (Y = We(K, z, false, false), Z = We(K, $, true, false)) : n && !s ? (Y = We(z, K, false, true), Z = We($, K, false, false)) : (Y = We(z, K, true, true), Z = We(K, $, true, true)), r != null) {
      let te = xp(q, K);
      return [Y, Z, te];
    } else
      return [Y, Z];
  }, A = { a: x, b: k, bias: T, preluActivationWeights: N }, P = { transposeA: n, transposeB: s, activation: a, leakyreluAlpha: o };
  return r == null ? js((F, $, z) => {
    let W = M.runKernel(ra, A, P);
    return z([F, $, W]), { value: G(W, v), gradFunc: E };
  })(x, k) : js((F, $, z, W) => {
    let q = M.runKernel(ra, A, P);
    return W([F, $, q, z]), { value: G(q, v), gradFunc: E };
  })(x, k, T);
}
var hF = L({ fusedMatMul_: pF });
function fF(e) {
  return TI(e, 0.54, 0.46);
}
var mF = L({ hammingWindow_: fF });
function gF(e) {
  return TI(e, 0.5, 0.5);
}
var AI = L({ hannWindow_: gF });
function bF(e, t, n, s = false, r = 0) {
  let a = 0, i = [];
  for (; a + t <= e.size; )
    i.push(He(e, a, t)), a += n;
  if (s)
    for (; a < e.size; ) {
      let o = a + t - e.size, u = Ft([He(e, a, t - o), Pl([o], r)]);
      i.push(u), a += n;
    }
  return i.length === 0 ? Ki([], [0, t]) : G(Ft(i), [i.length, t]);
}
var EI = L({ frame_: bF });
function yF(e, t, n, s, r = AI) {
  s == null && (s = sF(t));
  let a = EI(e, t, n), i = V(a, r(t));
  return cb(i, s);
}
var vF = L({ stft_: yF });
function xF(e, t, n, s, r = "bilinear", a = 0) {
  let i = _(e, "image", "cropAndResize"), o = _(t, "boxes", "cropAndResize", "float32"), u = _(n, "boxInd", "cropAndResize", "int32"), l = o.shape[0];
  O(i.rank === 4, () => `Error in cropAndResize: image must be rank 4,but got rank ${i.rank}.`), O(o.rank === 2 && o.shape[1] === 4, () => `Error in cropAndResize: boxes must be have size [${l},4] but had shape ${o.shape}.`), O(u.rank === 1 && u.shape[0] === l, () => `Error in cropAndResize: boxInd must be have size [${l}] but had shape ${o.shape}.`), O(s.length === 2, () => `Error in cropAndResize: cropSize must be of length 2, but got length ${s.length}.`), O(s[0] >= 1 && s[1] >= 1, () => `cropSize must be atleast [1,1], but was ${s}`), O(r === "bilinear" || r === "nearest", () => `method must be bilinear or nearest, but was ${r}`);
  let c = { image: i, boxes: o, boxInd: u }, p = { method: r, extrapolationValue: a, cropSize: s };
  return M.runKernel(co, c, p);
}
var wF = L({ cropAndResize_: xF });
function kF(e) {
  let t = _(e, "image", "flipLeftRight", "float32");
  O(t.rank === 4, () => `Error in flipLeftRight: image must be rank 4,but got rank ${t.rank}.`);
  let n = { image: t };
  return M.runKernel(go, n, {});
}
var IF = L({ flipLeftRight_: kF });
function SF(e) {
  let t = _(e, "image", "grayscaleToRGB"), n = t.rank - 1, s = t.shape[n];
  O(t.rank >= 2, () => `Error in grayscaleToRGB: images must be at least rank 2, but got rank ${t.rank}.`), O(s === 1, () => `Error in grayscaleToRGB: last dimension of a grayscale image should be size 1, but got size ${s}.`);
  let r = new Array(t.rank);
  return r.fill(1, 0, n), r[n] = 3, ps(t, r);
}
var CF = L({ grayscaleToRGB_: SF });
function NF(e, t, n = 0, s = 0.5) {
  let r = _(e, "image", "rotateWithOffset", "float32");
  O(r.rank === 4, () => `Error in rotateWithOffset: image must be rank 4,but got rank ${r.rank}.`);
  let a = { image: r }, i = { radians: t, fillValue: n, center: s };
  return M.runKernel(qo, a, i);
}
var TF = L({ rotateWithOffset_: NF });
function Yo(e, t, n, s, r, a) {
  s == null && (s = 0.5), r == null && (r = Number.NEGATIVE_INFINITY), a == null && (a = 0);
  let i = e.shape[0];
  return n = Math.min(n, i), O(0 <= s && s <= 1, () => `iouThreshold must be in [0, 1], but was '${s}'`), O(e.rank === 2, () => `boxes must be a 2D tensor, but was of rank '${e.rank}'`), O(e.shape[1] === 4, () => `boxes must have 4 columns, but 2nd dimension was ${e.shape[1]}`), O(t.rank === 1, () => "scores must be a 1D tensor"), O(t.shape[0] === i, () => `scores has incompatible shape with boxes. Expected ${i}, but was ${t.shape[0]}`), O(0 <= a && a <= 1, () => `softNmsSigma must be in [0, 1], but was '${a}'`), { maxOutputSize: n, iouThreshold: s, scoreThreshold: r, softNmsSigma: a };
}
function $F(e, t, n, s = 0.5, r = Number.NEGATIVE_INFINITY) {
  let a = _(e, "boxes", "nonMaxSuppression", "float32"), i = _(t, "scores", "nonMaxSuppression", "float32"), o = Yo(a, i, n, s, r);
  n = o.maxOutputSize, s = o.iouThreshold, r = o.scoreThreshold;
  let u = { maxOutputSize: n, iouThreshold: s, scoreThreshold: r };
  return M.runKernel(Co, { boxes: a, scores: i }, u);
}
var _F = L({ nonMaxSuppression_: $F });
function AF(e, t, n) {
  let s = EF(e, t, n), r = s < 0 ? -(s + 1) : s;
  e.splice(r, 0, t);
}
function EF(e, t, n) {
  return DF(e, t, n || RF);
}
function RF(e, t) {
  return e > t ? 1 : e < t ? -1 : 0;
}
function DF(e, t, n) {
  let s = 0, r = e.length, a = 0, i = false;
  for (; s < r; ) {
    a = s + (r - s >>> 1);
    let o = n(t, e[a]);
    o > 0 ? s = a + 1 : (r = a, i = !o);
  }
  return i ? s : -s - 1;
}
function RI(e, t, n, s, r) {
  return hb(e, t, n, s, r, 0);
}
function DI(e, t, n, s, r, a) {
  return hb(e, t, n, s, r, 0, false, a, true);
}
function FI(e, t, n, s, r, a) {
  return hb(e, t, n, s, r, a, true);
}
function hb(e, t, n, s, r, a, i = false, o = false, u = false) {
  let l = [];
  for (let g = 0; g < t.length; g++)
    t[g] > r && l.push({ score: t[g], boxIndex: g, suppressBeginIndex: 0 });
  l.sort(fx);
  let c = a > 0 ? -0.5 / a : 0, p = [], d = [];
  for (; p.length < n && l.length > 0; ) {
    let g = l.pop(), { score: b, boxIndex: y, suppressBeginIndex: v } = g;
    if (b < r)
      break;
    let x = false;
    for (let k = p.length - 1; k >= v; --k) {
      let T = FF(e, y, p[k]);
      if (T >= s) {
        x = true;
        break;
      }
      if (g.score = g.score * OF(s, c, T), g.score <= r)
        break;
    }
    g.suppressBeginIndex = p.length, x || (g.score === b ? (p.push(y), d.push(g.score)) : g.score > r && AF(l, g, fx));
  }
  let h = p.length, f = n - h;
  o && f > 0 && (p.push(...new Array(f).fill(0)), d.push(...new Array(f).fill(0)));
  let m = { selectedIndices: p };
  return i && (m.selectedScores = d), u && (m.validOutputs = h), m;
}
function FF(e, t, n) {
  let s = e.subarray(t * 4, t * 4 + 4), r = e.subarray(n * 4, n * 4 + 4), a = Math.min(s[0], s[2]), i = Math.min(s[1], s[3]), o = Math.max(s[0], s[2]), u = Math.max(s[1], s[3]), l = Math.min(r[0], r[2]), c = Math.min(r[1], r[3]), p = Math.max(r[0], r[2]), d = Math.max(r[1], r[3]), h = (o - a) * (u - i), f = (p - l) * (d - c);
  if (h <= 0 || f <= 0)
    return 0;
  let m = Math.max(a, l), g = Math.max(i, c), b = Math.min(o, p), y = Math.min(u, d), v = Math.max(b - m, 0) * Math.max(y - g, 0);
  return v / (h + f - v);
}
function OF(e, t, n) {
  let s = Math.exp(t * n * n);
  return n <= e ? s : 0;
}
function fx(e, t) {
  return e.score - t.score || e.score === t.score && t.boxIndex - e.boxIndex;
}
async function PF(e, t, n, s = 0.5, r = Number.NEGATIVE_INFINITY) {
  let a = _(e, "boxes", "nonMaxSuppressionAsync"), i = _(t, "scores", "nonMaxSuppressionAsync"), o = Yo(a, i, n, s, r);
  n = o.maxOutputSize, s = o.iouThreshold, r = o.scoreThreshold;
  let u = await Promise.all([a.data(), i.data()]), l = u[0], c = u[1], { selectedIndices: p } = RI(l, c, n, s, r);
  return a !== e && a.dispose(), i !== t && i.dispose(), Zt(p, "int32");
}
var zF = PF;
function MF(e, t, n, s = 0.5, r = Number.NEGATIVE_INFINITY, a = 0) {
  let i = _(e, "boxes", "nonMaxSuppression"), o = _(t, "scores", "nonMaxSuppression"), u = Yo(i, o, n, s, r, a);
  n = u.maxOutputSize, s = u.iouThreshold, r = u.scoreThreshold, a = u.softNmsSigma;
  let l = { boxes: i, scores: o }, c = { maxOutputSize: n, iouThreshold: s, scoreThreshold: r, softNmsSigma: a }, p = M.runKernel(No, l, c);
  return { selectedIndices: p[0], selectedScores: p[1] };
}
var LF = L({ nonMaxSuppressionWithScore_: MF });
async function BF(e, t, n, s = 0.5, r = Number.NEGATIVE_INFINITY, a = 0) {
  let i = _(e, "boxes", "nonMaxSuppressionAsync"), o = _(t, "scores", "nonMaxSuppressionAsync"), u = Yo(i, o, n, s, r, a);
  n = u.maxOutputSize, s = u.iouThreshold, r = u.scoreThreshold, a = u.softNmsSigma;
  let l = await Promise.all([i.data(), o.data()]), c = l[0], p = l[1], { selectedIndices: d, selectedScores: h } = FI(c, p, n, s, r, a);
  return i !== e && i.dispose(), o !== t && o.dispose(), { selectedIndices: Zt(d, "int32"), selectedScores: Zt(h) };
}
var VF = BF;
function WF(e, t, n, s = 0.5, r = Number.NEGATIVE_INFINITY, a = false) {
  let i = _(e, "boxes", "nonMaxSuppression"), o = _(t, "scores", "nonMaxSuppression"), u = Yo(i, o, n, s, r, null), l = u.maxOutputSize, c = u.iouThreshold, p = u.scoreThreshold, d = { boxes: i, scores: o }, h = { maxOutputSize: l, iouThreshold: c, scoreThreshold: p, padToMaxOutputSize: a }, f = M.runKernel(kl, d, h);
  return { selectedIndices: f[0], validOutputs: f[1] };
}
var UF = L({ nonMaxSuppressionPadded_: WF });
async function GF(e, t, n, s = 0.5, r = Number.NEGATIVE_INFINITY, a = false) {
  let i = _(e, "boxes", "nonMaxSuppressionAsync"), o = _(t, "scores", "nonMaxSuppressionAsync"), u = Yo(i, o, n, s, r, null), l = u.maxOutputSize, c = u.iouThreshold, p = u.scoreThreshold, [d, h] = await Promise.all([i.data(), o.data()]), { selectedIndices: f, validOutputs: m } = DI(d, h, l, c, p, a);
  return i !== e && i.dispose(), o !== t && o.dispose(), { selectedIndices: Zt(f, "int32"), validOutputs: we(m, "int32") };
}
var HF = GF;
function qF(e, t, n = false, s = false) {
  let r = _(e, "images", "resizeBilinear");
  O(r.rank === 3 || r.rank === 4, () => `Error in resizeBilinear: x must be rank 3 or 4, but got rank ${r.rank}.`), O(t.length === 2, () => `Error in resizeBilinear: new shape must 2D, but got shape ${t}.`), O(s === false || n === false, () => "Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false.");
  let a = r, i = false;
  r.rank === 3 && (i = true, a = G(r, [1, r.shape[0], r.shape[1], r.shape[2]]));
  let [] = t, o = { images: a }, u = { alignCorners: n, halfPixelCenters: s, size: t }, l = M.runKernel(ti, o, u);
  return i ? G(l, [l.shape[1], l.shape[2], l.shape[3]]) : l;
}
var jF = L({ resizeBilinear_: qF });
function KF(e, t, n = false, s = false) {
  let r = _(e, "images", "resizeNearestNeighbor");
  O(r.rank === 3 || r.rank === 4, () => `Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${r.rank}.`), O(t.length === 2, () => `Error in resizeNearestNeighbor: new shape must 2D, but got shape ${t}.`), O(r.dtype === "float32" || r.dtype === "int32", () => "`images` must have `int32` or `float32` as dtype"), O(s === false || n === false, () => "Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false.");
  let a = r, i = false;
  r.rank === 3 && (i = true, a = G(r, [1, r.shape[0], r.shape[1], r.shape[2]]));
  let [] = t, o = { images: a }, u = { alignCorners: n, halfPixelCenters: s, size: t }, l = M.runKernel(Cl, o, u);
  return i ? G(l, [l.shape[1], l.shape[2], l.shape[3]]) : l;
}
var XF = L({ resizeNearestNeighbor_: KF });
function YF(e, t = "binary", n = false, s = 0.5) {
  let r = _(e, "image", "threshold"), a = 0.2989, i = 0.587, o = 0.114, u = r.shape[0] * r.shape[1], l = V(Zt([s]), 255), c, p, d, h;
  if (O(r.rank === 3, () => `Error in threshold: image must be rank 3,but got rank ${r.rank}.`), O(r.shape[2] === 3 || r.shape[2] === 1, () => `Error in threshold: image color channel must be equal to 3 or 1but got ${r.shape[2]}.`), O(r.dtype === "int32" || r.dtype === "float32", () => `Error in dtype: image dtype must be int32 or float32,but got dtype ${r.dtype}.`), O(t === "otsu" || t === "binary", () => `Method must be binary or otsu, but was ${t}`), r.shape[2] === 3) {
    [c, p, d] = Bn(r, [1, 1, 1], -1);
    let g = V(c, a), b = V(p, i), y = V(d, o);
    h = ie(ie(g, b), y);
  } else
    h = e;
  if (t === "otsu") {
    let g = Qk(ce(fI(h), "int32"), fs([]), 256);
    l = QF(g, u);
  }
  let f = n ? Xo(h, l) : Wn(h, l);
  return ce(V(f, 255), "int32");
}
function QF(e, t) {
  let n = Zt([-1]), s = Zt([0]), r = Zt([0]), a, i, o, u, l, c;
  for (let p = 0; p < e.size - 1; p++) {
    a = He(e, 0, p + 1), i = He(e, p + 1), l = xe(ve(a), t), c = xe(ve(i), t);
    let d = ve(V(a, Yu(0, a.size)));
    o = xe(d, ve(a));
    let h = Pl(i.shape, a.size), f = ie(Yu(0, i.size), h), m = V(i, f);
    u = xe(ve(m), ve(i));
    let g = ge(o, u), b = ge(o, u), y = V(l, c);
    r = V(V(y, g), b);
    let v = Wn(r, s);
    s = vn(v, r, s), n = vn(v, Zt([p]), n);
  }
  return n;
}
var ZF = L({ threshold_: YF });
function JF(e, t, n = "nearest", s = "constant", r = 0, a) {
  let i = _(e, "image", "transform", "float32"), o = _(t, "transforms", "transform", "float32");
  O(i.rank === 4, () => `Error in transform: image must be rank 4,but got rank ${i.rank}.`), O(o.rank === 2 && (o.shape[0] === i.shape[0] || o.shape[0] === 1) && o.shape[1] === 8, () => "Error in transform: Input transform should be batch x 8 or 1 x 8"), O(a == null || a.length === 2, () => `Error in transform: outputShape must be [height, width] or null, but got ${a}.`);
  let u = { image: i, transforms: o }, l = { interpolation: n, fillMode: s, fillValue: r, outputShape: a };
  return M.runKernel(Uo, u, l);
}
var eO = L({ transform_: JF });
function tO(e, t, n) {
  O(t % 1 === 0, () => `bandPart(): numLower must be an integer, got ${t}.`), O(n % 1 === 0, () => `bandPart(): numUpper must be an integer, got ${n}.`);
  let s = _(e, "a", "bandPart");
  O(s.rank >= 2, () => `bandPart(): Rank must be at least 2, got ${s.rank}.`);
  let r = s.shape, [a, i] = s.shape.slice(-2);
  if (!(t <= a))
    throw new Error(`bandPart(): numLower (${t}) must not be greater than the number of rows (${a}).`);
  if (!(n <= i))
    throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${i}).`);
  t < 0 && (t = a), n < 0 && (n = i);
  let o = G(Yu(0, a, 1, "int32"), [-1, 1]), u = Yu(0, i, 1, "int32"), l = ge(o, u), c = Ds(Xo(l, we(+t, "int32")), Ko(l, we(-n, "int32"))), p = $t([a, i], s.dtype);
  return G(Jn(Fs(G(s, [-1, a, i])).map((d) => vn(c, d, p))), r);
}
var nO = L({ bandPart_: tO });
function sO(e) {
  let t;
  if (Array.isArray(e)) {
    t = false, O(e != null && e.length > 0, () => "Gram-Schmidt process: input must not be null, undefined, or empty");
    let r = e[0].shape[0];
    for (let a = 1; a < e.length; ++a)
      O(e[a].shape[0] === r, () => `Gram-Schmidt: Non-unique lengths found in the input vectors: (${e[a].shape[0]} vs. ${r})`);
  } else
    t = true, e = Bn(e, e.shape[0], 0).map((r) => mr(r, [0]));
  O(e.length <= e[0].shape[0], () => `Gram-Schmidt: Number of vectors (${e.length}) exceeds number of dimensions (${e[0].shape[0]}).`);
  let n = [], s = e;
  for (let r = 0; r < e.length; ++r)
    n.push(M.tidy(() => {
      let a = s[r];
      if (r > 0)
        for (let i = 0; i < r; ++i) {
          let o = V(ve(V(n[i], a)), n[i]);
          a = ge(a, o);
        }
      return xe(a, CI(a, "euclidean"));
    }));
  return t ? Jn(n, 0) : n;
}
var rO = L({ gramSchmidt_: sO });
function aO(e, t = false) {
  if (O(e.rank >= 2, () => `qr() requires input tensor to have a rank >= 2, but got rank ${e.rank}`), e.rank === 2)
    return mx(e, t);
  {
    let n = e.shape.slice(0, e.shape.length - 2).reduce((u, l) => u * l), s = Fs(G(e, [n, e.shape[e.shape.length - 2], e.shape[e.shape.length - 1]]), 0), r = [], a = [];
    s.forEach((u) => {
      let [l, c] = mx(u, t);
      r.push(l), a.push(c);
    });
    let i = G(Jn(r, 0), e.shape), o = G(Jn(a, 0), e.shape);
    return [i, o];
  }
}
function mx(e, t = false) {
  return M.tidy(() => {
    O(e.shape.length === 2, () => `qr2d() requires a 2D Tensor, but got a ${e.shape.length}D Tensor.`);
    let n = e.shape[0], s = e.shape[1], r = rI(n), a = lr(e), i = Ki([[1]], [1, 1]), o = lr(i), u = n >= s ? s : n;
    for (let l = 0; l < u; ++l) {
      let c = a, p = o, d = r;
      [o, a, r] = M.tidy(() => {
        let h = He(a, [l, l], [n - l, 1]), f = CI(h), m = He(a, [l, l], [1, 1]), g = vn(Wn(m, 0), Ki([[-1]]), Ki([[1]])), b = ge(m, V(g, f)), y = xe(h, b);
        y.shape[0] === 1 ? o = lr(i) : o = Ft([i, He(y, [1, 0], [y.shape[0] - 1, y.shape[1]])], 0);
        let v = kt(xe(We(g, b), f)), x = He(a, [l, 0], [n - l, s]), k = V(v, o), T = qe(o);
        if (l === 0)
          a = ge(x, We(k, We(T, x)));
        else {
          let A = ge(x, We(k, We(T, x)));
          a = Ft([He(a, [0, 0], [l, s]), A], 0);
        }
        let N = qe(k), E = He(r, [0, l], [n, r.shape[1] - l]);
        if (l === 0)
          r = ge(E, We(We(E, o), N));
        else {
          let A = ge(E, We(We(E, o), N));
          r = Ft([He(r, [0, 0], [n, l]), A], 1);
        }
        return [o, a, r];
      }), Re([c, p, d]);
    }
    return !t && n > s && (r = He(r, [0, 0], [n, s]), a = He(a, [0, 0], [s, s])), [r, a];
  });
}
var iO = L({ qr_: aO });
var oO = ((e) => (e[e.NONE = 0] = "NONE", e[e.MEAN = 1] = "MEAN", e[e.SUM = 2] = "SUM", e[e.SUM_BY_NONZERO_WEIGHTS = 3] = "SUM_BY_NONZERO_WEIGHTS", e))(oO || {});
function uO(e, t, n = 3) {
  let s = _(e, "losses", "computeWeightedLoss"), r = null;
  t != null && (r = _(t, "weights", "computeWeightedLoss"));
  let a = r == null ? s : V(s, r);
  if (n === 0)
    return a;
  if (n === 2)
    return ve(a);
  if (n === 1) {
    if (r == null)
      return St(a);
    {
      let i = s.size / r.size, o = xe(ve(a), ve(r));
      return i > 1 ? xe(o, we(i)) : o;
    }
  }
  if (n === 3) {
    if (r == null)
      return xe(ve(a), we(s.size));
    {
      let i = V(r, Mn(s.shape)), o = ce(ve(Xu(i, we(0))), "float32");
      return xe(ve(a), o);
    }
  }
  throw Error(`Unknown reduction: ${n}`);
}
var Ys = L({ computeWeightedLoss_: uO });
function lO(e, t, n, s = 3) {
  let r = _(e, "labels", "absoluteDifference"), a = _(t, "predictions", "absoluteDifference"), i = null;
  n != null && (i = _(n, "weights", "absoluteDifference")), pn(r.shape, a.shape, "Error in absoluteDifference: ");
  let o = Mt(ge(r, a));
  return Ys(o, i, s);
}
var cO = L({ absoluteDifference_: lO });
function dO(e, t, n, s, r = 3) {
  let a = _(e, "labels", "cosineDistance"), i = _(t, "predictions", "cosineDistance"), o = null;
  s != null && (o = _(s, "weights", "cosineDistance")), pn(a.shape, i.shape, "Error in cosineDistance: ");
  let u = we(1), l = ge(u, ve(V(a, i), n, true));
  return Ys(l, o, r);
}
var pO = L({ cosineDistance_: dO });
function hO(e, t, n, s = 3) {
  let r = _(e, "labels", "hingeLoss"), a = _(t, "predictions", "hingeLoss"), i = null;
  n != null && (i = _(n, "weights", "hingeLoss")), pn(r.shape, a.shape, "Error in hingeLoss: ");
  let o = we(1);
  r = ge(V(we(2), r), o);
  let u = Xs(ge(o, V(r, a)));
  return Ys(u, i, s);
}
var fO = L({ hingeLoss_: hO });
function mO(e, t, n, s = 1, r = 3) {
  let a = _(e, "labels", "huberLoss"), i = _(t, "predictions", "huberLoss"), o = null;
  n != null && (o = _(n, "weights", "huberLoss")), pn(a.shape, i.shape, "Error in huberLoss: ");
  let u = we(s), l = Mt(ge(i, a)), c = bp(l, u), p = ge(l, c), d = ie(V(we(0.5), ct(c)), V(u, p));
  return Ys(d, o, r);
}
var gO = L({ huberLoss_: mO });
function bO(e, t, n, s = 1e-7, r = 3) {
  let a = _(e, "labels", "logLoss"), i = _(t, "predictions", "logLoss"), o = null;
  n != null && (o = _(n, "weights", "logLoss")), pn(a.shape, i.shape, "Error in logLoss: ");
  let u = we(1), l = we(s), c = kt(V(a, Yn(ie(i, l)))), p = V(ge(u, a), Yn(ie(ge(u, i), l))), d = ge(c, p);
  return Ys(d, o, r);
}
var yO = L({ logLoss_: bO });
function vO(e, t, n, s = 3) {
  let r = _(e, "labels", "meanSquaredError"), a = _(t, "predictions", "meanSquaredError"), i = null;
  n != null && (i = _(n, "weights", "meanSquaredError")), pn(r.shape, a.shape, "Error in meanSquaredError: ");
  let o = wI(r, a);
  return Ys(o, i, s);
}
var xO = L({ meanSquaredError_: vO });
function wO(e, t) {
  let n = _(e, "labels", "sigmoidCrossEntropyWithLogits"), s = _(t, "logits", "sigmoidCrossEntropyWithLogits");
  pn(n.shape, s.shape, "Error in sigmoidCrossEntropyWithLogits: ");
  let r = Xs(s), a = V(s, n), i = Yg(Xn(kt(Mt(s))));
  return ie(ge(r, a), i);
}
function kO(e, t, n, s = 0, r = 3) {
  let a = _(e, "multiClassLabels", "sigmoidCrossEntropy"), i = _(t, "logits", "sigmoidCrossEntropy"), o = null;
  if (n != null && (o = _(n, "weights", "sigmoidCrossEntropy")), pn(a.shape, i.shape, "Error in sigmoidCrossEntropy: "), s > 0) {
    let l = we(s), c = we(1), p = we(0.5);
    a = ie(V(a, ge(c, l)), V(p, l));
  }
  let u = wO(a, i);
  return Ys(u, o, r);
}
var IO = L({ sigmoidCrossEntropy_: kO });
function SO(e, t, n = -1) {
  if (n === -1 && (n = t.rank - 1), n !== t.rank - 1)
    throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${t.rank} and dim was ${n}`);
  return js((r, a, i) => {
    let u = iD(a, [n], true), l = ge(ce(a, "float32"), u);
    i([r, l]);
    let c = kt(V(l, r));
    return { value: ve(c, [n]), gradFunc: (h, f) => {
      let [m, g] = f, b = da(h.shape, [n]);
      return [V(G(h, b), ge(ce(m, "float32"), Xn(g))), V(G(h, b), ge(Xn(g), ce(m, "float32")))];
    } };
  })(e, t);
}
function CO(e, t, n, s = 0, r = 3) {
  let a = _(e, "onehotLabels", "softmaxCrossEntropy"), i = _(t, "logits", "softmaxCrossEntropy"), o = null;
  if (n != null && (o = _(n, "weights", "softmaxCrossEntropy")), pn(a.shape, i.shape, "Error in softmaxCrossEntropy: "), s > 0) {
    let l = we(s), c = we(1), p = we(a.shape[1]);
    a = ie(V(a, ge(c, l)), xe(l, p));
  }
  let u = SO(a, i);
  return Ys(u, o, r);
}
var NO = L({ softmaxCrossEntropy_: CO });
function TO(e, t, n, s) {
  let r = _(e, "indices", "sparseFillEmptyRows", "int32"), a = _(t, "values", "sparseFillEmptyRows"), i = _(n, "denseShape", "sparseFillEmptyRows", "int32"), o = _(s, "defaultValue", "sparseFillEmptyRows", a.dtype);
  if (r.rank !== 2)
    throw new Error(`Indices should be Tensor2D but received shape
        ${r.shape}`);
  if (a.rank !== 1)
    throw new Error(`Values should be Tensor1D but received shape ${a.shape}`);
  if (i.rank !== 1)
    throw new Error(`Dense shape should be Tensor1D but received shape ${i.shape}`);
  if (o.rank !== 0)
    throw new Error(`Default value should be a scalar but received shape ${o.shape}`);
  let u = { indices: r, values: a, denseShape: i, defaultValue: o }, l = M.runKernel(sp, u);
  return { outputIndices: l[0], outputValues: l[1], emptyRowIndicator: l[2], reverseIndexMap: l[3] };
}
var $O = L({ sparseFillEmptyRows_: TO });
function _O(e, t, n) {
  let s = _(e, "inputIndices", "sparseReshape", "int32"), r = _(t, "inputShape", "sparseReshape", "int32"), a = _(n, "newShape", "sparseReshape", "int32");
  if (s.rank !== 2)
    throw new Error(`Input indices should be Tensor2D but received shape
        ${s.shape}`);
  if (r.rank !== 1)
    throw new Error(`Input shape should be Tensor1D but received shape ${r.shape}`);
  if (a.rank !== 1)
    throw new Error(`New shape should be Tensor1D but received shape ${a.shape}`);
  let i = { inputIndices: s, inputShape: r, newShape: a }, o = M.runKernel(_l, i);
  return { outputIndices: o[0], outputShape: o[1] };
}
var AO = L({ sparseReshape_: _O });
function EO(e, t, n) {
  let s = _(e, "data", "sparseSegmentMean"), r = _(t, "indices", "sparseSegmentMean", "int32"), a = _(n, "segmentIds", "sparseSegmentMean", "int32");
  if (s.rank < 1)
    throw new Error("Data should be at least 1 dimensional but received scalar");
  if (r.rank !== 1)
    throw new Error(`Indices should be Tensor1D but received shape
          ${r.shape}`);
  if (a.rank !== 1)
    throw new Error(`Segment ids should be Tensor1D but received shape
          ${a.shape}`);
  let i = { data: s, indices: r, segmentIds: a };
  return M.runKernel(rp, i);
}
var RO = L({ sparseSegmentMean_: EO });
function DO(e, t, n) {
  let s = _(e, "data", "sparseSegmentSum"), r = _(t, "indices", "sparseSegmentSum", "int32"), a = _(n, "segmentIds", "sparseSegmentSum", "int32");
  if (s.rank < 1)
    throw new Error("Data should be at least 1 dimensional but received scalar");
  if (r.rank !== 1)
    throw new Error(`Indices should be Tensor1D but received shape
         ${r.shape}`);
  if (a.rank !== 1)
    throw new Error(`Segment ids should be Tensor1D but received shape
         ${a.shape}`);
  let i = { data: s, indices: r, segmentIds: a };
  return M.runKernel(ap, i);
}
var FO = L({ sparseSegmentSum_: DO });
function OO(e, t, n, s, r, a, i, o) {
  let u = _(e, "data", "stringNGrams", "string");
  if (u.dtype !== "string")
    throw new Error("Data must be of datatype string");
  if (u.shape.length !== 1)
    throw new Error(`Data must be a vector, saw: ${u.shape}`);
  let l = _(t, "dataSplits", "stringNGrams");
  if (l.dtype !== "int32")
    throw new Error("Data splits must be of datatype int32");
  let c = { separator: n, nGramWidths: s, leftPad: r, rightPad: a, padWidth: i, preserveShortSequences: o }, p = { data: u, dataSplits: l }, d = M.runKernel(op, p, c);
  return { nGrams: d[0], nGramsSplits: d[1] };
}
var PO = L({ stringNGrams_: OO });
function zO(e, t, n = true) {
  let s = _(e, "input", "stringSplit", "string"), r = _(t, "delimiter", "stringSplit", "string");
  if (s.rank !== 1)
    throw new Error(`Input should be Tensor1D but received shape ${s.shape}`);
  if (r.rank !== 0)
    throw new Error(`Delimiter should be a scalar but received shape ${r.shape}`);
  let a = { skipEmpty: n }, i = { input: s, delimiter: r }, o = M.runKernel($g, i, a);
  return { indices: o[0], values: o[1], shape: o[2] };
}
var MO = L({ stringSplit_: zO });
function LO(e, t) {
  let n = _(e, "input", "stringToHashBucketFast", "string"), s = { numBuckets: t };
  if (t <= 0)
    throw new Error("Number of buckets must be at least 1");
  let r = { input: n };
  return M.runKernel(_g, r, s);
}
var BO = L({ stringToHashBucketFast_: LO });
var Ipe = { fft: lb, ifft: Id, rfft: cb, irfft: xI };
var Spe = { hammingWindow: mF, hannWindow: AI, frame: EI, stft: vF };
var qn = { flipLeftRight: IF, grayscaleToRGB: CF, resizeNearestNeighbor: XF, resizeBilinear: jF, rotateWithOffset: TF, cropAndResize: wF, nonMaxSuppression: _F, nonMaxSuppressionAsync: zF, nonMaxSuppressionWithScore: LF, nonMaxSuppressionWithScoreAsync: VF, nonMaxSuppressionPadded: UF, nonMaxSuppressionPaddedAsync: HF, threshold: ZF, transform: eO };
var VO = { bandPart: nO, gramSchmidt: rO, qr: iO };
var Cpe = { absoluteDifference: cO, computeWeightedLoss: Ys, cosineDistance: pO, hingeLoss: fO, huberLoss: gO, logLoss: yO, meanSquaredError: xO, sigmoidCrossEntropy: IO, softmaxCrossEntropy: NO };
var Wc = { sparseFillEmptyRows: $O, sparseReshape: AO, sparseSegmentMean: RO, sparseSegmentSum: FO };
var Mf = { stringNGrams: PO, stringSplit: MO, stringToHashBucketFast: BO };
var _r = class extends Vk {
  minimize(e, t = false, n) {
    let { value: s, grads: r } = this.computeGradients(e, n);
    if (n != null) {
      let a = n.map((i) => ({ name: i.name, tensor: r[i.name] }));
      this.applyGradients(a);
    } else
      this.applyGradients(r);
    return Re(r), t ? s : (s.dispose(), null);
  }
  get iterations() {
    return this.iterations_ == null && (this.iterations_ = 0), this.iterations_;
  }
  incrementIterations() {
    this.iterations_ = this.iterations + 1;
  }
  computeGradients(e, t) {
    return XR(e, t);
  }
  dispose() {
    this.iterations_ != null && Re(this.iterations_);
  }
  async saveIterations() {
    return this.iterations_ == null && (this.iterations_ = 0), { name: "iter", tensor: we(this.iterations_, "int32") };
  }
  async getWeights() {
    throw new Error("getWeights() is not implemented for this optimizer yet.");
  }
  async setWeights(e) {
    throw new Error(`setWeights() is not implemented for this optimizer class ${this.getClassName()}`);
  }
  async extractIterations(e) {
    return this.iterations_ = (await e[0].tensor.data())[0], e.slice(1);
  }
};
Object.defineProperty(_r, Symbol.hasInstance, { value: (e) => e.minimize != null && e.computeGradients != null && e.applyGradients != null });
var fb = class extends _r {
  constructor(e, t, n = null) {
    super(), this.learningRate = e, this.rho = t, this.epsilon = n, this.accumulatedGrads = [], this.accumulatedUpdates = [], n == null && (this.epsilon = M.backend.epsilon());
  }
  applyGradients(e) {
    (Array.isArray(e) ? e.map((n) => n.name) : Object.keys(e)).forEach((n, s) => {
      let r = M.registeredVariables[n], a = false;
      this.accumulatedGrads[s] == null && (this.accumulatedGrads[s] = { originalName: `${n}/accum_grad`, variable: j(() => je(r).variable(a)) }), this.accumulatedUpdates[s] == null && (this.accumulatedUpdates[s] = { originalName: `${n}/accum_var`, variable: j(() => je(r).variable(a)) });
      let i = Array.isArray(e) ? e[s].tensor : e[n];
      if (i == null)
        return;
      let o = this.accumulatedGrads[s].variable, u = this.accumulatedUpdates[s].variable;
      j(() => {
        let l = ie(V(o, this.rho), V(ct(i), 1 - this.rho)), c = V(xe(dn(ie(u, this.epsilon)), dn(ie(o, this.epsilon))), i), p = ie(V(u, this.rho), V(ct(c), 1 - this.rho));
        o.assign(l), u.assign(p);
        let d = ie(V(c, -this.learningRate), r);
        r.assign(d);
      });
    }), this.incrementIterations();
  }
  dispose() {
    this.accumulatedUpdates != null && (Re(this.accumulatedGrads.map((e) => e.variable)), Re(this.accumulatedUpdates.map((e) => e.variable)));
  }
  async getWeights() {
    let e = [...this.accumulatedGrads, ...this.accumulatedUpdates];
    return [await this.saveIterations()].concat(e.map((t) => ({ name: t.originalName, tensor: t.variable })));
  }
  async setWeights(e) {
    e = await this.extractIterations(e);
    let t = e.length / 2, n = false;
    this.accumulatedGrads = e.slice(0, t).map((s) => ({ originalName: s.name, variable: s.tensor.variable(n) })), this.accumulatedUpdates = e.slice(t, t * 2).map((s) => ({ originalName: s.name, variable: s.tensor.variable(n) }));
  }
  getConfig() {
    return { learningRate: this.learningRate, rho: this.rho, epsilon: this.epsilon };
  }
  static fromConfig(e, t) {
    return new e(t.learningRate, t.rho, t.epsilon);
  }
};
fb.className = "Adadelta";
Tr(fb);
var mb = class extends _r {
  constructor(e, t = 0.1) {
    super(), this.learningRate = e, this.initialAccumulatorValue = t, this.accumulatedGrads = [];
  }
  applyGradients(e) {
    (Array.isArray(e) ? e.map((n) => n.name) : Object.keys(e)).forEach((n, s) => {
      let r = M.registeredVariables[n];
      this.accumulatedGrads[s] == null && (this.accumulatedGrads[s] = { originalName: `${n}/accumulator`, variable: j(() => Pl(r.shape, this.initialAccumulatorValue).variable(false)) });
      let a = Array.isArray(e) ? e[s].tensor : e[n];
      if (a == null)
        return;
      let i = this.accumulatedGrads[s].variable;
      j(() => {
        let o = ie(i, ct(a));
        i.assign(o);
        let u = ie(V(xe(a, dn(ie(o, M.backend.epsilon()))), -this.learningRate), r);
        r.assign(u);
      });
    }), this.incrementIterations();
  }
  dispose() {
    this.accumulatedGrads != null && Re(this.accumulatedGrads.map((e) => e.variable));
  }
  async getWeights() {
    return [await this.saveIterations()].concat(this.accumulatedGrads.map((e) => ({ name: e.originalName, tensor: e.variable })));
  }
  async setWeights(e) {
    e = await this.extractIterations(e);
    let t = false;
    this.accumulatedGrads = e.map((n) => ({ originalName: n.name, variable: n.tensor.variable(t) }));
  }
  getConfig() {
    return { learningRate: this.learningRate, initialAccumulatorValue: this.initialAccumulatorValue };
  }
  static fromConfig(e, t) {
    return new e(t.learningRate, t.initialAccumulatorValue);
  }
};
mb.className = "Adagrad";
Tr(mb);
var gb = class extends _r {
  constructor(e, t, n, s = null) {
    super(), this.learningRate = e, this.beta1 = t, this.beta2 = n, this.epsilon = s, this.accumulatedFirstMoment = [], this.accumulatedSecondMoment = [], j(() => {
      this.accBeta1 = we(t).variable(), this.accBeta2 = we(n).variable();
    }), s == null && (this.epsilon = M.backend.epsilon());
  }
  applyGradients(e) {
    let t = Array.isArray(e) ? e.map((n) => n.name) : Object.keys(e);
    j(() => {
      let n = ge(1, this.accBeta1), s = ge(1, this.accBeta2);
      t.forEach((r, a) => {
        let i = M.registeredVariables[r], o = false;
        this.accumulatedFirstMoment[a] == null && (this.accumulatedFirstMoment[a] = { originalName: `${r}/m`, variable: j(() => je(i).variable(o)) }), this.accumulatedSecondMoment[a] == null && (this.accumulatedSecondMoment[a] = { originalName: `${r}/v`, variable: j(() => je(i).variable(o)) });
        let u = Array.isArray(e) ? e[a].tensor : e[r];
        if (u == null)
          return;
        let l = this.accumulatedFirstMoment[a].variable, c = this.accumulatedSecondMoment[a].variable, p = ie(V(l, this.beta1), V(u, 1 - this.beta1)), d = ie(V(c, this.beta2), V(ct(u), 1 - this.beta2)), h = xe(p, n), f = xe(d, s);
        l.assign(p), c.assign(d);
        let m = ie(V(xe(h, ie(dn(f), this.epsilon)), -this.learningRate), i);
        i.assign(m);
      }), this.accBeta1.assign(V(this.accBeta1, this.beta1)), this.accBeta2.assign(V(this.accBeta2, this.beta2));
    }), this.incrementIterations();
  }
  dispose() {
    this.accBeta1.dispose(), this.accBeta2.dispose(), this.accumulatedFirstMoment != null && Re(this.accumulatedFirstMoment.map((e) => e.variable)), this.accumulatedSecondMoment != null && Re(this.accumulatedSecondMoment.map((e) => e.variable));
  }
  async getWeights() {
    let e = [...this.accumulatedFirstMoment, ...this.accumulatedSecondMoment];
    return [await this.saveIterations()].concat(e.map((t) => ({ name: t.originalName, tensor: t.variable })));
  }
  async setWeights(e) {
    e = await this.extractIterations(e), j(() => {
      this.accBeta1.assign(pa(this.beta1, this.iterations_ + 1)), this.accBeta2.assign(pa(this.beta2, this.iterations_ + 1));
    });
    let t = e.length / 2, n = false;
    this.accumulatedFirstMoment = e.slice(0, t).map((s) => ({ originalName: s.name, variable: s.tensor.variable(n) })), this.accumulatedSecondMoment = e.slice(t, t * 2).map((s) => ({ originalName: s.name, variable: s.tensor.variable(n) }));
  }
  getConfig() {
    return { learningRate: this.learningRate, beta1: this.beta1, beta2: this.beta2, epsilon: this.epsilon };
  }
  static fromConfig(e, t) {
    return new e(t.learningRate, t.beta1, t.beta2, t.epsilon);
  }
};
gb.className = "Adam";
Tr(gb);
var bb = class extends _r {
  constructor(e, t, n, s = null, r = 0) {
    super(), this.learningRate = e, this.beta1 = t, this.beta2 = n, this.epsilon = s, this.decay = r, this.accumulatedFirstMoment = [], this.accumulatedWeightedInfNorm = [], j(() => {
      this.iteration = we(0).variable(), this.accBeta1 = we(t).variable();
    }), s == null && (this.epsilon = M.backend.epsilon());
  }
  applyGradients(e) {
    let t = Array.isArray(e) ? e.map((n) => n.name) : Object.keys(e);
    j(() => {
      let n = ge(1, this.accBeta1), s = xe(-this.learningRate, ie(V(this.iteration, this.decay), 1));
      t.forEach((r, a) => {
        let i = M.registeredVariables[r], o = false;
        this.accumulatedFirstMoment[a] == null && (this.accumulatedFirstMoment[a] = { originalName: `${r}/m`, variable: je(i).variable(o) }), this.accumulatedWeightedInfNorm[a] == null && (this.accumulatedWeightedInfNorm[a] = { originalName: `${r}/v`, variable: je(i).variable(o) });
        let u = Array.isArray(e) ? e[a].tensor : e[r];
        if (u == null)
          return;
        let l = this.accumulatedFirstMoment[a].variable, c = this.accumulatedWeightedInfNorm[a].variable, p = ie(V(l, this.beta1), V(u, 1 - this.beta1)), d = V(c, this.beta2), h = Mt(u), f = $r(d, h);
        l.assign(p), c.assign(f);
        let m = ie(V(xe(s, n), xe(p, ie(f, this.epsilon))), i);
        i.assign(m);
      }), this.iteration.assign(ie(this.iteration, 1)), this.accBeta1.assign(V(this.accBeta1, this.beta1));
    }), this.incrementIterations();
  }
  dispose() {
    this.accBeta1.dispose(), this.iteration.dispose(), this.accumulatedFirstMoment != null && Re(this.accumulatedFirstMoment.map((e) => e.variable)), this.accumulatedWeightedInfNorm != null && Re(this.accumulatedWeightedInfNorm.map((e) => e.variable));
  }
  async getWeights() {
    throw new Error("getWeights() is not implemented for Adamax yet.");
  }
  async setWeights(e) {
    throw new Error("setWeights() is not implemented for Adamax yet.");
  }
  getConfig() {
    return { learningRate: this.learningRate, beta1: this.beta1, beta2: this.beta2, epsilon: this.epsilon, decay: this.decay };
  }
  static fromConfig(e, t) {
    return new e(t.learningRate, t.beta1, t.beta2, t.epsilon, t.decay);
  }
};
bb.className = "Adamax";
Tr(bb);
var Ip = class extends _r {
  constructor(e) {
    super(), this.learningRate = e, this.setLearningRate(e);
  }
  applyGradients(e) {
    (Array.isArray(e) ? e.map((n) => n.name) : Object.keys(e)).forEach((n, s) => {
      let r = Array.isArray(e) ? e[s].tensor : e[n];
      if (r == null)
        return;
      let a = M.registeredVariables[n];
      j(() => {
        let i = ie(V(this.c, r), a);
        a.assign(i);
      });
    }), this.incrementIterations();
  }
  setLearningRate(e) {
    this.learningRate = e, this.c != null && this.c.dispose(), this.c = Ht(we(-e));
  }
  dispose() {
    this.c.dispose();
  }
  async getWeights() {
    return [await this.saveIterations()];
  }
  async setWeights(e) {
    if (e = await this.extractIterations(e), e.length !== 0)
      throw new Error("SGD optimizer does not have settable weights.");
  }
  getConfig() {
    return { learningRate: this.learningRate };
  }
  static fromConfig(e, t) {
    return new e(t.learningRate);
  }
};
Ip.className = "SGD";
Tr(Ip);
var yb = class extends Ip {
  constructor(e, t, n = false) {
    super(e), this.learningRate = e, this.momentum = t, this.useNesterov = n, this.accumulations = [], this.m = we(this.momentum);
  }
  applyGradients(e) {
    (Array.isArray(e) ? e.map((n) => n.name) : Object.keys(e)).forEach((n, s) => {
      let r = M.registeredVariables[n];
      this.accumulations[s] == null && (this.accumulations[s] = { originalName: `${n}/momentum`, variable: j(() => je(r).variable(false)) });
      let a = this.accumulations[s].variable, i = Array.isArray(e) ? e[s].tensor : e[n];
      i != null && j(() => {
        let o, u = ie(V(this.m, a), i);
        this.useNesterov ? o = ie(V(this.c, ie(i, V(u, this.m))), r) : o = ie(V(this.c, u), r), a.assign(u), r.assign(o);
      });
    }), this.incrementIterations();
  }
  dispose() {
    this.m.dispose(), this.accumulations != null && Re(this.accumulations.map((e) => e.variable));
  }
  setMomentum(e) {
    this.momentum = e;
  }
  async getWeights() {
    return [await this.saveIterations()].concat(this.accumulations.map((e) => ({ name: e.originalName, tensor: e.variable })));
  }
  async setWeights(e) {
    e = await this.extractIterations(e);
    let t = false;
    this.accumulations = e.map((n) => ({ originalName: n.name, variable: n.tensor.variable(t) }));
  }
  getConfig() {
    return { learningRate: this.learningRate, momentum: this.momentum, useNesterov: this.useNesterov };
  }
  static fromConfig(e, t) {
    return new e(t.learningRate, t.momentum, t.useNesterov);
  }
};
yb.className = "Momentum";
Tr(yb);
var vb = class extends _r {
  constructor(e, t = 0.9, n = 0, s = null, r = false) {
    if (super(), this.learningRate = e, this.decay = t, this.momentum = n, this.epsilon = s, this.accumulatedMeanSquares = [], this.accumulatedMoments = [], this.accumulatedMeanGrads = [], this.centered = r, s == null && (this.epsilon = M.backend.epsilon()), e == null)
      throw new Error("learningRate for RMSPropOptimizer must be defined.");
  }
  applyGradients(e) {
    (Array.isArray(e) ? e.map((n) => n.name) : Object.keys(e)).forEach((n, s) => {
      let r = M.registeredVariables[n], a = false;
      this.accumulatedMeanSquares[s] == null && (this.accumulatedMeanSquares[s] = { originalName: `${n}/rms`, variable: j(() => je(r).variable(a)) }), this.accumulatedMoments[s] == null && (this.accumulatedMoments[s] = { originalName: `${n}/momentum`, variable: j(() => je(r).variable(a)) }), this.accumulatedMeanGrads[s] == null && this.centered && (this.accumulatedMeanGrads[s] = { originalName: `${n}/mg`, variable: j(() => je(r).variable(a)) });
      let i = Array.isArray(e) ? e[s].tensor : e[n];
      if (i == null)
        return;
      let o = this.accumulatedMeanSquares[s].variable, u = this.accumulatedMoments[s].variable;
      j(() => {
        let l = ie(V(o, this.decay), V(ct(i), 1 - this.decay));
        if (this.centered) {
          let c = this.accumulatedMeanGrads[s].variable, p = ie(V(c, this.decay), V(i, 1 - this.decay)), d = xe(V(i, this.learningRate), dn(ge(l, ie(ct(p), this.epsilon)))), h = ie(V(u, this.momentum), d);
          o.assign(l), c.assign(p), u.assign(h);
          let f = ge(r, h);
          r.assign(f);
        } else {
          let c = ie(V(o, this.decay), V(ct(i), 1 - this.decay)), p = ie(V(u, this.momentum), xe(V(i, this.learningRate), dn(ie(c, this.epsilon))));
          o.assign(c), u.assign(p);
          let d = ge(r, p);
          r.assign(d);
        }
      });
    }), this.incrementIterations();
  }
  dispose() {
    this.accumulatedMeanSquares != null && Re(this.accumulatedMeanSquares.map((e) => e.variable)), this.accumulatedMeanGrads != null && this.centered && Re(this.accumulatedMeanGrads.map((e) => e.variable)), this.accumulatedMoments != null && Re(this.accumulatedMoments.map((e) => e.variable));
  }
  async getWeights() {
    let e = [...this.accumulatedMeanSquares, ...this.accumulatedMoments];
    return this.centered && e.push(...this.accumulatedMeanGrads), [await this.saveIterations()].concat(e.map((t) => ({ name: t.originalName, tensor: t.variable })));
  }
  async setWeights(e) {
    e = await this.extractIterations(e);
    let t = this.centered ? e.length / 3 : e.length / 2, n = false;
    this.accumulatedMeanSquares = e.slice(0, t).map((s) => ({ originalName: s.name, variable: s.tensor.variable(n) })), this.accumulatedMoments = e.slice(t, t * 2).map((s) => ({ originalName: s.name, variable: s.tensor.variable(n) })), this.centered && (this.accumulatedMeanGrads = e.slice(t * 2, t * 3).map((s) => ({ originalName: s.name, variable: s.tensor.variable(n) })));
  }
  getConfig() {
    return { learningRate: this.learningRate, decay: this.decay, momentum: this.momentum, epsilon: this.epsilon, centered: this.centered };
  }
  static fromConfig(e, t) {
    return new e(t.learningRate, t.decay, t.momentum, t.epsilon, t.centered);
  }
};
vb.className = "RMSProp";
Tr(vb);
var Wr = class {
  static sgd(e) {
    return new Ip(e);
  }
  static momentum(e, t, n = false) {
    return new yb(e, t, n);
  }
  static rmsprop(e, t = 0.9, n = 0, s = null, r = false) {
    return new vb(e, t, n, s, r);
  }
  static adam(e = 1e-3, t = 0.9, n = 0.999, s = null) {
    return new gb(e, t, n, s);
  }
  static adadelta(e = 1e-3, t = 0.95, n = null) {
    return new fb(e, t, n);
  }
  static adamax(e = 2e-3, t = 0.9, n = 0.999, s = null, r = 0) {
    return new bb(e, t, n, s, r);
  }
  static adagrad(e, t = 0.1) {
    return new mb(e, t);
  }
};
var Pi = { sgd: Wr.sgd, momentum: Wr.momentum, adadelta: Wr.adadelta, adagrad: Wr.adagrad, rmsprop: Wr.rmsprop, adamax: Wr.adamax, adam: Wr.adam };
var WO = (() => typeof requestAnimationFrame != "undefined" ? requestAnimationFrame : typeof setImmediate != "undefined" ? setImmediate : (e) => e())();
function OI() {
  return new Promise((e) => WO(() => e()));
}
var S = {};
Ae(S, { ERF_A1: () => JO, ERF_A2: () => eP, ERF_A3: () => tP, ERF_A4: () => nP, ERF_A5: () => sP, ERF_P: () => ZO, PARALLELIZE_THRESHOLD: () => xb, SELU_SCALE: () => zI, SELU_SCALEALPHA: () => PI, applyActivation: () => wp, assertAndGetBroadcastShape: () => ot, assertAxesAreInnerMostDims: () => sD, assertParamsConsistent: () => UO, assignToTypedArray: () => lP, axesAreInnerMostDims: () => Qg, calculateShapes: () => Ek, checkEinsumDimSizes: () => mP, checkPadOnDimRoundingMode: () => hn, combineLocations: () => oI, complexWithEvenIndex: () => iP, complexWithOddIndex: () => oP, computeConv2DInfo: () => Ol, computeConv3DInfo: () => Kk, computeDefaultPad: () => Ug, computeDilation2DInfo: () => cE, computeOptimalWindowSize: () => HO, computeOutAndReduceShapes: () => uI, computeOutShape: () => GO, computePool2DInfo: () => jk, computePool3DInfo: () => dE, convertConv2DDataFormat: () => Xk, decodeEinsumEquation: () => hP, eitherStridesOrDilationsAreOne: () => Ps, expandShapeToKeepDim: () => da, exponent: () => dP, exponents: () => cP, fromStringArrayToUint8: () => PP, fromUint8ToStringArray: () => OP, getAxesPermutation: () => lI, getBroadcastDims: () => Ck, getComplexWithIndex: () => uP, getEinsumComputePath: () => gP, getEinsumPermutation: () => fP, getFusedBiasGradient: () => xp, getFusedDyActivation: () => vp, getImageCenter: () => qO, getInnerMostAxes: () => rD, getPermuted: () => KO, getReductionAxes: () => _t, getReshaped: () => jO, getReshapedPermuted: () => XO, getSliceBeginCoords: () => YO, getSliceSize: () => QO, getSparseFillEmptyRowsIndicesDenseShapeMismatch: () => xP, getSparseFillEmptyRowsNegativeIndexErrorMessage: () => wP, getSparseFillEmptyRowsOutOfRangeIndexErrorMessage: () => kP, getSparseReshapeEmptyTensorZeroOutputDimErrorMessage: () => CP, getSparseReshapeInputOutputMismatchErrorMessage: () => TP, getSparseReshapeInputOutputMultipleErrorMessage: () => NP, getSparseReshapeMultipleNegativeOneOutputDimErrorMessage: () => IP, getSparseReshapeNegativeOutputDimErrorMessage: () => SP, getSparseSegmentReductionIndicesOutOfRangeErrorMessage: () => EP, getSparseSegmentReductionNegativeSegmentIdsErrorMessage: () => $P, getSparseSegmentReductionNonIncreasingSegmentIdsErrorMessage: () => _P, getSparseSegmentReductionSegmentIdOutOfRangeErrorMessage: () => AP, getUndoAxesPermutation: () => Zg, isIdentityPermutation: () => bP, log: () => R$, mergeRealAndImagArrays: () => rP, prepareAndValidate: () => _k, prepareSplitSize: () => vP, segment_util: () => MI, shouldFuse: () => kp, slice_util: () => wt, splitRealAndImagArrays: () => aP, tupleValuesAreOne: () => fr, upcastType: () => cn, validateInput: () => Bg, validateUpdateShape: () => Lg, warn: () => ar });
function UO(e, t) {
  let n = e[0].length;
  e.forEach((r, a) => {
    O(r.length === n, () => `Error in concat${n}D: rank of tensors[${a}] must be the same as the rank of the rest (${n})`);
  }), O(t >= 0 && t < n, () => `Error in concat${n}D: axis must be between 0 and ${n - 1}.`);
  let s = e[0];
  e.forEach((r, a) => {
    for (let i = 0; i < n; i++)
      O(i === t || r[i] === s[i], () => `Error in concat${n}D: Shape of tensors[${a}] (${r}) does not match the shape of the rest (${s}) along the non-concatenated axis ${a}.`);
  });
}
function GO(e, t) {
  let n = e[0].slice();
  for (let s = 1; s < e.length; s++)
    n[t] += e[s][t];
  return n;
}
var xb = 30;
function HO(e) {
  return e <= xb ? e : hd(e, Math.floor(Math.sqrt(e)));
}
function qO(e, t, n) {
  let s = n * (typeof e == "number" ? e : e[0]), r = t * (typeof e == "number" ? e : e[1]);
  return [s, r];
}
function jO(e, t, n, s = true) {
  let r = [];
  if (s)
    r = r.concat(t.slice(0)), r.push(e[0] / n), r = r.concat(e.slice(1));
  else {
    r = r.concat(e[0]);
    let a = t.length;
    for (let i = 0; i < a; ++i)
      r = r.concat([e[i + 1] / t[i], t[i]]);
    r = r.concat(e.slice(a + 1));
  }
  return r;
}
function KO(e, t, n = true) {
  let s = [];
  if (n) {
    s.push(t);
    for (let r = t + 1; r < e; ++r)
      r <= 2 * t ? (s.push(r), s.push(r - (t + 1))) : s.push(r);
  } else {
    let r = [], a = [];
    for (let i = 1; i < e; ++i)
      i >= t * 2 + 1 || i % 2 === 1 ? a.push(i) : r.push(i);
    s.push(...r), s.push(0), s.push(...a);
  }
  return s;
}
function XO(e, t, n, s = true) {
  let r = [];
  s ? r.push(e[0] / n) : r.push(e[0] * n);
  for (let a = 1; a < e.length; ++a)
    a <= t.length ? s ? r.push(t[a - 1] * e[a]) : r.push(e[a] / t[a - 1]) : r.push(e[a]);
  return r;
}
function YO(e, t) {
  let n = [0];
  for (let s = 0; s < t; ++s)
    n.push(e[s][0]);
  return n;
}
function QO(e, t, n) {
  let s = e.slice(0, 1);
  for (let r = 0; r < n; ++r)
    s.push(e[r + 1] - t[r][0] - t[r][1]);
  return s;
}
var PI = 1.7580993408473768;
var zI = 1.0507009873554805;
var ZO = 0.3275911;
var JO = 0.254829592;
var eP = -0.284496736;
var tP = 1.421413741;
var nP = -1.453152027;
var sP = 1.061405429;
function rP(e, t) {
  if (e.length !== t.length)
    throw new Error(`Cannot merge real and imag arrays of different lengths. real:${e.length}, imag: ${t.length}.`);
  let n = new Float32Array(e.length * 2);
  for (let s = 0; s < n.length; s += 2)
    n[s] = e[s / 2], n[s + 1] = t[s / 2];
  return n;
}
function aP(e) {
  let t = new Float32Array(e.length / 2), n = new Float32Array(e.length / 2);
  for (let s = 0; s < e.length; s += 2)
    t[s / 2] = e[s], n[s / 2] = e[s + 1];
  return { real: t, imag: n };
}
function iP(e) {
  let t = Math.ceil(e.length / 4), n = new Float32Array(t), s = new Float32Array(t);
  for (let r = 0; r < e.length; r += 4)
    n[Math.floor(r / 4)] = e[r], s[Math.floor(r / 4)] = e[r + 1];
  return { real: n, imag: s };
}
function oP(e) {
  let t = Math.floor(e.length / 4), n = new Float32Array(t), s = new Float32Array(t);
  for (let r = 2; r < e.length; r += 4)
    n[Math.floor(r / 4)] = e[r], s[Math.floor(r / 4)] = e[r + 1];
  return { real: n, imag: s };
}
function uP(e, t) {
  let n = e[t * 2], s = e[t * 2 + 1];
  return { real: n, imag: s };
}
function lP(e, t, n, s) {
  e[s * 2] = t, e[s * 2 + 1] = n;
}
function cP(e, t) {
  let n = new Float32Array(e / 2), s = new Float32Array(e / 2);
  for (let r = 0; r < Math.ceil(e / 2); r++) {
    let a = (t ? 2 : -2) * Math.PI * (r / e);
    n[r] = Math.cos(a), s[r] = Math.sin(a);
  }
  return { real: n, imag: s };
}
function dP(e, t, n) {
  let s = (n ? 2 : -2) * Math.PI * (e / t), r = Math.cos(s), a = Math.sin(s);
  return { real: r, imag: a };
}
var Lf = "->";
var pP = /->/g;
var gx = ",";
var bx = "...";
function hP(e, t) {
  e = e.replace(/\s/g, "");
  let n = (e.length - e.replace(pP, "").length) / Lf.length;
  if (n < 1)
    throw new Error("Equations without an arrow are not supported.");
  if (n > 1)
    throw new Error(`Equation must contain exactly one arrow ("${Lf}").`);
  let [s, r] = e.split(Lf);
  O(s.indexOf(bx) === -1, () => `The ellipsis notation ("${bx}") is not supported yet.`);
  let a = s.split(gx), i = a.length;
  if (t !== i)
    throw new Error(`Expected ${i} input tensors, received ${t}`);
  if (i > 2)
    throw new Error("Support for more than 2 input tensors is not implemented yet.");
  let o = [];
  for (let d = 0; d < r.length; ++d) {
    let h = r[d];
    if (!a.some((f) => f.indexOf(h) !== -1))
      throw new Error(`Output subscripts contain the label ${h} not present in the input subscripts.`);
    o.indexOf(h) === -1 && o.push(h);
  }
  for (let d = 0; d < s.length; ++d) {
    let h = s[d];
    o.indexOf(h) === -1 && h !== gx && o.push(h);
  }
  let u = new Array(a.length);
  for (let d = 0; d < i; ++d) {
    if (new Set(a[d].split("")).size !== a[d].length)
      throw new Error(`Found duplicate axes in input component ${a[d]}. Support for duplicate axes in input is not implemented yet.`);
    u[d] = [];
    for (let h = 0; h < a[d].length; ++h)
      u[d].push(o.indexOf(a[d][h]));
  }
  let l = o.length, c = r.length, p = [];
  for (let d = c; d < l; ++d)
    p.push(d);
  return { allDims: o, summedDims: p, idDims: u };
}
function fP(e, t) {
  let n = new Array(e);
  n.fill(-1);
  for (let r = 0; r < t.length; ++r)
    n[t[r]] = r;
  let s = [];
  for (let r = 0; r < e; ++r)
    n[r] === -1 && s.push(r);
  return n = n.filter((r) => r !== -1), { permutationIndices: n, expandDims: s };
}
function mP(e, t, n) {
  let s = new Array(e);
  for (let r = 0; r < n.length; ++r) {
    let a = n[r].shape;
    for (let i = 0; i < t[r].length; ++i)
      s[t[r][i]] === void 0 ? s[t[r][i]] = a[i] : O(s[t[r][i]] === a[i], () => `Expected dimension ${s[t[r][i]]} at axis ${i} of input shaped ${JSON.stringify(a)}, but got dimension ${a[i]}`);
  }
}
function gP(e, t) {
  let n = e, s = [], r = 0;
  e.length === 0 && n.push(-1), r = e.length + 1;
  for (let i = 0; i < r; ++i)
    s.push([]);
  let a = [];
  for (let i = 0; i < n.length; ++i) {
    let o = n[i], u = yP(t, o);
    for (let l of u)
      a.indexOf(l) === -1 && (s[i].push(l), a.push(l));
  }
  return { path: n, steps: s };
}
function bP(e) {
  return e.every((t, n) => t === n);
}
function yP(e, t) {
  let n = [];
  for (let s = 0; s < e.length; ++s)
    (e[s].length === 0 || e[s].indexOf(t) !== -1 || t === -1) && n.push(s);
  return n;
}
function vP(e, t, n = 0) {
  let s = [];
  if (typeof t == "number")
    O(e.shape[n] % t === 0, () => "Number of splits must evenly divide the axis."), s = new Array(t).fill(e.shape[n] / t);
  else {
    let r = t.reduce((i, o) => (o === -1 && (i += 1), i), 0);
    O(r <= 1, () => "There should be only one negative value in split array.");
    let a = t.indexOf(-1);
    if (a !== -1) {
      let i = t.reduce((o, u) => u > 0 ? o + u : o);
      t[a] = e.shape[n] - i;
    }
    O(e.shape[n] === t.reduce((i, o) => i + o), () => "The sum of sizes must match the size of the axis dimension."), s = t;
  }
  return s;
}
function xP(e) {
  return `Received SparseTensor with denseShape[0] = 0 but
  indices.shape[0] = ${e}`;
}
function wP(e, t) {
  return `indices(${e}, 0) is invalid: ${t} < 0`;
}
function kP(e, t, n) {
  return `indices(${e}, 0) is invalid: ${t} >= ${n}`;
}
function IP(e, t) {
  return `only one output dimension may be -1, not both ${e} and ${t}`;
}
function SP(e, t) {
  return `size ${e} must be non-negative, not ${t}`;
}
function CP() {
  return "reshape cannot infer the missing input size for an empty tensor unless all specified input sizes are non-zero";
}
function NP(e, t) {
  let n = pt(e), s = pt(t);
  return `Input to reshape is a SparseTensor with ${n}
  dense values, but the requested shape requires a multiple of ${s}. inputShape=${e} outputShape= ${t}`;
}
function TP(e, t) {
  let n = pt(e), s = pt(t);
  return `Input to reshape is a tensor with ${n} dense values, but the requested shape has ${s}. inputShape=${e} outputShape=${t}`;
}
function $P() {
  return "segment ids must be >= 0";
}
function _P() {
  return "segment ids are not increasing";
}
function AP(e, t) {
  return `Segment id ${e} out of range [0, ${t}), possibly because segmentIds input is not sorted.`;
}
function EP(e, t, n) {
  return `Bad: indices[${e}] == ${t} out of range [0, ${n})`;
}
var MI = {};
Ae(MI, { collectGatherOpShapeInfo: () => FP, computeOutShape: () => DP, segOpComputeOptimalWindowSize: () => RP });
function RP(e, t) {
  let n = false, s;
  for (e <= xb ? (s = e, n = true) : s = hd(e, Math.floor(Math.sqrt(e))); !n; )
    s > t || s === e ? n = true : s = hd(e, s + 1);
  return s;
}
function DP(e, t, n) {
  let s = [], r = e.length;
  for (let a = 0; a < r; a++)
    a !== t ? s.push(e[a]) : s.push(n);
  return s;
}
function FP(e, t, n, s) {
  let r = t.shape.length, a = e.shape.length;
  if (s !== 0 && (s < -r || s > r))
    throw new Error(`Expect batchDims in the range of [-${r}, ${r}], but got ${s}`);
  if (s < 0 && (s += r), s > a)
    throw new Error(`batchDims (${s}) must be less than rank(x) (
    ${a}).`);
  if (n < s)
    throw new Error(`batchDims (${s}) must be less than or equal to axis (${n}).`);
  for (let p = 0; p < s; ++p)
    if (e.shape[p] !== t.shape[p])
      throw new Error(`x.shape[${p}]: ${e.shape[p]} should be equal to indices.shape[${p}]: ${t.shape[p]}.`);
  let i = e.shape[n], o = [], u = 1, l = 1, c = 1;
  for (let p = 0; p < s; ++p)
    o.push(e.shape[p]), u *= e.shape[p];
  for (let p = s; p < n; p++)
    o.push(e.shape[p]), l *= e.shape[p];
  for (let p = s; p < r; p++)
    o.push(t.shape[p]);
  for (let p = n + 1; p < a; p++)
    o.push(e.shape[p]), c *= e.shape[p];
  return { batchSize: u, sliceSize: c, outerSize: l, dimSize: i, outputShape: o };
}
function OP(e) {
  try {
    return e.map((t) => md(t));
  } catch (t) {
    throw new Error(`Failed to decode encoded string bytes into utf-8, error: ${t}`);
  }
}
function PP(e) {
  return e.map((t) => Dl(t));
}
var xs = {};
Ae(xs, { nonMaxSuppressionV3Impl: () => RI, nonMaxSuppressionV4Impl: () => DI, nonMaxSuppressionV5Impl: () => FI, whereImpl: () => kI });
var LI = { kernelName: io, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => V(e, yp(ce(n, "float32"), -1)) };
} };
var zP = { kernelName: sl, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => {
    let s = ct(ce(n, "float32")), r = dn(ge(we(1), s));
    return kt(xe(e, r));
  } };
} };
var MP = { kernelName: rl, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => {
    let s = dn(ge(ct(ce(n, "float32")), 1));
    return xe(e, s);
  } };
} };
var LP = { kernelName: Ir, inputsToSave: ["a", "b"], gradFunc: (e, t) => {
  let [n, s] = t, r = ot(n.shape, s.shape);
  return { a: () => {
    let o = e, u = _t(n.shape, r);
    return u.length > 0 && (o = ve(o, u)), G(o, n.shape);
  }, b: () => {
    let o = e, u = _t(s.shape, r);
    return u.length > 0 && (o = ve(o, u)), G(o, s.shape);
  } };
} };
var BP = { kernelName: ka, saveAllInputs: true, gradFunc: (e, t) => {
  let n = {};
  return t.forEach((s, r) => {
    n[r] = () => e.clone();
  }), n;
} };
var VP = { kernelName: Ia, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => je(n) };
} };
var WP = { kernelName: ol, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => je(n) };
} };
var UP = { kernelName: ul, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => xe(e, dn(ge(we(1), ct(ce(n, "float32"))))) };
} };
var GP = { kernelName: ll, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => {
    let s = dn(ie(we(1), ct(ce(n, "float32"))));
    return xe(e, s);
  } };
} };
var HP = { kernelName: pl, inputsToSave: ["a", "b"], gradFunc: (e, t) => {
  let [n, s] = t, r = ot(n.shape, s.shape);
  return { a: () => {
    let o = ie(ct(n), ct(s)), u = V(e, xe(s, o)), l = _t(n.shape, r);
    return l.length > 0 && (u = ve(u, l)), G(u, n.shape);
  }, b: () => {
    let o = ie(ct(n), ct(s)), u = kt(V(e, xe(n, o))), l = _t(s.shape, r);
    return l.length > 0 && (u = ve(u, l)), G(u, s.shape);
  } };
} };
var qP = { kernelName: cl, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => xe(e, ie(ct(ce(n, "float32")), 1)) };
} };
var jP = { kernelName: dl, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => xe(e, ge(we(1), ct(ce(n, "float32")))) };
} };
function KP(e, t, n, s, r, a) {
  let i = _(e, "dy", "avgPool3dGrad"), o = _(t, "input", "avgPool3dGrad"), u = i, l = o, c = false;
  o.rank === 4 && (c = true, u = G(i, [1, i.shape[0], i.shape[1], i.shape[2], i.shape[3]]), l = G(o, [1, o.shape[0], o.shape[1], o.shape[2], o.shape[3]])), O(u.rank === 5, () => `Error in avgPool3dGrad: dy must be rank 5 but got rank ${u.rank}.`), O(l.rank === 5, () => `Error in avgPool3dGrad: input must be rank 5 but got rank ${l.rank}.`), hn("avgPool3dGrad", r, a);
  let p = { dy: u, input: l }, d = { filterSize: n, strides: s, pad: r, dimRoundingMode: a }, h = M.runKernel(og, p, d);
  return c ? G(h, [h.shape[1], h.shape[2], h.shape[3], h.shape[4]]) : h;
}
var XP = L({ avgPool3dGrad_: KP });
var YP = { kernelName: qd, inputsToSave: ["x"], gradFunc: (e, t, n) => {
  let [s] = t, { filterSize: r, strides: a, pad: i, dimRoundingMode: o } = n;
  return { x: () => XP(e, s, r, a, i, o) };
} };
function QP(e, t, n, s, r) {
  let a = _(e, "dy", "avgPoolGrad"), i = _(t, "input", "avgPoolGrad");
  O(i.rank === a.rank, () => `Rank of input (${i.rank}) does not match rank of dy (${a.rank})`);
  let o = i, u = a, l = false;
  i.rank === 3 && (l = true, o = G(i, [1, i.shape[0], i.shape[1], i.shape[2]]), u = G(a, [1, a.shape[0], a.shape[1], a.shape[2]])), O(u.rank === 4, () => `Error in avgPoolGrad: dy must be rank 4 but got rank ${u.rank}.`), O(o.rank === 4, () => `Error in avgPoolGrad: input must be rank 4 but got rank ${o.rank}.`);
  let c = { dy: u, input: o }, p = { filterSize: n, strides: s, pad: r }, d = M.runKernel(ig, c, p);
  return l ? G(d, [d.shape[1], d.shape[2], d.shape[3]]) : d;
}
var ZP = L({ avgPoolGrad_: QP });
var JP = { kernelName: Sa, inputsToSave: ["x"], gradFunc: (e, t, n) => {
  let [s] = t, { filterSize: r, strides: a, pad: i } = n;
  return { x: () => ZP(e, s, r, a, i) };
} };
var ez = { kernelName: Ca, inputsToSave: ["a", "b"], gradFunc: (e, t, n) => {
  let [s, r] = t, { transposeA: a, transposeB: i } = n;
  return !a && !i ? { a: () => We(e, r, false, true), b: () => We(s, e, true, false) } : !a && i ? { a: () => We(e, r, false, false), b: () => We(e, s, true, false) } : a && !i ? { a: () => We(r, e, false, true), b: () => We(s, e, false, false) } : { a: () => We(r, e, true, true), b: () => We(e, s, true, true) };
} };
var tz = { kernelName: oo, gradFunc: (e, t, n) => {
  let { blockShape: s, crops: r } = n;
  return { x: () => nb(e, s, r) };
} };
var nz = { kernelName: A$, gradFunc: (e, t, n) => {
  let s = n, r = s.inputShape, a = s.shape, i = Array.from(a);
  for (let u = r.length - 1; u >= 0; u--)
    if (r[u] === a[u])
      i[u] = 1;
    else if (r[u] !== 1)
      throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${a}].`);
  let o = [];
  for (let u = 0; u < i.length; u++)
    i[u] > 1 && o.push(u);
  return { x: () => ve(e, o, true) };
} };
var sz = { kernelName: Na, gradFunc: (e) => ({ x: () => e.clone() }) };
var rz = { kernelName: Ta, gradFunc: (e) => ({ x: () => je(e) }) };
var az = { kernelName: Sr, inputsToSave: ["x"], gradFunc: (e, t, n) => {
  let [s] = t, { clipValueMin: r, clipValueMax: a } = n;
  return { x: () => vn(Ds(Ko(s, r), Xo(s, a)), e, je(e)) };
} };
var iz = { kernelName: Kd, inputsToSave: ["x"], gradFunc: LI.gradFunc };
var oz = { kernelName: uo, saveAllInputs: true, gradFunc: (e, t, n) => {
  let s = t.map((u) => u.shape), { axis: r } = n, a = ts(r, t[0].shape)[0], i = s.map((u) => u[a]);
  return Bn(e, i, a).map((u) => () => u);
} };
var uz = { kernelName: $a, inputsToSave: ["x", "filter"], gradFunc: (e, t, n) => {
  let [s, r] = t, { dilations: a, strides: i, pad: o, dataFormat: u } = n;
  return O(fr(a), () => `Error in gradient of conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`), { x: () => qg(s.shape, e, r, i, o, u), filter: () => pb(s, e, r.shape, i, o, u) };
} };
var lz = { kernelName: _a, inputsToSave: ["dy", "filter"], gradFunc: (e, t, n) => {
  let [s, r] = t, { strides: a, pad: i, dataFormat: o, dimRoundingMode: u } = n;
  return { dy: () => ca(e, r, a, i, o, 1, u), filter: () => pb(e, s, r.shape, a, i, o, u) };
} };
function cz(e, t, n, s, r) {
  let a = e;
  e.rank === 4 && (a = G(e, [1, e.shape[0], e.shape[1], e.shape[2], e.shape[3]]));
  let i = t;
  i.rank === 4 && (i = G(t, [1, t.shape[0], t.shape[1], t.shape[2], t.shape[3]])), O(a.rank === 5, () => `Error in conv3dDerFilter: input must be rank 5, but got shape ${a.shape}.`), O(i.rank === 5, () => `Error in conv3dDerFilter: dy must be rank 5, but got shape ${i.shape}.`), O(n.length === 5, () => `Error in conv3dDerFilter: filterShape must be length 5, but got ${n}.`), O(a.shape[4] === n[3], () => `Error in conv3dDerFilter: depth of input ${a.shape[4]}) must match input depth in filter (${n[3]}.`), O(i.shape[4] === n[4], () => `Error in conv3dDerFilter: depth of dy (${i.shape[4]}) must match output depth for filter (${n[4]}).`);
  let o = { x: a, dy: i }, u = { strides: s, pad: r, filterShape: n };
  return M.runKernel(dg, o, u);
}
var dz = L({ conv3DBackpropFilter_: cz });
var pz = { kernelName: Xd, inputsToSave: ["x", "filter"], gradFunc: (e, t, n) => {
  let { dilations: s, strides: r, pad: a } = n;
  O(fr(s), () => `Error in gradient of conv3D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${s}'`);
  let [i, o] = t;
  return { x: () => tI(i.shape, e, o, r, a), filter: () => dz(i, e, o.shape, r, a) };
} };
var hz = { kernelName: Aa, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => V(kt(bI(ce(n, "float32"))), e) };
} };
var fz = { kernelName: Ea, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => V(yI(ce(n, "float32")), e) };
} };
var mz = { kernelName: lo, inputsToSave: ["x"], gradFunc: (e, t, n) => {
  let [s] = t, { axis: r, exclusive: a, reverse: i } = n;
  return { x: () => {
    let o = lI([r], s.rank), u = sI(e, r, a, !i);
    return o != null && (u = qe(u, o)), u;
  } };
} };
var gz = { kernelName: Ra, inputsToSave: ["x", "filter"], gradFunc: (e, t, n) => {
  let { dilations: s, strides: r, pad: a, dimRoundingMode: i } = n, o = s == null ? [1, 1] : s;
  O(fr(o), () => `Error in gradient of depthwiseConv2dNative: dilation rates greater than 1 are not yet supported. Got dilations '${o}'`);
  let [u, l] = t;
  return O(u.rank === 4, () => `Error in gradient of depthwiseConv2dNative: input must be rank 4, but got rank ${u.rank}.`), O(l.rank === 4, () => `Error in gradient of depthwiseConv2dNative: filter must be rank 4, but got rank ${l.rank}.`), O(u.shape[3] === l.shape[2], () => `Error in gradient of depthwiseConv2d: number of input channels (${u.shape[3]}) must match the inChannels dimension in filter ${l.shape[2]}.`), O(Ps(r, o), () => `Error in gradient of depthwiseConv2d: Either strides or dilations must be  1. Got strides ${r} and dilations '${o}'.`), hn("depthwiseConv2d", a, i), { x: () => _I(u.shape, e, l, r, a, o, i), filter: () => $I(u, e, l.shape, r, a, o, i) };
} };
var bz = { kernelName: Yd, inputsToSave: ["x", "filter"], gradFunc: (e, t, n) => {
  let [s, r] = t, a = { x: s, filter: r, dy: e }, i = { x: s, filter: r, dy: e };
  return { x: () => M.runKernel(Yf, a, n), filter: () => M.runKernel(Qf, i, n) };
} };
var yz = { kernelName: Fa, outputsToSave: [true], gradFunc: (e, t) => {
  let [n] = t, s = { dy: e, y: n };
  return { x: () => M.runKernel(bg, s) };
} };
var vz = { kernelName: fl, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t, s = V(Xn(kt(ct(n))), 2 / Math.sqrt(Math.PI));
  return { x: () => V(e, s) };
} };
var xz = { kernelName: Oa, outputsToSave: [true], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => V(e, n) };
} };
var wz = { kernelName: fo, inputsToSave: ["input"], gradFunc: (e, t) => {
  let [n] = t;
  return { input: () => G(e, n.shape) };
} };
var kz = { kernelName: mo, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => V(e, Xn(n)) };
} };
var Iz = { kernelName: Pa, gradFunc: (e) => ({ x: () => je(e) }) };
var Sz = { kernelName: za, inputsToSave: ["a", "b"], gradFunc: (e, t) => {
  let [n, s] = t, r = ot(n.shape, s.shape);
  return { a: () => {
    let o = xe(e, ce(s, "float32")), u = _t(n.shape, r);
    return u.length > 0 ? G(ve(o, u), n.shape) : o;
  }, b: () => {
    let o = V(e, ce(n, "float32")), u = _t(s.shape, r);
    u.length > 0 && (o = G(ve(o, u), s.shape));
    let l = ct(s);
    return kt(xe(o, ce(l, "float32")));
  } };
} };
var Cz = { kernelName: Ma, inputsToSave: ["x", "mean", "variance", "scale"], gradFunc: (e, t, n) => {
  let { varianceEpsilon: s } = n, [r, a, i, o] = t, u = o == null ? we(1) : o, l = _t(a.shape, r.shape), c = [];
  if (a.rank === 1) {
    for (let x = 0; x < r.shape.length - 1; ++x)
      c.push(r.shape[x]);
    c.push(1);
  }
  let p = ge(r, a), d = V(e, u), h = mI(ie(i, we(s))), f = V(V(V(h, h), h), we(-0.5));
  return { x: () => a.rank === 1 ? G(V(V(e, ps(G(h, [1, 1, 1, a.shape[0]]), c)), u), r.shape) : G(V(V(e, h), u), r.shape), mean: () => {
    let x = V(V(h, we(-1)), d);
    return a.rank === 1 && (x = ve(x, l)), G(x, a.shape);
  }, variance: () => {
    let x = V(V(f, p), d);
    return a.rank === 1 && (x = ve(x, l)), G(x, a.shape);
  }, scale: () => {
    let x = V(p, h), k = V(e, x);
    return a.rank === 1 && (k = ve(k, l)), G(k, a.shape);
  }, offset: () => {
    let x = e;
    return a.rank === 1 && (x = ve(x, l)), G(x, a.shape);
  } };
} };
var Nz = { kernelName: bo, inputsToSave: ["x", "indices"], gradFunc: (e, t, n) => {
  let [s, r] = t, { axis: a } = n, i = ts(a, s.shape)[0];
  return { x: () => {
    let u = s.shape, l = r.size, c = u.slice(0, i), p = c.length, d = u.slice(a, u.length).slice(1), h = d.length, f = yx(0, p), m = yx(p + 1, p + 1 + h), g = vx([c, [l], d]), b = G(e, g), y = G(r, [l]), v = vx([[p], f, m]), x = qe(b, v), k = V3(x, y, s.shape[i]), T = Zg(v);
    return k = qe(k, T), k;
  }, indices: () => r };
} };
function yx(e, t) {
  let n = [];
  for (let s = e; s < t; ++s)
    n.push(s);
  return n;
}
function vx(e) {
  let t = [];
  for (let n = 0; n < e.length; ++n)
    for (let s = 0; s < e[n].length; ++s)
      t.push(e[n][s]);
  return t;
}
var Tz = { kernelName: La, inputsToSave: ["a", "b"], gradFunc: (e, t) => {
  let [n, s] = t;
  return { a: () => je(n), b: () => je(s) };
} };
var $z = { kernelName: Ba, gradFunc: (e) => ({ x: () => ce(e, "float32") }) };
var _z = { kernelName: gl, gradFunc: (e) => ({ x: () => je(e) }) };
var Az = { kernelName: bl, gradFunc: (e) => ({ x: () => je(e) }) };
var Ez = { kernelName: yl, gradFunc: (e) => ({ x: () => je(e) }) };
var Rz = { kernelName: Va, inputsToSave: ["x"], gradFunc: (e, t, n) => {
  let [s] = t, { alpha: r } = n, a = Wn(s, 0);
  return { x: () => vn(a, e, V(e, r)) };
} };
var Dz = { kernelName: vl, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => xe(e, ie(n, 1)) };
} };
var Fz = { kernelName: Wa, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => xe(e, ce(n, "float32")) };
} };
var Oz = { kernelName: E$, inputsToSave: [], outputsToSave: [true], gradFunc: (e, t, n) => {
  let [s] = t, { axis: r } = n;
  return { logits: () => {
    let i = Xn(s);
    return ge(e, V(ve(e, r, true), i));
  } };
} };
function Pz(e, t, n, s = 5, r = 1, a = 1, i = 0.5) {
  let o = { x: e, y: t, dy: n }, u = { depthRadius: s, bias: r, alpha: a, beta: i };
  return M.runKernel(wg, o, u);
}
var zz = L({ localResponseNormalizationBackprop_: Pz });
var Mz = { kernelName: ep, inputsToSave: ["x"], outputsToSave: [true], gradFunc: (e, t, n) => {
  let [s, r] = t, { depthRadius: a, bias: i, alpha: o, beta: u } = n;
  return { x: () => zz(s, r, e, a, i, o, u) };
} };
function BI(e, t, n, s) {
  return t.rank < n.rank && (t = G(t, da(t.shape, s))), e.rank < n.rank && (e = G(e, da(e.shape, s))), { x: () => V(e, ce(Kn(n, t), e.dtype)) };
}
var xx = { kernelName: Ua, inputsToSave: ["x"], outputsToSave: [true], gradFunc: (e, t, n) => {
  let s = n, { reductionIndices: r } = s, a = t[0], i = t[1], o = ts(r, a.shape), u = BI(e, i, a, o);
  return { x: () => u.x() };
} };
var Lz = { kernelName: Ga, inputsToSave: ["a", "b"], gradFunc: (e, t) => {
  let [n, s] = t;
  return { a: () => V(e, ce(Ko(n, s), "float32")), b: () => V(e, ce(aI(n, s), "float32")) };
} };
function Bz(e, t, n, s, r, a, i) {
  let o = _(e, "dy", "maxPool3dGrad"), u = _(t, "input", "maxPool3dGrad"), l = _(n, "output", "maxPool3dGrad"), c = o, p = u, d = l, h = false;
  u.rank === 4 && (h = true, c = G(o, [1, o.shape[0], o.shape[1], o.shape[2], o.shape[3]]), p = G(u, [1, u.shape[0], u.shape[1], u.shape[2], u.shape[3]]), d = G(l, [1, l.shape[0], l.shape[1], l.shape[2], l.shape[3]])), O(c.rank === 5, () => `Error in maxPool3dGrad: dy must be rank 5 but got rank ${c.rank}.`), O(p.rank === 5, () => `Error in maxPool3dGrad: input must be rank 5 but got rank ${p.rank}.`), O(d.rank === 5, () => `Error in maxPool3dGrad: output must be rank 5 but got rank ${d.rank}.`), hn("maxPool3dGrad", a, i);
  let f = { dy: c, input: p, output: d }, m = { filterSize: s, strides: r, pad: a, dimRoundingMode: i }, g = M.runKernel(Ig, f, m);
  return h ? G(g, [g.shape[1], g.shape[2], g.shape[3], g.shape[4]]) : g;
}
var Vz = L({ maxPool3dGrad_: Bz });
var Wz = { kernelName: tp, inputsToSave: ["x"], outputsToSave: [true], gradFunc: (e, t, n) => {
  let [s, r] = t, { filterSize: a, strides: i, pad: o, dimRoundingMode: u } = n;
  return { x: () => Vz(e, s, r, a, i, o, u) };
} };
function Uz(e, t, n, s, r, a, i) {
  let o = _(e, "dy", "maxPoolGrad"), u = _(t, "input", "maxPoolGrad"), l = _(n, "output", "maxPoolGrad");
  O(u.rank === o.rank, () => `Rank of input (${u.rank}) does not match rank of dy (${o.rank})`), O(o.rank === 4, () => `Error in maxPoolGrad: dy must be rank 4 but got rank ${o.rank}.`), O(u.rank === 4, () => `Error in maxPoolGrad: input must be rank 4 but got rank ${u.rank}.`), hn("maxPoolGrad", a, i);
  let c = { dy: o, input: u, output: l }, p = { filterSize: s, strides: r, pad: a, dimRoundingMode: i };
  return M.runKernel(kg, c, p);
}
var Gz = L({ maxPoolGrad_: Uz });
var Hz = { kernelName: Ha, inputsToSave: ["x"], outputsToSave: [true], gradFunc: (e, t, n) => {
  let [s, r] = t, { filterSize: a, strides: i, pad: o } = n;
  return { x: () => Gz(e, s, r, a, i, o) };
} };
var qz = { kernelName: qa, inputsToSave: ["x"], gradFunc: (e, t, n) => {
  let [s] = t, { axis: r } = n, a = ts(r, s.shape), o = uI(s.shape, a)[1], u = pt(o);
  return { x: () => {
    let c = s.shape.slice();
    a.forEach((h) => {
      c[h] = 1;
    });
    let p = G(e, c);
    return xe(V(p, Mn(s.shape, "float32")), u);
  } };
} };
var jz = { kernelName: ja, inputsToSave: ["x"], outputsToSave: [true], gradFunc: (e, t, n) => {
  let s = n, { axis: r } = s, [a, i] = t, o = ts(r, a.shape), u = BI(e, i, a, o);
  return { x: () => u.x() };
} };
var Kz = { kernelName: Ka, inputsToSave: ["a", "b"], gradFunc: (e, t) => {
  let [n, s] = t;
  return { a: () => V(e, ce(Xo(n, s), "float32")), b: () => V(e, ce(Wn(n, s), "float32")) };
} };
var Xz = { kernelName: Xa, inputsToSave: ["x"], gradFunc: (e, t, n) => {
  let s = t[0], { paddings: r } = n, a = r.map((i) => i[0]);
  return { x: () => He(e, a, s.shape) };
} };
var Yz = { kernelName: wl, inputsToSave: ["a", "b"], gradFunc: (e, t) => {
  let [n, s] = t, r = ot(n.shape, s.shape);
  return { a: () => {
    let o = _t(n.shape, r);
    return o.length > 0 ? G(ve(e, o), n.shape) : e;
  }, b: () => {
    let o = V(e, kt(mp(xe(n, s)))), u = _t(s.shape, r);
    return u.length > 0 ? G(ve(o, u), s.shape) : o;
  } };
} };
var Qz = { kernelName: Ya, inputsToSave: ["a", "b"], gradFunc: (e, t) => {
  let [n, s] = t, r = ot(n.shape, s.shape);
  return { a: () => {
    let o = V(e, ce(s, "float32")), u = _t(n.shape, r);
    return u.length > 0 ? G(ve(o, u), n.shape) : o;
  }, b: () => {
    let o = V(e, ce(n, "float32")), u = _t(s.shape, r);
    return u.length > 0 ? G(ve(o, u), s.shape) : o;
  } };
} };
var Zz = { kernelName: Io, gradFunc: (e) => ({ x: () => kt(e) }) };
var Jz = { kernelName: $o, inputsToSave: ["indices"], gradFunc: (e, t) => {
  let n = t[0];
  return { indices: () => $t(n.shape, "float32") };
} };
var eM = { kernelName: To, gradFunc: (e) => ({ x: () => je(e) }) };
var tM = { kernelName: _o, saveAllInputs: true, gradFunc: (e, t, n) => {
  let { axis: s } = n;
  return Fs(e, s).map((a) => () => a);
} };
var wx = { kernelName: Qa, inputsToSave: ["x"], gradFunc: (e, t, n) => {
  let s = t[0], { paddings: r } = n, a = r.map((i) => i[0]);
  return { x: () => He(e, a, s.shape) };
} };
var nM = { kernelName: Za, inputsToSave: ["a", "b"], outputsToSave: [true], gradFunc: (e, t) => {
  let [n, s, r] = t, a = n, i = s, o = ot(a.shape, i.shape);
  return { a: () => {
    let c = ce(i, "float32"), p = V(e, V(c, pa(a, ge(c, we(1))))), d = _t(a.shape, o);
    return d.length > 0 && (p = ve(p, d)), G(p, a.shape);
  }, b: () => {
    let c = Wn(a, 0), p = vn(c, Yn(a), je(a)), d = V(e, V(r, p)), h = _t(i.shape, o);
    return h.length > 0 && (d = ve(d, h)), G(d, i.shape);
  } };
} };
var sM = { kernelName: Ja, inputsToSave: ["x", "alpha"], gradFunc: (e, t) => {
  let [n, s] = t, r = Wn(n, 0);
  return { x: () => vn(r, e, V(e, s)), alpha: () => {
    let a = vn(r, je(e), V(e, n)), i = _t(s.shape, e.shape);
    return i.length > 0 && (a = ve(a, i)), G(a, s.shape);
  } };
} };
var rM = { kernelName: Da, inputsToSave: ["a", "b"], gradFunc: (e, t) => {
  let [n, s] = t, r = ot(n.shape, s.shape);
  return { a: () => {
    let o = xe(e, ce(s, "float32")), u = _t(n.shape, r);
    return u.length > 0 ? G(ve(o, u), n.shape) : o;
  }, b: () => {
    let o = V(e, ce(n, "float32")), u = _t(s.shape, r);
    u.length > 0 && (o = G(ve(o, u), s.shape));
    let l = ct(s);
    return kt(xe(o, ce(l, "float32")));
  } };
} };
var aM = { kernelName: Sl, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => xe(e, kt(ct(n))) };
} };
var iM = { kernelName: ni, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t, s = V(Xo(n, 6), yp(n));
  return { x: () => V(e, ce(s, "float32")) };
} };
var oM = { kernelName: ei, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => V(e, ce(yp(n), "float32")) };
} };
var uM = { kernelName: Eo, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => G(e, n.shape) };
} };
var lM = { kernelName: ti, inputsToSave: ["images"], gradFunc: (e, t, n) => {
  let [s] = t, r = { dy: e, images: s };
  return { images: () => M.runKernel(Tg, r, n) };
} };
var cM = { kernelName: Cl, inputsToSave: ["images"], gradFunc: (e, t, n) => {
  let [s] = t, r = { dy: e, images: s };
  return { images: () => M.runKernel(Ng, r, n) };
} };
var dM = { kernelName: Ro, gradFunc: (e, t, n) => {
  let { dims: s } = n, r = ts(s, e.shape);
  return { x: () => Zn(e, r) };
} };
var pM = { kernelName: Do, gradFunc: (e) => ({ x: () => je(e) }) };
var hM = { kernelName: si, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => kt(xe(e, V(pa(n, 1.5), 2))) };
} };
var fM = { kernelName: Oo, inputsToSave: ["condition"], gradFunc: (e, t) => {
  let [n] = t;
  return { condition: () => ce(je(n), "float32"), t: () => V(e, ce(n, e.dtype)), e: () => V(e, ce(Jg(n), e.dtype)) };
} };
var mM = { kernelName: Nl, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => {
    let s = Wn(n, we(0)), r = we(PI), a = we(zI), i = V(e, a), o = V(V(e, r), Xn(ce(n, "float32")));
    return vn(s, i, o);
  } };
} };
var gM = { kernelName: ai, outputsToSave: [true], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => V(e, V(n, ge(we(1), n))) };
} };
var bM = { kernelName: Tl, gradFunc: (e) => ({ x: () => je(e) }) };
var yM = { kernelName: ri, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => V(jg(ce(n, "float32")), e) };
} };
var vM = { kernelName: zo, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => V(nI(ce(n, "float32")), e) };
} };
var xM = { kernelName: Po, inputsToSave: ["x"], gradFunc: (e, t, n) => {
  let [s] = t, { begin: r, size: a } = n, i = s.shape, [o, u] = Bk(s, r, a), l = [];
  for (let c = 0; c < e.rank; c++)
    l.push([o[c], i[c] - o[c] - u[c]]);
  return { x: () => fi(e, l) };
} };
var wM = { kernelName: ui, outputsToSave: [true], gradFunc: (e, t, n) => {
  let [s] = t, { dim: r } = n, a = true, i = V(e, s);
  return { logits: () => ge(i, V(ve(i, [r], a), s)) };
} };
var kM = { kernelName: $l, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => V(e, qs(n)) };
} };
var kx = { kernelName: Mo, gradFunc: (e, t, n) => {
  let { blockShape: s, paddings: r } = n;
  return { x: () => Hg(e, s, r) };
} };
var Ix = { kernelName: Lo, gradFunc: (e, t, n) => {
  let { axis: s } = n;
  return { x: () => Ft(e, s) };
} };
var IM = { kernelName: ii, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => xe(e, V(dn(ce(n, "float32")), 2)) };
} };
var SM = { kernelName: Al, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => V(e, V(ce(n, "float32"), 2)) };
} };
var CM = { kernelName: li, inputsToSave: ["a", "b"], gradFunc: (e, t) => {
  let [n, s] = t, r = we(2);
  return { a: () => V(e, V(r, ge(n, s))), b: () => V(e, V(r, ge(s, n))) };
} };
var NM = { kernelName: hi, gradFunc: (e) => ({ x: () => je(e) }) };
var TM = { kernelName: ci, inputsToSave: ["a", "b"], gradFunc: (e, t) => {
  let [n, s] = t, r = ot(n.shape, s.shape);
  return { a: () => {
    let o = e, u = _t(n.shape, r);
    return u.length > 0 && (o = ve(o, u)), G(o, n.shape);
  }, b: () => {
    let o = e, u = _t(s.shape, r);
    return u.length > 0 && (o = ve(o, u)), G(kt(o), s.shape);
  } };
} };
var $M = { kernelName: oi, inputsToSave: ["x"], gradFunc: (e, t, n) => {
  let [s] = t, r = s.shape.slice(), { axis: a } = n;
  ts(a, s.shape).forEach((l) => {
    r[l] = 1;
  });
  let o = G(e, r), u = V(o, Mn(s.shape, "float32"));
  return { x: () => u };
} };
var _M = { kernelName: Vo, inputsToSave: ["x"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => xe(e, ct(jg(n))) };
} };
var AM = { kernelName: di, outputsToSave: [true], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => V(ge(we(1), ct(n)), e) };
} };
var EM = { kernelName: Cr, inputsToSave: ["x"], gradFunc: (e, t, n) => {
  let [s] = t, { reps: r } = n;
  return { x: () => {
    let i = je(s);
    if (s.rank === 1)
      for (let o = 0; o < r[0]; ++o)
        i = ie(i, He(e, [o * s.shape[0]], [s.shape[0]]));
    else if (s.rank === 2)
      for (let o = 0; o < r[0]; ++o)
        for (let u = 0; u < r[1]; ++u)
          i = ie(i, He(e, [o * s.shape[0], u * s.shape[1]], [s.shape[0], s.shape[1]]));
    else if (s.rank === 3)
      for (let o = 0; o < r[0]; ++o)
        for (let u = 0; u < r[1]; ++u)
          for (let l = 0; l < r[2]; ++l)
            i = ie(i, He(e, [o * s.shape[0], u * s.shape[1], l * s.shape[2]], [s.shape[0], s.shape[1], s.shape[2]]));
    else if (s.rank === 4)
      for (let o = 0; o < r[0]; ++o)
        for (let u = 0; u < r[1]; ++u)
          for (let l = 0; l < r[2]; ++l)
            for (let c = 0; c < r[3]; ++c)
              i = ie(i, He(e, [o * s.shape[0], u * s.shape[1], l * s.shape[2], c * s.shape[3]], [s.shape[0], s.shape[1], s.shape[2], s.shape[3]]));
    else
      throw new Error(`Gradient for tile operation is not implemented for rank-${s.rank} tensors yet.`);
    return i;
  } };
} };
var RM = { kernelName: pi, gradFunc: (e, t, n) => {
  let s = n, { perm: r } = s, a = Zg(r);
  return { x: () => qe(e, a) };
} };
var DM = { kernelName: Go, gradFunc: (e, t, n) => {
  let s = n, { axis: r } = s;
  return { value: () => Jn(e, r) };
} };
var FM = { kernelName: up, inputsToSave: ["segmentIds"], gradFunc: (e, t) => {
  let [n] = t;
  return { x: () => OM(e, n) };
} };
function OM(e, t) {
  let n = $r(t, je(t)), s = Ku(e, n), r = Ko(t, we(0, "int32")), a = s.rank - r.rank;
  for (let o = 0; o < a; ++o)
    r = Pn(r, o + 1);
  r = Ds(r, Mn(s.shape, "bool"));
  let i = je(s);
  return vn(r, s, i);
}
var PM = { kernelName: Ho, gradFunc: (e) => ({ x: () => je(e) }) };
var zM = [LI, zP, MP, LP, BP, VP, WP, UP, GP, HP, qP, jP, YP, JP, ez, tz, nz, sz, rz, az, iz, oz, lz, uz, pz, hz, fz, mz, gz, bz, rM, yz, vz, xz, wz, kz, Sz, Iz, Cz, Nz, Tz, $z, _z, Az, Ez, Rz, Dz, Fz, Oz, Mz, xx, xx, Lz, Wz, Hz, qz, jz, Kz, Xz, Yz, Qz, Zz, Jz, eM, tM, wx, wx, nM, sM, aM, iM, oM, uM, lM, cM, dM, pM, hM, fM, mM, gM, bM, yM, vM, xM, wM, kM, kx, kx, Ix, Ix, IM, CM, SM, NM, TM, $M, _M, AM, EM, RM, DM, FM, PM];
for (let e of zM)
  D$(e);
var MM = {};
Ae(MM, { maxNorm: () => WM, minMaxNorm: () => HM, nonNeg: () => GM, unitNorm: () => UM });
var Bf;
function Rt() {
  return Bf == null && (Bf = zA().epsilon()), Bf;
}
function bs() {
  return "channelsLast";
}
var Vs = class extends Error {
  constructor(e) {
    super(e), Object.setPrototypeOf(this, Vs.prototype);
  }
};
var hs = class extends Error {
  constructor(e) {
    super(e), Object.setPrototypeOf(this, hs.prototype);
  }
};
var U = class extends Error {
  constructor(e) {
    super(e), Object.setPrototypeOf(this, U.prototype);
  }
};
var Fe = class extends Error {
  constructor(e) {
    super(e), Object.setPrototypeOf(this, Fe.prototype);
  }
};
var VI = class extends Error {
  constructor(e) {
    super(e), Object.setPrototypeOf(this, VI.prototype);
  }
};
function fa(e, t) {
  if (Array.isArray(e)) {
    let n = [];
    for (let s = 0; s < t; s++)
      n = n.concat(e);
    return n;
  } else {
    let n = new Array(t);
    return n.fill(e), n;
  }
}
function Cs(e, t) {
  if (!e)
    throw new VI(t);
}
function Sx(e, t) {
  let n = 0;
  for (let s of e)
    s === t && n++;
  return n;
}
function bn(e) {
  return e.length === 1 ? e[0] : e;
}
function dt(e) {
  return Array.isArray(e) ? e : [e];
}
function Ws(e) {
  let n = e.replace(/(.)([A-Z][a-z0-9]+)/g, "$1_$2").replace(/([a-z])([A-Z])/g, "$1_$2").toLowerCase();
  return n[0] !== "_" ? n : "private" + n;
}
function Kr(e) {
  return e.length <= 1 || e.indexOf("_") === -1 ? e : e.replace(/[_]+(\w|$)/g, (t, n) => n.toUpperCase());
}
var Gn = {};
function wb(e) {
  if (e == null)
    return null;
  let t = {};
  return t.className = e.getClassName(), t.config = e.getConfig(), t;
}
function mm(e) {
  if (!(e == null || typeof e != "object"))
    if (Array.isArray(e))
      e.forEach((t) => mm(t));
    else {
      let t = Object.keys(e);
      for (let n of t) {
        let s = e[n];
        s != null && typeof s == "object" && (!Array.isArray(s) && s.type === "ndarray" && typeof s.value == "number" ? e[n] = s.value : mm(s));
      }
    }
}
function Ll(e, t = {}, n = {}, s = "object", r = false) {
  if (typeof e == "string") {
    let a = e, i;
    if (a in n)
      i = n[a];
    else if (a in Gn)
      i = Gn[a];
    else if (i = t[a], i == null)
      throw new U(`Unknown ${s}: ${e}. This may be due to one of the following reasons:
1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.
2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);
    return i;
  } else {
    let a = e;
    if (a.className == null || a.config == null)
      throw new U(`${s}: Improper config format: ${JSON.stringify(a)}.
'className' and 'config' must set.`);
    let i = a.className, o, u;
    if (i in n ? [o, u] = n[i] : i in Gn ? [o, u] = Gn.className : i in t && ([o, u] = t[i]), o == null)
      throw new U(`Unknown ${s}: ${i}. This may be due to one of the following reasons:
1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.
2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);
    if (u != null) {
      let l = {};
      for (let h of Object.keys(Gn))
        l[h] = Gn[h];
      for (let h of Object.keys(n))
        l[h] = n[h];
      let c = a.config;
      c.customObjects = l;
      let p = { ...Gn };
      for (let h of Object.keys(n))
        Gn[h] = n[h];
      mm(a.config);
      let d = u(o, a.config, n, r);
      return Gn = { ...p }, d;
    } else {
      let l = { ...Gn };
      for (let p of Object.keys(n))
        Gn[p] = n[p];
      let c = new o(a.config);
      return Gn = { ...l }, c;
    }
  }
}
function LM(e, t) {
  return e < t ? -1 : e > t ? 1 : 0;
}
function Uc(e, t) {
  return -1 * LM(e, t);
}
function cr(e) {
  if (e == null)
    return e;
  let t = [];
  for (let n of e)
    t.indexOf(n) === -1 && t.push(n);
  return t;
}
function BM(e) {
  if (e == null)
    throw new U(`Invalid value in obj: ${JSON.stringify(e)}`);
  for (let t in e)
    if (e.hasOwnProperty(t))
      return false;
  return true;
}
function mi(e, t, n) {
  if (n != null && e.indexOf(n) < 0)
    throw new U(`${n} is not a valid ${t}.  Valid values are ${e} or null/undefined.`);
}
function kb(e, t, n = 0, s = 1 / 0) {
  return Cs(n >= 0), Cs(s >= n), Array.isArray(e) && e.length >= n && e.length <= s && e.every((r) => typeof r === t);
}
function Bt(e, t) {
  Array.isArray(e) ? (w.assert(e.length > 0, () => `${t} is unexpectedly an empty array.`), e.forEach((n, s) => Bt(n, `element ${s + 1} of ${t}`))) : w.assert(Number.isInteger(e) && e > 0, () => `Expected ${t} to be a positive integer, but got ${WI(e)}.`);
}
function WI(e) {
  return e === null ? "null" : Array.isArray(e) ? "[" + e.map((t) => WI(t)).join(",") + "]" : typeof e == "string" ? `"${e}"` : `${e}`;
}
function VM(e, t, n) {
  let s = n != null ? n() : w.now(), r;
  return (...i) => {
    let o = n != null ? n() : w.now();
    return o - s < t || (s = o, r = e(...i)), r;
  };
}
function UI(e) {
  return e === "relu" ? "relu" : e === "linear" ? "linear" : e === "elu" ? "elu" : null;
}
function Ib(e, t) {
  return j(() => dn(ve(V(e, e), t, true)));
}
var Bl = class extends ae.Serializable {
  getConfig() {
    return {};
  }
};
var Sb = class extends Bl {
  constructor(e) {
    super(), this.defaultMaxValue = 2, this.defaultAxis = 0, this.maxValue = e.maxValue != null ? e.maxValue : this.defaultMaxValue, this.axis = e.axis != null ? e.axis : this.defaultAxis;
  }
  apply(e) {
    return j(() => {
      let t = Ib(e, this.axis), n = Vn(t, 0, this.maxValue);
      return V(e, xe(n, ie(Rt(), t)));
    });
  }
  getConfig() {
    return { maxValue: this.maxValue, axis: this.axis };
  }
};
Sb.className = "MaxNorm";
ae.registerClass(Sb);
var Cb = class extends Bl {
  constructor(e) {
    super(), this.defaultAxis = 0, this.axis = e.axis != null ? e.axis : this.defaultAxis;
  }
  apply(e) {
    return j(() => xe(e, ie(Rt(), Ib(e, this.axis))));
  }
  getConfig() {
    return { axis: this.axis };
  }
};
Cb.className = "UnitNorm";
ae.registerClass(Cb);
var Nb = class extends Bl {
  apply(e) {
    return Xs(e);
  }
};
Nb.className = "NonNeg";
ae.registerClass(Nb);
var Tb = class extends Bl {
  constructor(e) {
    super(), this.defaultMinValue = 0, this.defaultMaxValue = 1, this.defaultRate = 1, this.defaultAxis = 0, this.minValue = e.minValue != null ? e.minValue : this.defaultMinValue, this.maxValue = e.maxValue != null ? e.maxValue : this.defaultMaxValue, this.rate = e.rate != null ? e.rate : this.defaultRate, this.axis = e.axis != null ? e.axis : this.defaultAxis;
  }
  apply(e) {
    return j(() => {
      let t = Ib(e, this.axis), n = ie(V(this.rate, Vn(t, this.minValue, this.maxValue)), V(1 - this.rate, t));
      return V(e, xe(n, ie(Rt(), t)));
    });
  }
  getConfig() {
    return { minValue: this.minValue, maxValue: this.maxValue, rate: this.rate, axis: this.axis };
  }
};
Tb.className = "MinMaxNorm";
ae.registerClass(Tb);
var Cx = { maxNorm: "MaxNorm", minMaxNorm: "MinMaxNorm", nonNeg: "NonNeg", unitNorm: "UnitNorm" };
function Ot(e) {
  return wb(e);
}
function Nx(e, t = {}) {
  return Ll(e, ae.SerializationMap.getMap().classNameMap, t, "constraint");
}
function Pt(e) {
  if (e == null)
    return null;
  if (typeof e == "string") {
    let n = { className: e in Cx ? Cx[e] : e, config: {} };
    return Nx(n);
  } else
    return e instanceof Bl ? e : Nx(e);
}
function WM(e) {
  return new Sb(e);
}
function UM(e) {
  return new Cb(e);
}
function GM() {
  return new Nb();
}
function HM(e) {
  return new Tb(e);
}
var qM = {};
Ae(qM, { constant: () => mL, glorotNormal: () => kL, glorotUniform: () => wL, heNormal: () => IL, heUniform: () => SL, identity: () => vL, leCunNormal: () => CL, leCunUniform: () => NL, ones: () => fL, orthogonal: () => TL, randomNormal: () => bL, randomUniform: () => gL, truncatedNormal: () => yL, varianceScaling: () => xL, zeros: () => hL });
var jM = ["channelsFirst", "channelsLast"];
var KM = ["nearest", "bilinear"];
var XM = ["valid", "same", "causal"];
var YM = ["max", "avg"];
var QM = ["sum", "mul", "concat", "ave"];
var zi = /* @__PURE__ */ new Map();
function Ct(e) {
  mi(jM, "DataFormat", e);
}
function ZM(e) {
  mi(KM, "InterpolationFormat", e);
}
function Un(e) {
  mi(XM, "PaddingMode", e);
}
function GI(e) {
  mi(YM, "PoolMode", e);
}
var Mu = [];
var Tx = "/";
function ea(e, t) {
  Mu.push(e);
  try {
    let n = t();
    return Mu.pop(), n;
  } catch (n) {
    throw Mu.pop(), n;
  }
}
function JM() {
  return Mu.length === 0 ? "" : Mu.join(Tx) + Tx;
}
function HI(e) {
  if (!jI(e))
    throw new Error("Not a valid tensor name: '" + e + "'");
  return JM() + e;
}
function qI(e) {
  if (!jI(e))
    throw new Error("Not a valid tensor name: '" + e + "'");
  zi.has(e) || zi.set(e, 0);
  let t = zi.get(e);
  if (zi.set(e, zi.get(e) + 1), t > 0) {
    let n = `${e}_${t}`;
    return zi.set(n, 1), n;
  } else
    return e;
}
var eL = new RegExp(/^[A-Za-z0-9][-A-Za-z0-9\._\/]*$/);
function jI(e) {
  return !!e.match(eL);
}
function tL(e) {
  return e === parseInt(e.toString(), 10);
}
function dr(e, t, n) {
  t == null && (t = 0), n == null && (n = e.length);
  let s = 1;
  for (let r = t; r < n; ++r)
    s *= e[r];
  return s;
}
function Zi(e) {
  if (e.length === 0)
    return Number.NaN;
  let t = Number.POSITIVE_INFINITY;
  for (let n = 0; n < e.length; n++) {
    let s = e[n];
    s < t && (t = s);
  }
  return t;
}
function gr(e) {
  if (e.length === 0)
    return Number.NaN;
  let t = Number.NEGATIVE_INFINITY;
  for (let n = 0; n < e.length; n++) {
    let s = e[n];
    s > t && (t = s);
  }
  return t;
}
function ys(e, t) {
  if (t < e)
    throw new U(`end (${t}) < begin (${e}) is forbidden.`);
  let n = [];
  for (let s = e; s < t; ++s)
    n.push(s);
  return n;
}
function Sp(e, t) {
  return ce(e, t);
}
function Vl(e, t = -1) {
  let n = e.shape.slice();
  return t < 0 && (t = n.length + t + 1), n.splice(t, 0, 1), G(e, n);
}
function nL(e, t) {
  return j(() => {
    if (e.shape.length !== 2)
      throw new U(`repeat() expects a rank-2 tensor, but received a rank-${e.shape.length} tensor.`);
    let n = Vl(e, 1);
    return gm(n, [1, t, 1]);
  });
}
function sL(e) {
  let t = [dr(e.shape)];
  return G(e, t);
}
function rL(e) {
  if (e.rank <= 1)
    throw new U(`batchFlatten requires a minimum rank of 2. Got rank: ${e.rank}.`);
  let t = [e.shape[0], dr(e.shape, 1)];
  return G(e, t);
}
function ta(e, t, n) {
  return j(() => {
    switch (e.rank) {
      case 1:
        return ib(e, t, n);
      case 2:
        return vI(e, [t, 0], [n, e.shape[1]]);
      case 3:
        return ob(e, [t, 0, 0], [n, e.shape[1], e.shape[2]]);
      case 4:
        return kd(e, [t, 0, 0, 0], [n, e.shape[1], e.shape[2], e.shape[3]]);
      case 5:
        return He(e, [t, 0, 0, 0, 0], [n, e.shape[1], e.shape[2], e.shape[3], e.shape[4]]);
      case 6:
        return He(e, [t, 0, 0, 0, 0, 0], [n, e.shape[1], e.shape[2], e.shape[3], e.shape[4], e.shape[5]]);
      default:
        throw new U(`sliceAlongFirstAxis() received an unsupported tensor rank: ${e.rank}`);
    }
  });
}
function Vf(e, t, n) {
  return j(() => {
    switch (e.rank) {
      case 1:
        return ib(e, t, n);
      case 2:
        return vI(e, [0, t], [e.shape[0], n]);
      case 3:
        return ob(e, [0, 0, t], [e.shape[0], e.shape[1], n]);
      case 4:
        return kd(e, [0, 0, 0, t], [e.shape[0], e.shape[1], e.shape[2], n]);
      default:
        throw new U(`sliceAlongLastAxis() received an unsupported tensor rank: ${e.rank}`);
    }
  });
}
function Gc(e, t, n, s) {
  return j(() => {
    switch (e.rank) {
      case 1:
        return ib(e, t, n);
      case 2:
        switch (s) {
          case 1:
            return ta(e, t, n);
          case 2:
            return Vf(e, t, n);
          default:
            throw new U(`The axis is not within the rank of the tensor ${s}`);
        }
      case 3:
        switch (s) {
          case 1:
            return ta(e, t, n);
          case 2:
            return ob(e, [0, t, 0], [e.shape[0], n, e.shape[2]]);
          case 3:
            return Vf(e, t, n);
          default:
            throw new U(`The axis is not within the rank of the tensor ${s}`);
        }
      case 4:
        switch (s) {
          case 1:
            return ta(e, t, n);
          case 2:
            return kd(e, [0, t, 0, 0], [e.shape[0], n, e.shape[2], e.shape[3]]);
          case 3:
            return kd(e, [0, 0, t, 0], [e.shape[0], e.shape[1], n, e.shape[3]]);
          case 4:
            return Vf(e, t, n);
          default:
            throw new U(`The axis is not within the rank of the tensor ${s}`);
        }
      default:
        throw new U(`sliceAlongLastAxis() received an unsupported tensor rank: ${e.rank}`);
    }
  });
}
function $b(e, t = -1) {
  let n;
  return t < 0 && (n = e[0].rank, n !== 0 ? t = n : t = 0), t === e[0].rank && (t = -1), Ft(e, t);
}
function $x(e, t) {
  switch (e.rank) {
    case 1:
      return VE([e, t]);
    case 2:
      return UE([e, t], 0);
    case 3:
      return HE([e, t], 0);
    case 4:
      return jE([e, t], 0);
    default:
      throw new U(`concatAlongFirstAxis() received an unsupported tensor rank: ${e.rank}`);
  }
}
function gm(e, t) {
  if (Array.isArray(t) || (t = [t]), e.rank !== t.length)
    throw new U(`The length of input n (${t.length}) does not match the number of dimensions in input x (${e.rank})`);
  return ps(e, t);
}
function Cp(e, t = 0, n = 1, s, r) {
  return KD(e, t, n, s, r);
}
function Es(e, t, n, s) {
  if (e.rank < 2 || t.rank < 2)
    throw new Fe(`dot requires both inputs to be rank >= 2 but got x shape = ${e.shape} and y shape = ${t.shape}`);
  if (t.rank >= 3) {
    let r = e.shape.slice(-1)[0], a = t.shape.slice(-2)[0];
    if (r !== a)
      throw new Fe(`If rank y >= 3, then the second last dim of y must equal the last dim of x but got x shape = ${e.shape} and  y shape = ${t.shape}`);
  }
  if (e.rank === 2 && t.rank === 2)
    return ha.matMul({ a: e, b: t, transposeA: false, transposeB: false, bias: s ? bm(e.rank, s, bs()) : null, activation: n });
  {
    let r = e.shape.slice(), a = r.pop();
    e = G(e, [-1, a]);
    let i = t.shape.slice(), o = i.pop(), u = i.pop(), l = [...i, o], c = Array.from({ length: t.rank }, (f, m) => m === 0 ? t.rank - 2 : m <= t.rank - 2 ? m - 1 : m);
    t = G(qe(t, c), [u, -1]);
    let p = [...r, ...l], d = false, h = false;
    return G(ha.matMul({ a: e, b: t, transposeA: d, transposeB: h, bias: s ? bm(e.rank, s, bs()) : null, activation: n }), p);
  }
}
function KI(e, t, n) {
  return j(() => (Array.isArray(t) ? t = Zt(t, "int32") : t = ce(t, "int32"), Ku(e, t, n)));
}
function Wl(e) {
  return V(e, e);
}
function bm(e, t, n) {
  let s = t.shape;
  if (t.rank !== 1 && t.rank !== e)
    throw new U(`Unexpected bias dimensions: ${t.rank}; expected it to be 1 or ${e}`);
  if (e === 5) {
    if (n === "channelsFirst")
      return s.length === 1 ? G(t, [1, s[0], 1, 1, 1]) : G(t, [1, s[3], s[0], s[1], s[2]]);
    if (n === "channelsLast")
      return s.length === 1 ? G(t, [1, 1, 1, 1, s[0]]) : G(t, [1].concat(s));
  } else if (e === 4) {
    if (n === "channelsFirst")
      return s.length === 1 ? G(t, [1, s[0], 1, 1]) : G(t, [1, s[2], s[0], s[1]]);
    if (n === "channelsLast")
      return s.length === 1 ? G(t, [1, 1, 1, s[0]]) : G(t, [1].concat(s));
  } else if (e === 3) {
    if (n === "channelsFirst")
      return s.length === 1 ? G(t, [1, s[0], 1]) : G(t, [1, s[1], s[0]]);
    if (n === "channelsLast")
      return s.length === 1 ? G(t, [1, 1, s[0]]) : G(t, [1].concat(s));
  } else if (e < 3)
    return t;
  throw new U(`Unsupported input rank by biasAdd: ${t.rank}`);
}
function ws(e, t, n) {
  return j(() => (n == null && (n = bs()), Ct(n), ie(e, bm(e.rank, t, n))));
}
function aL(e, t = 1) {
  if (t !== 1)
    throw new Fe(`Support for alpha values other than 1 (${t}) is not implemented yet.`);
  return fp(e);
}
function iL(e) {
  return j(() => xe(e, ie(Mt(e), 1)));
}
function XI(e, t, n, s) {
  return j(() => nF(e, t, n, s));
}
function oL(e) {
  return j(() => {
    let t = ie(0.5, V(0.2, e));
    return Vn(t, 0, 1);
  });
}
function Ul(e, t, n = false) {
  return n ? e() : t();
}
var uL = ["fanIn", "fanOut", "fanAvg"];
var lL = ["normal", "uniform", "truncatedNormal"];
function cL(e) {
  mi(uL, "FanMode", e);
}
function dL(e) {
  mi(lL, "Distribution", e);
}
var ns = class extends ae.Serializable {
  fromConfigUsesCustomObjects() {
    return false;
  }
  getConfig() {
    return {};
  }
};
var _b = class extends ns {
  apply(e, t) {
    return $t(e, t);
  }
};
_b.className = "Zeros";
ae.registerClass(_b);
var Np = class extends ns {
  apply(e, t) {
    return Mn(e, t);
  }
};
Np.className = "Ones";
ae.registerClass(Np);
var Ab = class extends ns {
  constructor(e) {
    if (super(), typeof e != "object")
      throw new U(`Expected argument of type ConstantConfig but got ${e}`);
    if (e.value === void 0)
      throw new U(`config must have value set but got ${e}`);
    this.value = e.value;
  }
  apply(e, t) {
    return j(() => V(we(this.value), Mn(e, t)));
  }
  getConfig() {
    return { value: this.value };
  }
};
Ab.className = "Constant";
ae.registerClass(Ab);
var Eb = class extends ns {
  constructor(e) {
    super(), this.DEFAULT_MINVAL = -0.05, this.DEFAULT_MAXVAL = 0.05, this.minval = e.minval || this.DEFAULT_MINVAL, this.maxval = e.maxval || this.DEFAULT_MAXVAL, this.seed = e.seed;
  }
  apply(e, t) {
    return Ml(e, this.minval, this.maxval, t);
  }
  getConfig() {
    return { minval: this.minval, maxval: this.maxval, seed: this.seed };
  }
};
Eb.className = "RandomUniform";
ae.registerClass(Eb);
var Rb = class extends ns {
  constructor(e) {
    super(), this.DEFAULT_MEAN = 0, this.DEFAULT_STDDEV = 0.05, this.mean = e.mean || this.DEFAULT_MEAN, this.stddev = e.stddev || this.DEFAULT_STDDEV, this.seed = e.seed;
  }
  apply(e, t) {
    if (t = t || "float32", t !== "float32" && t !== "int32")
      throw new Fe(`randomNormal does not support dType ${t}.`);
    return Cp(e, this.mean, this.stddev, t, this.seed);
  }
  getConfig() {
    return { mean: this.mean, stddev: this.stddev, seed: this.seed };
  }
};
Rb.className = "RandomNormal";
ae.registerClass(Rb);
var Db = class extends ns {
  constructor(e) {
    super(), this.DEFAULT_MEAN = 0, this.DEFAULT_STDDEV = 0.05, this.mean = e.mean || this.DEFAULT_MEAN, this.stddev = e.stddev || this.DEFAULT_STDDEV, this.seed = e.seed;
  }
  apply(e, t) {
    if (t = t || "float32", t !== "float32" && t !== "int32")
      throw new Fe(`truncatedNormal does not support dType ${t}.`);
    return db(e, this.mean, this.stddev, t, this.seed);
  }
  getConfig() {
    return { mean: this.mean, stddev: this.stddev, seed: this.seed };
  }
};
Db.className = "TruncatedNormal";
ae.registerClass(Db);
var Fb = class extends ns {
  constructor(e) {
    super(), this.gain = e.gain != null ? e.gain : 1;
  }
  apply(e, t) {
    return j(() => {
      if (e.length !== 2 || e[0] !== e[1])
        throw new U("Identity matrix initializer can only be used for 2D square matrices.");
      return V(this.gain, rI(e[0]));
    });
  }
  getConfig() {
    return { gain: this.gain };
  }
};
Fb.className = "Identity";
ae.registerClass(Fb);
function pL(e, t = "channelsLast") {
  let n, s;
  if (Ct(t), e.length === 2)
    n = e[0], s = e[1];
  else if ([3, 4, 5].indexOf(e.length) !== -1) {
    if (t === "channelsFirst") {
      let r = dr(e, 2);
      n = e[1] * r, s = e[0] * r;
    } else if (t === "channelsLast") {
      let r = dr(e, 0, e.length - 2);
      n = e[e.length - 2] * r, s = e[e.length - 1] * r;
    }
  } else {
    let r = dr(e);
    n = Math.sqrt(r), s = Math.sqrt(r);
  }
  return [n, s];
}
var xn = class extends ns {
  constructor(e) {
    if (super(), e.scale < 0)
      throw new U(`scale must be a positive float. Got: ${e.scale}`);
    this.scale = e.scale == null ? 1 : e.scale, this.mode = e.mode == null ? "fanIn" : e.mode, cL(this.mode), this.distribution = e.distribution == null ? "normal" : e.distribution, dL(this.distribution), this.seed = e.seed;
  }
  apply(e, t) {
    let n = pL(e), s = n[0], r = n[1], a = this.scale;
    if (this.mode === "fanIn" ? a /= Math.max(1, s) : this.mode === "fanOut" ? a /= Math.max(1, r) : a /= Math.max(1, (s + r) / 2), this.distribution === "normal") {
      let i = Math.sqrt(a);
      if (t = t || "float32", t !== "float32" && t !== "int32")
        throw new Fe(`${this.getClassName()} does not support dType ${t}.`);
      return db(e, 0, i, t, this.seed);
    } else {
      let i = Math.sqrt(3 * a);
      return Ml(e, -i, i, t);
    }
  }
  getConfig() {
    return { scale: this.scale, mode: this.mode, distribution: this.distribution, seed: this.seed };
  }
};
xn.className = "VarianceScaling";
ae.registerClass(xn);
var Tp = class extends xn {
  constructor(e) {
    super({ scale: 1, mode: "fanAvg", distribution: "uniform", seed: e == null ? null : e.seed });
  }
  getClassName() {
    return xn.className;
  }
};
Tp.className = "GlorotUniform";
ae.registerClass(Tp);
var $p = class extends xn {
  constructor(e) {
    super({ scale: 1, mode: "fanAvg", distribution: "normal", seed: e == null ? null : e.seed });
  }
  getClassName() {
    return xn.className;
  }
};
$p.className = "GlorotNormal";
ae.registerClass($p);
var _p = class extends xn {
  constructor(e) {
    super({ scale: 2, mode: "fanIn", distribution: "normal", seed: e == null ? null : e.seed });
  }
  getClassName() {
    return xn.className;
  }
};
_p.className = "HeNormal";
ae.registerClass(_p);
var Ap = class extends xn {
  constructor(e) {
    super({ scale: 2, mode: "fanIn", distribution: "uniform", seed: e == null ? null : e.seed });
  }
  getClassName() {
    return xn.className;
  }
};
Ap.className = "HeUniform";
ae.registerClass(Ap);
var Ep = class extends xn {
  constructor(e) {
    super({ scale: 1, mode: "fanIn", distribution: "normal", seed: e == null ? null : e.seed });
  }
  getClassName() {
    return xn.className;
  }
};
Ep.className = "LeCunNormal";
ae.registerClass(Ep);
var Rp = class extends xn {
  constructor(e) {
    super({ scale: 1, mode: "fanIn", distribution: "uniform", seed: e == null ? null : e.seed });
  }
  getClassName() {
    return xn.className;
  }
};
Rp.className = "LeCunNormal";
ae.registerClass(Rp);
var Ob = class extends ns {
  constructor(e) {
    if (super(), this.DEFAULT_GAIN = 1, this.gain = e.gain == null ? this.DEFAULT_GAIN : e.gain, this.seed = e.seed, this.seed != null)
      throw new Fe("Random seed is not implemented for Orthogonal Initializer yet.");
  }
  apply(e, t) {
    return j(() => {
      if (e.length < 2)
        throw new Fe("Shape must be at least 2D.");
      e[0] * e[1] > 2e3 && console.warn(`Orthogonal initializer is being called on a matrix with more than 2000 (${e[0] * e[1]}) elements: Slowness may result.`);
      let n = e[0] > e[1] ? [e[1], e[0]] : e, s = Cp(n, 0, 1, "float32"), r = VO.gramSchmidt(s);
      return e[0] > e[1] && (r = qe(r)), V(this.gain, r);
    });
  }
  getConfig() {
    return { gain: this.gain, seed: this.seed };
  }
};
Ob.className = "Orthogonal";
ae.registerClass(Ob);
var _x = { constant: "Constant", glorotNormal: "GlorotNormal", glorotUniform: "GlorotUniform", heNormal: "HeNormal", heUniform: "HeUniform", identity: "Identity", leCunNormal: "LeCunNormal", leCunUniform: "LeCunUniform", ones: "Ones", orthogonal: "Orthogonal", randomNormal: "RandomNormal", randomUniform: "RandomUniform", truncatedNormal: "TruncatedNormal", varianceScaling: "VarianceScaling", zeros: "Zeros" };
function Ax(e, t = {}) {
  return Ll(e, ae.SerializationMap.getMap().classNameMap, t, "initializer");
}
function yt(e) {
  return wb(e);
}
function ht(e) {
  if (typeof e == "string") {
    let t = e in _x ? _x[e] : e;
    if (t === "GlorotNormal")
      return new $p();
    if (t === "GlorotUniform")
      return new Tp();
    if (t === "HeNormal")
      return new _p();
    if (t === "HeUniform")
      return new Ap();
    if (t === "LeCunNormal")
      return new Ep();
    if (t === "LeCunUniform")
      return new Rp();
    {
      let n = {};
      return n.className = t, n.config = {}, Ax(n);
    }
  } else
    return e instanceof ns ? e : Ax(e);
}
function hL() {
  return new _b();
}
function fL() {
  return new Np();
}
function mL(e) {
  return new Ab(e);
}
function gL(e) {
  return new Eb(e);
}
function bL(e) {
  return new Rb(e);
}
function yL(e) {
  return new Db(e);
}
function vL(e) {
  return new Fb(e);
}
function xL(e) {
  return new xn(e);
}
function wL(e) {
  return new Tp(e);
}
function kL(e) {
  return new $p(e);
}
function IL(e) {
  return new _p(e);
}
function SL(e) {
  return new Ap(e);
}
function CL(e) {
  return new Ep(e);
}
function NL(e) {
  return new Rp(e);
}
function TL(e) {
  return new Ob(e);
}
var $L = {};
Ae($L, { Layer: () => Ge, RNN: () => Ar, RNNCell: () => ql, activation: () => cV, add: () => vV, alphaDropout: () => nW, average: () => xV, averagePooling1d: () => Hy, averagePooling2d: () => qy, averagePooling3d: () => jy, avgPool1d: () => _V, avgPool2d: () => EV, avgPool3d: () => DV, avgPooling1d: () => AV, avgPooling2d: () => RV, avgPooling3d: () => FV, batchNormalization: () => NV, bidirectional: () => KV, concatenate: () => wV, conv1d: () => tV, conv2d: () => nV, conv2dTranspose: () => sV, conv3d: () => rV, conv3dTranspose: () => aV, convLstm2d: () => GV, convLstm2dCell: () => HV, cropping2D: () => oV, dense: () => dV, depthwiseConv2d: () => lV, dot: () => CV, dropout: () => pV, elu: () => XB, embedding: () => yV, flatten: () => fV, gaussianDropout: () => tW, gaussianNoise: () => eW, globalAveragePooling1d: () => OV, globalAveragePooling2d: () => PV, globalMaxPool1d: () => YV, globalMaxPool2d: () => QV, globalMaxPooling1d: () => GS, globalMaxPooling2d: () => HS, gru: () => MV, gruCell: () => LV, input: () => OB, inputLayer: () => KB, layerNormalization: () => TV, leakyReLU: () => QB, lstm: () => BV, lstmCell: () => VV, masking: () => sW, maxPool1d: () => ZV, maxPool2d: () => JV, maxPooling1d: () => qS, maxPooling2d: () => jS, maxPooling3d: () => zV, maximum: () => kV, minimum: () => IV, multiply: () => SV, permute: () => bV, prelu: () => ZB, reLU: () => YB, repeatVector: () => mV, reshape: () => gV, rnn: () => qV, separableConv2d: () => iV, simpleRNN: () => WV, simpleRNNCell: () => UV, softmax: () => JB, spatialDropout1d: () => hV, stackedRNNCells: () => jV, thresholdedReLU: () => eV, timeDistributed: () => XV, upSampling2d: () => uV, zeroPadding2d: () => $V });
var _L = 0;
function YI() {
  return _L++;
}
var Hc = {};
function Dp(e = "") {
  return e in Hc || (Hc[e] = 0), Hc[e] += 1, e + Hc[e].toString();
}
function ym(e) {
  return Array.isArray(e) && Array.isArray(e[0]);
}
function Sd(e) {
  return e.length === 0 ? [] : Array.isArray(e[0]) ? e : [e];
}
function Oe(e) {
  let t;
  if (Array.isArray(e)) {
    if (e.length !== 1)
      throw new U(`Expected Tensor length to be 1; got ${e.length}`);
    t = e[0];
  } else
    t = e;
  return t;
}
function nt(e) {
  if (Array.isArray(e) && Array.isArray(e[0])) {
    if (e.length === 1)
      return e = e, e[0];
    throw new U(`Expected exactly 1 Shape; got ${e.length}`);
  } else
    return e;
}
function Cd(e) {
  let t = 0;
  for (let n of e)
    n.shape.length === 0 ? t += 1 : t += n.shape.reduce((s, r) => s * r);
  return t;
}
var Ex = "Variable";
var AL = class {
  constructor(e, t = "float32", n = Ex, s = true, r = null) {
    this.dtype = t == null ? "float32" : t, this.shape = e.shape, this.id = YI(), n = n == null ? Ex : n, this.originalName = HI(n), this.name = qI(this.originalName), this.trainable_ = s, this.constraint = r, this.val = U3(e, this.trainable_, this.name, this.dtype);
  }
  read() {
    return this.assertNotDisposed(), this.val;
  }
  write(e) {
    return this.assertNotDisposed(), EL(this.val, e), this.val.id !== e.id && (this.val.assign(e), this.constraint != null && this.val.assign(this.constraint.apply(this.val))), this;
  }
  dispose() {
    this.assertNotDisposed(), this.val.dispose();
  }
  assertNotDisposed() {
    if (this.val.isDisposed)
      throw new Error(`LayersVariable ${this.name} is already disposed.`);
  }
  get trainable() {
    return this.trainable_;
  }
  set trainable(e) {
    this.trainable_ = e, this.val.trainable = e;
  }
};
function EL(e, t) {
  if (e.shape.toString() !== t.shape.toString())
    throw new Error("Shape mismatch: " + JSON.stringify(e.shape) + " vs. " + JSON.stringify(t.shape));
}
function vm(e) {
  return e.map((t) => t.read());
}
function Pb(e) {
  e.forEach((t) => {
    t[0].write(t[1]);
  });
}
var Dt = class {
  constructor(e) {
    this.dtype = e.dtype, this.shape = e.shape, e.shape != null ? this.ndim = e.shape.length : this.ndim = e.ndim, this.maxNDim = e.maxNDim, this.minNDim = e.minNDim, this.axes = e.axes || {};
  }
};
var $s = class {
  constructor(e, t, n, s, r, a, i) {
    this.dtype = e, this.shape = t, this.sourceLayer = n, this.inputs = s, this.callArgs = r, this.outputTensorIndex = i, this.id = YI(), a != null && (this.originalName = HI(a), this.name = qI(this.originalName)), this.rank = t.length;
  }
};
var RL = 0;
var Fp = class {
  constructor(e, t) {
    this.callArgs = t, this.id = RL++, this.outboundLayer = e.outboundLayer, this.inboundLayers = e.inboundLayers, this.nodeIndices = e.nodeIndices, this.tensorIndices = e.tensorIndices, this.inputTensors = e.inputTensors, this.outputTensors = e.outputTensors, this.inputMasks = e.inputMasks, this.outputMasks = e.outputMasks, this.inputShapes = e.inputShapes, this.outputShapes = e.outputShapes;
    for (let n of e.inboundLayers)
      n != null && n.outboundNodes.push(this);
    e.outboundLayer.inboundNodes.push(this);
  }
  getConfig() {
    let e = [];
    for (let t of this.inboundLayers)
      t != null ? e.push(t.name) : e.push(null);
    return { outboundLayer: this.outboundLayer ? this.outboundLayer.name : null, inboundLayers: e, nodeIndices: this.nodeIndices, tensorIndices: this.tensorIndices };
  }
};
var DL = 0;
var Ge = class extends ae.Serializable {
  constructor(e = {}) {
    super(), this._callHook = null, this._addedWeightNames = [], this._stateful = false, this.id = DL++, this.activityRegularizer = null, this.inputSpec = null, this.supportsMasking = false, this._trainableWeights = [], this._nonTrainableWeights = [], this._losses = [], this._updates = [], this._built = false, this.inboundNodes = [], this.outboundNodes = [];
    let t = e.name;
    if (!t) {
      let n = this.getClassName();
      t = Ws(n) + "_" + Dp(n);
    }
    if (this.name = t, this.trainable_ = e.trainable == null ? true : e.trainable, e.inputShape != null || e.batchInputShape != null) {
      let n;
      if (e.batchInputShape != null)
        n = e.batchInputShape;
      else if (e.inputShape != null) {
        let r = null;
        e.batchSize != null && (r = e.batchSize), n = [r].concat(e.inputShape);
      }
      this.batchInputShape = n;
      let s = e.dtype;
      s == null && (s = e.inputDType), s == null && (s = "float32"), this.dtype = s;
    }
    e.weights != null ? this.initialWeights = e.weights : this.initialWeights = null, this._refCount = null, this.fastWeightInitDuringBuild = false;
  }
  static nodeKey(e, t) {
    return e.name + "_ib-" + t.toString();
  }
  getNodeAtIndex(e, t) {
    if (this.inboundNodes.length === 0)
      throw new hs(`The layer has never been called and thus has no defined ${t}.`);
    if (this.inboundNodes.length <= e)
      throw new U(`Asked to get ${t} at node ${e}, but the layer has only ${this.inboundNodes.length} inbound nodes.`);
    return this.inboundNodes[e];
  }
  getInputAt(e) {
    return bn(this.getNodeAtIndex(e, "input").inputTensors);
  }
  getOutputAt(e) {
    return bn(this.getNodeAtIndex(e, "output").outputTensors);
  }
  get input() {
    if (this.inboundNodes.length > 1)
      throw new Vs(`Layer ${this.name} has multiple inbound nodes, hence the notion of "layer input" is ill-defined. Use \`getInputAt(nodeIndex)\` instead.`);
    if (this.inboundNodes.length === 0)
      throw new Vs(`Layer ${this.name} is not connected, no input to return.`);
    return bn(this.getNodeAtIndex(0, "input").inputTensors);
  }
  get output() {
    if (this.inboundNodes.length === 0)
      throw new Vs(`Layer ${this.name} has no inbound nodes.`);
    if (this.inboundNodes.length > 1)
      throw new Vs(`Layer ${this.name} has multiple inbound nodes, hence the notion of "layer output" is ill-defined. Use \`getOutputAt(nodeIndex)\` instead.`);
    return bn(this.getNodeAtIndex(0, "output").outputTensors);
  }
  get losses() {
    return this._losses;
  }
  calculateLosses() {
    return this.losses.map((e) => e());
  }
  get updates() {
    return this._updates;
  }
  get built() {
    return this._built;
  }
  set built(e) {
    this._built = e;
  }
  get trainable() {
    return this.trainable_;
  }
  set trainable(e) {
    this._trainableWeights.forEach((t) => t.trainable = e), this.trainable_ = e;
  }
  get trainableWeights() {
    return this.trainable_ ? this._trainableWeights.filter((e) => e.trainable) : [];
  }
  set trainableWeights(e) {
    this._trainableWeights = e;
  }
  get nonTrainableWeights() {
    return this.trainable ? this._trainableWeights.filter((e) => !e.trainable).concat(this._nonTrainableWeights) : this._trainableWeights.concat(this._nonTrainableWeights);
  }
  set nonTrainableWeights(e) {
    this._nonTrainableWeights = e;
  }
  get weights() {
    return this.trainableWeights.concat(this.nonTrainableWeights);
  }
  get stateful() {
    return this._stateful;
  }
  resetStates() {
    if (!this.stateful)
      throw new Error("Cannot call the resetStates() method of a non-stateful Layer object.");
  }
  assertInputCompatibility(e) {
    if (e = dt(e), this.inputSpec == null || this.inputSpec.length === 0)
      return;
    let t = dt(this.inputSpec);
    if (e.length !== t.length)
      throw new U(`Layer ${this.name} expects ${t.length} inputs, but it received ${e.length} input tensors. Input received: ${e}`);
    for (let n = 0; n < e.length; n++) {
      let s = e[n], r = t[n];
      if (r == null)
        continue;
      let a = s.rank;
      if (r.ndim != null && a !== r.ndim)
        throw new U(`Input ${n} is incompatible with layer ${this.name}: expected ndim=${r.ndim}, found ndim=${a}`);
      if (r.maxNDim != null && a > r.maxNDim)
        throw new U(`Input ${n} is incompatible with layer ${this.name}: expected max_ndim=${r.maxNDim}, found ndim=${a}`);
      if (r.minNDim != null && a < r.minNDim)
        throw new U(`Input ${n} is incompatible with layer ${this.name}: expected min_ndim=${r.minNDim}, found ndim=${a}.`);
      if (r.dtype != null && s.dtype !== r.dtype)
        throw new U(`Input ${n} is incompatible with layer ${this.name} : expected dtype=${r.dtype}, found dtype=${s.dtype}.`);
      if (r.axes) {
        let i = s.shape;
        for (let o in r.axes) {
          let u = Number(o), l = r.axes[o], c = u >= 0 ? i[u] : i[i.length + u];
          if (l != null && [l, null].indexOf(c) === -1)
            throw new U(`Input ${n} is incompatible with layer ${this.name}: expected axis ${u} of input shape to have value ${l} but got shape ${i}.`);
        }
      }
      if (r.shape != null)
        for (let i = 0; i < r.shape.length; ++i) {
          let o = r.shape[i], u = s.shape[i];
          if (o != null && u != null && o !== u)
            throw new U(`Input ${n} is incompatible with layer ${this.name}: expected shape=${r.shape}, found shape=${s.shape}.`);
        }
    }
  }
  call(e, t) {
    return e;
  }
  invokeCallHook(e, t) {
    this._callHook != null && this._callHook(e, t);
  }
  setCallHook(e) {
    this._callHook = e;
  }
  clearCallHook() {
    this._callHook = null;
  }
  apply(e, t) {
    t = t || {}, this.assertNotDisposed();
    let n = dt(e), s = true;
    for (let a of n)
      if (!(a instanceof $s)) {
        s = false;
        break;
      }
    let r = true;
    for (let a of n)
      if (a instanceof $s) {
        r = false;
        break;
      }
    if (s === r)
      throw new U("Arguments to apply() must be all SymbolicTensors or all Tensors");
    return ea(this.name, () => {
      if (!this.built) {
        this.assertInputCompatibility(e);
        let a = [];
        for (let i of dt(e))
          a.push(i.shape);
        this.build(bn(a)), this.built = true, this.initialWeights && this.setWeights(this.initialWeights), this._refCount === null && r && (this._refCount = 1);
      }
      if (this.assertInputCompatibility(e), r) {
        let a = this.call(e, t), i = dt(a), o = [];
        for (let u of i)
          n.indexOf(u) !== -1 && (u = u.clone()), o.push(u);
        if (a = bn(o), this.activityRegularizer != null)
          throw new Fe("Layer invocation in the presence of activity regularizer(s) is not supported yet.");
        return a;
      } else {
        let a = FL(e), i = this.computeOutputShape(a), o, u = OL(e);
        if (this.warnOnIncompatibleInputShape(Array.isArray(e) ? a[0] : a), i != null && i.length > 0 && Array.isArray(i[0]) ? o = i.map((l, c) => new $s(u, l, this, dt(e), t, this.name, c)) : o = new $s(u, i, this, dt(e), t, this.name), this.addInboundNode(e, o, null, null, a, i, t), this._refCount++, this.activityRegularizer != null)
          throw new Fe("Layer invocation in the presence of activity regularizer(s) is not supported yet.");
        return o;
      }
    });
  }
  warnOnIncompatibleInputShape(e) {
    if (this.batchInputShape != null)
      if (e.length !== this.batchInputShape.length)
        console.warn(`The rank of the input tensor provided (shape: ${JSON.stringify(e)}) does not match that of the batchInputShape (${JSON.stringify(this.batchInputShape)}) of the layer ${this.name}`);
      else {
        let t = false;
        this.batchInputShape.forEach((n, s) => {
          n != null && e[s] != null && e[s] !== n && (t = true);
        }), t && console.warn(`The shape of the input tensor (${JSON.stringify(e)}) does not match the expectation of layer ${this.name}: ${JSON.stringify(this.batchInputShape)}`);
      }
  }
  get outputShape() {
    if (this.inboundNodes == null || this.inboundNodes.length === 0)
      throw new Vs(`The layer ${this.name} has never been called and thus has no defined output shape.`);
    let e = [];
    for (let t of this.inboundNodes) {
      let n = JSON.stringify(t.outputShapes);
      e.indexOf(n) === -1 && e.push(n);
    }
    if (e.length === 1) {
      let t = this.inboundNodes[0].outputShapes;
      return Array.isArray(t) && Array.isArray(t[0]) && t.length === 1 ? t[0] : t;
    } else
      throw new Vs(`The layer ${this.name} has multiple inbound nodes with different output shapes. Hence the notion of "output shape" is ill-defined for the layer.`);
  }
  countParams() {
    if (!this.built)
      throw new hs(`You tried to call countParams() on ${this.name}, but the layer is not built yet. Build it first by calling build(batchInputShape).`);
    return Cd(this.weights);
  }
  build(e) {
    this.built = true;
  }
  getWeights(e = false) {
    return vm(e ? this.trainableWeights : this.weights);
  }
  setWeights(e) {
    j(() => {
      let t = this.weights;
      if (t.length !== e.length)
        throw new U(`You called setWeights(weights) on layer "${this.name}" with a weight list of length ${e.length}, but the layer was expecting ${t.length} weights. Provided weights: ${e}...`);
      if (t.length === 0)
        return;
      let n = [], s = vm(t);
      for (let r = 0; r < s.length; ++r) {
        let a = s[r], i = t[r], o = e[r];
        if (!w.arraysEqual(a.shape, o.shape))
          throw new U(`Layer weight shape ${a.shape} not compatible with provided weight shape ${o.shape}`);
        n.push([i, o]);
      }
      Pb(n);
    });
  }
  addWeight(e, t, n, s, r, a, i, o) {
    if (this._addedWeightNames.indexOf(e) !== -1)
      throw new U(`Duplicate weight name ${e} for layer ${this.name}`);
    this._addedWeightNames.push(e), n == null && (n = "float32"), this.fastWeightInitDuringBuild && (s = o != null ? o() : ht("zeros"));
    let u = s.apply(t, n), l = new AL(u, n, e, a, i);
    return u.dispose(), r != null && this.addLoss(() => r.apply(l.read())), a == null && (a = true), a ? this._trainableWeights.push(l) : this._nonTrainableWeights.push(l), l;
  }
  setFastWeightInitDuringBuild(e) {
    this.fastWeightInitDuringBuild = e;
  }
  addLoss(e) {
    e == null || Array.isArray(e) && e.length === 0 || (e = dt(e), this._losses !== void 0 && this._losses !== null && this.losses.push(...e));
  }
  computeOutputShape(e) {
    return e;
  }
  computeMask(e, t) {
    if (!this.supportsMasking) {
      if (t != null)
        if (Array.isArray(t))
          t.forEach((n) => {
            if (n != null)
              throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`);
          });
        else
          throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`);
      return null;
    }
    return t;
  }
  addInboundNode(e, t, n, s, r, a, i = null) {
    let o = dt(e);
    t = dt(t), n = dt(n), s = dt(s), r = Sd(r), a = Sd(a);
    let u = [], l = [], c = [];
    for (let p of o)
      u.push(p.sourceLayer), l.push(p.nodeIndex), c.push(p.tensorIndex);
    new Fp({ outboundLayer: this, inboundLayers: u, nodeIndices: l, tensorIndices: c, inputTensors: o, outputTensors: t, inputMasks: n, outputMasks: s, inputShapes: r, outputShapes: a }, i);
    for (let p = 0; p < t.length; p++)
      t[p].sourceLayer = this, t[p].nodeIndex = this.inboundNodes.length - 1, t[p].tensorIndex = p;
  }
  getConfig() {
    let e = { name: this.name, trainable: this.trainable };
    return this.batchInputShape != null && (e.batchInputShape = this.batchInputShape), this.dtype != null && (e.dtype = this.dtype), e;
  }
  disposeWeights() {
    return this.weights.forEach((e) => e.dispose()), this.weights.length;
  }
  assertNotDisposed() {
    if (this._refCount === 0)
      throw new Error(`Layer '${this.name}' is already disposed.`);
  }
  dispose() {
    if (!this.built)
      throw new Error(`Cannot dispose Layer ${this.name} because it has not been built yet.`);
    if (this._refCount === null)
      throw new Error(`Cannot dispose Layer ${this.name} because it has not been used yet.`);
    this.assertNotDisposed();
    let e = 0;
    return --this._refCount === 0 && (e = this.disposeWeights()), { refCountAfterDispose: this._refCount, numDisposedVariables: e };
  }
};
function FL(e) {
  e = dt(e);
  let t = [];
  for (let n of e)
    t.push(n.shape);
  return bn(t);
}
function OL(e) {
  return "float32";
}
function QI(e, t, n) {
  if ((t == null || n != null && n > 0) && (t = e.sourceLayer, n = e.nodeIndex), t.inboundNodes.length === 0)
    return [e];
  {
    let s = t.inboundNodes[n];
    if (s.inboundLayers.length === 0)
      return s.inputTensors;
    {
      let r = [];
      for (let a = 0; a < s.inboundLayers.length; a++) {
        let i = s.inputTensors[a], o = s.inboundLayers[a], u = s.nodeIndices[a], l = QI(i, o, u);
        for (let c of l)
          r.indexOf(c) === -1 && r.push(c);
      }
      return r;
    }
  }
}
var Qo = class extends Ge {
  constructor(e) {
    if (super({ dtype: e.dtype, name: e.name != null ? e.name : Dp("input").toString() }), e.batchSize == null && (e.batchSize = null), e.sparse == null && (e.sparse = false), this.trainable = false, this.built = true, this.sparse = e.sparse, e.inputShape != null && e.batchInputShape != null)
      throw new U("Only provide the inputShape OR batchInputShape argument to inputLayer, not both at the same time.");
    let t = e.batchInputShape;
    if (t == null) {
      if (e.inputShape == null)
        throw new U("An InputLayer should be passed either a `batchInputShape` or an `inputShape`.");
      t = [e.batchSize].concat(e.inputShape);
    } else if (e.batchSize != null)
      throw new U("Cannot specify batchSize if batchInputShape is specified when creating an InputLayer.");
    let n = e.dtype || "float32";
    this.batchInputShape = t, this.dtype = n, this.inputSpec = [{ shape: t }];
    let s = new $s(this.dtype, this.batchInputShape, this, [], {}, this.name);
    s.nodeIndex = 0, s.tensorIndex = 0, new Fp({ outboundLayer: this, inboundLayers: [], nodeIndices: [], tensorIndices: [], inputTensors: [s], outputTensors: [s], inputMasks: [null], outputMasks: [null], inputShapes: [t], outputShapes: [t] });
  }
  apply(e, t) {
    throw new U(`Cannot pass any input to an InputLayer's apply() method. InputLayer name: ${this.name}`);
  }
  dispose() {
    return { refCountAfterDispose: this._refCount, numDisposedVariables: 0 };
  }
  getConfig() {
    return { batchInputShape: this.batchInputShape, dtype: this.dtype, sparse: this.sparse, name: this.name };
  }
};
Qo.className = "InputLayer";
ae.registerClass(Qo);
function ZI(e) {
  if (e.batchShape == null && e.shape == null)
    throw new Error("Please provide to Input either a `shape` or a `batchShape` argument. Note that `shape` does not include the batch dimension.");
  if (e.batchShape != null && e.shape != null)
    throw new U("Please provide either a `shape` or `batchShape` argument to Input, but not both.");
  let t = e.batchShape;
  e.shape != null && t == null && (t = [null].concat(e.shape));
  let n = e.dtype;
  return n == null && (n = "float32"), new Qo({ batchInputShape: t, name: e.name, dtype: n, sparse: e.sparse }).inboundNodes[0].outputTensors[0];
}
async function rr(e) {
  if (e == null)
    return;
  let t = [], n = [], s = [];
  for (let r in e) {
    let a = e[r];
    if (typeof a != "number") {
      let i = a;
      t.push(i.data()), n.push(r), s.push(i);
    }
  }
  if (t.length > 0) {
    let r = await Promise.all(t);
    for (let a = 0; a < r.length; ++a)
      e[n[a]] = r[a][0];
    Re(s);
  }
}
function JI(e) {
  if (e != null)
    for (let t in e) {
      let n = e[t];
      typeof n != "number" && n.dispose();
    }
}
var PL = 125;
var Ji = class {
  constructor() {
    this.validationData = null;
  }
  setParams(e) {
    this.params = e;
  }
  async onEpochBegin(e, t) {
  }
  async onEpochEnd(e, t) {
  }
  async onBatchBegin(e, t) {
  }
  async onBatchEnd(e, t) {
  }
  async onTrainBegin(e) {
  }
  async onTrainEnd(e) {
  }
  setModel(e) {
  }
};
var zL = class {
  constructor(e, t = 10) {
    e == null && (e = []), this.callbacks = e, this.queueLength = t;
  }
  append(e) {
    this.callbacks.push(e);
  }
  setParams(e) {
    for (let t of this.callbacks)
      t.setParams(e);
  }
  setModel(e) {
    for (let t of this.callbacks)
      t.setModel(e);
  }
  async onEpochBegin(e, t) {
    t == null && (t = {});
    for (let n of this.callbacks)
      await n.onEpochBegin(e, t);
  }
  async onEpochEnd(e, t) {
    t == null && (t = {});
    for (let n of this.callbacks)
      await n.onEpochEnd(e, t);
  }
  async onBatchBegin(e, t) {
    t == null && (t = {});
    for (let n of this.callbacks)
      await n.onBatchBegin(e, t);
  }
  async onBatchEnd(e, t) {
    t == null && (t = {});
    for (let n of this.callbacks)
      await n.onBatchEnd(e, t);
  }
  async onTrainBegin(e) {
    e == null && (e = {});
    for (let t of this.callbacks)
      await t.onTrainBegin(e);
  }
  async onTrainEnd(e) {
    e == null && (e = {});
    for (let t of this.callbacks)
      await t.onTrainEnd(e);
  }
};
var ML = class extends Ji {
  constructor() {
    super();
  }
  async onEpochBegin(e) {
    this.seen = 0, this.totals = {};
  }
  async onBatchEnd(e, t) {
    t == null && (t = {});
    let n = t.size == null ? 0 : t.size;
    this.seen += n;
    for (let s in t) {
      let r = t[s];
      if (typeof r == "number")
        this.totals.hasOwnProperty(s) || (this.totals[s] = 0), this.totals[s] = this.totals[s] + r * n;
      else {
        let a;
        s in this.totals ? a = this.totals[s] : this.totals[s] = 0;
        let i = j(() => ie(this.totals[s], V(r, n)));
        this.totals[s] = i, a != null && a.dispose();
      }
    }
  }
  async onEpochEnd(e, t) {
    if (t != null)
      for (let n of this.params.metrics)
        this.totals[n] != null && (typeof this.totals[n] == "number" ? t[n] = this.totals[n] / this.seen : j(() => {
          let s = V(xe(1, this.seen), this.totals[n]);
          t[n] = s, this.totals[n].dispose(), Ht(t[n]);
        }));
  }
};
var LL = class extends Ji {
  async onTrainBegin(e) {
    this.epoch = [], this.history = {};
  }
  async onEpochEnd(e, t) {
    t == null && (t = {}), this.epoch.push(e);
    for (let n in t)
      this.history[n] == null && (this.history[n] = []), this.history[n].push(t[n]);
  }
  async syncData() {
    let e = [], t = [], n = [];
    for (let r in this.history) {
      let a = this.history[r];
      for (let i = 0; i < a.length; ++i)
        if (typeof a[i] != "number") {
          let o = a[i];
          e.push(o.data()), t.push(r), n.push(i);
        }
    }
    let s = await Promise.all(e);
    for (let r = 0; r < s.length; ++r)
      this.history[t[r]][n[r]].dispose(), this.history[t[r]][n[r]] = s[r][0];
  }
};
var BL = class extends Ji {
  constructor(e, t) {
    if (super(), this.currentEpoch = 0, this.nowFunc = e.nowFunc, this.nextFrameFunc = e.nextFrameFunc || OI, this.yieldEvery = t || "auto", this.yieldEvery === "auto" && (this.yieldEvery = PL), this.yieldEvery === "never" && e.onYield != null)
      throw new Error("yieldEvery is `never` but you provided an `onYield` callback. Either change `yieldEvery` or remove the callback");
    w.isNumber(this.yieldEvery) && (this.maybeWait = VM(this.maybeWait.bind(this), this.yieldEvery, this.nowFunc)), this.trainBegin = e.onTrainBegin, this.trainEnd = e.onTrainEnd, this.epochBegin = e.onEpochBegin, this.epochEnd = e.onEpochEnd, this.batchBegin = e.onBatchBegin, this.batchEnd = e.onBatchEnd, this.yield = e.onYield;
  }
  async maybeWait(e, t, n) {
    let s = [];
    this.yield != null && (await rr(n), s.push(this.yield(e, t, n))), s.push(this.nextFrameFunc()), await Promise.all(s);
  }
  async onEpochBegin(e, t) {
    this.currentEpoch = e, this.epochBegin != null && (await rr(t), await this.epochBegin(e, t));
  }
  async onEpochEnd(e, t) {
    let n = [];
    this.epochEnd != null && (await rr(t), n.push(this.epochEnd(e, t))), this.yieldEvery === "epoch" && n.push(this.nextFrameFunc()), await Promise.all(n);
  }
  async onBatchBegin(e, t) {
    this.batchBegin != null && (await rr(t), await this.batchBegin(e, t));
  }
  async onBatchEnd(e, t) {
    let n = [];
    this.batchEnd != null && (await rr(t), n.push(this.batchEnd(e, t))), this.yieldEvery === "batch" ? n.push(this.nextFrameFunc()) : w.isNumber(this.yieldEvery) && n.push(this.maybeWait(this.currentEpoch, e, t)), await Promise.all(n);
  }
  async onTrainBegin(e) {
    this.trainBegin != null && (await rr(e), await this.trainBegin(e));
  }
  async onTrainEnd(e) {
    this.trainEnd != null && (await rr(e), await this.trainEnd(e));
  }
};
function eS(e, t) {
  return e == null && (e = {}), e instanceof Ji ? [e] : Array.isArray(e) && e[0] instanceof Ji ? e : dt(e).map((s) => new BL(s, t));
}
var ks = class {
  constructor() {
  }
  static registerCallbackConstructor(e, t) {
    w.assert(e >= 0 && Number.isInteger(e), () => `Verbosity level is expected to be an integer >= 0, but got ${e}`), ks.checkForDuplicate(t), ks.constructors[e] == null && (ks.constructors[e] = []), ks.constructors[e].push(t);
  }
  static checkForDuplicate(e) {
    for (let t in ks.constructors)
      ks.constructors[+t].forEach((s) => {
        if (s === e)
          throw new U("Duplicate callback constructor.");
      });
  }
  static clear() {
    ks.constructors = {};
  }
  static createCallbacks(e) {
    let t = [];
    for (let n in ks.constructors) {
      let s = +n;
      e >= s && t.push(...ks.constructors[s]);
    }
    return t.map((n) => new n());
  }
};
var zb = ks;
zb.constructors = {};
function tS(e, t, n, s, r, a, i, o, u) {
  let l = new LL(), c = [new ML(), ...zb.createCallbacks(t)];
  e != null && c.push(...e), c.push(l);
  let p = new zL(c);
  return p.setParams({ epochs: n, initialEpoch: s, samples: r, steps: a, batchSize: i, verbose: t, doValidation: o, metrics: u }), { callbackList: p, history: l };
}
function ms(e, t = {}, n = false) {
  return Ll(e, ae.SerializationMap.getMap().classNameMap, t, "layer", n);
}
function Nd(e, t) {
  return j(() => {
    e.dtype !== "float32" && (e = ce(e, "float32"));
    let n = ve(Wl(e), t, true), s = Pl(n.shape, Rt()), r = dn($r(n, s));
    return xe(e, r);
  });
}
function gi(e, t) {
  return j(() => St(Wl(ge(t, e)), -1));
}
function Op(e, t) {
  return j(() => St(Mt(ge(t, e)), -1));
}
function Zo(e, t) {
  return j(() => {
    let n = ge(e, t), s = Vn(Mt(e), Rt(), Number.MAX_VALUE), r = Mt(xe(n, s));
    return V(100, St(r, -1));
  });
}
function VL(e, t) {
  return j(() => {
    let n = Vn(t, Rt(), Number.MAX_VALUE), s = Yn(ie(1, n)), r = Vn(e, Rt(), Number.MAX_VALUE), a = Yn(ie(1, r));
    return St(Wl(ge(s, a)), -1);
  });
}
function WL(e, t) {
  return j(() => {
    let n = $r(0, ge(1, V(e, t)));
    return St(Wl(n), -1);
  });
}
function UL(e, t) {
  return j(() => {
    let n = $r(0, ge(1, V(e, t)));
    return St(n, -1);
  });
}
function GL(e, t) {
  return j(() => {
    let n = ve(V(e, t), -1), s = As(V(ge(1, e), t), -1);
    return $r(0, ie(1, ge(s, n)));
  });
}
function HL(e, t) {
  return j(() => {
    let n = Math.log(2), s = ge(t, e), r = ge(ie(s, zl(V(-2, s))), n);
    return St(r, -1);
  });
}
function Qu(e, t, n = false) {
  return j(() => {
    if (n)
      t = ub(t);
    else {
      let s = ve(t, t.shape.length - 1, true);
      t = xe(t, s);
    }
    return t = Vn(t, Rt(), 1 - Rt()), kt(ve(V(ce(e, "float32"), Yn(t)), t.shape.length - 1));
  });
}
function Td(e, t, n = false) {
  return j(() => {
    let s = ce(mp(sL(e)), "int32");
    t = Vn(t, Rt(), 1 - Rt());
    let r = t.shape, a = G(vd(s, r[r.length - 1]), r);
    return Qu(a, t, n);
  });
}
function qL(e, t) {
  if (!w.arraysEqual(e.shape, t.shape))
    throw new U(`logits and labels must have the same shape, but got shapes ${JSON.stringify(e.shape)} and ${JSON.stringify(t.shape)}`);
  return j(() => {
    let n = Xs(t), s = kt(Mt(t));
    return ie(ge(n, V(t, e)), Yg(Xn(s)));
  });
}
function Pp(e, t) {
  return j(() => {
    let n;
    return n = Vn(t, Rt(), 1 - Rt()), n = Yn(xe(n, ge(1, n))), St(qL(e, n), -1);
  });
}
function jL(e, t) {
  return j(() => {
    let n = Vn(e, Rt(), 1), s = Vn(t, Rt(), 1);
    return ve(V(e, Yn(xe(n, s))), -1);
  });
}
function KL(e, t) {
  return j(() => {
    let n = Yn(ie(Rt(), t));
    return St(ge(t, V(e, n)), -1);
  });
}
function Mb(e, t) {
  return j(() => {
    let n = Nd(e, -1), s = Nd(t, -1), r = V(n, s);
    return kt(ve(r, -1));
  });
}
var $d = { meanSquaredError: gi, meanAbsoluteError: Op, meanAbsolutePercentageError: Zo, meanSquaredLogarithmicError: VL, squaredHinge: WL, hinge: UL, categoricalHinge: GL, logcosh: HL, categoricalCrossentropy: Qu, sparseCategoricalCrossentropy: Td, binaryCrossentropy: Pp, kullbackLeiblerDivergence: jL, poisson: KL, cosineProximity: Mb };
function Wf(e) {
  if (typeof e == "string") {
    if (e in $d)
      return $d[e];
    let t = `Unknown loss ${e}`;
    throw e.toLowerCase().includes("softmaxcrossentropy") && (t = `Unknown loss ${e}. Use "categoricalCrossentropy" as the string name for tf.losses.softmaxCrossEntropy`), new U(t);
  } else
    return e;
}
function Lb(e, t) {
  return j(() => {
    let n = V(0.5, Qn(t)), s = Sp(Wn(t, n), e.dtype);
    return St(Kn(e, s), -1);
  });
}
function Bb(e, t) {
  return j(() => Sp(Kn(Hu(e, -1), Hu(t, -1)), "float32"));
}
function nS(e, t) {
  return j(() => ce(ve(Ds(Kn(e, 1), Kn(t, 1))), "float32"));
}
function XL(e, t) {
  return j(() => ce(ve(Ds(Kn(e, 1), Kn(t, 0))), "float32"));
}
function YL(e, t) {
  return j(() => ce(ve(Ds(Kn(e, 0), Kn(t, 1))), "float32"));
}
function sS(e, t) {
  return j(() => {
    let n = nS(e, t), s = YL(e, t), r = ie(n, s);
    return ce(vn(Wn(r, 0), xe(n, r), 0), "float32");
  });
}
function QL(e, t) {
  return j(() => {
    let n = nS(e, t), s = XL(e, t), r = ie(n, s);
    return ce(vn(Wn(r, 0), xe(n, r), 0), "float32");
  });
}
function rS(e, t) {
  return Pp(e, t);
}
function aS(e, t) {
  return e.rank === t.rank && (e = mr(e, [e.rank - 1])), t = Hu(t, -1), t.dtype !== e.dtype && (t = ce(t, e.dtype)), ce(Kn(e, t), "float32");
}
var ZL = gi;
var JL = gi;
var eB = Op;
var tB = Op;
var nB = Zo;
var sB = Zo;
var Vb = Qu;
var rB = Mb;
var iS = Td;
var _d = { binaryAccuracy: Lb, categoricalAccuracy: Bb, precision: sS, categoricalCrossentropy: Vb, sparseCategoricalCrossentropy: iS, mse: ZL, MSE: JL, mae: eB, MAE: tB, mape: nB, MAPE: sB, cosine: rB };
function aB(e) {
  if (typeof e == "string" && e in _d)
    return _d[e];
  if (typeof e != "string" && e != null)
    return e;
  throw new U(`Unknown metric ${e}`);
}
function qc(e) {
  if (Cs(e !== null, `Unknown LossOrMetricFn ${e}`), typeof e == "string")
    return e;
  {
    let t;
    for (let n of Object.keys($d))
      if ($d[n] === e) {
        t = n;
        break;
      }
    if (t !== void 0)
      return t;
    for (let n of Object.keys(_d))
      if (_d[n] === e) {
        t = n;
        break;
      }
    return t !== void 0 ? t : e.name;
  }
}
function iB(e) {
  let t = { Adagrad: () => Pi.adagrad(0.01), Adadelta: () => Pi.adadelta(1, 0.95, Rt()), Adam: () => Pi.adam(1e-3, 0.9, 0.999, Rt()), Adamax: () => Pi.adamax(2e-3, 0.9, 0.999, Rt(), 0), RMSProp: () => Pi.rmsprop(1e-3, 0.9, 0, Rt()), SGD: () => Pi.sgd(0.01) };
  if (t.adagrad = t.Adagrad, t.adadelta = t.Adadelta, t.adam = t.Adam, t.adamax = t.Adamax, t.rmsprop = t.RMSProp, t.sgd = t.SGD, e in t)
    return t[e]();
  throw new U(`Unknown Optimizer ${e}`);
}
var Rx = 1 * 1024 * 1024;
function Dx(e, t, n = false) {
  if (e == null || typeof e != "object" || Object.getPrototypeOf(e) !== Object.prototype || !xm(e))
    throw new Error("User-defined metadata is expected to be a JSON object, but is not.");
  if (n) {
    let s = JSON.stringify(e);
    s.length > Rx && console.warn(`User-defined metadata of model "${t}" is too large in size (length=${s.length} when serialized). It is not recommended to store such large objects in user-defined metadata. Please make sure its serialized length is <= ${Rx}.`);
  }
}
function xm(e) {
  if (e === null)
    return true;
  if (typeof e == "object")
    if (Object.getPrototypeOf(e) === Object.prototype) {
      let t = Object.keys(e);
      for (let n of t)
        if (typeof n != "string" || !xm(e[n]))
          return false;
      return true;
    } else if (Array.isArray(e)) {
      for (let t of e)
        if (!xm(t))
          return false;
      return true;
    } else
      return false;
  else {
    let t = typeof e;
    return t === "string" || t === "number" || t === "boolean";
  }
}
function oB(e, t, n, s = console.log) {
  let r = lB(e), a = ["Layer (type)", "Input Shape", "Output shape", "Param #"];
  r ? (t = t || 90, n = n || [0.32, 0.61, 0.89, 1]) : (t = t || 115, n = n || [0.24, 0.48, 0.7, 0.8, 1]), n[n.length - 1] <= 1 && (n = n.map((c) => Math.floor(t * c)));
  let i;
  if (!r) {
    a.push("Receives inputs"), i = [];
    for (let c in e.nodesByDepth)
      i.push(...e.nodesByDepth[c]);
  }
  s("_".repeat(t)), Ad(a, n, s), s("=".repeat(t));
  let o = e.layers;
  for (let c = 0; c < o.length; ++c)
    r ? cB(o[c], n, s) : dB(o[c], n, i, s), s((c === o.length - 1 ? "=" : "_").repeat(t));
  e.checkTrainableWeightsConsistency();
  let u = uB(e), l = Cd(e.nonTrainableWeights);
  s(`Total params: ${u + l}`), s(`Trainable params: ${u}`), s(`Non-trainable params: ${l}`), s("_".repeat(t));
}
function uB(e) {
  let t;
  return e.collectedTrainableWeights != null ? t = Cd(e.collectedTrainableWeights) : t = Cd(e.trainableWeights), t;
}
function lB(e) {
  let t = true, n = [], s = [];
  for (let r in e.nodesByDepth)
    n.push(e.nodesByDepth[r]);
  for (let r of n) {
    if (r.length > 1 || r.length === 1 && r[0].inboundLayers.length > 1) {
      t = false;
      break;
    }
    s.push(...r);
  }
  if (t)
    for (let r of e.layers) {
      let a = false;
      for (let i of r.inboundNodes)
        if (s.indexOf(i) !== -1)
          if (a) {
            t = false;
            break;
          } else
            a = true;
      if (!t)
        break;
    }
  return t;
}
function Ad(e, t, n = console.log) {
  let s = "";
  for (let r = 0; r < e.length; ++r)
    r > 0 && (s = s.slice(0, s.length - 1) + " "), s += e[r], s = s.slice(0, t[r]), s += " ".repeat(t[r] - s.length);
  n(s);
}
function cB(e, t, n) {
  let s, r;
  try {
    r = e.inboundNodes.map((u) => JSON.stringify(u.inputShapes)).join(",");
  } catch (u) {
    r = "multiple";
  }
  try {
    s = JSON.stringify(e.outputShape);
  } catch (u) {
    s = "multiple";
  }
  let a = e.name, i = e.getClassName(), o = [`${a} (${i})`, r, s, e.countParams().toString()];
  Ad(o, t, n);
}
function dB(e, t, n, s) {
  let r, a;
  try {
    a = e.inboundNodes.map((p) => JSON.stringify(p.inputShapes)).join(",");
  } catch (p) {
    a = "multiple";
  }
  try {
    r = JSON.stringify(e.outputShape);
  } catch (p) {
    r = "multiple";
  }
  let i = [];
  for (let p of e.inboundNodes)
    if (!(n != null && n.length > 0 && n.indexOf(p) === -1))
      for (let d = 0; d < p.inboundLayers.length; ++d) {
        let h = p.inboundLayers[d].name, f = p.nodeIndices[d], m = p.tensorIndices[d];
        i.push(`${h}[${f}][${m}]`);
      }
  let o = e.name, u = e.getClassName(), l = i.length === 0 ? "" : i[0], c = [`${o} (${u})`, a, r, e.countParams().toString(), l];
  Ad(c, t, s);
  for (let p = 1; p < i.length; ++p)
    Ad(["", "", "", "", i[p]], t, s);
}
function oS(e, t, n) {
  return (e === "inboundNodes" || e === "outputLayers" || e === "inputLayers") && t === 0 && typeof n == "string";
}
function Zu(e, t) {
  if (e === null)
    return null;
  if (typeof e == "string")
    return Kr(e);
  if (typeof e == "number" || typeof e == "boolean")
    return e;
  if (e instanceof Array) {
    let n = [], s = e.length;
    for (let r = 0; r < s; ++r) {
      let a = e[r];
      oS(t, r, a) ? n.push(a) : n.push(Zu(a, t));
    }
    return n;
  } else {
    let n = {};
    for (let s of Object.keys(e)) {
      let r = e[s];
      if (s === "name" && typeof r == "string")
        n[s] = r;
      else {
        let a = Kr(s);
        n[a] = Zu(r, a);
      }
    }
    return n;
  }
}
function wm(e, t) {
  if (e == null)
    return null;
  if (typeof e == "string")
    return Ws(e);
  if (typeof e == "number" || typeof e == "boolean")
    return e;
  if (e instanceof Array) {
    let n = [], s = e.length;
    for (let r = 0; r < s; ++r) {
      let a = e[r];
      oS(t, r, a) ? n.push(a) : n.push(wm(a, t));
    }
    return n;
  } else {
    let n = {};
    for (let s of Object.keys(e)) {
      let r = e[s], a = Ws(s);
      (s === "name" || s === "className") && typeof r == "string" ? n[a] = r : n[a] = wm(r, s);
    }
    return n;
  }
}
var uS = "0.0.0";
function pB(e, t) {
  if (e.dtype == null || e.dtype === t.dtype)
    return t;
  try {
    return ce(t, e.dtype);
  } catch (n) {
    throw new U(`The dtype of the feed (${t.dtype}) can not be cast to the dtype of the key '${e.name}' (${e.dtype}).`);
  }
}
var Qr = class {
  constructor(e) {
    if (this.id2Value = {}, this.id2Mask = {}, this.name2Id = {}, e instanceof Qr)
      for (let t in e.id2Value)
        this.id2Value[t] = e.id2Value[t], t in e.id2Mask && (this.id2Mask[t] = e.id2Mask[t]);
    else {
      if (e == null)
        return;
      for (let t of e)
        this.add(t.key, t.value);
    }
  }
  add(e, t, n) {
    if (this.id2Value[e.id] == null)
      this.id2Value[e.id] = pB(e, t), this.name2Id[e.name] = e.id, n != null && (this.id2Mask[e.id] = n);
    else
      throw new U(`Duplicate key: name=${e.name}, id=${e.id}`);
    return this;
  }
  addFeed(e) {
    this.add(e.key, e.value);
  }
  hasKey(e) {
    return this.id2Value[e.id] != null;
  }
  names() {
    return Object.keys(this.name2Id);
  }
  getValue(e) {
    if (e instanceof $s) {
      if (this.id2Value[e.id] == null)
        throw new U(`Nonexistent key: ${e.name}`);
      return this.id2Value[e.id];
    } else {
      let t = this.name2Id[e];
      if (t == null)
        throw new U(`Feed dict has no SymbolicTensor name: ${e}`);
      return this.id2Value[t];
    }
  }
  getMask(e) {
    if (e instanceof $s) {
      if (this.id2Value[e.id] == null)
        throw new U(`Nonexistent key: ${e.name}`);
      return this.id2Mask[e.id];
    } else {
      let t = this.name2Id[e];
      if (t == null)
        throw new U(`Feed dict has no SymbolicTensor name: ${e}`);
      return this.id2Mask[t];
    }
  }
  disposeMasks() {
    this.id2Mask != null && Re(this.id2Mask);
  }
};
var Uf = {};
var Fx = {};
function Au(e, t, n, s) {
  let r = n == null ? false : n.training, a = Array.isArray(e), i = a ? e : [e], o = i.map((f) => f.name), u = [], l = t.names();
  for (let f of o)
    l.indexOf(f) !== -1 ? u.push(t.getValue(f)) : u.push(null);
  s != null && (s.maxNumTensors = -1 / 0, s.minNumTensors = 1 / 0);
  let c = o.join(",") + "|" + t.names().join(","), p, d;
  if (Uf[c] == null) {
    let f = hB(i, t);
    p = f.sorted, d = f.recipientCounts, Uf[c] = p, Fx[c] = d;
  }
  p = Uf[c], d = {}, r || Object.assign(d, Fx[c]);
  let h = new Qr(t);
  for (let f = 0; f < p.length; ++f) {
    if (s != null) {
      let A = dm().numTensors;
      A > s.maxNumTensors && (s.maxNumTensors = A), A < s.minNumTensors && (s.minNumTensors = A);
    }
    let m = p[f], g = m.sourceLayer;
    if (g instanceof Qo)
      continue;
    let b = [], y = [], v = [], x = false;
    for (let A of m.inputs) {
      let P = h.getValue(A), R = h.getMask(A);
      b.push(P), y.push(R), R != null && (x = true), r || (d[A.name]--, d[A.name] === 0 && !t.hasKey(A) && o.indexOf(A.name) === -1 && !P.isDisposed && A.sourceLayer.stateful !== true && v.push(P));
    }
    x && (n = n || {}, n.mask = y[0]);
    let k = dt(g.apply(b, n)), T = null;
    g.supportsMasking && (T = g.computeMask(b, y));
    let N = mB(m), E = Array.isArray(N) ? N : [N];
    for (let A = 0; A < E.length; ++A) {
      h.hasKey(E[A]) || h.add(E[A], k[A], Array.isArray(T) ? T[0] : T);
      let P = o.indexOf(E[A].name);
      P !== -1 && (u[P] = k[A]);
    }
    r || Re(v);
  }
  return h.disposeMasks(), a ? u : u[0];
}
function hB(e, t) {
  w.assert(e != null && e.length > 0, () => "Expected at least one fetch, got none");
  let n = [], s = {};
  if (e.length === 1) {
    let r = Ox(e[0], t);
    n = r.sorted, s = r.recipientMap;
  } else {
    let r = /* @__PURE__ */ new Set();
    for (let a of e) {
      let { sorted: i, recipientMap: o } = Ox(a, t);
      for (let u of i)
        r.has(u.name) || (n.push(u), r.add(u.name));
      for (let u in o)
        s[u] == null && (s[u] = /* @__PURE__ */ new Set()), o[u].forEach((l) => s[u].add(l));
    }
  }
  return { sorted: n, recipientCounts: fB(s) };
}
function fB(e) {
  let t = {};
  for (let n in e)
    t[n] = e[n].size;
  return t;
}
function Ox(e, t) {
  let n = /* @__PURE__ */ new Set(), s = [], r = {};
  for (let o of t.names())
    n.add(o);
  let a = [], i = [];
  for (a.push(e); a.length > 0; ) {
    let o = a[a.length - 1];
    if (n.has(o.name)) {
      a.pop();
      continue;
    }
    let u = i[i.length - 1] === a.length - 1;
    if (o.inputs.length === 0 || u)
      a.pop(), s.push(o), n.add(o.name), u && i.pop();
    else {
      i.push(a.length - 1);
      for (let l of o.inputs)
        r[l.name] == null && (r[l.name] = /* @__PURE__ */ new Set()), r[l.name].add(o.name), !n.has(l.name) && a.push(l);
    }
  }
  return { sorted: s, recipientMap: r };
}
function mB(e) {
  let t;
  if (e.sourceLayer.inboundNodes.length === 1)
    t = e.sourceLayer.output;
  else {
    let n = null;
    for (let s = 0; s < e.sourceLayer.inboundNodes.length; ++s)
      for (let r of e.sourceLayer.inboundNodes[s].outputTensors)
        if (r.id === e.id) {
          n = s;
          break;
        }
    t = e.sourceLayer.getOutputAt(n);
  }
  return t;
}
var Is = class extends Ge {
  constructor(e) {
    if (super({}), this.containerNodes = /* @__PURE__ */ new Set(), this.name = e.name, this.name == null) {
      let b = this.getClassName().toLowerCase();
      this.name = Dp(b);
    }
    if (this.supportsMasking = false, this.trainable_ = true, Array.isArray(e.inputs) ? this.inputs = e.inputs.slice() : this.inputs = [e.inputs], Array.isArray(e.outputs) ? this.outputs = e.outputs.slice() : this.outputs = [e.outputs], cr(this.inputs).length !== this.inputs.length)
      throw new U(`The list of inputs passed to the model is redundant. All inputs should only appear once. Found: ${this.inputs.map((b) => b.name)}`);
    cr(this.outputs).length !== this.outputs.length && console.warn(`The list of outputs passed to the model is redundant. All outputs should only appear once. Found: ${this.outputs.map((b) => b.name)}`), this.inputLayers = [], this.inputLayersNodeIndices = [], this.inputLayersTensorIndices = [], this.outputLayers = [], this.outputLayersNodeIndices = [], this.outputLayersTensorIndices = [], this.layers = [], this.internalContainerRefs = [];
    for (let b of this.outputs) {
      let y = b.sourceLayer, v = b.nodeIndex, x = b.tensorIndex;
      this.outputLayers.push(y), this.outputLayersNodeIndices.push(v), this.outputLayersTensorIndices.push(x);
    }
    for (let b of this.inputs) {
      let y = b.sourceLayer, v = b.nodeIndex, x = b.tensorIndex;
      Cs(v === 0, "input layer has >1 nodes"), Cs(x === 0, "input layer has >1 tensors"), this.inputLayers.push(y), this.inputLayersNodeIndices.push(v), this.inputLayersTensorIndices.push(x);
    }
    this.inputNames = [], this.outputNames = [], this.feedInputShapes = [], this.feedInputNames = [], this.feedOutputNames = [];
    for (let b = 0; b < this.inputLayers.length; b++) {
      let y = this.inputLayers[b];
      if (!(y instanceof Qo))
        throw new TypeError(`Input layers to a LayersModel must be InputLayer objects. Received inputs: ${e.inputs}. Input ${b} (0-based) originates from layer type ${y.getClassName()}.`);
      this.inputNames.push(y.name), this.feedInputShapes.push(y.batchInputShape), this.feedInputNames.push(y.name);
    }
    for (let b of this.outputLayers)
      this.outputNames.push(b.name);
    this.internalInputShapes = this.inputs.map((b) => b.shape), this.internalOutputShapes = this.outputs.map((b) => b.shape);
    let t = {}, n = {}, s = {}, r = {}, a = {}, i = [], o = (b, y, v, x, k, T) => {
      (x == null || k == null || T == null) && (x = b.sourceLayer, k = b.nodeIndex, T = b.tensorIndex);
      let N = x.inboundNodes[k];
      if (v.indexOf(N) !== -1)
        throw new hs(`The tensor ${b.name} at layer "${x.name}" is part of a cycle.`);
      if (y.indexOf(N) !== -1)
        return;
      this.containerNodes.add(Is.nodeKey(x, k)), x.id in a || (a[x.id] = Object.keys(a).length), v.indexOf(N) === -1 && v.push(N);
      let E = N.inboundLayers.length;
      for (let A = 0; A < E; A++) {
        let P = N.inputTensors[A], R = N.inboundLayers[A], F = N.nodeIndices[A], $ = N.tensorIndices[A];
        o(P, y, v, R, F, $);
      }
      for (y.push(N); v.indexOf(N) >= 0; )
        v.splice(v.indexOf(N), 1);
      i.push(N);
    }, u = [], l = [];
    for (let b of this.outputs)
      o(b, u, l);
    let c = i.slice().reverse();
    for (let b of c) {
      n[b.id] = b, b.id in t || (t[b.id] = 0);
      let y = t[b.id], v = s[b.outboundLayer.id] == null ? 0 : s[b.outboundLayer.id];
      y = Math.max(y, v), s[b.outboundLayer.id] = y, r[b.outboundLayer.id] = b.outboundLayer, t[b.id] = y;
      for (let x = 0; x < b.inboundLayers.length; x++) {
        let k = b.inboundLayers[x], T = b.nodeIndices[x], N = k.inboundNodes[T], E = t[N.id] == null ? 0 : t[N.id];
        t[N.id] = Math.max(y + 1, E), n[N.id] = N;
      }
    }
    let p = {};
    for (let b in t) {
      let y = t[b];
      y in p || (p[y] = []), p[y].push(n[b]);
    }
    let d = {};
    for (let b in s) {
      let y = s[b];
      y in d || (d[y] = []), d[y].push(r[b]);
    }
    let h = Object.keys(d).map((b) => parseInt(b, 10)).sort(Uc);
    this.layers = [];
    for (let b of h) {
      let y = d[b];
      y.sort((v, x) => {
        let k = a[v.id], T = a[x.id];
        return k < T ? -1 : k > T ? 1 : 0;
      });
      for (let v of y)
        v instanceof Is && this.internalContainerRefs.push(v), this.layers.push(v);
    }
    this.layersByDepth = d, h = Object.keys(p).map((b) => parseInt(b, 10)).sort(Uc);
    let f = this.inputs.slice(), m = [];
    for (let b of h)
      for (let y of p[b]) {
        let v = y.outboundLayer;
        if (v != null) {
          for (let x of y.inputTensors)
            if (f.indexOf(x) === -1)
              throw new hs(`Graph disconnected: cannot obtain value for tensor ${x} at layer "${v.name}". The following previous layers were accessed without issue: ${m}`);
          for (let x of y.outputTensors)
            f.push(x);
          m.push(v.name);
        }
      }
    this.nodesByDepth = p;
    let g = this.layers.map((b) => b.name);
    for (let b of g) {
      let y = g.filter((v) => v === b).length;
      if (y !== 1)
        throw new hs(`The name "${b}" is used ${y} times in the model. All layer names should be unique. Layer names: ` + JSON.stringify(g));
    }
    this.outboundNodes = [], this.inboundNodes = [], new Fp({ outboundLayer: this, inboundLayers: [], nodeIndices: [], tensorIndices: [], inputTensors: this.inputs, outputTensors: this.outputs, inputMasks: this.inputs.map((b) => null), outputMasks: this.outputs.map((b) => null), inputShapes: this.inputs.map((b) => b.shape), outputShapes: this.outputs.map((b) => b.shape) }), this.built = true, this._refCount = 1;
  }
  assertNotDisposed() {
    if (this._refCount === 0)
      throw new Error(`Container '${this.name}' is already disposed.`);
  }
  dispose() {
    this.assertNotDisposed();
    let e = { refCountAfterDispose: null, numDisposedVariables: 0 };
    if (--this._refCount === 0) {
      for (let t of this.layers)
        e.numDisposedVariables += t.dispose().numDisposedVariables;
      for (let t of this.internalContainerRefs)
        e.numDisposedVariables += t.dispose().numDisposedVariables;
    }
    return e.refCountAfterDispose = this._refCount, e;
  }
  get trainable() {
    return this.trainable_;
  }
  set trainable(e) {
    this.layers.forEach((t) => {
      t._trainableWeights.forEach((n) => n.trainable = e);
    }), this.trainable_ = e;
  }
  get trainableWeights() {
    if (this._trainableWeights.length > 0)
      throw new U("Container instance unexpectedly contains _trainableWeights.The trainable weights of a Container are a union of the trainable weights of its consituent Layers. Its own _trainableWeights must remain an empty Array.");
    if (!this.trainable)
      return [];
    let e = [];
    for (let t of this.layers)
      e = e.concat(t.trainableWeights);
    return e;
  }
  get nonTrainableWeights() {
    let e = [];
    for (let t of this.layers)
      e.push(...t.nonTrainableWeights);
    if (!this.trainable) {
      let t = [];
      for (let n of this.layers)
        t.push(...n.trainableWeights);
      return t.concat(e);
    }
    return e;
  }
  get weights() {
    return this.trainableWeights.concat(this.nonTrainableWeights);
  }
  loadWeights(e, t = true) {
    let n = {}, s = 0;
    for (let a of this.layers)
      for (let i of a.weights) {
        if (n[i.originalName] != null)
          throw new U(`Duplicate weight name: ${i.originalName}`);
        n[i.originalName] = i, s++;
      }
    let r = [];
    for (let a in e) {
      let i = a;
      if (n[a] == null) {
        let o = a.split("/");
        i = o.slice(0, -2).concat([o[o.length - 1]]).join("/");
      }
      if (n[i] != null)
        r.push([n[i], e[a]]);
      else if (t)
        throw new U(`Provided weight data has no target variable: ${a}`);
      delete n[i];
    }
    if (t) {
      let a = [];
      for (let i in n)
        a.push(i);
      if (a.length > 0)
        throw new U(`${a.length} of ${s} weights are not set: ${a}`);
    }
    Pb(r);
  }
  updatedConfig() {
    let e = this.getConfig(), t = {};
    return t.className = this.getClassName(), t.config = e, t.kerasVersion = `tfjs-layers ${uS}`, t.backend = "TensorFlow.js", t;
  }
  toJSON(e, t = true) {
    let n = wm(this.updatedConfig());
    return t ? JSON.stringify(n) : n;
  }
  call(e, t) {
    return j(() => {
      e = dt(e);
      let n = new Qr();
      for (let s = 0; s < this.inputs.length; ++s)
        n.add(this.inputs[s], e[s]);
      return Au(this.outputs, n, t);
    });
  }
  computeMask(e, t) {
    return j(() => {
      e = dt(e);
      let n;
      return t == null ? n = fa(null, e.length) : n = dt(t), this.runInternalGraph(e, n)[1];
    });
  }
  computeOutputShape(e) {
    let t = Sd(e);
    if (t.length !== this.inputLayers.length)
      throw new U(`Invalid inputShape argument ${e}: model has ${this.inputLayers.length} tensor inputs.`);
    let n = {};
    for (let i = 0; i < t.length; i++) {
      let o = this.inputLayers[i], u = t[i], l = o.name + "_0_0";
      n[l] = u;
    }
    let s = Object.keys(this.nodesByDepth).map((i) => parseInt(i, 10)).sort(Uc);
    if (s.length > 1)
      for (let i of s) {
        let o = this.nodesByDepth[i];
        for (let u of o) {
          let l = u.outboundLayer;
          if (this.inputLayers.map((f) => f.id).indexOf(l.id) !== -1)
            continue;
          let c = [];
          for (let f = 0; f < u.inboundLayers.length; f++) {
            let m = u.inboundLayers[f], g = u.nodeIndices[f], b = u.tensorIndices[f], y = `${m.name}_${g}_${b}`, v = n[y];
            c.push(v);
          }
          let p = l.computeOutputShape(bn(c)), d = Sd(p), h = l.inboundNodes.indexOf(u);
          for (let f = 0; f < d.length; f++) {
            let m = `${l.name}_${h}_${f}`;
            n[m] = d[f];
          }
        }
      }
    let r = [], a = [];
    for (let i = 0; i < this.outputLayers.length; i++) {
      let o = this.outputLayers[i], u = this.outputLayersNodeIndices[i], l = this.outputLayersTensorIndices[i], c = `${o.name}_${u}_${l}`;
      a.push(c);
    }
    for (let i = 0; i < a.length; i++) {
      let o = a[i];
      Cs(o in n), r.push(n[o]);
    }
    return bn(r);
  }
  runInternalGraph(e, t) {
    t == null && (t = fa(null, e.length));
    let n = {};
    for (let o = 0; o < this.inputs.length; ++o) {
      let u = this.inputs[o], l = e[o], c = t[o];
      n[u.id] = [l, c];
    }
    let s = Object.keys(this.nodesByDepth).map((o) => parseInt(o, 10)).sort(Uc);
    for (let o of s) {
      let u = this.nodesByDepth[o];
      for (let l of u) {
        let c = l.outboundLayer, p = l.inputTensors, d = l.outputTensors, h = new Array();
        for (let f of p)
          f.id in n && h.push(n[f.id]);
        if (h.length === p.length) {
          let f = {}, m, g, b, y;
          if (l.callArgs != null && (f = l.callArgs), h.length === 1) {
            let [v, x] = h[0];
            f.mask == null && (f.mask = x), b = dt(c.call(v, f)), y = dt(c.computeMask(v, x)), m = [v], g = [x];
          } else
            m = h.map((v) => v[0]), g = h.map((v) => v[1]), f.mask == null && (f.mask = g), b = dt(c.call(m, f)), y = dt(c.computeMask(m, g));
          if (c.activityRegularizer)
            throw new Fe("LayersModel invocation with concrete Tensor value(s) in the presence of activity regularizer(s) is not supported yet.");
          for (let v = 0; v < d.length; ++v) {
            let x = d[v], k = b[v], T = y[v];
            n[x.id] = [k, T];
          }
        }
      }
    }
    let r = [], a = [], i = [];
    for (let o of this.outputs) {
      Cs(o.id in n, `Could not compute output ${o.name} : ${o.id}`);
      let [u, l] = n[o.id];
      i.push(u.shape), r.push(u), a.push(l);
    }
    return [r, a, i];
  }
  buildNodeConversionMap(e) {
    let t = {}, n;
    for (let s of this.layers) {
      n = s instanceof Is ? 1 : 0;
      for (let r = 0; r < s.inboundNodes.length; r++) {
        let a = Is.nodeKey(s, r);
        this.containerNodes.has(a) && (t[a] = n, n += 1);
      }
    }
    return t;
  }
  getLayer(e, t) {
    if (t != null) {
      if (this.layers.length <= t)
        throw new U(`Was asked to retrieve layer at index ${t}, but model only has ${this.layers.length} layer(s).`);
      return this.layers[t];
    } else if (e == null)
      throw new U("Provide either a layer name or layer index");
    for (let n of this.layers)
      if (n.name === e)
        return n;
    throw new U(`No such layer: ${e}`);
  }
  calculateLosses() {
    return j(() => {
      let e = [];
      for (let t of this.layers)
        for (let n = 0; n < t.inboundNodes.length; ++n) {
          let s = Is.nodeKey(t, n);
          this.containerNodes.has(s) && e.push(...t.calculateLosses());
        }
      return e;
    });
  }
  getConfig() {
    let e = { name: this.name }, t = this.buildNodeConversionMap(this.layers), n = [];
    for (let a of this.layers) {
      let i = a.getClassName(), o = a.getConfig(), u = [];
      for (let c = 0; c < a.inboundNodes.length; c++) {
        let p = a.inboundNodes[c], d = Is.nodeKey(a, c), h = {};
        if (this.containerNodes.has(d)) {
          if (p.callArgs)
            try {
              JSON.stringify(p.callArgs), h = p.callArgs;
            } catch (f) {
              console.warn(`Layer ${a.name} was passed non-serializable keyword arguments: ${p.callArgs}. They will not be included in the serialized model (and thus will be missing at deserialization time).`), h = {};
            }
          if (p.inboundLayers.length > 0) {
            let f = [];
            for (let m = 0; m < p.inboundLayers.length; m++) {
              let g = p.inboundLayers[m], b = p.nodeIndices[m], y = p.tensorIndices[m], v = Is.nodeKey(g, b), x = t[v];
              x == null && (x = 0), f.push([g.name, x, y, h]);
            }
            u.push(f);
          }
        }
      }
      let l = {};
      l.name = a.name, l.className = i, l.config = o, l.inboundNodes = u, n.push(l);
    }
    e.layers = n;
    let s = [];
    for (let a = 0; a < this.inputLayers.length; a++) {
      let i = this.inputLayers[a], o = this.inputLayersNodeIndices[a], u = Is.nodeKey(i, o);
      if (!this.containerNodes.has(u))
        continue;
      let l = t[u];
      l == null && (l = 0);
      let c = this.inputLayersTensorIndices[a];
      s.push([i.name, l, c]);
    }
    e.inputLayers = s;
    let r = [];
    for (let a = 0; a < this.outputLayers.length; a++) {
      let i = this.outputLayers[a], o = this.outputLayersNodeIndices[a], u = Is.nodeKey(i, o);
      if (!this.containerNodes.has(u))
        continue;
      let l = t[u];
      l == null && (l = 0);
      let c = this.outputLayersTensorIndices[a];
      r.push([i.name, l, c]);
    }
    return e.outputLayers = r, e;
  }
  static fromConfig(e, t, n = {}, s = false) {
    let r = {}, a = {};
    function i(m, g) {
      m.name in a ? a[m.name].push(g) : a[m.name] = [g];
    }
    function o(m, g) {
      let b = [], y;
      for (let v of g) {
        let x = v[0], k = v[1], T = v[2];
        if (y = v[3] == null ? {} : v[3], !(x in r)) {
          i(m, g);
          return;
        }
        let N = r[x];
        if (N.inboundNodes.length <= k) {
          i(m, g);
          return;
        }
        let E = N.inboundNodes[k];
        b.push(E.outputTensors[T]);
      }
      b.length > 0 && m.apply(bn(b), y);
    }
    function u(m) {
      let g = m.name, b = ms(m, t.customObjects != null ? t.customObjects : {});
      b.setFastWeightInitDuringBuild(s), r[g] = b, m.inboundNodes.forEach((v) => {
        if (!(v instanceof Array))
          throw new U(`Corrupted configuration, expected array for nodeData: ${v}`);
        i(b, v);
      });
    }
    let l = t.name, c = t.layers;
    for (let m of c)
      u(m);
    for (; !BM(a); )
      for (let m of c) {
        let g = r[m.name];
        if (g.name in a) {
          let b = a[g.name];
          delete a[g.name];
          for (let y of b)
            o(g, y);
        }
      }
    let p = [], d = [], h = t.inputLayers;
    for (let m of h) {
      let g = m[0], b = m[1], y = m[2];
      Cs(g in r);
      let x = r[g].inboundNodes[b].outputTensors;
      p.push(x[y]);
    }
    let f = t.outputLayers;
    for (let m of f) {
      let g = m[0], b = m[1], y = m[2];
      Cs(g in r);
      let x = r[g].inboundNodes[b].outputTensors;
      d.push(x[y]);
    }
    return new e({ inputs: p, outputs: d, name: l });
  }
  get stateful() {
    if (this._stateful)
      throw new U("Container instance unexpectedly has _stateful = true. The statefulness of a Container is determined by the Layers it contains. Its _stateful property must remain the default false.");
    for (let e of this.layers)
      if (e.stateful)
        return true;
    return false;
  }
  resetStates() {
    j(() => {
      this.layers.forEach((e) => {
        e.stateful && e.resetStates();
      });
    });
  }
};
function gB(e, t, n) {
  let s = t.length;
  if (e == null || Array.isArray(e) && e.length === 0)
    return t.map((r) => null);
  if (s === 1)
    return Array.isArray(e) && e.length === 1 ? e : typeof e == "object" && t[0] in e ? [e[t[0]]] : [e];
  if (Array.isArray(e)) {
    if (e.length !== s)
      throw new Error(`Provided ${n} is an array of ${e.length} element(s), but the model has ${s} outputs. Make sure a set of weights is provided for each model output.`);
    return e;
  } else if (typeof e == "object" && Object.keys(e).length > 0 && typeof e[Object.keys(e)[0]] == "object") {
    let r = [];
    return t.forEach((a) => {
      a in e ? r.push(e[a]) : r.push(null);
    }), r;
  } else
    throw new Error(`The model has multiple (${s}) outputs, so ${n} must be either an array with ${s} elements or an object with ${t} keys. Provided ${n} not understood: ${JSON.stringify(e)}`);
}
function lS(e, t) {
  return gB(e, t, "classWeight");
}
async function cS(e, t, n, s) {
  if (t != null || s != null)
    throw new Error("Support sampleWeight is not implemented yet");
  if (n != null) {
    let r = j(() => {
      if (e.shape.length === 1)
        return lr(e);
      if (e.shape.length === 2) {
        if (e.shape[1] > 1)
          return Hu(e, 1);
        if (e.shape[1] === 1)
          return G(e, [e.shape[0]]);
        throw new Error(`Encountered unexpected last-dimension size (${e.shape[1]}) during handling of class weights. The size is expected to be >= 1.`);
      } else
        throw new Error(`Unexpected rank of target (y) tensor (${e.rank}) during handling of class weights. The rank is expected to be 1 or 2.`);
    }), a = Array.from(await r.data());
    Re(r);
    let i = [];
    return a.forEach((o) => {
      if (n[o] == null)
        throw new Error(`classWeight must contain all classes in the training data. The class ${o} exists in the data but not in classWeight`);
      i.push(n[o]);
    }), Zt(i, "float32");
  } else
    return null;
}
function bB(e, t) {
  return V(e, t);
}
var yB = 32;
function dS(e, t) {
  let n, s, r = t;
  n = r.xs, s = r.ys, w.assert(n != null && s != null, () => `A Dataset iterator for fitDataset() is expected to generate objects of the form \`{xs: xVal, ys: yVal}\`, where the two values may be \`tf.Tensor\`, an array of Tensors, or a map of string to Tensor.  The provided Dataset instead generates ${t}`);
  let a = Px("input", e.inputNames, n), i = Px("output", e.outputNames, s), o = a[0].shape[0];
  w.assert(a.length === e.inputs.length, () => `LayersModel has ${e.inputs.length} inputs, but the dataset provides ${a.length} inputs.  (Expected input keys: ${JSON.stringify(e.inputNames)})`), w.assert(i.length === e.outputs.length, () => `LayersModel has ${e.outputs.length} outputs, but the dataset provides ${i.length} outputs.  (Expected output keys: ${JSON.stringify(e.outputNames)})`);
  for (let u = 0; u < a.length; u++)
    w.assert(a[u].shape[0] === o, () => `Batch size mismatch: input ${e.inputNames[u]} has ${a[u].shape[0]}; expected  ${o} based on input ${e.inputNames[0]}.`);
  for (let u = 0; u < i.length; u++)
    w.assert(i[u].shape[0] === o, () => `Batch size mismatch: output ${e.outputNames[u]} has ${i[u].shape[0]}; expected  ${o} based on input ${e.inputNames[0]}.`);
  return { xs: a, ys: i };
}
function Px(e, t, n) {
  if (n instanceof et)
    return [n];
  if (Array.isArray(n))
    return w.assert(n.length === t.length, () => `Received an array of ${n.length} Tensors, but expected ${t.length} to match the ${e} keys ${t}.`), n;
  {
    let s = [];
    for (let r of t) {
      if (n[r] == null)
        throw new U(`The feature data generated by the dataset lacks the required ${e} key '${r}'.`);
      s.push(n[r]);
    }
    return s;
  }
}
function vB(e) {
  if (e.length === 3)
    throw new Fe("Validation with sample weights is not implemented yet.");
  return { xs: e[0], ys: e[1] };
}
async function xB(e, t, n) {
  let s = n.batchesPerEpoch != null;
  if (w.assert(e.optimizer != null, () => "You must compile a model before training/testing. Use LayersModel.compile(modelCompileConfig)."), w.assert(n != null, () => "For fitDataset(), the 2nd argument (config) is required, but it is not provided in this call."), w.assert(n.epochs != null && n.epochs > 0 && Number.isInteger(n.epochs), () => `For fitDataset(), config.epochs is expected to be a positive integer, but got ${n.epochs}`), w.assert(!s || n.batchesPerEpoch > 0 && Number.isInteger(n.batchesPerEpoch), () => `For fitDataset(), config.batchesPerEpoch is expected to be a positive integer if specified, but got ${n.batchesPerEpoch}`), w.assert(n.validationSplit == null, () => "`validationSplit` is not supported by `fitDataset()`. Use validationData instead."), e.isTraining)
    throw new Error("Cannot start training because another fit() call is ongoing.");
  e.isTraining = true;
  try {
    let r = n.validationData != null, a, i;
    if (r)
      if (zx(n.validationData))
        w.assert(n.validationBatches == null || n.validationBatches > 0 && Number.isInteger(n.validationBatches), () => `For fitDataset() with dataset-based validation, config.validationBatches is expected not to be provided, or to be a positive integer, but got ${n.validationBatches}`);
      else {
        let g = vB(n.validationData);
        a = g.xs, i = g.ys;
      }
    let o = e.makeTrainFunction(), u = e.getDedupedMetricsNames(), l;
    r ? l = u.slice().concat(u.map((g) => "val_" + g)) : l = u.slice();
    let c = eS(n.callbacks, n.yieldEvery), p = n.verbose == null ? 1 : n.verbose, { callbackList: d, history: h } = tS(c, p, n.epochs, null, null, wB(t, n), null, r, l);
    d.setModel(e), e.history = h, await d.onTrainBegin(), e.stopTraining_ = false;
    let f = n.initialEpoch == null ? 0 : n.initialEpoch, m = await t.iterator();
    for (; f < n.epochs; ) {
      let g = {};
      await d.onEpochBegin(f);
      let b = 0, y = 0;
      for (s || (m = await t.iterator()); !s || b < n.batchesPerEpoch; ) {
        let v = await m.next();
        if (s && v.done) {
          console.warn(`You provided \`batchesPerEpoch\` as ${n.batchesPerEpoch}, but your dataset iterator ran out of data after ${b} batches; interrupting training. Make sure that your dataset can generate at least \`batchesPerEpoch * epochs\` batches (in this case, ${n.batchesPerEpoch * n.epochs} batches). You may need to use the repeat() function when building your dataset.`);
          break;
        }
        if (v.value != null) {
          let { xs: x, ys: k } = dS(e, v.value), T = {};
          T.batch = y, T.size = x[0].shape[0], await d.onBatchBegin(y, T);
          let N = [];
          if (n.classWeight != null) {
            let P = lS(n.classWeight, e.outputNames);
            for (let R = 0; R < P.length; ++R)
              N.push(await cS(k[R], null, P[R]));
          }
          let E = x.concat(k).concat(N), A = o(E);
          Re(E);
          for (let P = 0; P < u.length; ++P) {
            let R = u[P], F = A[P];
            T[R] = F, Ht(F);
          }
          await d.onBatchEnd(y, T), JI(T), y++, b++;
        }
        if (s ? b >= n.batchesPerEpoch : v.done) {
          if (r) {
            let x;
            zx(n.validationData) ? x = dt(await e.evaluateDataset(n.validationData, { batches: n.validationBatches })) : x = dt(e.evaluate(a, i, { batchSize: n.validationBatchSize == null ? yB : n.validationBatchSize, verbose: 0 }));
            for (let k = 0; k < e.metricsNames.length; ++k)
              g[`val_${e.metricsNames[k]}`] = x[k];
          }
          break;
        }
        if (e.stopTraining_)
          break;
      }
      if (await d.onEpochEnd(f, g), f++, e.stopTraining_)
        break;
    }
    return await d.onTrainEnd(), await e.history.syncData(), e.history;
  } finally {
    e.isTraining = false;
  }
}
function wB(e, t) {
  let n = null;
  return t.batchesPerEpoch != null ? n = t.batchesPerEpoch : Number.isFinite(e.size) && (n = e.size), n;
}
function zx(e) {
  return typeof e.iterator == "function";
}
function kB(e) {
  return typeof e.next == "function";
}
async function IB(e, t, n) {
  n = n || {};
  let s = n.batches != null, r = e.testFunction, a = [];
  if (n.verbose > 0)
    throw new Fe("Verbose mode is not implemented yet.");
  w.assert(!s || n.batches > 0 && Number.isInteger(n.batches), () => `Test loop expects \`batches\` to be a positive integer, but received ${JSON.stringify(n.batches)}`);
  let i = kB(t) ? t : await t.iterator(), o = 0, u = 0;
  for (; !s || u < n.batches; ) {
    let l = await i.next();
    if (a = j(() => {
      if (l.value) {
        let { xs: c, ys: p } = dS(e, l.value), d = c.concat(p), h = j(() => r(d));
        if (Re(d), u === 0)
          for (let m = 0; m < h.length; ++m)
            a.push(we(0));
        let f = d[0].shape[0];
        for (let m = 0; m < h.length; ++m) {
          let g = h[m], b = a[m];
          a[m] = j(() => ie(a[m], V(f, g))), u > 0 && Re(b);
        }
        Re(h), o += f, ++u;
      }
      return a;
    }), l.done) {
      s && console.warn(`Your dataset iterator ran out of data during evaluateDataset(). Interrupting evalution. Make sure that your dataset can generate at least \`batches\` batches (in this case, ${n.batches} batches). You may need to use the repeat() function when building your dataset.`);
      break;
    }
  }
  for (let l = 0; l < a.length; ++l) {
    let c = a[l];
    a[l] = xe(a[l], o), Re(c);
  }
  return bn(a);
}
function km(e) {
  w.assert(e > 0 && Number.isInteger(e), () => `batchSize is required to be a positive integer, but got ${e}`);
}
function Eu(e, t, n) {
  return e == null ? [null] : Array.isArray(e) ? e.map((s) => ta(s, t, n - t)) : ta(e, t, n - t);
}
function Wb(e, t) {
  return j(() => e == null ? null : Array.isArray(e) ? e.map((n) => Wb(n, t)) : KI(e, t.dtype === "int32" ? t : ce(t, "int32")));
}
function Im(e, t) {
  let n = [], s = 0, r = null;
  for (; s < e; )
    r = s + t, r >= e && (r = e), n.push([s, r]), s = r;
  return n;
}
async function SB(e, t, n, s, r, a, i, o, u, l, c, p, d, h, f) {
  r == null && (r = 32), a == null && (a = 1), c == null && (c = true), d == null && (d = 0);
  let m = false;
  if (u != null && l != null && (m = true), f != null && (m = true, h == null))
    throw new U("Can only use `validationSteps` when doing step-wise training, i.e., `stepsPerEpoch` must be set.");
  let g = e.checkNumSamples(n, r, h, "steps_per_epoch"), b;
  g != null && (b = ys(0, g)), i == null && (i = 1);
  let { callbackList: y, history: v } = tS(o, i, a, d, g, h, r, m, p);
  y.setModel(e), e.history = v, await y.onTrainBegin(), e.stopTraining_ = false;
  for (let x = d; x < a; ++x) {
    await y.onEpochBegin(x);
    let k = {};
    if (h != null)
      throw new Fe("stepsPerEpoch mode is not implemented yet.");
    {
      if (c === "batch")
        throw new Fe("batch shuffling is not implemneted yet");
      c && w.shuffle(b);
      let T = Zt(b), N = Im(g, r);
      for (let E = 0; E < N.length; ++E) {
        let A = {};
        if (await y.onBatchBegin(E, A), j(() => {
          let P = N[E][0], R = N[E][1], F = ta(T, P, R - P);
          A.batch = E, A.size = R - P;
          let $ = Wb(n, F), z = t($);
          for (let W = 0; W < s.length; ++W) {
            let q = s[W], K = z[W];
            A[q] = K, Ht(K);
          }
          if (E === N.length - 1 && m) {
            let W = e.testLoop(u, l, r);
            for (let q = 0; q < s.length; ++q) {
              let K = s[q], Y = W[q];
              Ht(Y), k["val_" + K] = Y;
            }
          }
        }), await y.onBatchEnd(E, A), JI(A), e.stopTraining_)
          break;
      }
      T.dispose();
    }
    if (await y.onEpochEnd(x, k), e.stopTraining_)
      break;
  }
  return await y.onTrainEnd(), await e.history.syncData(), e.history;
}
async function CB(e, t, n, s = {}) {
  if (e.isTraining)
    throw new Error("Cannot start training because another fit() call is ongoing.");
  e.isTraining = true;
  let r, a, i, o, u, l, c, p, d;
  try {
    let h = s.batchSize == null ? 32 : s.batchSize;
    km(h);
    let f = false, m = await e.standardizeUserData(t, n, s.sampleWeight, s.classWeight, f, h);
    r = m[0], a = m[1], d = m[2];
    let g = false, b;
    if (s.validationData != null && s.validationData.length > 0) {
      if (g = true, s.validationData.length === 2)
        u = s.validationData[0], l = s.validationData[1];
      else
        throw s.validationData.length === 3 ? new Fe("validationData including sample weights is not supported yet.") : new U(`When passing validation data, it must contain 2 (valX, valY) or 3 (valX, valY, valSampleWeight) items; ${s.validationData} is invalid.`);
      let A = true, P = await e.standardizeUserData(u, l, null, null, A, h);
      c = P[0], p = P[1], b = c.concat(p);
    } else if (s.validationSplit != null && s.validationSplit > 0 && s.validationSplit < 1) {
      g = true;
      let A = Math.floor(r[0].shape[0] * (1 - s.validationSplit)), P = r[0].shape[0];
      c = Eu(r, A, P), i = r, r = Eu(r, 0, A), p = Eu(a, A, P), o = a, a = Eu(a, 0, A), b = c.concat(p);
    } else
      s.validationSteps != null && (g = true);
    let y = r.concat(a).concat(d);
    e.checkTrainableWeightsConsistency();
    let v = e.makeTrainFunction(), x = e.getDedupedMetricsNames(), k, T;
    g ? (e.makeTestFunction(), k = e.testFunction, T = x.slice().concat(x.map((A) => "val_" + A))) : (k = null, b = [], T = x.slice());
    let N = eS(s.callbacks, s.yieldEvery);
    return await SB(e, v, y, x, h, s.epochs, s.verbose, N, k, b, s.shuffle, T, s.initialEpoch, null, null);
  } finally {
    e.isTraining = false, ds(r, t), ds(a, n), ds(i, t), ds(o, n), ds(c, u), ds(p, l), d != null && Re(d);
  }
}
function pS(e) {
  let t = [];
  e instanceof et && (e = [e]);
  for (let n = 0; n < e.length; ++n) {
    let s = e[n];
    if (s.rank === 1)
      t.push(Vl(s, 1));
    else {
      if (s.rank === 0)
        throw new Error("Expected tensor to be at least 1D, but received a 0D tensor (scalar).");
      t.push(s);
    }
  }
  return t;
}
function ds(e, t) {
  if (e == null)
    return;
  let n = [];
  if (t instanceof et)
    n.push(t.id);
  else if (Array.isArray(t))
    t.forEach((r) => n.push(r.id));
  else if (t != null)
    for (let r in t) {
      let a = t[r];
      n.push(a.id);
    }
  let s = [];
  if (e instanceof et)
    n.indexOf(e.id) === -1 && s.push(e);
  else if (Array.isArray(e))
    e.forEach((r) => {
      n.indexOf(r.id) === -1 && s.push(r);
    });
  else if (e != null)
    for (let r in e) {
      let a = e[r];
      n.indexOf(a.id) === -1 && s.push(a);
    }
  s.forEach((r) => {
    r.isDisposed || r.dispose();
  });
}
function NB(e) {
  return e instanceof et;
}
function Sm(e) {
  return Array.isArray(e);
}
function Mx(e) {
  return !NB(e) && !Sm(e);
}
function Lx(e, t, n, s = true, r = "") {
  if (t == null || t.length === 0) {
    if (e != null) {
      let i = false;
      if (Sm(e) && e.length > 0)
        i = true;
      else if (Mx(e)) {
        for (let o in e)
          if (e.hasOwnProperty(o)) {
            i = true;
            break;
          }
      } else
        i = true;
      if (i)
        throw new U(`Error when checking model ${r} expected no data, but got ${e}`);
    }
    return [];
  }
  if (e == null)
    return t.map((i) => null);
  let a;
  if (Mx(e)) {
    e = e, a = [];
    for (let i of t) {
      if (e[i] == null)
        throw new U(`No data provided for "${i}". Need data for each key in: ${t}`);
      a.push(e[i]);
    }
  } else if (Sm(e)) {
    if (e = e, e.length !== t.length)
      throw new U(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the model expected. Expected to see ${t.length} Tensor(s), but instead got the following list of Tensor(s): ${e}`);
    a = e;
  } else {
    if (e = e, t.length > 1)
      throw new U(`The model ${r} expects ${t.length} Tensor(s), but only received one Tensor. Found: Tensor with shape ${e.shape}`);
    a = [e];
  }
  if (a = pS(a), n != null)
    for (let i = 0; i < t.length; ++i) {
      if (n[i] == null)
        continue;
      let o = a[i];
      if (o.shape.length !== n[i].length)
        throw new U(`Error when checking ${r}: expected ${t[i]} to have ${n[i].length} dimension(s). but got array with shape ${o.shape}`);
      for (let u = 0; u < n[i].length; ++u) {
        if (u === 0 && !s)
          continue;
        let l = o.shape[u], c = n[i][u];
        if (c != null && c >= 0 && l !== c)
          throw new U(`${r} expected a batch of elements where each example has shape [${n[i].slice(1, n[i].length)}] (i.e.,tensor shape [*,${n[i].slice(1, n[i].length)}]) but the ${r} received an input with ${o.shape[0]} examples, each with shape [${o.shape.slice(1, o.shape.length)}] (tensor shape [${o.shape}])`);
      }
    }
  return a;
}
function TB(e, t, n) {
  let s = cr(e.map((a) => a.shape[0]));
  s.sort();
  let r = cr(t.map((a) => a.shape[0]));
  if (r.sort(), s.length > 1)
    throw new U(`All input Tensors (x) should have the same number of samples. Got array shapes: ${JSON.stringify(e.map((a) => a.shape))}`);
  if (r.length > 1)
    throw new U(`All target Tensors (y) should have the same number of samples. Got array shapes: ${JSON.stringify(t.map((a) => a.shape))}`);
  if (s.length > 0 && r.length > 0 && !w.arraysEqual(s, r))
    throw new U(`Input Tensors should have the same number of samples as target Tensors. Found ${s[0]} input sample(s) and ${r[0]} target sample(s).`);
}
function $B(e, t, n) {
  let s = [gi, Pp, Qu];
  for (let r = 0; r < e.length; ++r) {
    let a = e[r], i = t[r], o = n[r];
    if (i != null) {
      if (i === Qu && a.shape[a.shape.length - 1] === 1)
        throw new U(`You are passing a target array of shape ${a.shape} while using a loss 'categorical_crossentropy'. 'categorical_crossentropy'expects targets to be binary matrices (1s and 0s) of shape [samples, classes].`);
      if (s.indexOf(i) !== -1) {
        let u = a.shape.slice(1), l = o.slice(1);
        for (let c = 0; c < u.length; ++c) {
          let p = u[c], d = l[c];
          if (d != null && p !== d)
            throw new U(`A target Tensor with shape ${a.shape} was passed for an output of shape ${o}, while using a loss function that expects targets to have the same shape as the output.`);
        }
      }
    }
  }
}
function Bx(e, t, n, s = true, r = "") {
  let a;
  if (Array.isArray(e)) {
    if (e.length !== t.length)
      throw new U(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the the model expected. Expected to see ${t.length} Tensor(s), but instead got ${e.length} Tensors(s).`);
    a = e;
  } else {
    if (t.length > 1)
      throw new U(`The model expects ${t.length} ${r} Tensors, but only received one Tensor. Found: array with shape ${JSON.stringify(e.shape)}.`);
    a = [e];
  }
  if (n != null)
    for (let i = 0; i < t.length; ++i) {
      if (n[i] == null)
        continue;
      let o = a[i];
      if (o.shape.length !== n[i].length)
        throw new U(`Error when checking ${r}: expected ${t[i]} to have ${n[i].length} dimension(s), but got array with shape ${JSON.stringify(o.shape)}`);
      for (let u = 0; u < n[i].length; ++u) {
        if (u === 0 && !s)
          continue;
        let l = o.shape[u], c = n[i][u];
        if (c != null && c !== l)
          throw new U(`Error when checking ${r}: expected ${t[i]} to have shape ${JSON.stringify(n[i])} but got array with shape ${JSON.stringify(o.shape)}.`);
      }
    }
}
function _B(e, t) {
  if (e == null || Array.isArray(e) && e.length === 0)
    return t.map((s) => []);
  let n;
  if (typeof e == "string" || typeof e == "function")
    n = [e];
  else if (Array.isArray(e) || typeof e == "object")
    n = e;
  else
    throw new TypeError(`Type of metrics argument not understood. Expected an string,function, Array, or Object, found: ${e}`);
  if (Array.isArray(n))
    return t.map((s) => n);
  {
    let s = [];
    for (let r of t) {
      let a = n.hasOwnProperty(r) ? n[r] : [];
      Array.isArray(a) || (a = [a]), s.push(a);
    }
    return s;
  }
}
var AB = "layers-model";
var pr = class extends Is {
  constructor(e) {
    super(e), this.isTraining = false;
  }
  summary(e, t, n = console.log) {
    if (!this.built)
      throw new U("This model has never been called, thus its weights have not been created yet. So no summary can be displayed. Build the model first (e.g., by calling it on some test data).");
    oB(this, e, t, n);
  }
  compile(e) {
    if (e.loss == null && (e.loss = []), this.loss = e.loss, typeof e.optimizer == "string")
      this.optimizer_ = iB(e.optimizer), this.isOptimizerOwned = true;
    else {
      if (!(e.optimizer instanceof _r))
        throw new U("User-defined optimizer must be an instance of tf.Optimizer.");
      this.optimizer_ = e.optimizer, this.isOptimizerOwned = false;
    }
    let t = [];
    if (!Array.isArray(e.loss) && typeof e.loss != "string" && typeof e.loss != "function") {
      e.loss = e.loss;
      for (let a in e.loss)
        if (this.outputNames.indexOf(a) === -1)
          throw new U(`Unknown entry in loss dictionary: "${a}". Only expected the following keys: ${this.outputNames}`);
      for (let a of this.outputNames)
        e.loss[a] == null && console.warn(`Output "${a}" is missing from loss dictionary. We assume this was done on purpose, and we will not be expecting data to be passed to ${a} during training`), t.push(Wf(e.loss[a]));
    } else if (Array.isArray(e.loss)) {
      if (e.loss.length !== this.outputs.length)
        throw new U(`When passing an Array as loss, it should have one entry per model output. The model has ${this.outputs.length} output(s), but you passed loss=${e.loss}.`);
      t = e.loss.map((i) => Wf(i));
    } else {
      let a = Wf(e.loss);
      this.outputs.forEach((i) => {
        t.push(a);
      });
    }
    this.lossFunctions = t, this.feedOutputNames = [], this.feedOutputShapes = [], this.feedLossFns = [];
    for (let a = 0; a < this.outputs.length; ++a) {
      let i = this.internalOutputShapes[a], o = this.outputNames[a];
      this.feedOutputNames.push(o), this.feedOutputShapes.push(i), this.feedLossFns.push(this.lossFunctions[a]);
    }
    let n = [];
    this.metrics = e.metrics, this.metricsNames = ["loss"], this.metricsTensors = [], ea("loss", () => {
      for (let a = 0; a < this.outputs.length; ++a) {
        if (n.indexOf(a) !== -1)
          continue;
        let i = this.lossFunctions[a];
        this.outputs.length > 1 && (this.metricsTensors.push([i, a]), this.metricsNames.push(this.outputNames[a] + "_loss"));
      }
    });
    let s = _B(e.metrics, this.outputNames), r = (a, i, o) => {
      this.outputNames.length > 1 && (i = this.outputNames[a] + "_" + i), this.metricsNames.push(i), this.metricsTensors.push([o, a]);
    };
    ea("metric", () => {
      for (let a = 0; a < this.outputs.length; ++a) {
        if (n.indexOf(a) !== -1)
          continue;
        let i = s[a];
        ((u) => {
          let l = "", c, p, d;
          for (let h of u) {
            if (typeof h == "string" && ["accuracy", "acc", "crossentropy", "ce"].indexOf(h) !== -1) {
              let m = this.internalOutputShapes[a];
              m[m.length - 1] === 1 || this.lossFunctions[a] === Pp ? ["accuracy", "acc"].indexOf(h) !== -1 ? p = Lb : ["crossentropy", "ce"].indexOf(h) !== -1 && (p = rS) : this.lossFunctions[a] === Td ? ["accuracy", "acc"].indexOf(h) !== -1 ? p = aS : ["crossentropy", "ce"].indexOf(h) !== -1 && (p = iS) : ["accuracy", "acc"].indexOf(h) !== -1 ? p = Bb : ["crossentropy", "ce"].indexOf(h) !== -1 && (p = Vb);
              let g;
              ["accuracy", "acc"].indexOf(h) !== -1 ? g = "acc" : ["crossentropy", "ce"].indexOf(h) !== -1 && (g = "ce"), d = p, c = l + g;
            } else
              d = aB(h), c = l + qc(h);
            let f;
            ea(c, () => {
              f = d;
            }), r(a, c, f);
          }
        })(i);
      }
    }), this.collectedTrainableWeights = this.trainableWeights;
  }
  checkTrainableWeightsConsistency() {
    this.collectedTrainableWeights != null && this.trainableWeights.length !== this.collectedTrainableWeights.length && console.warn("Discrepancy between trainableweights and collected trainable weights. Did you set `model.trainable` without calling `model.compile()` afterwards?");
  }
  evaluate(e, t, n = {}) {
    let s = n.batchSize == null ? 32 : n.batchSize;
    km(s);
    let r = true, a = this.standardizeUserDataXY(e, t, r, s);
    try {
      let i = a[0].concat(a[1]);
      this.makeTestFunction();
      let o = this.testFunction, u = this.testLoop(o, i, s, n.verbose, n.steps);
      return bn(u);
    } finally {
      ds(a[0], e), ds(a[1], t);
    }
  }
  async evaluateDataset(e, t) {
    return this.makeTestFunction(), IB(this, e, t);
  }
  checkNumSamples(e, t, n, s = "steps") {
    let r;
    if (n != null) {
      if (r = null, t != null)
        throw new U(`If ${s} is set, batchSize must be null or undefined.Got batchSize = ${t}`);
    } else if (e != null)
      Array.isArray(e) ? r = e[0].shape[0] : r = e.shape[0];
    else
      throw new U(`Either the input data should have a defined shape, or ${s} shoud be specified.`);
    return r;
  }
  execute(e, t) {
    if (Array.isArray(t) && t.length === 0)
      throw new U("`outputs` is an empty Array, which is not allowed.");
    let n = Array.isArray(t), s = n ? t : [t], r = this.retrieveSymbolicTensors(s), a = new Qr();
    if (e instanceof et && (e = [e]), Array.isArray(e)) {
      if (e.length !== this.inputs.length)
        throw new U(`The number of inputs provided (${e.length}) does not match the number of inputs of this model (${this.inputs.length}).`);
      for (let o = 0; o < this.inputs.length; ++o)
        a.add(this.inputs[o], e[o]);
    } else
      for (let o of this.inputs) {
        let u = e[o.name];
        if (u == null)
          throw new U(`No value is provided for the model's input ${o.name}`);
        a.add(o, u);
      }
    let i = Au(r, a);
    return n ? i : i[0];
  }
  retrieveSymbolicTensors(e) {
    let t = fa(null, e.length), n = e.length;
    for (let s of this.layers) {
      let r = Array.isArray(s.output) ? s.output : [s.output], a = r.map((i) => i.name);
      for (let i = 0; i < e.length; ++i) {
        let o = a.indexOf(e[i]);
        if (o !== -1 && (t[i] = r[o], n--), n === 0)
          break;
      }
      if (n === 0)
        break;
    }
    if (n > 0) {
      let s = [];
      throw t.forEach((r, a) => {
        r == null && s.push(e[a]);
      }), new U(`Cannot find SymbolicTensors for output name(s): ${JSON.stringify(s)}`);
    }
    return t;
  }
  predictLoop(e, t = 32, n = false) {
    return j(() => {
      let s = this.checkNumSamples(e);
      if (n)
        throw new Fe("Verbose predictLoop() is not implemented yet.");
      let r = Im(s, t), a = this.outputs.map((i) => []);
      for (let i = 0; i < r.length; ++i)
        j(() => {
          let u = r[i][0], l = r[i][1], c = Eu(e, u, l), p = [];
          if (Array.isArray(c))
            for (let h = 0; h < c.length; ++h)
              p.push({ key: this.inputs[h], value: c[h] });
          else
            p.push({ key: this.inputs[0], value: c });
          let d = new Qr(p);
          return Au(this.outputs, d);
        }).forEach((u, l) => a[l].push(u));
      return bn(a.map((i) => Ft(i, 0)));
    });
  }
  predict(e, t = {}) {
    let n = pS(e);
    Bx(n, this.inputNames, this.feedInputShapes, false);
    try {
      let s = t.batchSize == null ? 32 : t.batchSize;
      return km(s), this.predictLoop(n, s);
    } finally {
      ds(n, e);
    }
  }
  predictOnBatch(e) {
    Bx(e, this.inputNames, this.feedInputShapes, true);
    let t = (Array.isArray(e) ? e[0] : e).shape[0];
    return this.predictLoop(e, t);
  }
  standardizeUserDataXY(e, t, n = true, s) {
    if (this.optimizer_ == null)
      throw new hs("You must compile a model before training/testing. Use LayersModel.compile(modelCompileArgs).");
    let r = [];
    for (let a = 0; a < this.feedOutputShapes.length; ++a) {
      let i = this.feedOutputShapes[a];
      this.feedLossFns[a] === Td ? r.push(i.slice(0, i.length - 1).concat([1])) : r.push(i);
    }
    if (e = Lx(e, this.feedInputNames, this.feedInputShapes, false, "input"), t = Lx(t, this.feedOutputNames, r, false, "target"), TB(e, t, null), $B(t, this.feedLossFns, this.feedOutputShapes), this.stateful && s != null && s > 0 && e[0].shape[0] % s !== 0)
      throw new U(`In a stateful network, you should only pass inputs with a number of samples that is divisible by the batch size ${s}. Found: ${e[0].shape[0]} sample(s).`);
    return [e, t];
  }
  async standardizeUserData(e, t, n, s, r = true, a) {
    let [i, o] = this.standardizeUserDataXY(e, t, r, a);
    if (n != null)
      throw new Error("sample weight is not supported yet.");
    let u = null;
    if (s != null) {
      let l = lS(s, this.outputNames);
      u = [];
      for (let c = 0; c < l.length; ++c)
        u.push(await cS(o[c], null, l[c]));
    }
    return [i, o, u];
  }
  testLoop(e, t, n, s = 0, r) {
    return j(() => {
      let a = this.checkNumSamples(t, n, r, "steps"), i = [];
      if (s > 0)
        throw new Fe("Verbose mode is not implemented yet.");
      if (r != null)
        throw new Fe("steps mode in testLoop() is not implemented yet");
      {
        let o = Im(a, n), u = Zt(ys(0, a));
        for (let l = 0; l < o.length; ++l) {
          let c = o[l][0], p = o[l][1], d = ta(u, c, p - c), h = Wb(t, d), f = e(h);
          if (l === 0)
            for (let m = 0; m < f.length; ++m)
              i.push(we(0));
          for (let m = 0; m < f.length; ++m) {
            let g = f[m];
            i[m] = ie(i[m], V(p - c, g));
          }
        }
        for (let l = 0; l < i.length; ++l)
          i[l] = xe(i[l], a);
      }
      return i;
    });
  }
  getDedupedMetricsNames() {
    let e = this.metricsNames, t = [];
    for (let n = 0; n < e.length; ++n) {
      let s = e[n], r = s;
      Sx(e, s) > 1 && (r += `_${Sx(e.slice(0, n), s)}`), t.push(r);
    }
    return t;
  }
  makeTrainFunction() {
    return (e) => {
      let t = [], n = e.slice(0, this.inputs.length), s = e.slice(this.inputs.length, this.inputs.length + this.outputs.length), r = e.slice(this.inputs.length + this.outputs.length, this.inputs.length + this.outputs.length * 2), a = [], i = () => {
        let c = [];
        for (let f = 0; f < this.inputs.length; ++f)
          c.push({ key: this.inputs[f], value: n[f] });
        let p = new Qr(c), d = Au(this.outputs, p, { training: true }), h;
        for (let f = 0; f < this.lossFunctions.length; ++f) {
          let g = this.lossFunctions[f](s[f], d[f]);
          r[f] != null && (g = bB(g, r[f]));
          let b = St(g);
          t.push(b), f === 0 ? h = g : h = ie(h, g);
        }
        for (let f = 0; f < this.metricsTensors.length; ++f) {
          let m;
          if (this.outputs.length > 1 && f < this.outputs.length)
            m = t[f];
          else {
            let g = this.metricsTensors[f][0], b = this.metricsTensors[f][1];
            m = St(g(s[b], d[b]));
          }
          Ht(m), a.push(m);
        }
        return h = St(h), this.calculateLosses().forEach((f) => {
          h = ie(h, f);
        }), h;
      }, o = this.collectedTrainableWeights.map((c) => c.read()), u = true;
      return [this.optimizer_.minimize(i, u, o)].concat(a);
    };
  }
  makeTestFunction() {
    this.testFunction = (e) => j(() => {
      let t = [], n, s = e.slice(0, this.inputs.length), r = e.slice(this.inputs.length, this.inputs.length + this.outputs.length), a = [];
      for (let u = 0; u < this.inputs.length; ++u)
        a.push({ key: this.inputs[u], value: s[u] });
      let i = new Qr(a), o = Au(this.outputs, i);
      for (let u = 0; u < this.lossFunctions.length; ++u) {
        let l = this.lossFunctions[u], c = St(l(r[u], o[u]));
        u === 0 ? n = c : n = ie(n, c), t.push(n);
      }
      for (let u = 0; u < this.metricsTensors.length; ++u) {
        let l = this.metricsTensors[u][0], c = this.metricsTensors[u][1], p = St(l(r[c], o[c]));
        t.push(p);
      }
      return t;
    });
  }
  async fit(e, t, n = {}) {
    return CB(this, e, t, n);
  }
  async fitDataset(e, t) {
    return xB(this, e, t);
  }
  async trainOnBatch(e, t) {
    let n = await this.standardizeUserData(e, t), s = n[0], r = n[1], i = this.makeTrainFunction()(s.concat(r)), o = [];
    for (let u of i) {
      let l = await u.data();
      o.push(l[0]);
    }
    return Re(i), ds(n[0], e), ds(n[1], t), bn(o);
  }
  getNamedWeights(e) {
    let t = [], n = e != null && e.trainableOnly, s = n ? this.trainableWeights : this.weights, r = this.getWeights(n);
    for (let a = 0; a < s.length; ++a)
      n && !s[a].trainable || t.push({ name: s[a].originalName, tensor: r[a] });
    return t;
  }
  set stopTraining(e) {
    this.stopTraining_ = e;
  }
  get stopTraining() {
    return this.stopTraining_;
  }
  get optimizer() {
    return this.optimizer_;
  }
  set optimizer(e) {
    this.optimizer_ !== e && (this.optimizer_ = e, this.isOptimizerOwned = false);
  }
  dispose() {
    let e = super.dispose();
    if (e.refCountAfterDispose === 0 && this.optimizer != null && this.isOptimizerOwned) {
      let t = dm().numTensors;
      this.optimizer_.dispose(), e.numDisposedVariables += t - dm().numTensors;
    }
    return e;
  }
  getLossIdentifiers() {
    let e;
    if (typeof this.loss == "string")
      e = Ws(this.loss);
    else if (Array.isArray(this.loss)) {
      for (let t of this.loss)
        if (typeof t != "string")
          throw new Error("Serialization of non-string loss is not supported.");
      e = this.loss.map((t) => Ws(t));
    } else {
      let t = Object.keys(this.loss);
      e = {};
      let n = this.loss;
      for (let s of t)
        if (typeof n[s] == "string")
          e[s] = Ws(n[s]);
        else
          throw new Error("Serialization of non-string loss is not supported.");
    }
    return e;
  }
  getMetricIdentifiers() {
    if (typeof this.metrics == "string" || typeof this.metrics == "function")
      return [Ws(qc(this.metrics))];
    if (Array.isArray(this.metrics))
      return this.metrics.map((e) => Ws(qc(e)));
    {
      let e = {};
      for (let t in this.metrics)
        e[t] = Ws(qc(this.metrics[t]));
      return e;
    }
  }
  getTrainingConfig() {
    return { loss: this.getLossIdentifiers(), metrics: this.getMetricIdentifiers(), optimizer_config: { class_name: this.optimizer.getClassName(), config: this.optimizer.getConfig() } };
  }
  loadTrainingConfig(e) {
    if (e.weighted_metrics != null)
      throw new Error("Loading weight_metrics is not supported yet.");
    if (e.loss_weights != null)
      throw new Error("Loading loss_weights is not supported yet.");
    if (e.sample_weight_mode != null)
      throw new Error("Loading sample_weight_mode is not supported yet.");
    let t = Zu(e.optimizer_config), n = ms(t), s;
    if (typeof e.loss == "string")
      s = Kr(e.loss);
    else if (Array.isArray(e.loss))
      s = e.loss.map((a) => Kr(a));
    else if (e.loss != null) {
      s = {};
      for (let a in e.loss)
        s[a] = Kr(e.loss[a]);
    }
    let r;
    if (Array.isArray(e.metrics))
      r = e.metrics.map((a) => Kr(a));
    else if (e.metrics != null) {
      r = {};
      for (let a in e.metrics)
        r[a] = Kr(e.metrics[a]);
    }
    this.compile({ loss: s, metrics: r, optimizer: n });
  }
  async save(e, t) {
    if (typeof e == "string") {
      let u = En.getSaveHandlers(e);
      if (u.length === 0)
        throw new U(`Cannot find any save handlers for URL '${e}'`);
      if (u.length > 1)
        throw new U(`Found more than one (${u.length}) save handlers for URL '${e}'`);
      e = u[0];
    }
    if (e.save == null)
      throw new U("LayersModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");
    let n = await En.encodeWeights(this.getNamedWeights(t)), s = false, r = null, i = { modelTopology: this.toJSON(r, s), format: AB, generatedBy: `TensorFlow.js tfjs-layers v${uS}`, convertedBy: null };
    if ((t == null ? false : t.includeOptimizer) && this.optimizer != null) {
      i.trainingConfig = this.getTrainingConfig();
      let u = "optimizer", { data: l, specs: c } = await En.encodeWeights(await this.optimizer.getWeights(), u);
      n.specs.push(...c), n.data = En.concatenateArrayBuffers([n.data, l]);
    }
    return this.userDefinedMetadata != null && (Dx(this.userDefinedMetadata, this.name, true), i.userDefinedMetadata = this.userDefinedMetadata), i.weightData = n.data, i.weightSpecs = n.specs, e.save(i);
  }
  setUserDefinedMetadata(e) {
    Dx(e, this.name), this.userDefinedMetadata = e;
  }
  getUserDefinedMetadata() {
    return this.userDefinedMetadata;
  }
};
pr.className = "Model";
ae.registerClass(pr);
var hS = class extends pr {
};
hS.className = "Functional";
ae.registerClass(hS);
async function EB(e, t) {
  "modelTopology" in e || (e = { modelTopology: e }), e = e;
  let n = e.modelTopology;
  n.model_config != null && (n = n.model_config);
  let s = Zu(n), r = ms(s, t);
  if (e.weightsManifest != null) {
    let a = await En.loadWeights(e.weightsManifest, e.pathPrefix, r.weights.map((o) => o.originalName)), i = {};
    for (let o of r.weights)
      i[o.originalName] = a[o.originalName];
    r.loadWeights(i), Re(a);
  }
  return r;
}
async function RB(e, t) {
  if (t == null && (t = {}), typeof e == "string") {
    let n = En.getLoadHandlers(e, t);
    if (n.length === 0)
      n.push(En.browserHTTPRequest(e, t));
    else if (n.length > 1)
      throw new U(`Found more than one (${n.length}) load handlers for URL '${e}'`);
    e = n[0];
  }
  return DB(e, void 0, t);
}
async function DB(e, t, n) {
  if (n == null && (n = {}), e.load == null)
    throw new U("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");
  let s = await e.load(), r = s.modelTopology;
  r.model_config != null && (r = r.model_config);
  let a = n.strict == null ? true : n.strict, i = s.weightData != null && s.weightSpecs != null && a, o = ms(Zu(r), t, i), u = s.trainingConfig;
  if (u != null && o.loadTrainingConfig(u), s.userDefinedMetadata != null && o.setUserDefinedMetadata(s.userDefinedMetadata), s.weightData != null) {
    if (s.weightSpecs == null)
      throw new U("LayersModel artifacts contains weight data, but not weight specs. Therefore loading of weights cannot proceed.");
    let { modelWeights: l, optimizerWeights: c } = FB(s.weightData, s.weightSpecs);
    o.loadWeights(l, a), o.optimizer != null && c.length > 0 && await o.optimizer.setWeights(c), Re(l), Re(c.map((p) => p.tensor));
  }
  return o;
}
function FB(e, t) {
  let n = En.decodeWeights(e, t), s = {}, r = [];
  return t.forEach((a) => {
    a.group === "optimizer" ? r.push({ name: a.name, tensor: n[a.name] }) : s[a.name] = n[a.name];
  }), { modelWeights: s, optimizerWeights: r };
}
var Cm = class extends pr {
  constructor(e) {
    if (super({ inputs: [], outputs: [] }), e = e || {}, this.trainable = true, this.built = false, this.name = e.name != null ? e.name : Dp("sequential_"), e.layers != null)
      for (let t of e.layers)
        this.add(t);
  }
  checkShape(e) {
    if (e.inboundNodes[0].outputTensors[0].shape.some((n) => n < 0))
      throw new U(`Negative dimension size caused by adding layer ${e.name} with input shape [${e.inboundNodes[0].inputTensors[0].shape}]`);
  }
  add(e) {
    let t = e instanceof Cm || e instanceof pr, n;
    if (t) {
      if (n = e, n.outputs.length !== 1)
        throw new U("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");
      if (n.inputs.length !== 1)
        throw new U("All layers in a Sequential model should have a single input tensor. For multi-input layers, use the functional API.");
    }
    if (this.outputs.length === 0) {
      if (e.inboundNodes.length === 0) {
        if (e.batchInputShape == null)
          throw new U("The first layer in a Sequential model must get an `inputShape` or `batchInputShape` argument.");
        let s = ZI({ batchShape: e.batchInputShape, dtype: e.dtype, name: e.name + "_input" });
        e.apply(s);
      }
      if (t)
        this.outputs = n.outputs, this.inputs = n.inputs;
      else {
        if (e.inboundNodes.length !== 1)
          throw new U(`A layer added to a Sequential model must not already be connected somewhere else. LayersModel received layer ${e.name} which has ${e.inboundNodes.length} pre-existing inbound connections.`);
        if (e.inboundNodes[0].outputTensors.length !== 1)
          throw new U("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");
        this.checkShape(e), this.outputs = [e.inboundNodes[0].outputTensors[0]], this.inputs = QI(this.outputs[0]);
      }
      this.inboundNodes = [], new Fp({ outboundLayer: this, inboundLayers: [], nodeIndices: [], tensorIndices: [], inputTensors: this.inputs, outputTensors: this.outputs, inputMasks: fa(null, this.inputs.length), outputMasks: [null], inputShapes: this.inputs.map((s) => s.shape), outputShapes: this.outputs[0].shape });
    } else {
      let s = e.apply(this.outputs[0]);
      if (Array.isArray(s))
        throw new TypeError("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");
      this.checkShape(e), this.outputs = [s], this.inboundNodes[0].outputTensors = this.outputs, this.inboundNodes[0].outputShapes = [this.outputs[0].shape];
    }
    this.layers.push(e), this.built = false;
  }
  pop() {
    if (this.layers.length === 0)
      throw new TypeError("There are no layers in the model.");
    if (this.layers.pop(), this.layers.length === 0)
      this.outputs = [], this.inboundNodes = [], this.outboundNodes = [];
    else {
      let e = this.layers.length - 1;
      this.layers[e].outboundNodes = [], this.outputs = [this.layers[e].output], this.inboundNodes[0].outputTensors = this.outputs, this.inboundNodes[0].outputShapes = [this.outputs[0].shape];
    }
  }
  call(e, t) {
    return this.model == null && this.build(), this.model.call(e, t);
  }
  build(e) {
    if (nt(e), this.inputs.length === 0 || this.outputs.length === 0)
      throw new TypeError("Sequential model cannot be built: model is empty. Add some layers first.");
    this.model = new pr({ inputs: this.inputs, outputs: this.outputs[0], name: this.name + "_model" }), this.model.trainable = this.trainable, this.supportsMasking = this.model.supportsMasking, this.inputLayers = this.model.inputLayers, this.inputLayersNodeIndices = this.model.inputLayersNodeIndices, this.inputLayersTensorIndices = this.model.inputLayersTensorIndices, this.outputLayers = this.model.outputLayers, this.outputLayersNodeIndices = this.model.outputLayersNodeIndices, this.outputLayersTensorIndices = this.model.outputLayersTensorIndices, this.nodesByDepth = this.model.nodesByDepth, this.containerNodes = this.model.containerNodes, this.outputNames = this.model.outputNames, this.inputNames = this.model.inputNames, this.built = true;
  }
  countParams() {
    return this.built || this.build(), super.countParams();
  }
  summary(e, t, n = console.log) {
    this.built || this.build(), super.summary(e, t, n);
  }
  setWeights(e) {
    this.model == null && this.build(), this.model.setWeights(e);
  }
  evaluate(e, t, n = {}) {
    if (!this.built)
      throw new hs("The model needs to be compiled before being used.");
    return this.model.evaluate(e, t, n);
  }
  async evaluateDataset(e, t) {
    if (!this.built)
      throw new hs("The model needs to be compiled before being used.");
    return this.model.evaluateDataset(e, t);
  }
  predict(e, t = {}) {
    return this.model == null && this.build(), this.model.predict(e, t);
  }
  predictOnBatch(e) {
    return this.model == null && this.build(), this.model.predictOnBatch(e);
  }
  compile(e) {
    this.build(), this.model.compile(e), this.optimizer_ = this.model.optimizer, this.isOptimizerOwned = this.model.isOptimizerOwned, this.loss = this.model.loss, this.metrics = this.model.metrics, this.metricsTensors = this.model.metricsTensors, this.metricsNames = this.model.metricsNames;
  }
  get optimizer() {
    return this.model == null ? void 0 : this.model.optimizer;
  }
  set optimizer(e) {
    this.model.optimizer = e;
  }
  async fit(e, t, n = {}) {
    if (!this.built)
      throw new hs("The model needs to be compiled before being used.");
    return this.model.fit(e, t, n);
  }
  async fitDataset(e, t) {
    if (!this.built)
      throw new hs("The model needs to be compiled before being used.");
    return this.model.fitDataset(e, t);
  }
  async trainOnBatch(e, t) {
    return this.model.trainOnBatch(e, t);
  }
  static fromConfig(e, t, n = {}, s = false) {
    let r, a = {};
    if (t instanceof Array) {
      if (t[0].className == null || t[0].className === "Merge")
        throw new U("Legacy serialization format not supported yet.");
      r = t;
    } else
      w.assert(t.layers != null, () => "When the config data for a Sequential model is not an Array, it must be an Object that contains the 'layers' field."), r = t.layers, delete t.layers, a = t;
    let i = new e(a);
    if (!(i instanceof Cm))
      throw new Fe(`Sequential.fromConfig called on non-Sequential input: ${i}`);
    for (let o of r) {
      let l = ms(o, void 0, s);
      s && l.setFastWeightInitDuringBuild(true), i.add(l);
    }
    return i;
  }
  set stopTraining(e) {
    if (this.model == null)
      throw new U("Cannot set the stopTraining property of a sequential model before it is compiled.");
    this.model.stopTraining = e;
  }
  get stopTraining() {
    if (this.model == null)
      throw new U("Cannot get the stopTraining property of a sequential model before it is compiled.");
    return this.model.stopTraining;
  }
  getConfig() {
    let e = [];
    for (let t of this.layers) {
      let n = {};
      n.className = t.getClassName(), n.config = t.getConfig(), e.push(n);
    }
    return { name: this.name, layers: e };
  }
};
var Ub = Cm;
Ub.className = "Sequential";
ae.registerClass(Ub);
function Npe(e) {
  return new pr(e);
}
function Tpe(e) {
  return new Ub(e);
}
function $pe(e, t) {
  return t == null && (t = {}), RB(e, t);
}
function OB(e) {
  return ZI(e);
}
function _pe(e, t) {
  zb.registerCallbackConstructor(e, t);
}
var In = class extends ae.Serializable {
  getConfig() {
    return {};
  }
};
var fS = class extends In {
  apply(e, t = 1) {
    return aL(e, t);
  }
};
fS.className = "elu";
ae.registerClass(fS);
var mS = class extends In {
  apply(e) {
    return gI(e);
  }
};
mS.className = "selu";
ae.registerClass(mS);
var gS = class extends In {
  apply(e) {
    return Xs(e);
  }
};
gS.className = "relu";
ae.registerClass(gS);
var bS = class extends In {
  apply(e) {
    return j(() => bp(6, Xs(e)));
  }
};
bS.className = "relu6";
ae.registerClass(bS);
var yS = class extends In {
  apply(e) {
    return e;
  }
};
yS.className = "linear";
ae.registerClass(yS);
var vS = class extends In {
  apply(e) {
    return qs(e);
  }
};
vS.className = "sigmoid";
ae.registerClass(vS);
var xS = class extends In {
  apply(e) {
    return oL(e);
  }
};
xS.className = "hardSigmoid";
ae.registerClass(xS);
var wS = class extends In {
  apply(e) {
    return zl(e);
  }
};
wS.className = "softplus";
ae.registerClass(wS);
var kS = class extends In {
  apply(e) {
    return iL(e);
  }
};
kS.className = "softsign";
ae.registerClass(kS);
var IS = class extends In {
  apply(e) {
    return qu(e);
  }
};
IS.className = "tanh";
ae.registerClass(IS);
var Gb = class extends In {
  apply(e, t = -1) {
    return ub(e, t);
  }
};
Gb.className = "softmax";
ae.registerClass(Gb);
var SS = class extends In {
  apply(e, t = -1) {
    return iI(e, t);
  }
};
SS.className = "logSoftmax";
ae.registerClass(SS);
var CS = class extends In {
  apply(e, t = 1) {
    return j(() => V(qs(V(e, t)), e));
  }
};
CS.className = "swish";
ae.registerClass(CS);
var NS = class extends In {
  apply(e) {
    return j(() => V(e, qu(zl(e))));
  }
};
NS.className = "mish";
ae.registerClass(NS);
function br(e) {
  return e.getClassName();
}
function Gf(e, t = {}) {
  return Ll(e, ae.SerializationMap.getMap().classNameMap, t, "activation");
}
function yr(e) {
  if (e == null) {
    let t = {};
    return t.className = "linear", t.config = {}, Gf(t);
  }
  if (typeof e == "string") {
    let t = {};
    return t.className = e, t.config = {}, Gf(t);
  } else
    return e instanceof In ? e : Gf(e);
}
function Hb(e) {
  if (e != null && typeof e != "object")
    throw new Error(`Argument to L1L2 regularizer's constructor is expected to be an object, but received: ${e}`);
}
var TS = class extends ae.Serializable {
};
var Gl = class extends TS {
  constructor(e) {
    super(), Hb(e), this.l1 = e == null || e.l1 == null ? 0.01 : e.l1, this.l2 = e == null || e.l2 == null ? 0.01 : e.l2, this.hasL1 = this.l1 !== 0, this.hasL2 = this.l2 !== 0;
  }
  apply(e) {
    return j(() => {
      let t = $t([1]);
      return this.hasL1 && (t = ie(t, ve(V(this.l1, Mt(e))))), this.hasL2 && (t = ie(t, ve(V(this.l2, Wl(e))))), G(t, []);
    });
  }
  getConfig() {
    return { l1: this.l1, l2: this.l2 };
  }
  static fromConfig(e, t) {
    return new e({ l1: t.l1, l2: t.l2 });
  }
};
Gl.className = "L1L2";
ae.registerClass(Gl);
function PB(e) {
  return Hb(e), new Gl({ l1: e != null ? e.l1 : null, l2: 0 });
}
function zB(e) {
  return Hb(e), new Gl({ l2: e != null ? e.l2 : null, l1: 0 });
}
var Vx = { l1l2: "L1L2" };
function it(e) {
  return wb(e);
}
function Wx(e, t = {}) {
  return Ll(e, ae.SerializationMap.getMap().classNameMap, t, "regularizer");
}
function ft(e) {
  if (e == null)
    return null;
  if (typeof e == "string") {
    let n = { className: e in Vx ? Vx[e] : e, config: {} };
    return Wx(n);
  } else
    return e instanceof TS ? e : Wx(e);
}
var qb = class extends Ge {
  constructor(e) {
    super(e == null ? {} : e), this.supportsMasking = true, e != null && (this.maxValue = e.maxValue);
  }
  call(e, t) {
    e = Oe(e);
    let n = Xs(e);
    return this.maxValue != null && (n = Vn(n, 0, this.maxValue)), n;
  }
  computeOutputShape(e) {
    return e;
  }
  getConfig() {
    let e = { maxValue: this.maxValue }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
qb.className = "ReLU";
ae.registerClass(qb);
var jb = class extends Ge {
  constructor(e) {
    super(e == null ? {} : e), this.DEFAULT_ALPHA = 0.3, e == null && (e = {}), this.alpha = e.alpha == null ? this.DEFAULT_ALPHA : e.alpha;
  }
  call(e, t) {
    let n = Oe(e);
    return Xg(n, this.alpha);
  }
  computeOutputShape(e) {
    return e;
  }
  getConfig() {
    let e = { alpha: this.alpha }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
jb.className = "LeakyReLU";
ae.registerClass(jb);
var Kb = class extends Ge {
  constructor(e) {
    if (super(e == null ? {} : e), this.DEFAULT_ALPHA_INITIALIZER = "zeros", e == null && (e = {}), this.supportsMasking = true, this.alphaInitializer = ht(e.alphaInitializer || this.DEFAULT_ALPHA_INITIALIZER), this.alphaRegularizer = ft(e.alphaRegularizer), this.alphaConstraint = Pt(e.alphaConstraint), e.sharedAxes == null)
      this.sharedAxes = null;
    else if (Array.isArray(e.sharedAxes))
      this.sharedAxes = e.sharedAxes;
    else if (typeof e.sharedAxes == "number")
      this.sharedAxes = [e.sharedAxes];
    else
      throw new U(`Expected sharedAxes to be a number or an array of numbers, but got ${e.sharedAxes}`);
  }
  build(e) {
    e = nt(e);
    let t = e.slice(1);
    if (this.sharedAxes != null)
      for (let s of this.sharedAxes)
        t[s - 1] = 1;
    this.alpha = this.addWeight("alpha", t, "float32", this.alphaInitializer, this.alphaRegularizer, true, this.alphaConstraint);
    let n = {};
    if (this.sharedAxes != null)
      for (let s = 1; s < e.length; ++s)
        n[s] = e[s];
    this.inputSpec = [new Dt({ ndim: e.length, axes: n })], this.built = true;
  }
  call(e, t) {
    return e = Oe(e), sb(e, this.alpha.read());
  }
  getConfig() {
    let e = { alphaInitializer: yt(this.alphaInitializer), alphaRegularizer: it(this.alphaRegularizer), alphaConstraint: Ot(this.alphaConstraint), sharedAxes: this.sharedAxes }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
Kb.className = "PReLU";
ae.registerClass(Kb);
var Xb = class extends Ge {
  constructor(e) {
    if (super(e == null ? {} : e), this.DEFAULT_ALPHA = 1, e == null && (e = {}), e.alpha != null && e.alpha !== this.DEFAULT_ALPHA)
      throw new Fe(`Non-default alpha value (${e.alpha}) is not supported by the ELU layer yet.`);
    this.alpha = e.alpha == null ? this.DEFAULT_ALPHA : e.alpha;
  }
  call(e, t) {
    let n = Oe(e);
    return fp(n);
  }
  computeOutputShape(e) {
    return e;
  }
  getConfig() {
    let e = { alpha: this.alpha }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
Xb.className = "ELU";
ae.registerClass(Xb);
var Yb = class extends Ge {
  constructor(e) {
    super(e == null ? {} : e), this.DEFAULT_THETA = 1, e == null && (e = {}), this.theta = e.theta == null ? this.DEFAULT_THETA : e.theta;
  }
  call(e, t) {
    let n = Oe(e);
    return V(n, ce(Wn(n, this.theta), "float32"));
  }
  computeOutputShape(e) {
    return e;
  }
  getConfig() {
    let e = { theta: this.theta }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
Yb.className = "ThresholdedReLU";
ae.registerClass(Yb);
var Qb = class extends Ge {
  constructor(e) {
    super(e == null ? {} : e), this.DEFAULT_AXIS = 1, e == null && (e = {}), this.softmax = new Gb().apply, this.axis = e.axis == null ? this.DEFAULT_AXIS : e.axis;
  }
  call(e, t) {
    let n = Oe(e);
    return this.softmax(n, this.axis);
  }
  computeOutputShape(e) {
    return e;
  }
  getConfig() {
    let e = { axis: this.axis }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
Qb.className = "Softmax";
ae.registerClass(Qb);
function Xi(e, t, n) {
  if (typeof e == "number")
    return fa(e, t);
  if (e.length !== t)
    throw new U(`The ${n} argument must be an integer or tuple of ${t} integers. Received: ${e.length} elements.`);
  for (let s = 0; s < t; ++s) {
    let r = e[s];
    if (!tL(r))
      throw new U(`The ${n} argument must be an integer or tuple of ${t} integers. Received: ${JSON.stringify(e)} including a non-integer number ${r}`);
  }
  return e;
}
function gs(e, t, n, s, r = 1) {
  if (e == null)
    return e;
  let a = t + (t - 1) * (r - 1), i;
  return n === "same" ? i = e : i = e - a + 1, Math.floor((i + s - 1) / s);
}
function Ns(e, t, n, s) {
  if (e == null)
    return null;
  if (s === "valid")
    e = e * t + gr([n - t, 0]);
  else if (s === "same")
    e = e * t;
  else
    throw new U(`Unsupport padding mode: ${s}.`);
  return e;
}
function Zb(e, t) {
  return j(() => (Ct(t), t === "channelsFirst" ? qe(e, [0, 2, 3, 1]) : e));
}
function $S(e, t) {
  return j(() => (Ct(t), t === "channelsFirst" ? qe(e, [0, 2, 3, 4, 1]) : e));
}
function MB(e, t, n, s = 1, r = "valid", a, i = 1) {
  return j(() => {
    if (a == null && (a = bs()), Ct(a), e.shape.length !== 3)
      throw new U(`The input of a conv1dWithBias operation should be 3, but is ${e.shape.length} instead.`);
    if (t.shape.length !== 3)
      throw new U(`The kernel for a conv1dWithBias operation should be 3, but is ${t.shape.length} instead`);
    if (n != null && n.shape.length !== 1)
      throw new U(`The bias for a conv1dWithBias operation should be 1, but is ${t.shape.length} instead`);
    if (a === "channelsFirst" && (e = qe(e, [0, 2, 1])), r === "causal")
      throw new Fe("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");
    let o = Zk(e, t, s, r === "same" ? "same" : "valid", "NWC", i);
    return n != null && (o = ws(o, n)), o;
  });
}
function Ux(e, t, n, s = [1, 1], r = "valid", a, i, o = null) {
  return j(() => {
    if (a == null && (a = bs()), Ct(a), e.rank !== 3 && e.rank !== 4)
      throw new U(`conv2dWithBiasActivation expects input to be of rank 3 or 4, but received ${e.rank}.`);
    if (t.rank !== 3 && t.rank !== 4)
      throw new U(`conv2dWithBiasActivation expects kernel to be of rank 3 or 4, but received ${e.rank}.`);
    let u = Zb(e, a);
    if (r === "causal")
      throw new Fe("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");
    return u = ha.conv2d({ x: u, filter: t, strides: s, pad: r === "same" ? "same" : "valid", dilations: i, dataFormat: "NHWC", bias: n, activation: o }), a === "channelsFirst" && (u = qe(u, [0, 3, 1, 2])), u;
  });
}
function LB(e, t, n, s = [1, 1, 1], r = "valid", a, i) {
  return j(() => {
    if (a == null && (a = bs()), Ct(a), e.rank !== 4 && e.rank !== 5)
      throw new U(`conv3dWithBias expects input to be of rank 4 or 5, but received ${e.rank}.`);
    if (t.rank !== 4 && t.rank !== 5)
      throw new U(`conv3dWithBias expects kernel to be of rank 4 or 5, but received ${e.rank}.`);
    let o = $S(e, a);
    if (r === "causal")
      throw new Fe("The support for CAUSAL padding mode in conv3dWithBias is not implemented yet.");
    return o = eI(o, t, s, r === "same" ? "same" : "valid", "NDHWC", i), n != null && (o = ws(o, n)), a === "channelsFirst" && (o = qe(o, [0, 4, 1, 2, 3])), o;
  });
}
var Jb = class extends Ge {
  constructor(e, t) {
    if (super(t), this.bias = null, this.DEFAULT_KERNEL_INITIALIZER = "glorotNormal", this.DEFAULT_BIAS_INITIALIZER = "zeros", Jb.verifyArgs(t), this.rank = e, Bt(this.rank, "rank"), this.rank !== 1 && this.rank !== 2 && this.rank !== 3)
      throw new Fe(`Convolution layer for rank other than 1, 2, or 3 (${this.rank}) is not implemented yet.`);
    if (this.kernelSize = Xi(t.kernelSize, e, "kernelSize"), this.strides = Xi(t.strides == null ? 1 : t.strides, e, "strides"), this.padding = t.padding == null ? "valid" : t.padding, Un(this.padding), this.dataFormat = t.dataFormat == null ? "channelsLast" : t.dataFormat, Ct(this.dataFormat), this.activation = yr(t.activation), this.useBias = t.useBias == null ? true : t.useBias, this.biasInitializer = ht(t.biasInitializer || this.DEFAULT_BIAS_INITIALIZER), this.biasConstraint = Pt(t.biasConstraint), this.biasRegularizer = ft(t.biasRegularizer), this.activityRegularizer = ft(t.activityRegularizer), this.dilationRate = Xi(t.dilationRate == null ? 1 : t.dilationRate, e, "dilationRate"), this.rank === 1 && Array.isArray(this.dilationRate) && this.dilationRate.length !== 1)
      throw new U(`dilationRate must be a number or an array of a single number for 1D convolution, but received ${JSON.stringify(this.dilationRate)}`);
    if (this.rank === 2) {
      if (typeof this.dilationRate == "number")
        this.dilationRate = [this.dilationRate, this.dilationRate];
      else if (this.dilationRate.length !== 2)
        throw new U(`dilationRate must be a number or array of two numbers for 2D convolution, but received ${JSON.stringify(this.dilationRate)}`);
    } else if (this.rank === 3) {
      if (typeof this.dilationRate == "number")
        this.dilationRate = [this.dilationRate, this.dilationRate, this.dilationRate];
      else if (this.dilationRate.length !== 3)
        throw new U(`dilationRate must be a number or array of three numbers for 3D convolution, but received ${JSON.stringify(this.dilationRate)}`);
    }
  }
  static verifyArgs(e) {
    if (Cs("kernelSize" in e, "required key 'kernelSize' not in config"), typeof e.kernelSize != "number" && !kb(e.kernelSize, "number", 1, 3))
      throw new U(`BaseConv expects config.kernelSize to be number or number[] with length 1, 2, or 3, but received ${JSON.stringify(e.kernelSize)}.`);
  }
  getConfig() {
    let e = { kernelSize: this.kernelSize, strides: this.strides, padding: this.padding, dataFormat: this.dataFormat, dilationRate: this.dilationRate, activation: br(this.activation), useBias: this.useBias, biasInitializer: yt(this.biasInitializer), biasRegularizer: it(this.biasRegularizer), activityRegularizer: it(this.activityRegularizer), biasConstraint: Ot(this.biasConstraint) }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
var Hl = class extends Jb {
  constructor(e, t) {
    super(e, t), this.kernel = null, Hl.verifyArgs(t), this.filters = t.filters, Bt(this.filters, "filters"), this.kernelInitializer = ht(t.kernelInitializer || this.DEFAULT_KERNEL_INITIALIZER), this.kernelConstraint = Pt(t.kernelConstraint), this.kernelRegularizer = ft(t.kernelRegularizer);
  }
  build(e) {
    e = nt(e);
    let t = this.dataFormat === "channelsFirst" ? 1 : e.length - 1;
    if (e[t] == null)
      throw new U(`The channel dimension of the input should be defined. Found ${e[t]}`);
    let n = e[t], s = this.kernelSize.concat([n, this.filters]);
    this.kernel = this.addWeight("kernel", s, null, this.kernelInitializer, this.kernelRegularizer, true, this.kernelConstraint), this.useBias && (this.bias = this.addWeight("bias", [this.filters], null, this.biasInitializer, this.biasRegularizer, true, this.biasConstraint)), this.inputSpec = [{ ndim: this.rank + 2, axes: { [t]: n } }], this.built = true;
  }
  call(e, t) {
    return j(() => {
      e = Oe(e);
      let n, s = this.bias == null ? null : this.bias.read(), r = UI(this.activation.getClassName());
      if (r != null && this.rank === 2)
        n = Ux(e, this.kernel.read(), s, this.strides, this.padding, this.dataFormat, this.dilationRate, r);
      else {
        if (this.rank === 1)
          n = MB(e, this.kernel.read(), s, this.strides[0], this.padding, this.dataFormat, this.dilationRate[0]);
        else if (this.rank === 2)
          n = Ux(e, this.kernel.read(), s, this.strides, this.padding, this.dataFormat, this.dilationRate);
        else if (this.rank === 3)
          n = LB(e, this.kernel.read(), s, this.strides, this.padding, this.dataFormat, this.dilationRate);
        else
          throw new Fe("convolutions greater than 3D are not implemented yet.");
        this.activation != null && (n = this.activation.apply(n));
      }
      return n;
    });
  }
  computeOutputShape(e) {
    e = nt(e);
    let t = [], n = this.dataFormat === "channelsLast" ? e.slice(1, e.length - 1) : e.slice(2);
    for (let r = 0; r < n.length; ++r) {
      let a = gs(n[r], this.kernelSize[r], this.padding, this.strides[r], typeof this.dilationRate == "number" ? this.dilationRate : this.dilationRate[r]);
      t.push(a);
    }
    let s = [e[0]];
    return this.dataFormat === "channelsLast" ? (s = s.concat(t), s.push(this.filters)) : (s.push(this.filters), s = s.concat(t)), s;
  }
  getConfig() {
    let e = { filters: this.filters, kernelInitializer: yt(this.kernelInitializer), kernelRegularizer: it(this.kernelRegularizer), kernelConstraint: Ot(this.kernelConstraint) }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
  static verifyArgs(e) {
    if (!("filters" in e) || typeof e.filters != "number" || e.filters < 1)
      throw new U(`Convolution layer expected config.filters to be a 'number' > 0 but got ${JSON.stringify(e.filters)}`);
  }
};
var _S = class extends Hl {
  constructor(e) {
    super(2, e), _S.verifyArgs(e);
  }
  getConfig() {
    let e = super.getConfig();
    return delete e.rank, e;
  }
  static verifyArgs(e) {
    if (typeof e.kernelSize != "number" && !kb(e.kernelSize, "number", 1, 2))
      throw new U(`Conv2D expects config.kernelSize to be number or number[] with length 1 or 2, but received ${JSON.stringify(e.kernelSize)}.`);
  }
};
var zp = _S;
zp.className = "Conv2D";
ae.registerClass(zp);
var AS = class extends Hl {
  constructor(e) {
    super(3, e), AS.verifyArgs(e);
  }
  getConfig() {
    let e = super.getConfig();
    return delete e.rank, e;
  }
  static verifyArgs(e) {
    if (typeof e.kernelSize != "number" && !(Array.isArray(e.kernelSize) && (e.kernelSize.length === 1 || e.kernelSize.length === 3)))
      throw new U(`Conv3D expects config.kernelSize to be number or [number, number, number], but received ${JSON.stringify(e.kernelSize)}.`);
  }
};
var Mp = AS;
Mp.className = "Conv3D";
ae.registerClass(Mp);
var ey = class extends zp {
  constructor(e) {
    if (super(e), this.inputSpec = [new Dt({ ndim: 4 })], this.padding !== "same" && this.padding !== "valid")
      throw new U(`Conv2DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode ${this.padding}`);
  }
  build(e) {
    if (e = nt(e), e.length !== 4)
      throw new U("Input should have rank 4; Received input shape: " + JSON.stringify(e));
    let t = this.dataFormat === "channelsFirst" ? 1 : e.length - 1;
    if (e[t] == null)
      throw new U("The channel dimension of the inputs should be defined. Found `None`.");
    let n = e[t], s = this.kernelSize.concat([this.filters, n]);
    this.kernel = this.addWeight("kernel", s, "float32", this.kernelInitializer, this.kernelRegularizer, true, this.kernelConstraint), this.useBias && (this.bias = this.addWeight("bias", [this.filters], "float32", this.biasInitializer, this.biasRegularizer, true, this.biasConstraint)), this.inputSpec = [new Dt({ ndim: 4, axes: { [t]: n } })], this.built = true;
  }
  call(e, t) {
    return j(() => {
      let n = Oe(e);
      if (n.shape.length !== 4)
        throw new U(`Conv2DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-${n.shape.length}`);
      let s = n.shape, r = s[0], a, i;
      this.dataFormat === "channelsFirst" ? (a = 2, i = 3) : (a = 1, i = 2);
      let o = s[a], u = s[i], l = this.kernelSize[0], c = this.kernelSize[1], p = this.strides[0], d = this.strides[1], h = Ns(o, p, l, this.padding), f = Ns(u, d, c, this.padding), m = [r, h, f, this.filters];
      this.dataFormat !== "channelsLast" && (n = qe(n, [0, 2, 3, 1]));
      let g = Jk(n, this.kernel.read(), m, this.strides, this.padding);
      return this.dataFormat !== "channelsLast" && (g = qe(g, [0, 3, 1, 2])), this.bias != null && (g = ws(g, this.bias.read(), this.dataFormat)), this.activation != null && (g = this.activation.apply(g)), g;
    });
  }
  computeOutputShape(e) {
    e = nt(e);
    let t = e.slice(), n, s, r;
    this.dataFormat === "channelsFirst" ? (n = 1, s = 2, r = 3) : (n = 3, s = 1, r = 2);
    let a = this.kernelSize[0], i = this.kernelSize[1], o = this.strides[0], u = this.strides[1];
    return t[n] = this.filters, t[s] = Ns(t[s], o, a, this.padding), t[r] = Ns(t[r], u, i, this.padding), t;
  }
  getConfig() {
    let e = super.getConfig();
    return delete e.dilationRate, e;
  }
};
ey.className = "Conv2DTranspose";
ae.registerClass(ey);
var ty = class extends Mp {
  constructor(e) {
    if (super(e), this.inputSpec = [new Dt({ ndim: 5 })], this.padding !== "same" && this.padding !== "valid")
      throw new U(`Conv3DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode ${this.padding}`);
  }
  build(e) {
    if (e = nt(e), e.length !== 5)
      throw new U("Input should have rank 5; Received input shape: " + JSON.stringify(e));
    let t = this.dataFormat === "channelsFirst" ? 1 : e.length - 1;
    if (e[t] == null)
      throw new U("The channel dimension of the inputs should be defined. Found `None`.");
    let n = e[t], s = this.kernelSize.concat([this.filters, n]);
    this.kernel = this.addWeight("kernel", s, "float32", this.kernelInitializer, this.kernelRegularizer, true, this.kernelConstraint), this.useBias && (this.bias = this.addWeight("bias", [this.filters], "float32", this.biasInitializer, this.biasRegularizer, true, this.biasConstraint)), this.inputSpec = [new Dt({ ndim: 5, axes: { [t]: n } })], this.built = true;
  }
  call(e, t) {
    return j(() => {
      let n = Oe(e);
      if (n.shape.length !== 5)
        throw new U(`Conv3DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-${n.shape.length}`);
      let s = n.shape, r = s[0], a, i, o;
      this.dataFormat === "channelsFirst" ? (o = 2, a = 3, i = 4) : (o = 1, a = 2, i = 3);
      let u = s[o], l = s[a], c = s[i], p = this.kernelSize[0], d = this.kernelSize[1], h = this.kernelSize[2], f = this.strides[0], m = this.strides[1], g = this.strides[2], b = Ns(u, f, p, this.padding), y = Ns(l, m, d, this.padding), v = Ns(c, g, h, this.padding), x = [r, b, y, v, this.filters];
      this.dataFormat !== "channelsLast" && (n = qe(n, [0, 2, 3, 4, 1]));
      let k = tR(n, this.kernel.read(), x, this.strides, this.padding);
      return this.dataFormat !== "channelsLast" && (k = qe(k, [0, 4, 1, 2, 3])), this.bias !== null && (k = ws(k, this.bias.read(), this.dataFormat)), this.activation !== null && (k = this.activation.apply(k)), k;
    });
  }
  computeOutputShape(e) {
    e = nt(e);
    let t = e.slice(), n, s, r, a;
    this.dataFormat === "channelsFirst" ? (n = 1, s = 2, r = 3, a = 4) : (n = 4, s = 1, r = 2, a = 3);
    let i = this.kernelSize[0], o = this.kernelSize[1], u = this.kernelSize[2], l = this.strides[0], c = this.strides[1], p = this.strides[2];
    return t[n] = this.filters, t[s] = Ns(t[s], l, i, this.padding), t[r] = Ns(t[r], c, o, this.padding), t[a] = Ns(t[a], p, u, this.padding), t;
  }
  getConfig() {
    let e = super.getConfig();
    return delete e.dilationRate, e;
  }
};
ty.className = "Conv3DTranspose";
ae.registerClass(ty);
var ES = class extends Hl {
  constructor(e, t) {
    if (super(e, t), this.DEFAULT_DEPTHWISE_INITIALIZER = "glorotUniform", this.DEFAULT_POINTWISE_INITIALIZER = "glorotUniform", this.depthwiseKernel = null, this.pointwiseKernel = null, t.filters == null)
      throw new U("The `filters` configuration field is required by SeparableConv, but is unspecified.");
    if (t.kernelInitializer != null || t.kernelRegularizer != null || t.kernelConstraint != null)
      throw new U("Fields kernelInitializer, kernelRegularizer and kernelConstraint are invalid for SeparableConv2D. Use depthwiseInitializer, depthwiseRegularizer, depthwiseConstraint, pointwiseInitializer, pointwiseRegularizer and pointwiseConstraint instead.");
    if (t.padding != null && t.padding !== "same" && t.padding !== "valid")
      throw new U(`SeparableConv${this.rank}D supports only padding modes: 'same' and 'valid', but received ${JSON.stringify(t.padding)}`);
    this.depthMultiplier = t.depthMultiplier == null ? 1 : t.depthMultiplier, this.depthwiseInitializer = ht(t.depthwiseInitializer || this.DEFAULT_DEPTHWISE_INITIALIZER), this.depthwiseRegularizer = ft(t.depthwiseRegularizer), this.depthwiseConstraint = Pt(t.depthwiseConstraint), this.pointwiseInitializer = ht(t.depthwiseInitializer || this.DEFAULT_POINTWISE_INITIALIZER), this.pointwiseRegularizer = ft(t.pointwiseRegularizer), this.pointwiseConstraint = Pt(t.pointwiseConstraint);
  }
  build(e) {
    if (e = nt(e), e.length < this.rank + 2)
      throw new U(`Inputs to SeparableConv${this.rank}D should have rank ${this.rank + 2}, but received input shape: ${JSON.stringify(e)}`);
    let t = this.dataFormat === "channelsFirst" ? 1 : e.length - 1;
    if (e[t] == null || e[t] < 0)
      throw new U(`The channel dimension of the inputs should be defined, but found ${JSON.stringify(e[t])}`);
    let n = e[t], s = this.kernelSize.concat([n, this.depthMultiplier]), r = [];
    for (let i = 0; i < this.rank; ++i)
      r.push(1);
    r.push(n * this.depthMultiplier, this.filters);
    let a = true;
    this.depthwiseKernel = this.addWeight("depthwise_kernel", s, "float32", this.depthwiseInitializer, this.depthwiseRegularizer, a, this.depthwiseConstraint), this.pointwiseKernel = this.addWeight("pointwise_kernel", r, "float32", this.pointwiseInitializer, this.pointwiseRegularizer, a, this.pointwiseConstraint), this.useBias ? this.bias = this.addWeight("bias", [this.filters], "float32", this.biasInitializer, this.biasRegularizer, a, this.biasConstraint) : this.bias = null, this.inputSpec = [new Dt({ ndim: this.rank + 2, axes: { [t]: n } })], this.built = true;
  }
  call(e, t) {
    return j(() => {
      e = Oe(e);
      let n;
      if (this.rank === 1)
        throw new Fe("1D separable convolution is not implemented yet.");
      return this.rank === 2 && (this.dataFormat === "channelsFirst" && (e = qe(e, [0, 2, 3, 1])), n = c3(e, this.depthwiseKernel.read(), this.pointwiseKernel.read(), this.strides, this.padding, this.dilationRate, "NHWC")), this.useBias && (n = ws(n, this.bias.read(), this.dataFormat)), this.activation != null && (n = this.activation.apply(n)), this.dataFormat === "channelsFirst" && (n = qe(n, [0, 3, 1, 2])), n;
    });
  }
  getConfig() {
    let e = super.getConfig();
    return delete e.rank, delete e.kernelInitializer, delete e.kernelRegularizer, delete e.kernelConstraint, e.depthwiseInitializer = yt(this.depthwiseInitializer), e.pointwiseInitializer = yt(this.pointwiseInitializer), e.depthwiseRegularizer = it(this.depthwiseRegularizer), e.pointwiseRegularizer = it(this.pointwiseRegularizer), e.depthwiseConstraint = Ot(this.depthwiseConstraint), e.pointwiseConstraint = Ot(this.pointwiseConstraint), e;
  }
};
ES.className = "SeparableConv";
var ny = class extends ES {
  constructor(e) {
    super(2, e);
  }
};
ny.className = "SeparableConv2D";
ae.registerClass(ny);
var RS = class extends Hl {
  constructor(e) {
    super(1, e), RS.verifyArgs(e), this.inputSpec = [{ ndim: 3 }];
  }
  getConfig() {
    let e = super.getConfig();
    return delete e.rank, delete e.dataFormat, e;
  }
  static verifyArgs(e) {
    if (typeof e.kernelSize != "number" && !kb(e.kernelSize, "number", 1, 1))
      throw new U(`Conv1D expects config.kernelSize to be number or number[] with length 1, but received ${JSON.stringify(e.kernelSize)}.`);
  }
};
var sy = RS;
sy.className = "Conv1D";
ae.registerClass(sy);
var ry = class extends Ge {
  constructor(e) {
    super(e), typeof e.cropping == "number" ? this.cropping = [[e.cropping, e.cropping], [e.cropping, e.cropping]] : typeof e.cropping[0] == "number" ? this.cropping = [[e.cropping[0], e.cropping[0]], [e.cropping[1], e.cropping[1]]] : this.cropping = e.cropping, this.dataFormat = e.dataFormat === void 0 ? "channelsLast" : e.dataFormat, this.inputSpec = [{ ndim: 4 }];
  }
  computeOutputShape(e) {
    return this.dataFormat === "channelsFirst" ? [e[0], e[1], e[2] - this.cropping[0][0] - this.cropping[0][1], e[3] - this.cropping[1][0] - this.cropping[1][1]] : [e[0], e[1] - this.cropping[0][0] - this.cropping[0][1], e[2] - this.cropping[1][0] - this.cropping[1][1], e[3]];
  }
  call(e, t) {
    return j(() => {
      if (e = Oe(e), this.dataFormat === "channelsLast") {
        let n = Gc(e, this.cropping[0][0], e.shape[1] - this.cropping[0][0] - this.cropping[0][1], 2);
        return Gc(n, this.cropping[1][0], e.shape[2] - this.cropping[1][1] - this.cropping[1][0], 3);
      } else {
        let n = Gc(e, this.cropping[0][0], e.shape[2] - this.cropping[0][0] - this.cropping[0][1], 3);
        return Gc(n, this.cropping[1][0], e.shape[3] - this.cropping[1][1] - this.cropping[1][0], 4);
      }
    });
  }
  getConfig() {
    let e = { cropping: this.cropping, dataFormat: this.dataFormat }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
ry.className = "Cropping2D";
ae.registerClass(ry);
var ay = class extends Ge {
  constructor(e) {
    super(e), this.DEFAULT_SIZE = [2, 2], this.inputSpec = [{ ndim: 4 }], this.size = e.size == null ? this.DEFAULT_SIZE : e.size, this.dataFormat = e.dataFormat == null ? "channelsLast" : e.dataFormat, Ct(this.dataFormat), this.interpolation = e.interpolation == null ? "nearest" : e.interpolation, ZM(this.interpolation);
  }
  computeOutputShape(e) {
    if (this.dataFormat === "channelsFirst") {
      let t = e[2] == null ? null : this.size[0] * e[2], n = e[3] == null ? null : this.size[1] * e[3];
      return [e[0], e[1], t, n];
    } else {
      let t = e[1] == null ? null : this.size[0] * e[1], n = e[2] == null ? null : this.size[1] * e[2];
      return [e[0], t, n, e[3]];
    }
  }
  call(e, t) {
    return j(() => {
      let n = Oe(e), s = n.shape;
      if (this.dataFormat === "channelsFirst") {
        n = qe(n, [0, 2, 3, 1]);
        let r = this.size[0] * s[2], a = this.size[1] * s[3], i = this.interpolation === "nearest" ? qn.resizeNearestNeighbor(n, [r, a]) : qn.resizeBilinear(n, [r, a]);
        return qe(i, [0, 3, 1, 2]);
      } else {
        let r = this.size[0] * s[1], a = this.size[1] * s[2];
        return this.interpolation === "nearest" ? qn.resizeNearestNeighbor(n, [r, a]) : qn.resizeBilinear(n, [r, a]);
      }
    });
  }
  getConfig() {
    let e = { size: this.size, dataFormat: this.dataFormat }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
ay.className = "UpSampling2D";
ae.registerClass(ay);
function BB(e, t, n = [1, 1], s = "valid", r, a) {
  return j(() => {
    r == null && (r = bs()), Ct(r);
    let i = Zb(e, r);
    if (e.rank !== 4)
      throw new U(`Input for depthwiseConv2d is required to be 4-D, but is instead ${e.rank}-D`);
    if (t.rank !== 4)
      throw new U(`depthwiseKernel is required to be 4-D, but is instead ${t.rank}-D`);
    return i = hp(i, t, n, s === "same" ? "same" : "valid", "NHWC", a), r === "channelsFirst" && (i = qe(i, [0, 3, 1, 2])), i;
  });
}
var iy = class extends Jb {
  constructor(e) {
    super(2, e), this.depthwiseKernel = null, this.depthMultiplier = e.depthMultiplier == null ? 1 : e.depthMultiplier, this.depthwiseInitializer = ht(e.depthwiseInitializer || this.DEFAULT_KERNEL_INITIALIZER), this.depthwiseConstraint = Pt(e.depthwiseConstraint), this.depthwiseRegularizer = ft(e.depthwiseRegularizer);
  }
  build(e) {
    if (e = nt(e), e.length < 4)
      throw new U(`Inputs to DepthwiseConv2D should have rank 4. Received input shape: ${JSON.stringify(e)}.`);
    let t = this.dataFormat === "channelsFirst" ? 1 : 3;
    if (e[t] == null || e[t] < 0)
      throw new U(`The channel dimension of the inputs to DepthwiseConv2D should be defined, but is not (${e[t]}).`);
    let n = e[t], s = [this.kernelSize[0], this.kernelSize[1], n, this.depthMultiplier];
    this.depthwiseKernel = this.addWeight("depthwise_kernel", s, null, this.depthwiseInitializer, this.depthwiseRegularizer, true, this.depthwiseConstraint), this.useBias ? this.bias = this.addWeight("bias", [n * this.depthMultiplier], null, this.biasInitializer, this.biasRegularizer, true, this.biasConstraint) : this.bias = null, this.built = true;
  }
  call(e, t) {
    return j(() => {
      e = Oe(e);
      let n = BB(e, this.depthwiseKernel.read(), this.strides, this.padding, this.dataFormat, null);
      return this.useBias && (n = ws(n, this.bias.read(), this.dataFormat)), this.activation != null && (n = this.activation.apply(n)), n;
    });
  }
  computeOutputShape(e) {
    e = nt(e);
    let t = this.dataFormat === "channelsFirst" ? e[2] : e[1], n = this.dataFormat === "channelsFirst" ? e[3] : e[2], s = this.dataFormat === "channelsFirst" ? e[1] * this.depthMultiplier : e[3] * this.depthMultiplier, r = gs(t, this.kernelSize[0], this.padding, this.strides[0]), a = gs(n, this.kernelSize[1], this.padding, this.strides[1]);
    return this.dataFormat === "channelsFirst" ? [e[0], s, r, a] : [e[0], r, a, s];
  }
  getConfig() {
    let e = super.getConfig();
    return e.depthMultiplier = this.depthMultiplier, e.depthwiseInitializer = yt(this.depthwiseInitializer), e.depthwiseRegularizer = it(this.depthwiseRegularizer), e.depthwiseConstraint = Ot(this.depthwiseRegularizer), e;
  }
};
iy.className = "DepthwiseConv2D";
ae.registerClass(iy);
function DS(e, t, n, s) {
  if (Array.isArray(e)) {
    if (t != null || n != null)
      throw new U("When inputs is an array, neither initialState or constants should be provided");
    s != null && (n = e.slice(e.length - s, e.length), e = e.slice(0, e.length - s)), e.length > 1 && (t = e.slice(1, e.length)), e = e[0];
  }
  function r(a) {
    return a == null || Array.isArray(a) ? a : [a];
  }
  return t = r(t), n = r(n), { inputs: e, initialState: t, constants: n };
}
function FS(e, t, n, s = false, r, a, i = false, o = false) {
  return j(() => {
    let u = t.shape.length;
    if (u < 3)
      throw new U(`Input should be at least 3D, but is ${u}D.`);
    let l = [1, 0].concat(ys(2, u));
    if (t = qe(t, l), a != null)
      throw new Fe("The rnn() functoin of the deeplearn.js backend does not support constants yet.");
    i && console.warn("Backend rnn(): the unroll = true option is not applicable to the imperative deeplearn.js backend."), r != null && (r = ce(ce(r, "bool"), "float32"), r.rank === u - 1 && (r = Pn(r, -1)), r = qe(r, l)), s && (t = Zn(t, 0), r != null && (r = Zn(r, 0)));
    let c = [], p, d = n, h = t.shape[0], f = Fs(t), m;
    r != null && (m = Fs(r));
    for (let b = 0; b < h; ++b) {
      let y = f[b], v = j(() => e(y, d));
      if (r == null)
        p = v[0], d = v[1];
      else {
        let x = j(() => {
          let k = m[b], T = ge(Qn(k), k), N = ie(V(v[0], k), V(d[0], T)), E = d.map((A, P) => ie(V(v[1][P], k), V(A, T)));
          return { output: N, newStates: E };
        });
        p = x.output, d = x.newStates;
      }
      o && c.push(p);
    }
    let g;
    return o && (g = Jn(c, 1)), [p, g, d];
  });
}
var OS = class extends Ge {
  constructor(e) {
    super(e);
    let t;
    if (e.cell == null)
      throw new U("cell property is missing for the constructor of RNN.");
    if (Array.isArray(e.cell) ? t = new Vp({ cells: e.cell }) : t = e.cell, t.stateSize == null)
      throw new U("The RNN cell should have an attribute `stateSize` (tuple of integers, one integer per RNN state).");
    this.cell = t, this.returnSequences = e.returnSequences == null ? false : e.returnSequences, this.returnState = e.returnState == null ? false : e.returnState, this.goBackwards = e.goBackwards == null ? false : e.goBackwards, this._stateful = e.stateful == null ? false : e.stateful, this.unroll = e.unroll == null ? false : e.unroll, this.supportsMasking = true, this.inputSpec = [new Dt({ ndim: 3 })], this.stateSpec = null, this.states_ = null, this.numConstants = null, this.keptStates = [];
  }
  getStates() {
    if (this.states_ == null) {
      let e = Array.isArray(this.cell.stateSize) ? this.cell.stateSize.length : 1;
      return ys(0, e).map((t) => null);
    } else
      return this.states_;
  }
  setStates(e) {
    this.states_ = e;
  }
  computeOutputShape(e) {
    ym(e) && (e = e[0]), e = e;
    let t = this.cell.stateSize;
    Array.isArray(t) || (t = [t]);
    let n = t[0], s;
    if (this.returnSequences ? s = [e[0], e[1], n] : s = [e[0], n], this.returnState) {
      let r = [];
      for (let a of t)
        r.push([e[0], a]);
      return [s].concat(r);
    } else
      return s;
  }
  computeMask(e, t) {
    return j(() => {
      Array.isArray(t) && (t = t[0]);
      let n = this.returnSequences ? t : null;
      if (this.returnState) {
        let s = this.states.map((r) => null);
        return [n].concat(s);
      } else
        return n;
    });
  }
  get states() {
    if (this.states_ == null) {
      let e = Array.isArray(this.cell.stateSize) ? this.cell.stateSize.length : 1, t = [];
      for (let n = 0; n < e; ++n)
        t.push(null);
      return t;
    } else
      return this.states_;
  }
  set states(e) {
    this.states_ = e;
  }
  build(e) {
    if (this.numConstants != null)
      throw new Fe("Constants support is not implemented in RNN yet.");
    ym(e) && (e = e[0]), e = e;
    let n = this.stateful ? e[0] : null, s = e.slice(2);
    this.inputSpec[0] = new Dt({ shape: [n, null, ...s] });
    let r = [e[0]].concat(e.slice(2));
    this.cell.build(r);
    let a;
    if (Array.isArray(this.cell.stateSize) ? a = this.cell.stateSize : a = [this.cell.stateSize], this.stateSpec != null) {
      if (!w.arraysEqual(this.stateSpec.map((i) => i.shape[i.shape.length - 1]), a))
        throw new U(`An initialState was passed that is not compatible with cell.stateSize. Received stateSpec=${this.stateSpec}; However cell.stateSize is ${this.cell.stateSize}`);
    } else
      this.stateSpec = a.map((i) => new Dt({ shape: [null, i] }));
    this.stateful && this.resetStates();
  }
  resetStates(e, t = false) {
    j(() => {
      if (!this.stateful)
        throw new Vs("Cannot call resetStates() on an RNN Layer that is not stateful.");
      let n = this.inputSpec[0].shape[0];
      if (n == null)
        throw new U("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");
      if (this.states_ == null)
        Array.isArray(this.cell.stateSize) ? this.states_ = this.cell.stateSize.map((s) => $t([n, s])) : this.states_ = [$t([n, this.cell.stateSize])];
      else if (e == null)
        Re(this.states_), this.keptStates != null && (Re(this.keptStates), this.keptStates = []), Array.isArray(this.cell.stateSize) ? this.states_ = this.cell.stateSize.map((s) => $t([n, s])) : this.states_[0] = $t([n, this.cell.stateSize]);
      else {
        if (Array.isArray(e) || (e = [e]), e.length !== this.states_.length)
          throw new U(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${e.length} state value(s). Input received: ${e}`);
        t === true ? this.keptStates.push(this.states_.slice()) : Re(this.states_);
        for (let s = 0; s < this.states_.length; ++s) {
          let r = e[s], a = Array.isArray(this.cell.stateSize) ? this.cell.stateSize[s] : this.cell.stateSize, i = [n, a];
          if (!w.arraysEqual(r.shape, i))
            throw new U(`State ${s} is incompatible with layer ${this.name}: expected shape=${i}, received shape=${r.shape}`);
          this.states_[s] = r;
        }
      }
      this.states_ = this.states_.map((s) => Ht(s.clone()));
    });
  }
  apply(e, t) {
    let n = t == null ? null : t.initialState, s = t == null ? null : t.constants;
    t == null && (t = {});
    let r = DS(e, n, s, this.numConstants);
    e = r.inputs, n = r.initialState, s = r.constants;
    let a = [], i = [];
    if (n != null) {
      t.initialState = n, a = a.concat(n), this.stateSpec = [];
      for (let u of n)
        this.stateSpec.push(new Dt({ shape: u.shape }));
      i = i.concat(this.stateSpec);
    }
    if (s != null && (t.constants = s, a = a.concat(s), this.numConstants = s.length), a[0] instanceof $s) {
      let u = [e].concat(a), l = this.inputSpec.concat(i), c = this.inputSpec;
      this.inputSpec = l;
      let p = super.apply(u, t);
      return this.inputSpec = c, p;
    } else
      return super.apply(e, t);
  }
  call(e, t) {
    return j(() => {
      let n = t == null ? null : t.mask, s = t == null ? null : t.training, r = t == null ? null : t.initialState;
      e = Oe(e), r == null && (this.stateful ? r = this.states_ : r = this.getInitialState(e));
      let a = Array.isArray(this.cell.stateSize) ? this.cell.stateSize.length : 1;
      if (r.length !== a)
        throw new U(`RNN Layer has ${a} state(s) but was passed ${r.length} initial state(s).`);
      this.unroll && console.warn("Ignoring unroll = true for RNN layer, due to imperative backend.");
      let i = { training: s }, u = FS((h, f) => {
        let m = this.cell.call([h].concat(f), i);
        return [m[0], m.slice(1)];
      }, e, r, this.goBackwards, n, null, this.unroll, this.returnSequences), l = u[0], c = u[1], p = u[2];
      this.stateful && this.resetStates(p, s);
      let d = this.returnSequences ? c : l;
      return this.returnState ? [d].concat(p) : d;
    });
  }
  getInitialState(e) {
    return j(() => {
      let t = $t(e.shape);
      return t = ve(t, [1, 2]), t = Vl(t), Array.isArray(this.cell.stateSize) ? this.cell.stateSize.map((n) => n > 1 ? gm(t, [1, n]) : t) : this.cell.stateSize > 1 ? [gm(t, [1, this.cell.stateSize])] : [t];
    });
  }
  get trainableWeights() {
    return this.trainable ? this.cell.trainableWeights : [];
  }
  get nonTrainableWeights() {
    return this.trainable ? this.cell.nonTrainableWeights : this.cell.weights;
  }
  setFastWeightInitDuringBuild(e) {
    super.setFastWeightInitDuringBuild(e), this.cell != null && this.cell.setFastWeightInitDuringBuild(e);
  }
  getConfig() {
    let e = super.getConfig(), t = { returnSequences: this.returnSequences, returnState: this.returnState, goBackwards: this.goBackwards, stateful: this.stateful, unroll: this.unroll };
    this.numConstants != null && (t.numConstants = this.numConstants);
    let n = this.cell.getConfig();
    return this.getClassName() === OS.className && (t.cell = { className: this.cell.getClassName(), config: n }), { ...n, ...e, ...t };
  }
  static fromConfig(e, t, n = {}) {
    let s = t.cell, r = ms(s, n);
    return new e(Object.assign(t, { cell: r }));
  }
};
var Ar = OS;
Ar.className = "RNN";
ae.registerClass(Ar);
var ql = class extends Ge {
};
var Lp = class extends ql {
  constructor(e) {
    super(e), this.DEFAULT_ACTIVATION = "tanh", this.DEFAULT_KERNEL_INITIALIZER = "glorotNormal", this.DEFAULT_RECURRENT_INITIALIZER = "orthogonal", this.DEFAULT_BIAS_INITIALIZER = "zeros", this.units = e.units, Bt(this.units, "units"), this.activation = yr(e.activation == null ? this.DEFAULT_ACTIVATION : e.activation), this.useBias = e.useBias == null ? true : e.useBias, this.kernelInitializer = ht(e.kernelInitializer || this.DEFAULT_KERNEL_INITIALIZER), this.recurrentInitializer = ht(e.recurrentInitializer || this.DEFAULT_RECURRENT_INITIALIZER), this.biasInitializer = ht(e.biasInitializer || this.DEFAULT_BIAS_INITIALIZER), this.kernelRegularizer = ft(e.kernelRegularizer), this.recurrentRegularizer = ft(e.recurrentRegularizer), this.biasRegularizer = ft(e.biasRegularizer), this.kernelConstraint = Pt(e.kernelConstraint), this.recurrentConstraint = Pt(e.recurrentConstraint), this.biasConstraint = Pt(e.biasConstraint), this.dropout = Zi([1, gr([0, e.dropout == null ? 0 : e.dropout])]), this.recurrentDropout = Zi([1, gr([0, e.recurrentDropout == null ? 0 : e.recurrentDropout])]), this.dropoutFunc = e.dropoutFunc, this.stateSize = this.units, this.dropoutMask = null, this.recurrentDropoutMask = null;
  }
  build(e) {
    e = nt(e), this.kernel = this.addWeight("kernel", [e[e.length - 1], this.units], null, this.kernelInitializer, this.kernelRegularizer, true, this.kernelConstraint), this.recurrentKernel = this.addWeight("recurrent_kernel", [this.units, this.units], null, this.recurrentInitializer, this.recurrentRegularizer, true, this.recurrentConstraint), this.useBias ? this.bias = this.addWeight("bias", [this.units], null, this.biasInitializer, this.biasRegularizer, true, this.biasConstraint) : this.bias = null, this.built = true;
  }
  call(e, t) {
    return j(() => {
      if (e = e, e.length !== 2)
        throw new U(`SimpleRNNCell expects 2 input Tensors, got ${e.length}.`);
      let n = e[1];
      e = e[0];
      let s = t.training == null ? false : t.training;
      0 < this.dropout && this.dropout < 1 && this.dropoutMask == null && (this.dropoutMask = vr({ ones: () => Qn(e), rate: this.dropout, training: s, dropoutFunc: this.dropoutFunc })), 0 < this.recurrentDropout && this.recurrentDropout < 1 && this.recurrentDropoutMask == null && (this.recurrentDropoutMask = vr({ ones: () => Qn(n), rate: this.recurrentDropout, training: s, dropoutFunc: this.dropoutFunc }));
      let r, a = this.dropoutMask, i = this.recurrentDropoutMask;
      a != null ? r = Es(V(e, a), this.kernel.read()) : r = Es(e, this.kernel.read()), this.bias != null && (r = ws(r, this.bias.read())), i != null && (n = V(n, i));
      let o = ie(r, Es(n, this.recurrentKernel.read()));
      return this.activation != null && (o = this.activation.apply(o)), [o, o];
    });
  }
  getConfig() {
    let e = super.getConfig(), t = { units: this.units, activation: br(this.activation), useBias: this.useBias, kernelInitializer: yt(this.kernelInitializer), recurrentInitializer: yt(this.recurrentInitializer), biasInitializer: yt(this.biasInitializer), kernelRegularizer: it(this.kernelRegularizer), recurrentRegularizer: it(this.recurrentRegularizer), biasRegularizer: it(this.biasRegularizer), activityRegularizer: it(this.activityRegularizer), kernelConstraint: Ot(this.kernelConstraint), recurrentConstraint: Ot(this.recurrentConstraint), biasConstraint: Ot(this.biasConstraint), dropout: this.dropout, recurrentDropout: this.recurrentDropout };
    return { ...e, ...t };
  }
};
Lp.className = "SimpleRNNCell";
ae.registerClass(Lp);
var oy = class extends Ar {
  constructor(e) {
    e.cell = new Lp(e), super(e);
  }
  call(e, t) {
    return j(() => {
      this.cell.dropoutMask != null && (Re(this.cell.dropoutMask), this.cell.dropoutMask = null), this.cell.recurrentDropoutMask != null && (Re(this.cell.recurrentDropoutMask), this.cell.recurrentDropoutMask = null);
      let n = t == null ? null : t.mask, s = t == null ? null : t.training, r = t == null ? null : t.initialState;
      return super.call(e, { mask: n, training: s, initialState: r });
    });
  }
  static fromConfig(e, t) {
    return new e(t);
  }
};
oy.className = "SimpleRNN";
ae.registerClass(oy);
var Bp = class extends ql {
  constructor(e) {
    if (super(e), this.DEFAULT_ACTIVATION = "tanh", this.DEFAULT_RECURRENT_ACTIVATION = "hardSigmoid", this.DEFAULT_KERNEL_INITIALIZER = "glorotNormal", this.DEFAULT_RECURRENT_INITIALIZER = "orthogonal", this.DEFAULT_BIAS_INITIALIZER = "zeros", e.resetAfter)
      throw new U("GRUCell does not support reset_after parameter set to true.");
    this.units = e.units, Bt(this.units, "units"), this.activation = yr(e.activation === void 0 ? this.DEFAULT_ACTIVATION : e.activation), this.recurrentActivation = yr(e.recurrentActivation === void 0 ? this.DEFAULT_RECURRENT_ACTIVATION : e.recurrentActivation), this.useBias = e.useBias == null ? true : e.useBias, this.kernelInitializer = ht(e.kernelInitializer || this.DEFAULT_KERNEL_INITIALIZER), this.recurrentInitializer = ht(e.recurrentInitializer || this.DEFAULT_RECURRENT_INITIALIZER), this.biasInitializer = ht(e.biasInitializer || this.DEFAULT_BIAS_INITIALIZER), this.kernelRegularizer = ft(e.kernelRegularizer), this.recurrentRegularizer = ft(e.recurrentRegularizer), this.biasRegularizer = ft(e.biasRegularizer), this.kernelConstraint = Pt(e.kernelConstraint), this.recurrentConstraint = Pt(e.recurrentConstraint), this.biasConstraint = Pt(e.biasConstraint), this.dropout = Zi([1, gr([0, e.dropout == null ? 0 : e.dropout])]), this.recurrentDropout = Zi([1, gr([0, e.recurrentDropout == null ? 0 : e.recurrentDropout])]), this.dropoutFunc = e.dropoutFunc, this.implementation = e.implementation, this.stateSize = this.units, this.dropoutMask = null, this.recurrentDropoutMask = null;
  }
  build(e) {
    e = nt(e);
    let t = e[e.length - 1];
    this.kernel = this.addWeight("kernel", [t, this.units * 3], null, this.kernelInitializer, this.kernelRegularizer, true, this.kernelConstraint), this.recurrentKernel = this.addWeight("recurrent_kernel", [this.units, this.units * 3], null, this.recurrentInitializer, this.recurrentRegularizer, true, this.recurrentConstraint), this.useBias ? this.bias = this.addWeight("bias", [this.units * 3], null, this.biasInitializer, this.biasRegularizer, true, this.biasConstraint) : this.bias = null, this.built = true;
  }
  call(e, t) {
    return j(() => {
      if (e = e, e.length !== 2)
        throw new U(`GRUCell expects 2 input Tensors (inputs, h, c), got ${e.length}.`);
      let n = t.training == null ? false : t.training, s = e[1];
      e = e[0], 0 < this.dropout && this.dropout < 1 && this.dropoutMask == null && (this.dropoutMask = vr({ ones: () => Qn(e), rate: this.dropout, training: n, count: 3, dropoutFunc: this.dropoutFunc })), 0 < this.recurrentDropout && this.recurrentDropout < 1 && this.recurrentDropoutMask == null && (this.recurrentDropoutMask = vr({ ones: () => Qn(s), rate: this.recurrentDropout, training: n, count: 3, dropoutFunc: this.dropoutFunc }));
      let r = this.dropoutMask, a = this.recurrentDropoutMask, i, o, u;
      0 < this.dropout && this.dropout < 1 && (e = V(e, r[0]));
      let l = Es(e, this.kernel.read());
      this.useBias && (l = ws(l, this.bias.read())), 0 < this.recurrentDropout && this.recurrentDropout < 1 && (s = V(s, a[0]));
      let c = this.recurrentKernel.read(), [p, d] = Bn(c, [2 * this.units, this.units], c.rank - 1), h = Es(s, p), [f, m, g] = Bn(l, 3, l.rank - 1), [b, y] = Bn(h, 2, h.rank - 1);
      i = this.recurrentActivation.apply(ie(f, b)), o = this.recurrentActivation.apply(ie(m, y));
      let v = Es(V(o, s), d);
      u = this.activation.apply(ie(g, v));
      let x = ie(V(i, s), V(ie(1, kt(i)), u));
      return [x, x];
    });
  }
  getConfig() {
    let e = super.getConfig(), t = { units: this.units, activation: br(this.activation), recurrentActivation: br(this.recurrentActivation), useBias: this.useBias, kernelInitializer: yt(this.kernelInitializer), recurrentInitializer: yt(this.recurrentInitializer), biasInitializer: yt(this.biasInitializer), kernelRegularizer: it(this.kernelRegularizer), recurrentRegularizer: it(this.recurrentRegularizer), biasRegularizer: it(this.biasRegularizer), activityRegularizer: it(this.activityRegularizer), kernelConstraint: Ot(this.kernelConstraint), recurrentConstraint: Ot(this.recurrentConstraint), biasConstraint: Ot(this.biasConstraint), dropout: this.dropout, recurrentDropout: this.recurrentDropout, implementation: this.implementation, resetAfter: false };
    return { ...e, ...t };
  }
};
Bp.className = "GRUCell";
ae.registerClass(Bp);
var uy = class extends Ar {
  constructor(e) {
    e.implementation === 0 && console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."), e.cell = new Bp(e), super(e);
  }
  call(e, t) {
    return j(() => {
      this.cell.dropoutMask != null && (Re(this.cell.dropoutMask), this.cell.dropoutMask = null), this.cell.recurrentDropoutMask != null && (Re(this.cell.recurrentDropoutMask), this.cell.recurrentDropoutMask = null);
      let n = t == null ? null : t.mask, s = t == null ? null : t.training, r = t == null ? null : t.initialState;
      return super.call(e, { mask: n, training: s, initialState: r });
    });
  }
  static fromConfig(e, t) {
    return t.implmentation === 0 && (t.implementation = 1), new e(t);
  }
};
uy.className = "GRU";
ae.registerClass(uy);
var jl = class extends ql {
  constructor(e) {
    super(e), this.DEFAULT_ACTIVATION = "tanh", this.DEFAULT_RECURRENT_ACTIVATION = "hardSigmoid", this.DEFAULT_KERNEL_INITIALIZER = "glorotNormal", this.DEFAULT_RECURRENT_INITIALIZER = "orthogonal", this.DEFAULT_BIAS_INITIALIZER = "zeros", this.units = e.units, Bt(this.units, "units"), this.activation = yr(e.activation === void 0 ? this.DEFAULT_ACTIVATION : e.activation), this.recurrentActivation = yr(e.recurrentActivation === void 0 ? this.DEFAULT_RECURRENT_ACTIVATION : e.recurrentActivation), this.useBias = e.useBias == null ? true : e.useBias, this.kernelInitializer = ht(e.kernelInitializer || this.DEFAULT_KERNEL_INITIALIZER), this.recurrentInitializer = ht(e.recurrentInitializer || this.DEFAULT_RECURRENT_INITIALIZER), this.biasInitializer = ht(e.biasInitializer || this.DEFAULT_BIAS_INITIALIZER), this.unitForgetBias = e.unitForgetBias, this.kernelRegularizer = ft(e.kernelRegularizer), this.recurrentRegularizer = ft(e.recurrentRegularizer), this.biasRegularizer = ft(e.biasRegularizer), this.kernelConstraint = Pt(e.kernelConstraint), this.recurrentConstraint = Pt(e.recurrentConstraint), this.biasConstraint = Pt(e.biasConstraint), this.dropout = Zi([1, gr([0, e.dropout == null ? 0 : e.dropout])]), this.recurrentDropout = Zi([1, gr([0, e.recurrentDropout == null ? 0 : e.recurrentDropout])]), this.dropoutFunc = e.dropoutFunc, this.implementation = e.implementation, this.stateSize = [this.units, this.units], this.dropoutMask = null, this.recurrentDropoutMask = null;
  }
  build(e) {
    var t;
    e = nt(e);
    let n = e[e.length - 1];
    this.kernel = this.addWeight("kernel", [n, this.units * 4], null, this.kernelInitializer, this.kernelRegularizer, true, this.kernelConstraint), this.recurrentKernel = this.addWeight("recurrent_kernel", [this.units, this.units * 4], null, this.recurrentInitializer, this.recurrentRegularizer, true, this.recurrentConstraint);
    let s;
    if (this.useBias) {
      if (this.unitForgetBias) {
        let r = this.biasInitializer, a = this.units;
        s = new (t = class extends ns {
          apply(i, o) {
            let u = r.apply([a]), l = new Np().apply([a]), c = r.apply([a * 2]);
            return $x($x(u, l), c);
          }
        }, t.className = "CustomInit", t)();
      } else
        s = this.biasInitializer;
      this.bias = this.addWeight("bias", [this.units * 4], null, s, this.biasRegularizer, true, this.biasConstraint);
    } else
      this.bias = null;
    this.built = true;
  }
  call(e, t) {
    return j(() => {
      let n = t.training == null ? false : t.training;
      if (e = e, e.length !== 3)
        throw new U(`LSTMCell expects 3 input Tensors (inputs, h, c), got ${e.length}.`);
      let s = e[1], r = e[2];
      e = e[0], 0 < this.dropout && this.dropout < 1 && this.dropoutMask == null && (this.dropoutMask = vr({ ones: () => Qn(e), rate: this.dropout, training: n, count: 4, dropoutFunc: this.dropoutFunc })), 0 < this.recurrentDropout && this.recurrentDropout < 1 && this.recurrentDropoutMask == null && (this.recurrentDropoutMask = vr({ ones: () => Qn(s), rate: this.recurrentDropout, training: n, count: 4, dropoutFunc: this.dropoutFunc }));
      let a = this.dropoutMask, i = this.recurrentDropoutMask, o, u, l, c;
      0 < this.dropout && this.dropout < 1 && (e = V(e, a[0]));
      let p = Es(e, this.kernel.read());
      0 < this.recurrentDropout && this.recurrentDropout < 1 && (s = V(s, i[0])), p = ie(p, Es(s, this.recurrentKernel.read())), this.useBias && (p = ws(p, this.bias.read()));
      let [d, h, f, m] = Bn(p, 4, p.rank - 1);
      o = this.recurrentActivation.apply(d), u = this.recurrentActivation.apply(h), l = ie(V(u, r), V(o, this.activation.apply(f))), c = this.recurrentActivation.apply(m);
      let g = V(c, this.activation.apply(l));
      return [g, g, l];
    });
  }
  getConfig() {
    let e = super.getConfig(), t = { units: this.units, activation: br(this.activation), recurrentActivation: br(this.recurrentActivation), useBias: this.useBias, kernelInitializer: yt(this.kernelInitializer), recurrentInitializer: yt(this.recurrentInitializer), biasInitializer: yt(this.biasInitializer), unitForgetBias: this.unitForgetBias, kernelRegularizer: it(this.kernelRegularizer), recurrentRegularizer: it(this.recurrentRegularizer), biasRegularizer: it(this.biasRegularizer), activityRegularizer: it(this.activityRegularizer), kernelConstraint: Ot(this.kernelConstraint), recurrentConstraint: Ot(this.recurrentConstraint), biasConstraint: Ot(this.biasConstraint), dropout: this.dropout, recurrentDropout: this.recurrentDropout, implementation: this.implementation };
    return { ...e, ...t };
  }
};
jl.className = "LSTMCell";
ae.registerClass(jl);
var ly = class extends Ar {
  constructor(e) {
    e.implementation === 0 && console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."), e.cell = new jl(e), super(e);
  }
  call(e, t) {
    return j(() => {
      this.cell.dropoutMask != null && (Re(this.cell.dropoutMask), this.cell.dropoutMask = null), this.cell.recurrentDropoutMask != null && (Re(this.cell.recurrentDropoutMask), this.cell.recurrentDropoutMask = null);
      let n = t == null ? null : t.mask, s = t == null ? null : t.training, r = t == null ? null : t.initialState;
      return super.call(e, { mask: n, training: s, initialState: r });
    });
  }
  static fromConfig(e, t) {
    return t.implmentation === 0 && (t.implementation = 1), new e(t);
  }
};
ly.className = "LSTM";
ae.registerClass(ly);
var Vp = class extends ql {
  constructor(e) {
    super(e), this.cells = e.cells;
  }
  get stateSize() {
    let e = [];
    for (let t of this.cells.slice().reverse())
      Array.isArray(t.stateSize) ? e.push(...t.stateSize) : e.push(t.stateSize);
    return e;
  }
  call(e, t) {
    return j(() => {
      e = e;
      let n = e.slice(1), s = [];
      for (let i of this.cells.slice().reverse())
        Array.isArray(i.stateSize) ? s.push(n.splice(0, i.stateSize.length)) : s.push(n.splice(0, 1));
      s.reverse();
      let r = [], a;
      for (let i = 0; i < this.cells.length; ++i) {
        let o = this.cells[i];
        n = s[i], i === 0 ? a = [e[0]].concat(n) : a = [a[0]].concat(n), a = o.call(a, t), r.push(a.slice(1));
      }
      n = [];
      for (let i of r.slice().reverse())
        n.push(...i);
      return [a[0]].concat(n);
    });
  }
  build(e) {
    ym(e) && (e = e[0]), e = e;
    let t;
    this.cells.forEach((n, s) => {
      ea(`RNNCell_${s}`, () => {
        n.build(e), Array.isArray(n.stateSize) ? t = n.stateSize[0] : t = n.stateSize, e = [e[0], t];
      });
    }), this.built = true;
  }
  getConfig() {
    let e = super.getConfig(), t = (r) => ({ className: r.getClassName(), config: r.getConfig() }), s = { cells: this.cells.map(t) };
    return { ...e, ...s };
  }
  static fromConfig(e, t, n = {}) {
    let s = [];
    for (let r of t.cells)
      s.push(ms(r, n));
    return new e({ cells: s });
  }
  get trainableWeights() {
    if (!this.trainable)
      return [];
    let e = [];
    for (let t of this.cells)
      e.push(...t.trainableWeights);
    return e;
  }
  get nonTrainableWeights() {
    let e = [];
    for (let t of this.cells)
      e.push(...t.nonTrainableWeights);
    if (!this.trainable) {
      let t = [];
      for (let n of this.cells)
        t.push(...n.trainableWeights);
      return t.concat(e);
    }
    return e;
  }
  getWeights() {
    let e = [];
    for (let t of this.cells)
      e.push(...t.weights);
    return vm(e);
  }
  setWeights(e) {
    let t = [];
    for (let n of this.cells) {
      let s = n.weights.length, r = e.splice(s);
      for (let a = 0; a < n.weights.length; ++a)
        t.push([n.weights[a], r[a]]);
    }
    Pb(t);
  }
};
Vp.className = "StackedRNNCells";
ae.registerClass(Vp);
function vr(e) {
  let { ones: t, rate: n, training: s = false, count: r = 1, dropoutFunc: a } = e, i = () => a != null ? a(t(), n) : XI(t(), n), o = () => Ul(i, t, s);
  return !r || r <= 1 ? Ht(o().clone()) : Array(r).fill(void 0).map(o).map((l) => Ht(l.clone()));
}
var PS = class extends Ar {
  constructor(e) {
    if (e.unroll)
      throw new Fe("Unrolling is not possible with convolutional RNNs.");
    if (Array.isArray(e.cell))
      throw new Fe("It is not possible at the moment to stack convolutional cells.");
    super(e), this.inputSpec = [new Dt({ ndim: 5 })];
  }
  call(e, t) {
    return j(() => {
      if (this.cell.dropoutMask != null && (Re(this.cell.dropoutMask), this.cell.dropoutMask = null), this.cell.recurrentDropoutMask != null && (Re(this.cell.recurrentDropoutMask), this.cell.recurrentDropoutMask = null), t && t.constants)
        throw new U("ConvRNN2D cell does not support constants");
      let n = t == null ? null : t.mask, s = t == null ? null : t.training, r = t == null ? null : t.initialState;
      return super.call(e, { mask: n, training: s, initialState: r });
    });
  }
  computeOutputShape(e) {
    let t = this.computeSingleOutputShape(e);
    return this.returnSequences || (t = [t[0], ...t.slice(2)]), this.returnState && (t = [t, ...Array(2).fill([e[0], ...t.slice(-3)])]), t;
  }
  getInitialState(e) {
    return j(() => {
      let { stateSize: t } = this.cell, n = e.shape, s = this.computeSingleOutputShape(n), r = [s[0], ...s.slice(2)], a = $t(r);
      return Array.isArray(t) ? Array(t.length).fill(a) : [a];
    });
  }
  resetStates(e, t = false) {
    j(() => {
      if (!this.stateful)
        throw new Vs("Cannot call resetStates() on an RNN Layer that is not stateful.");
      let n = this.inputSpec[0].shape, s = this.computeSingleOutputShape(n), r = [s[0], ...s.slice(2)];
      if (n[0] == null)
        throw new U("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");
      if (this.getStates() == null)
        Array.isArray(this.cell.stateSize) ? this.states_ = this.cell.stateSize.map(() => $t(r)) : this.states_ = [$t(r)];
      else if (e == null)
        Re(this.states_), this.keptStates != null && (Re(this.keptStates), this.keptStates = []), Array.isArray(this.cell.stateSize) ? this.states_ = this.cell.stateSize.map(() => $t(r)) : this.states_[0] = $t(r);
      else {
        if (Array.isArray(e) || (e = [e]), e.length !== this.states_.length)
          throw new U(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${e.length} state value(s). Input received: ${e}`);
        t ? this.keptStates.push(this.states_.slice()) : Re(this.states_);
        for (let i = 0; i < this.states_.length; ++i) {
          let o = e[i], u = r;
          if (!w.arraysEqual(o.shape, u))
            throw new U(`State ${i} is incompatible with layer ${this.name}: expected shape=${u}, received shape=${o.shape}`);
          this.states_[i] = o;
        }
      }
      this.states_ = this.states_.map((i) => Ht(i.clone()));
    });
  }
  computeSingleOutputShape(e) {
    let { dataFormat: t, filters: n, kernelSize: s, padding: r, strides: a, dilationRate: i } = this.cell, o = t === "channelsFirst", u = e[o ? 3 : 2], l = e[o ? 4 : 3], c = gs(u, s[0], r, a[0], i[0]), p = gs(l, s[1], r, a[1], i[1]);
    return [...e.slice(0, 2), ...o ? [n, c, p] : [c, p, n]];
  }
};
PS.className = "ConvRNN2D";
var Wp = class extends jl {
  constructor(e) {
    let { filters: t, kernelSize: n, strides: s, padding: r, dataFormat: a, dilationRate: i } = e;
    super({ ...e, units: t }), this.filters = t, Bt(this.filters, "filters"), this.kernelSize = Xi(n, 2, "kernelSize"), this.kernelSize.forEach((o) => Bt(o, "kernelSize")), this.strides = Xi(s || 1, 2, "strides"), this.strides.forEach((o) => Bt(o, "strides")), this.padding = r || "valid", Un(this.padding), this.dataFormat = a || "channelsLast", Ct(this.dataFormat), this.dilationRate = Xi(i || 1, 2, "dilationRate"), this.dilationRate.forEach((o) => Bt(o, "dilationRate"));
  }
  build(e) {
    var t;
    e = nt(e);
    let n = this.dataFormat === "channelsFirst" ? 1 : e.length - 1;
    if (e[n] == null)
      throw new U(`The channel dimension of the input should be defined. Found ${e[n]}`);
    let s = e[n], r = 4, a = this.kernelSize.concat([s, this.filters * r]);
    this.kernel = this.addWeight("kernel", a, null, this.kernelInitializer, this.kernelRegularizer, true, this.kernelConstraint);
    let i = this.kernelSize.concat([this.filters, this.filters * r]);
    if (this.recurrentKernel = this.addWeight("recurrent_kernel", i, null, this.recurrentInitializer, this.recurrentRegularizer, true, this.recurrentConstraint), this.useBias) {
      let o;
      if (this.unitForgetBias) {
        let u = this.biasInitializer, l = this.filters;
        o = new (t = class extends ns {
          apply(c, p) {
            let d = u.apply([l]), h = Mn([l]), f = u.apply([l * 2]);
            return $b([d, h, f]);
          }
        }, t.className = "CustomInit", t)();
      } else
        o = this.biasInitializer;
      this.bias = this.addWeight("bias", [this.filters * r], null, o, this.biasRegularizer, true, this.biasConstraint);
    }
    this.built = true;
  }
  call(e, t) {
    return j(() => {
      if (e.length !== 3)
        throw new U(`ConvLSTM2DCell expects 3 input Tensors (inputs, h, c), got ${e.length}.`);
      let n = t.training || false, s = e[0], r = e[1], a = e[2], i = 4;
      0 < this.dropout && this.dropout < 1 && this.dropoutMask == null && (this.dropoutMask = vr({ ones: () => Qn(s), rate: this.dropout, training: n, count: i, dropoutFunc: this.dropoutFunc }));
      let o = this.dropoutMask, u = (Z, te, ee) => !te || !te[ee] ? Z : V(te[ee], Z), l = u(s, o, 0), c = u(s, o, 1), p = u(s, o, 2), d = u(s, o, 3);
      0 < this.recurrentDropout && this.recurrentDropout < 1 && this.recurrentDropoutMask == null && (this.recurrentDropoutMask = vr({ ones: () => Qn(r), rate: this.recurrentDropout, training: n, count: i, dropoutFunc: this.dropoutFunc }));
      let h = this.recurrentDropoutMask, f = u(r, h, 0), m = u(r, h, 1), g = u(r, h, 2), b = u(r, h, 3), y = 3, [v, x, k, T] = Bn(this.kernel.read(), i, y), [N, E, A, P] = this.useBias ? Bn(this.bias.read(), i) : [null, null, null, null];
      l = this.inputConv(l, v, N, this.padding), c = this.inputConv(c, x, E, this.padding), p = this.inputConv(p, k, A, this.padding), d = this.inputConv(d, T, P, this.padding);
      let [R, F, $, z] = Bn(this.recurrentKernel.read(), i, y);
      f = this.recurrentConv(f, R), m = this.recurrentConv(m, F), g = this.recurrentConv(g, $), b = this.recurrentConv(b, z);
      let W = this.recurrentActivation.apply(ie(l, f)), q = this.recurrentActivation.apply(ie(c, m)), K = ie(V(q, a), V(W, this.activation.apply(ie(p, g)))), Y = V(this.recurrentActivation.apply(ie(d, b)), this.activation.apply(K));
      return [Y, Y, K];
    });
  }
  getConfig() {
    let { units: e, ...t } = super.getConfig(), n = { filters: this.filters, kernelSize: this.kernelSize, padding: this.padding, dataFormat: this.dataFormat, dilationRate: this.dilationRate, strides: this.strides };
    return { ...t, ...n };
  }
  inputConv(e, t, n, s) {
    let r = ca(e, t, this.strides, s || "valid", this.dataFormat === "channelsFirst" ? "NCHW" : "NHWC", this.dilationRate);
    return n ? ws(r, n, this.dataFormat) : r;
  }
  recurrentConv(e, t) {
    return ca(e, t, 1, "same", this.dataFormat === "channelsFirst" ? "NCHW" : "NHWC");
  }
};
Wp.className = "ConvLSTM2DCell";
ae.registerClass(Wp);
var cy = class extends PS {
  constructor(e) {
    let t = new Wp(e);
    super({ ...e, cell: t });
  }
  static fromConfig(e, t) {
    return new e(t);
  }
};
cy.className = "ConvLSTM2D";
ae.registerClass(cy);
var Up = class extends Ge {
  constructor(e) {
    super(e), this.rate = Math.max(Math.min(e.rate, 1), 0), this.noiseShape = e.noiseShape, this.seed = e.seed, this.supportsMasking = true;
  }
  getNoiseShape(e) {
    if (this.noiseShape == null)
      return this.noiseShape;
    let t = e.shape, n = [];
    for (let s = 0; s < this.noiseShape.length; ++s)
      n.push(this.noiseShape[s] == null ? t[s] : this.noiseShape[s]);
    return n;
  }
  call(e, t) {
    return j(() => {
      this.invokeCallHook(e, t);
      let n = Oe(e);
      if (0 < this.rate && this.rate < 1) {
        let s = t.training == null ? false : t.training, r = this.getNoiseShape(n);
        return Ul(() => XI(n, this.rate, r, this.seed), () => n, s);
      }
      return e;
    });
  }
  getConfig() {
    let e = { rate: this.rate, noiseShape: this.noiseShape, seed: this.seed }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
  dispose() {
    return super.dispose();
  }
};
Up.className = "Dropout";
ae.registerClass(Up);
var dy = class extends Up {
  constructor(e) {
    super(e), this.inputSpec = [{ ndim: 3 }];
  }
  getNoiseShape(e) {
    let t = e.shape;
    return [t[0], 1, t[2]];
  }
};
dy.className = "SpatialDropout1D";
ae.registerClass(dy);
var py = class extends Ge {
  constructor(e) {
    if (super(e), this.activation = null, this.useBias = true, this.kernel = null, this.bias = null, this.DEFAULT_KERNEL_INITIALIZER = "glorotNormal", this.DEFAULT_BIAS_INITIALIZER = "zeros", e.batchInputShape == null && e.inputShape == null && e.inputDim != null) {
      let t = null;
      e.batchSize != null && (t = e.batchSize), this.batchInputShape = [t, e.inputDim];
    }
    this.units = e.units, Bt(this.units, "units"), this.activation = yr(e.activation), e.useBias != null && (this.useBias = e.useBias), this.kernelInitializer = ht(e.kernelInitializer || this.DEFAULT_KERNEL_INITIALIZER), this.biasInitializer = ht(e.biasInitializer || this.DEFAULT_BIAS_INITIALIZER), this.kernelConstraint = Pt(e.kernelConstraint), this.biasConstraint = Pt(e.biasConstraint), this.kernelRegularizer = ft(e.kernelRegularizer), this.biasRegularizer = ft(e.biasRegularizer), this.activityRegularizer = ft(e.activityRegularizer), this.supportsMasking = true, this.inputSpec = [{ minNDim: 2 }];
  }
  build(e) {
    e = nt(e);
    let t = e[e.length - 1];
    this.kernel == null && (this.kernel = this.addWeight("kernel", [t, this.units], null, this.kernelInitializer, this.kernelRegularizer, true, this.kernelConstraint), this.useBias && (this.bias = this.addWeight("bias", [this.units], null, this.biasInitializer, this.biasRegularizer, true, this.biasConstraint))), this.inputSpec = [{ minNDim: 2, axes: { [-1]: t } }], this.built = true;
  }
  computeOutputShape(e) {
    e = nt(e);
    let t = e.slice();
    return t[t.length - 1] = this.units, t;
  }
  call(e, t) {
    return j(() => {
      this.invokeCallHook(e, t);
      let n = Oe(e), s = UI(this.activation.getClassName()), r;
      return s != null ? r = Es(n, this.kernel.read(), s, this.bias ? this.bias.read() : null) : (r = Es(n, this.kernel.read()), this.bias != null && (r = ws(r, this.bias.read())), this.activation != null && (r = this.activation.apply(r))), r;
    });
  }
  getConfig() {
    let e = { units: this.units, activation: br(this.activation), useBias: this.useBias, kernelInitializer: yt(this.kernelInitializer), biasInitializer: yt(this.biasInitializer), kernelRegularizer: it(this.kernelRegularizer), biasRegularizer: it(this.biasRegularizer), activityRegularizer: it(this.activityRegularizer), kernelConstraint: Ot(this.kernelConstraint), biasConstraint: Ot(this.biasConstraint) }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
py.className = "Dense";
ae.registerClass(py);
var hy = class extends Ge {
  constructor(e) {
    e = e || {}, super(e), this.inputSpec = [{ minNDim: 3 }], this.dataFormat = e.dataFormat;
  }
  computeOutputShape(e) {
    e = nt(e);
    for (let t of e.slice(1))
      if (t == null)
        throw new U(`The shape of the input to "Flatten" is not fully defined (got ${e.slice(1)}). Make sure to pass a complete "input_shape" or "batch_input_shape" argument to the first layer in your model.`);
    return [e[0], dr(e, 1)];
  }
  call(e, t) {
    return j(() => {
      this.invokeCallHook(e, t);
      let n = Oe(e);
      if (this.dataFormat === "channelsFirst" && n.rank > 1) {
        let s = [0];
        for (let r = 2; r < n.rank; ++r)
          s.push(r);
        s.push(1), n = qe(n, s);
      }
      return rL(n);
    });
  }
  getConfig() {
    let e = {};
    this.dataFormat != null && (e.dataFormat = this.dataFormat);
    let t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
hy.className = "Flatten";
ae.registerClass(hy);
var fy = class extends Ge {
  constructor(e) {
    super(e), this.supportsMasking = true, this.activation = yr(e.activation);
  }
  call(e, t) {
    return j(() => {
      this.invokeCallHook(e, t);
      let n = Oe(e);
      return this.activation.apply(n);
    });
  }
  getConfig() {
    let e = { activation: br(this.activation) }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
fy.className = "Activation";
ae.registerClass(fy);
var my = class extends Ge {
  constructor(e) {
    super(e), this.n = e.n, this.inputSpec = [{ ndim: 2 }];
  }
  computeOutputShape(e) {
    return [e[0], this.n, e[1]];
  }
  call(e, t) {
    return j(() => (e = Oe(e), nL(e, this.n)));
  }
  getConfig() {
    let e = { n: this.n }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
my.className = "RepeatVector";
ae.registerClass(my);
var gy = class extends Ge {
  constructor(e) {
    super(e), this.targetShape = e.targetShape;
    for (let t = 0; t < this.targetShape.length; ++t)
      this.isUnknown(this.targetShape[t]) && (this.targetShape[t] = null);
  }
  isUnknown(e) {
    return e < 0 || e == null;
  }
  fixUnknownDimension(e, t) {
    let n = "Total size of new array must be unchanged.", s = t.slice(), r = 1, a = null;
    for (let o = 0; o < s.length; ++o) {
      let u = s[o];
      if (this.isUnknown(u))
        if (a === null)
          a = o;
        else
          throw new U("Can only specifiy one unknown dimension.");
      else
        r *= u;
    }
    let i = dr(e);
    if (a !== null) {
      if (r === 0 || i % r !== 0)
        throw new U(n);
      s[a] = i / r;
    } else if (i !== r)
      throw new U(n);
    return s;
  }
  computeOutputShape(e) {
    let t = false;
    for (let n = 0; n < e.length; ++n)
      if (this.isUnknown(e[n])) {
        t = true;
        break;
      }
    return t ? e.slice(0, 1).concat(this.targetShape) : e.slice(0, 1).concat(this.fixUnknownDimension(e.slice(1), this.targetShape));
  }
  call(e, t) {
    return j(() => {
      this.invokeCallHook(e, t);
      let n = Oe(e), s = n.shape, r = s.slice(0, 1).concat(this.fixUnknownDimension(s.slice(1), this.targetShape));
      return G(n, r);
    });
  }
  getConfig() {
    let e = { targetShape: this.targetShape }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
gy.className = "Reshape";
ae.registerClass(gy);
var by = class extends Ge {
  constructor(e) {
    if (super(e), e.dims == null)
      throw new Error("Required configuration field `dims` is missing during Permute constructor call.");
    if (!Array.isArray(e.dims))
      throw new Error(`Permute constructor requires \`dims\` to be an Array, but received ${e.dims} instead.`);
    let t = ys(1, e.dims.length + 1);
    if (!w.arraysEqual(e.dims.slice().sort(), t))
      throw new Error("Invalid permutation `dims`: " + JSON.stringify(e.dims) + " `dims` must contain consecutive integers starting from 1.");
    this.dims = e.dims, this.dimsIncludingBatch = [0].concat(this.dims), this.inputSpec = [new Dt({ ndim: this.dims.length + 1 })];
  }
  computeOutputShape(e) {
    e = nt(e);
    let t = e.slice();
    return this.dims.forEach((n, s) => {
      t[s + 1] = e[n];
    }), t;
  }
  call(e, t) {
    return qe(Oe(e), this.dimsIncludingBatch);
  }
  getConfig() {
    let e = { dims: this.dims }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
by.className = "Permute";
ae.registerClass(by);
var yy = class extends Ge {
  constructor(e) {
    super(e == null ? {} : e), this.supportsMasking = true, e != null ? this.maskValue = e.maskValue == null ? 0 : e.maskValue : this.maskValue = 0;
  }
  computeOutputShape(e) {
    return e;
  }
  getConfig() {
    let e = super.getConfig(), t = { maskValue: this.maskValue };
    return Object.assign(t, e), t;
  }
  computeMask(e, t) {
    let n = Oe(e), s = -1;
    return pm(Xu(n, this.maskValue), s);
  }
  call(e, t) {
    return j(() => {
      this.invokeCallHook(e, t);
      let n = Oe(e), s = -1, r = true, a = pm(Xu(n, this.maskValue), s, r);
      return V(n, ce(a, n.dtype));
    });
  }
};
yy.className = "Masking";
ae.registerClass(yy);
var vy = class extends Ge {
  constructor(e) {
    if (super(e), this.embeddings = null, this.DEFAULT_EMBEDDINGS_INITIALIZER = "randomUniform", e.batchInputShape == null && e.inputShape == null) {
      let t = null;
      e.batchSize != null && (t = e.batchSize), e.inputLength == null ? this.batchInputShape = [t, null] : this.batchInputShape = [t].concat(dt(e.inputLength));
    }
    this.inputDim = e.inputDim, Bt(this.inputDim, "inputDim"), this.outputDim = e.outputDim, Bt(this.outputDim, "outputDim"), this.embeddingsInitializer = ht(e.embeddingsInitializer || this.DEFAULT_EMBEDDINGS_INITIALIZER), this.embeddingsRegularizer = ft(e.embeddingsRegularizer), this.activityRegularizer = ft(e.activityRegularizer), this.embeddingsConstraint = Pt(e.embeddingsConstraint), this.maskZero = e.maskZero, this.supportsMasking = e.maskZero, this.inputLength = e.inputLength;
  }
  build(e) {
    this.embeddings = this.addWeight("embeddings", [this.inputDim, this.outputDim], this.dtype, this.embeddingsInitializer, this.embeddingsRegularizer, true, this.embeddingsConstraint), this.built = true;
  }
  warnOnIncompatibleInputShape(e) {
  }
  computeMask(e, t) {
    return j(() => this.maskZero ? (e = Oe(e), Xu(e, je(e))) : null);
  }
  computeOutputShape(e) {
    if (e = nt(e), this.inputLength == null)
      return [...e, this.outputDim];
    let t = dt(this.inputLength);
    if (t.length !== e.length - 1)
      throw new U(`"inputLength" is ${this.inputLength}, but received input shape has shape ${e}`);
    {
      let n = 0;
      for (let s = 0; s < t.length; ++s) {
        let r = t[s], a = e[s + 1];
        if (r != null && a != null && r !== a)
          throw new U(`"inputLength" is ${this.inputLength}, but received input shape has shape ${e}`);
        r == null && (t[n] = a), n++;
      }
    }
    return [e[0], ...t, this.outputDim];
  }
  call(e, t) {
    return j(() => {
      this.invokeCallHook(e, t);
      let n = Oe(e);
      n.dtype !== "int32" && (n = Sp(n, "int32"));
      let s = KI(this.embeddings.read(), G(n, [n.size]));
      return G(s, nt(this.computeOutputShape(n.shape)));
    });
  }
  getConfig() {
    let e = { inputDim: this.inputDim, outputDim: this.outputDim, embeddingsInitializer: yt(this.embeddingsInitializer), embeddingsRegularizer: it(this.embeddingsRegularizer), activityRegularizer: it(this.activityRegularizer), embeddingsConstraint: Ot(this.embeddingsConstraint), maskZero: this.maskZero, inputLength: this.inputLength }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
vy.className = "Embedding";
ae.registerClass(vy);
var bi = class extends Ge {
  constructor(e) {
    super(e || {}), this.supportsMasking = true;
  }
  mergeFunction(e) {
    throw new Fe();
  }
  computeElementwiseOpOutputShape(e, t) {
    if (e == null || t == null)
      return null;
    if (e.length < t.length)
      return this.computeElementwiseOpOutputShape(t, e);
    if (t.length === 0)
      return e;
    let n = e.slice(0, e.length - t.length);
    for (let s = 0; s < t.length; ++s) {
      let r = e[e.length - t.length + s], a = t[s];
      if (r == null || a == null || r < 0 || a < 0)
        n.push(null);
      else if (r === 1)
        n.push(a);
      else if (a === 1)
        n.push(r);
      else {
        if (r !== a)
          throw new U("Operands could not be broadcast together with shapes " + JSON.stringify(e) + " " + JSON.stringify(t));
        n.push(r);
      }
    }
    return n;
  }
  build(e) {
    if (Array.isArray(e) && !Array.isArray(e[0]) && (e = [nt(e)]), e = e, e.length < 2)
      throw new U(`A merge layer should be called on an Array of at least 2 inputs. Got ${e.length} input(s).`);
    let t = [];
    for (let r of e)
      r != null && r[0] !== null && t.push(r[0]);
    if (t = cr(t), t.length > 1)
      throw new U(`Can not merge tensors with different batch sizes. Got tensors with shapes: ${JSON.stringify(e)}.`);
    let n = e[0] == null ? null : e[0].slice(1);
    for (let r = 1; r < e.length; ++r) {
      let a = e[r] == null ? null : e[r].slice(1);
      n = this.computeElementwiseOpOutputShape(n, a);
    }
    let s = e.map((r) => r.length);
    e.indexOf(null) === -1 && cr(s).length === 1 ? this.reshapeRequired = false : this.reshapeRequired = true;
  }
  call(e, t) {
    return j(() => {
      if (e = e, this.reshapeRequired) {
        let n = [], s = e.map((r) => r.rank);
        if (s.indexOf(null) === -1) {
          let r = gr(s);
          for (let a of e) {
            let i = a.rank;
            for (let o = 0; o < r - i; ++o)
              a = Vl(a, 1);
            n.push(a);
          }
          return this.mergeFunction(n);
        } else {
          let r = false;
          for (let o of e) {
            let u = o.rank;
            if (u == null) {
              let l = o.shape, c = l[0], p = l.slice(1).concat([c]), d = G(o, [c].concat(dr(l.slice(1))));
              d = qe(d, [1, 0]), d = G(d, p), n.push(d), r = true;
            } else if (u > 1) {
              let l = ys(1, u).concat([0]);
              n.push(qe(o, l)), r = true;
            } else
              n.push(o);
          }
          let a = this.mergeFunction(n), i = a.rank;
          if (r) {
            if (i == null) {
              let o = a.shape, u = o.length, l = o[u - 1], c = [l].concat(o.slice(0, o.length - 1));
              a = G(qe(G(a, [-1, l]), [1, 0]), c);
            } else if (i > 1) {
              let o = [i - 1].concat(ys(0, i - 1));
              a = qe(a, o);
            }
          }
          return a;
        }
      } else
        return this.mergeFunction(e);
    });
  }
  computeOutputShape(e) {
    e = e;
    let t;
    e[0] == null ? t = null : t = e[0].slice(1);
    for (let s = 1; s < e.length; ++s) {
      let r = e[s] == null ? null : e[s].slice(1);
      t = this.computeElementwiseOpOutputShape(t, r);
    }
    let n = [];
    for (let s of e)
      s != null && s[0] !== null && n.push(s[0]);
    return n = cr(n), n.length === 1 ? t = n.concat(t) : t = [null].concat(t), t;
  }
  computeMask(e, t) {
    return j(() => {
      if (t == null)
        return null;
      if (!Array.isArray(t))
        throw new U("`mask` should be an Array");
      if (!Array.isArray(e))
        throw new U("`inputs` should be an Array");
      if (t.length !== e.length)
        throw new U(`The Array 'inputs' and 'mask' are expected to have the same length, but have different lengths (${e.length} vs ${t.length})`);
      if (t.every((s) => s == null))
        return null;
      t = t.map((s) => s == null ? s : Pn(s, 0));
      let n = t[0];
      for (let s = 1; s < t.length - 1; ++s)
        n = Ds(n, t[s]);
      return n;
    });
  }
};
var xy = class extends bi {
  constructor(e) {
    super(e);
  }
  mergeFunction(e) {
    return j(() => {
      let t = e[0].clone();
      for (let n = 1; n < e.length; ++n)
        t = ie(t, e[n]);
      return t;
    });
  }
};
xy.className = "Add";
ae.registerClass(xy);
var wy = class extends bi {
  constructor(e) {
    super(e);
  }
  mergeFunction(e) {
    return j(() => {
      let t = e[0].clone();
      for (let n = 1; n < e.length; ++n)
        t = V(t, e[n]);
      return t;
    });
  }
};
wy.className = "Multiply";
ae.registerClass(wy);
var ky = class extends bi {
  constructor(e) {
    super(e);
  }
  mergeFunction(e) {
    return j(() => {
      let t = e[0].clone();
      for (let n = 1; n < e.length; ++n)
        t = ie(t, e[n]);
      return V(1 / e.length, t);
    });
  }
};
ky.className = "Average";
ae.registerClass(ky);
var Iy = class extends bi {
  constructor(e) {
    super(e);
  }
  mergeFunction(e) {
    return j(() => {
      let t = e[0];
      for (let n = 1; n < e.length; ++n)
        t = $r(t, e[n]);
      return t;
    });
  }
};
Iy.className = "Maximum";
ae.registerClass(Iy);
var Sy = class extends bi {
  constructor(e) {
    super(e);
  }
  mergeFunction(e) {
    return j(() => {
      let t = e[0];
      for (let n = 1; n < e.length; ++n)
        t = bp(t, e[n]);
      return t;
    });
  }
};
Sy.className = "Minimum";
ae.registerClass(Sy);
var Cy = class extends bi {
  constructor(e) {
    super(e), this.DEFAULT_AXIS = -1, e == null && (e = {}), this.axis = e.axis == null ? this.DEFAULT_AXIS : e.axis, this.supportsMasking = true, this.reshapeRequired = false;
  }
  build(e) {
    if (!(Array.isArray(e) && Array.isArray(e[0])) || e.length === 1)
      throw new U("A `Concatenate` layer should be called on a list of at least 2 inputs");
    e = e;
    let t = true;
    for (let s of e)
      if (s != null) {
        t = false;
        break;
      }
    if (t)
      return;
    let n = [];
    for (let s = 0; s < e.length; ++s) {
      let r = e[s].slice();
      r.splice(this.axis, 1);
      let a = false;
      for (let i of n)
        if (w.arraysEqual(i, r)) {
          a = true;
          break;
        }
      a || n.push(r);
    }
    if (n.length > 1)
      throw new U("A `Concatenate` layer requires inputs with matching shapes except for the concat axis. Got input shapes: " + JSON.stringify(e));
  }
  mergeFunction(e) {
    return j(() => $b(e, this.axis));
  }
  computeOutputShape(e) {
    if (!(Array.isArray(e) && Array.isArray(e[0])))
      throw new U("A `Concatenate` layer should be called on a list of inputs.");
    let t = e, n = t[0].slice(), s = this.axis < 0 ? n.length + this.axis : this.axis;
    for (let r of t.slice(1)) {
      if (n[s] == null || r[s] == null) {
        n[s] = null;
        break;
      }
      n[s] += r[s];
    }
    return n;
  }
  computeMask(e, t) {
    if (t == null)
      return null;
    if (!Array.isArray(t))
      throw new U("`mask` should be an array for Concatenate");
    if (!Array.isArray(e))
      throw new U("`inputs` should be an array for Concatenate");
    if (t.length !== e.length)
      throw new U(`Mismatch in the length of mask (${t.length}) and the legnth of inputs (${e.length})`);
    return j(() => {
      let n = true;
      if (t.forEach((a) => {
        if (a != null) {
          n = false;
          return;
        }
      }), n)
        return null;
      let s = [];
      for (let a = 0; a < e.length; ++a)
        t[a] == null ? s.push(ce(Qn(e[a]), "bool")) : t[a].rank < e[a].rank ? s.push(Pn(t[a], -1)) : s.push(t[a]);
      let r = Ft(s, this.axis);
      return qk(r, -1, false);
    });
  }
  getConfig() {
    let e = { axis: this.axis }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
Cy.className = "Concatenate";
ae.registerClass(Cy);
function Cu(e, t) {
  for (; e < 0; )
    e += t;
  return e;
}
function VB(e, t, n) {
  if (e.shape.length > 3 || t.shape.length > 3)
    throw new Fe("batchDot is not implemented for tensors of 4D or higher rank yet");
  if (w.assert(e.shape.length >= 2, () => `batchDot requires the rank of x to be >= 2, but got ${e.shape.length}`), w.assert(e.shape.length >= 2, () => `batchDot requires the rank of y to be >= 2, but got ${t.shape.length}`), typeof n == "number" && (n = [n, n]), e.dtype === "complex64" || t.dtype === "complex64")
    throw new Fe("batchDot is not implemented for complex64-type Tensors yet.");
  let s = e.shape.length, r = t.shape.length;
  n == null && (n = [s - 1, r - 2]);
  let a = n;
  return j(() => {
    let i;
    if (s > r) {
      i = s - r;
      let u = [];
      for (let l = 0; l < i; ++l)
        u.push(1);
      t = G(t, t.shape.concat(u));
    } else if (r > s) {
      i = r - s;
      let u = [];
      for (let l = 0; l < i; ++l)
        u.push(1);
      e = G(e, e.shape.concat(u));
    } else
      i = 0;
    let o;
    if (e.shape.length === 2 && t.shape.length === 2)
      a[0] === a[1] ? o = ve(V(e, t), a[0]) : o = ve(V(qe(e, [1, 0]), t), a[1]);
    else {
      let u = a[0] !== e.shape.length - 1, l = a[1] === t.shape.length - 1;
      o = We(e, t, u, l);
    }
    if (i > 0) {
      let u;
      s > r ? u = s + r - 3 : u = s - 1;
      let l = [];
      for (let c = u; c < u + i; ++c)
        l.push(c);
      o = mr(o, l);
    }
    return o.shape.length === 1 && (o = Pn(o, 1)), o;
  });
}
var Ny = class extends bi {
  constructor(e) {
    super(e), this.axes = e.axes, this.normalize = e.normalize == null ? false : e.normalize, this.supportsMasking = true, this.reshapeRequired = false;
  }
  build(e) {
    w.assert(Array.isArray(e) && e.length === 2 && Array.isArray(e[0]) && Array.isArray(e[1]), () => "A `Dot` layer should be called on a list of exactly 2 inputs.");
    let t = e[0], n = e[1];
    if (t.length > 3 || n.length > 3)
      throw new Fe("Dot layer does not support tensors of 4D or higher rank yet.");
    let s = this.interpretAxes(t, n);
    if (t[s[0]] !== n[s[1]])
      throw new U(`Dimension incompatibility: ${t[s[0]]} !== ${n[s[1]]}`);
  }
  mergeFunction(e) {
    if (e.length !== 2)
      throw new U(`A \`Dot\` layer must be called on exactly 2 inputs, but received ${e.length} input(s).`);
    let t = e[0], n = e[1], s;
    return Array.isArray(this.axes) ? s = this.axes.map((r, a) => Cu(r, e[a].shape.length)) : s = [Cu(this.axes, t.shape.length), Cu(this.axes, n.shape.length)], this.normalize && (t = Nd(t, s[0]), n = Nd(n, s[1])), VB(t, n, s);
  }
  interpretAxes(e, t) {
    let n;
    return Array.isArray(this.axes) ? n = this.axes : n = [Cu(this.axes, e.length), Cu(this.axes, t.length)], n;
  }
  computeOutputShape(e) {
    w.assert(Array.isArray(e) && e.length === 2 && Array.isArray(e[0]) && Array.isArray(e[1]), () => "A `Dot` layer should be called on a list of exactly 2 inputs.");
    let t = e[0].slice(), n = e[1].slice();
    if (t.length > 3 || n.length > 3)
      throw new Fe("Dot layer does not support tensors of 4D or higher rank yet.");
    let s = this.interpretAxes(t, n);
    t.splice(s[0], 1), n.splice(s[1], 1), n.splice(0, 1);
    let r = t.concat(n);
    return r.length === 1 && r.push(1), r;
  }
  computeMask(e, t) {
    return null;
  }
  getConfig() {
    let e = { axes: this.axes, normalize: this.normalize }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
Ny.className = "Dot";
ae.registerClass(Ny);
var Ty = class extends Ge {
  constructor(e) {
    super(e), this.supportsMasking = true, this.stddev = e.stddev;
  }
  computeOutputShape(e) {
    return e;
  }
  getConfig() {
    let e = super.getConfig(), t = { stddev: this.stddev };
    return Object.assign(t, e), t;
  }
  call(e, t) {
    return j(() => {
      this.invokeCallHook(e, t);
      let n = Oe(e);
      return Ul(() => ie(Cp(n.shape, 0, this.stddev), n), () => n, t.training || false);
    });
  }
};
Ty.className = "GaussianNoise";
ae.registerClass(Ty);
var $y = class extends Ge {
  constructor(e) {
    super(e), this.supportsMasking = true, this.rate = e.rate;
  }
  computeOutputShape(e) {
    return e;
  }
  getConfig() {
    let e = super.getConfig(), t = { rate: this.rate };
    return Object.assign(t, e), t;
  }
  call(e, t) {
    return j(() => {
      this.invokeCallHook(e, t);
      let n = Oe(e);
      return this.rate > 0 && this.rate < 1 ? Ul(() => {
        let r = Math.sqrt(this.rate / (1 - this.rate));
        return V(n, Cp(n.shape, 1, r));
      }, () => n, t.training || false) : n;
    });
  }
};
$y.className = "GaussianDropout";
ae.registerClass($y);
var _y = class extends Ge {
  constructor(e) {
    super(e), this.supportsMasking = true, this.rate = e.rate, this.noiseShape = e.noiseShape;
  }
  _getNoiseShape(e) {
    return this.noiseShape || Oe(e).shape;
  }
  computeOutputShape(e) {
    return e;
  }
  getConfig() {
    let e = super.getConfig(), t = { rate: this.rate };
    return Object.assign(t, e), t;
  }
  call(e, t) {
    return j(() => {
      if (this.rate < 1 && this.rate > 0) {
        let n = this._getNoiseShape(e);
        return Ul(() => {
          let r = Oe(e), a = 1.6732632423543772, i = 1.0507009873554805, o = -a * i, u = Ko(Ml(n), this.rate);
          u = Sp(u, "float32");
          let l = ((1 - this.rate) * (1 + this.rate * o ** 2)) ** -0.5, c = -l * o * this.rate, p = ie(V(r, u), V(ie(u, -1), o));
          return ie(V(p, l), c);
        }, () => Oe(e), t.training || false);
      }
      return e;
    });
  }
};
_y.className = "AlphaDropout";
ae.registerClass(_y);
function Ju(e, t, n, s, r, a = 1e-3) {
  let i;
  if (e.rank === 2)
    i = $E(e, t, n, s, r, a);
  else if (e.rank === 3)
    i = AE(e, t, n, s, r, a);
  else if (e.rank === 4)
    i = RE(e, t, n, s, r, a);
  else
    throw new Fe(`batchNormalization is not implemented for array of rank ${e.rank} yet`);
  return i;
}
function WB(e, t, n, s, r = 1e-3) {
  return j(() => {
    let a = tb(e, s), i = a.mean, o = a.variance;
    return [Ju(e, i, o, n, t, r), i, o];
  });
}
function UB(e, t, n, s, r = 1e-3) {
  return j(() => {
    let a = tb(e, s), i = a.mean, o = a.variance, u = [];
    for (let f of ys(0, e.rank))
      s.indexOf(f) !== -1 ? u.push(1) : u.push(e.shape[f]);
    let l = G(i, u), c = G(o, u), p = t == null ? null : G(t, u), d = n == null ? null : G(n, u);
    return [Ju(e, l, c, d, p, r), i, o];
  });
}
function GB(e, t, n, s, r = 1e-3) {
  return w.arraysEqual(s.slice().sort(), ys(0, e.rank - 1)) ? WB(e, t, n, s, r) : UB(e, t, n, s, r);
}
var Ay = class extends Ge {
  constructor(e) {
    e == null && (e = {}), super(e), this.supportsMasking = true, this.axis = e.axis == null ? -1 : e.axis, this.momentum = e.momentum == null ? 0.99 : e.momentum, this.epsilon = e.epsilon == null ? 1e-3 : e.epsilon, this.center = e.center == null ? true : e.center, this.scale = e.scale == null ? true : e.scale, this.betaInitializer = ht(e.betaInitializer || "zeros"), this.gammaInitializer = ht(e.gammaInitializer || "ones"), this.movingMeanInitializer = ht(e.movingMeanInitializer || "zeros"), this.movingVarianceInitializer = ht(e.movingVarianceInitializer || "ones"), this.betaConstraint = Pt(e.betaConstraint), this.gammaConstraint = Pt(e.gammaConstraint), this.betaRegularizer = ft(e.betaRegularizer), this.gammaRegularizer = ft(e.gammaRegularizer);
  }
  build(e) {
    e = nt(e);
    let t = this.axis >= 0 ? this.axis : this.axis + e.length, n = e[t];
    if (n == null)
      throw new U(`Axis ${t} of input tensor should have a defined dimension but the layer received an input with shape ${JSON.stringify(e)}.`);
    this.inputSpec = [new Dt({ ndim: e.length, axes: { [t]: n } })];
    let s = [n];
    this.scale && (this.gamma = this.addWeight("gamma", s, null, this.gammaInitializer, this.gammaRegularizer, true, this.gammaConstraint)), this.center && (this.beta = this.addWeight("beta", s, null, this.betaInitializer, this.betaRegularizer, true, this.betaConstraint)), this.movingMean = this.addWeight("moving_mean", s, null, this.movingMeanInitializer, null, false), this.movingVariance = this.addWeight("moving_variance", s, null, this.movingVarianceInitializer, null, false), this.built = true;
  }
  call(e, t) {
    return j(() => {
      let n = t.training == null ? false : t.training, s = Oe(e), r = s.shape, a = r.length, i = ys(0, a), o = this.axis >= 0 ? this.axis : this.axis + a;
      i.splice(o, 1);
      let u = fa(1, a);
      u[o] = r[o];
      let l = i.slice();
      l.sort();
      let c = !w.arraysEqual(l, ys(0, a).slice(0, a - 1)), p = () => {
        if (c) {
          let b = G(this.movingMean.read(), u), y = G(this.movingVariance.read(), u), v = this.center ? G(this.beta.read(), u) : null, x = this.scale ? G(this.gamma.read(), u) : null;
          return Ju(s, b, y, v, x, this.epsilon);
        } else
          return Ju(s, this.movingMean.read(), this.movingVariance.read(), this.beta == null ? null : this.beta.read(), this.gamma == null ? null : this.gamma.read(), this.epsilon);
      };
      if (!n)
        return p();
      let [d, h, f] = GB(s, this.gamma.read(), this.beta.read(), i, this.epsilon), m = (b, y, v) => {
        j(() => {
          let x = 1 - v, k = b.read(), T = V(ge(k, y), x);
          b.write(ge(k, T));
        });
      };
      return (() => {
        m(this.movingMean, h, this.momentum), m(this.movingVariance, f, this.momentum);
      })(), d;
    });
  }
  getConfig() {
    let e = { axis: this.axis, momentum: this.momentum, epsilon: this.epsilon, center: this.center, scale: this.scale, betaInitializer: yt(this.betaInitializer), gammaInitializer: yt(this.gammaInitializer), movingMeanInitializer: yt(this.movingMeanInitializer), movingVarianceInitializer: yt(this.movingVarianceInitializer), betaRegularizer: it(this.betaRegularizer), gammaRegularizer: it(this.gammaRegularizer), betaConstraint: Ot(this.betaConstraint), gammaConstraint: Ot(this.gammaConstraint) }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
Ay.className = "BatchNormalization";
ae.registerClass(Ay);
var Ey = class extends Ge {
  constructor(e) {
    if (e == null && (e = {}), super(e), this.axis = e.axis == null ? -1 : e.axis, typeof this.axis == "number") {
      if (!Number.isInteger(this.axis))
        throw new Error(`Expected axis to be an integer, but received ${this.axis}`);
    } else if (Array.isArray(this.axis)) {
      for (let t of this.axis)
        if (!Number.isInteger(t))
          throw new Error(`Expected axis to be an array of integers, but received ${JSON.stringify(this.axis)}`);
    } else
      throw new Error(`Expected axis to be an integer or an array of integers, but received ${JSON.stringify(this.axis)}`);
    this.epsilon = e.epsilon == null ? 1e-3 : e.epsilon, this.center = e.center == null ? true : e.center, this.scale = e.scale == null ? true : e.scale, this.betaInitializer = ht(e.betaInitializer || "zeros"), this.gammaInitializer = ht(e.gammaInitializer || "ones"), this.betaRegularizer = ft(e.betaRegularizer), this.gammaRegularizer = ft(e.gammaRegularizer), this.supportsMasking = true;
  }
  build(e) {
    e = nt(e);
    let t = e.length;
    typeof this.axis == "number" && (this.axis = [this.axis]);
    for (let r = 0; r < this.axis.length; ++r)
      this.axis[r] < 0 && (this.axis[r] += t);
    for (let r of this.axis)
      if (r < 0 || r >= t)
        throw new Error(`Invalid axis: ${r}`);
    if (this.axis.length !== cr(this.axis).length)
      throw new Error(`Found duplicate axes in: ${this.axis}`);
    let n = this.axis.map((r) => e[r]), s = true;
    this.scale ? this.gamma = this.addWeight("gamma", n, "float32", this.gammaInitializer, this.gammaRegularizer, s) : this.gamma = null, this.center ? this.beta = this.addWeight("beta", n, "float32", this.betaInitializer, this.betaRegularizer, s) : this.beta = null, this.built = true;
  }
  call(e, t) {
    let n = Oe(e), s = n.shape, r = s.length;
    return j(() => {
      let { mean: i, variance: o } = tb(n, this.axis, true), u = fa(1, r);
      for (let f of this.axis)
        u[f] = s[f];
      let l = (f) => f != null && f.shape.length !== r ? G(f, u) : f, c = l(this.gamma.read()), p = l(this.beta.read()), d = [], h = [];
      for (let f = 0; f < r; ++f)
        this.axis.indexOf(f) !== -1 ? (d.push(s[f]), h.push(1)) : (d.push(1), h.push(s[f]));
      return i = ps(i, d), o = ps(o, d), c = ps(c, h), p = ps(p, h), Ju(n, i, o, p, c, this.epsilon);
    });
  }
  getConfig() {
    let e = { axis: this.axis, epsilon: this.epsilon, center: this.center, scale: this.scale, betaInitializer: yt(this.betaInitializer), gammaInitializer: yt(this.gammaInitializer), betaRegularizer: it(this.betaRegularizer), gammaRegularizer: it(this.gammaRegularizer) }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
Ey.className = "LayerNormalization";
ae.registerClass(Ey);
function HB(e, t, n) {
  return j(() => {
    if (e.rank !== 4)
      throw new U(`temporalPadding expects input tensor to be 4-D, but received a ${e.rank}-D tensor.`);
    if (t == null && (t = [[1, 1], [1, 1]]), t.length !== 2 || t[0].length !== 2 || t[1].length !== 2)
      throw new U("spatial2dPadding expects `padding` to be an Array of two Arrays, each of which is an Array of two integers.");
    if (n == null && (n = bs()), n !== "channelsLast" && n !== "channelsFirst")
      throw new U(`Unknown data format: ${n}. Supported data formats are 'channelsLast' and 'channelsFirst.`);
    let s;
    return n === "channelsFirst" ? s = [[0, 0], [0, 0], t[0], t[1]] : s = [[0, 0], t[0], t[1], [0, 0]], fi(e, s);
  });
}
var Ry = class extends Ge {
  constructor(e) {
    if (e == null && (e = {}), super(e), this.dataFormat = e.dataFormat == null ? bs() : e.dataFormat, e.padding == null)
      this.padding = [[1, 1], [1, 1]];
    else if (typeof e.padding == "number")
      this.padding = [[e.padding, e.padding], [e.padding, e.padding]];
    else {
      if (e.padding = e.padding, e.padding.length !== 2)
        throw new U(`ZeroPadding2D expects padding to be a length-2 array, but received a length-${e.padding.length} array.`);
      let t, n;
      if (typeof e.padding[0] == "number")
        t = [e.padding[0], e.padding[0]], n = [e.padding[1], e.padding[1]];
      else {
        if (e.padding = e.padding, e.padding[0].length !== 2)
          throw new U(`ZeroPadding2D expects height padding to be a length-2 array, but received a length-${e.padding[0].length} array.`);
        if (t = e.padding[0], e.padding[1].length !== 2)
          throw new U(`ZeroPadding2D expects width padding to be a length-2 array, but received a length-${e.padding[1].length} array.`);
        n = e.padding[1];
      }
      this.padding = [t, n];
    }
    this.inputSpec = [new Dt({ ndim: 4 })];
  }
  computeOutputShape(e) {
    e = nt(e);
    let t, n;
    return this.dataFormat === "channelsFirst" ? (e[2] != null && e[2] >= 0 ? t = e[2] + this.padding[0][0] + this.padding[0][1] : t = null, e[3] != null && e[3] >= 0 ? n = e[3] + this.padding[1][0] + this.padding[1][1] : n = null, [e[0], e[1], t, n]) : (e[1] != null && e[1] >= 0 ? t = e[1] + this.padding[0][0] + this.padding[0][1] : t = null, e[2] != null && e[2] >= 0 ? n = e[2] + this.padding[1][0] + this.padding[1][1] : n = null, [e[0], t, n, e[3]]);
  }
  call(e, t) {
    return j(() => HB(Oe(e), this.padding, this.dataFormat));
  }
  getConfig() {
    let e = { padding: this.padding, dataFormat: this.dataFormat }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
Ry.className = "ZeroPadding2D";
ae.registerClass(Ry);
function Gp(e, t, n, s, r, a) {
  return j(() => {
    Ct(r), GI(a), Un(s), n == null && (n = [1, 1]), s == null && (s = "valid"), r == null && (r = bs()), a == null && (a = "max"), e = Zb(e, r);
    let i, o = s === "same" ? "same" : "valid";
    return a === "max" ? i = eb(e, t, n, o) : i = Gg(e, t, n, o), r === "channelsFirst" && (i = qe(i, [0, 3, 1, 2])), i;
  });
}
function zS(e, t, n, s, r, a) {
  return j(() => {
    Ct(r), GI(a), Un(s), n == null && (n = [1, 1, 1]), s == null && (s = "valid"), r == null && (r = bs()), a == null && (a = "max"), e = $S(e, r);
    let i, o = s === "same" ? "same" : "valid";
    return a === "max" ? i = dI(e, t, n, o) : i = Yk(e, t, n, o), r === "channelsFirst" && (i = qe(i, [0, 4, 1, 2, 3])), i;
  });
}
var MS = class extends Ge {
  constructor(e) {
    if (e.poolSize == null && (e.poolSize = 2), super(e), typeof e.poolSize == "number")
      this.poolSize = [e.poolSize];
    else if (Array.isArray(e.poolSize) && e.poolSize.length === 1 && typeof e.poolSize[0] == "number")
      this.poolSize = e.poolSize;
    else
      throw new U(`poolSize for 1D convolutional layer must be a number or an Array of a single number, but received ${JSON.stringify(e.poolSize)}`);
    if (Bt(this.poolSize, "poolSize"), e.strides == null)
      this.strides = this.poolSize;
    else if (typeof e.strides == "number")
      this.strides = [e.strides];
    else if (Array.isArray(e.strides) && e.strides.length === 1 && typeof e.strides[0] == "number")
      this.strides = e.strides;
    else
      throw new U(`strides for 1D convolutional layer must be a number or an Array of a single number, but received ${JSON.stringify(e.strides)}`);
    Bt(this.strides, "strides"), this.padding = e.padding == null ? "valid" : e.padding, Un(this.padding), this.inputSpec = [new Dt({ ndim: 3 })];
  }
  computeOutputShape(e) {
    e = nt(e);
    let t = gs(e[1], this.poolSize[0], this.padding, this.strides[0]);
    return [e[0], t, e[2]];
  }
  call(e, t) {
    return j(() => {
      this.invokeCallHook(e, t), e = Vl(Oe(e), 2);
      let n = this.poolingFunction(Oe(e), [this.poolSize[0], 1], [this.strides[0], 1], this.padding, "channelsLast");
      return mr(n, [2]);
    });
  }
  getConfig() {
    let e = { poolSize: this.poolSize, padding: this.padding, strides: this.strides }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
var Dy = class extends MS {
  constructor(e) {
    super(e);
  }
  poolingFunction(e, t, n, s, r) {
    return Ct(r), Un(s), Gp(e, t, n, s, r, "max");
  }
};
Dy.className = "MaxPooling1D";
ae.registerClass(Dy);
var Fy = class extends MS {
  constructor(e) {
    super(e);
  }
  poolingFunction(e, t, n, s, r) {
    return Ct(r), Un(s), Gp(e, t, n, s, r, "avg");
  }
};
Fy.className = "AveragePooling1D";
ae.registerClass(Fy);
var LS = class extends Ge {
  constructor(e) {
    if (e.poolSize == null && (e.poolSize = [2, 2]), super(e), this.poolSize = Array.isArray(e.poolSize) ? e.poolSize : [e.poolSize, e.poolSize], e.strides == null)
      this.strides = this.poolSize;
    else if (Array.isArray(e.strides)) {
      if (e.strides.length !== 2)
        throw new U(`If the strides property of a 2D pooling layer is an Array, it is expected to have a length of 2, but received length ${e.strides.length}.`);
      this.strides = e.strides;
    } else
      this.strides = [e.strides, e.strides];
    Bt(this.poolSize, "poolSize"), Bt(this.strides, "strides"), this.padding = e.padding == null ? "valid" : e.padding, this.dataFormat = e.dataFormat == null ? "channelsLast" : e.dataFormat, Ct(this.dataFormat), Un(this.padding), this.inputSpec = [new Dt({ ndim: 4 })];
  }
  computeOutputShape(e) {
    e = nt(e);
    let t = this.dataFormat === "channelsFirst" ? e[2] : e[1], n = this.dataFormat === "channelsFirst" ? e[3] : e[2];
    return t = gs(t, this.poolSize[0], this.padding, this.strides[0]), n = gs(n, this.poolSize[1], this.padding, this.strides[1]), this.dataFormat === "channelsFirst" ? [e[0], e[1], t, n] : [e[0], t, n, e[3]];
  }
  call(e, t) {
    return j(() => (this.invokeCallHook(e, t), this.poolingFunction(Oe(e), this.poolSize, this.strides, this.padding, this.dataFormat)));
  }
  getConfig() {
    let e = { poolSize: this.poolSize, padding: this.padding, strides: this.strides, dataFormat: this.dataFormat }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
var Oy = class extends LS {
  constructor(e) {
    super(e);
  }
  poolingFunction(e, t, n, s, r) {
    return Ct(r), Un(s), Gp(e, t, n, s, r, "max");
  }
};
Oy.className = "MaxPooling2D";
ae.registerClass(Oy);
var Py = class extends LS {
  constructor(e) {
    super(e);
  }
  poolingFunction(e, t, n, s, r) {
    return Ct(r), Un(s), Gp(e, t, n, s, r, "avg");
  }
};
Py.className = "AveragePooling2D";
ae.registerClass(Py);
var BS = class extends Ge {
  constructor(e) {
    if (e.poolSize == null && (e.poolSize = [2, 2, 2]), super(e), this.poolSize = Array.isArray(e.poolSize) ? e.poolSize : [e.poolSize, e.poolSize, e.poolSize], e.strides == null)
      this.strides = this.poolSize;
    else if (Array.isArray(e.strides)) {
      if (e.strides.length !== 3)
        throw new U(`If the strides property of a 3D pooling layer is an Array, it is expected to have a length of 3, but received length ${e.strides.length}.`);
      this.strides = e.strides;
    } else
      this.strides = [e.strides, e.strides, e.strides];
    Bt(this.poolSize, "poolSize"), Bt(this.strides, "strides"), this.padding = e.padding == null ? "valid" : e.padding, this.dataFormat = e.dataFormat == null ? "channelsLast" : e.dataFormat, Ct(this.dataFormat), Un(this.padding), this.inputSpec = [new Dt({ ndim: 5 })];
  }
  computeOutputShape(e) {
    e = nt(e);
    let t = this.dataFormat === "channelsFirst" ? e[2] : e[1], n = this.dataFormat === "channelsFirst" ? e[3] : e[2], s = this.dataFormat === "channelsFirst" ? e[4] : e[3];
    return t = gs(t, this.poolSize[0], this.padding, this.strides[0]), n = gs(n, this.poolSize[1], this.padding, this.strides[1]), s = gs(s, this.poolSize[2], this.padding, this.strides[2]), this.dataFormat === "channelsFirst" ? [e[0], e[1], t, n, s] : [e[0], t, n, s, e[4]];
  }
  call(e, t) {
    return j(() => (this.invokeCallHook(e, t), this.poolingFunction(Oe(e), this.poolSize, this.strides, this.padding, this.dataFormat)));
  }
  getConfig() {
    let e = { poolSize: this.poolSize, padding: this.padding, strides: this.strides, dataFormat: this.dataFormat }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
var zy = class extends BS {
  constructor(e) {
    super(e);
  }
  poolingFunction(e, t, n, s, r) {
    return Ct(r), Un(s), zS(e, t, n, s, r, "max");
  }
};
zy.className = "MaxPooling3D";
ae.registerClass(zy);
var My = class extends BS {
  constructor(e) {
    super(e);
  }
  poolingFunction(e, t, n, s, r) {
    return Ct(r), Un(s), zS(e, t, n, s, r, "avg");
  }
};
My.className = "AveragePooling3D";
ae.registerClass(My);
var VS = class extends Ge {
  constructor(e) {
    super(e), this.inputSpec = [new Dt({ ndim: 3 })];
  }
  computeOutputShape(e) {
    return [e[0], e[2]];
  }
  call(e, t) {
    throw new Fe();
  }
};
var Ly = class extends VS {
  constructor(e) {
    super(e || {});
  }
  call(e, t) {
    return j(() => {
      let n = Oe(e);
      return St(n, 1);
    });
  }
};
Ly.className = "GlobalAveragePooling1D";
ae.registerClass(Ly);
var By = class extends VS {
  constructor(e) {
    super(e || {});
  }
  call(e, t) {
    return j(() => {
      let n = Oe(e);
      return As(n, 1);
    });
  }
};
By.className = "GlobalMaxPooling1D";
ae.registerClass(By);
var WS = class extends Ge {
  constructor(e) {
    super(e), this.dataFormat = e.dataFormat == null ? "channelsLast" : e.dataFormat, Ct(this.dataFormat), this.inputSpec = [new Dt({ ndim: 4 })];
  }
  computeOutputShape(e) {
    return e = e, this.dataFormat === "channelsLast" ? [e[0], e[3]] : [e[0], e[1]];
  }
  call(e, t) {
    throw new Fe();
  }
  getConfig() {
    let e = { dataFormat: this.dataFormat }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
};
var Vy = class extends WS {
  call(e, t) {
    return j(() => {
      let n = Oe(e);
      return this.dataFormat === "channelsLast" ? St(n, [1, 2]) : St(n, [2, 3]);
    });
  }
};
Vy.className = "GlobalAveragePooling2D";
ae.registerClass(Vy);
var Wy = class extends WS {
  call(e, t) {
    return j(() => {
      let n = Oe(e);
      return this.dataFormat === "channelsLast" ? As(n, [1, 2]) : As(n, [2, 3]);
    });
  }
};
Wy.className = "GlobalMaxPooling2D";
ae.registerClass(Wy);
var US = class extends Ge {
  constructor(e) {
    super(e), this.layer = e.layer;
  }
  build(e) {
    this.built = true;
  }
  get trainable() {
    return this.layer != null ? this.layer.trainable : false;
  }
  set trainable(e) {
    this.layer != null && (this.layer.trainable = e);
  }
  get trainableWeights() {
    return this.layer.trainableWeights;
  }
  get nonTrainableWeights() {
    return this.layer.nonTrainableWeights;
  }
  get updates() {
    return this.layer._updates;
  }
  get losses() {
    return this.layer.losses;
  }
  getWeights() {
    return this.layer.getWeights();
  }
  setWeights(e) {
    this.layer.setWeights(e);
  }
  getConfig() {
    let e = { layer: { className: this.layer.getClassName(), config: this.layer.getConfig() } }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
  setFastWeightInitDuringBuild(e) {
    super.setFastWeightInitDuringBuild(e), this.layer != null && this.layer.setFastWeightInitDuringBuild(e);
  }
  static fromConfig(e, t, n = {}) {
    let s = t.layer, r = ms(s, n);
    delete t.layer;
    let a = { layer: r };
    return Object.assign(a, t), new e(a);
  }
};
var Uy = class extends US {
  constructor(e) {
    super(e), this.supportsMasking = true;
  }
  build(e) {
    if (e = nt(e), e.length < 3)
      throw new U(`TimeDistributed layer expects an input shape >= 3D, but received input shape ${JSON.stringify(e)}`);
    this.inputSpec = [{ shape: e }];
    let t = [e[0]].concat(e.slice(2));
    this.layer.built || (this.layer.build(t), this.layer.built = true), super.build(e);
  }
  computeOutputShape(e) {
    e = nt(e);
    let t = [e[0]].concat(e.slice(2)), n = this.layer.computeOutputShape(t), s = e[1];
    return [n[0], s].concat(n.slice(1));
  }
  call(e, t) {
    return j(() => (e = Oe(e), FS((a, i) => [Oe(this.layer.call(a, t)), []], e, [], false, null, null, false, true)[1]));
  }
};
Uy.className = "TimeDistributed";
ae.registerClass(Uy);
function qB(e) {
  mi(QM, "BidirectionalMergeMode", e);
}
var jB = "concat";
var Gy = class extends US {
  constructor(e) {
    super(e);
    let t = e.layer.getConfig(), n = {};
    n.className = e.layer.getClassName(), n.config = t, this.forwardLayer = ms(n), t.goBackwards = t.goBackwards !== true;
    let s = {};
    if (s.className = e.layer.getClassName(), s.config = t, this.backwardLayer = ms(s), this.forwardLayer.name = "forward_" + this.forwardLayer.name, this.backwardLayer.name = "backward_" + this.backwardLayer.name, this.mergeMode = e.mergeMode === void 0 ? jB : e.mergeMode, qB(this.mergeMode), e.weights)
      throw new Fe("weights support is not implemented for Bidirectional layer yet.");
    this._stateful = e.layer.stateful, this.returnSequences = e.layer.returnSequences, this.returnState = e.layer.returnState, this.supportsMasking = true, this._trainable = true, this.inputSpec = e.layer.inputSpec, this.numConstants = null;
  }
  get trainable() {
    return this._trainable;
  }
  set trainable(e) {
    this._trainable = e, this.forwardLayer != null && (this.forwardLayer.trainable = e), this.backwardLayer != null && (this.backwardLayer.trainable = e);
  }
  getWeights() {
    return this.forwardLayer.getWeights().concat(this.backwardLayer.getWeights());
  }
  setWeights(e) {
    let t = e.length, n = Math.floor(t / 2);
    this.forwardLayer.setWeights(e.slice(0, n)), this.backwardLayer.setWeights(e.slice(n));
  }
  computeOutputShape(e) {
    let t = this.forwardLayer.computeOutputShape(e);
    Array.isArray(t) && Array.isArray(t[0]) || (t = [t]), t = t;
    let n, s, r;
    return this.returnState && (r = t.slice(1)), n = t[0], n = n, this.mergeMode === "concat" ? (n[n.length - 1] *= 2, s = [n]) : this.mergeMode == null ? s = [n, n.slice()] : s = [n], this.returnState ? this.mergeMode == null ? s.concat(r).concat(r.slice()) : [n].concat(r).concat(r.slice()) : bn(s);
  }
  apply(e, t) {
    let n = t == null ? null : t.initialState, s = t == null ? null : t.constants;
    t == null && (t = {});
    let r = DS(e, n, s, this.numConstants);
    if (e = r.inputs, n = r.initialState, s = r.constants, Array.isArray(e) && (n = e.slice(1), e = e[0]), (n == null || n.length === 0) && s == null)
      return super.apply(e, t);
    let a = [], i = [];
    if (n != null) {
      let u = n.length;
      if (u % 2 > 0)
        throw new U("When passing `initialState` to a Bidrectional RNN, the state should be an Array containing the states of the underlying RNNs.");
      t.initialState = n, a.push(...n);
      let l = n.map((c) => new Dt({ shape: c.shape }));
      this.forwardLayer.stateSpec = l.slice(0, u / 2), this.backwardLayer.stateSpec = l.slice(u / 2), i.push(...l);
    }
    if (s != null)
      throw new Fe("Support for constants in Bidirectional layers is not implemented yet.");
    let o = a[0] instanceof $s;
    for (let u of a)
      if (u instanceof $s !== o)
        throw new U("The initial state of a Bidirectional layer cannot be specified as a mix of symbolic and non-symbolic tensors");
    if (o) {
      let u = [e].concat(a), l = this.inputSpec.concat(i), c = this.inputSpec;
      this.inputSpec = l;
      let p = super.apply(u, t);
      return this.inputSpec = c, p;
    } else
      return super.apply(e, t);
  }
  call(e, t) {
    return j(() => {
      let n = t.initialState, s, r;
      if (n == null)
        s = this.forwardLayer.call(e, t), r = this.backwardLayer.call(e, t);
      else {
        let o = n.slice(0, n.length / 2), u = n.slice(n.length / 2);
        s = this.forwardLayer.call(e, Object.assign(t, { initialState: o })), r = this.backwardLayer.call(e, Object.assign(t, { initialState: u }));
      }
      let a;
      this.returnState && (Array.isArray(s) && (a = s.slice(1).concat(r.slice(1))), s = s[0], r = r[0]), this.returnSequences && (r = Zn(r, 1));
      let i;
      return this.mergeMode === "concat" ? i = $b([s, r]) : this.mergeMode === "sum" ? i = ie(s, r) : this.mergeMode === "ave" ? i = V(0.5, ie(s, r)) : this.mergeMode === "mul" ? i = V(s, r) : this.mergeMode == null && (i = [s, r]), this.returnState ? this.mergeMode == null ? i.concat(a) : [i].concat(a) : i;
    });
  }
  resetStates(e) {
    this.forwardLayer.resetStates(), this.backwardLayer.resetStates();
  }
  build(e) {
    ea(this.forwardLayer.name, () => {
      this.forwardLayer.build(e);
    }), ea(this.backwardLayer.name, () => {
      this.backwardLayer.build(e);
    }), this.built = true;
  }
  computeMask(e, t) {
    Array.isArray(t) && (t = t[0]);
    let n;
    if (this.returnSequences ? this.mergeMode == null ? n = [t, t] : n = t : this.mergeMode == null ? n = [null, null] : n = null, this.returnState) {
      let r = this.forwardLayer.states.map((a) => null);
      return Array.isArray(n) ? n.concat(r).concat(r) : [n].concat(r).concat(r);
    } else
      return n;
  }
  get trainableWeights() {
    return this.forwardLayer.trainableWeights.concat(this.backwardLayer.trainableWeights);
  }
  get nonTrainableWeights() {
    return this.forwardLayer.nonTrainableWeights.concat(this.backwardLayer.nonTrainableWeights);
  }
  setFastWeightInitDuringBuild(e) {
    super.setFastWeightInitDuringBuild(e), this.forwardLayer != null && this.forwardLayer.setFastWeightInitDuringBuild(e), this.backwardLayer != null && this.backwardLayer.setFastWeightInitDuringBuild(e);
  }
  getConfig() {
    let e = { mergeMode: this.mergeMode }, t = super.getConfig();
    return Object.assign(e, t), e;
  }
  static fromConfig(e, t) {
    let n = ms(t.layer);
    if (delete t.layer, t.numConstants != null)
      throw new Fe("Deserialization of a Bidirectional layer with numConstants present is not supported yet.");
    let s = t;
    return s.layer = n, new e(s);
  }
};
Gy.className = "Bidirectional";
ae.registerClass(Gy);
function KB(e) {
  return new Qo(e);
}
function XB(e) {
  return new Xb(e);
}
function YB(e) {
  return new qb(e);
}
function QB(e) {
  return new jb(e);
}
function ZB(e) {
  return new Kb(e);
}
function JB(e) {
  return new Qb(e);
}
function eV(e) {
  return new Yb(e);
}
function tV(e) {
  return new sy(e);
}
function nV(e) {
  return new zp(e);
}
function sV(e) {
  return new ey(e);
}
function rV(e) {
  return new Mp(e);
}
function aV(e) {
  return new ty(e);
}
function iV(e) {
  return new ny(e);
}
function oV(e) {
  return new ry(e);
}
function uV(e) {
  return new ay(e);
}
function lV(e) {
  return new iy(e);
}
function cV(e) {
  return new fy(e);
}
function dV(e) {
  return new py(e);
}
function pV(e) {
  return new Up(e);
}
function hV(e) {
  return new dy(e);
}
function fV(e) {
  return new hy(e);
}
function mV(e) {
  return new my(e);
}
function gV(e) {
  return new gy(e);
}
function bV(e) {
  return new by(e);
}
function yV(e) {
  return new vy(e);
}
function vV(e) {
  return new xy(e);
}
function xV(e) {
  return new ky(e);
}
function wV(e) {
  return new Cy(e);
}
function kV(e) {
  return new Iy(e);
}
function IV(e) {
  return new Sy(e);
}
function SV(e) {
  return new wy(e);
}
function CV(e) {
  return new Ny(e);
}
function NV(e) {
  return new Ay(e);
}
function TV(e) {
  return new Ey(e);
}
function $V(e) {
  return new Ry(e);
}
function Hy(e) {
  return new Fy(e);
}
function _V(e) {
  return Hy(e);
}
function AV(e) {
  return Hy(e);
}
function qy(e) {
  return new Py(e);
}
function EV(e) {
  return qy(e);
}
function RV(e) {
  return qy(e);
}
function jy(e) {
  return new My(e);
}
function DV(e) {
  return jy(e);
}
function FV(e) {
  return jy(e);
}
function OV(e) {
  return new Ly(e);
}
function PV(e) {
  return new Vy(e);
}
function GS(e) {
  return new By(e);
}
function HS(e) {
  return new Wy(e);
}
function qS(e) {
  return new Dy(e);
}
function jS(e) {
  return new Oy(e);
}
function zV(e) {
  return new zy(e);
}
function MV(e) {
  return new uy(e);
}
function LV(e) {
  return new Bp(e);
}
function BV(e) {
  return new ly(e);
}
function VV(e) {
  return new jl(e);
}
function WV(e) {
  return new oy(e);
}
function UV(e) {
  return new Lp(e);
}
function GV(e) {
  return new cy(e);
}
function HV(e) {
  return new Wp(e);
}
function qV(e) {
  return new Ar(e);
}
function jV(e) {
  return new Vp(e);
}
function KV(e) {
  return new Gy(e);
}
function XV(e) {
  return new Uy(e);
}
var YV = GS;
var QV = HS;
var ZV = qS;
var JV = jS;
function eW(e) {
  return new Ty(e);
}
function tW(e) {
  return new $y(e);
}
function nW(e) {
  return new _y(e);
}
function sW(e) {
  return new yy(e);
}
var rW = {};
Ae(rW, { MAPE: () => mW, MSE: () => yW, binaryAccuracy: () => aW, binaryCrossentropy: () => iW, categoricalAccuracy: () => uW, categoricalCrossentropy: () => lW, cosineProximity: () => pW, mape: () => gW, meanAbsoluteError: () => hW, meanAbsolutePercentageError: () => fW, meanSquaredError: () => bW, mse: () => vW, precision: () => cW, recall: () => dW, sparseCategoricalAccuracy: () => oW });
function aW(e, t) {
  return Lb(e, t);
}
function iW(e, t) {
  return rS(e, t);
}
function oW(e, t) {
  return aS(e, t);
}
function uW(e, t) {
  return Bb(e, t);
}
function lW(e, t) {
  return Vb(e, t);
}
function cW(e, t) {
  return sS(e, t);
}
function dW(e, t) {
  return QL(e, t);
}
function pW(e, t) {
  return Mb(e, t);
}
function hW(e, t) {
  return Op(e, t);
}
function fW(e, t) {
  return Zo(e, t);
}
function mW(e, t) {
  return Zo(e, t);
}
function gW(e, t) {
  return Zo(e, t);
}
function bW(e, t) {
  return gi(e, t);
}
function yW(e, t) {
  return gi(e, t);
}
function vW(e, t) {
  return gi(e, t);
}
var xW = {};
Ae(xW, { modelFromJSON: () => EB });
var wW = {};
Ae(wW, { l1: () => IW, l1l2: () => kW, l2: () => SW });
function kW(e) {
  return new Gl(e);
}
function IW(e) {
  return PB(e);
}
function SW(e) {
  return zB(e);
}
var CW = class extends Ji {
  constructor() {
    super(...arguments), this.model = null;
  }
  setModel(e) {
    if (!(e instanceof pr))
      throw new Error("model must be a LayersModel, not some other Container");
    this.model = e;
  }
};
function jc(e, t) {
  return e < t;
}
function Gx(e, t) {
  return e > t;
}
var NW = class extends CW {
  constructor(e) {
    if (super(), e == null && (e = {}), e.restoreBestWeights)
      throw new Fe("restoreBestWeights = True is not implemented in EarlyStopping yet.");
    this.monitor = e.monitor || "val_loss", this.minDelta = Math.abs(e.minDelta || 0), this.patience = e.patience || 0, this.verbose = e.verbose || 0, this.mode = e.mode || "auto", this.baseline = e.baseline, ["auto", "min", "max"].indexOf(this.mode) === -1 && (console.warn(`EarlyStopping mode '${this.mode}' is invalid. Falling back to mode 'auto'.`), this.mode = "auto"), this.mode === "min" ? this.monitorFunc = jc : this.mode === "max" ? this.monitorFunc = Gx : this.monitor.indexOf("acc") !== -1 ? this.monitorFunc = Gx : this.monitorFunc = jc, this.monitorFunc === jc && (this.minDelta *= -1);
  }
  async onTrainBegin(e) {
    this.wait = 0, this.stoppedEpoch = 0, this.baseline != null ? this.best = this.baseline : this.best = this.monitorFunc === jc ? 1 / 0 : -1 / 0;
  }
  async onEpochEnd(e, t) {
    await rr(t);
    let n = this.getMonitorValue(t);
    n != null && (this.monitorFunc(n - this.minDelta, this.best) ? (this.best = n, this.wait = 0) : (this.wait++, this.wait >= this.patience && (this.stoppedEpoch = e, this.model.stopTraining = true)));
  }
  async onTrainEnd(e) {
    this.stoppedEpoch > 0 && this.verbose && console.log(`Epoch ${this.stoppedEpoch}: early stopping.`);
  }
  getMonitorValue(e) {
    e == null && (e = {});
    let t = e[this.monitor];
    return t == null && console.warn(`Metric for EarlyStopping ${this.monitor} is not available. Available metrics are: ${Object.keys(e)}`), t;
  }
};
function TW(e) {
  return new NW(e);
}
var Ape = { earlyStopping: TW };
var $W = X();
$W.registerFlag("KEEP_INTERMEDIATE_TENSORS", () => false, (e) => {
  e && console.warn("Keep intermediate tensors is ON. This will print the values of all intermediate tensors during model inference. Not all models support this mode. For details, check e2e/benchmarks/ model_config.js. This significantly impacts performance.");
});
var KS = ((e) => (e[e.DT_INVALID = 0] = "DT_INVALID", e[e.DT_FLOAT = 1] = "DT_FLOAT", e[e.DT_DOUBLE = 2] = "DT_DOUBLE", e[e.DT_INT32 = 3] = "DT_INT32", e[e.DT_UINT8 = 4] = "DT_UINT8", e[e.DT_INT16 = 5] = "DT_INT16", e[e.DT_INT8 = 6] = "DT_INT8", e[e.DT_STRING = 7] = "DT_STRING", e[e.DT_COMPLEX64 = 8] = "DT_COMPLEX64", e[e.DT_INT64 = 9] = "DT_INT64", e[e.DT_BOOL = 10] = "DT_BOOL", e[e.DT_QINT8 = 11] = "DT_QINT8", e[e.DT_QUINT8 = 12] = "DT_QUINT8", e[e.DT_QINT32 = 13] = "DT_QINT32", e[e.DT_BFLOAT16 = 14] = "DT_BFLOAT16", e[e.DT_QINT16 = 15] = "DT_QINT16", e[e.DT_QUINT16 = 16] = "DT_QUINT16", e[e.DT_UINT16 = 17] = "DT_UINT16", e[e.DT_COMPLEX128 = 18] = "DT_COMPLEX128", e[e.DT_HALF = 19] = "DT_HALF", e[e.DT_RESOURCE = 20] = "DT_RESOURCE", e[e.DT_VARIANT = 21] = "DT_VARIANT", e[e.DT_UINT32 = 22] = "DT_UINT32", e[e.DT_UINT64 = 23] = "DT_UINT64", e[e.DT_FLOAT_REF = 101] = "DT_FLOAT_REF", e[e.DT_DOUBLE_REF = 102] = "DT_DOUBLE_REF", e[e.DT_INT32_REF = 103] = "DT_INT32_REF", e[e.DT_UINT8_REF = 104] = "DT_UINT8_REF", e[e.DT_INT16_REF = 105] = "DT_INT16_REF", e[e.DT_INT8_REF = 106] = "DT_INT8_REF", e[e.DT_STRING_REF = 107] = "DT_STRING_REF", e[e.DT_COMPLEX64_REF = 108] = "DT_COMPLEX64_REF", e[e.DT_INT64_REF = 109] = "DT_INT64_REF", e[e.DT_BOOL_REF = 110] = "DT_BOOL_REF", e[e.DT_QINT8_REF = 111] = "DT_QINT8_REF", e[e.DT_QUINT8_REF = 112] = "DT_QUINT8_REF", e[e.DT_QINT32_REF = 113] = "DT_QINT32_REF", e[e.DT_BFLOAT16_REF = 114] = "DT_BFLOAT16_REF", e[e.DT_QINT16_REF = 115] = "DT_QINT16_REF", e[e.DT_QUINT16_REF = 116] = "DT_QUINT16_REF", e[e.DT_UINT16_REF = 117] = "DT_UINT16_REF", e[e.DT_COMPLEX128_REF = 118] = "DT_COMPLEX128_REF", e[e.DT_HALF_REF = 119] = "DT_HALF_REF", e[e.DT_RESOURCE_REF = 120] = "DT_RESOURCE_REF", e[e.DT_VARIANT_REF = 121] = "DT_VARIANT_REF", e[e.DT_UINT32_REF = 122] = "DT_UINT32_REF", e[e.DT_UINT64_REF = 123] = "DT_UINT64_REF", e))(KS || {});
var Hx;
((e) => {
  let t;
  ((n) => {
    n[n.LEGACY = 0] = "LEGACY", n[n.V1 = 1] = "V1", n[n.V2 = 2] = "V2";
  })(t = e.CheckpointFormatVersion || (e.CheckpointFormatVersion = {}));
})(Hx || (Hx = {}));
var Ky = {};
function Epe(e, t) {
  let n = { tfOpName: e, category: "custom", inputs: [], attrs: [], customExecutor: t };
  Ky[e] = n;
}
function XS(e) {
  return Ky[e];
}
function Rpe(e) {
  delete Ky[e];
}
function I(e, t, n, s, r) {
  let a = t.inputParams[e];
  if (a && a.inputIndexStart !== void 0) {
    let o = a.inputIndexStart, u = a.inputIndexEnd === 0 ? void 0 : a.inputIndexEnd === void 0 ? o + 1 : a.inputIndexEnd;
    if (a.type === "tensor")
      return un(t.inputNames[a.inputIndexStart], n, s, r);
    if (a.type === "tensors")
      return t.inputNames.slice(o, u).map((d) => un(d, n, s, r));
    let l = un(t.inputNames.slice(o)[0], n, s, r), c = l.dataSync();
    return a.type === "number" ? c[0] : w.toNestedArray(l.shape, c);
  }
  let i = t.attrParams[e];
  return i && i.value;
}
function un(e, t, n, s) {
  let [r, a] = An(e);
  if (s != null) {
    let o = s.getHashTableHandleByName(r);
    if (o != null)
      return o;
  }
  let i = n.currentContextIds.find((o) => !!t[Ed(r, o)]);
  return i !== void 0 ? t[Ed(r, i)][a] : void 0;
}
function _W(e, t, n) {
  return t[Ed(e, n.currentContextId)];
}
function Ts(e, t) {
  let [n, s, r] = An(e);
  return [Ed(n, t && t.currentContextId), s, r];
}
function Ed(e, t) {
  return t ? `${e}-${t}` : e;
}
function An(e) {
  let t = e.split(":");
  if (t.length === 1)
    return [e, 0, void 0];
  let n = t[0], s = t.length === 3 ? t[1] : void 0, r = Number(t[t.length - 1]);
  return [n, r, s];
}
function sd(e, t, n) {
  let s = I("pad", e, t, n);
  if (s === "explicit") {
    s = I("explicitPaddings", e, t, n);
    let r = [[0, 0], [0, 0], [0, 0], [0, 0]];
    for (let a = 0; a < 4; a++)
      r[a][0] = s[a * 2], r[a][1] = s[a * 2 + 1];
    return r;
  }
  return s;
}
function Us(e) {
  return e.kept ? e : lr(e);
}
var YS = {};
Ae(YS, { json: () => AW });
var AW = [{ tfOpName: "Add", category: "arithmetic", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "AddV2", category: "arithmetic", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "AddN", category: "arithmetic", inputs: [{ start: 0, end: 0, name: "tensors", type: "tensors" }] }, { tfOpName: "BiasAdd", category: "arithmetic", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }, { tfName: "data_format", name: "dataFormat", type: "string", notSupported: true }] }, { tfOpName: "Sub", category: "arithmetic", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "RealDiv", category: "arithmetic", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Div", category: "arithmetic", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "DivNoNan", category: "arithmetic", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "FloorDiv", category: "arithmetic", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Mul", category: "arithmetic", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Maximum", category: "arithmetic", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Minimum", category: "arithmetic", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Pow", category: "arithmetic", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "SquaredDifference", category: "arithmetic", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Mod", category: "arithmetic", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "FloorMod", category: "arithmetic", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }];
var QS = {};
Ae(QS, { json: () => EW });
var EW = [{ tfOpName: "Abs", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Acos", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Asin", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Atan", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Atan2", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "y", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Ceil", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "ClipByValue", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "clipValueMin", type: "number" }, { start: 2, name: "clipValueMax", type: "number" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Complex", category: "basic_math", inputs: [{ start: 0, name: "real", type: "tensor" }, { start: 1, name: "imag", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "ComplexAbs", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Cos", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Cosh", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Elu", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Exp", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Floor", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Log", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Imag", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }, { tfName: "Tout", name: "outputType", type: "dtype", notSupported: true }] }, { tfOpName: "Neg", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Real", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }, { tfName: "Tout", name: "outputType", type: "dtype", notSupported: true }] }, { tfOpName: "Prelu", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "alpha", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Relu", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Relu6", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Selu", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Sigmoid", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Sin", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Sinh", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Sqrt", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Rsqrt", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Square", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Tan", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Tanh", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Sign", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Round", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Expm1", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Log1p", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Reciprocal", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Softplus", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Asinh", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Acosh", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Atanh", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Erf", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Prod", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "axes", type: "number[]" }], attrs: [{ tfName: "keep_dims", name: "keepDims", type: "bool", notSupported: true }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "LeakyRelu", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "alpha", name: "alpha", type: "number", defaultValue: 0.2 }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "IsNan", category: "basic_math", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }];
var ZS = {};
Ae(ZS, { json: () => RW });
var RW = [{ tfOpName: "EmptyTensorList", category: "control", inputs: [{ start: 0, name: "elementShape", type: "shape" }, { start: 1, name: "maxNumElements", type: "number" }], attrs: [{ tfName: "element_dtype", name: "elementDType", type: "dtype" }] }, { tfOpName: "LoopCond", category: "control", inputs: [{ start: 0, name: "pred", type: "tensor" }] }, { tfOpName: "Switch", category: "control", inputs: [{ start: 0, name: "data", type: "tensor" }, { start: 1, name: "pred", type: "tensor" }] }, { tfOpName: "Merge", category: "control", inputs: [{ start: 0, end: 0, name: "tensors", type: "tensors" }] }, { tfOpName: "Enter", category: "control", inputs: [{ start: 0, name: "tensor", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }, { tfName: "frame_name", name: "frameName", type: "string" }, { tfName: "is_constant", name: "isConstant", type: "bool" }] }, { tfOpName: "Exit", category: "control", inputs: [{ start: 0, name: "tensor", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "NextIteration", category: "control", inputs: [{ start: 0, name: "tensor", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "TensorArrayV3", category: "control", inputs: [{ start: 0, name: "size", type: "number" }], attrs: [{ tfName: "dtype", name: "dtype", type: "dtype" }, { tfName: "element_shape", name: "elementShape", type: "shape" }, { tfName: "dynamic_size", name: "dynamicSize", type: "bool" }, { tfName: "clear_after_read", name: "clearAfterRead", type: "bool" }, { tfName: "identical_element_shapes", name: "identicalElementShapes", type: "bool" }, { tfName: "tensor_array_name", name: "name", type: "string" }] }, { tfOpName: "TensorArrayWriteV3", category: "control", inputs: [{ start: 0, name: "tensorArrayId", type: "tensor" }, { start: 1, name: "index", type: "number" }, { start: 2, name: "tensor", type: "tensor" }, { start: 3, name: "flowIn", type: "number" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "TensorArrayReadV3", category: "control", inputs: [{ start: 0, name: "tensorArrayId", type: "tensor" }, { start: 1, name: "index", type: "number" }, { start: 2, name: "flowIn", type: "number" }], attrs: [{ tfName: "dtype", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "TensorArrayGatherV3", category: "control", inputs: [{ start: 0, name: "tensorArrayId", type: "tensor" }, { start: 1, name: "indices", type: "number[]" }, { start: 2, name: "flowIn", type: "number" }], attrs: [{ tfName: "dtype", name: "dtype", type: "dtype" }, { tfName: "element_shape", name: "elementShape", type: "shape" }] }, { tfOpName: "TensorArrayScatterV3", category: "control", inputs: [{ start: 0, name: "tensorArrayId", type: "tensor" }, { start: 1, name: "indices", type: "number[]" }, { start: 2, name: "tensor", type: "tensor" }, { start: 3, name: "flowIn", type: "number" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype" }] }, { tfOpName: "TensorArrayConcatV3", category: "control", inputs: [{ start: 0, name: "tensorArrayId", type: "tensor" }, { start: 1, name: "flowIn", type: "number" }], attrs: [{ tfName: "dtype", name: "dtype", type: "dtype" }, { tfName: "element_shape_except0", name: "elementShapeExcept0", type: "shape", notSupported: true }] }, { tfOpName: "TensorArraySplitV3", category: "control", inputs: [{ start: 0, name: "tensorArrayId", type: "tensor" }, { start: 1, name: "tensor", type: "tensor" }, { start: 2, name: "lengths", type: "number[]" }, { start: 3, name: "flowIn", type: "number" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype" }] }, { tfOpName: "TensorArraySizeV3", category: "control", inputs: [{ start: 0, name: "tensorArrayId", type: "tensor" }, { start: 1, name: "flowIn", type: "number" }] }, { tfOpName: "TensorArrayCloseV3", category: "control", inputs: [{ start: 0, name: "tensorArrayId", type: "tensor" }] }, { tfOpName: "StatelessIf", category: "control", inputs: [{ start: 0, name: "cond", type: "tensor" }, { start: 1, end: 0, name: "args", type: "tensors" }], attrs: [{ tfName: "then_branch", name: "thenBranch", type: "func" }, { tfName: "else_branch", name: "elseBranch", type: "func" }] }, { tfOpName: "If", category: "control", inputs: [{ start: 0, name: "cond", type: "tensor" }, { start: 1, end: 0, name: "args", type: "tensors" }], attrs: [{ tfName: "then_branch", name: "thenBranch", type: "func" }, { tfName: "else_branch", name: "elseBranch", type: "func" }] }, { tfOpName: "StatelessWhile", category: "control", inputs: [{ start: 0, end: 0, name: "args", type: "tensors" }], attrs: [{ tfName: "cond", name: "cond", type: "func" }, { tfName: "body", name: "body", type: "func" }] }, { tfOpName: "While", category: "control", inputs: [{ start: 0, end: 0, name: "args", type: "tensors" }], attrs: [{ tfName: "cond", name: "cond", type: "func" }, { tfName: "body", name: "body", type: "func" }] }, { tfOpName: "TensorListScatter", category: "control", inputs: [{ start: 0, name: "tensor", type: "tensor" }, { start: 1, name: "indices", type: "number[]" }, { start: 2, name: "elementShape", type: "shape" }], attrs: [{ tfName: "element_dtype", name: "elementDType", type: "dtype" }] }, { tfOpName: "TensorListScatterV2", category: "control", inputs: [{ start: 0, name: "tensor", type: "tensor" }, { start: 1, name: "indices", type: "number[]" }, { start: 2, name: "elementShape", type: "shape" }, { start: 3, name: "numElements", type: "number" }], attrs: [{ tfName: "element_dtype", name: "elementDType", type: "dtype" }] }, { tfOpName: "TensorListGather", category: "control", inputs: [{ start: 0, name: "tensorListId", type: "tensor" }, { start: 1, name: "indices", type: "number[]" }, { start: 2, name: "elementShape", type: "shape" }], attrs: [{ tfName: "element_dtype", name: "elementDType", type: "dtype" }] }, { tfOpName: "TensorListGetItem", category: "control", inputs: [{ start: 0, name: "tensorListId", type: "tensor" }, { start: 1, name: "index", type: "number" }, { start: 2, name: "elementShape", type: "shape" }], attrs: [{ tfName: "element_dtype", name: "elementDType", type: "dtype" }] }, { tfOpName: "TensorListSetItem", category: "control", inputs: [{ start: 0, name: "tensorListId", type: "tensor" }, { start: 1, name: "index", type: "number" }, { start: 2, name: "tensor", type: "tensor" }], attrs: [{ tfName: "element_dtype", name: "elementDType", type: "dtype" }] }, { tfOpName: "TensorListReserve", category: "control", inputs: [{ start: 0, name: "elementShape", type: "shape" }, { start: 1, name: "numElements", type: "number" }], attrs: [{ tfName: "element_dtype", name: "elementDType", type: "dtype" }] }, { tfOpName: "TensorListFromTensor", category: "control", inputs: [{ start: 0, name: "tensor", type: "tensor" }, { start: 1, name: "elementShape", type: "shape" }], attrs: [{ tfName: "element_dtype", name: "elementDType", type: "dtype" }] }, { tfOpName: "TensorListStack", category: "control", inputs: [{ start: 0, name: "tensorListId", type: "tensor" }, { start: 1, name: "elementShape", type: "shape" }], attrs: [{ tfName: "element_dtype", name: "elementDType", type: "dtype" }, { tfName: "num_elements", name: "numElements", type: "dtype" }] }, { tfOpName: "TensorListSplit", category: "control", inputs: [{ start: 0, name: "tensor", type: "tensor" }, { start: 1, name: "elementShape", type: "shape" }, { start: 2, name: "lengths", type: "number[]" }], attrs: [{ tfName: "element_dtype", name: "elementDType", type: "dtype" }] }, { tfOpName: "TensorListConcat", category: "control", inputs: [{ start: 0, name: "tensorListId", type: "tensor" }], attrs: [{ tfName: "element_shape", name: "elementShape", type: "shape" }, { tfName: "element_dtype", name: "elementDType", type: "dtype" }] }, { tfOpName: "TensorListPopBack", category: "control", inputs: [{ start: 0, name: "tensorListId", type: "tensor" }, { start: 1, name: "elementShape", type: "shape" }], attrs: [{ tfName: "element_dtype", name: "elementDType", type: "dtype" }] }, { tfOpName: "TensorListPushBack", category: "control", inputs: [{ start: 0, name: "tensorListId", type: "tensor" }, { start: 1, name: "tensor", type: "tensor" }], attrs: [{ tfName: "element_dtype", name: "elementDType", type: "dtype" }] }, { tfOpName: "TensorListLength", category: "control", inputs: [{ start: 0, name: "tensorListId", type: "tensor" }] }, { tfOpName: "TensorListResize", category: "control", inputs: [{ start: 0, name: "tensorListId", type: "tensor" }, { start: 1, name: "size", type: "number" }] }];
var JS = {};
Ae(JS, { json: () => DW });
var DW = [{ tfOpName: "AvgPool", category: "convolution", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "strides", name: "strides", type: "number[]" }, { tfName: "padding", name: "pad", type: "string" }, { tfName: "data_format", name: "dataFormat", type: "string", notSupported: true }, { tfName: "ksize", name: "kernelSize", type: "number[]" }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "MaxPool", category: "convolution", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "strides", name: "strides", type: "number[]" }, { tfName: "padding", name: "pad", type: "string" }, { tfName: "data_format", name: "dataFormat", type: "string", notSupported: true }, { tfName: "ksize", name: "kernelSize", type: "number[]" }, { tfName: "explicit_paddings", name: "explicitPaddings", type: "number[]", defaultValue: [], notSupported: true }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "MaxPoolWithArgmax", category: "convolution", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "strides", name: "strides", type: "number[]" }, { tfName: "padding", name: "pad", type: "string" }, { tfName: "ksize", name: "kernelSize", type: "number[]" }, { tfName: "include_batch_in_index", name: "includeBatchInIndex", type: "bool" }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "AvgPool3D", category: "convolution", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "strides", name: "strides", type: "number[]" }, { tfName: "padding", name: "pad", type: "string" }, { tfName: "data_format", name: "dataFormat", type: "string", notSupported: true }, { tfName: "ksize", name: "kernelSize", type: "number[]" }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "MaxPool3D", category: "convolution", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "strides", name: "strides", type: "number[]" }, { tfName: "padding", name: "pad", type: "string" }, { tfName: "data_format", name: "dataFormat", type: "string", notSupported: true }, { tfName: "ksize", name: "kernelSize", type: "number[]" }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Conv1D", category: "convolution", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "filter", type: "tensor" }], attrs: [{ tfName: "stride", name: "stride", type: "number" }, { tfName: "padding", name: "pad", type: "string" }, { tfName: "data_format", name: "dataFormat", type: "string", defaultValue: "NWC" }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }, { tfName: "dilation", name: "dilation", type: "number", defaultValue: 1 }] }, { tfOpName: "Conv2D", category: "convolution", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "filter", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }, { tfName: "strides", name: "strides", type: "number[]" }, { tfName: "padding", name: "pad", type: "string" }, { tfName: "useCudnnOnGpu", name: "useCudnnOnGpu", type: "bool" }, { tfName: "data_format", name: "dataFormat", type: "string", defaultValue: "NHWC" }, { tfName: "explicit_paddings", name: "explicitPaddings", type: "number[]", defaultValue: [] }, { tfName: "dilations", name: "dilations", type: "number[]" }] }, { tfOpName: "_FusedConv2D", category: "convolution", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "filter", type: "tensor" }, { start: 2, end: 0, name: "args", type: "tensors" }], attrs: [{ tfName: "num_args", name: "numArgs", type: "number" }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }, { tfName: "strides", name: "strides", type: "number[]" }, { tfName: "padding", name: "pad", type: "string" }, { tfName: "explicit_paddings", name: "explicitPaddings", type: "number[]", defaultValue: [] }, { tfName: "use_cudnn_on_gpu", name: "useCudnnOnGpu", type: "bool", defaultValue: true }, { tfName: "data_format", name: "dataFormat", type: "string", defaultValue: "NHWC" }, { tfName: "dilations", name: "dilations", type: "number[]", defaultValue: [1, 1, 1, 1] }, { tfName: "fused_ops", name: "fusedOps", type: "string[]", defaultValue: [] }, { tfName: "epsilon", name: "epsilon", type: "number", defaultValue: 1e-4 }, { tfName: "leakyrelu_alpha", name: "leakyreluAlpha", type: "number" }] }, { tfOpName: "Conv2DBackpropInput", category: "convolution", inputs: [{ start: 2, name: "x", type: "tensor" }, { start: 1, name: "filter", type: "tensor" }, { start: 0, name: "outputShape", type: "number[]" }], attrs: [{ tfName: "strides", name: "strides", type: "number[]" }, { tfName: "padding", name: "pad", type: "string" }, { tfName: "data_format", name: "dataFormat", type: "string", notSupported: true }, { tfName: "explicit_paddings", name: "explicitPaddings", type: "number[]", defaultValue: [] }, { tfName: "dilations", name: "dilations", type: "number[]", notSupported: true }] }, { tfOpName: "DepthwiseConv2d", category: "convolution", inputs: [{ start: 0, name: "input", type: "tensor" }, { start: 1, name: "filter", type: "tensor" }], attrs: [{ tfName: "strides", name: "strides", type: "number[]" }, { tfName: "padding", name: "pad", type: "string" }, { tfName: "data_format", name: "dataFormat", type: "string", defaultValue: "NHWC" }, { tfName: "explicit_paddings", name: "explicitPaddings", type: "number[]", defaultValue: [] }, { tfName: "dilations", name: "dilations", type: "number[]" }] }, { tfOpName: "DepthwiseConv2dNative", category: "convolution", inputs: [{ start: 0, name: "input", type: "tensor" }, { start: 1, name: "filter", type: "tensor" }], attrs: [{ tfName: "strides", name: "strides", type: "number[]" }, { tfName: "padding", name: "pad", type: "string" }, { tfName: "data_format", name: "dataFormat", type: "string", defaultValue: "NHWC" }, { tfName: "explicit_paddings", name: "explicitPaddings", type: "number[]", defaultValue: [] }, { tfName: "dilations", name: "dilations", type: "number[]" }] }, { tfOpName: "FusedDepthwiseConv2dNative", category: "convolution", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "filter", type: "tensor" }, { start: 2, end: 0, name: "args", type: "tensors" }], attrs: [{ tfName: "num_args", name: "numArgs", type: "number" }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }, { tfName: "strides", name: "strides", type: "number[]" }, { tfName: "padding", name: "pad", type: "string" }, { tfName: "data_format", name: "dataFormat", type: "string", defaultValue: "NHWC" }, { tfName: "dilations", name: "dilations", type: "number[]", defaultValue: [1, 1, 1, 1] }, { tfName: "fused_ops", name: "fusedOps", type: "string[]", defaultValue: [] }, { tfName: "explicit_paddings", name: "explicitPaddings", type: "number[]", defaultValue: [] }] }, { tfOpName: "Conv3D", category: "convolution", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "filter", type: "tensor" }], attrs: [{ tfName: "strides", name: "strides", type: "number[]" }, { tfName: "padding", name: "pad", type: "string" }, { tfName: "data_format", name: "dataFormat", type: "string", defaultValue: "NHWC" }, { tfName: "dilations", name: "dilations", type: "number[]" }] }, { tfOpName: "Dilation2D", category: "convolution", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "filter", type: "tensor" }], attrs: [{ tfName: "strides", name: "strides", type: "number[]" }, { tfName: "rates", name: "dilations", type: "number[]" }, { tfName: "padding", name: "pad", type: "string" }] }];
var e0 = {};
Ae(e0, { json: () => FW });
var FW = [{ tfOpName: "Fill", category: "creation", inputs: [{ start: 0, name: "shape", type: "number[]" }, { start: 1, name: "value", type: "number" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype" }] }, { tfOpName: "LinSpace", category: "creation", inputs: [{ start: 0, name: "start", type: "number" }, { start: 1, name: "stop", type: "number" }, { start: 2, name: "num", type: "number" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "OneHot", category: "creation", inputs: [{ start: 0, name: "indices", type: "tensor" }, { start: 1, name: "depth", type: "number" }, { start: 2, name: "onValue", type: "number", defaultValue: 1 }, { start: 3, name: "offValue", type: "number", defaultValue: 0 }], attrs: [{ tfName: "axis", name: "axis", type: "number", notSupported: true }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Ones", category: "creation", inputs: [{ start: 0, name: "shape", type: "number[]" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype" }] }, { tfOpName: "OnesLike", category: "creation", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "dtype", name: "dtype", type: "dtype" }] }, { tfOpName: "RandomUniform", category: "creation", inputs: [{ start: 0, name: "shape", type: "number[]" }], attrs: [{ tfName: "minval", name: "minval", type: "number", defaultValue: 0 }, { tfName: "maxval", name: "maxval", type: "number", defaultValue: 1 }, { tfName: "dtype", name: "dtype", type: "dtype" }, { tfName: "seed", name: "seed", type: "number", defaultValue: 0 }, { tfName: "seed2", name: "seed2", type: "number", defaultValue: 0, notSupported: true }, { tfName: "T", name: "T", type: "number", notSupported: true }] }, { tfOpName: "Range", category: "creation", inputs: [{ start: 0, name: "start", type: "number" }, { start: 1, name: "stop", type: "number" }, { start: 2, name: "step", type: "number", defaultValue: 0 }], attrs: [{ tfName: "Tidx", name: "dtype", type: "dtype" }] }, { tfOpName: "TruncatedNormal", category: "creation", inputs: [{ start: 0, name: "shape", type: "number[]" }], attrs: [{ tfName: "means", name: "mean", type: "number", defaultValue: 0 }, { tfName: "stddev", name: "stdDev", type: "number", defaultValue: 1 }, { tfName: "seed", name: "seed", type: "number" }, { tfName: "seed2", name: "seed2", type: "number", defaultValue: 0, notSupported: true }, { tfName: "dtype", name: "dtype", type: "dtype" }, { tfName: "T", name: "T", type: "number", notSupported: true }] }, { tfOpName: "Zeros", category: "creation", inputs: [{ start: 0, name: "shape", type: "number[]" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype" }] }, { tfOpName: "ZerosLike", category: "creation", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype" }] }, { tfOpName: "Multinomial", category: "creation", inputs: [{ start: 0, name: "logits", type: "tensor" }, { start: 1, name: "numSamples", type: "number" }], attrs: [{ tfName: "seed", name: "seed", type: "number" }, { tfName: "seed2", name: "seed2", type: "number" }, { tfName: "T", name: "dtype", type: "dtype" }, { tfName: "output_dtype", name: "output_dtype", type: "dtype" }] }];
var t0 = {};
Ae(t0, { json: () => OW });
var OW = [{ tfOpName: "NonMaxSuppressionV2", category: "dynamic", inputs: [{ start: 0, name: "boxes", type: "tensor" }, { start: 1, name: "scores", type: "tensor" }, { start: 2, name: "maxOutputSize", type: "number" }, { start: 3, name: "iouThreshold", type: "number" }] }, { tfOpName: "NonMaxSuppressionV3", category: "dynamic", inputs: [{ start: 0, name: "boxes", type: "tensor" }, { start: 1, name: "scores", type: "tensor" }, { start: 2, name: "maxOutputSize", type: "number" }, { start: 3, name: "iouThreshold", type: "number" }, { start: 4, name: "scoreThreshold", type: "number" }] }, { tfOpName: "NonMaxSuppressionV4", category: "dynamic", inputs: [{ start: 0, name: "boxes", type: "tensor" }, { start: 1, name: "scores", type: "tensor" }, { start: 2, name: "maxOutputSize", type: "number" }, { start: 3, name: "iouThreshold", type: "number" }, { start: 4, name: "scoreThreshold", type: "number" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }, { tfName: "T_threshold", name: "threshold", type: "dtype", notSupported: true }, { tfName: "pad_to_max_output_size", name: "padToMaxOutputSize", type: "bool" }] }, { tfOpName: "NonMaxSuppressionV5", category: "dynamic", inputs: [{ start: 0, name: "boxes", type: "tensor" }, { start: 1, name: "scores", type: "tensor" }, { start: 2, name: "maxOutputSize", type: "number" }, { start: 3, name: "iouThreshold", type: "number" }, { start: 4, name: "scoreThreshold", type: "number" }, { start: 5, name: "softNmsSigma", type: "number" }] }, { tfOpName: "Where", category: "dynamic", inputs: [{ start: 0, name: "condition", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "ListDiff", category: "dynamic", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "y", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }];
var n0 = {};
Ae(n0, { json: () => PW });
var PW = [{ tfOpName: "TopKV2", category: "evaluation", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "k", type: "number" }], attrs: [{ tfName: "sorted", name: "sorted", type: "bool" }] }, { tfOpName: "Unique", category: "evaluation", inputs: [{ start: 0, name: "x", type: "tensor" }] }, { tfOpName: "UniqueV2", category: "evaluation", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "axis", type: "number" }] }];
var s0 = {};
Ae(s0, { json: () => zW });
var zW = [{ tfOpName: "PlaceholderWithDefault", category: "graph", inputs: [{ start: 0, name: "default", type: "tensor" }], attrs: [{ tfName: "shape", name: "shape", type: "shape" }, { tfName: "dtype", name: "dtype", type: "dtype" }] }, { tfOpName: "Placeholder", category: "graph", attrs: [{ tfName: "shape", name: "shape", type: "shape" }, { tfName: "dtype", name: "dtype", type: "dtype" }] }, { tfOpName: "Const", category: "graph" }, { tfOpName: "Identity", category: "graph", inputs: [{ start: 0, name: "x", type: "tensor" }] }, { tfOpName: "IdentityN", category: "graph", inputs: [{ start: 0, end: 0, name: "x", type: "tensors" }] }, { tfOpName: "Snapshot", category: "graph", inputs: [{ start: 0, name: "x", type: "tensor" }] }, { tfOpName: "Rank", category: "graph", inputs: [{ start: 0, name: "x", type: "tensor" }] }, { tfOpName: "Size", category: "graph", inputs: [{ start: 0, name: "x", type: "tensor" }] }, { tfOpName: "Shape", category: "graph", inputs: [{ start: 0, name: "x", type: "tensor" }] }, { tfOpName: "ShapeN", category: "graph", inputs: [{ start: 0, end: 0, name: "x", type: "tensors" }] }, { tfOpName: "Print", category: "graph", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "data", type: "tensors" }], attrs: [{ tfName: "message", name: "message", type: "string" }, { tfName: "first_n", name: "firstN", type: "number", notSupported: true }, { tfName: "summarize", name: "summarize", type: "number", defaultValue: 3 }] }, { tfOpName: "NoOp", category: "graph", inputs: [] }, { tfOpName: "StopGradient", category: "graph", inputs: [{ start: 0, name: "x", type: "tensor" }] }, { tfOpName: "FakeQuantWithMinMaxVars", category: "graph", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "min", name: "min", type: "number" }, { tfName: "max", name: "max", type: "number" }] }];
var r0 = {};
Ae(r0, { json: () => MW });
var MW = [{ tfOpName: "HashTable", category: "hash_table", inputs: [], attrs: [{ tfName: "shared_name", name: "sharedName", type: "string" }, { tfName: "use_node_name_sharing", name: "useNodeNameSharing", type: "bool" }, { tfName: "key_dtype", name: "keyDType", type: "dtype" }, { tfName: "value_dtype", name: "valueDType", type: "dtype" }] }, { tfOpName: "HashTableV2", category: "hash_table", inputs: [], attrs: [{ tfName: "shared_name", name: "sharedName", type: "string" }, { tfName: "use_node_name_sharing", name: "useNodeNameSharing", type: "bool" }, { tfName: "key_dtype", name: "keyDType", type: "dtype" }, { tfName: "value_dtype", name: "valueDType", type: "dtype" }] }, { tfOpName: "LookupTableImport", category: "hash_table", inputs: [{ start: 0, name: "tableHandle", type: "tensor" }, { start: 1, name: "keys", type: "tensor" }, { start: 2, name: "values", type: "tensor" }], attrs: [{ tfName: "Tin", name: "tIn", type: "dtype", notSupported: true }, { tfName: "Tout", name: "tOut", type: "dtype", notSupported: true }] }, { tfOpName: "LookupTableImportV2", category: "hash_table", inputs: [{ start: 0, name: "tableHandle", type: "tensor" }, { start: 1, name: "keys", type: "tensor" }, { start: 2, name: "values", type: "tensor" }], attrs: [{ tfName: "Tin", name: "tIn", type: "dtype", notSupported: true }, { tfName: "Tout", name: "tOut", type: "dtype", notSupported: true }] }, { tfOpName: "LookupTableFind", category: "hash_table", inputs: [{ start: 0, name: "tableHandle", type: "tensor" }, { start: 1, name: "keys", type: "tensor" }, { start: 2, name: "defaultValue", type: "tensor" }], attrs: [{ tfName: "Tin", name: "tIn", type: "dtype", notSupported: true }, { tfName: "Tout", name: "tOut", type: "dtype", notSupported: true }] }, { tfOpName: "LookupTableFindV2", category: "hash_table", inputs: [{ start: 0, name: "tableHandle", type: "tensor" }, { start: 1, name: "keys", type: "tensor" }, { start: 2, name: "defaultValue", type: "tensor" }], attrs: [{ tfName: "Tin", name: "tIn", type: "dtype", notSupported: true }, { tfName: "Tout", name: "tOut", type: "dtype", notSupported: true }] }, { tfOpName: "LookupTableSize", category: "hash_table", inputs: [{ start: 0, name: "tableHandle", type: "tensor" }] }, { tfOpName: "LookupTableSizeV2", category: "hash_table", inputs: [{ start: 0, name: "tableHandle", type: "tensor" }] }];
var a0 = {};
Ae(a0, { json: () => LW });
var LW = [{ tfOpName: "ResizeBilinear", category: "image", inputs: [{ start: 0, name: "images", type: "tensor" }, { start: 1, name: "size", type: "number[]" }], attrs: [{ tfName: "align_corners", name: "alignCorners", type: "bool" }, { tfName: "half_pixel_centers", name: "halfPixelCenters", type: "bool" }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "ResizeNearestNeighbor", category: "image", inputs: [{ start: 0, name: "images", type: "tensor" }, { start: 1, name: "size", type: "number[]" }], attrs: [{ tfName: "align_corners", name: "alignCorners", type: "bool" }, { tfName: "half_pixel_centers", name: "halfPixelCenters", type: "bool" }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "CropAndResize", category: "image", inputs: [{ start: 0, name: "image", type: "tensor" }, { start: 1, name: "boxes", type: "tensor" }, { start: 2, name: "boxInd", type: "tensor" }, { start: 3, name: "cropSize", type: "number[]" }], attrs: [{ tfName: "method", name: "method", type: "string" }, { tfName: "extrapolation_value", name: "extrapolationValue", type: "number" }] }, { tfOpName: "ImageProjectiveTransformV3", category: "image", inputs: [{ start: 0, name: "images", type: "tensor" }, { start: 1, name: "transforms", type: "tensor" }, { start: 2, name: "outputShape", type: "number[]" }, { start: 3, name: "fillValue", type: "number" }], attrs: [{ tfName: "interpolation", name: "interpolation", type: "string" }, { tfName: "fill_mode", name: "fillMode", type: "string" }] }];
var i0 = {};
Ae(i0, { json: () => BW });
var BW = [{ tfOpName: "Equal", category: "logical", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "NotEqual", category: "logical", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Greater", category: "logical", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "GreaterEqual", category: "logical", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Less", category: "logical", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "LessEqual", category: "logical", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "LogicalAnd", category: "logical", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "LogicalNot", category: "logical", inputs: [{ start: 0, name: "a", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "LogicalOr", category: "logical", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Select", category: "logical", inputs: [{ start: 0, name: "condition", type: "tensor" }, { start: 1, name: "a", type: "tensor" }, { start: 2, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "SelectV2", category: "logical", inputs: [{ start: 0, name: "condition", type: "tensor" }, { start: 1, name: "a", type: "tensor" }, { start: 2, name: "b", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }];
var o0 = {};
Ae(o0, { json: () => VW });
var VW = [{ tfOpName: "_FusedMatMul", category: "matrices", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }, { start: 2, end: 0, name: "args", type: "tensors" }], attrs: [{ tfName: "num_args", name: "numArgs", type: "number" }, { tfName: "fused_ops", name: "fusedOps", type: "string[]", defaultValue: [] }, { tfName: "epsilon", name: "epsilon", type: "number", defaultValue: 1e-4 }, { tfName: "transpose_a", name: "transposeA", type: "bool", defaultValue: false }, { tfName: "transpose_b", name: "transposeB", type: "bool", defaultValue: false }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "MatMul", category: "matrices", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "transpose_a", name: "transposeA", type: "bool", defaultValue: false }, { tfName: "transpose_b", name: "transposeB", type: "bool", defaultValue: false }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "BatchMatMul", category: "matrices", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "adj_x", name: "transposeA", type: "bool", defaultValue: false }, { tfName: "adj_y", name: "transposeB", type: "bool", defaultValue: false }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "BatchMatMulV2", category: "matrices", inputs: [{ start: 0, name: "a", type: "tensor" }, { start: 1, name: "b", type: "tensor" }], attrs: [{ tfName: "adj_x", name: "transposeA", type: "bool", defaultValue: false }, { tfName: "adj_y", name: "transposeB", type: "bool", defaultValue: false }, { tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Transpose", category: "matrices", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "perm", type: "number[]" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "Einsum", category: "matrices", inputs: [{ start: 0, end: 0, name: "tensors", type: "tensors" }], attrs: [{ tfName: "equation", name: "equation", type: "string" }, { tfName: "N", name: "n", type: "number", defaultValue: 2 }, { tfName: "T", name: "dtype", type: "dtype" }] }];
var u0 = {};
Ae(u0, { json: () => WW });
var WW = [{ tfOpName: "FusedBatchNorm", category: "normalization", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "scale", type: "tensor" }, { start: 2, name: "offset", type: "tensor" }, { start: 3, name: "mean", type: "tensor" }, { start: 4, name: "variance", type: "tensor" }], attrs: [{ tfName: "epsilon", name: "epsilon", type: "number", defaultValue: 1e-3 }, { tfName: "data_format", name: "dataFormat", type: "string", notSupported: true }] }, { tfOpName: "FusedBatchNormV2", category: "normalization", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "scale", type: "tensor" }, { start: 2, name: "offset", type: "tensor" }, { start: 3, name: "mean", type: "tensor" }, { start: 4, name: "variance", type: "tensor" }], attrs: [{ tfName: "epsilon", name: "epsilon", type: "number", defaultValue: 1e-3 }, { tfName: "data_format", name: "dataFormat", type: "string", notSupported: true }] }, { tfOpName: "FusedBatchNormV3", category: "normalization", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "scale", type: "tensor" }, { start: 2, name: "offset", type: "tensor" }, { start: 3, name: "mean", type: "tensor" }, { start: 4, name: "variance", type: "tensor" }], attrs: [{ tfName: "epsilon", name: "epsilon", type: "number", defaultValue: 1e-3 }, { tfName: "data_format", name: "dataFormat", type: "string", notSupported: true }] }, { tfOpName: "LRN", category: "normalization", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "depth_radius", name: "radius", type: "number", defaultValue: 5 }, { tfName: "bias", name: "bias", type: "number", defaultValue: 1 }, { tfName: "alpha", name: "alpha", type: "number", defaultValue: 1 }, { tfName: "beta", name: "beta", type: "number", defaultValue: 0.5 }] }, { tfOpName: "Softmax", category: "normalization", inputs: [{ start: 0, name: "x", type: "tensor" }] }, { tfOpName: "LogSoftmax", category: "normalization", inputs: [{ start: 0, name: "x", type: "tensor" }] }, { tfOpName: "SparseToDense", category: "normalization", inputs: [{ start: 0, name: "sparseIndices", type: "tensor" }, { start: 1, name: "outputShape", type: "number[]" }, { start: 2, name: "sparseValues", type: "tensor" }, { start: 3, name: "defaultValue", type: "tensor" }], attrs: [{ tfName: "validate_indices", name: "validateIndices", type: "bool", defaultValue: true, notSupported: true }] }];
var l0 = {};
Ae(l0, { json: () => UW });
var UW = [{ tfOpName: "Bincount", category: "reduction", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "size", type: "number" }, { start: 2, name: "weights", type: "tensor" }] }, { tfOpName: "DenseBincount", category: "reduction", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "size", type: "number" }, { start: 2, name: "weights", type: "tensor" }], attrs: [{ tfName: "binary_output", name: "binaryOutput", type: "bool" }] }, { tfOpName: "Max", category: "reduction", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "axis", type: "number[]" }], attrs: [{ tfName: "keep_dims", name: "keepDims", type: "bool" }] }, { tfOpName: "Mean", category: "reduction", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "axis", type: "number[]" }], attrs: [{ tfName: "keep_dims", name: "keepDims", type: "bool" }] }, { tfOpName: "Min", category: "reduction", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "axis", type: "number[]" }], attrs: [{ tfName: "keep_dims", name: "keepDims", type: "bool" }] }, { tfOpName: "Sum", category: "reduction", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "axis", type: "number[]" }], attrs: [{ tfName: "keep_dims", name: "keepDims", type: "bool" }] }, { tfOpName: "All", category: "reduction", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "axis", type: "number[]" }], attrs: [{ tfName: "keep_dims", name: "keepDims", type: "bool" }] }, { tfOpName: "Any", category: "reduction", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "axis", type: "number[]" }], attrs: [{ tfName: "keep_dims", name: "keepDims", type: "bool" }] }, { tfOpName: "ArgMax", category: "reduction", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "axis", type: "number" }] }, { tfOpName: "ArgMin", category: "reduction", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "axis", type: "number" }] }, { tfOpName: "Prod", category: "reduction", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "axis", type: "number[]" }], attrs: [{ tfName: "keep_dims", name: "keepDims", type: "bool" }] }, { tfOpName: "Cumprod", category: "reduction", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "axis", type: "number" }], attrs: [{ tfName: "exclusive", name: "exclusive", type: "bool" }, { tfName: "reverse", name: "reverse", type: "bool" }] }, { tfOpName: "Cumsum", category: "reduction", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "axis", type: "number" }], attrs: [{ tfName: "exclusive", name: "exclusive", type: "bool" }, { tfName: "reverse", name: "reverse", type: "bool" }] }];
var c0 = {};
Ae(c0, { json: () => GW });
var GW = [{ tfOpName: "ConcatV2", category: "slice_join", inputs: [{ start: 0, end: -1, name: "tensors", type: "tensors" }, { start: -1, name: "axis", type: "number" }], attrs: [{ tfName: "N", name: "n", type: "number", defaultValue: 2 }] }, { tfOpName: "Concat", category: "slice_join", inputs: [{ start: 1, end: 0, name: "tensors", type: "tensors" }, { start: 0, name: "axis", type: "number" }], attrs: [{ tfName: "N", name: "n", type: "number", defaultValue: 2 }] }, { tfOpName: "GatherV2", category: "slice_join", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "indices", type: "tensor" }, { start: 2, name: "axis", type: "number", defaultValue: 0 }], attrs: [{ tfName: "batch_dims", name: "batchDims", type: "number", defaultValue: 0 }] }, { tfOpName: "Gather", category: "slice_join", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "indices", type: "tensor" }], attrs: [{ tfName: "validate_indices", name: "validateIndices", type: "bool", notSupported: true }] }, { tfOpName: "Reverse", category: "slice_join", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "dims", type: "bool[]" }] }, { tfOpName: "ReverseV2", category: "slice_join", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "axis", type: "number[]" }] }, { tfOpName: "Slice", category: "slice_join", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "begin", type: "number[]" }, { start: 2, name: "size", type: "number[]" }] }, { tfOpName: "StridedSlice", category: "slice_join", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "begin", type: "number[]" }, { start: 2, name: "end", type: "number[]" }, { start: 3, name: "strides", type: "number[]" }], attrs: [{ tfName: "begin_mask", name: "beginMask", type: "number", defaultValue: 0 }, { tfName: "end_mask", name: "endMask", type: "number", defaultValue: 0 }, { tfName: "new_axis_mask", name: "newAxisMask", type: "number", defaultValue: 0 }, { tfName: "ellipsis_mask", name: "ellipsisMask", type: "number", defaultValue: 0 }, { tfName: "shrink_axis_mask", name: "shrinkAxisMask", type: "number", defaultValue: 0 }] }, { tfOpName: "Pack", category: "slice_join", inputs: [{ start: 0, end: 0, name: "tensors", type: "tensors" }], attrs: [{ tfName: "axis", name: "axis", type: "number", defaultValue: 0 }] }, { tfOpName: "Unpack", category: "slice_join", inputs: [{ start: 0, name: "tensor", type: "tensor" }], attrs: [{ tfName: "axis", name: "axis", type: "number", defaultValue: 0 }, { tfName: "num", name: "num", type: "number", defaultValue: 0, notSupported: true }] }, { tfOpName: "Tile", category: "slice_join", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "reps", type: "number[]" }] }, { tfOpName: "Split", category: "slice_join", inputs: [{ start: 0, name: "axis", type: "number", defaultValue: 0 }, { start: 1, name: "x", type: "tensor" }], attrs: [{ tfName: "num_split", name: "numOrSizeSplits", type: "number", defaultValue: 1 }] }, { tfOpName: "SplitV", category: "slice_join", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "numOrSizeSplits", type: "number[]" }, { start: 2, name: "axis", type: "number", defaultValue: 0 }] }, { tfOpName: "ScatterNd", category: "slice_join", inputs: [{ start: 0, name: "indices", type: "tensor" }, { start: 1, name: "values", type: "tensor" }, { start: 2, name: "shape", type: "number[]" }] }, { tfOpName: "GatherNd", category: "slice_join", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "indices", type: "tensor" }] }, { tfOpName: "SparseToDense", category: "slice_join", inputs: [{ start: 0, name: "sparseIndices", type: "tensor" }, { start: 1, name: "outputShape", type: "number[]" }, { start: 2, name: "sparseValues", type: "tensor" }, { start: 3, name: "defaultValue", type: "tensor" }], attrs: [{ tfName: "validate_indices", name: "validateIndices", type: "bool", defaultValue: false, notSupported: true }] }];
var d0 = {};
Ae(d0, { json: () => HW });
var HW = [{ tfOpName: "SparseFillEmptyRows", category: "sparse", inputs: [{ start: 0, name: "indices", type: "tensor" }, { start: 1, name: "values", type: "tensor" }, { start: 2, name: "denseShape", type: "tensor" }, { start: 3, name: "defaultValue", type: "tensor" }] }, { tfOpName: "SparseReshape", category: "sparse", inputs: [{ start: 0, name: "inputIndices", type: "tensor" }, { start: 1, name: "inputShape", type: "tensor" }, { start: 2, name: "newShape", type: "tensor" }], attrs: [{ tfName: "T", name: "dtype", type: "dtype", notSupported: true }] }, { tfOpName: "SparseSegmentMean", category: "sparse", inputs: [{ start: 0, name: "data", type: "tensor" }, { start: 1, name: "indices", type: "tensor" }, { start: 2, name: "segmentIds", type: "tensor" }] }, { tfOpName: "SparseSegmentSum", category: "sparse", inputs: [{ start: 0, name: "data", type: "tensor" }, { start: 1, name: "indices", type: "tensor" }, { start: 2, name: "segmentIds", type: "tensor" }] }];
var p0 = {};
Ae(p0, { json: () => qW });
var qW = [{ tfOpName: "FFT", category: "spectral", inputs: [{ start: 0, name: "x", type: "tensor" }] }, { tfOpName: "IFFT", category: "spectral", inputs: [{ start: 0, name: "x", type: "tensor" }] }, { tfOpName: "RFFT", category: "spectral", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "fft_length", type: "number", notSupported: true }] }, { tfOpName: "IRFFT", category: "spectral", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "fft_length", type: "number", notSupported: true }] }];
var h0 = {};
Ae(h0, { json: () => jW });
var jW = [{ tfOpName: "StringNGrams", category: "string", inputs: [{ start: 0, name: "data", type: "tensor" }, { start: 1, name: "dataSplits", type: "tensor" }], attrs: [{ tfName: "separator", name: "separator", type: "string" }, { tfName: "ngram_widths", name: "nGramWidths", type: "number[]" }, { tfName: "left_pad", name: "leftPad", type: "string" }, { tfName: "right_pad", name: "rightPad", type: "string" }, { tfName: "pad_width", name: "padWidth", type: "number" }, { tfName: "preserve_short_sequences", name: "preserveShortSequences", type: "bool" }], outputs: ["ngrams", "ngrams_splits"] }, { tfOpName: "StringSplit", category: "string", inputs: [{ start: 0, name: "input", type: "tensor" }, { start: 1, name: "delimiter", type: "tensor" }], attrs: [{ tfName: "skip_empty", name: "skipEmpty", type: "bool" }], outputs: ["indices", "values", "shape"] }, { tfOpName: "StringToHashBucketFast", category: "string", inputs: [{ start: 0, name: "input", type: "tensor" }], attrs: [{ tfName: "num_buckets", name: "numBuckets", type: "number" }] }];
var f0 = {};
Ae(f0, { json: () => KW });
var KW = [{ tfOpName: "Cast", category: "transformation", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "SrcT", name: "sdtype", type: "dtype", notSupported: true }, { tfName: "DstT", name: "dtype", type: "dtype" }] }, { tfOpName: "ExpandDims", category: "transformation", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "axis", type: "number" }] }, { tfOpName: "MirrorPad", category: "transformation", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "padding", type: "number[]" }], attrs: [{ tfName: "mode", name: "mode", type: "string" }] }, { tfOpName: "Pad", category: "transformation", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "padding", type: "number[]" }], attrs: [{ tfName: "constant_value", name: "constantValue", type: "number", defaultValue: 0 }] }, { tfOpName: "PadV2", category: "transformation", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "padding", type: "number[]" }, { start: 2, name: "constantValue", type: "number", defaultValue: 0 }] }, { tfOpName: "Reshape", category: "transformation", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "shape", type: "number[]" }] }, { tfOpName: "Squeeze", category: "transformation", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "axis", tfDeprecatedName: "squeeze_dims", name: "axis", type: "number[]" }] }, { tfOpName: "SpaceToBatchND", category: "transformation", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "blockShape", type: "number[]" }, { start: 2, name: "paddings", type: "number[]" }] }, { tfOpName: "BatchToSpaceND", category: "transformation", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "blockShape", type: "number[]" }, { start: 2, name: "crops", type: "number[]" }] }, { tfOpName: "DepthToSpace", category: "transformation", inputs: [{ start: 0, name: "x", type: "tensor" }], attrs: [{ tfName: "block_size", name: "blockSize", type: "number" }, { tfName: "data_format", name: "dataFormat", type: "string" }] }, { tfOpName: "BroadcastTo", category: "transformation", inputs: [{ start: 0, name: "x", type: "tensor" }, { start: 1, name: "shape", type: "number[]" }], attrs: [] }, { tfOpName: "BroadcastArgs", category: "transformation", inputs: [{ start: 0, name: "s0", type: "tensor" }, { start: 1, name: "s1", type: "tensor" }], attrs: [] }];
var qx = class {
  static get Instance() {
    return this._instance || (this._instance = new this());
  }
  constructor() {
    let e = [YS, QS, ZS, JS, e0, t0, n0, s0, r0, a0, i0, o0, u0, l0, c0, d0, p0, h0, f0], t = [].concat(...e.map((n) => n.json));
    this.opMappers = t.reduce((n, s) => (n[s.tfOpName] = s, n), {});
  }
  transformGraph(e, t = {}) {
    let n = e.node, s = [], r = [], a = [], i = n.reduce((f, m) => (f[m.name] = this.mapNode(m), m.op.startsWith("Placeholder") ? s.push(f[m.name]) : m.op === "Const" ? r.push(f[m.name]) : (m.input == null || m.input.length === 0) && a.push(f[m.name]), f), {}), o = [], u = [], l = {}, c = {};
    t != null && (l = this.mapSignatureEntries(t.inputs), c = this.mapSignatureEntries(t.outputs));
    let p = Object.keys(i);
    p.forEach((f) => {
      let m = i[f];
      m.inputNames.forEach((g, b) => {
        let [y, , v] = Ts(g), x = i[y];
        if (x.outputs != null) {
          let k = x.outputs.indexOf(v);
          if (k !== -1) {
            let T = `${y}:${k}`;
            m.inputNames[b] = T;
          }
        }
        m.inputs.push(x), x.children.push(m);
      });
    }), Object.keys(c).length === 0 ? p.forEach((f) => {
      let m = i[f];
      m.children.length === 0 && u.push(m);
    }) : Object.keys(c).forEach((f) => {
      let [m] = Ts(f), g = i[m];
      g != null && (g.signatureKey = c[f], u.push(g));
    }), Object.keys(l).length > 0 ? Object.keys(l).forEach((f) => {
      let [m] = Ts(f), g = i[m];
      g && (g.signatureKey = l[f], o.push(g));
    }) : o = s;
    let d = {};
    e.library != null && e.library.function != null && (d = e.library.function.reduce((f, m) => (f[m.signature.name] = this.mapFunction(m), f), {}));
    let h = { nodes: i, inputs: o, outputs: u, weights: r, placeholders: s, signature: t, functions: d };
    return a.length > 0 && (h.initNodes = a), h;
  }
  mapSignatureEntries(e) {
    return Object.keys(e || {}).reduce((t, n) => (t[e[n].name] = n, t), {});
  }
  mapNode(e) {
    let t = XS(e.op) || this.opMappers[e.op] || {};
    e.attr == null && (e.attr = {});
    let n = { name: e.name, op: e.op, category: t.category, inputNames: (e.input || []).map((s) => s.startsWith("^") ? s.slice(1) : s), inputs: [], children: [], inputParams: {}, attrParams: {}, rawAttrs: e.attr, outputs: t.outputs };
    return t.inputs != null && (n.inputParams = t.inputs.reduce((s, r) => (s[r.name] = { type: r.type, inputIndexStart: r.start, inputIndexEnd: r.end }, s), {})), t.attrs != null && (n.attrParams = t.attrs.reduce((s, r) => {
      let a = r.type, i;
      switch (r.type) {
        case "string":
          i = Nm(e.attr, r.tfName, r.defaultValue), i === void 0 && !!r.tfDeprecatedName && (i = Nm(e.attr, r.tfDeprecatedName, r.defaultValue));
          break;
        case "string[]":
          i = Dm(e.attr, r.tfName, r.defaultValue), i === void 0 && !!r.tfDeprecatedName && (i = Dm(e.attr, r.tfDeprecatedName, r.defaultValue));
          break;
        case "number":
          i = $m(e.attr, r.tfName, r.defaultValue || 0), i === void 0 && !!r.tfDeprecatedName && (i = $m(e.attr, r.tfDeprecatedName, r.defaultValue));
          break;
        case "number[]":
          i = Rm(e.attr, r.tfName, r.defaultValue), i === void 0 && !!r.tfDeprecatedName && (i = Rm(e.attr, r.tfDeprecatedName, r.defaultValue));
          break;
        case "bool":
          i = Tm(e.attr, r.tfName, r.defaultValue), i === void 0 && !!r.tfDeprecatedName && (i = Tm(e.attr, r.tfDeprecatedName, r.defaultValue));
          break;
        case "bool[]":
          i = Om(e.attr, r.tfName, r.defaultValue), i === void 0 && !!r.tfDeprecatedName && (i = Om(e.attr, r.tfDeprecatedName, r.defaultValue));
          break;
        case "shape":
          i = Em(e.attr, r.tfName, r.defaultValue), i === void 0 && !!r.tfDeprecatedName && (i = Em(e.attr, r.tfDeprecatedName, r.defaultValue));
          break;
        case "shape[]":
          i = Fm(e.attr, r.tfName, r.defaultValue), i === void 0 && !!r.tfDeprecatedName && (i = Fm(e.attr, r.tfDeprecatedName, r.defaultValue));
          break;
        case "dtype":
          i = _m(e.attr, r.tfName, r.defaultValue), i === void 0 && !!r.tfDeprecatedName && (i = _m(e.attr, r.tfDeprecatedName, r.defaultValue));
          break;
        case "dtype[]":
          i = Am(e.attr, r.tfName, r.defaultValue), i === void 0 && !!r.tfDeprecatedName && (i = Am(e.attr, r.tfDeprecatedName, r.defaultValue));
          break;
        case "func":
          i = jx(e.attr, r.tfName, r.defaultValue), i === void 0 && !!r.tfDeprecatedName && (i = jx(e.attr, r.tfDeprecatedName, r.defaultValue));
          break;
        case "tensor":
        case "tensors":
          break;
        default:
          throw new Error(`Unsupported param type: ${r.type} for op: ${e.op}`);
      }
      return s[r.name] = { value: i, type: a }, s;
    }, {})), n;
  }
  mapFunction(e) {
    let t = e.nodeDef, n = [], s = [], r = {};
    t != null && (r = t.reduce((c, p) => (c[p.name] = this.mapNode(p), p.op === "Const" && s.push(c[p.name]), c), {}));
    let a = [], i = [];
    e.signature.inputArg.forEach((c) => {
      let [p] = Ts(c.name), d = { name: p, op: "Placeholder", inputs: [], inputNames: [], category: "graph", inputParams: {}, attrParams: { dtype: { value: Xy(c.type), type: "dtype" } }, children: [] };
      d.signatureKey = c.name, a.push(d), r[p] = d;
    }), Object.keys(r).forEach((c) => {
      let p = r[c];
      p.inputNames.forEach((d, h) => {
        let [f, , m] = Ts(d), g = r[f];
        if (g.outputs != null) {
          let b = g.outputs.indexOf(m);
          if (b !== -1) {
            let y = `${f}:${b}`;
            p.inputNames[h] = y;
          }
        }
        p.inputs.push(g), g.children.push(p);
      });
    });
    let u = e.ret;
    e.signature.outputArg.forEach((c) => {
      let [p, d] = Ts(u[c.name]), h = r[p];
      h != null && (h.defaultOutput = d, i.push(h));
    });
    let l = this.mapArgsToSignature(e);
    return { nodes: r, inputs: a, outputs: i, weights: s, placeholders: n, signature: l };
  }
  mapArgsToSignature(e) {
    return { methodName: e.signature.name, inputs: e.signature.inputArg.reduce((t, n) => (t[n.name] = this.mapArgToTensorInfo(n), t), {}), outputs: e.signature.outputArg.reduce((t, n) => (t[n.name] = this.mapArgToTensorInfo(n, e.ret), t), {}) };
  }
  mapArgToTensorInfo(e, t) {
    let n = e.name;
    return t != null && (n = t[n]), { name: n, dtype: e.type };
  }
};
function XW(e) {
  let t = X().global;
  if (typeof t.atob != "undefined")
    return t.atob(e);
  if (typeof Buffer != "undefined")
    return new Buffer(e, "base64").toString();
  throw new Error("Unable to decode base64 in this environment. Missing built-in atob() or Buffer()");
}
function m0(e, t) {
  let n = Array.isArray(e) ? String.fromCharCode.apply(null, e) : XW(e);
  return t ? n : n.toLowerCase();
}
function Nm(e, t, n, s = false) {
  let r = e[t];
  return r != null ? m0(r.s, s) : n;
}
function Tm(e, t, n) {
  let s = e[t];
  return s ? s.b : n;
}
function $m(e, t, n) {
  let s = e[t] || {}, r = s.i != null ? s.i : s.f != null ? s.f : n;
  return typeof r == "number" ? r : parseInt(r, 10);
}
function Xy(e) {
  switch (typeof e == "string" && (e = KS[e]), e) {
    case 1:
    case 19:
      return "float32";
    case 3:
    case 9:
    case 6:
    case 4:
      return "int32";
    case 10:
      return "bool";
    case 2:
      return "float32";
    case 7:
      return "string";
    default:
      return null;
  }
}
function jx(e, t, n) {
  let s = e[t];
  return s && s.func ? s.func.name : n;
}
function _m(e, t, n) {
  let s = e[t];
  return s && s.type ? Xy(s.type) : n;
}
function Am(e, t, n) {
  let s = e[t];
  return s && s.list && s.list.type ? s.list.type.map((r) => Xy(r)) : n;
}
function g0(e) {
  if (!e.unknownRank)
    return e.dim != null ? e.dim.map((t) => typeof t.size == "number" ? t.size : parseInt(t.size, 10)) : [];
}
function Em(e, t, n) {
  let s = e[t];
  return s && s.shape ? g0(s.shape) : n;
}
function Rm(e, t, n) {
  let s = e[t];
  return s ? ((s.list.f && s.list.f.length ? s.list.f : s.list.i) || []).map((r) => typeof r == "number" ? r : parseInt(r, 10)) : n;
}
function Dm(e, t, n, s = false) {
  let r = e[t];
  return r && r.list && r.list.s ? r.list.s.map((a) => m0(a, s)) : n;
}
function Fm(e, t, n) {
  let s = e[t];
  return s && s.list && s.list.shape ? s.list.shape.map((r) => g0(r)) : n;
}
function Om(e, t, n) {
  let s = e[t];
  return s && s.list && s.list.b ? s.list.b : n;
}
var YW = class {
  constructor(e, t, n) {
    this.node = e, this.tensorMap = t, this.context = n, this.inputs = [], this.attrs = {}, this.inputs = e.inputNames.map((s) => this.getInput(s)), e.rawAttrs != null && (this.attrs = Object.keys(e.rawAttrs).reduce((s, r) => (s[r] = this.getAttr(r), s), {}));
  }
  getInput(e) {
    return un(e, this.tensorMap, this.context);
  }
  getAttr(e, t) {
    let n = this.node.rawAttrs[e];
    if (n.tensor != null)
      return un(e, this.tensorMap, this.context);
    if (n.i != null || n.f != null)
      return $m(this.node.rawAttrs, e, t);
    if (n.s != null)
      return Nm(this.node.rawAttrs, e, t);
    if (n.b != null)
      return Tm(this.node.rawAttrs, e, t);
    if (n.shape != null)
      return Em(this.node.rawAttrs, e, t);
    if (n.type != null)
      return _m(this.node.rawAttrs, e, t);
    if (n.list != null) {
      if (n.list.i != null || n.list.f != null)
        return Rm(this.node.rawAttrs, e, t);
      if (n.list.s != null)
        return Dm(this.node.rawAttrs, e, t);
      if (n.list.shape != null)
        return Fm(this.node.rawAttrs, e, t);
      if (n.list.b != null)
        return Om(this.node.rawAttrs, e, t);
      if (n.list.type != null)
        return Am(this.node.rawAttrs, e, t);
    }
    return t;
  }
};
var QW = (e, t, n) => {
  switch (e.op) {
    case "BiasAdd":
    case "AddV2":
    case "Add":
      return [ie(I("a", e, t, n), I("b", e, t, n))];
    case "AddN":
      return [KA(I("tensors", e, t, n))];
    case "FloorMod":
    case "Mod":
      return [kD(I("a", e, t, n), I("b", e, t, n))];
    case "Mul":
      return [V(I("a", e, t, n), I("b", e, t, n))];
    case "RealDiv":
    case "Div":
      return [xe(I("a", e, t, n), I("b", e, t, n))];
    case "DivNoNan":
      return [vR(I("a", e, t, n), I("b", e, t, n))];
    case "FloorDiv":
      return [Hk(I("a", e, t, n), I("b", e, t, n))];
    case "Sub":
      return [ge(I("a", e, t, n), I("b", e, t, n))];
    case "Minimum":
      return [bp(I("a", e, t, n), I("b", e, t, n))];
    case "Maximum":
      return [$r(I("a", e, t, n), I("b", e, t, n))];
    case "Pow":
      return [pa(I("a", e, t, n), I("b", e, t, n))];
    case "SquaredDifference":
      return [wI(I("a", e, t, n), I("b", e, t, n))];
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
var ZW = (e, t, n) => {
  switch (e.op) {
    case "Abs":
    case "ComplexAbs":
      return [Mt(I("x", e, t, n))];
    case "Acos":
      return [GA(I("x", e, t, n))];
    case "Acosh":
      return [qA(I("x", e, t, n))];
    case "Asin":
      return [tE(I("x", e, t, n))];
    case "Asinh":
      return [sE(I("x", e, t, n))];
    case "Atan":
      return [aE(I("x", e, t, n))];
    case "Atan2":
      return [oE(I("x", e, t, n), I("y", e, t, n))];
    case "Atanh":
      return [lE(I("x", e, t, n))];
    case "Ceil":
      return [ME(I("x", e, t, n))];
    case "Complex":
      return [oa(I("real", e, t, n), I("imag", e, t, n))];
    case "Cos":
      return [jg(I("x", e, t, n))];
    case "Cosh":
      return [nI(I("x", e, t, n))];
    case "Elu":
      return [fp(I("x", e, t, n))];
    case "Erf":
      return [CR(I("x", e, t, n))];
    case "Exp":
      return [Xn(I("x", e, t, n))];
    case "Expm1":
      return [_R(I("x", e, t, n))];
    case "Floor":
      return [mp(I("x", e, t, n))];
    case "Log":
      return [Yn(I("x", e, t, n))];
    case "Log1p":
      return [Yg(I("x", e, t, n))];
    case "Imag":
      return [Kg(I("x", e, t, n))];
    case "Neg":
      return [kt(I("x", e, t, n))];
    case "Reciprocal":
      return [ZD(I("x", e, t, n))];
    case "Real":
      return [wd(I("x", e, t, n))];
    case "Relu":
      return [Xs(I("x", e, t, n))];
    case "Round":
      return [fI(I("x", e, t, n))];
    case "Selu":
      return [gI(I("x", e, t, n))];
    case "Sigmoid":
      return [qs(I("x", e, t, n))];
    case "Sin":
      return [bI(I("x", e, t, n))];
    case "Sign":
      return [f3(I("x", e, t, n))];
    case "Sinh":
      return [yI(I("x", e, t, n))];
    case "Softplus":
      return [zl(I("x", e, t, n))];
    case "Sqrt":
      return [dn(I("x", e, t, n))];
    case "Square":
      return [ct(I("x", e, t, n))];
    case "Tanh":
      return [qu(I("x", e, t, n))];
    case "Tan":
      return [O3(I("x", e, t, n))];
    case "ClipByValue":
      return [Vn(I("x", e, t, n), I("clipValueMin", e, t, n), I("clipValueMax", e, t, n))];
    case "Relu6":
      return [hI(I("x", e, t, n))];
    case "Rsqrt":
      return [mI(un(e.inputNames[0], t, n))];
    case "Prod":
      return [pI(I("x", e, t, n), I("axes", e, t, n))];
    case "LeakyRelu":
      return [Xg(I("x", e, t, n), I("alpha", e, t, n))];
    case "Prelu":
      return [sb(I("x", e, t, n), I("alpha", e, t, n))];
    case "IsNan":
      return [BR(un(e.inputNames[0], t, n))];
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
function Hn(e, t, n = "") {
  if (!(typeof e == "number" || typeof t == "number")) {
    w.assert(e.length === t.length, () => n + ` Shapes ${e} and ${t} must match`);
    for (let s = 0; s < e.length; s++) {
      let r = e[s], a = t[s];
      w.assert(r < 0 || a < 0 || r === a, () => n + ` Shapes ${e} and ${t} must match`);
    }
  }
}
function Kx(e) {
  return !(typeof e == "number" || e.some((t) => t < 0));
}
function Nu(e, t, n) {
  let s = Pm(e, n), r = !Kx(s);
  if (r && t.length === 0)
    throw new Error(`Tried to calculate elements of an empty list with non-fully-defined elementShape: ${s}`);
  if (r && t.forEach((a) => {
    s = Pm(a.shape, s);
  }), !Kx(s))
    throw new Error(`Non-fully-defined elementShape: ${s}`);
  return s;
}
function Pm(e, t) {
  if (typeof e == "number")
    return t;
  if (typeof t == "number")
    return e;
  if (e.length !== t.length)
    throw new Error(`Incompatible ranks during merge: ${e} vs. ${t}`);
  let n = [];
  for (let s = 0; s < e.length; ++s) {
    let r = e[s], a = t[s];
    if (r >= 0 && a >= 0 && r !== a)
      throw new Error(`Incompatible shape during merge: ${e} vs. ${t}`);
    n[s] = r >= 0 ? r : a;
  }
  return n;
}
var JW = class {
  constructor(e, t, n, s, r, a, i) {
    this.name = e, this.dtype = t, this.maxSize = n, this.elementShape = s, this.identicalElementShapes = r, this.dynamicSize = a, this.clearAfterRead = i, this.tensors = [], this.closed_ = false, this.idTensor = we(0), Ht(this.idTensor);
  }
  get id() {
    return this.idTensor.id;
  }
  get closed() {
    return this.closed_;
  }
  clearAndClose(e) {
    this.tensors.forEach((t) => {
      (e == null || !e.has(t.tensor.id)) && t.tensor.dispose();
    }), this.tensors = [], this.closed_ = true, this.idTensor.dispose();
  }
  size() {
    return this.tensors.length;
  }
  read(e) {
    if (this.closed_)
      throw new Error(`TensorArray ${this.name} has already been closed.`);
    if (e < 0 || e >= this.size())
      throw new Error(`Tried to read from index ${e}, but array size is: ${this.size()}`);
    let t = this.tensors[e];
    if (t.cleared)
      throw new Error(`TensorArray ${this.name}: Could not read index ${e} twice because it was cleared after a previous read (perhaps try setting clear_after_read = false?).`);
    return this.clearAfterRead && (t.cleared = true), t.read = true, t.tensor;
  }
  readMany(e) {
    return e.map((t) => this.read(t));
  }
  write(e, t) {
    if (this.closed_)
      throw new Error(`TensorArray ${this.name} has already been closed.`);
    if (e < 0 || !this.dynamicSize && e >= this.maxSize)
      throw new Error(`Tried to write to index ${e}, but array is not resizeable and size is: ${this.maxSize}`);
    let n = this.tensors[e] || {};
    if (t.dtype !== this.dtype)
      throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e},
          because the value dtype is ${t.dtype}, but TensorArray dtype is ${this.dtype}.`);
    if (this.size() === 0 && (this.elementShape == null || this.elementShape.length === 0) && (this.elementShape = t.shape), Hn(this.elementShape, t.shape, `TensorArray ${this.name}: Could not write to TensorArray index ${e}.`), n.read)
      throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e}, because it has already been read.`);
    if (n.written)
      throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e}, because it has already been written.`);
    n.tensor = t, Ht(t), n.written = true, this.tensors[e] = n;
  }
  writeMany(e, t) {
    if (e.length !== t.length)
      throw new Error(`TensorArray ${this.name}: could not write multiple tensors,because the index size: ${e.length} is not the same as tensors size: ${t.length}.`);
    e.forEach((n, s) => this.write(n, t[s]));
  }
  gather(e, t) {
    if (!!t && t !== this.dtype)
      throw new Error(`TensorArray dtype is ${this.dtype} but gather requested dtype ${t}`);
    if (e)
      e = e.slice(0, this.size());
    else {
      e = [];
      for (let s = 0; s < this.size(); s++)
        e.push(s);
    }
    if (e.length === 0)
      return fs([], [0].concat(this.elementShape));
    let n = this.readMany(e);
    return Hn(this.elementShape, n[0].shape, "TensorArray shape mismatch: "), Jn(n, 0);
  }
  concat(e) {
    if (!!e && e !== this.dtype)
      throw new Error(`TensorArray dtype is ${this.dtype} but concat requested dtype ${e}`);
    if (this.size() === 0)
      return fs([], [0].concat(this.elementShape));
    let t = [];
    for (let s = 0; s < this.size(); s++)
      t.push(s);
    let n = this.readMany(t);
    return Hn(this.elementShape, n[0].shape, `TensorArray shape mismatch: tensor array shape (${this.elementShape}) vs first tensor shape (${n[0].shape})`), Ft(n, 0);
  }
  scatter(e, t) {
    if (t.dtype !== this.dtype)
      throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${t.dtype}`);
    if (e.length !== t.shape[0])
      throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${e.length} vs. ${t.shape[0]}`);
    let n = Math.max(...e);
    if (!this.dynamicSize && n >= this.maxSize)
      throw new Error(`Max index must be < array size (${n}  vs. ${this.maxSize})`);
    this.writeMany(e, Fs(t, 0));
  }
  split(e, t) {
    if (t.dtype !== this.dtype)
      throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${t.dtype}`);
    let n = 0, s = e.map((o) => (n += o, n));
    if (n !== t.shape[0])
      throw new Error(`Expected sum of lengths to be equal to
          tensor.shape[0], but sum of lengths is
        ${n}, and tensor's shape is: ${t.shape}`);
    if (!this.dynamicSize && e.length !== this.maxSize)
      throw new Error(`TensorArray's size is not equal to the size of lengths (${this.maxSize} vs. ${e.length}), and the TensorArray is not marked as dynamically resizeable`);
    let r = n === 0 ? 0 : t.size / n, a = [];
    j(() => {
      t = G(t, [1, n, r]);
      for (let o = 0; o < e.length; ++o) {
        let u = o === 0 ? 0 : s[o - 1], l = [0, u, 0], c = [1, e[o], r];
        a[o] = G(He(t, l, c), this.elementShape);
      }
      return a;
    });
    let i = [];
    for (let o = 0; o < e.length; o++)
      i[o] = o;
    this.writeMany(i, a);
  }
};
var eo = class {
  constructor(e, t, n, s = -1) {
    this.tensors = e, this.elementShape = t, this.elementDtype = n, e != null && e.forEach((r) => {
      if (n !== r.dtype)
        throw new Error(`Invalid data types; op elements ${n}, but list elements ${r.dtype}`);
      Hn(t, r.shape, "TensorList shape mismatch: "), Ht(r);
    }), this.idTensor = we(0), this.maxNumElements = s, Ht(this.idTensor);
  }
  get id() {
    return this.idTensor.id;
  }
  copy() {
    return new eo([...this.tensors], this.elementShape, this.elementDtype);
  }
  clearAndClose(e) {
    this.tensors.forEach((t) => {
      (e == null || !e.has(t.id)) && t.dispose();
    }), this.tensors.length = 0, this.idTensor.dispose();
  }
  size() {
    return this.tensors.length;
  }
  stack(e, t, n = -1) {
    if (t !== this.elementDtype)
      throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);
    if (n !== -1 && this.tensors.length !== n)
      throw new Error(`Operation expected a list with ${n} elements but got a list with ${this.tensors.length} elements.`);
    Hn(e, this.elementShape, "TensorList shape mismatch: ");
    let s = Nu(this.elementShape, this.tensors, e);
    return j(() => {
      let r = this.tensors.map((a) => G(a, s));
      return Jn(r, 0);
    });
  }
  popBack(e, t) {
    if (t !== this.elementDtype)
      throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);
    if (this.size() === 0)
      throw new Error("Trying to pop from an empty list.");
    let n = Nu(this.elementShape, this.tensors, e), s = this.tensors.pop();
    return Hn(s.shape, e, "TensorList shape mismatch: "), G(s, n);
  }
  pushBack(e) {
    if (e.dtype !== this.elementDtype)
      throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${this.elementDtype}`);
    if (Hn(e.shape, this.elementShape, "TensorList shape mismatch: "), this.maxNumElements === this.size())
      throw new Error("Trying to push element into a full list.");
    Ht(e), this.tensors.push(e);
  }
  resize(e) {
    if (e < 0)
      throw new Error(`TensorListResize expects size to be non-negative. Got: ${e}`);
    if (this.maxNumElements !== -1 && e > this.maxNumElements)
      throw new Error(`TensorListResize input size ${e} is greater maxNumElement ${this.maxNumElements}.`);
    let t = new eo([], this.elementShape, this.elementDtype, this.maxNumElements);
    t.tensors.length = e;
    for (let n = 0; n < Math.min(this.tensors.length, e); ++n)
      t.tensors[n] = this.tensors[n];
    return t;
  }
  getItem(e, t, n) {
    if (n !== this.elementDtype)
      throw new Error(`Invalid data types; op elements ${n}, but list elements ${this.elementDtype}`);
    if (e < 0 || e > this.tensors.length)
      throw new Error(`Trying to access element ${e} in a list with ${this.tensors.length} elements.`);
    if (this.tensors[e] == null)
      throw new Error(`element at index ${e} is null.`);
    Hn(this.tensors[e].shape, t, "TensorList shape mismatch: ");
    let s = Nu(this.elementShape, this.tensors, t);
    return G(this.tensors[e], s);
  }
  setItem(e, t) {
    if (t.dtype !== this.elementDtype)
      throw new Error(`Invalid data types; op elements ${t.dtype}, but list elements ${this.elementDtype}`);
    if (e < 0 || this.maxNumElements !== -1 && e >= this.maxNumElements)
      throw new Error(`Trying to set element ${e} in a list with max ${this.maxNumElements} elements.`);
    Hn(this.elementShape, t.shape, "TensorList shape mismatch: "), Ht(t), this.tensors[e] = t;
  }
  gather(e, t, n) {
    if (t !== this.elementDtype)
      throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);
    Hn(this.elementShape, n, "TensorList shape mismatch: "), e = e.slice(0, this.size());
    let s = Nu(this.elementShape, this.tensors, n);
    return e.length === 0 ? fs([], [0].concat(s)) : j(() => {
      let r = e.map((a) => G(this.tensors[a], s));
      return Jn(r, 0);
    });
  }
  concat(e, t) {
    if (!!e && e !== this.elementDtype)
      throw new Error(`TensorList dtype is ${this.elementDtype} but concat requested dtype ${e}`);
    Hn(this.elementShape, t, "TensorList shape mismatch: ");
    let n = Nu(this.elementShape, this.tensors, t);
    return this.size() === 0 ? fs([], [0].concat(n)) : j(() => {
      let s = this.tensors.map((r) => G(r, n));
      return Ft(s, 0);
    });
  }
};
function e4(e, t, n) {
  let s = e.dtype;
  if (e.shape.length < 1)
    throw new Error(`Tensor must be at least a vector, but saw shape: ${e.shape}`);
  if (e.dtype !== n)
    throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${n}`);
  let r = e.shape.slice(1);
  Hn(r, t, "TensorList shape mismatch: ");
  let a = Fs(e);
  return new eo(a, t, s);
}
function t4(e, t, n) {
  return new eo([], e, t, n);
}
function n4(e, t, n, s) {
  if (t.length !== e.shape[0])
    throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${t.length} vs. ${e.shape[0]}`);
  let r = Math.max(...t);
  if (s != null && s !== -1 && r >= s)
    throw new Error(`Max index must be < array size (${r}  vs. ${s})`);
  let a = new eo([], n, e.dtype, s), i = Fs(e, 0);
  return t.forEach((o, u) => {
    a.setItem(o, i[u]);
  }), a;
}
function s4(e, t, n) {
  let s = 0, r = t.map((c) => (s += c, s));
  if (s !== e.shape[0])
    throw new Error(`Expected sum of lengths to be equal to
          tensor.shape[0], but sum of lengths is
        ${s}, and tensor's shape is: ${e.shape}`);
  let a = e.shape.slice(1), i = Pm(a, n), o = s === 0 ? 0 : e.size / s, u = j(() => {
    let c = [];
    e = G(e, [1, s, o]);
    for (let p = 0; p < t.length; ++p) {
      let d = p === 0 ? 0 : r[p - 1], h = [0, d, 0], f = [1, t[p], o];
      c[p] = G(He(e, h, f), i);
    }
    return e.dispose(), c;
  }), l = new eo([], n, e.dtype, t.length);
  for (let c = 0; c < u.length; c++)
    l.setItem(c, u[c]);
  return l;
}
var r4 = async (e, t, n) => {
  switch (e.op) {
    case "If":
    case "StatelessIf": {
      let s = I("thenBranch", e, t, n), r = I("elseBranch", e, t, n), a = I("cond", e, t, n), i = I("args", e, t, n);
      return (await a.data())[0] ? n.functionMap[s].executeFunctionAsync(i, n.tensorArrayMap, n.tensorListMap) : n.functionMap[r].executeFunctionAsync(i, n.tensorArrayMap, n.tensorListMap);
    }
    case "While":
    case "StatelessWhile": {
      let s = I("body", e, t, n), r = I("cond", e, t, n), a = I("args", e, t, n), i = await n.functionMap[r].executeFunctionAsync(a, n.tensorArrayMap, n.tensorListMap), o = a.map((c) => c.id), u = await i[0].data();
      i.forEach((c) => {
        !c.kept && o.indexOf(c.id) === -1 && c.dispose();
      });
      let l = a;
      for (; u[0]; ) {
        let c = l;
        l = await n.functionMap[s].executeFunctionAsync(l, n.tensorArrayMap, n.tensorListMap);
        let p = l.map((h) => h.id);
        c.forEach((h) => {
          !h.kept && o.indexOf(h.id) === -1 && p.indexOf(h.id) === -1 && h.dispose();
        });
        let d = await n.functionMap[r].executeFunctionAsync(l, n.tensorArrayMap, n.tensorListMap);
        u = await d[0].data(), d.forEach((h) => {
          !h.kept && o.indexOf(h.id) === -1 && p.indexOf(h.id) === -1 && h.dispose();
        });
      }
      return l;
    }
    case "LoopCond": {
      let s = I("pred", e, t, n);
      return [Us(s)];
    }
    case "Switch": {
      let s = I("pred", e, t, n), r = I("data", e, t, n);
      return r.kept || (r = Us(r)), (await s.data())[0] ? [void 0, r] : [r, void 0];
    }
    case "Merge": {
      let s = e.inputNames.find((r) => un(r, t, n) !== void 0);
      if (s) {
        let r = un(s, t, n);
        return [Us(r)];
      }
      return;
    }
    case "Enter": {
      let s = I("frameName", e, t, n), r = I("tensor", e, t, n);
      return n.enterFrame(s), [Us(r)];
    }
    case "Exit": {
      let s = I("tensor", e, t, n);
      return n.exitFrame(), [Us(s)];
    }
    case "NextIteration": {
      let s = I("tensor", e, t, n);
      return n.nextIteration(), [Us(s)];
    }
    case "TensorArrayV3": {
      let s = I("size", e, t, n), r = I("dtype", e, t, n), a = I("elementShape", e, t, n), i = I("dynamicSize", e, t, n), o = I("clearAfterRead", e, t, n), u = I("identicalElementShapes", e, t, n), l = I("name", e, t, n), c = new JW(l, r, s, a, u, i, o);
      return n.addTensorArray(c), [c.idTensor, we(1)];
    }
    case "TensorArrayWriteV3": {
      let s = I("tensorArrayId", e, t, n), r = I("index", e, t, n), a = I("tensor", e, t, n), i = n.getTensorArray(s.id);
      return i.write(r, a), [i.idTensor];
    }
    case "TensorArrayReadV3": {
      let s = I("tensorArrayId", e, t, n), r = I("index", e, t, n);
      return [n.getTensorArray(s.id).read(r)];
    }
    case "TensorArrayGatherV3": {
      let s = I("tensorArrayId", e, t, n), r = I("indices", e, t, n), a = I("dtype", e, t, n);
      return [n.getTensorArray(s.id).gather(r, a)];
    }
    case "TensorArrayScatterV3": {
      let s = I("tensorArrayId", e, t, n), r = I("indices", e, t, n), a = I("tensor", e, t, n), i = n.getTensorArray(s.id);
      return i.scatter(r, a), [i.idTensor];
    }
    case "TensorArrayConcatV3": {
      let s = I("tensorArrayId", e, t, n), r = n.getTensorArray(s.id), a = I("dtype", e, t, n);
      return [r.concat(a)];
    }
    case "TensorArraySplitV3": {
      let s = I("tensorArrayId", e, t, n), r = I("tensor", e, t, n), a = I("lengths", e, t, n), i = n.getTensorArray(s.id);
      return i.split(a, r), [i.idTensor];
    }
    case "TensorArraySizeV3": {
      let s = I("tensorArrayId", e, t, n), r = n.getTensorArray(s.id);
      return [we(r.size(), "int32")];
    }
    case "TensorArrayCloseV3": {
      let s = I("tensorArrayId", e, t, n), r = n.getTensorArray(s.id);
      return r.clearAndClose(), [r.idTensor];
    }
    case "TensorListSetItem": {
      let s = I("tensorListId", e, t, n), r = I("index", e, t, n), a = I("tensor", e, t, n), i = n.getTensorList(s.id);
      return i.setItem(r, a), [i.idTensor];
    }
    case "TensorListGetItem": {
      let s = I("tensorListId", e, t, n), r = I("index", e, t, n), a = I("elementShape", e, t, n), i = I("elementDType", e, t, n);
      return [n.getTensorList(s.id).getItem(r, a, i)];
    }
    case "TensorListScatterV2":
    case "TensorListScatter": {
      let s = I("indices", e, t, n), r = I("tensor", e, t, n), a = I("elementShape", e, t, n), i = I("numElements", e, t, n), o = n4(r, s, a, i);
      return n.addTensorList(o), [o.idTensor];
    }
    case "TensorListReserve":
    case "EmptyTensorList": {
      let s = I("elementShape", e, t, n), r = I("elementDType", e, t, n), a;
      e.op === "TensorListReserve" ? a = "numElements" : a = "maxNumElements";
      let i = I(a, e, t, n), o = t4(s, r, i);
      return n.addTensorList(o), [o.idTensor];
    }
    case "TensorListGather": {
      let s = I("tensorListId", e, t, n), r = I("indices", e, t, n), a = I("elementShape", e, t, n), i = I("elementDType", e, t, n);
      return [n.getTensorList(s.id).gather(r, i, a)];
    }
    case "TensorListStack": {
      let s = I("tensorListId", e, t, n), r = I("elementShape", e, t, n), a = I("elementDType", e, t, n), i = I("numElements", e, t, n);
      return [n.getTensorList(s.id).stack(r, a, i)];
    }
    case "TensorListFromTensor": {
      let s = I("tensor", e, t, n), r = I("elementShape", e, t, n), a = I("elementDType", e, t, n), i = e4(s, r, a);
      return n.addTensorList(i), [i.idTensor];
    }
    case "TensorListConcat": {
      let s = I("tensorListId", e, t, n), r = n.getTensorList(s.id), a = I("dtype", e, t, n), i = I("elementShape", e, t, n);
      return [r.concat(a, i)];
    }
    case "TensorListPushBack": {
      let s = I("tensorListId", e, t, n), r = I("tensor", e, t, n), a = n.getTensorList(s.id);
      return a.pushBack(r), [a.idTensor];
    }
    case "TensorListPopBack": {
      let s = I("tensorListId", e, t, n), r = I("elementShape", e, t, n), a = I("elementDType", e, t, n);
      return [n.getTensorList(s.id).popBack(r, a)];
    }
    case "TensorListSplit": {
      let s = I("tensor", e, t, n), r = I("elementShape", e, t, n), a = I("lengths", e, t, n), i = s4(s, a, r);
      return n.addTensorList(i), [i.idTensor];
    }
    case "TensorListLength": {
      let s = I("tensorListId", e, t, n), r = n.getTensorList(s.id);
      return [we(r.size(), "int32")];
    }
    case "TensorListResize": {
      let s = I("tensorListId", e, t, n), r = I("size", e, t, n), i = n.getTensorList(s.id).resize(r);
      return n.addTensorList(i), [i.idTensor];
    }
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
function Xx(e, t, n) {
  let [s, r] = I("fusedOps", e, t, n), a = s === "biasadd", i = !a, o = r === "prelu", u = s === "fusedbatchnorm", l = I("numArgs", e, t, n);
  if (a) {
    if (o && l !== 2)
      throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd and Prelu must have two extra arguments: bias and alpha.");
    if (!o && a && l !== 1)
      throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd must have one extra argument: bias.");
  }
  if (u)
    throw new Error("FusedConv2d and DepthwiseConv2d with FusedBatchNorm is not supported");
  let c = I("strides", e, t, n), p = sd(e, t, n), d = I("dataFormat", e, t, n).toUpperCase(), h = I("dilations", e, t, n), [f, m] = I("args", e, t, n);
  i && (m = f, f = void 0);
  let g = I("leakyreluAlpha", e, t, n);
  return { stride: c, pad: p, dataFormat: d, dilations: h, biasArg: f, preluArg: m, activationFunc: r, leakyreluAlpha: g };
}
var a4 = (e, t, n) => {
  switch (e.op) {
    case "Conv1D": {
      let s = I("stride", e, t, n), r = I("pad", e, t, n), a = I("dataFormat", e, t, n).toUpperCase(), i = I("dilation", e, t, n);
      return [Zk(I("x", e, t, n), I("filter", e, t, n), s, r, a, i)];
    }
    case "Conv2D": {
      let s = I("strides", e, t, n), r = sd(e, t, n), a = I("dataFormat", e, t, n).toUpperCase(), i = I("dilations", e, t, n);
      return [ca(I("x", e, t, n), I("filter", e, t, n), [s[1], s[2]], r, a, [i[1], i[2]])];
    }
    case "_FusedConv2D": {
      let { stride: s, pad: r, dataFormat: a, dilations: i, biasArg: o, preluArg: u, activationFunc: l, leakyreluAlpha: c } = Xx(e, t, n);
      return [ha.conv2d({ x: I("x", e, t, n), filter: I("filter", e, t, n), strides: [s[1], s[2]], pad: r, dataFormat: a, dilations: [i[1], i[2]], bias: o, activation: l, preluActivationWeights: u, leakyreluAlpha: c })];
    }
    case "FusedDepthwiseConv2dNative": {
      let { stride: s, pad: r, dataFormat: a, dilations: i, biasArg: o, preluArg: u, activationFunc: l, leakyreluAlpha: c } = Xx(e, t, n);
      return [ha.depthwiseConv2d({ x: I("x", e, t, n), filter: I("filter", e, t, n), strides: [s[1], s[2]], pad: r, dataFormat: a, dilations: [i[1], i[2]], bias: o, activation: l, preluActivationWeights: u, leakyreluAlpha: c })];
    }
    case "Conv2DBackpropInput":
    case "Conv2dTranspose": {
      let s = I("outputShape", e, t, n), r = I("strides", e, t, n), a = sd(e, t, n);
      return [Jk(I("x", e, t, n), I("filter", e, t, n), s, [r[1], r[2]], a)];
    }
    case "DepthwiseConv2dNative":
    case "DepthwiseConv2d": {
      let s = I("strides", e, t, n), r = sd(e, t, n), a = I("dilations", e, t, n), i = I("dataFormat", e, t, n).toUpperCase();
      return [hp(I("input", e, t, n), I("filter", e, t, n), [s[1], s[2]], r, i, [a[1], a[2]])];
    }
    case "Conv3D": {
      let s = I("strides", e, t, n), r = I("pad", e, t, n), a = I("dataFormat", e, t, n).toUpperCase(), i = I("dilations", e, t, n);
      return [eI(I("x", e, t, n), I("filter", e, t, n), [s[1], s[2], s[3]], r, a, [i[1], i[2], i[3]])];
    }
    case "AvgPool": {
      let s = I("strides", e, t, n), r = I("pad", e, t, n), a = I("kernelSize", e, t, n);
      return [Gg(I("x", e, t, n), [a[1], a[2]], [s[1], s[2]], r)];
    }
    case "MaxPool": {
      let s = I("strides", e, t, n), r = I("pad", e, t, n), a = I("kernelSize", e, t, n);
      return [eb(I("x", e, t, n), [a[1], a[2]], [s[1], s[2]], r)];
    }
    case "MaxPoolWithArgmax": {
      let s = I("strides", e, t, n), r = I("pad", e, t, n), a = I("kernelSize", e, t, n), i = I("includeBatchInIndex", e, t, n), { result: o, indexes: u } = fD(I("x", e, t, n), [a[1], a[2]], [s[1], s[2]], r, i);
      return [o, u];
    }
    case "AvgPool3D": {
      let s = I("strides", e, t, n), r = I("pad", e, t, n), a = I("kernelSize", e, t, n);
      return [Yk(I("x", e, t, n), [a[1], a[2], a[3]], [s[1], s[2], s[3]], r)];
    }
    case "MaxPool3D": {
      let s = I("strides", e, t, n), r = I("pad", e, t, n), a = I("kernelSize", e, t, n);
      return [dI(I("x", e, t, n), [a[1], a[2], a[3]], [s[1], s[2], s[3]], r)];
    }
    case "Dilation2D": {
      let s = I("strides", e, t, n), r = I("pad", e, t, n), a = I("dilations", e, t, n), i = s[1], o = s[2], u = a[1], l = a[2];
      return [fR(I("x", e, t, n), I("filter", e, t, n), [i, o], r, [u, l], "NHWC")];
    }
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
var i4 = (e, t, n) => {
  switch (e.op) {
    case "Fill": {
      let s = I("shape", e, t, n), r = I("dtype", e, t, n), a = I("value", e, t, n);
      return [Pl(s, a, r)];
    }
    case "LinSpace": {
      let s = I("start", e, t, n), r = I("stop", e, t, n), a = I("num", e, t, n);
      return [GR(s, r, a)];
    }
    case "Multinomial": {
      let s = I("logits", e, t, n), r = I("numSamples", e, t, n), a = I("seed", e, t, n);
      return [TD(s, r, a)];
    }
    case "OneHot": {
      let s = I("indices", e, t, n), r = I("depth", e, t, n), a = I("onValue", e, t, n), i = I("offValue", e, t, n);
      return [vd(s, r, a, i)];
    }
    case "Ones":
      return [Mn(I("shape", e, t, n), I("dtype", e, t, n))];
    case "OnesLike":
      return [Qn(I("x", e, t, n))];
    case "RandomUniform":
      return [Ml(I("shape", e, t, n), I("minval", e, t, n), I("maxval", e, t, n), I("dtype", e, t, n))];
    case "Range": {
      let s = I("start", e, t, n), r = I("stop", e, t, n), a = I("step", e, t, n);
      return [Yu(s, r, a, I("dtype", e, t, n))];
    }
    case "TruncatedNormal": {
      let s = I("shape", e, t, n), r = I("mean", e, t, n), a = I("stdDev", e, t, n), i = I("seed", e, t, n);
      return [db(s, r, a, I("dtype", e, t, n), i)];
    }
    case "Zeros":
      return [$t(I("shape", e, t, n), I("dtype", e, t, n))];
    case "ZerosLike":
      return [je(I("x", e, t, n))];
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
function Hf(e, t, n) {
  let s = I("boxes", e, t, n), r = I("scores", e, t, n), a = I("maxOutputSize", e, t, n), i = I("iouThreshold", e, t, n), o = I("scoreThreshold", e, t, n), u = I("softNmsSigma", e, t, n);
  return { boxes: s, scores: r, maxOutputSize: a, iouThreshold: i, scoreThreshold: o, softNmsSigma: u };
}
var o4 = async (e, t, n) => {
  switch (e.op) {
    case "NonMaxSuppressionV5": {
      let { boxes: s, scores: r, maxOutputSize: a, iouThreshold: i, scoreThreshold: o, softNmsSigma: u } = Hf(e, t, n), l = await qn.nonMaxSuppressionWithScoreAsync(s, r, a, i, o, u);
      return [l.selectedIndices, l.selectedScores];
    }
    case "NonMaxSuppressionV4": {
      let { boxes: s, scores: r, maxOutputSize: a, iouThreshold: i, scoreThreshold: o } = Hf(e, t, n), u = I("padToMaxOutputSize", e, t, n), l = await qn.nonMaxSuppressionPaddedAsync(s, r, a, i, o, u);
      return [l.selectedIndices, l.validOutputs];
    }
    case "NonMaxSuppressionV3":
    case "NonMaxSuppressionV2": {
      let { boxes: s, scores: r, maxOutputSize: a, iouThreshold: i, scoreThreshold: o } = Hf(e, t, n);
      return [await qn.nonMaxSuppressionAsync(s, r, a, i, o)];
    }
    case "Where": {
      let s = ce(I("condition", e, t, n), "bool"), r = [await II(s)];
      return s.dispose(), r;
    }
    case "ListDiff":
      return p3(I("x", e, t, n), I("y", e, t, n));
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
var u4 = (e, t, n) => {
  switch (e.op) {
    case "TopKV2": {
      let s = I("x", e, t, n), r = I("k", e, t, n), a = I("sorted", e, t, n), i = z3(s, r, a);
      return [i.values, i.indices];
    }
    case "Unique": {
      let s = I("x", e, t, n), r = hx(s);
      return [r.values, r.indices];
    }
    case "UniqueV2": {
      let s = I("x", e, t, n), r = I("axis", e, t, n), a = hx(s, r);
      return [a.values, a.indices];
    }
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
var l4 = (e, t, n) => {
  switch (e.op) {
    case "Const":
      return t[e.name];
    case "PlaceholderWithDefault":
      let s = I("default", e, t, n);
      return [un(e.name, t, n) || s];
    case "Placeholder":
      return [un(e.name, t, n)];
    case "Identity":
    case "StopGradient":
    case "FakeQuantWithMinMaxVars": {
      let l = I("x", e, t, n);
      return [Us(l)];
    }
    case "IdentityN":
      return I("x", e, t, n).map((l) => Us(l));
    case "Snapshot":
      let r = I("x", e, t, n);
      return [Us(r)];
    case "Shape":
      return [Zt(I("x", e, t, n).shape, "int32")];
    case "ShapeN":
      return I("x", e, t, n).map((l) => Zt(l.shape));
    case "Size":
      return [we(I("x", e, t, n).size, "int32")];
    case "Rank":
      return [we(I("x", e, t, n).rank, "int32")];
    case "NoOp":
      return [we(1)];
    case "Print":
      let a = I("x", e, t, n), i = I("data", e, t, n), o = I("message", e, t, n), u = I("summarize", e, t, n);
      console.warn("The graph has a tf.print() operation,usually used for debugging, which slows down performance."), console.log(o);
      for (let l = 0; l < i.length; l++)
        console.log(Array.prototype.slice.call(i[l].dataSync()).slice(0, u));
      return [a];
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
var c4 = class {
  constructor(e, t) {
    this.keyDType = e, this.valueDType = t, this.handle = we(0), this.tensorMap = /* @__PURE__ */ new Map(), Ht(this.handle);
  }
  get id() {
    return this.handle.id;
  }
  clearAndClose() {
    this.tensorMap.forEach((e) => e.dispose()), this.tensorMap.clear(), this.handle.dispose();
  }
  size() {
    return this.tensorMap.size;
  }
  tensorSize() {
    return we(this.size(), "int32");
  }
  async import(e, t) {
    this.checkKeyAndValueTensor(e, t);
    let n = await e.data();
    return this.tensorMap.forEach((s) => s.dispose()), this.tensorMap.clear(), j(() => {
      let s = Fs(t), r = n.length, a = s.length;
      w.assert(r === a, () => `The number of elements doesn't match, keys has ${r} elements, the values has ${a} elements.`);
      for (let i = 0; i < r; i++) {
        let o = n[i], u = s[i];
        Ht(u), this.tensorMap.set(o, u);
      }
      return this.handle;
    });
  }
  async find(e, t) {
    this.checkKeyAndValueTensor(e, t);
    let n = await e.data();
    return j(() => {
      let s = [];
      for (let r = 0; r < n.length; r++) {
        let a = n[r], i = this.findWithDefault(a, t);
        s.push(i);
      }
      return Jn(s);
    });
  }
  findWithDefault(e, t) {
    let n = this.tensorMap.get(e);
    return n != null ? n : t;
  }
  checkKeyAndValueTensor(e, t) {
    if (e.dtype !== this.keyDType)
      throw new Error(`Expect key dtype ${this.keyDType}, but got ${e.dtype}`);
    if (t.dtype !== this.valueDType)
      throw new Error(`Expect value dtype ${this.valueDType}, but got ${t.dtype}`);
  }
};
var d4 = async (e, t, n, s) => {
  switch (e.op) {
    case "HashTable":
    case "HashTableV2": {
      let r = I("keyDType", e, t, n), a = I("valueDType", e, t, n), i = new c4(r, a);
      return s.addHashTable(e.name, i), [i.handle];
    }
    case "LookupTableImport":
    case "LookupTableImportV2": {
      let r = I("tableHandle", e, t, n, s), a = I("keys", e, t, n), i = I("values", e, t, n);
      return [await s.getHashTableById(r.id).import(a, i)];
    }
    case "LookupTableFind":
    case "LookupTableFindV2": {
      let r = I("tableHandle", e, t, n, s), a = I("keys", e, t, n), i = I("defaultValue", e, t, n);
      return [await s.getHashTableById(r.id).find(a, i)];
    }
    case "LookupTableSize":
    case "LookupTableSizeV2": {
      let r = I("tableHandle", e, t, n, s);
      return [s.getHashTableById(r.id).tensorSize()];
    }
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
var p4 = (e, t, n) => {
  switch (e.op) {
    case "ResizeBilinear": {
      let s = I("images", e, t, n), r = I("size", e, t, n), a = I("alignCorners", e, t, n), i = I("halfPixelCenters", e, t, n);
      return [qn.resizeBilinear(s, [r[0], r[1]], a, i)];
    }
    case "ResizeNearestNeighbor": {
      let s = I("images", e, t, n), r = I("size", e, t, n), a = I("alignCorners", e, t, n), i = I("halfPixelCenters", e, t, n);
      return [qn.resizeNearestNeighbor(s, [r[0], r[1]], a, i)];
    }
    case "CropAndResize": {
      let s = I("image", e, t, n), r = I("boxes", e, t, n), a = I("boxInd", e, t, n), i = I("cropSize", e, t, n), o = I("method", e, t, n), u = I("extrapolationValue", e, t, n);
      return [qn.cropAndResize(s, r, a, i, o, u)];
    }
    case "ImageProjectiveTransformV3": {
      let s = I("images", e, t, n), r = I("transforms", e, t, n), a = I("outputShape", e, t, n), i = I("fillValue", e, t, n), o = I("interpolation", e, t, n), u = I("fillMode", e, t, n);
      return [qn.transform(s, r, o.toLowerCase(), u.toLowerCase(), i, a)];
    }
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
var h4 = (e, t, n) => {
  switch (e.op) {
    case "Equal":
      return [Kn(I("a", e, t, n), I("b", e, t, n))];
    case "NotEqual":
      return [Xu(I("a", e, t, n), I("b", e, t, n))];
    case "Greater":
      return [Wn(I("a", e, t, n), I("b", e, t, n))];
    case "GreaterEqual":
      return [Ko(I("a", e, t, n), I("b", e, t, n))];
    case "Less":
      return [aI(I("a", e, t, n), I("b", e, t, n))];
    case "LessEqual":
      return [Xo(I("a", e, t, n), I("b", e, t, n))];
    case "LogicalAnd":
      return [Ds(I("a", e, t, n), I("b", e, t, n))];
    case "LogicalNot":
      return [Jg(I("a", e, t, n))];
    case "LogicalOr":
      return [cI(I("a", e, t, n), I("b", e, t, n))];
    case "Select":
    case "SelectV2":
      return [vn(I("condition", e, t, n), I("a", e, t, n), I("b", e, t, n))];
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
var f4 = (e, t, n) => {
  switch (e.op) {
    case "BatchMatMul":
    case "BatchMatMulV2":
    case "MatMul":
      return [We(I("a", e, t, n), I("b", e, t, n), I("transposeA", e, t, n), I("transposeB", e, t, n))];
    case "Einsum":
      return [kR(I("equation", e, t, n), ...I("tensors", e, t, n))];
    case "Transpose":
      return [qe(I("x", e, t, n), I("perm", e, t, n))];
    case "_FusedMatMul":
      let [s, r] = I("fusedOps", e, t, n), a = s === "biasadd", i = r === "prelu", o = I("numArgs", e, t, n), u = I("leakyreluAlpha", e, t, n);
      if (a) {
        if (i && o !== 2)
          throw new Error("Fused MatMul with BiasAdd and Prelu must have two extra arguments: bias and alpha.");
        if (!i && o !== 1)
          throw new Error("Fused MatMul with BiasAdd must have one extra argument: bias.");
      }
      let [l, c] = I("args", e, t, n);
      return [ha.matMul({ a: I("a", e, t, n), b: I("b", e, t, n), transposeA: I("transposeA", e, t, n), transposeB: I("transposeB", e, t, n), bias: l, activation: r, preluActivationWeights: c, leakyreluAlpha: u })];
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
var m4 = (e, t, n) => {
  switch (e.op) {
    case "FusedBatchNorm":
    case "FusedBatchNormV2":
      return [ju(I("x", e, t, n), I("mean", e, t, n), I("variance", e, t, n), I("offset", e, t, n), I("scale", e, t, n), I("epsilon", e, t, n))];
    case "FusedBatchNormV3":
      return [ju(I("x", e, t, n), I("mean", e, t, n), I("variance", e, t, n), I("offset", e, t, n), I("scale", e, t, n), I("epsilon", e, t, n))];
    case "LRN":
      return [qR(I("x", e, t, n), I("radius", e, t, n), I("bias", e, t, n), I("alpha", e, t, n), I("beta", e, t, n))];
    case "Softmax":
      return [ub(I("x", e, t, n))];
    case "LogSoftmax":
      return [iI(I("x", e, t, n))];
    case "SparseToDense":
      return [NI(I("sparseIndices", e, t, n), I("outputShape", e, t, n), I("sparseValues", e, t, n), I("defaultValue", e, t, n))];
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
var g4 = (e, t, n) => {
  switch (e.op) {
    case "Max": {
      let i = I("axis", e, t, n), o = I("keepDims", e, t, n);
      return [As(I("x", e, t, n), i, o)];
    }
    case "Mean": {
      let i = I("axis", e, t, n), o = I("keepDims", e, t, n);
      return [St(I("x", e, t, n), i, o)];
    }
    case "Min": {
      let i = I("axis", e, t, n), o = I("keepDims", e, t, n);
      return [fm(I("x", e, t, n), i, o)];
    }
    case "Sum": {
      let i = I("axis", e, t, n), o = I("keepDims", e, t, n);
      return [ve(I("x", e, t, n), i, o)];
    }
    case "All": {
      let i = I("axis", e, t, n), o = I("keepDims", e, t, n);
      return [qk(I("x", e, t, n), i, o)];
    }
    case "Any": {
      let i = I("axis", e, t, n), o = I("keepDims", e, t, n);
      return [pm(I("x", e, t, n), i, o)];
    }
    case "ArgMax": {
      let i = I("axis", e, t, n);
      return [Hu(I("x", e, t, n), i)];
    }
    case "ArgMin": {
      let i = I("axis", e, t, n);
      return [JA(I("x", e, t, n), i)];
    }
    case "Prod": {
      let i = I("axis", e, t, n), o = I("keepDims", e, t, n);
      return [pI(I("x", e, t, n), i, o)];
    }
    case "Cumprod": {
      let i = I("axis", e, t, n), o = I("exclusive", e, t, n), u = I("reverse", e, t, n);
      return [aR(I("x", e, t, n), i, o, u)];
    }
    case "Cumsum": {
      let i = I("axis", e, t, n), o = I("exclusive", e, t, n), u = I("reverse", e, t, n);
      return [sI(I("x", e, t, n), i, o, u)];
    }
    case "Bincount":
      let s = I("x", e, t, n), r = I("weights", e, t, n), a = I("size", e, t, n);
      return [Qk(s, r, a)];
    case "DenseBincount": {
      let i = I("x", e, t, n), o = I("weights", e, t, n), u = I("size", e, t, n), l = I("binaryOutput", e, t, n);
      return [uR(i, o, u, l)];
    }
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
var b4 = (e, t, n) => {
  switch (e.op) {
    case "ConcatV2":
    case "Concat": {
      let s = I("n", e, t, n), r = I("axis", e, t, n), a = I("tensors", e, t, n);
      return a = a.slice(0, s), [Ft(a, r)];
    }
    case "Gather": {
      let s = I("x", e, t, n), r = I("indices", e, t, n);
      return [Ku(s, ce(r, "int32"), 0)];
    }
    case "GatherV2": {
      let s = I("axis", e, t, n), r = I("batchDims", e, t, n), a = I("x", e, t, n), i = I("indices", e, t, n);
      return [Ku(a, ce(i, "int32"), s, r)];
    }
    case "Reverse": {
      let s = I("dims", e, t, n), r = [];
      for (let i = 0; i < s.length; i++)
        s[i] && r.push(i);
      let a = I("x", e, t, n);
      return [Zn(a, r)];
    }
    case "ReverseV2": {
      let s = I("axis", e, t, n), r = I("x", e, t, n);
      return [Zn(r, s)];
    }
    case "Slice": {
      let s = I("begin", e, t, n), r = I("size", e, t, n);
      return [He(I("x", e, t, n), s, r)];
    }
    case "StridedSlice": {
      let s = I("begin", e, t, n), r = I("end", e, t, n), a = I("strides", e, t, n), i = I("beginMask", e, t, n), o = I("endMask", e, t, n), u = I("ellipsisMask", e, t, n), l = I("newAxisMask", e, t, n), c = I("shrinkAxisMask", e, t, n), p = I("x", e, t, n);
      return [D3(p, s, r, a, i, o, u, l, c)];
    }
    case "Pack":
      return j(() => {
        let s = I("axis", e, t, n), r = I("tensors", e, t, n), a = r[0].shape, i = mr(r[0]).shape, o = r.map((u) => {
          let l = w.arraysEqual(u.shape, a);
          if (!l && !w.arraysEqual(mr(u).shape, i))
            throw new Error("the input tensors shape does not match");
          return l ? u : G(u, a);
        });
        return [Jn(o, s)];
      });
    case "Unpack": {
      let s = I("axis", e, t, n), r = I("tensor", e, t, n);
      return Fs(r, s);
    }
    case "Tile": {
      let s = I("reps", e, t, n);
      return [ps(I("x", e, t, n), s)];
    }
    case "Split":
    case "SplitV": {
      let s = I("axis", e, t, n), r = I("numOrSizeSplits", e, t, n), a = I("x", e, t, n);
      return Bn(a, r, s);
    }
    case "ScatterNd": {
      let s = I("indices", e, t, n), r = I("values", e, t, n), a = I("shape", e, t, n);
      return [X3(s, r, a)];
    }
    case "GatherNd": {
      let s = I("x", e, t, n), r = I("indices", e, t, n);
      return [J3(s, r)];
    }
    case "SparseToDense": {
      let s = I("sparseIndices", e, t, n), r = I("outputShape", e, t, n), a = I("sparseValues", e, t, n), i = I("defaultValue", e, t, n);
      return [NI(s, a, r, a.dtype === i.dtype ? i : ce(i, a.dtype))];
    }
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
var y4 = (e, t, n) => {
  switch (e.op) {
    case "SparseFillEmptyRows": {
      let { outputIndices: s, outputValues: r, emptyRowIndicator: a, reverseIndexMap: i } = Wc.sparseFillEmptyRows(I("indices", e, t, n), I("values", e, t, n), I("denseShape", e, t, n), I("defaultValue", e, t, n));
      return [s, r, a, i];
    }
    case "SparseReshape": {
      let { outputIndices: s, outputShape: r } = Wc.sparseReshape(I("inputIndices", e, t, n), I("inputShape", e, t, n), I("newShape", e, t, n));
      return [s, r];
    }
    case "SparseSegmentMean":
      return [Wc.sparseSegmentMean(I("data", e, t, n), I("indices", e, t, n), I("segmentIds", e, t, n))];
    case "SparseSegmentSum":
      return [Wc.sparseSegmentSum(I("data", e, t, n), I("indices", e, t, n), I("segmentIds", e, t, n))];
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
var v4 = (e, t, n) => {
  switch (e.op) {
    case "FFT":
      return [lb(I("x", e, t, n))];
    case "IFFT":
      return [Id(I("x", e, t, n))];
    case "RFFT":
      return [cb(I("x", e, t, n))];
    case "IRFFT":
      return [xI(I("x", e, t, n))];
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
var x4 = (e, t, n) => {
  switch (e.op) {
    case "StringNGrams": {
      let { nGrams: s, nGramsSplits: r } = Mf.stringNGrams(I("data", e, t, n), I("dataSplits", e, t, n), I("separator", e, t, n), I("nGramWidths", e, t, n), I("leftPad", e, t, n), I("rightPad", e, t, n), I("padWidth", e, t, n), I("preserveShortSequences", e, t, n));
      return [s, r];
    }
    case "StringSplit": {
      let { indices: s, values: r, shape: a } = Mf.stringSplit(I("input", e, t, n), I("delimiter", e, t, n), I("skipEmpty", e, t, n));
      return [s, r, a];
    }
    case "StringToHashBucketFast":
      return [Mf.stringToHashBucketFast(I("input", e, t, n), I("numBuckets", e, t, n))];
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
var w4 = (e, t, n) => {
  switch (e.op) {
    case "Cast":
      return [ce(I("x", e, t, n), I("dtype", e, t, n))];
    case "ExpandDims": {
      let s = I("axis", e, t, n);
      return [Pn(I("x", e, t, n), s)];
    }
    case "Squeeze": {
      let s = I("axis", e, t, n);
      return [mr(I("x", e, t, n), s)];
    }
    case "Reshape":
      return [G(I("x", e, t, n), I("shape", e, t, n))];
    case "MirrorPad":
      return [xD(I("x", e, t, n), I("padding", e, t, n), I("mode", e, t, n))];
    case "PadV2":
    case "Pad":
      return [fi(I("x", e, t, n), I("padding", e, t, n), I("constantValue", e, t, n))];
    case "SpaceToBatchND": {
      let s = I("blockShape", e, t, n), r = I("paddings", e, t, n);
      return [nb(I("x", e, t, n), s, r)];
    }
    case "BatchToSpaceND": {
      let s = I("blockShape", e, t, n), r = I("crops", e, t, n);
      return [Hg(I("x", e, t, n), s, r)];
    }
    case "DepthToSpace": {
      let s = I("blockSize", e, t, n), r = I("dataFormat", e, t, n).toUpperCase();
      return [cR(I("x", e, t, n), s, r)];
    }
    case "BroadcastTo":
      return [nd(I("x", e, t, n), I("shape", e, t, n))];
    case "BroadcastArgs":
      return [OE(I("s0", e, t, n), I("s1", e, t, n))];
    default:
      throw TypeError(`Node type ${e.op} is not implemented`);
  }
};
function Yx(e, t, n, s) {
  let r = ((a, i, o) => {
    switch (a.category) {
      case "arithmetic":
        return j(() => QW(a, i, o));
      case "basic_math":
        return j(() => ZW(a, i, o));
      case "control":
        return r4(a, i, o);
      case "convolution":
        return j(() => a4(a, i, o));
      case "creation":
        return j(() => i4(a, i, o));
      case "dynamic":
        return o4(a, i, o);
      case "evaluation":
        return j(() => u4(a, i, o));
      case "image":
        return j(() => p4(a, i, o));
      case "graph":
        return j(() => l4(a, i, o));
      case "logical":
        return j(() => h4(a, i, o));
      case "matrices":
        return j(() => f4(a, i, o));
      case "normalization":
        return j(() => m4(a, i, o));
      case "reduction":
        return j(() => g4(a, i, o));
      case "slice_join":
        return j(() => b4(a, i, o));
      case "sparse":
        return j(() => y4(a, i, o));
      case "spectral":
        return j(() => v4(a, i, o));
      case "string":
        return j(() => x4(a, i, o));
      case "transformation":
        return j(() => w4(a, i, o));
      case "hash_table":
        return d4(a, i, o, s);
      case "custom":
        let u = XS(a.op);
        if (u && u.customExecutor)
          return u.customExecutor(new YW(a, i, o));
        throw TypeError(`Custom op ${a.op} is not registered.`);
      default:
        throw TypeError(`Unknown op '${a.op}'. File an issue at https://github.com/tensorflow/tfjs/issues so we can add it, or register a custom execution with tf.registerOp()`);
    }
  })(e, t, n);
  return w.isPromise(r) ? r.then((a) => [].concat(a)) : [].concat(r);
}
var Qx = class {
  constructor(e = {}, t = {}, n = {}, s = {}) {
    this.weightMap = e, this.tensorArrayMap = t, this.tensorListMap = n, this.functionMap = s, this.rootContext = { id: 0, frameName: "", iterationId: 0 }, this.contexts = [this.rootContext], this.lastId = 0, this.generateCurrentContextIds();
  }
  newFrame(e, t) {
    return { id: e, frameName: t, iterationId: 0 };
  }
  set currentContext(e) {
    this.contexts !== e && (this.contexts = e, this.generateCurrentContextIds());
  }
  get currentContext() {
    return this.contexts;
  }
  get currentContextId() {
    return this._currentContextIds[0];
  }
  get currentContextIds() {
    return this._currentContextIds;
  }
  generateCurrentContextIds() {
    let e = [];
    for (let t = 0; t < this.contexts.length - 1; t++) {
      let n = this.contexts.slice(0, this.contexts.length - t);
      e.push(this.contextIdforContexts(n));
    }
    e.push(""), this._currentContextIds = e;
  }
  contextIdforContexts(e) {
    return e ? e.map((t) => t.id === 0 && t.iterationId === 0 ? "" : `${t.frameName}-${t.iterationId}`).join("/") : "";
  }
  enterFrame(e) {
    this.contexts && (this.lastId++, this.contexts = this.contexts.slice(), this.contexts.push(this.newFrame(this.lastId, e)), this._currentContextIds.unshift(this.contextIdforContexts(this.contexts)));
  }
  exitFrame() {
    if (this.contexts && this.contexts.length > 1)
      this.contexts = this.contexts.slice(), this.contexts.splice(-1), this.currentContextIds.shift();
    else
      throw new Error("Cannot exit frame, the context is empty");
  }
  nextIteration() {
    if (this.contexts && this.contexts.length > 0) {
      this.contexts = this.contexts.slice(), this.lastId++;
      let e = Object.assign({}, this.contexts[this.contexts.length - 1]);
      e.iterationId += 1, e.id = this.lastId, this.contexts.splice(-1, 1, e), this._currentContextIds.splice(0, 1, this.contextIdforContexts(this.contexts));
    } else
      throw new Error("Cannot increase frame iteration, the context is empty");
  }
  getWeight(e) {
    return this.weightMap[e];
  }
  addTensorArray(e) {
    this.tensorArrayMap[e.id] = e;
  }
  getTensorArray(e) {
    return this.tensorArrayMap[e];
  }
  addTensorList(e) {
    this.tensorListMap[e.id] = e;
  }
  getTensorList(e) {
    return this.tensorListMap[e];
  }
  dispose(e) {
    for (let t in this.tensorArrayMap)
      this.tensorArrayMap[t].clearAndClose(e);
    for (let t in this.tensorListMap)
      this.tensorListMap[t].clearAndClose(e);
  }
};
function Zx(e, t, n, s) {
  let r = /* @__PURE__ */ new Set(), a = [], i = null, o = null, u = /* @__PURE__ */ new Set(), l = Object.keys(e).map((d) => An(d)[0]), c = [];
  s != null && (c = s.map((d) => An(d.name)[0]));
  let p = [...t];
  for (; p.length > 0; ) {
    let d = p.pop();
    if ((b0(d) || N4(d) || T4(d)) && i == null && (i = d, o = i.children.map((h) => h.name).filter((h) => r.has(h))), r.add(d.name), n[d.name] == null && l.indexOf(d.name) === -1 && c.indexOf(d.name) === -1) {
      if (d.inputs.length === 0) {
        a.push(d.name);
        continue;
      }
      d.inputs.forEach((h) => {
        u.has(h.name) || (u.add(h.name), p.push(h));
      });
    }
  }
  return { inputs: e, outputs: t, usedNodes: r, missingInputs: a, dynamicNode: i, syncInputs: o };
}
function k4(e, t, n) {
  let { usedNodes: s, inputs: r } = n, a = [], i = Object.keys(r).map((c) => An(c)[0]).map((c) => e.nodes[c]), o = e.initNodes;
  i.forEach((c) => {
    s.has(c.name) && a.push(c);
  }), e.weights.forEach((c) => {
    s.has(c.name) && a.push(c);
  }), o != null && o.forEach((c) => {
    s.has(c.name) && a.push(c);
  });
  let u = /* @__PURE__ */ new Set(), l = [];
  for (; a.length > 0; ) {
    let c = a.pop();
    u.add(c.name), t[c.name] || l.push(c), c.children.forEach((p) => {
      !u.has(p.name) && s.has(p.name) && p.inputs.every((d) => u.has(d.name)) && a.push(p);
    });
  }
  return l;
}
var I4 = ["Switch", "Merge", "Enter", "Exit", "NextIteration", "StatelessIf", "StatelessWhile", "if", "While"];
var S4 = ["NonMaxSuppressionV2", "NonMaxSuppressionV3", "NonMaxSuppressionV5", "Where"];
var C4 = ["HashTable", "HashTableV2", "LookupTableImport", "LookupTableImportV2", "LookupTableFind", "LookupTableFindV2", "LookupTableSize", "LookupTableSizeV2"];
function b0(e) {
  return I4.indexOf(e.op) >= 0;
}
function N4(e) {
  return S4.indexOf(e.op) >= 0;
}
function T4(e) {
  return C4.indexOf(e.op) >= 0;
}
var zm = class {
  constructor(e, t) {
    this.graph = e, this.parent = t, this.compiledMap = /* @__PURE__ */ new Map(), this._weightMap = {}, this.SEPERATOR = ",", this._functions = {}, this._functionExecutorMap = {}, this.intermediateTensors = {}, this.keepTensorForDebug = false, this._outputs = e.outputs, this._inputs = e.inputs, this._initNodes = e.initNodes, this._signature = e.signature, this._functions = e.functions, e.functions != null && Object.keys(e.functions).forEach((n) => {
      this._functionExecutorMap[n] = new zm(e.functions[n], this);
    });
  }
  get weightIds() {
    return this.parent ? this.parent.weightIds : this._weightIds;
  }
  get functionExecutorMap() {
    return this.parent ? this.parent.functionExecutorMap : this._functionExecutorMap;
  }
  get weightMap() {
    return this.parent ? this.parent.weightMap : this._weightMap;
  }
  set weightMap(e) {
    let t = Object.keys(e).map((n) => e[n].map((s) => s.id));
    this._weightIds = [].concat(...t), this._weightMap = e;
  }
  set resourceManager(e) {
    this._resourceManager = e;
  }
  get inputs() {
    return this._inputs.map((e) => ({ name: e.name, shape: e.attrParams.shape ? e.attrParams.shape.value : void 0, dtype: e.attrParams.dtype ? e.attrParams.dtype.value : void 0 }));
  }
  get outputs() {
    return this._outputs.map((e) => ({ name: e.name, shape: e.attrParams.shape ? e.attrParams.shape.value : void 0, dtype: e.attrParams.dtype ? e.attrParams.dtype.value : void 0 }));
  }
  get inputNodes() {
    return this._inputs.map((e) => e.signatureKey || e.name);
  }
  get outputNodes() {
    return this._outputs.map((e) => {
      let t = e.signatureKey || e.name;
      return e.defaultOutput ? `${t}:${e.defaultOutput}` : t;
    });
  }
  get functions() {
    return Object.keys(this._functions).reduce((e, t) => (e[t] = this._functions[t].signature, e), {});
  }
  getCompilationKey(e, t) {
    let n = e.map((r) => r.name).sort(), s = t.map((r) => r.name).sort();
    return n.join(this.SEPERATOR) + "--" + s.join(this.SEPERATOR);
  }
  compile(e, t) {
    let n = Zx(e, t, this.weightMap, this._initNodes), { missingInputs: s, dynamicNode: r, syncInputs: a } = n;
    if (r != null)
      throw new Error(`This execution contains the node '${r.name}', which has the dynamic op '${r.op}'. Please use model.executeAsync() instead. Alternatively, to avoid the dynamic ops, specify the inputs [${a}]`);
    if (s.length > 0) {
      let i = t.map((u) => u.name), o = Object.keys(e);
      throw new Error(`Cannot compute the outputs [${i}] from the provided inputs [${o}]. Missing the following inputs: [${s}]`);
    }
    return k4(this.graph, this.weightMap, n);
  }
  execute(e, t) {
    e = this.mapInputs(e);
    let n = Object.keys(e).sort();
    this.checkInputs(e), this.checkInputShapeAndType(e), t = this.mapOutputs(t), this.checkOutputs(t);
    let s = n.map((c) => this.graph.nodes[An(c)[0]]), r = t.map((c) => An(c)[0]), a = r.map((c) => this.graph.nodes[c]);
    this.resetIntermediateTensors(), a.length === 0 && (a = this._outputs);
    let i = this.getCompilationKey(s, a), o = this.compiledMap.get(i);
    o == null && (o = this.compile(e, a), this.compiledMap.set(i, o));
    let u = {}, l = {};
    return j(() => {
      let c = new Qx(this.weightMap, u, l, this.functionExecutorMap), p = { ...this.weightMap };
      Object.keys(e).forEach((f) => {
        let [m, g] = An(f), b = [];
        b[g] = e[f], p[m] = b;
      });
      let d = this.getFrozenTensorIds(p), h = {};
      for (let f = 0; f < o.length; f++) {
        let m = o[f];
        if (!p[m.name]) {
          let g = Yx(m, p, c, this._resourceManager);
          if (w.isPromise(g))
            throw new Error(`The execution of the op '${m.op}' returned a promise. Please use model.executeAsync() instead.`);
          p[m.name] = g, this.checkTensorForDisposal(m.name, m, p, c, d, r, h);
        }
      }
      return this.parent == null && c.dispose(d), t.map((f) => un(f, p, c));
    });
  }
  getFrozenTensorIds(e) {
    let t = [].concat.apply([], Object.keys(e).map((n) => e[n]).map((n) => n.map((s) => s.id)));
    return new Set(t);
  }
  checkTensorForDisposal(e, t, n, s, r, a, i) {
    t.category === "control" || a.indexOf(e) !== -1 || (n[e].forEach((o) => {
      o != null && (i[o.id] = (i[o.id] || 0) + t.children.length);
    }), t.inputs.forEach((o) => {
      if (o.category !== "control") {
        let u = _W(o.name, n, s);
        u != null && u.forEach((l) => {
          if (l && !l.kept && !r.has(l.id)) {
            let c = i[l.id];
            if (c === 1) {
              if (!this.keepTensorForDebug)
                l.dispose();
              else {
                let [p, d] = Ts(t.name, s);
                this.intermediateTensors[p] ? this.intermediateTensors[p][d] = l : (this.intermediateTensors[p] = [], this.intermediateTensors[p][d] = l);
              }
              delete i[l.id];
            } else
              c != null && i[l.id]--;
          }
        });
      }
    }));
  }
  async executeAsync(e, t) {
    return this._executeAsync(e, t);
  }
  disposeIntermediateTensors() {
    !this.intermediateTensors || (Object.keys(this.intermediateTensors).forEach((e) => this.intermediateTensors[e].forEach((t) => t.dispose())), this.disposeTensorsMap());
  }
  disposeTensorsMap() {
    !this.tensorsMap || Object.keys(this.tensorsMap).forEach((e) => {
      this.tensorsMap[e].forEach((n) => {
        n && !n.kept && !n.isDisposed && !this.keepIds.has(n.id) && n.dispose();
      });
    });
  }
  getIntermediateTensors() {
    return this.tensorsMap;
  }
  resetIntermediateTensors() {
    for (let e in this.intermediateTensors)
      this.intermediateTensors[e].forEach((t) => t.dispose()), delete this.intermediateTensors[e];
  }
  async _executeAsync(e, t, n = false, s = {}, r = {}) {
    n || (e = this.mapInputs(e), this.checkInputs(e), this.checkInputShapeAndType(e), t = this.mapOutputs(t), this.checkOutputs(t));
    try {
      this.keepTensorForDebug = X().getBool("KEEP_INTERMEDIATE_TENSORS");
    } catch (l) {
      console.warn(l.message);
    }
    this.resetIntermediateTensors();
    let a = new Qx(this.weightMap, s, r, this.functionExecutorMap);
    this.tensorsMap = await this.executeWithControlFlow(e, a, t, n);
    let i = t.map((l) => un(l, this.tensorsMap, a)), o = i.map((l) => l.id), u = Object.keys(e).map((l) => e[l].id);
    return this.keepIds = /* @__PURE__ */ new Set([...o, ...u, ...this.weightIds]), this.keepTensorForDebug || this.disposeTensorsMap(), this.parent == null && a.dispose(this.keepIds), i;
  }
  async executeFunctionAsync(e, t, n) {
    let s = e.reduce((r, a, i) => (r[this.inputs[i].name] = a, r), {});
    return this._executeAsync(s, this.outputNodes, true, t, n);
  }
  async executeWithControlFlow(e, t, n, s) {
    let r = Object.keys(e), a = r.map((y) => this.graph.nodes[An(y)[0]]), i = n.map((y) => An(y)[0]), o = i.map((y) => this.graph.nodes[y]);
    o.length === 0 && (o = this._outputs);
    let { usedNodes: u, missingInputs: l, dynamicNode: c, syncInputs: p } = Zx(e, o, this.weightMap, this._initNodes), d = [...a, ...this.graph.weights, ...this._initNodes || []].map((y) => ({ node: y, contexts: t.currentContext })), h = { ...this.weightMap };
    Object.keys(e).forEach((y) => {
      let [v, x] = An(y), k = [];
      k[x] = e[y], h[v] = k;
    });
    let f = {}, m = this.getFrozenTensorIds(h), g = {};
    for (; d.length > 0; ) {
      let y = this.processStack(a, d, t, h, g, m, i, f, u);
      await Promise.all(y);
    }
    c == null && !s && console.warn("This model execution did not contain any nodes with control flow or dynamic output shapes. You can use model.execute() instead.");
    let b = o.filter((y) => !b0(y) && !un(y.name, h, t)).map((y) => y.name);
    if (b.length > 0) {
      let y = "";
      throw c != null && (y = `Alternatively, to avoid the dynamic ops, use model.execute() and specify the inputs [${p}]`), new Error(`Cannot compute the outputs [${b}] from the provided inputs [${r}]. Consider providing the following inputs: [${l}]. ${y}`);
    }
    return h;
  }
  processStack(e, t, n, s, r, a, i, o, u) {
    let l = [];
    for (; t.length > 0; ) {
      let c = t.pop();
      n.currentContext = c.contexts;
      let p = "";
      if (c.node.op === "Enter" && I("isConstant", c.node, s, n) && ([p] = Ts(c.node.name, n)), s[c.node.name] == null) {
        let d = Yx(c.node, s, n, this._resourceManager);
        p || ([p] = Ts(c.node.name, n));
        let h = n.currentContext;
        w.isPromise(d) ? l.push(d.then((f) => (s[p] = f, n.currentContext = h, this.checkTensorForDisposal(p, c.node, s, n, a, i, o), this.processChildNodes(c.node, t, n, s, r, u), f))) : (s[p] = d, this.checkTensorForDisposal(p, c.node, s, n, a, i, o), this.processChildNodes(c.node, t, n, s, r, u));
      } else
        this.processChildNodes(c.node, t, n, s, r, u);
    }
    return l;
  }
  processChildNodes(e, t, n, s, r, a) {
    e.children.forEach((i) => {
      let [o] = Ts(i.name, n);
      r[o] || !a.has(i.name) || (i.op === "Merge" ? i.inputNames.some((u) => !!un(u, s, n)) && (r[o] = true, t.push({ contexts: n.currentContext, node: i })) : i.inputNames.every((u) => !!un(u, s, n)) && (r[o] = true, t.push({ contexts: n.currentContext, node: i })));
    });
  }
  dispose() {
    Object.keys(this.weightMap).forEach((e) => this.weightMap[e].forEach((t) => t.dispose()));
  }
  checkInputShapeAndType(e) {
    Object.keys(e).forEach((t) => {
      let n = e[t], [s] = An(t), r = this.graph.nodes[s];
      if (r.attrParams.shape && r.attrParams.shape.value) {
        let a = r.attrParams.shape.value, i = a.length === n.shape.length && n.shape.every((o, u) => a[u] === -1 || a[u] === o);
        w.assert(i, () => `The shape of dict['${r.name}'] provided in model.execute(dict) must be [${a}], but was [${n.shape}]`);
      }
      r.attrParams.dtype && r.attrParams.dtype.value && w.assert(n.dtype === r.attrParams.dtype.value, () => `The dtype of dict['${r.name}'] provided in model.execute(dict) must be ${r.attrParams.dtype.value}, but was ${n.dtype}`);
    });
  }
  mapInputs(e) {
    let t = {};
    for (let n in e)
      if (this._signature != null && this._signature.inputs != null && this._signature.inputs[n] != null) {
        let s = this._signature.inputs[n];
        t[s.name] = e[n];
      } else
        t[n] = e[n];
    return t;
  }
  checkInputs(e) {
    let t = Object.keys(e).filter((n) => {
      let [s] = An(n);
      return this.graph.nodes[s] == null;
    });
    if (t.length > 0)
      throw new Error(`The dict provided in model.execute(dict) has keys: [${t}] that are not part of graph`);
  }
  mapOutputs(e) {
    return e.map((t) => this._signature != null && this._signature.outputs != null && this._signature.outputs[t] != null ? this._signature.outputs[t].name : t, {});
  }
  checkOutputs(e) {
    e.forEach((t) => {
      let [n] = An(t);
      if (!this.graph.nodes[n])
        throw new Error(`The output '${t}' is not found in the graph`);
    });
  }
};
var $4 = class {
  constructor(e = {}, t = {}) {
    this.hashTableNameToHandle = e, this.hashTableMap = t;
  }
  addHashTable(e, t) {
    this.hashTableNameToHandle[e] = t.handle, this.hashTableMap[t.id] = t;
  }
  getHashTableHandleByName(e) {
    return this.hashTableNameToHandle[e];
  }
  getHashTableById(e) {
    return this.hashTableMap[e];
  }
  dispose() {
    for (let e in this.hashTableMap)
      this.hashTableMap[e].clearAndClose(), delete this.hashTableMap[e];
    for (let e in this.hashTableNameToHandle)
      this.hashTableNameToHandle[e].dispose(), delete this.hashTableNameToHandle[e];
  }
};
var _4 = "?tfjs-format=file";
var A4 = "model.json";
var E4 = class {
  constructor(e, t = {}) {
    this.modelUrl = e, this.loadOptions = t, this.version = "n/a", t == null && (this.loadOptions = {}), this.resourceManager = new $4();
  }
  get modelVersion() {
    return this.version;
  }
  get inputNodes() {
    return this.executor.inputNodes;
  }
  get outputNodes() {
    return this.executor.outputNodes;
  }
  get inputs() {
    return this.executor.inputs;
  }
  get outputs() {
    return this.executor.outputs;
  }
  get weights() {
    return this.executor.weightMap;
  }
  get metadata() {
    return this.artifacts.userDefinedMetadata;
  }
  get modelSignature() {
    return this.signature;
  }
  findIOHandler() {
    let e = this.modelUrl;
    if (e.load != null)
      this.handler = e;
    else if (this.loadOptions.requestInit != null)
      this.handler = En.browserHTTPRequest(e, this.loadOptions);
    else {
      let t = En.getLoadHandlers(e, this.loadOptions);
      if (t.length === 0)
        t.push(En.browserHTTPRequest(e, this.loadOptions));
      else if (t.length > 1)
        throw new Error(`Found more than one (${t.length}) load handlers for URL '${[e]}'`);
      this.handler = t[0];
    }
  }
  async load() {
    if (this.findIOHandler(), this.handler.load == null)
      throw new Error("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");
    let e = await this.handler.load();
    return this.loadSync(e);
  }
  loadSync(e) {
    this.artifacts = e;
    let t = this.artifacts.modelTopology, n;
    this.artifacts.userDefinedMetadata != null && this.artifacts.userDefinedMetadata.signature != null ? n = this.artifacts.userDefinedMetadata.signature : n = this.artifacts.signature, this.signature = n, this.version = `${t.versions.producer}.${t.versions.minConsumer}`;
    let s = En.decodeWeights(this.artifacts.weightData, this.artifacts.weightSpecs);
    if (this.executor = new zm(qx.Instance.transformGraph(t, this.signature)), this.executor.weightMap = this.convertTensorMapToTensorsMap(s), this.executor.resourceManager = this.resourceManager, e.modelInitializer != null && e.modelInitializer.node != null) {
      let r = qx.Instance.transformGraph(e.modelInitializer);
      this.initializer = new zm(r), this.initializer.weightMap = this.executor.weightMap, this.initializer.resourceManager = this.resourceManager, this.initializer.executeAsync({}, []);
    }
    return true;
  }
  async save(e, t) {
    if (typeof e == "string") {
      let n = En.getSaveHandlers(e);
      if (n.length === 0)
        throw new Error(`Cannot find any save handlers for URL '${e}'`);
      if (n.length > 1)
        throw new Error(`Found more than one (${n.length}) save handlers for URL '${e}'`);
      e = n[0];
    }
    if (e.save == null)
      throw new Error("GraphModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");
    return e.save(this.artifacts);
  }
  predict(e, t) {
    return this.execute(e, this.outputNodes);
  }
  normalizeInputs(e) {
    if (!(e instanceof et) && !Array.isArray(e))
      return e;
    if (e = Array.isArray(e) ? e : [e], e.length !== this.inputNodes.length)
      throw new Error(`Input tensor count mismatch,the graph model has ${this.inputNodes.length} placeholders, while there are ${e.length} input tensors.`);
    return this.inputNodes.reduce((t, n, s) => (t[n] = e[s], t), {});
  }
  normalizeOutputs(e) {
    return e = e || this.outputNodes, Array.isArray(e) ? e : [e];
  }
  execute(e, t) {
    e = this.normalizeInputs(e), t = this.normalizeOutputs(t);
    let n = this.executor.execute(e, t);
    return n.length > 1 ? n : n[0];
  }
  async executeAsync(e, t) {
    e = this.normalizeInputs(e), t = this.normalizeOutputs(t);
    let n = await this.executor.executeAsync(e, t);
    return n.length > 1 ? n : n[0];
  }
  getIntermediateTensors() {
    return this.executor.getIntermediateTensors();
  }
  disposeIntermediateTensors() {
    this.executor.disposeIntermediateTensors();
  }
  convertTensorMapToTensorsMap(e) {
    return Object.keys(e).reduce((t, n) => (t[n] = [e[n]], t), {});
  }
  dispose() {
    this.executor.dispose(), this.initializer && this.initializer.dispose(), this.resourceManager.dispose();
  }
};
async function Dpe(e, t = {}) {
  if (e == null)
    throw new Error("modelUrl in loadGraphModel() cannot be null. Please provide a url or an IOHandler that loads the model");
  t == null && (t = {}), t.fromTFHub && e.load == null && (e.endsWith("/") || (e = e + "/"), e = `${e}${A4}${_4}`);
  let n = new E4(e, t);
  return await n.load(), n;
}
var Fpe = "0.0.0";
var R4 = {};
Ae(R4, { CSVDataset: () => _0, Dataset: () => Jo, FileDataSource: () => P0, TextLineDataset: () => $0, URLDataSource: () => z0, array: () => tU, csv: () => pU, func: () => hU, generator: () => fU, microphone: () => gU, version_data: () => bU, webcam: () => mU, zip: () => nU });
var D4 = xa(Wd());
var F4 = xa(Wd());
function O4(e, t) {
  return Rd(e, t);
}
function Rd(e, t, n = /* @__PURE__ */ new Map(), s = /* @__PURE__ */ new Set()) {
  if (e == null)
    return null;
  if (typeof Blob == "function" && e instanceof Blob)
    return e.slice();
  if (s.has(e))
    throw new Error("Circular references are not supported.");
  if (n.has(e))
    return n.get(e);
  let r = t(e);
  if (r.recurse && r.value !== null)
    throw new Error("A deep map function may not return both a value and recurse=true.");
  if (r.recurse)
    if (to(e)) {
      let a = Array.isArray(e) ? [] : {};
      s.add(e);
      for (let i in e) {
        let o = e[i], u = Rd(o, t, n, s);
        a[i] = u;
      }
      return s.delete(e), e.__proto__ && (a.__proto__ = e.__proto__), a;
    } else
      throw new Error(`Can't recurse into non-iterable type: ${e}`);
  else
    return n.set(e, r.value), r.value;
}
function P4(e, t = v0) {
  return y0(e, t);
}
function y0(e, t, n = /* @__PURE__ */ new Set()) {
  let s = e[0];
  if (n.has(s))
    throw new Error("Circular references are not supported.");
  let r = t(e);
  if (r.recurse && r.value !== null)
    throw new Error("A deep zip function may not return both a value and recurse=true.");
  if (r.recurse)
    if (to(s)) {
      let a = Array.isArray(s) ? [] : {};
      n.add(s);
      for (let i in s) {
        let o = e.map((l) => l[i]), u = y0(o, t, n);
        a[i] = u;
      }
      return n.delete(s), a;
    } else
      throw new Error(`Can't recurse into non-iterable type: ${s}`);
  else
    return r.value;
}
function v0(e) {
  return e === null ? null : to(e[0]) ? { value: null, recurse: true } : { value: e, recurse: false };
}
async function x0(e, t) {
  let n = /* @__PURE__ */ new Map();
  Rd(e, t, n);
  for (let r of Array.from(n.keys())) {
    let a = n.get(r);
    if (w.isPromise(a)) {
      let i = await a;
      n.set(r, i);
    }
  }
  return Rd(e, t, n);
}
function to(e) {
  let t = false;
  if (X().get("IS_BROWSER"))
    t = e instanceof TextDecoder;
  else {
    let { StringDecoder: n } = Ww();
    t = e instanceof n;
  }
  return e != null && !ArrayBuffer.isView(e) && (Array.isArray(e) || typeof e == "object" && !(e instanceof et) && !(e instanceof Promise) && !t);
}
function z4(e) {
  return e == null || M4(e) || Array.isArray(e) || typeof e == "object" && e instanceof et || w.isTypedArray(e);
}
function M4(e) {
  return e === null || typeof e != "object" && typeof e != "function";
}
function L4(e) {
  return O4(e, B4);
}
function B4(e) {
  return e instanceof et ? { value: e.clone(), recurse: false } : to(e) ? { value: null, recurse: true } : { value: e, recurse: false };
}
var w0 = class {
  constructor(e) {
    if (this.capacity = e, this.begin = 0, this.end = 0, e == null)
      throw new RangeError("Can't create a ring buffer of unknown capacity.");
    if (e < 1)
      throw new RangeError("Can't create ring buffer of capacity < 1.");
    this.data = new Array(e), this.doubledCapacity = 2 * e;
  }
  wrap(e) {
    for (; e < 0; )
      e += this.doubledCapacity;
    return e % this.doubledCapacity;
  }
  get(e) {
    if (e < 0)
      throw new RangeError("Can't get item at a negative index.");
    return this.data[e % this.capacity];
  }
  set(e, t) {
    if (e < 0)
      throw new RangeError("Can't set item at a negative index.");
    this.data[e % this.capacity] = t;
  }
  length() {
    let e = this.end - this.begin;
    return e < 0 && (e = this.doubledCapacity + e), e;
  }
  isFull() {
    return this.length() === this.capacity;
  }
  isEmpty() {
    return this.length() === 0;
  }
  push(e) {
    if (this.isFull())
      throw new RangeError("Ring buffer is full.");
    this.set(this.end, e), this.end = this.wrap(this.end + 1);
  }
  pushAll(e) {
    for (let t of e)
      this.push(t);
  }
  pop() {
    if (this.isEmpty())
      throw new RangeError("Ring buffer is empty.");
    this.end = this.wrap(this.end - 1);
    let e = this.get(this.end);
    return this.set(this.end, void 0), e;
  }
  unshift(e) {
    if (this.isFull())
      throw new RangeError("Ring buffer is full.");
    this.begin = this.wrap(this.begin - 1), this.set(this.begin, e);
  }
  shift() {
    if (this.isEmpty())
      throw new RangeError("Ring buffer is empty.");
    let e = this.get(this.begin);
    return this.set(this.begin, void 0), this.begin = this.wrap(this.begin + 1), e;
  }
  shuffleExcise(e) {
    if (this.isEmpty())
      throw new RangeError("Ring buffer is empty.");
    let t = this.wrap(this.begin + e), n = this.get(t);
    return this.set(t, this.pop()), n;
  }
};
var k0 = class extends w0 {
  constructor() {
    super(k0.INITIAL_CAPACITY);
  }
  isFull() {
    return false;
  }
  push(e) {
    super.isFull() && this.expand(), super.push(e);
  }
  unshift(e) {
    super.isFull() && this.expand(), super.unshift(e);
  }
  expand() {
    let e = this.capacity * 2, t = new Array(e), n = this.length();
    for (let s = 0; s < n; s++)
      t[s] = this.get(this.wrap(this.begin + s));
    this.data = t, this.capacity = e, this.doubledCapacity = 2 * this.capacity, this.begin = 0, this.end = n;
  }
};
var I0 = k0;
I0.INITIAL_CAPACITY = 32;
function S0(e) {
  return new U4(e);
}
function Yy(e) {
  return new G4(e);
}
function V4(e, t) {
  return new C0(e, t);
}
function W4(e, t = N0.FAIL) {
  return new J4(e, t);
}
var Ut = class {
  async toArray() {
    let e = [], t = await this.next();
    for (; !t.done; )
      e.push(t.value), t = await this.next();
    return e;
  }
  async toArrayForTest() {
    let e = this.prefetch(100), t = [], n = await e.next();
    for (; !n.done; )
      t.push(n.value), n = await e.next();
    return t;
  }
  async resolveFully() {
    let e = await this.next();
    for (; !e.done; )
      e = await this.next();
  }
  async resolveWhile(e) {
    let t = await this.next(), n = e(t.value);
    for (; !t.done && n; )
      t = await this.next(), n = e(t.value);
  }
  handleErrors(e) {
    return new Q4(this, e);
  }
  filter(e) {
    return new X4(this, e);
  }
  map(e) {
    return new Y4(this, e);
  }
  mapAsync(e) {
    return new Jx(this, e);
  }
  serialMapAsync(e) {
    return new Jx(this, e).serial();
  }
  flatmap(e) {
    return new Z4(this, e);
  }
  async forEachAsync(e) {
    return this.map(e).resolveFully();
  }
  async serialForEach(e) {
    return this.serialMapAsync(e).resolveWhile((t) => t === true);
  }
  rowMajorBatch(e, t = true) {
    return new K4(this, e, t);
  }
  columnMajorBatch(e, t = true, n = v0) {
    return this.rowMajorBatch(e, t).map((r) => P4(r, n));
  }
  concatenate(e, t) {
    return new C0(S0([this, e]), t);
  }
  take(e) {
    return e < 0 || e == null ? this : new j4(this, e);
  }
  skip(e) {
    return e < 0 || e == null ? this : new q4(this, e);
  }
  prefetch(e) {
    return new T0(this, e);
  }
  shuffle(e, t) {
    return new eU(this, e, t);
  }
  serial() {
    return new H4(this);
  }
};
var U4 = class extends Ut {
  constructor(e) {
    super(), this.items = e, this.trav = 0;
  }
  summary() {
    return `Array of ${this.items.length} items`;
  }
  async next() {
    if (this.trav >= this.items.length)
      return { value: null, done: true };
    let e = this.items[this.trav];
    return this.trav++, { value: L4(e), done: false };
  }
};
var G4 = class extends Ut {
  constructor(e) {
    super(), this.nextFn = e;
  }
  summary() {
    return "Function call";
  }
  async next() {
    try {
      return this.nextFn();
    } catch (e) {
      throw e.message = `Error thrown while iterating through a dataset: ${e.message}`, e;
    }
  }
};
var H4 = class extends Ut {
  constructor(e) {
    super(), this.upstream = e, this.lastRead = Promise.resolve({ value: null, done: false });
  }
  summary() {
    return `${this.upstream.summary()} -> Serial`;
  }
  async next() {
    return this.lastRead = this.lastRead.then(() => this.serialNext()), this.lastRead;
  }
  async serialNext() {
    return this.upstream.next();
  }
};
var q4 = class extends Ut {
  constructor(e, t) {
    super(), this.upstream = e, this.maxCount = t, this.count = 0, this.lastRead = Promise.resolve({ value: null, done: false });
  }
  summary() {
    return `${this.upstream.summary()} -> Skip`;
  }
  async next() {
    return this.lastRead = this.lastRead.then(() => this.serialNext()), this.lastRead;
  }
  async serialNext() {
    for (; this.count++ < this.maxCount; ) {
      let e = await this.upstream.next();
      if (e.done)
        return e;
      Re(e.value);
    }
    return this.upstream.next();
  }
};
var j4 = class extends Ut {
  constructor(e, t) {
    super(), this.upstream = e, this.maxCount = t, this.count = 0;
  }
  summary() {
    return `${this.upstream.summary()} -> Take`;
  }
  async next() {
    return this.count++ >= this.maxCount ? { value: null, done: true } : this.upstream.next();
  }
};
var K4 = class extends Ut {
  constructor(e, t, n = true) {
    super(), this.upstream = e, this.batchSize = t, this.enableSmallLastBatch = n, this.lastRead = Promise.resolve({ value: null, done: false });
  }
  summary() {
    return `${this.upstream.summary()} -> RowMajorBatch`;
  }
  async next() {
    return this.lastRead = this.lastRead.then(() => this.serialNext()), this.lastRead;
  }
  async serialNext() {
    let e = [];
    for (; e.length < this.batchSize; ) {
      let t = await this.upstream.next();
      if (t.done)
        return this.enableSmallLastBatch && e.length > 0 ? { value: e, done: false } : { value: null, done: true };
      e.push(t.value);
    }
    return { value: e, done: false };
  }
};
var X4 = class extends Ut {
  constructor(e, t) {
    super(), this.upstream = e, this.predicate = t, this.lastRead = Promise.resolve({ value: null, done: false });
  }
  summary() {
    return `${this.upstream.summary()} -> Filter`;
  }
  async next() {
    return this.lastRead = this.lastRead.then(() => this.serialNext()), this.lastRead;
  }
  async serialNext() {
    for (; ; ) {
      let e = await this.upstream.next();
      if (e.done || this.predicate(e.value))
        return e;
      Re(e.value);
    }
  }
};
var Y4 = class extends Ut {
  constructor(e, t) {
    super(), this.upstream = e, this.transform = t;
  }
  summary() {
    return `${this.upstream.summary()} -> Map`;
  }
  async next() {
    let e = await this.upstream.next();
    if (e.done)
      return { value: null, done: true };
    let t = _s.getTensorsInContainer(e.value), n = this.transform(e.value), s = _s.getTensorsInContainer(n);
    for (let r of t)
      _s.isTensorInList(r, s) || r.dispose();
    return { value: n, done: false };
  }
};
var Q4 = class extends Ut {
  constructor(e, t) {
    super(), this.upstream = e, this.handler = t, this.count = 0, this.lastRead = Promise.resolve({ value: null, done: false });
  }
  summary() {
    return `${this.upstream.summary()} -> handleErrors`;
  }
  async next() {
    return this.lastRead = this.lastRead.then(() => this.serialNext()), this.lastRead;
  }
  async serialNext() {
    for (; ; )
      try {
        return await this.upstream.next();
      } catch (e) {
        if (!this.handler(e))
          return { value: null, done: true };
      }
  }
};
var Jx = class extends Ut {
  constructor(e, t) {
    super(), this.upstream = e, this.transform = t;
  }
  summary() {
    return `${this.upstream.summary()} -> AsyncMap`;
  }
  async next() {
    let e = await this.upstream.next();
    if (e.done)
      return { value: null, done: true };
    let t = _s.getTensorsInContainer(e.value), n = await this.transform(e.value), s = _s.getTensorsInContainer(n);
    for (let r of t)
      _s.isTensorInList(r, s) || r.dispose();
    return { value: n, done: false };
  }
};
var Qy = class extends Ut {
  constructor() {
    super(), this.outputQueue = new I0(), this.lastRead = Promise.resolve({ value: null, done: false });
  }
  async next() {
    return this.lastRead = this.lastRead.then(() => this.serialNext()), this.lastRead;
  }
  async serialNext() {
    for (; this.outputQueue.length() === 0; )
      if (!await this.pump())
        return { value: null, done: true };
    return { value: this.outputQueue.shift(), done: false };
  }
};
var Z4 = class extends Qy {
  constructor(e, t) {
    super(), this.upstream = e, this.transform = t;
  }
  summary() {
    return `${this.upstream.summary()} -> Flatmap`;
  }
  async pump() {
    let e = await this.upstream.next();
    if (e.done)
      return false;
    let t = _s.getTensorsInContainer(e.value), n = this.transform(e.value), s = _s.getTensorsInContainer(n);
    this.outputQueue.pushAll(n);
    for (let r of t)
      _s.isTensorInList(r, s) || r.dispose();
    return true;
  }
};
var C0 = class extends Ut {
  constructor(e, t) {
    super(), this.baseErrorHandler = t, this.lastRead = null, this.iterator = null, this.moreIterators = e;
  }
  summary() {
    return "TODO: fill in upstream of chained summaries -> Chained";
  }
  async next() {
    return this.lastRead = this.readFromChain(this.lastRead), this.lastRead;
  }
  async readFromChain(e) {
    if (await e, this.iterator == null) {
      let n = await this.moreIterators.next();
      if (n.done)
        return { value: null, done: true };
      this.iterator = n.value, this.baseErrorHandler != null && (this.iterator = this.iterator.handleErrors(this.baseErrorHandler));
    }
    let t = await this.iterator.next();
    return t.done ? (this.iterator = null, this.readFromChain(e)) : t;
  }
};
var N0 = ((e) => (e[e.FAIL = 0] = "FAIL", e[e.SHORTEST = 1] = "SHORTEST", e[e.LONGEST = 2] = "LONGEST", e))(N0 || {});
var J4 = class extends Ut {
  constructor(e, t = 0) {
    super(), this.iterators = e, this.mismatchMode = t, this.count = 0, this.currentPromise = null;
  }
  summary() {
    return "{TODO: fill in upstream of zip summaries} -> Zip";
  }
  async nextState(e) {
    await e;
    let t = 0, n = 0;
    function s(a) {
      return a instanceof Ut ? { value: a.next().then((o) => (t++, o.done && n++, o.value)), recurse: false } : { value: null, recurse: true };
    }
    let r = await x0(this.iterators, s);
    if (t === n)
      return { value: null, done: true };
    if (n > 0)
      switch (this.mismatchMode) {
        case 0:
          throw new Error(`Zipped streams should have the same length. Mismatched at element ${this.count}.`);
        case 1:
          return { value: null, done: true };
        case 2:
        default:
      }
    return this.count++, { value: r, done: false };
  }
  async next() {
    return this.currentPromise = this.nextState(this.currentPromise), this.currentPromise;
  }
};
var T0 = class extends Ut {
  constructor(e, t) {
    super(), this.upstream = e, this.bufferSize = t, this.buffer = new w0(t);
  }
  summary() {
    return `${this.upstream.summary()} -> Prefetch`;
  }
  refill() {
    for (; !this.buffer.isFull(); ) {
      let e = this.upstream.next();
      this.buffer.push(e);
    }
  }
  next() {
    return this.refill(), this.buffer.shift();
  }
};
var eU = class extends T0 {
  constructor(e, t, n) {
    super(e, t), this.upstream = e, this.windowSize = t, this.upstreamExhausted = false, this.random = F4.alea(n || w.now().toString()), this.lastRead = Promise.resolve({ value: null, done: false });
  }
  async next() {
    return this.lastRead = this.lastRead.then(() => this.serialNext()), this.lastRead;
  }
  randomInt(e) {
    return Math.floor(this.random() * e);
  }
  chooseIndex() {
    return this.randomInt(this.buffer.length());
  }
  async serialNext() {
    for (this.upstreamExhausted || this.refill(); !this.buffer.isEmpty(); ) {
      let e = this.chooseIndex(), t = await this.buffer.shuffleExcise(e);
      if (t.done)
        this.upstreamExhausted = true;
      else
        return this.refill(), t;
    }
    return { value: null, done: true };
  }
};
var Jo = class {
  constructor() {
    this.size = null;
  }
  batch(e, t = true) {
    let n = this;
    w.assert(e > 0, () => `batchSize needs to be positive, but it is
      ${e}`);
    let s;
    return this.size === 1 / 0 || this.size == null ? s = this.size : t ? s = Math.ceil(this.size / e) : s = Math.floor(this.size / e), _n(async () => (await n.iterator()).columnMajorBatch(e, t, sU), s);
  }
  concatenate(e) {
    let t = this, n;
    return this.size === 1 / 0 || e.size === 1 / 0 ? n = 1 / 0 : this.size != null && e.size != null ? n = this.size + e.size : n = null, _n(async () => (await t.iterator()).concatenate(await e.iterator()), n);
  }
  filter(e) {
    let t = this, n;
    return this.size === 1 / 0 ? n = 1 / 0 : n = null, _n(async () => (await t.iterator()).filter((s) => j(() => e(s))), n);
  }
  async forEachAsync(e) {
    return (await this.iterator()).forEachAsync(e);
  }
  map(e) {
    let t = this;
    return _n(async () => (await t.iterator()).map((n) => j(() => e(n))), this.size);
  }
  mapAsync(e) {
    let t = this;
    return _n(async () => (await t.iterator()).mapAsync(e), this.size);
  }
  prefetch(e) {
    if (e == null)
      throw new RangeError("`Dataset.prefetch()` requires bufferSize to be specified.");
    let t = this;
    return _n(async () => (await t.iterator()).prefetch(e), this.size);
  }
  repeat(e) {
    let t = this, n;
    return this.size != null && e > 0 ? n = this.size * e : e === 0 ? n = 0 : this.size != null && (e === void 0 || e < 0) ? n = 1 / 0 : n = null, _n(async () => {
      let s = Yy(async () => ({ value: await t.iterator(), done: false }));
      return V4(s.take(e));
    }, n);
  }
  skip(e) {
    let t = this, n;
    return this.size != null && e >= 0 && this.size >= e ? n = this.size - e : this.size != null && (this.size < e || e === void 0 || e < 0) ? n = 0 : n = null, _n(async () => (await t.iterator()).skip(e), n);
  }
  shuffle(e, t, n = true) {
    if (e == null || e < 0)
      throw this.size == null ? new RangeError("`Dataset.shuffle()` requires bufferSize to be specified.") : new RangeError(`\`Dataset.shuffle()\` requires bufferSize to be specified.  If your data fits in main memory (for regular JS objects), and/or GPU memory (for \`tf.Tensor\`s), consider setting bufferSize to the dataset size (${this.size} elements)`);
    let s = this, r = D4.alea(t || w.now().toString());
    return _n(async () => {
      let a = r.int32();
      return n && (a += r.int32()), (await s.iterator()).shuffle(e, a.toString());
    }, this.size);
  }
  take(e) {
    let t = this, n;
    return this.size != null && this.size > e ? n = e : this.size != null && this.size <= e ? n = this.size : n = null, _n(async () => (await t.iterator()).take(e), n);
  }
  async toArray() {
    if (this.size === 1 / 0)
      throw new Error("Can not convert infinite data stream to array.");
    return (await this.iterator()).toArray();
  }
  async toArrayForTest() {
    if (this.size === 1 / 0)
      throw new Error("Can not convert infinite data stream to array.");
    return (await this.iterator()).toArrayForTest();
  }
};
Jo.MAX_BUFFER_SIZE = 1e4;
function _n(e, t = null) {
  return new class extends Jo {
    constructor() {
      super(...arguments), this.size = t;
    }
    async iterator() {
      return e();
    }
  }();
}
function tU(e) {
  return _n(async () => S0(e), e.length);
}
function nU(e) {
  if (!to(e))
    throw new Error("The argument to zip() must be an object or array.");
  let t;
  if (Array.isArray(e))
    for (let n = 0; n < e.length; n++)
      t = t == null ? e[n].size : Math.min(t, e[n].size);
  else if (e instanceof Object)
    for (let n in e)
      t = t == null ? e[n].size : Math.min(t, e[n].size);
  return _n(async () => {
    let n = await x0(e, (s) => {
      if (s instanceof Jo)
        return { value: s.iterator(), recurse: false };
      if (to(s))
        return { value: null, recurse: true };
      throw new Error("Leaves of the structure passed to zip() must be Datasets, not primitives.");
    });
    return W4(n, 1);
  }, t);
}
function sU(e) {
  if (e === null)
    return null;
  let t = e[0];
  return z4(t) ? { value: rU(e), recurse: false } : { value: null, recurse: true };
}
function rU(e) {
  if (e.length === 0)
    throw new Error("Can't make a batch of zero elements.");
  return e[0] instanceof et ? Jn(e) : fs(e);
}
var $0 = class extends Jo {
  constructor(e) {
    super(), this.input = e;
  }
  async iterator() {
    return (await this.input.iterator()).decodeUTF8().split(`
`).map((s) => (s.endsWith("\r") && (s = s.slice(0, -1)), s));
  }
};
var Kc = '"';
var Tu = Symbol("out");
var ew = Symbol("field");
var Xc = Symbol("quote");
var qf = Symbol("quoteafterquote");
var tw = Symbol("quoteinquote");
var _0 = class extends Jo {
  constructor(e, t) {
    super(), this.input = e, this.hasHeader = true, this.fullColumnNames = null, this.columnNamesValidated = false, this.columnConfigs = null, this.configuredColumnsOnly = false, this.delimiter = ",", this.delimWhitespace = false, this.base = new $0(e), t || (t = {}), this.hasHeader = t.hasHeader !== false, this.fullColumnNames = t.columnNames, this.columnConfigs = t.columnConfigs, this.configuredColumnsOnly = t.configuredColumnsOnly, t.delimWhitespace ? (w.assert(t.delimiter == null, () => "Delimiter should not be provided when delimWhitespace is true."), this.delimWhitespace = true, this.delimiter = " ") : this.delimiter = t.delimiter ? t.delimiter : ",";
  }
  async columnNames() {
    return this.columnNamesValidated || await this.setColumnNames(), this.configuredColumnsOnly ? Object.keys(this.columnConfigs) : this.fullColumnNames;
  }
  async setColumnNames() {
    let e = await this.maybeReadHeaderLine();
    if (!this.fullColumnNames && !e)
      throw new Error("Column names must be provided if there is no header line.");
    this.fullColumnNames && e && w.assert(e.length === this.fullColumnNames.length, () => "The length of provided columnNames (" + this.fullColumnNames.length.toString() + ") does not match the length of the header line read from file (" + e.length.toString() + ")."), this.fullColumnNames || (this.fullColumnNames = e);
    let t = this.fullColumnNames.reduce((s, r) => (s[r] = s[r] + 1 || 1, s), {}), n = Object.keys(t).filter((s) => t[s] > 1);
    if (w.assert(n.length === 0, () => "Duplicate column names found: " + n.toString()), this.columnConfigs) {
      for (let s of Object.keys(this.columnConfigs))
        if (this.fullColumnNames.indexOf(s) === -1)
          throw new Error('The key "' + s + '" provided in columnConfigs does not match any of the column names (' + this.fullColumnNames.toString() + ").");
    }
    this.columnNamesValidated = true;
  }
  async maybeReadHeaderLine() {
    if (this.hasHeader) {
      let t = await (await this.base.iterator()).next();
      if (t.done)
        throw new Error("No data was found for CSV parsing.");
      let n = t.value;
      return this.parseRow(n, false);
    } else
      return null;
  }
  async iterator() {
    this.columnNamesValidated || await this.setColumnNames();
    let e = await this.base.iterator();
    return this.hasHeader && (e = e.skip(1)), e.map((t) => this.makeDataElement(t));
  }
  makeDataElement(e) {
    let t = this.parseRow(e), n = {}, s = {};
    for (let r = 0; r < this.fullColumnNames.length; r++) {
      let a = this.fullColumnNames[r], i = this.columnConfigs ? this.columnConfigs[a] : null;
      if (!(this.configuredColumnsOnly && !i)) {
        let o = t[r], u = null;
        if (o === "")
          if (i && i.default !== void 0)
            u = i.default;
          else {
            if (i && (i.required || i.isLabel))
              throw new Error(`Required column ${a} is empty in this line: ${e}`);
            u = void 0;
          }
        else {
          let l = Number(o);
          if (isNaN(l))
            i && i.dtype === "bool" ? u = this.getBoolean(o) : u = o;
          else if (!i || !i.dtype)
            u = l;
          else
            switch (i.dtype) {
              case "float32":
                u = l;
                break;
              case "int32":
                u = Math.floor(l);
                break;
              case "bool":
                u = this.getBoolean(o);
                break;
              default:
                u = l;
            }
        }
        i && i.isLabel ? s[a] = u : n[a] = u;
      }
    }
    return Object.keys(s).length === 0 ? n : { xs: n, ys: s };
  }
  getBoolean(e) {
    return e === "1" || e.toLowerCase() === "true" ? 1 : 0;
  }
  parseRow(e, t = true) {
    let n = [], s = 0, r = e.length, a = Tu;
    for (let i = 0; i < r; i++)
      switch (a) {
        case Tu:
          switch (e.charAt(i)) {
            case Kc:
              s = i + 1, a = Xc;
              break;
            case this.delimiter:
              if (s = i + 1, this.delimiter === " " && this.delimWhitespace)
                break;
              n.push(""), a = Tu;
              break;
            default:
              a = ew, s = i;
              break;
          }
          break;
        case ew:
          switch (e.charAt(i)) {
            case this.delimiter:
              n.push(e.substring(s, i)), a = Tu, s = i + 1;
              break;
            default:
          }
          break;
        case Xc:
          switch (e.charAt(i)) {
            case Kc:
              a = qf;
              break;
            default:
          }
          break;
        case qf:
          switch (e.charAt(i)) {
            case this.delimiter:
              n.push(e.substring(s, i - 1)), a = Tu, s = i + 1;
              break;
            case Kc:
              a = Xc;
              break;
            default:
              a = tw;
              break;
          }
          break;
        case tw:
          switch (e.charAt(i)) {
            case Kc:
              a = Xc;
              break;
            default:
          }
          break;
        default:
      }
    if (a === qf ? n.push(e.substring(s, r - 1)) : n.push(e.substring(s)), t && n.length !== this.fullColumnNames.length)
      throw new Error(`Invalid row in csv file. Should have ${this.fullColumnNames.length} elements in a row, but got ${n}`);
    return n;
  }
};
var A0 = class extends Ut {
  constructor(e) {
    super(), this.microphoneConfig = e, this.isClosed = false, this.fftSize = e.fftSize || 1024;
    let t = Math.log2(this.fftSize);
    if (this.fftSize < 0 || t < 4 || t > 14 || !Number.isInteger(t))
      throw new Error(`Invalid fftSize: it must be a power of 2 between 2 to 4 and 2 to 14, but got ${this.fftSize}`);
    if (this.numFrames = e.numFramesPerSpectrogram || 43, this.sampleRateHz = e.sampleRateHz, this.columnTruncateLength = e.columnTruncateLength || this.fftSize, this.audioTrackConstraints = e.audioTrackConstraints, this.smoothingTimeConstant = e.smoothingTimeConstant || 0, this.includeSpectrogram = e.includeSpectrogram !== false, this.includeWaveform = e.includeWaveform === true, !this.includeSpectrogram && !this.includeWaveform)
      throw new Error("Both includeSpectrogram and includeWaveform are false. At least one type of data should be returned.");
  }
  summary() {
    return "microphone";
  }
  static async create(e = {}) {
    if (!X().get("IS_BROWSER"))
      throw new Error("microphone API is only supported in browser environment.");
    let t = new A0(e);
    return await t.start(), t;
  }
  async start() {
    try {
      this.stream = await navigator.mediaDevices.getUserMedia({ audio: this.audioTrackConstraints == null ? true : this.audioTrackConstraints, video: false });
    } catch (n) {
      throw new Error(`Error thrown while initializing video stream: ${n.message}`);
    }
    if (!this.stream)
      throw new Error("Could not obtain audio from microphone.");
    let e = window.AudioContext || window.webkitAudioContext;
    if (this.audioContext = new e(), !this.sampleRateHz)
      this.sampleRateHz = this.audioContext.sampleRate;
    else if (this.audioContext.sampleRate !== this.sampleRateHz)
      throw new Error(`Mismatch in sampling rate: Expected: ${this.sampleRateHz}; Actual: ${this.audioContext.sampleRate}`);
    let t = this.audioContext.createMediaStreamSource(this.stream);
    this.analyser = this.audioContext.createAnalyser(), this.analyser.fftSize = this.fftSize * 2, this.analyser.smoothingTimeConstant = this.smoothingTimeConstant, t.connect(this.analyser), this.freqData = new Float32Array(this.fftSize), this.timeData = new Float32Array(this.fftSize);
  }
  async next() {
    if (this.isClosed)
      return { value: null, done: true };
    let e, t, n = await this.getAudioData();
    if (this.includeSpectrogram) {
      let s = this.flattenQueue(n.freqDataQueue);
      e = this.getTensorFromAudioDataArray(s, [this.numFrames, this.columnTruncateLength, 1]);
    }
    if (this.includeWaveform) {
      let s = this.flattenQueue(n.timeDataQueue);
      t = this.getTensorFromAudioDataArray(s, [this.numFrames * this.fftSize, 1]);
    }
    return { value: { spectrogram: e, waveform: t }, done: false };
  }
  async capture() {
    return (await this.next()).value;
  }
  async getAudioData() {
    let e = [], t = [], n = 0;
    return new Promise((s) => {
      let r = setInterval(() => {
        this.includeSpectrogram && (this.analyser.getFloatFrequencyData(this.freqData), this.freqData[0] === -1 / 0 && s({ freqDataQueue: e, timeDataQueue: t }), e.push(this.freqData.slice(0, this.columnTruncateLength))), this.includeWaveform && (this.analyser.getFloatTimeDomainData(this.timeData), t.push(this.timeData.slice())), ++n === this.numFrames && (clearInterval(r), s({ freqDataQueue: e, timeDataQueue: t }));
      }, this.fftSize / this.sampleRateHz * 1e3);
    });
  }
  stop() {
    this.isClosed || (this.isClosed = true, this.analyser.disconnect(), this.audioContext.close(), this.stream != null && this.stream.getTracks().length > 0 && this.stream.getTracks()[0].stop());
  }
  toArray() {
    throw new Error("Can not convert infinite audio stream to array.");
  }
  getSampleRate() {
    return this.sampleRateHz;
  }
  flattenQueue(e) {
    let t = e[0].length, n = new Float32Array(e.length * t);
    return e.forEach((s, r) => n.set(s, r * t)), n;
  }
  getTensorFromAudioDataArray(e, t) {
    let n = new Float32Array(w.sizeFromShape(t));
    return n.set(e, n.length - e.length), fs(n, t);
  }
};
var E0 = class extends Ut {
  constructor(e, t) {
    if (super(), this.webcamVideoElement = e, this.webcamConfig = t, this.isClosed = true, this.resize = false, this.needToResize())
      if (this.resize = true, this.cropSize = [this.webcamConfig.resizeHeight, this.webcamConfig.resizeWidth], this.cropBoxInd = Zt([0], "int32"), this.webcamConfig.centerCrop) {
        let n = this.webcamConfig.resizeWidth * 1 / this.webcamVideoElement.width, s = this.webcamConfig.resizeHeight * 1 / this.webcamVideoElement.height, r = (1 - n) / 2, a = (1 - s) / 2, i = r + n, o = s + a;
        this.cropBox = Ki([a, r, o, i], [1, 4]);
      } else
        this.cropBox = Ki([0, 0, 1, 1], [1, 4]);
  }
  summary() {
    return "webcam";
  }
  static async create(e, t = {}) {
    if (!X().get("IS_BROWSER"))
      throw new Error("tf.data.webcam is only supported in browser environment.");
    if (!e) {
      if (e = document.createElement("video"), !t.resizeWidth || !t.resizeHeight)
        throw new Error("Please provide webcam video element, or resizeWidth and resizeHeight to create a hidden video element.");
      e.width = t.resizeWidth, e.height = t.resizeHeight;
    }
    let n = new E0(e, t);
    return await n.start(), n;
  }
  async start() {
    this.webcamConfig.facingMode && w.assert(this.webcamConfig.facingMode === "user" || this.webcamConfig.facingMode === "environment", () => `Invalid webcam facing mode: ${this.webcamConfig.facingMode}. Please provide 'user' or 'environment'`);
    try {
      this.stream = await navigator.mediaDevices.getUserMedia({ video: { deviceId: this.webcamConfig.deviceId, facingMode: this.webcamConfig.facingMode ? this.webcamConfig.facingMode : "user", width: this.webcamVideoElement.width, height: this.webcamVideoElement.height } });
    } catch (e) {
      throw e.message = `Error thrown while initializing video stream: ${e.message}`, e;
    }
    if (!this.stream)
      throw new Error("Could not obtain video from webcam.");
    try {
      this.webcamVideoElement.srcObject = this.stream;
    } catch (e) {
      console.log(e), this.webcamVideoElement.src = window.URL.createObjectURL(this.stream);
    }
    return this.webcamVideoElement.play(), this.isClosed = false, new Promise((e) => {
      this.webcamVideoElement.onloadedmetadata = () => {
        e();
      };
    });
  }
  async next() {
    if (this.isClosed)
      return { value: null, done: true };
    let e;
    try {
      e = Nk.fromPixels(this.webcamVideoElement);
    } catch (t) {
      throw new Error(`Error thrown converting video to pixels: ${JSON.stringify(t)}`);
    }
    if (this.resize)
      try {
        return { value: this.cropAndResizeFrame(e), done: false };
      } catch (t) {
        throw new Error(`Error thrown cropping the video: ${t.message}`);
      } finally {
        e.dispose();
      }
    else
      return { value: e, done: false };
  }
  needToResize() {
    return !!(this.webcamConfig.resizeWidth && this.webcamConfig.resizeHeight && (this.webcamVideoElement.width !== this.webcamConfig.resizeWidth || this.webcamVideoElement.height !== this.webcamConfig.resizeHeight));
  }
  cropAndResizeFrame(e) {
    return j(() => {
      let t = Pn(ce(e, "float32"), 0), n;
      n = qn.cropAndResize(t, this.cropBox, this.cropBoxInd, this.cropSize, "bilinear");
      let s = n.shape;
      return G(n, s.slice(1));
    });
  }
  async capture() {
    return (await this.next()).value;
  }
  stop() {
    this.stream.getTracks().forEach((t) => t.stop());
    try {
      this.webcamVideoElement.srcObject = null;
    } catch (t) {
      console.log(t), this.webcamVideoElement.src = null;
    }
    this.isClosed = true;
  }
  toArray() {
    throw new Error("Can not convert infinite video stream to array.");
  }
};
var R0 = class {
};
var D0 = class extends Ut {
  split(e) {
    return new aU(this, e);
  }
};
var aU = class extends D0 {
  constructor(e, t) {
    super(), this.upstream = e, this.impl = new iU(e, t);
  }
  summary() {
    return this.impl.summary();
  }
  async next() {
    return this.impl.next();
  }
};
var iU = class extends Qy {
  constructor(e, t) {
    super(), this.upstream = e, this.separator = t, this.carryover = "";
  }
  summary() {
    return `${this.upstream.summary()} -> Split('${this.separator}')`;
  }
  async pump() {
    let e = await this.upstream.next();
    if (e.done)
      return this.carryover === "" ? false : (this.outputQueue.push(this.carryover), this.carryover = "", true);
    let t = e.value.split(this.separator);
    t[0] = this.carryover + t[0];
    for (let n of t.slice(0, -1))
      this.outputQueue.push(n);
    return this.carryover = t[t.length - 1], true;
  }
};
var oU = class extends Ut {
  decodeUTF8() {
    return new uU(this);
  }
};
var uU = class extends D0 {
  constructor(e) {
    super(), this.upstream = e, this.impl = new lU(e);
  }
  summary() {
    return this.impl.summary();
  }
  async next() {
    return this.impl.next();
  }
};
var lU = class extends Qy {
  constructor(e) {
    if (super(), this.upstream = e, X().get("IS_BROWSER"))
      this.decoder = new TextDecoder("utf-8");
    else {
      let { StringDecoder: t } = Ww();
      this.decoder = new t("utf8");
    }
  }
  summary() {
    return `${this.upstream.summary()} -> Utf8`;
  }
  async pump() {
    let e = await this.upstream.next(), t;
    if (e.done)
      return false;
    t = e.value;
    let n;
    return X().get("IS_BROWSER") ? n = this.decoder.decode(t, { stream: true }) : n = this.decoder.write(Buffer.from(t.buffer)), this.outputQueue.push(n), true;
  }
};
var F0 = class extends oU {
  constructor(e, t = {}) {
    super(), this.file = e, this.options = t, w.assert(e instanceof Uint8Array || (X().get("IS_BROWSER") ? e instanceof File || e instanceof Blob : false), () => "FileChunkIterator only supports File, Blob and Uint8Array right now."), this.offset = t.offset || 0, this.chunkSize = t.chunkSize || 1024 * 1024;
  }
  summary() {
    return `FileChunks ${this.file}`;
  }
  async next() {
    return this.offset >= (this.file instanceof Uint8Array ? this.file.byteLength : this.file.size) ? { value: null, done: true } : { value: await new Promise((t, n) => {
      let s = this.offset + this.chunkSize;
      if (this.file instanceof Uint8Array)
        t(new Uint8Array(this.file.slice(this.offset, s)));
      else {
        let r = new FileReader();
        r.onload = (i) => {
          let o = r.result;
          if (o instanceof ArrayBuffer && (o = new Uint8Array(o)), !(o instanceof Uint8Array))
            return n(new TypeError("FileReader returned unknown type."));
          t(o);
        }, r.onabort = (i) => n(new Error("Aborted")), r.onerror = (i) => n(new Error(i.type));
        let a = this.file.slice(this.offset, s);
        r.readAsArrayBuffer(a);
      }
      this.offset = s;
    }), done: false };
  }
};
async function cU(e, t = {}, n) {
  let s, r;
  typeof e == "string" ? s = e : (s = e.url, r = dU(e));
  let a = await (n || w.fetch)(s, r);
  if (a.ok) {
    let i = new Uint8Array(await a.arrayBuffer());
    return new F0(i, t);
  } else
    throw new Error(a.statusText);
}
var dU = (e) => ({ method: e.method, headers: e.headers, body: e.body, mode: e.mode, credentials: e.credentials, cache: e.cache, redirect: e.redirect, referrer: e.referrer, integrity: e.integrity });
function O0(e) {
  return typeof e == "string" && e.slice(0, 7) === "file://";
}
var P0 = class extends R0 {
  constructor(e, t = {}) {
    super(), this.input = e, this.options = t;
  }
  async iterator() {
    if (O0(this.input) && X().get("IS_NODE")) {
      let e = tg();
      this.input = e.readFileSync(this.input.slice(7));
    }
    return new F0(this.input, this.options);
  }
};
var z0 = class extends R0 {
  constructor(e, t = {}) {
    super(), this.url = e, this.fileOptions = t;
  }
  async iterator() {
    return O0(this.url) ? new P0(this.url, this.fileOptions).iterator() : cU(this.url, this.fileOptions);
  }
};
function pU(e, t = {}) {
  return new _0(new z0(e), t);
}
function hU(e) {
  let t = Yy(e);
  return _n(async () => t);
}
function fU(e) {
  return _n(async () => {
    let t = await e();
    return Yy(() => t.next());
  });
}
async function mU(e, t) {
  return E0.create(e, t);
}
async function gU(e) {
  return A0.create(e);
}
var bU = "0.0.0";
function be(e, t) {
  Array.isArray(e) || (e = [e]), e.forEach((n) => {
    n != null && w.assert(n.dtype !== "complex64", () => `${t} does not support complex64 tensors in the CPU backend.`);
  });
}
var yU = xs.whereImpl;
var M0 = class extends nl {
  constructor() {
    super(), this.blockSize = 48, this.firstUse = true, this.data = new Ud(this, Ss());
  }
  nextDataId() {
    return M0.nextDataId++;
  }
  write(e, t, n) {
    this.firstUse && (this.firstUse = false, X().get("IS_NODE") && S.warn(`
============================
Hi there \u{1F44B}. Looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, which binds to TensorFlow C++, by running npm i @tensorflow/tfjs-node, or npm i @tensorflow/tfjs-node-gpu if you have CUDA. Then call require('@tensorflow/tfjs-node'); (-gpu suffix for CUDA) at the start of your program. Visit https://github.com/tensorflow/tfjs-node for more details.
============================`));
    let s = { id: this.nextDataId() };
    return this.data.set(s, { values: e, dtype: n, refCount: 1 }), s;
  }
  makeTensorInfo(e, t, n) {
    let s;
    if (t === "string" && n != null && n.length > 0 && w.isString(n[0])) {
      let r = n.map((a) => w.encodeString(a));
      s = this.write(r, e, t);
    } else
      s = this.write(n, e, t);
    return { dataId: s, shape: e, dtype: t };
  }
  refCount(e) {
    return this.data.has(e) ? this.data.get(e).refCount : 0;
  }
  incRef(e) {
    let t = this.data.get(e);
    t.refCount++;
  }
  decRef(e) {
    if (this.data.has(e)) {
      let t = this.data.get(e);
      t.refCount--;
    }
  }
  move(e, t, n, s, r) {
    this.data.set(e, { values: t, dtype: s, refCount: r });
  }
  numDataIds() {
    return this.data.numDataIds();
  }
  async read(e) {
    return this.readSync(e);
  }
  readSync(e) {
    let { dtype: t, complexTensorInfos: n } = this.data.get(e);
    if (t === "complex64") {
      let s = this.readSync(n.real.dataId), r = this.readSync(n.imag.dataId);
      return S.mergeRealAndImagArrays(s, r);
    }
    return this.data.get(e).values;
  }
  bufferSync(e) {
    let t = this.readSync(e.dataId), n = t;
    if (e.dtype === "string")
      try {
        n = t.map((s) => w.decodeString(s));
      } catch (s) {
        throw new Error("Failed to decode encoded string bytes into utf-8");
      }
    return De(e.shape, e.dtype, n);
  }
  makeOutput(e, t, n) {
    let s = this.write(e, t, n);
    return Ss().makeTensorFromDataId(s, t, n, this);
  }
  disposeData(e, t = false) {
    if (this.data.has(e)) {
      if (this.data.get(e).refCount--, !t && this.data.get(e).refCount > 0)
        return false;
      let { complexTensorInfos: n } = this.data.get(e);
      n != null && (this.disposeData(n.real.dataId, true), this.disposeData(n.imag.dataId, true)), this.data.delete(e);
    }
    return true;
  }
  disposeIntermediateTensorInfo(e) {
    this.disposeData(e.dataId);
  }
  async time(e) {
    let t = w.now();
    return e(), { kernelMs: w.now() - t };
  }
  memory() {
    return { unreliable: true, reasons: ["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."] };
  }
  where(e) {
    be([e], "where");
    let t = this.readSync(e.dataId);
    return yU(e.shape, t);
  }
  dispose() {
  }
  floatPrecision() {
    return 32;
  }
  epsilon() {
    return super.epsilon();
  }
};
var L0 = M0;
L0.nextDataId = 0;
var Zy = {};
Ae(Zy, { addImpl: () => V0, bincountImpl: () => ev, bincountReduceImpl: () => W0, ceilImpl: () => U0, concatImpl: () => tv, equalImpl: () => G0, expImpl: () => q0, expm1Impl: () => K0, floorImpl: () => X0, gatherNdImpl: () => Y0, gatherV2Impl: () => Q0, greaterEqualImpl: () => J0, greaterImpl: () => Z0, lessEqualImpl: () => tC, lessImpl: () => eC, linSpaceImpl: () => nC, logImpl: () => sC, maxImpl: () => rC, maximumImpl: () => aC, minimumImpl: () => iC, multiplyImpl: () => nv, negImpl: () => oC, notEqualImpl: () => uC, prodImpl: () => lC, rangeImpl: () => rv, rsqrtImpl: () => cC, sigmoidImpl: () => iG, simpleAbsImpl: () => B0, sliceImpl: () => Fd, sparseFillEmptyRowsImpl: () => pC, sparseReshapeImpl: () => hC, sparseSegmentReductionImpl: () => av, sqrtImpl: () => lG, squaredDifferenceImpl: () => fC, stridedSliceImpl: () => mC, stringNGramsImpl: () => gC, stringSplitImpl: () => bC, stringToHashBucketFastImpl: () => yC, subImpl: () => vC, tileImpl: () => xC, topKImpl: () => kC, transposeImpl: () => sv, uniqueImpl: () => IC });
function B0(e) {
  let t = new Float32Array(e.length);
  for (let n = 0; n < e.length; ++n)
    t[n] = Math.abs(e[n]);
  return t;
}
var vU = (e) => {
  let { x: t } = e.inputs, n = e.backend;
  be(t, "abs");
  let s = new Float32Array(w.sizeFromShape(t.shape)), r = n.data.get(t.dataId).values;
  return s = B0(r), n.makeOutput(s, t.shape, t.dtype);
};
var xU = { kernelName: io, backendName: "cpu", kernelFunc: vU };
function At(e) {
  return (t, n, s, r, a) => {
    let i = S.assertAndGetBroadcastShape(t, n), o = i.length, u = w.computeStrides(i), l = w.sizeFromShape(i), c = w.getTypedArrayFromDType(a, l), p = t.length, d = n.length, h = w.computeStrides(t), f = w.computeStrides(n), m = S.getBroadcastDims(t, i), g = S.getBroadcastDims(n, i);
    if (m.length + g.length === 0)
      for (let b = 0; b < c.length; ++b)
        c[b] = e(s[b % s.length], r[b % r.length]);
    else
      for (let b = 0; b < c.length; ++b) {
        let y = w.indexToLoc(b, o, u), v = y.slice(-p);
        m.forEach((N) => v[N] = 0);
        let x = w.locToIndex(v, p, h), k = y.slice(-d);
        g.forEach((N) => k[N] = 0);
        let T = w.locToIndex(k, d, f);
        c[b] = e(s[x], r[T]);
      }
    return [c, i];
  };
}
function Rn(e) {
  let { inputs: t, backend: n } = e, { real: s, imag: r } = t, a = n.data.get(s.dataId).values, i = n.data.get(r.dataId).values, o = n.makeTensorInfo(s.shape, "complex64"), u = n.data.get(o.dataId);
  return u.complexTensorInfos = { real: n.makeTensorInfo(s.shape, "float32", a), imag: n.makeTensorInfo(r.shape, "float32", i) }, o;
}
var wU = { kernelName: jd, backendName: "cpu", kernelFunc: Rn };
function Dd(e, t, n = "float32") {
  if (n === "complex64") {
    let r = Dd(e, t, "float32"), a = Dd(e, t, "float32");
    return Rn({ inputs: { real: r, imag: a }, backend: e });
  }
  let s = w.makeZerosTypedArray(w.sizeFromShape(t), n);
  return e.makeTensorInfo(t, n, s);
}
function Os(e) {
  let { inputs: t, backend: n } = e, { x: s } = t;
  return n.incRef(s.dataId), { dataId: s.dataId, shape: s.shape, dtype: s.dtype };
}
var kU = { kernelName: Ba, backendName: "cpu", kernelFunc: Os };
function ma(e) {
  let { inputs: t, backend: n } = e, { input: s } = t, r = n.data.get(s.dataId).complexTensorInfos.real, a = n.data.get(r.dataId).values;
  return n.makeTensorInfo(r.shape, r.dtype, a);
}
var IU = { kernelName: np, backendName: "cpu", kernelFunc: ma };
function xr(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { dtype: a } = s;
  if (a === "complex64") {
    if (r.dtype === "complex64")
      return Os({ inputs: { x: r }, backend: n });
    let i = Dd(n, r.shape, r.dtype), o = xr({ inputs: { x: r }, backend: n, attrs: { dtype: "float32" } }), u = Rn({ inputs: { real: o, imag: i }, backend: n });
    return n.disposeIntermediateTensorInfo(i), n.disposeIntermediateTensorInfo(o), u;
  }
  if (r.dtype === "complex64") {
    let i = ma({ inputs: { input: r }, backend: n }), o = xr({ inputs: { x: i }, backend: n, attrs: { dtype: a } });
    return n.disposeIntermediateTensorInfo(i), o;
  }
  if (!w.hasEncodingLoss(r.dtype, a)) {
    let i = Os({ inputs: { x: r }, backend: n });
    return { dataId: i.dataId, shape: i.shape, dtype: a };
  }
  if (a === "int32") {
    let i = n.data.get(r.dataId).values, o = Int32Array.from(i);
    return n.makeTensorInfo(r.shape, "int32", o);
  }
  if (a === "bool") {
    let i = n.data.get(r.dataId).values, o = w.toTypedArray([0], r.dtype), [u, l] = At((c, p) => c !== p ? 1 : 0)(r.shape, [], i, o, "bool");
    return n.makeTensorInfo(l, "bool", u);
  }
  throw new Error(`Error in Cast: failed to cast ${r.dtype} to ${a}`);
}
var SU = { kernelName: Na, backendName: "cpu", kernelFunc: xr };
function Gt(e, t, n, s) {
  return n == null ? ({ inputs: r, backend: a }) => {
    let { a: i, b: o } = r, u = a;
    be([i, o], e);
    let l = u.data.get(i.dataId).values, c = u.data.get(o.dataId).values, p = i.dtype === "string" ? S.fromUint8ToStringArray(l) : l, d = i.dtype === "string" ? S.fromUint8ToStringArray(c) : c, h = s || i.dtype, [f, m] = t(i.shape, o.shape, p, d, h);
    return u.makeTensorInfo(m, h, f);
  } : ({ inputs: r, backend: a }) => {
    let { a: i, b: o } = r, u = a;
    if (i.dtype === "complex64" || o.dtype === "complex64") {
      let l = xr({ inputs: { x: i }, backend: u, attrs: { dtype: "complex64" } }), c = u.data.get(l.dataId), p = c.complexTensorInfos.real, d = c.complexTensorInfos.imag, h = u.data.get(p.dataId).values, f = u.data.get(d.dataId).values, m = xr({ inputs: { x: o }, backend: u, attrs: { dtype: "complex64" } }), g = u.data.get(m.dataId), b = g.complexTensorInfos.real, y = g.complexTensorInfos.imag, v = u.data.get(b.dataId).values, x = u.data.get(y.dataId).values, [k, T, N] = n(i.shape, o.shape, h, f, v, x), E = u.makeTensorInfo(N, "float32", k), A = u.makeTensorInfo(N, "float32", T), P = Rn({ inputs: { real: E, imag: A }, backend: u });
      return u.disposeIntermediateTensorInfo(l), u.disposeIntermediateTensorInfo(m), u.disposeIntermediateTensorInfo(E), u.disposeIntermediateTensorInfo(A), P;
    } else {
      let l = u.data.get(i.dataId).values, c = u.data.get(o.dataId).values, p = s || i.dtype, [d, h] = t(i.shape, o.shape, l, c, p);
      return u.makeTensorInfo(h, p, d);
    }
  };
}
function Jy(e) {
  return (t, n, s, r, a, i) => {
    let o = S.assertAndGetBroadcastShape(t, n), u = w.sizeFromShape(o), l = o.length, c = w.computeStrides(o), p = w.getTypedArrayFromDType("float32", u), d = w.getTypedArrayFromDType("float32", u), h = S.getBroadcastDims(t, o), f = S.getBroadcastDims(n, o), m = S.mergeRealAndImagArrays(s, r), g = S.mergeRealAndImagArrays(a, i), b = t.length, y = w.computeStrides(t), v = n.length, x = w.computeStrides(n);
    if (h.length + f.length === 0)
      for (let k = 0; k < p.length; k++) {
        let T = k % m.length, N = k % g.length, E = e(m[T * 2], m[T * 2 + 1], g[N * 2], g[N * 2 + 1]);
        p[k] = E.real, d[k] = E.imag;
      }
    else
      for (let k = 0; k < p.length; k++) {
        let T = w.indexToLoc(k, l, c), N = T.slice(-b);
        h.forEach((F) => N[F] = 0);
        let E = w.locToIndex(N, b, y), A = T.slice(-v);
        f.forEach((F) => A[F] = 0);
        let P = w.locToIndex(A, v, x), R = e(m[E * 2], m[E * 2 + 1], g[P * 2], g[P * 2 + 1]);
        p[k] = R.real, d[k] = R.imag;
      }
    return [p, d, o];
  };
}
var V0 = At((e, t) => e + t);
var CU = Jy((e, t, n, s) => ({ real: e + n, imag: t + s }));
var Kl = Gt(Ir, V0, CU);
var NU = { kernelName: Ir, backendName: "cpu", kernelFunc: Kl };
function ev(e, t, n, s, r) {
  let a = w.sizeFromShape(s), i = w.makeZerosTypedArray(r, n);
  for (let o = 0; o < e.length; o++) {
    let u = e[o];
    if (u < 0)
      throw new Error("Input x must be non-negative!");
    u >= r || (a > 0 ? i[u] += t[o] : i[u] += 1);
  }
  return i;
}
function W0(e, t, n, s = false) {
  let r = e.shape[0], a = e.shape[1], i = De([r, n], t.dtype);
  for (let o = 0; o < r; o++)
    for (let u = 0; u < a; u++) {
      let l = e.get(o, u);
      if (l < 0)
        throw new Error("Input x must be non-negative!");
      l >= n || (s ? i.set(1, o, l) : t.size > 0 ? i.set(i.get(o, l) + t.get(o, u), o, l) : i.set(i.get(o, l) + 1, o, l));
    }
  return i;
}
function Er(e) {
  return (t, n, s) => {
    let r = w.getTypedArrayFromDType(n, t.length);
    for (let a = 0; a < t.length; ++a)
      r[a] = e(t[a], s);
    return r;
  };
}
function st(e, t, n) {
  return ({ inputs: s, attrs: r, backend: a }) => {
    let { x: i } = s;
    if (be(i, e), i.dtype === "string" || n === "string")
      throw new Error("unaryKernelFunc does not support string input/output");
    let o = a, u = o.data.get(i.dataId).values, l = w.sizeFromShape(i.shape), c = n || i.dtype, p = w.getArrayFromDType(c, l);
    for (let d = 0; d < l; ++d)
      p[d] = t(u[d], r);
    return o.makeTensorInfo(i.shape, c, p);
  };
}
function eu(e, t, n) {
  return ({ inputs: s, attrs: r, backend: a }) => {
    let { x: i } = s;
    if (be(i, e), i.dtype === "string" || n === "string")
      throw new Error("unaryKernelFunc does not support string input/output");
    let o = a, u = o.data.get(i.dataId).values, l = n || i.dtype, c = t(u, l, r);
    return o.makeTensorInfo(i.shape, l, c);
  };
}
var U0 = Er((e) => Math.ceil(e));
var TU = eu(Ta, U0);
var $U = { kernelName: Ta, backendName: "cpu", kernelFunc: TU };
function tv(e, t, n, s) {
  let r = w.getArrayFromDType(n, w.sizeFromShape(t));
  if (s && n !== "string") {
    let a = 0;
    e.forEach((i) => {
      let o = w.sizeFromShape(i.shape);
      r.set(i.vals, a), a += o;
    });
  } else {
    let a = 0;
    e.forEach((i) => {
      let o = n === "string" ? S.fromUint8ToStringArray(i.vals) : i.vals, u = 0;
      for (let l = 0; l < i.shape[0]; ++l) {
        let c = l * t[1] + a;
        for (let p = 0; p < i.shape[1]; ++p)
          r[c + p] = o[u++];
      }
      a += i.shape[1];
    });
  }
  return r;
}
var G0 = At((e, t) => e === t ? 1 : 0);
var H0 = Gt(ho, G0, null, "bool");
var _U = { kernelName: ho, backendName: "cpu", kernelFunc: H0 };
var q0 = Er((e) => Math.exp(e));
var j0 = eu(Oa, q0, "float32");
var AU = { kernelName: Oa, backendName: "cpu", kernelFunc: j0 };
var K0 = Er((e) => Math.expm1(e));
var EU = eu(mo, K0);
var RU = { kernelName: mo, backendName: "cpu", kernelFunc: EU };
var X0 = Er((e) => Math.floor(e));
var DU = eu(Pa, X0);
var FU = { kernelName: Pa, backendName: "cpu", kernelFunc: DU };
function Y0(e, t, n, s, r, a, i, o, u) {
  let l = De([s, a], n);
  for (let c = 0; c < s; c++) {
    let p = [], d = 0;
    for (let h = 0; h < r; h++) {
      let f = e[c * r + h];
      d += f * i[h], p.push(f);
    }
    if (d < 0 || d >= u / a)
      throw new Error(`Invalid indices: ${p} does not index into ${o}`);
    for (let h = 0; h < a; h++)
      l.values[c * a + h] = t.get(...t.indexToLoc(d * a + h));
  }
  return l;
}
function Q0(e, t, n) {
  let s = De(n, e.dtype);
  for (let r = 0; r < s.size; ++r) {
    let i = s.indexToLoc(r).slice(), o = i[0], u = i[2], l = t.locToIndex([o, u]);
    i[2] = t.values[l];
    let c = e.locToIndex(i);
    0 <= c && c < e.values.length && (s.values[r] = e.values[c]);
  }
  return s;
}
var Z0 = At((e, t) => e > t ? 1 : 0);
var OU = Gt(vo, Z0, null, "bool");
var PU = { kernelName: vo, backendName: "cpu", kernelFunc: OU };
var J0 = At((e, t) => e >= t ? 1 : 0);
var zU = Gt(La, J0, null, "bool");
var MU = { kernelName: La, backendName: "cpu", kernelFunc: zU };
var eC = At((e, t) => e < t ? 1 : 0);
var LU = Gt(xo, eC, null, "bool");
var BU = { kernelName: xo, backendName: "cpu", kernelFunc: LU };
var tC = At((e, t) => e <= t ? 1 : 0);
var VU = Gt(wo, tC, null, "bool");
var WU = { kernelName: wo, backendName: "cpu", kernelFunc: VU };
function nC(e, t, n) {
  let s = (t - e) / (n - 1), r = w.makeZerosTypedArray(n, "float32");
  r[0] = e;
  for (let a = 1; a < r.length; a++)
    r[a] = r[a - 1] + s;
  return r;
}
var sC = Er((e) => Math.log(e));
var UU = eu(Wa, sC);
var GU = { kernelName: Wa, backendName: "cpu", kernelFunc: UU };
function rC(e, t, n, s) {
  let r = w.getTypedArrayFromDType(s, w.sizeFromShape(n));
  for (let a = 0; a < r.length; ++a) {
    let i = a * t, o = e[i];
    for (let u = 0; u < t; ++u) {
      let l = e[i + u];
      (Number.isNaN(l) || l > o) && (o = l);
    }
    r[a] = o;
  }
  return r;
}
var aC = At((e, t) => Math.max(e, t));
var HU = Gt(Ga, aC);
var qU = { kernelName: Ga, backendName: "cpu", kernelFunc: HU };
var iC = At((e, t) => Math.min(e, t));
var jU = Gt(Ka, iC);
var KU = { kernelName: Ka, backendName: "cpu", kernelFunc: jU };
var nv = At((e, t) => e * t);
var XU = Jy((e, t, n, s) => ({ real: e * n - t * s, imag: e * s + t * n }));
var Hp = Gt(Ya, nv, XU);
var YU = { kernelName: Ya, backendName: "cpu", kernelFunc: Hp };
function oC(e, t, n) {
  let s = w.createScalarValue(-1, n);
  return nv([], t, s, e, n);
}
function QU(e) {
  let { inputs: t, backend: n } = e, { x: s } = t;
  be(s, "neg");
  let r = n.data.get(s.dataId).values, [a, i] = oC(r, s.shape, s.dtype);
  return n.makeTensorInfo(i, s.dtype, a);
}
var ZU = { kernelName: Io, backendName: "cpu", kernelFunc: QU };
var uC = At((e, t) => e !== t ? 1 : 0);
var JU = Gt(So, uC, null, "bool");
var eG = { kernelName: So, backendName: "cpu", kernelFunc: JU };
function sv(e, t, n, s, r) {
  let a = t.length, i = w.sizeFromShape(t), o = w.computeStrides(t), u = w.computeStrides(r), l = w.getTypedArrayFromDType(n, w.sizeFromShape(r));
  for (let c = 0; c < i; ++c) {
    let p = w.indexToLoc(c, a, o), d = new Array(p.length);
    for (let f = 0; f < d.length; f++)
      d[f] = p[s[f]];
    let h = w.locToIndex(d, a, u);
    l[h] = e[c];
  }
  return l;
}
function wn(e) {
  let { inputs: t, attrs: n, backend: s } = e, { x: r } = t, { perm: a } = n;
  be(r, "transpose");
  let i = r.shape.length, o = new Array(i);
  for (let p = 0; p < o.length; p++)
    o[p] = r.shape[a[p]];
  let u = s.data.get(r.dataId).values, l = sv(u, r.shape, r.dtype, a, o);
  return { dataId: s.write(l, o, r.dtype), shape: o, dtype: r.dtype };
}
var tG = { kernelName: pi, backendName: "cpu", kernelFunc: wn };
function lC(e, t, n, s) {
  let [r, a] = S.computeOutAndReduceShapes(e, s), i = cn(t, "int32"), o = w.makeZerosTypedArray(w.sizeFromShape(r), i), u = w.sizeFromShape(a);
  for (let l = 0; l < o.length; ++l) {
    let c = l * u, p = 1;
    for (let d = 0; d < u; ++d)
      p *= n[c + d];
    o[l] = p;
  }
  return { outVals: o, outShape: r, outDtype: i };
}
function nG(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { axis: a, keepDims: i } = s;
  be(r, "prod");
  let o = r.shape.length, u = w.parseAxisParam(a, r.shape), l = S.getAxesPermutation(u, o), c = u, p = r, d = [];
  l != null && (p = wn({ inputs: { x: r }, backend: n, attrs: { perm: l } }), d.push(p), c = S.getInnerMostAxes(c.length, o));
  let h = n.data.get(p.dataId).values, { outVals: f, outShape: m, outDtype: g } = lC(p.shape, p.dtype, h, c), b = m;
  return i && (b = S.expandShapeToKeepDim(m, u)), d.forEach((y) => n.disposeIntermediateTensorInfo(y)), n.makeTensorInfo(b, g, f);
}
var sG = { kernelName: Ao, backendName: "cpu", kernelFunc: nG };
function rv(e, t, n, s) {
  let r = e === t, a = e < t && n < 0, i = t < e && n > 1;
  if (r || a || i)
    return w.makeZerosTypedArray(0, s);
  let o = Math.abs(Math.ceil((t - e) / n)), u = w.makeZerosTypedArray(o, s);
  t < e && n === 1 && (n = -1), u[0] = e;
  for (let l = 1; l < u.length; l++)
    u[l] = u[l - 1] + n;
  return u;
}
var cC = Er((e) => 1 / Math.sqrt(e));
var rG = eu(si, cC);
var aG = { kernelName: si, backendName: "cpu", kernelFunc: rG };
var iG = Er((e) => 1 / (1 + Math.exp(-e)));
var dC = st(ai, (e) => 1 / (1 + Math.exp(-e)));
var oG = { kernelName: ai, backendName: "cpu", kernelFunc: dC };
function Fd(e, t, n, s, r) {
  let a = wt.isSliceContinous(s, t, n), i = w.sizeFromShape(n), o = w.computeStrides(s);
  if (a) {
    let p = wt.computeFlatOffset(t, o);
    return r === "string" ? e.slice(p, p + i) : e.subarray(p, p + i);
  }
  let u = r === "string" ? S.fromUint8ToStringArray(e) : e, l = De(s, r, u), c = De(n, r);
  for (let p = 0; p < c.size; ++p) {
    let d = c.indexToLoc(p), h = d.map((f, m) => f + t[m]);
    c.set(l.get(...h), ...d);
  }
  return r === "string" ? S.fromStringArrayToUint8(c.values) : c.values;
}
function ga(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { begin: a, size: i } = s;
  be(r, "slice");
  let [o, u] = wt.parseSliceParams(r, a, i);
  wt.assertParamsValid(r, o, u);
  let l = n.data.get(r.dataId).values, c = Fd(l, o, u, r.shape, r.dtype);
  return n.makeTensorInfo(u, r.dtype, c);
}
var uG = { kernelName: Po, backendName: "cpu", kernelFunc: ga };
function pC(e, t, n, s, r, a, i) {
  let o = t[0], u = a[0], l = new Array(u), c = new Array(o), p = t[1];
  if (u === 0) {
    if (o !== 0)
      throw new Error(S.getSparseFillEmptyRowsIndicesDenseShapeMismatch(o));
    let g = w.getArrayFromDType(n, 0), b = w.getArrayFromDType(r, 0);
    return [g, [0, p], b, l, c];
  }
  let d = true, h = 0, f = new Array(u).fill(0);
  for (let g = 0; g < o; ++g) {
    let b = e[g * p];
    if (b < 0)
      throw new Error(S.getSparseFillEmptyRowsNegativeIndexErrorMessage(g, b));
    if (b >= u)
      throw new Error(S.getSparseFillEmptyRowsOutOfRangeIndexErrorMessage(g, b, u));
    ++f[b], d = d && b >= h, h = b;
  }
  let m = true;
  for (let g = 0; g < u; ++g) {
    let b = f[g] === 0;
    l[g] = b, m = m && !b, f[g] = Math.max(f[g], 1), g > 0 && (f[g] += f[g - 1]);
  }
  if (m && d) {
    let g = e, b = s;
    for (let y = 0; y < o; ++y)
      c[y] = y;
    return [g, [o, p], b, l, c];
  } else {
    let g = f[u - 1], b = w.getArrayFromDType(n, g * p), y = w.getArrayFromDType(r, g), v = new Array(u).fill(0);
    for (let x = 0; x < o; ++x) {
      let k = e[x * p], T = v[k], N = (k === 0 ? 0 : f[k - 1]) + T;
      v[k]++;
      for (let E = 0; E < p; ++E)
        b[N * p + E] = e[x * p + E];
      y[N] = s[x], c[x] = N;
    }
    for (let x = 0; x < u; ++x)
      if (v[x] === 0) {
        let T = x === 0 ? 0 : f[x - 1];
        b[T * p + 0] = x;
        for (let N = 1; N < p; ++N)
          b[T * p + N] = 0;
        y[T] = i;
      }
    return [b, [g, p], y, l, c];
  }
}
function hC(e, t, n, s, r) {
  let a = w.sizeFromShape(s), i = t[0], o = r.length, u = [], l = 1, c = -1;
  for (let g = 0; g < o; ++g) {
    let b = r[g];
    if (b === -1) {
      if (c !== -1)
        throw new Error(S.getSparseReshapeMultipleNegativeOneOutputDimErrorMessage(c, g));
      c = g, u.push(1);
    } else {
      if (b < 0)
        throw new Error(S.getSparseReshapeNegativeOutputDimErrorMessage(g, b));
      l *= b, u.push(b);
    }
  }
  if (c !== -1) {
    if (l <= 0)
      throw new Error(S.getSparseReshapeEmptyTensorZeroOutputDimErrorMessage());
    let g = Math.trunc(a / l);
    if (l * g !== a)
      throw new Error(S.getSparseReshapeInputOutputMultipleErrorMessage(s, u));
    u[c] = g;
  }
  if (w.sizeFromShape(u) !== a)
    throw new Error(S.getSparseReshapeInputOutputMismatchErrorMessage(s, u));
  let d = s.length, h = [];
  if (d > 0) {
    h[d - 1] = 1;
    for (let g = d - 2; g >= 0; --g)
      h[g] = h[g + 1] * s[g + 1];
  }
  let f = [];
  if (o > 0) {
    f[o - 1] = 1;
    for (let g = o - 2; g >= 0; --g)
      f[g] = f[g + 1] * u[g + 1];
  }
  let m = w.getArrayFromDType(n, i * o);
  for (let g = 0; g < i; ++g) {
    let b = 0;
    for (let y = 0; y < d; ++y)
      b += e[g * d + y] * h[y];
    for (let y = 0; y < o; ++y)
      m[g * o + y] = Math.trunc(b / f[y]), b %= f[y];
  }
  return [m, [i, o], u];
}
function av(e, t, n, s, r, a = false, i = 0) {
  let o = s.length, u = [t[0], e.length / t[0]], l = u[1], p = o > 0 ? r[o - 1] + 1 : 0;
  if (p < 0)
    throw new Error(S.getSparseSegmentReductionNegativeSegmentIdsErrorMessage());
  let d = t.slice();
  d[0] = p;
  let h = d.reduce((v, x) => v * x, 1), f = w.getArrayFromDType(n, h);
  if (o === 0)
    return p > 0 && f.fill(i), [f, d];
  if (p <= 0)
    throw new Error(S.getSparseSegmentReductionNegativeSegmentIdsErrorMessage());
  let m = 0, g = 1, b = 0, y = r[m];
  for (; ; ) {
    let v = 0;
    if (g < o) {
      if (v = r[g], y === v) {
        ++g;
        continue;
      }
      if (y >= v)
        throw new Error(S.getSparseSegmentReductionNonIncreasingSegmentIdsErrorMessage());
    }
    if (y < 0 || y >= p)
      throw new Error(S.getSparseSegmentReductionSegmentIdOutOfRangeErrorMessage(y, p));
    y > b && f.fill(i, b * l, y * l);
    for (let x = m; x < g; ++x) {
      let k = s[x];
      if (k < 0 || k >= u[0])
        throw new Error(S.getSparseSegmentReductionIndicesOutOfRangeErrorMessage(x, s[x], u[0]));
      for (let T = 0; T < l; T++)
        f[y * l + T] += e[k * l + T];
    }
    if (a)
      for (let x = 0; x < l; x++)
        f[y * l + x] /= g - m;
    if (m = g, ++g, b = y + 1, y = v, g > o)
      break;
  }
  return b < p && f.fill(i, b * l, p * l), [f, d];
}
var lG = Er((e) => Math.sqrt(e));
var cG = st(ii, (e) => Math.sqrt(e));
var dG = { kernelName: ii, backendName: "cpu", kernelFunc: cG };
var fC = At((e, t) => {
  let n = e - t;
  return n * n;
});
var pG = Gt(li, fC);
var hG = { kernelName: li, backendName: "cpu", kernelFunc: pG };
function mC(e, t, n, s) {
  let r = De(e, t.dtype);
  for (let a = 0; a < r.size; a++) {
    let i = r.indexToLoc(a), o = new Array(i.length);
    for (let u = 0; u < o.length; u++)
      o[u] = i[u] * n[u] + s[u];
    r.set(t.get(...o), ...i);
  }
  return r;
}
var fG = class {
  constructor(e, t, n, s, r, a) {
    this.separator = w.encodeString(e), this.nGramWidths = t, this.leftPad = w.encodeString(n), this.rightPad = w.encodeString(s), this.padWidth = r, this.preserveShort = a;
  }
  getPadWidth(e) {
    return Math.min(this.padWidth < 0 ? e - 1 : this.padWidth, e - 1);
  }
  getNumNGrams(e, t) {
    let n = this.getPadWidth(t);
    return Math.max(0, e + 2 * n - t + 1);
  }
  createNGrams(e, t, n, s, r, a) {
    for (let i = 0; i < r; ++i) {
      let o = this.getPadWidth(a), u = Math.max(0, o - i), l = Math.max(0, o - (r - (i + 1))), c = a - (u + l), p = t + (u > 0 ? 0 : i - o), d = 0;
      d += u * this.leftPad.length;
      for (let b = 0; b < c; ++b)
        d += e[p + b].length;
      d += l * this.rightPad.length, d += (u + l + c - 1) * this.separator.length, n[s + i] = new Uint8Array(d);
      let f = n[s + i], m = 0, g = (b) => b.forEach((y) => f[m++] = y);
      for (let b = 0; b < u; ++b)
        g(this.leftPad), g(this.separator);
      for (let b = 0; b < c - 1; ++b)
        g(e[p + b]), g(this.separator);
      if (c > 0) {
        g(e[p + c - 1]);
        for (let b = 0; b < l; ++b)
          g(this.separator), g(this.rightPad);
      } else {
        for (let b = 0; b < l - 1; ++b)
          g(this.rightPad), g(this.separator);
        g(this.rightPad);
      }
    }
  }
  compute(e, t) {
    let n = e.length, s = t.length;
    if (s > 0) {
      let o = t[0];
      if (o !== 0)
        throw new Error(`First split value must be 0, got ${o}`);
      for (let u = 1; u < s; ++u) {
        let l = t[u] >= o;
        if (l = l && t[u] <= n, !l)
          throw new Error(`Invalid split value ${t[u]}, must be in [${o}, ${n}]`);
        o = t[u];
      }
      if (o !== n)
        throw new Error(`Last split value must be data size. Expected ${n}, got ${o}`);
    }
    let r = s - 1, a = w.getArrayFromDType("int32", s);
    if (n === 0 || s === 0) {
      let o = new Array(n);
      for (let u = 0; u <= r; ++u)
        a[u] = 0;
      return [o, a];
    }
    a[0] = 0;
    for (let o = 1; o <= r; ++o) {
      let u = t[o] - t[o - 1], l = 0;
      this.nGramWidths.forEach((c) => {
        l += this.getNumNGrams(u, c);
      }), this.preserveShort && u > 0 && l === 0 && (l = 1), a[o] = a[o - 1] + l;
    }
    let i = new Array(a[r]);
    for (let o = 0; o < r; ++o) {
      let u = t[o], l = a[o];
      if (this.nGramWidths.forEach((c) => {
        let p = t[o + 1] - t[o], d = this.getNumNGrams(p, c);
        this.createNGrams(e, u, i, l, d, c), l += d;
      }), this.preserveShort && l === a[o]) {
        let c = t[o + 1] - t[o];
        if (c === 0)
          continue;
        let p = c + 2 * this.padWidth, d = 1;
        this.createNGrams(e, u, i, l, d, p);
      }
    }
    return [i, a];
  }
};
function gC(e, t, n, s, r, a, i, o) {
  return new fG(n, s, r, a, i, o).compute(e, t);
}
function mG(e, t, n, s) {
  if (!e.length)
    return;
  if (t.length === 0) {
    for (let a = 0; a < e.length; ++a)
      s.push(e.subarray(a, a + 1));
    return;
  }
  if (t.length === 1) {
    let a = t[0], i = e.indexOf(a);
    for (; i !== -1; ) {
      let o = e.subarray(0, i);
      (!n || o.length !== 0) && s.push(o), e = e.subarray(i + 1), i = e.indexOf(a);
    }
    (!n || e.length !== 0) && s.push(e);
    return;
  }
  let r = 0;
  for (let a = 0; a < e.length + 1; a++)
    if (a === e.length || t.indexOf(e[a]) !== -1) {
      let i = e.subarray(r, a);
      (!n || i.length !== 0) && s.push(i), r = a + 1;
    }
}
function bC(e, t, n) {
  let s = e.length, r = [], a = 0, i = 0, o = new Array(s);
  for (let d = 0; d < s; ++d) {
    let h = r.length;
    mG(e[d], t, n, r);
    let f = r.length - h;
    o[d] = f, a += f, i = Math.max(i, f);
  }
  let u = w.getArrayFromDType("int32", a * 2), l = new Array(a), c = [s, i], p = 0;
  for (let d = 0; d < s; ++d)
    for (let h = 0; h < o[d]; ++h)
      u[p * 2] = d, u[p * 2 + 1] = h, l[p] = r[p], ++p;
  return [u, l, c];
}
function yC(e, t) {
  let n = w.getArrayFromDType("int32", e.length);
  for (let s = 0; s < e.length; ++s)
    n[s] = w.fingerPrint64(e[s]).modulo(t).getLowBitsUnsigned();
  return n;
}
var vC = At((e, t) => e - t);
var gG = Jy((e, t, n, s) => ({ real: e - n, imag: t - s }));
var iv = Gt(ci, vC, gG);
var bG = { kernelName: ci, backendName: "cpu", kernelFunc: iv };
function xC(e, t) {
  let n = new Array(e.rank);
  for (let r = 0; r < n.length; r++)
    n[r] = e.shape[r] * t[r];
  let s = De(n, e.dtype);
  for (let r = 0; r < s.values.length; ++r) {
    let a = s.indexToLoc(r), i = new Array(e.rank);
    for (let u = 0; u < i.length; u++)
      i[u] = a[u] % e.shape[u];
    let o = e.locToIndex(i);
    s.values[r] = e.values[o];
  }
  return s;
}
var Ru = (e, t) => {
  let n = t.value - e.value;
  return n === 0 ? e.index - t.index : n;
};
function wC(e, t, n = 0, s = e.length - 1) {
  for (; s > n; ) {
    if (s - n > 600) {
      let o = s - n + 1, u = t - n + 1, l = Math.log(o), c = 0.5 * Math.exp(2 * l / 3), p = 0.5 * Math.sqrt(l * c * (o - c) / o) * Math.sign(u - o / 2), d = Math.max(n, Math.floor(t - u * c / o + p)), h = Math.min(s, Math.floor(t + (o - u) * c / o + p));
      wC(e, t, d, h);
    }
    let r = e[t], a = n, i = s;
    for (w.swap(e, n, t), Ru(e[s], r) > 0 && w.swap(e, n, s); a < i; ) {
      for (w.swap(e, a, i), a++, i--; Ru(e[a], r) < 0; )
        a = a + 1;
      for (; Ru(e[i], r) > 0; )
        i = i - 1;
    }
    Ru(e[n], r) === 0 ? w.swap(e, n, i) : (i = i + 1, w.swap(e, i, s)), i <= t && (n = i + 1), t <= i && (s = i - 1);
  }
}
function kC(e, t, n, s, r) {
  let a = t[t.length - 1], [i, o] = [e.length / a, a], u = w.getTypedArrayFromDType(n, i * s), l = w.getTypedArrayFromDType("int32", i * s);
  for (let p = 0; p < i; p++) {
    let d = p * o, h = e.subarray(d, d + o), f = new Array(h.length);
    h.forEach((y, v) => f[v] = { value: y, index: v }), s < f.length && (wC(f, s), f = f.slice(0, s)), r && f.sort(Ru);
    let m = p * s, g = u.subarray(m, m + s), b = l.subarray(m, m + s);
    for (let y = 0; y < s; y++)
      g[y] = f[y].value, b[y] = f[y].index;
  }
  let c = t.slice();
  return c[c.length - 1] = s, [De(c, n, u), De(c, "int32", l)];
}
function IC(e, t, n, s) {
  let r = w.parseAxisParam(t, n)[0], a = [1, n[0], 1];
  for (let f = 0; f < r; f++)
    a[0] *= n[f];
  a[1] = n[r];
  for (let f = r + 1; f < n.length; f++)
    a[2] *= n[f];
  let i = {}, o = new Int32Array(n[r]), u = new Vt(a, s, e), l = [], c = a[0] === 1 && a[2] === 1;
  for (let f = 0; f < n[r]; f++) {
    let m;
    if (c)
      m = e[f].toString();
    else {
      let g = [];
      for (let b = 0; b < a[0]; b++)
        for (let y = 0; y < a[2]; y++)
          g.push(u.get(b, f, y));
      m = g.join(",");
    }
    if (i[m] !== void 0)
      o[f] = i[m];
    else {
      let g = Object.keys(i).length;
      i[m] = g, o[f] = g, l.push(f);
    }
  }
  let p = a.slice();
  p[1] = Object.keys(i).length;
  let d = new Vt(p, s);
  l.forEach((f, m) => {
    for (let g = 0; g < a[0]; g++)
      for (let b = 0; b < a[2]; b++)
        d.set(u.get(g, f, b), g, m, b);
  });
  let h = n.slice();
  return h[r] = p[1], { outputValues: d.values, outputShape: h, indices: o };
}
var Ope = "0.0.0";
pp("cpu", () => new L0(), 1);
var SC = st(Fa, (e) => e >= 0 ? e : Math.exp(e) - 1);
var yG = { kernelName: Fa, backendName: "cpu", kernelFunc: SC };
function CC(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { alpha: a } = s;
  be([r], "leakyRelu");
  let i = w.sizeFromShape(r.shape), o = n.data.get(r.dataId).values, u = w.getTypedArrayFromDType("float32", i);
  for (let l = 0; l < o.length; l++)
    u[l] = o[l] < 0 ? a * o[l] : o[l];
  return n.makeTensorInfo(r.shape, "float32", u);
}
var vG = { kernelName: Va, backendName: "cpu", kernelFunc: CC };
var xG = At((e, t) => e < 0 ? t * e : e);
function NC(e) {
  let { inputs: t, backend: n } = e, { x: s, alpha: r } = t;
  be([s, r], "prelu");
  let a = n.data.get(s.dataId).values, i = n.data.get(r.dataId).values, [o, u] = xG(s.shape, r.shape, a, i, "float32");
  return n.makeTensorInfo(u, "float32", o);
}
var wG = { kernelName: Ja, backendName: "cpu", kernelFunc: NC };
var TC = st(ei, (e) => Math.max(0, e));
var kG = { kernelName: ei, backendName: "cpu", kernelFunc: TC };
var $C = st(ni, (e) => Math.min(Math.max(0, e), 6));
var IG = { kernelName: ni, backendName: "cpu", kernelFunc: $C };
function ov(e, t, n, s, r) {
  if (n === "linear")
    return Os({ inputs: { x: t }, backend: e });
  if (n === "relu")
    return TC({ inputs: { x: t }, backend: e });
  if (n === "elu")
    return SC({ inputs: { x: t }, backend: e });
  if (n === "relu6")
    return $C({ inputs: { x: t }, backend: e });
  if (n === "prelu")
    return NC({ inputs: { x: t, alpha: s }, backend: e });
  if (n === "leakyrelu")
    return CC({ inputs: { x: t }, backend: e, attrs: { alpha: r } });
  if (n === "sigmoid")
    return dC({ inputs: { x: t }, backend: e });
  throw new Error(`Activation ${n} has not been implemented for the CPU backend.`);
}
function mt(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { shape: a } = s, i = w.sizeFromShape(r.shape), o = w.inferFromImplicitShape(a, i), u = w.sizeFromShape(o);
  w.assert(i === u, () => `The new shape (${o}) has ${u} elements and the old shape (${r.shape}) has ${i} elements. The new shape and old shape must have the same number of elements.`), n.incRef(r.dataId);
  let l = n.data.get(r.dataId);
  if (l.complexTensorInfos != null) {
    let c = l.complexTensorInfos.real, p = l.complexTensorInfos.imag;
    c.shape = o, p.shape = o;
  }
  return { dataId: r.dataId, shape: o, dtype: r.dtype };
}
var SG = { kernelName: Eo, backendName: "cpu", kernelFunc: mt };
function _C(e) {
  let { inputs: t, backend: n, attrs: s } = e, { a: r, b: a } = t, { transposeA: i, transposeB: o } = s;
  be([r, a], "matMul");
  let u = r.shape.length, l = a.shape.length, c = i ? r.shape[u - 2] : r.shape[u - 1], p = o ? a.shape[l - 1] : a.shape[l - 2], d = i ? r.shape[u - 1] : r.shape[u - 2], h = o ? a.shape[l - 2] : a.shape[l - 1], f = r.shape.slice(0, -2), m = a.shape.slice(0, -2), g = w.sizeFromShape(f), b = w.sizeFromShape(m), v = jo.assertAndGetBroadcastShape(r.shape.slice(0, -2), a.shape.slice(0, -2)).concat([d, h]);
  w.assert(c === p, () => `Error in matMul: inner shapes (${c}) and (${p}) of Tensors with shapes ${r.shape} and ${a.shape} and transposeA=${i} and transposeB=${o} must match.`);
  let x = i ? [g, c, d] : [g, d, c], k = o ? [b, h, p] : [b, p, h], T = mt({ inputs: { x: r }, backend: n, attrs: { shape: x } }), N = mt({ inputs: { x: a }, backend: n, attrs: { shape: k } }), E = i ? T.shape[1] : T.shape[2], A = i ? T.shape[2] : T.shape[1], P = o ? N.shape[1] : N.shape[2], R = Math.max(g, b), F = n.data.get(T.dataId).values, $ = n.data.get(N.dataId).values, z = w.computeStrides(T.shape), W = w.computeStrides(N.shape), [q, K, Y] = i ? [z[0], 1, z[1]] : [z[0], z[1], 1], [Z, te, ee] = o ? [1, W[1], W[0]] : [W[1], 1, W[0]], se = A * P, ne = De([R, A, P], T.dtype), oe = ne.values, re = n.blockSize;
  for (let le = 0; le < R; le++)
    for (let me = 0; me < A; me += re)
      for (let ke = 0; ke < P; ke += re)
        for (let Se = 0; Se < E; Se += re) {
          let Ee = Math.min(me + re, A), Pe = Math.min(ke + re, P), Xe = Math.min(Se + re, E);
          for (let Je = me; Je < Ee; Je++)
            for (let Ye = ke; Ye < Pe; Ye++) {
              let tt = 0;
              for (let Ce = Se; Ce < Xe; Ce++) {
                let ut = Math.min(le, g - 1) * q, at = Math.min(le, b - 1) * ee, Jt = F[ut + Je * K + Ce * Y], Nt = $[Ce * Z + Ye * te + at];
                tt += Jt * Nt;
              }
              oe[le * se + (Je * P + Ye)] += tt;
            }
        }
  return n.disposeIntermediateTensorInfo(T), n.disposeIntermediateTensorInfo(N), n.makeTensorInfo(v, ne.dtype, ne.values);
}
var CG = { kernelName: Ca, backendName: "cpu", kernelFunc: _C };
function NG(e) {
  let { inputs: t, backend: n, attrs: s } = e, { a: r, b: a, bias: i, preluActivationWeights: o } = t, { transposeA: u, transposeB: l, activation: c, leakyreluAlpha: p } = s, d, h, f, m = [];
  d = _C({ inputs: { a: r, b: a }, attrs: { transposeA: u, transposeB: l }, backend: n }), i && (h = Kl({ inputs: { a: d, b: i }, backend: n }), m.push(d), d = h), c && (f = ov(n, d, c, o, p), m.push(d), d = f);
  for (let b of m)
    n.disposeIntermediateTensorInfo(b);
  return d;
}
var TG = { kernelName: ra, backendName: "cpu", kernelFunc: NG };
var $G = st(sl, (e) => Math.acos(e));
var _G = { kernelName: sl, backendName: "cpu", kernelFunc: $G };
var AG = st(rl, (e) => Math.acosh(e));
var EG = { kernelName: rl, backendName: "cpu", kernelFunc: AG };
function RG(e) {
  let { inputs: t, backend: n } = e, s = t;
  be(t, "addN");
  let r = s.map((o) => n.data.get(o.dataId).values), a = De(s[0].shape, s[0].dtype), i = a.values;
  for (let o = 0; o < s.length; o++) {
    let u = r[o];
    for (let l = 0; l < i.length; l++)
      i[l] += u[l];
  }
  return n.makeTensorInfo(a.shape, a.dtype, a.values);
}
var DG = { kernelName: ka, backendName: "cpu", kernelFunc: RG };
function FG(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { axis: a, keepDims: i } = s;
  be(r, "all");
  let o = w.parseAxisParam(a, r.shape), u = o, l = S.getAxesPermutation(u, r.shape.length), c = r;
  l != null && (c = wn({ inputs: { x: r }, backend: n, attrs: { perm: l } }), u = S.getInnerMostAxes(u.length, r.shape.length)), S.assertAxesAreInnerMostDims("all", u, c.shape.length);
  let [p, d] = S.computeOutAndReduceShapes(c.shape, u), h = w.sizeFromShape(d), f = w.makeZerosTypedArray(w.sizeFromShape(p), c.dtype), m = n.data.get(c.dataId).values;
  for (let b = 0; b < f.length; ++b) {
    let y = b * h, v = m[y];
    for (let x = 0; x < h; ++x) {
      let k = m[y + x];
      v = v && k;
    }
    f[b] = v;
  }
  l != null && n.disposeIntermediateTensorInfo(c);
  let g = n.makeTensorInfo(p, c.dtype, f);
  if (i) {
    let b = S.expandShapeToKeepDim(p, o), y = mt({ inputs: { x: g }, backend: n, attrs: { shape: b } });
    return n.disposeIntermediateTensorInfo(g), y;
  }
  return g;
}
var OG = { kernelName: al, backendName: "cpu", kernelFunc: FG };
function PG(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { axis: a, keepDims: i } = s;
  be(r, "any");
  let o = w.parseAxisParam(a, r.shape), u = o, l = S.getAxesPermutation(u, r.shape.length), c = r;
  l != null && (c = wn({ inputs: { x: r }, backend: n, attrs: { perm: l } }), u = S.getInnerMostAxes(u.length, r.shape.length)), S.assertAxesAreInnerMostDims("any", u, c.shape.length);
  let [p, d] = S.computeOutAndReduceShapes(c.shape, u), h = w.sizeFromShape(d), f = w.makeZerosTypedArray(w.sizeFromShape(p), c.dtype), m = n.data.get(c.dataId).values;
  for (let b = 0; b < f.length; ++b) {
    let y = b * h, v = m[y];
    for (let x = 0; x < h; ++x) {
      let k = m[y + x];
      v = v || k;
    }
    f[b] = v;
  }
  l != null && n.disposeIntermediateTensorInfo(c);
  let g = n.makeTensorInfo(p, c.dtype, f);
  if (i) {
    let b = S.expandShapeToKeepDim(p, o), y = mt({ inputs: { x: g }, backend: n, attrs: { shape: b } });
    return n.disposeIntermediateTensorInfo(g), y;
  }
  return g;
}
var zG = { kernelName: il, backendName: "cpu", kernelFunc: PG };
function MG(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { axis: a } = s;
  be(r, "argMax");
  let i = w.parseAxisParam(a, r.shape), o = S.getAxesPermutation(i, r.shape.length), u = r, l = [];
  o != null && (u = wn({ inputs: { x: r }, backend: n, attrs: { perm: o } }), l.push(u), i = S.getInnerMostAxes(i.length, u.shape.length)), i = [i[0]], S.assertAxesAreInnerMostDims("argMax", i, u.shape.length);
  let [c, p] = S.computeOutAndReduceShapes(u.shape, i), d = w.sizeFromShape(c), h = w.makeZerosTypedArray(d, "int32"), f = w.sizeFromShape(p), m = n.data.get(u.dataId).values;
  for (let g = 0; g < h.length; ++g) {
    let b = g * f, y = m[b], v = 0;
    for (let x = 0; x < f; ++x) {
      let k = m[b + x];
      k > y && (y = k, v = x);
    }
    h[g] = v;
  }
  return l.forEach((g) => n.disposeIntermediateTensorInfo(g)), n.makeTensorInfo(c, "int32", h);
}
var LG = { kernelName: Ia, backendName: "cpu", kernelFunc: MG };
function BG(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { axis: a } = s;
  be(r, "argMin");
  let i = w.parseAxisParam(a, r.shape), o = S.getAxesPermutation(i, r.shape.length), u = r, l = [];
  o != null && (u = wn({ inputs: { x: r }, backend: n, attrs: { perm: o } }), l.push(u), i = S.getInnerMostAxes(i.length, u.shape.length)), i = [i[0]], S.assertAxesAreInnerMostDims("argMin", i, u.shape.length);
  let [c, p] = S.computeOutAndReduceShapes(u.shape, i), d = w.sizeFromShape(c), h = w.makeZerosTypedArray(d, "int32"), f = w.sizeFromShape(p), m = n.data.get(u.dataId).values;
  for (let g = 0; g < h.length; ++g) {
    let b = g * f, y = m[b], v = 0;
    for (let x = 0; x < f; ++x) {
      let k = m[b + x];
      k < y && (y = k, v = x);
    }
    h[g] = v;
  }
  return l.forEach((g) => n.disposeIntermediateTensorInfo(g)), n.makeTensorInfo(c, "int32", h);
}
var VG = { kernelName: ol, backendName: "cpu", kernelFunc: BG };
var WG = st(ul, (e) => Math.asin(e));
var UG = { kernelName: ul, backendName: "cpu", kernelFunc: WG };
var GG = st(ll, (e) => Math.asinh(e));
var HG = { kernelName: ll, backendName: "cpu", kernelFunc: GG };
var qG = st(cl, (e) => Math.atan(e));
var jG = { kernelName: cl, backendName: "cpu", kernelFunc: qG };
var KG = At((e, t) => Math.atan2(e, t));
var XG = Gt(pl, KG);
var YG = { kernelName: pl, backendName: "cpu", kernelFunc: XG };
var QG = st(dl, (e) => Math.atanh(e));
var ZG = { kernelName: dl, backendName: "cpu", kernelFunc: QG };
function uv(e, t, n, s, r, a) {
  let i = r.strideHeight, o = r.strideWidth, u = r.dilationHeight, l = r.dilationWidth, c = r.effectiveFilterHeight, p = r.effectiveFilterWidth, d = r.padInfo.top, h = r.padInfo.left, f = a === "max" ? Number.NEGATIVE_INFINITY : Number.POSITIVE_INFINITY, m = De(r.outShape, n), g = m.values, b = r.outShape[1] * r.outShape[2] * r.outShape[3], y = r.outShape[2] * r.outShape[3], v = r.outShape[3];
  for (let x = 0; x < r.batchSize; ++x) {
    let k = x * b, T = x * s[0];
    for (let N = 0; N < r.inChannels; ++N)
      for (let E = 0; E < r.outHeight; ++E) {
        let A = E * i - d, P = Math.max(0, A), R = Math.min(r.inHeight, c + A), F = k + E * y;
        for (let $ = 0; $ < r.outWidth; ++$) {
          let z = $ * o - h, W = Math.max(0, z), q = Math.min(r.inWidth, p + z), K = f, Y = 0, Z = 0;
          for (let ee = P; ee < R; ee += u) {
            let se = T + ee * s[1];
            for (let ne = W; ne < q; ne += l) {
              let oe = se + ne * s[2], re = e[oe + N];
              a === "max" && re > K ? K = re : a === "avg" && (Y += re, Z++);
            }
            if (isNaN(K))
              break;
          }
          let te = F + $ * v + N;
          g[te] = a === "avg" ? Y / Z : K;
        }
      }
  }
  return m;
}
function AC(e, t, n, s, r = false, a = false) {
  let i = De(s.outShape, "int32"), o = s.strideHeight, u = s.strideWidth, l = s.dilationHeight, c = s.dilationWidth, p = s.effectiveFilterHeight, d = s.effectiveFilterWidth, h = s.padInfo.top, f = s.padInfo.left, m = De(t, n, e);
  for (let g = 0; g < s.batchSize; ++g)
    for (let b = 0; b < s.inChannels; ++b)
      for (let y = 0; y < s.outHeight; ++y) {
        let v = y * o - h, x = v;
        for (; x < 0; )
          x += l;
        let k = Math.min(s.inHeight, p + v);
        for (let T = 0; T < s.outWidth; ++T) {
          let N = T * u - f, E = N;
          for (; E < 0; )
            E += c;
          let A = Math.min(s.inWidth, d + N), P = Number.NEGATIVE_INFINITY, R = -1;
          for (let F = x; F < k; F += l) {
            let $ = F - v;
            for (let z = E; z < A; z += c) {
              let W = z - N, q = m.get(g, F, z, b);
              q > P && (P = q, r ? R = a ? ((g * s.inHeight + F) * s.inWidth + z) * s.inChannels + b : (F * s.inWidth + z) * s.inChannels + b : R = $ * d + W);
            }
          }
          i.set(R, g, y, T, b);
        }
      }
  return i;
}
function EC(e, t, n, s, r, a) {
  let i = r.strideDepth, o = r.strideHeight, u = r.strideWidth, l = r.dilationDepth, c = r.dilationHeight, p = r.dilationWidth, d = r.effectiveFilterDepth, h = r.effectiveFilterHeight, f = r.effectiveFilterWidth, m = r.padInfo.front, g = r.padInfo.top, b = r.padInfo.left, y = a === "max" ? Number.NEGATIVE_INFINITY : Number.POSITIVE_INFINITY, v = De(r.outShape, n), x = v.values, k = r.outShape[1] * r.outShape[2] * r.outShape[3] * r.outShape[4], T = r.outShape[2] * r.outShape[3] * r.outShape[4], N = r.outShape[3] * r.outShape[4], E = r.outShape[4];
  for (let A = 0; A < r.batchSize; ++A) {
    let P = A * k, R = A * s[0];
    for (let F = 0; F < r.inChannels; ++F)
      for (let $ = 0; $ < r.outDepth; ++$) {
        let z = $ * i - m, W = z;
        for (; W < 0; )
          W += l;
        let q = Math.min(r.inDepth, d + z), K = P + $ * T;
        for (let Y = 0; Y < r.outHeight; ++Y) {
          let Z = Y * o - g, te = Z;
          for (; te < 0; )
            te += c;
          let ee = Math.min(r.inHeight, h + Z), se = K + Y * N;
          for (let ne = 0; ne < r.outWidth; ++ne) {
            let oe = ne * u - b, re = oe;
            for (; re < 0; )
              re += p;
            let le = Math.min(r.inWidth, f + oe), me = se + ne * E, ke = y, Se = 0, Ee = 0;
            for (let Xe = W; Xe < q; Xe += l) {
              let Je = R + Xe * s[1];
              for (let Ye = te; Ye < ee; Ye += c) {
                let tt = Je + Ye * s[2];
                for (let Ce = re; Ce < le; Ce += p) {
                  let ut = tt + Ce * s[3], at = e[ut + F];
                  if (a === "max" && at > ke ? ke = at : a === "avg" && (Se += at, Ee++), isNaN(ke))
                    break;
                }
                if (isNaN(ke))
                  break;
              }
              if (isNaN(ke))
                break;
            }
            let Pe = me + F;
            x[Pe] = a === "avg" ? Se / Ee : ke;
          }
        }
      }
  }
  return v;
}
function JG(e, t) {
  let n = De(t.outShape, "int32"), s = t.strideDepth, r = t.strideHeight, a = t.strideWidth, i = t.dilationDepth, o = t.dilationHeight, u = t.dilationWidth, l = t.effectiveFilterDepth, c = t.effectiveFilterHeight, p = t.effectiveFilterWidth, d = t.padInfo.front, h = t.padInfo.top, f = t.padInfo.left;
  for (let m = 0; m < t.batchSize; ++m)
    for (let g = 0; g < t.inChannels; ++g)
      for (let b = 0; b < t.outDepth; ++b) {
        let y = b * s - d, v = y;
        for (; v < 0; )
          v += i;
        let x = Math.min(t.inDepth, l + y);
        for (let k = 0; k < t.outHeight; ++k) {
          let T = k * r - h, N = T;
          for (; N < 0; )
            N += o;
          let E = Math.min(t.inHeight, c + T);
          for (let A = 0; A < t.outWidth; ++A) {
            let P = A * a - f, R = P;
            for (; R < 0; )
              R += u;
            let F = Math.min(t.inWidth, p + P), $ = Number.NEGATIVE_INFINITY, z = -1;
            for (let W = v; W < x; W += i) {
              let q = W - y;
              for (let K = N; K < E; K += o) {
                let Y = K - T;
                for (let Z = R; Z < F; Z += u) {
                  let te = Z - P, ee = e.get(m, W, K, Z, g);
                  ee >= $ && ($ = ee, z = q * c * p + Y * c + te);
                }
              }
            }
            n.set(z, m, b, k, A, g);
          }
        }
      }
  return n;
}
function eH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t;
  be(r, "avgPool");
  let { filterSize: a, strides: i, pad: o, dimRoundingMode: u } = s, l = 1;
  w.assert(S.eitherStridesOrDilationsAreOne(i, l), () => `Error in avgPool: Either strides or dilations must be 1. Got strides ${i} and dilations '${l}'`);
  let c = S.computePool2DInfo(r.shape, a, i, l, o, u), p;
  if (c.filterWidth === 1 && c.filterHeight === 1 && w.arraysEqual(c.inShape, c.outShape))
    p = Os({ inputs: { x: r }, backend: n });
  else {
    let d = n.data.get(r.dataId).values, h = w.computeStrides(r.shape), f = uv(d, r.shape, r.dtype, h, c, "avg");
    p = n.makeTensorInfo(c.outShape, r.dtype, f.values);
  }
  return p;
}
var tH = { kernelName: Sa, backendName: "cpu", kernelFunc: eH };
function nH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { filterSize: a, strides: i, pad: o, dimRoundingMode: u, dataFormat: l } = s;
  be(r, "avgPool3d");
  let c = S.computePool3DInfo(r.shape, a, i, 1, o, u, l), p = n.data.get(r.dataId).values, d = EC(p, r.shape, r.dtype, w.computeStrides(r.shape), c, "avg");
  return n.makeTensorInfo(d.shape, "float32", d.values);
}
var sH = { kernelName: qd, backendName: "cpu", kernelFunc: nH };
function rH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { dy: r, input: a } = t, { filterSize: i, strides: o, pad: u, dimRoundingMode: l } = s;
  be([r, a], "avgPool3DGrad");
  let c = S.computePool3DInfo(a.shape, i, o, 1, u, l), p = c.strideDepth, d = c.strideHeight, h = c.strideWidth, f = c.filterDepth, m = c.filterHeight, g = c.filterWidth, b = c.dilationDepth, y = c.dilationHeight, v = c.dilationWidth, x = c.effectiveFilterDepth, k = c.effectiveFilterHeight, T = c.effectiveFilterWidth, N = x - 1 - c.padInfo.front, E = T - 1 - c.padInfo.left, A = k - 1 - c.padInfo.top, P = De(a.shape, "float32"), R = 1 / (f * m * g), F = n.bufferSync(r);
  for (let $ = 0; $ < c.batchSize; ++$)
    for (let z = 0; z < c.inChannels; ++z)
      for (let W = 0; W < c.inDepth; ++W)
        for (let q = 0; q < c.inHeight; ++q)
          for (let K = 0; K < c.inWidth; ++K) {
            let Y = W - N, Z = q - A, te = K - E, ee = 0;
            for (let se = 0; se < x; se += b) {
              let ne = (Y + se) / p;
              if (!(ne < 0 || ne >= c.outDepth || Math.floor(ne) !== ne))
                for (let oe = 0; oe < k; oe += y) {
                  let re = (Z + oe) / d;
                  if (!(re < 0 || re >= c.outHeight || Math.floor(re) !== re))
                    for (let le = 0; le < T; le += v) {
                      let me = (te + le) / h;
                      if (me < 0 || me >= c.outWidth || Math.floor(me) !== me)
                        continue;
                      ee += F.get($, ne, re, me, z);
                    }
                }
            }
            P.set(ee * R, $, W, q, K, z);
          }
  return n.makeTensorInfo(P.shape, P.dtype, P.values);
}
var aH = { kernelName: og, backendName: "cpu", kernelFunc: rH };
function iH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { dy: r, input: a } = t, i = a;
  be([r, a], "avgPoolGrad");
  let { filterSize: o, strides: u, pad: l } = s, c = S.computePool2DInfo(i.shape, o, u, 1, l), p = c.strideHeight, d = c.strideWidth, h = c.filterHeight, f = c.filterWidth, m = c.dilationHeight, g = c.dilationWidth, b = c.effectiveFilterHeight, y = c.effectiveFilterWidth, v = y - 1 - c.padInfo.left, x = b - 1 - c.padInfo.top, k = De(i.shape, "float32"), T = 1 / (h * f), N = n.data.get(r.dataId).values, E = De(r.shape, "float32", N);
  for (let A = 0; A < c.batchSize; ++A)
    for (let P = 0; P < c.inChannels; ++P)
      for (let R = 0; R < c.inHeight; ++R)
        for (let F = 0; F < c.inWidth; ++F) {
          let $ = R - x, z = F - v, W = 0;
          for (let q = 0; q < b; q += m) {
            let K = ($ + q) / p;
            if (!(K < 0 || K >= c.outHeight || Math.floor(K) !== K))
              for (let Y = 0; Y < y; Y += g) {
                let Z = (z + Y) / d;
                if (Z < 0 || Z >= c.outWidth || Math.floor(Z) !== Z)
                  continue;
                W += E.get(A, K, Z, P);
              }
          }
          k.set(W * T, A, R, F, P);
        }
  return n.makeTensorInfo(k.shape, k.dtype, k.values);
}
var oH = { kernelName: ig, backendName: "cpu", kernelFunc: iH };
function uH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r, scale: a, offset: i, mean: o, variance: u } = t;
  w.assert(o.shape.length === u.shape.length, () => "Batch normalization gradient requires mean and variance to have equal ranks."), w.assert(i == null || o.shape.length === i.shape.length, () => "Batch normalization gradient requires mean and offset to have equal ranks."), w.assert(a == null || o.shape.length === a.shape.length, () => "Batch normalization gradient requires mean and scale to have equal ranks."), be([r, o, u, a, i], "batchNorm");
  let { varianceEpsilon: l } = s;
  l == null && (l = 1e-3);
  let c = n.data.get(r.dataId).values, p = n.data.get(o.dataId).values, d = n.data.get(u.dataId).values, h = a ? n.data.get(a.dataId).values : new Float32Array([1]), f = i ? n.data.get(i.dataId).values : new Float32Array([0]), m = new Float32Array(c.length), g = f.length, b = h.length, y = d.length, v = p.length, x = 0, k = 0, T = 0, N = 0;
  for (let E = 0; E < c.length; ++E)
    m[E] = f[x++] + (c[E] - p[k++]) * h[T++] / Math.sqrt(d[N++] + l), x >= g && (x = 0), k >= v && (k = 0), T >= b && (T = 0), N >= y && (N = 0);
  return n.makeTensorInfo(r.shape, r.dtype, m);
}
var lH = { kernelName: Ma, backendName: "cpu", kernelFunc: uH };
function cH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { blockShape: a, crops: i } = s;
  be([r], "batchToSpaceND");
  let o = a.reduce((b, y) => b * y), u = S.getReshaped(r.shape, a, o), l = S.getPermuted(u.length, a.length), c = S.getReshapedPermuted(r.shape, a, o), p = S.getSliceBeginCoords(i, a.length), d = S.getSliceSize(c, i, a.length), h = mt({ inputs: { x: r }, backend: n, attrs: { shape: u } }), f = wn({ inputs: { x: h }, backend: n, attrs: { perm: l } }), m = mt({ inputs: { x: f }, backend: n, attrs: { shape: c } }), g = ga({ inputs: { x: m }, backend: n, attrs: { begin: p, size: d } });
  return n.disposeIntermediateTensorInfo(h), n.disposeIntermediateTensorInfo(f), n.disposeIntermediateTensorInfo(m), g;
}
var dH = { kernelName: oo, backendName: "cpu", kernelFunc: cH };
function pH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r, weights: a } = t, { size: i } = s, o = n.data.get(r.dataId).values, u = n.data.get(a.dataId).values, l = ev(o, u, a.dtype, a.shape, i);
  return n.makeTensorInfo([i], a.dtype, l);
}
var hH = { kernelName: ug, backendName: "cpu", kernelFunc: pH };
function fH(e) {
  let { inputs: t, backend: n } = e, { s0: s, s1: r } = t, a = n.data.get(s.dataId).values, i = n.data.get(r.dataId).values, o = S.assertAndGetBroadcastShape(Array.from(a), Array.from(i));
  return n.makeTensorInfo([o.length], "int32", Int32Array.from(o));
}
var mH = { kernelName: lg, backendName: "cpu", kernelFunc: fH };
var gH = st(Sr, (e, t) => {
  let n = t;
  return e > n.clipValueMax ? n.clipValueMax : e < n.clipValueMin ? n.clipValueMin : e;
});
var bH = { kernelName: Sr, backendName: "cpu", kernelFunc: gH };
var yH = (e) => {
  let { x: t } = e.inputs, n = e.backend, s = new Float32Array(w.sizeFromShape(t.shape)), r = n.data.get(t.dataId), a = r.complexTensorInfos.real, i = r.complexTensorInfos.imag, o = n.data.get(a.dataId).values, u = n.data.get(i.dataId).values;
  for (let l = 0; l < o.length; l++) {
    let c = o[l], p = u[l];
    s[l] = Math.hypot(c, p);
  }
  return n.makeOutput(s, t.shape, "float32");
};
var vH = { kernelName: Kd, backendName: "cpu", kernelFunc: yH };
function no(e) {
  let { inputs: t, backend: n } = e, { input: s } = t, r = n.data.get(s.dataId).complexTensorInfos.imag, a = n.data.get(r.dataId).values;
  return n.makeTensorInfo(r.shape, r.dtype, a);
}
var xH = { kernelName: Zd, backendName: "cpu", kernelFunc: no };
function so(e) {
  let { inputs: t, backend: n, attrs: s } = e, { axis: r } = s, a = w.parseAxisParam(r, t[0].shape)[0], i = S.computeOutShape(t.map((m) => m.shape), a);
  if (w.sizeFromShape(i) === 0)
    return n.makeTensorInfo(i, t[0].dtype, []);
  let o = t.filter((m) => w.sizeFromShape(m.shape) > 0);
  if (o.length === 1)
    return Os({ inputs: { x: o[0] }, backend: n });
  let u = o.map((m) => m.shape);
  if (S.assertParamsConsistent(u, a), o[0].dtype === "complex64") {
    let m = o.map((x) => ma({ inputs: { input: x }, backend: n })), g = o.map((x) => no({ inputs: { input: x }, backend: n })), b = so({ inputs: m, backend: n, attrs: { axis: a } }), y = so({ inputs: g, backend: n, attrs: { axis: a } }), v = Rn({ inputs: { real: b, imag: y }, backend: n });
    return m.forEach((x) => n.disposeIntermediateTensorInfo(x)), g.forEach((x) => n.disposeIntermediateTensorInfo(x)), n.disposeIntermediateTensorInfo(b), n.disposeIntermediateTensorInfo(y), v;
  }
  let l = o.map((m) => {
    let g = w.sizeFromShape(m.shape.slice(a));
    return mt({ inputs: { x: m }, backend: n, attrs: { shape: [-1, g] } });
  }), c = l.map((m) => ({ vals: n.data.get(m.dataId).values, shape: m.shape }));
  i = S.computeOutShape(l.map((m) => m.shape), 1);
  let p = l[0].shape[0] === 1, d = tv(c, i, t[0].dtype, p), h = S.computeOutShape(o.map((m) => m.shape), a), f = n.makeTensorInfo(h, t[0].dtype, d);
  return l.forEach((m) => n.disposeIntermediateTensorInfo(m)), f;
}
var wH = { kernelName: uo, backendName: "cpu", kernelFunc: so };
function RC(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r, filter: a } = t, { strides: i, pad: o, dataFormat: u, dilations: l, dimRoundingMode: c } = s;
  be([r, a], "conv2d");
  let p = S.convertConv2DDataFormat(u), d = S.computeConv2DInfo(r.shape, a.shape, i, l, o, c, false, p), h = d.filterHeight, f = d.filterWidth, m = d.dilationHeight, g = d.dilationWidth, b = d.padInfo.left, y = d.padInfo.top, v = d.dataFormat === "channelsLast", x = new Vt(d.outShape, r.dtype), k = w.computeStrides(r.shape), T = w.computeStrides(a.shape), N = k[0], E = v ? k[1] : k[2], A = v ? k[2] : 1, P = v ? 1 : k[1], R = x.strides[0], F = v ? x.strides[1] : x.strides[2], $ = v ? x.strides[2] : 1, z = v ? 1 : x.strides[1], W = n.data.get(r.dataId).values, q = n.data.get(a.dataId).values, K = x.values;
  for (let Y = 0; Y < d.batchSize; ++Y) {
    let Z = Y * N, te = Y * R;
    for (let ee = 0; ee < d.outHeight; ++ee) {
      let se = te + ee * F, ne = ee * d.strideHeight - y;
      for (let oe = 0; oe < h; ++oe) {
        let re = ne + oe * m;
        if (re < 0 || re >= d.inHeight)
          continue;
        let le = oe * T[0], me = Z + re * E;
        for (let ke = 0; ke < d.outWidth; ++ke) {
          let Se = se + ke * $, Ee = ke * d.strideWidth - b;
          for (let Pe = 0; Pe < f; ++Pe) {
            let Xe = Ee + Pe * g;
            if (Xe < 0 || Xe >= d.inWidth)
              continue;
            let Je = le + Pe * T[1], Ye = me + Xe * A, tt = Je;
            for (let Ce = 0; Ce < d.inChannels; ++Ce) {
              let ut = W[Ye + Ce * P];
              for (let at = 0; at < d.outChannels; ++at)
                K[Se + at * z] += ut * q[tt + at];
              tt += d.outChannels;
            }
          }
        }
      }
    }
  }
  return n.makeTensorInfo(x.shape, x.dtype, K);
}
var kH = { kernelName: $a, backendName: "cpu", kernelFunc: RC };
function IH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r, dy: a } = t, { strides: i, pad: o, dataFormat: u, dimRoundingMode: l, filterShape: c } = s;
  be([r, a], "conv2dBackpropFilter");
  let p = S.convertConv2DDataFormat(u), d = S.computeConv2DInfo(r.shape, c, i, 1, o, l, false, p), { strideHeight: h, strideWidth: f, filterHeight: m, filterWidth: g } = d, b = d.dataFormat === "channelsLast", y = new Vt(d.filterShape, "float32"), v = d.padInfo.left, x = d.padInfo.top, k = n.data.get(r.dataId).values, T = n.data.get(a.dataId).values, N = new Vt(r.shape, r.dtype, k), E = new Vt(a.shape, a.dtype, T);
  for (let A = 0; A < m; ++A) {
    let P = Math.max(0, Math.ceil((x - A) / h)), R = Math.min(d.outHeight, (d.inHeight + x - A) / h);
    for (let F = 0; F < g; ++F) {
      let $ = Math.max(0, Math.ceil((v - F) / f)), z = Math.min(d.outWidth, (d.inWidth + v - F) / f);
      for (let W = 0; W < d.inChannels; ++W)
        for (let q = 0; q < d.outChannels; ++q) {
          let K = 0;
          for (let Y = 0; Y < d.batchSize; ++Y)
            for (let Z = P; Z < R; ++Z) {
              let te = A + Z * h - x;
              for (let ee = $; ee < z; ++ee) {
                let se = F + ee * f - v;
                b ? K += N.get(Y, te, se, W) * E.get(Y, Z, ee, q) : K += N.get(Y, W, te, se) * E.get(Y, q, Z, ee);
              }
            }
          y.set(K, A, F, W, q);
        }
    }
  }
  return n.makeTensorInfo(y.shape, y.dtype, y.values);
}
var SH = { kernelName: cg, backendName: "cpu", kernelFunc: IH };
function CH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { dy: r, filter: a } = t, { inputShape: i, strides: o, pad: u, dataFormat: l, dimRoundingMode: c } = s;
  be([r, a], "conv2dBackpropInput");
  let p = w.computeStrides(a.shape), d = w.computeStrides(r.shape), h = S.convertConv2DDataFormat(l), f = S.computeConv2DInfo(i, a.shape, o, 1, u, c, false, h), m = new Vt(f.inShape, "float32"), g = m.values, b = n.data.get(r.dataId).values, y = n.data.get(a.dataId).values, [v, x, k] = p, { batchSize: T, filterHeight: N, filterWidth: E, inChannels: A, inHeight: P, inWidth: R, outChannels: F, outHeight: $, outWidth: z, strideHeight: W, strideWidth: q } = f;
  h = f.dataFormat;
  let K = N - 1 - f.padInfo.top, Y = E - 1 - f.padInfo.left, Z = h === "channelsLast", te = m.strides[0], ee = Z ? m.strides[1] : m.strides[2], se = Z ? m.strides[2] : 1, ne = Z ? 1 : m.strides[1], oe = d[0], re = Z ? d[1] : d[2], le = Z ? d[2] : 1, me = Z ? 1 : d[1];
  for (let ke = 0; ke < T; ++ke)
    for (let Se = 0; Se < A; ++Se)
      for (let Ee = 0; Ee < P; ++Ee) {
        let Pe = Ee - K, Xe = Math.max(0, Math.ceil(Pe / W)), Je = Math.min($, (N + Pe) / W);
        for (let Ye = 0; Ye < R; ++Ye) {
          let tt = Ye - Y, Ce = Math.max(0, Math.ceil(tt / q)), ut = Math.min(z, (E + tt) / q), at = 0;
          for (let Nt = Xe; Nt < Je; ++Nt) {
            let Cn = Nt * W - Pe;
            for (let Et = Ce; Et < ut; ++Et) {
              let en = Et * q - tt, Nn = oe * ke + re * Nt + le * Et, Tn = v * (N - 1 - Cn) + x * (E - 1 - en) + k * Se;
              for (let Yt = 0; Yt < F; ++Yt) {
                let Dn = b[Nn + me * Yt], tn = y[Tn + Yt];
                at += Dn * tn;
              }
            }
          }
          let Jt = te * ke + ee * Ee + se * Ye + ne * Se;
          g[Jt] = at;
        }
      }
  return n.makeTensorInfo(m.shape, m.dtype, m.values);
}
var NH = { kernelName: _a, backendName: "cpu", kernelFunc: CH };
function TH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r, filter: a } = t, { strides: i, pad: o, dilations: u } = s;
  be([r, a], "conv3d");
  let l = S.computeConv3DInfo(r.shape, a.shape, i, u, o), { filterDepth: c, filterHeight: p, filterWidth: d, dilationDepth: h, dilationHeight: f, dilationWidth: m, padInfo: g } = l, b = g.front, y = g.left, v = g.top, x = new Vt(l.outShape, r.dtype), k = n.data.get(r.dataId).values, T = n.data.get(a.dataId).values, N = x.values, E = w.computeStrides(r.shape), A = w.computeStrides(a.shape);
  for (let P = 0; P < l.batchSize; ++P) {
    let R = P * E[0], F = P * x.strides[0];
    for (let $ = 0; $ < l.outDepth; ++$) {
      let z = F + $ * x.strides[1], W = $ * l.strideDepth - b;
      for (let q = 0; q < c; ++q) {
        let K = W + q * h;
        if (K < 0 || K >= l.inDepth)
          continue;
        let Y = q * A[0], Z = R + K * E[1];
        for (let te = 0; te < l.outHeight; ++te) {
          let ee = z + te * x.strides[2], se = te * l.strideHeight - v;
          for (let ne = 0; ne < p; ++ne) {
            let oe = se + ne * f;
            if (oe < 0 || oe >= l.inHeight)
              continue;
            let re = Y + ne * A[1], le = Z + oe * E[2];
            for (let me = 0; me < l.outWidth; ++me) {
              let ke = ee + me * l.outChannels, Se = me * l.strideWidth - y;
              for (let Ee = 0; Ee < d; ++Ee) {
                let Pe = Se + Ee * m;
                if (Pe < 0 || Pe >= l.inWidth)
                  continue;
                let Xe = re + Ee * A[2], Je = le + Pe * l.inChannels, Ye = Xe;
                for (let tt = 0; tt < l.inChannels; ++tt) {
                  let Ce = k[Je + tt];
                  for (let ut = 0; ut < l.outChannels; ++ut)
                    N[ke + ut] += Ce * T[Ye + ut];
                  Ye += l.outChannels;
                }
              }
            }
          }
        }
      }
    }
  }
  return n.makeTensorInfo(x.shape, x.dtype, x.values);
}
var $H = { kernelName: Xd, backendName: "cpu", kernelFunc: TH };
function _H(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r, dy: a } = t, { strides: i, pad: o, filterShape: u } = s;
  be([r, a], "conv3dBackpropFilterV2");
  let l = w.computeStrides(r.shape), c = w.computeStrides(a.shape), p = S.computeConv3DInfo(r.shape, u, i, 1, o), d = p.strideDepth, h = p.strideHeight, f = p.strideWidth, m = p.filterDepth, g = p.filterHeight, b = p.filterWidth, y = new Vt(p.filterShape, "float32"), v = y.values, [x, k, T, N] = y.strides, E = n.data.get(a.dataId).values, [A, P, R, F] = c, $ = n.data.get(r.dataId).values, [z, W, q, K] = l, Y = p.padInfo.front, Z = p.padInfo.left, te = p.padInfo.top;
  for (let ee = 0; ee < m; ++ee) {
    let se = Math.max(0, Math.ceil((Y - ee) / d)), ne = Math.min(p.outDepth, (p.inDepth + Y - ee) / d), oe = ee * x;
    for (let re = 0; re < g; ++re) {
      let le = Math.max(0, Math.ceil((te - re) / h)), me = Math.min(p.outHeight, (p.inHeight + te - re) / h), ke = re * k + oe;
      for (let Se = 0; Se < b; ++Se) {
        let Ee = Math.max(0, Math.ceil((Z - Se) / f)), Pe = Math.min(p.outWidth, (p.inWidth + Z - Se) / f), Xe = Se * T + ke;
        for (let Je = 0; Je < p.inChannels; ++Je) {
          let Ye = Je * N + Xe;
          for (let tt = 0; tt < p.outChannels; ++tt) {
            let Ce = 0;
            for (let ut = 0; ut < p.batchSize; ++ut) {
              let at = ut * z, Jt = ut * A;
              for (let Nt = se; Nt < ne; ++Nt) {
                let Et = (ee + Nt * d - Y) * W + at, en = Nt * P + Jt;
                for (let Nn = le; Nn < me; ++Nn) {
                  let Yt = (re + Nn * h - te) * q + Et, Dn = Nn * R + en;
                  for (let tn = Ee; tn < Pe; ++tn) {
                    let Ls = (Se + tn * f - Z) * K + Yt, ki = tn * F + Dn;
                    Ce += $[Ls + Je] * E[ki + tt];
                  }
                }
              }
            }
            v[Ye + tt] = Ce;
          }
        }
      }
    }
  }
  return n.makeTensorInfo(y.shape, y.dtype, y.values);
}
var AH = { kernelName: dg, backendName: "cpu", kernelFunc: _H };
function EH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { dy: r, filter: a } = t, { pad: i, strides: o, inputShape: u } = s;
  be([r], "conv3dBackpropInputV2");
  let l = w.computeStrides(r.shape), c = w.computeStrides(a.shape), p = S.computeConv3DInfo(u, a.shape, o, 1, i), d = new Vt(p.inShape, "float32"), h = d.values, [f, m, g, b] = d.strides, y = n.data.get(r.dataId).values, [v, x, k, T] = l, N = n.data.get(a.dataId).values, [E, A, P, R] = c, { batchSize: F, filterDepth: $, filterHeight: z, filterWidth: W, inChannels: q, inDepth: K, inHeight: Y, inWidth: Z, outChannels: te, outDepth: ee, outHeight: se, outWidth: ne, strideDepth: oe, strideHeight: re, strideWidth: le } = p, me = $ - 1 - p.padInfo.front, ke = z - 1 - p.padInfo.top, Se = W - 1 - p.padInfo.left;
  for (let Ee = 0; Ee < F; ++Ee)
    for (let Pe = 0; Pe < q; ++Pe)
      for (let Xe = 0; Xe < K; ++Xe) {
        let Je = Xe - me, Ye = Math.max(0, Math.ceil(Je / oe)), tt = Math.min(ee, ($ + Je) / oe);
        for (let Ce = 0; Ce < Y; ++Ce) {
          let ut = Ce - ke, at = Math.max(0, Math.ceil(ut / re)), Jt = Math.min(se, (z + ut) / re);
          for (let Nt = 0; Nt < Z; ++Nt) {
            let Cn = Nt - Se, Et = Math.max(0, Math.ceil(Cn / le)), en = Math.min(ne, (W + Cn) / le), Nn = 0;
            for (let Tn = Ye; Tn < tt; ++Tn) {
              let Yt = Tn * oe - Je;
              for (let Dn = at; Dn < Jt; ++Dn) {
                let tn = Dn * re - ut;
                for (let Ms = Et; Ms < en; ++Ms) {
                  let Ls = Ms * le - Cn, ki = v * Ee + x * Tn + k * Dn + T * Ms, Js = E * ($ - 1 - Yt) + A * (z - 1 - tn) + P * (W - 1 - Ls) + R * Pe;
                  for (let Bs = 0; Bs < te; ++Bs) {
                    let pu = y[ki + Bs], Ii = N[Js + Bs];
                    Nn += pu * Ii;
                  }
                }
              }
            }
            h[f * Ee + m * Xe + g * Ce + b * Nt + Pe] = Nn;
          }
        }
      }
  return n.makeTensorInfo(d.shape, d.dtype, d.values);
}
var RH = { kernelName: pg, backendName: "cpu", kernelFunc: EH };
var DH = st(Aa, (e) => Math.cos(e));
var FH = { kernelName: Aa, backendName: "cpu", kernelFunc: DH };
var OH = st(Ea, (e) => Math.cosh(e));
var PH = { kernelName: Ea, backendName: "cpu", kernelFunc: OH };
function zH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { image: r, boxes: a, boxInd: i } = t, { cropSize: o, method: u, extrapolationValue: l } = s, [c, p, d, h] = r.shape, f = a.shape[0], [m, g] = o, b = De([f, m, g, h], "float32"), y = n.data.get(a.dataId).values, v = n.data.get(i.dataId).values, x = n.data.get(r.dataId).values, k = w.computeStrides(r.shape), T = w.computeStrides(b.shape);
  for (let N = 0; N < f; N++) {
    let E = N * 4, A = y[E], P = y[E + 1], R = y[E + 2], F = y[E + 3], $ = v[N];
    if ($ >= c)
      continue;
    let z = m > 1 ? (R - A) * (p - 1) / (m - 1) : 0, W = g > 1 ? (F - P) * (d - 1) / (g - 1) : 0;
    for (let q = 0; q < m; q++) {
      let K = m > 1 ? A * (p - 1) + q * z : 0.5 * (A + R) * (p - 1);
      if (K < 0 || K > p - 1) {
        for (let Y = 0; Y < g; Y++)
          for (let Z = 0; Z < h; Z++) {
            let te = Z + Y * T[2] + q * T[1] + N * T[0];
            b.values[te] = l;
          }
        continue;
      }
      if (u === "bilinear") {
        let Y = Math.floor(K), Z = Math.ceil(K), te = K - Y;
        for (let ee = 0; ee < g; ee++) {
          let se = g > 1 ? P * (d - 1) + ee * W : 0.5 * (P + F) * (d - 1);
          if (se < 0 || se > d - 1) {
            for (let le = 0; le < h; le++) {
              let me = le + ee * T[2] + q * T[1] + N * T[0];
              b.values[me] = l;
            }
            continue;
          }
          let ne = Math.floor(se), oe = Math.ceil(se), re = se - ne;
          for (let le = 0; le < h; le++) {
            let me = le + ne * k[2] + Y * k[1] + $ * k[0], ke = x[me];
            me = le + oe * k[2] + Y * k[1] + $ * k[0];
            let Se = x[me];
            me = le + ne * k[2] + Z * k[1] + $ * k[0];
            let Ee = x[me];
            me = le + oe * k[2] + Z * k[1] + $ * k[0];
            let Pe = x[me], Xe = ke + (Se - ke) * re, Je = Ee + (Pe - Ee) * re;
            me = le + ee * T[2] + q * T[1] + N * T[0], b.values[me] = Xe + (Je - Xe) * te;
          }
        }
      } else
        for (let Y = 0; Y < g; ++Y) {
          let Z = g > 1 ? P * (d - 1) + Y * W : 0.5 * (P + F) * (d - 1);
          if (Z < 0 || Z > d - 1) {
            for (let se = 0; se < h; se++) {
              let ne = se + Y * T[2] + q * T[1] + N * T[0];
              b.values[ne] = l;
            }
            continue;
          }
          let te = Math.round(Z), ee = Math.round(K);
          for (let se = 0; se < h; se++) {
            let ne = se + te * k[2] + ee * k[1] + $ * k[0], oe = se + Y * T[2] + q * T[1] + N * T[0];
            b.values[oe] = x[ne];
          }
        }
    }
  }
  return n.makeTensorInfo(b.shape, b.dtype, b.values);
}
var MH = { kernelName: co, backendName: "cpu", kernelFunc: zH };
function LH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { axis: a, exclusive: i, reverse: o } = s;
  be(r, "cumprod");
  let u = S.getAxesPermutation([a], r.shape.length), l = r;
  u != null && (l = wn({ inputs: { x: r }, backend: n, attrs: { perm: u } }));
  let c = S.getInnerMostAxes(1, r.shape.length)[0];
  if (c !== l.shape.length - 1)
    throw new Error(`backend.cumprod in CPU expects an inner-most axis=${l.shape.length - 1} but got axis=${c}`);
  let p = cn(l.dtype, "int32"), d = w.makeOnesTypedArray(w.sizeFromShape(l.shape), p), h = n.data.get(l.dataId).values, f = l.shape[l.shape.length - 1], m = o ? (b, y) => b + f - y - 1 : (b, y) => b + y;
  for (let b = 0; b < h.length; b += f)
    for (let y = 0; y < f; y++) {
      let v = m(b, y);
      if (y === 0)
        d[v] = i ? 1 : h[v];
      else {
        let x = m(b, y - 1);
        d[v] = i ? h[x] * d[x] : h[v] * d[x];
      }
    }
  let g = n.makeTensorInfo(l.shape, p, d);
  if (u != null) {
    let b = S.getUndoAxesPermutation(u), y = wn({ inputs: { x: g }, backend: n, attrs: { perm: b } });
    return n.disposeIntermediateTensorInfo(g), n.disposeIntermediateTensorInfo(l), y;
  }
  return g;
}
var BH = { kernelName: hl, backendName: "cpu", kernelFunc: LH };
function VH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { axis: a, exclusive: i, reverse: o } = s;
  be(r, "cumsum");
  let u = S.getAxesPermutation([a], r.shape.length), l = r;
  u != null && (l = wn({ inputs: { x: r }, backend: n, attrs: { perm: u } }));
  let c = S.getInnerMostAxes(1, r.shape.length)[0];
  if (c !== l.shape.length - 1)
    throw new Error(`backend.cumsum in CPU expects an inner-most axis=${l.shape.length - 1} but got axis=${c}`);
  let p = cn(l.dtype, "int32"), d = w.makeZerosTypedArray(w.sizeFromShape(l.shape), p), h = n.data.get(l.dataId).values, f = l.shape[l.shape.length - 1], m = o ? (b, y) => b + f - y - 1 : (b, y) => b + y;
  for (let b = 0; b < h.length; b += f)
    for (let y = 0; y < f; y++) {
      let v = m(b, y);
      if (y === 0)
        d[v] = i ? 0 : h[v];
      else {
        let x = m(b, y - 1);
        d[v] = i ? h[x] + d[x] : h[v] + d[x];
      }
    }
  let g = n.makeTensorInfo(l.shape, p, d);
  if (u != null) {
    let b = S.getUndoAxesPermutation(u), y = wn({ inputs: { x: g }, backend: n, attrs: { perm: b } });
    return n.disposeIntermediateTensorInfo(g), n.disposeIntermediateTensorInfo(l), y;
  }
  return g;
}
var WH = { kernelName: lo, backendName: "cpu", kernelFunc: VH };
function UH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r, weights: a } = t, { size: i, binaryOutput: o } = s;
  if (r.shape.length === 1) {
    let u = n.data.get(r.dataId).values, l = n.data.get(a.dataId).values, c = ev(u, l, a.dtype, a.shape, i);
    return n.makeTensorInfo([i], a.dtype, c);
  } else if (r.shape.length === 2) {
    let u = n.bufferSync(r), l = n.bufferSync(a), c = W0(u, l, i, o);
    return n.makeTensorInfo(c.shape, a.dtype, c.values);
  }
  throw new Error(`Error in denseBincount: input must be at most rank 2, but got rank${r.shape.length}.`);
}
var GH = { kernelName: hg, backendName: "cpu", kernelFunc: UH };
function HH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { blockSize: a, dataFormat: i } = s;
  w.assert(i === "NHWC", () => `Only NHWC dataFormat supported on CPU for depthToSpace. Got ${i}`);
  let o = r.shape[0], u = r.shape[1], l = r.shape[2], c = r.shape[3], p = u * a, d = l * a, h = c / (a * a), f = n.data.get(r.dataId).values, m = new Float32Array(o * p * d * h), g = 0;
  for (let b = 0; b < o; ++b)
    for (let y = 0; y < p; ++y) {
      let v = Math.floor(y / a), x = y % a;
      for (let k = 0; k < d; ++k) {
        let T = Math.floor(k / a), N = k % a, E = (x * a + N) * h;
        for (let A = 0; A < h; ++A) {
          let R = A + E + c * (T + l * (v + u * b));
          m[g++] = f[R];
        }
      }
    }
  return n.makeTensorInfo([o, p, d, h], r.dtype, m);
}
var qH = { kernelName: po, backendName: "cpu", kernelFunc: HH };
function DC(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r, filter: a } = t, { strides: i, pad: o, dilations: u, dimRoundingMode: l } = s;
  be([r, a], "depthwiseConv2DNative");
  let c = w.computeStrides(r.shape), p = w.computeStrides(a.shape), d = u;
  d == null && (d = [1, 1]), w.assert(S.eitherStridesOrDilationsAreOne(i, d), () => `Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${i} and dilations '${d}'`);
  let h = S.computeConv2DInfo(r.shape, a.shape, i, d, o, l, true), { filterHeight: f, filterWidth: m, dilationHeight: g, dilationWidth: b, padInfo: y } = h, v = y.left, x = y.top, k = h.outChannels / h.inChannels, T = new Vt(h.outShape, r.dtype), N = n.data.get(r.dataId).values, E = n.data.get(a.dataId).values, A = T.values;
  for (let P = 0; P < h.batchSize; ++P) {
    let R = P * c[0], F = P * T.strides[0];
    for (let $ = 0; $ < h.outHeight; ++$) {
      let z = F + $ * T.strides[1], W = $ * h.strideHeight - x;
      for (let q = 0; q < f; ++q) {
        let K = W + q * g;
        if (K < 0 || K >= h.inHeight)
          continue;
        let Y = q * p[0], Z = R + K * c[1];
        for (let te = 0; te < h.outWidth; ++te) {
          let ee = z + te * T.strides[2], se = te * h.strideWidth - v;
          for (let ne = 0; ne < m; ++ne) {
            let oe = se + ne * b;
            if (oe < 0 || oe >= h.inWidth)
              continue;
            let re = Y + ne * p[1], le = Z + oe * h.inChannels, me = ee, ke = re;
            for (let Se = 0; Se < h.inChannels; ++Se) {
              let Ee = N[le + Se];
              for (let Pe = 0; Pe < k; ++Pe)
                A[me + Pe] += Ee * E[ke + Pe];
              me += k, ke += k;
            }
          }
        }
      }
    }
  }
  return n.makeTensorInfo(T.shape, T.dtype, T.values);
}
var jH = { kernelName: Ra, backendName: "cpu", kernelFunc: DC };
function KH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r, dy: a } = t, { strides: i, dilations: o, pad: u, dimRoundingMode: l, filterShape: c } = s;
  be([r, a], "depthwiseConv2dNativeBackpropFilter");
  let p = S.computeConv2DInfo(r.shape, c, i, o, u, l, true), { strideHeight: d, strideWidth: h, filterHeight: f, filterWidth: m } = p, g = new Vt(p.filterShape, "float32"), b = p.padInfo.left, y = p.padInfo.top, v = p.outChannels / p.inChannels, x = n.data.get(r.dataId).values, k = new Vt(r.shape, r.dtype, x), T = n.data.get(a.dataId).values, N = new Vt(a.shape, a.dtype, T);
  for (let E = 0; E < f; ++E) {
    let A = Math.max(0, Math.ceil((y - E) / d)), P = Math.min(p.outHeight, (p.inHeight + y - E) / d);
    for (let R = 0; R < m; ++R) {
      let F = Math.max(0, Math.ceil((b - R) / h)), $ = Math.min(p.outWidth, (p.inWidth + b - R) / h);
      for (let z = 0; z < p.outChannels; ++z) {
        let W = Math.trunc(z / v), q = z % v, K = 0;
        for (let Y = 0; Y < p.batchSize; ++Y)
          for (let Z = A; Z < P; ++Z) {
            let te = E + Z * d - y;
            for (let ee = F; ee < $; ++ee) {
              let se = R + ee * h - b;
              K += k.get(Y, te, se, W) * N.get(Y, Z, ee, z);
            }
          }
        g.set(K, E, R, W, q);
      }
    }
  }
  return n.makeTensorInfo(g.shape, g.dtype, g.values);
}
var XH = { kernelName: fg, backendName: "cpu", kernelFunc: KH };
function YH(e) {
  let { inputs: t, backend: n, attrs: s } = e, { dy: r, filter: a } = t, { strides: i, dilations: o, pad: u, dimRoundingMode: l, inputShape: c } = s;
  be([r, a], "depthwiseConv2DNativeBackpropInput");
  let p = w.computeStrides(r.shape), d = w.computeStrides(a.shape), h = S.computeConv2DInfo(c, a.shape, i, o, u, l, true), f = new Vt(h.inShape, "float32"), m = f.values, [g, b, y] = f.strides, v = n.data.get(r.dataId).values, [x, k, T] = p, N = n.data.get(a.dataId).values, [E, A, P] = d, { batchSize: R, filterHeight: F, filterWidth: $, inChannels: z, inHeight: W, inWidth: q, outChannels: K, outHeight: Y, outWidth: Z, strideHeight: te, strideWidth: ee } = h, se = F - 1 - h.padInfo.top, ne = $ - 1 - h.padInfo.left, oe = K / z;
  for (let re = 0; re < R; ++re)
    for (let le = 0; le < z; ++le)
      for (let me = 0; me < W; ++me) {
        let ke = me - se, Se = Math.max(0, Math.ceil(ke / te)), Ee = Math.min(Y, (F + ke) / te);
        for (let Pe = 0; Pe < q; ++Pe) {
          let Xe = Pe - ne, Je = Math.max(0, Math.ceil(Xe / ee)), Ye = Math.min(Z, ($ + Xe) / ee), tt = 0;
          for (let Ce = Se; Ce < Ee; ++Ce) {
            let ut = Ce * te - ke;
            for (let at = Je; at < Ye; ++at) {
              let Jt = at * ee - Xe, Nt = x * re + k * Ce + T * at, Cn = E * (F - 1 - ut) + A * ($ - 1 - Jt) + P * le;
              for (let Et = 0; Et < oe; ++Et) {
                let en = le * oe + Et, Nn = v[Nt + en], Tn = N[Cn + Et];
                tt += Nn * Tn;
              }
            }
          }
          m[g * re + b * me + y * Pe + le] = tt;
        }
      }
  return n.makeTensorInfo(f.shape, f.dtype, f.values);
}
var QH = { kernelName: mg, backendName: "cpu", kernelFunc: YH };
function ZH(e) {
  let { inputs: t, backend: n } = e, { x: s } = t, r = w.sizeFromShape(s.shape), a = n.data.get(s.dataId).values, i = De([r, r], s.dtype), o = i.values;
  for (let l = 0; l < a.length; l++)
    o[l * r + l] = a[l];
  let u = [...s.shape, ...s.shape];
  return n.makeTensorInfo(u, i.dtype, i.values);
}
var JH = { kernelName: gg, backendName: "cpu", kernelFunc: ZH };
var e6 = { kernelName: Yd, backendName: "cpu", kernelFunc: ({ inputs: e, backend: t, attrs: n }) => {
  let { x: s, filter: r } = e, { strides: a, pad: i, dilations: o } = n, u = t, l = u.data.get(s.dataId).values, c = s.shape.length, p = u.data.get(r.dataId).values, d = r.shape.length, { batchSize: h, inHeight: f, inWidth: m, inChannels: g, outHeight: b, outWidth: y, padInfo: v, strideHeight: x, strideWidth: k, filterHeight: T, filterWidth: N, dilationHeight: E, dilationWidth: A, outShape: P } = S.computeDilation2DInfo(s.shape, r.shape, a, i, "NHWC", o), R = w.sizeFromShape(P), F = P.length, $ = w.getArrayFromDType(s.dtype, R);
  for (let W = 0; W < h; ++W)
    for (let q = 0; q < b; ++q) {
      let K = q * x - v.top;
      for (let Y = 0; Y < y; ++Y) {
        let Z = Y * k - v.left;
        for (let te = 0; te < g; ++te) {
          let ee = Number.MIN_SAFE_INTEGER;
          for (let ne = 0; ne < T; ++ne) {
            let oe = K + ne * E;
            if (oe >= 0 && oe < f)
              for (let re = 0; re < N; ++re) {
                let le = Z + re * A;
                if (le >= 0 && le < m) {
                  let me = w.locToIndex([W, oe, le, te], c, w.computeStrides(s.shape)), ke = w.locToIndex([ne, re, te], d, w.computeStrides(r.shape)), Se = l[me] + p[ke];
                  Se > ee && (ee = Se);
                }
              }
          }
          let se = w.locToIndex([W, q, Y, te], F, w.computeStrides(P));
          $[se] = ee;
        }
      }
    }
  return { dataId: u.write(w.toTypedArray($, s.dtype), P, s.dtype), shape: P, dtype: s.dtype };
} };
var t6 = { kernelName: Qf, backendName: "cpu", kernelFunc: ({ inputs: e, backend: t, attrs: n }) => {
  let { x: s, filter: r, dy: a } = e, { strides: i, pad: o, dilations: u } = n, l = t, c = w.toNestedArray(s.shape, l.data.get(s.dataId).values), p = w.toNestedArray(r.shape, l.data.get(r.dataId).values), { batchSize: d, inHeight: h, inWidth: f, inChannels: m, outHeight: g, outWidth: b, padInfo: y, strideHeight: v, strideWidth: x, filterHeight: k, filterWidth: T, dilationHeight: N, dilationWidth: E, outShape: A } = S.computeDilation2DInfo(s.shape, r.shape, i, o, "NHWC", u);
  w.assert(a.rank === A.length, () => `Error in ${Qf}, dy must have the same rank as output ${A.length}, but got ${a.rank}`);
  let P = w.toNestedArray(A, l.data.get(a.dataId).values), R = w.makeZerosNestedTypedArray(r.shape, r.dtype);
  for (let $ = 0; $ < d; ++$)
    for (let z = 0; z < g; ++z) {
      let W = z * v - y.top;
      for (let q = 0; q < b; ++q) {
        let K = q * x - y.left;
        for (let Y = 0; Y < m; ++Y) {
          let Z = Number.MIN_SAFE_INTEGER, te = 0, ee = 0;
          for (let se = 0; se < k; ++se) {
            let ne = W + se * N;
            if (ne >= 0 && ne < h)
              for (let oe = 0; oe < T; ++oe) {
                let re = K + oe * E;
                if (re >= 0 && re < f) {
                  let le = c[$][ne][re][Y] + p[se][oe][Y];
                  le > Z && (Z = le, te = se, ee = oe);
                }
              }
          }
          R[te][ee][Y] += P[$][z][q][Y];
        }
      }
    }
  return { dataId: l.write(w.toTypedArray(R, s.dtype), r.shape, r.dtype), shape: r.shape, dtype: r.dtype };
} };
var n6 = { kernelName: Yf, backendName: "cpu", kernelFunc: ({ inputs: e, backend: t, attrs: n }) => {
  let { x: s, filter: r, dy: a } = e, { strides: i, pad: o, dilations: u } = n, l = t, c = w.toNestedArray(s.shape, l.data.get(s.dataId).values), p = w.toNestedArray(r.shape, l.data.get(r.dataId).values), { batchSize: d, inHeight: h, inWidth: f, inChannels: m, outHeight: g, outWidth: b, padInfo: y, strideHeight: v, strideWidth: x, filterHeight: k, filterWidth: T, dilationHeight: N, dilationWidth: E, outShape: A } = S.computeDilation2DInfo(s.shape, r.shape, i, o, "NHWC", u);
  w.assert(a.rank === A.length, () => `Error in ${Yf}, dy must have the same rank as output ${A.length}, but got ${a.rank}`);
  let P = w.toNestedArray(A, l.data.get(a.dataId).values), R = w.makeZerosNestedTypedArray(s.shape, s.dtype);
  for (let $ = 0; $ < d; ++$)
    for (let z = 0; z < g; ++z) {
      let W = z * v - y.top;
      for (let q = 0; q < b; ++q) {
        let K = q * x - y.left;
        for (let Y = 0; Y < m; ++Y) {
          let Z = Number.MIN_SAFE_INTEGER, te = W < 0 ? 0 : W, ee = K < 0 ? 0 : K;
          for (let se = 0; se < k; ++se) {
            let ne = W + se * N;
            if (ne >= 0 && ne < h)
              for (let oe = 0; oe < T; ++oe) {
                let re = K + oe * E;
                if (re >= 0 && re < f) {
                  let le = c[$][ne][re][Y] + p[se][oe][Y];
                  le > Z && (Z = le, te = ne, ee = re);
                }
              }
          }
          R[$][te][ee][Y] += P[$][z][q][Y];
        }
      }
    }
  return { dataId: l.write(w.toTypedArray(R, s.dtype), s.shape, s.dtype), shape: s.shape, dtype: s.dtype };
} };
function Xl(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { axis: a, keepDims: i } = s;
  be(r, "sum");
  let o;
  r.dtype === "bool" ? o = xr({ inputs: { x: r }, backend: n, attrs: { dtype: "int32" } }) : o = Os({ inputs: { x: r }, backend: n });
  let u = o.shape.length, l = w.parseAxisParam(a, o.shape), c = S.getAxesPermutation(l, u), p = l, d = o;
  c != null && (d = wn({ inputs: { x: o }, backend: n, attrs: { perm: c } }), p = S.getInnerMostAxes(p.length, u)), S.assertAxesAreInnerMostDims("sum", p, d.shape.length);
  let [h, f] = S.computeOutAndReduceShapes(d.shape, p), m = S.upcastType(d.dtype, "int32"), g = Dd(n, h, m), b = w.sizeFromShape(f), y = n.data.get(g.dataId).values, v = n.data.get(d.dataId).values;
  for (let x = 0; x < y.length; ++x) {
    let k = x * b, T = 0;
    for (let N = 0; N < b; ++N)
      T += v[k + N];
    y[x] = T;
  }
  if (i) {
    let x = S.expandShapeToKeepDim(g.shape, l), k = g;
    g = mt({ inputs: { x: g }, backend: n, attrs: { shape: x } }), n.disposeIntermediateTensorInfo(k);
  }
  return n.disposeIntermediateTensorInfo(o), c != null && n.disposeIntermediateTensorInfo(d), g;
}
var s6 = { kernelName: oi, backendName: "cpu", kernelFunc: Xl };
function r6(e) {
  let { inputs: t, backend: n, attrs: s } = e, { equation: r } = s, a = t, { allDims: i, summedDims: o, idDims: u } = S.decodeEinsumEquation(r, a.length);
  S.checkEinsumDimSizes(i.length, u, a);
  let { path: l, steps: c } = S.getEinsumComputePath(o, u), p = c.length, d = null, h = i.length, f = [];
  for (let m = 0; m < p; ++m) {
    for (let g of c[m]) {
      let { permutationIndices: b, expandDims: y } = S.getEinsumPermutation(h, u[g]), v;
      S.isIdentityPermutation(b) ? v = a[g] : (v = wn({ inputs: { x: a[g] }, backend: n, attrs: { perm: b } }), f.push(v));
      let x = v.shape.slice();
      for (let k = 0; k < y.length; ++k)
        x.splice(y[k], 0, 1);
      w.arraysEqual(v.shape, x) || (v = mt({ inputs: { x: v }, backend: n, attrs: { shape: x } }), f.push(v)), d === null ? d = v : (d = Hp({ inputs: { a: v, b: d }, backend: n }), f.push(d));
    }
    m < p - 1 && (l[m] >= 0 && (d = Xl({ inputs: { x: d }, backend: n, attrs: { axis: l[m] - (i.length - h), keepDims: false } }), f.push(d)), h--);
  }
  for (let m of f)
    m !== d && n.disposeIntermediateTensorInfo(m);
  return d;
}
var a6 = { kernelName: Qd, backendName: "cpu", kernelFunc: r6 };
function i6(e) {
  let { inputs: t, backend: n } = e, { dy: s, y: r } = t;
  be([s, r], "eluGrad");
  let a = new Float32Array(w.sizeFromShape(r.shape)), i = n.data.get(r.dataId).values, o = n.data.get(s.dataId).values;
  for (let u = 0; u < i.length; ++u) {
    let l = i[u];
    l >= 1 ? a[u] = o[u] : a[u] = o[u] * (l + 1);
  }
  return n.makeTensorInfo(r.shape, "float32", a);
}
var o6 = { kernelName: bg, backendName: "cpu", kernelFunc: i6 };
var u6 = S.ERF_P;
var l6 = S.ERF_A1;
var c6 = S.ERF_A2;
var d6 = S.ERF_A3;
var p6 = S.ERF_A4;
var h6 = S.ERF_A5;
var f6 = st(fl, (e) => {
  let t = Math.sign(e), n = Math.abs(e), s = 1 / (1 + u6 * n);
  return t * (1 - ((((h6 * s + p6) * s + d6) * s + c6) * s + l6) * s * Math.exp(-n * n));
});
var m6 = { kernelName: fl, backendName: "cpu", kernelFunc: f6 };
function Od(e) {
  let { inputs: t, backend: n, attrs: s } = e, { input: r } = t, { dim: a } = s, i = r.shape.length, o = r.shape.slice(), u = a;
  return a < 0 && (w.assert(-(i + 1) <= a, () => `Axis must be in the interval [${-(i + 1)}, ${i}]`), u = i + a + 1), o.splice(u, 0, 1), mt({ inputs: { x: r }, backend: n, attrs: { shape: o } });
}
var g6 = { kernelName: fo, backendName: "cpu", kernelFunc: Od };
var b6 = At((e, t) => e / t);
var lv = Gt(Da, b6);
var Mm = { kernelName: Da, backendName: "cpu", kernelFunc: lv };
function FC(e, t, n) {
  let s = e.shape, r = s[0], a = s[1], i = n.data.get(e.dataId), o = i.complexTensorInfos.real, u = i.complexTensorInfos.imag, l = [r, a], c = w.sizeFromShape(l), p = w.getTypedArrayFromDType("float32", c), d = w.getTypedArrayFromDType("float32", c);
  for (let g = 0; g < r; g++) {
    let b = ga({ inputs: { x: o }, backend: n, attrs: { begin: [g, 0], size: [1, a] } }), y = ga({ inputs: { x: u }, backend: n, attrs: { begin: [g, 0], size: [1, a] } }), v = Rn({ inputs: { real: b, imag: y }, backend: n }), { real: x, imag: k } = y6(v, t, n), T = S.mergeRealAndImagArrays(x, k);
    for (let N = 0; N < a; N++) {
      let E = S.getComplexWithIndex(T, N);
      p[g * a + N] = E.real, d[g * a + N] = E.imag;
    }
    n.disposeIntermediateTensorInfo(b), n.disposeIntermediateTensorInfo(y), n.disposeIntermediateTensorInfo(v);
  }
  let h = n.makeTensorInfo(l, "float32", p), f = n.makeTensorInfo(l, "float32", d), m = Rn({ inputs: { real: h, imag: f }, backend: n });
  return n.disposeIntermediateTensorInfo(h), n.disposeIntermediateTensorInfo(f), m;
}
function y6(e, t, n) {
  let s = w.sizeFromShape(e.shape), r = n.data.get(e.dataId), a = n.data.get(r.complexTensorInfos.real.dataId).values, i = n.data.get(r.complexTensorInfos.imag.dataId).values;
  if (v6(s)) {
    let o = Lm(a, i, s, t, n), u = [e.shape[0], e.shape[1]];
    if (t) {
      let l = n.makeTensorInfo(u, "float32", o.real), c = n.makeTensorInfo(u, "float32", o.imag), p = n.makeTensorInfo([], "float32", w.createScalarValue(s, "float32")), d = Os({ inputs: { x: p }, backend: n }), h = Mm.kernelFunc({ inputs: { a: l, b: p }, backend: n }), f = Mm.kernelFunc({ inputs: { a: c, b: d }, backend: n }), m = n.data.get(h.dataId).values, g = n.data.get(f.dataId).values;
      return n.disposeIntermediateTensorInfo(l), n.disposeIntermediateTensorInfo(c), n.disposeIntermediateTensorInfo(p), n.disposeIntermediateTensorInfo(d), n.disposeIntermediateTensorInfo(h), n.disposeIntermediateTensorInfo(f), { real: m, imag: g };
    }
    return o;
  } else {
    let o = S.mergeRealAndImagArrays(a, i), u = x6(o, s, t);
    return S.splitRealAndImagArrays(u);
  }
}
function v6(e) {
  return (e & e - 1) === 0;
}
function Lm(e, t, n, s, r) {
  if (n === 1)
    return { real: e, imag: t };
  let a = S.mergeRealAndImagArrays(e, t), i = n / 2, o = S.complexWithEvenIndex(a), u = o.real, l = o.imag, c = [u.length], p = r.makeTensorInfo(c, "float32", u), d = r.makeTensorInfo(c, "float32", l), h = Rn({ inputs: { real: p, imag: d }, backend: r }), f = S.complexWithOddIndex(a), m = f.real, g = f.imag, b = [m.length], y = r.makeTensorInfo(b, "float32", m), v = r.makeTensorInfo(b, "float32", g), x = Rn({ inputs: { real: y, imag: v }, backend: r }), k = Lm(u, l, i, s, r), T = k.real, N = k.imag, E = [T.length], A = r.makeTensorInfo(E, "float32", T), P = r.makeTensorInfo(E, "float32", N), R = Rn({ inputs: { real: A, imag: P }, backend: r }), F = Lm(m, g, i, s, r), $ = F.real, z = F.imag, W = [$.length], q = r.makeTensorInfo(W, "float32", $), K = r.makeTensorInfo(W, "float32", z), Y = Rn({ inputs: { real: q, imag: K }, backend: r }), Z = S.exponents(n, s), te = [Z.real.length], ee = r.makeTensorInfo(te, "float32", Z.real), se = r.makeTensorInfo(te, "float32", Z.imag), ne = Rn({ inputs: { real: ee, imag: se }, backend: r }), oe = Hp({ inputs: { a: ne, b: Y }, backend: r }), re = Kl({ inputs: { a: R, b: oe }, backend: r }), le = iv({ inputs: { a: R, b: oe }, backend: r }), me = ma({ inputs: { input: re }, backend: r }), ke = ma({ inputs: { input: le }, backend: r }), Se = no({ inputs: { input: re }, backend: r }), Ee = no({ inputs: { input: le }, backend: r }), Pe = so({ inputs: [me, ke], backend: r, attrs: { axis: 0 } }), Xe = so({ inputs: [Se, Ee], backend: r, attrs: { axis: 0 } }), Je = r.data.get(Pe.dataId).values, Ye = r.data.get(Xe.dataId).values;
  return r.disposeIntermediateTensorInfo(p), r.disposeIntermediateTensorInfo(d), r.disposeIntermediateTensorInfo(h), r.disposeIntermediateTensorInfo(y), r.disposeIntermediateTensorInfo(v), r.disposeIntermediateTensorInfo(x), r.disposeIntermediateTensorInfo(A), r.disposeIntermediateTensorInfo(P), r.disposeIntermediateTensorInfo(R), r.disposeIntermediateTensorInfo(q), r.disposeIntermediateTensorInfo(K), r.disposeIntermediateTensorInfo(Y), r.disposeIntermediateTensorInfo(ee), r.disposeIntermediateTensorInfo(se), r.disposeIntermediateTensorInfo(ne), r.disposeIntermediateTensorInfo(oe), r.disposeIntermediateTensorInfo(re), r.disposeIntermediateTensorInfo(le), r.disposeIntermediateTensorInfo(me), r.disposeIntermediateTensorInfo(Se), r.disposeIntermediateTensorInfo(ke), r.disposeIntermediateTensorInfo(Ee), r.disposeIntermediateTensorInfo(Pe), r.disposeIntermediateTensorInfo(Xe), { real: Je, imag: Ye };
}
function x6(e, t, n) {
  let s = new Float32Array(t * 2);
  for (let r = 0; r < t; r++) {
    let a = 0, i = 0;
    for (let o = 0; o < t; o++) {
      let u = S.exponent(r * o, t, n), l = S.getComplexWithIndex(e, o);
      a += l.real * u.real - l.imag * u.imag, i += l.real * u.imag + l.imag * u.real;
    }
    n && (a /= t, i /= t), S.assignToTypedArray(s, a, i, r);
  }
  return s;
}
function w6(e) {
  let { inputs: t, backend: n } = e, { input: s } = t, r = w.sizeFromShape(s.shape), a = s.shape[s.shape.length - 1], i = r / a, o = mt({ inputs: { x: s }, backend: n, attrs: { shape: [i, a] } }), u = FC(o, false, n), l = mt({ inputs: { x: u }, backend: n, attrs: { shape: s.shape } });
  return n.disposeIntermediateTensorInfo(o), n.disposeIntermediateTensorInfo(u), l;
}
var k6 = { kernelName: yg, backendName: "cpu", kernelFunc: w6 };
function cv(e) {
  let { backend: t, attrs: n } = e, { shape: s, value: r, dtype: a } = n, i = a || w.inferDtype(r), o = w.getArrayFromDType(i, w.sizeFromShape(s));
  return S6(o, r, i), t.makeTensorInfo(s, i, o);
}
var I6 = { kernelName: ml, backendName: "cpu", kernelFunc: cv };
function S6(e, t, n) {
  e.fill(t);
}
var C6 = { kernelName: go, backendName: "cpu", kernelFunc: ({ inputs: e, attrs: t, backend: n }) => {
  let { image: s } = e, r = n, a = w.getTypedArrayFromDType(s.dtype, w.sizeFromShape(s.shape)), [i, o, u, l] = s.shape, c = r.data.get(s.dataId).values;
  for (let d = 0; d < i; d++) {
    let h = d * u * o * l;
    for (let f = 0; f < o; f++) {
      let m = f * (u * l);
      for (let g = 0; g < u; g++) {
        let b = g * l;
        for (let y = 0; y < l; y++) {
          let v = Math.round(u - g - 1), x = h + m + b + y, k = c[x];
          if (v >= 0 && v < u) {
            let T = v * l, N = h + m + T + y;
            k = c[N];
          }
          a[x] = k;
        }
      }
    }
  }
  return { dataId: r.write(a, s.shape, s.dtype), shape: s.shape, dtype: s.dtype };
} };
var N6 = At((e, t) => Math.floor(e / t));
var T6 = Gt(za, N6, null, "int32");
var $6 = { kernelName: za, backendName: "cpu", kernelFunc: T6 };
function _6(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r, filter: a, bias: i, preluActivationWeights: o } = t, { strides: u, pad: l, dataFormat: c, dilations: p, dimRoundingMode: d, activation: h, leakyreluAlpha: f } = s, m = RC({ inputs: { x: r, filter: a }, backend: n, attrs: { strides: u, pad: l, dataFormat: c, dilations: p, dimRoundingMode: d } });
  if (i) {
    let g = m;
    m = Kl({ inputs: { a: m, b: i }, backend: n }), n.disposeIntermediateTensorInfo(g);
  }
  if (h) {
    let g = m;
    m = ov(n, m, h, o, f), n.disposeIntermediateTensorInfo(g);
  }
  return m;
}
var A6 = { kernelName: aa, backendName: "cpu", kernelFunc: _6 };
function E6(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r, filter: a, bias: i, preluActivationWeights: o } = t, { strides: u, pad: l, dataFormat: c, dilations: p, dimRoundingMode: d, activation: h, leakyreluAlpha: f } = s, m = DC({ inputs: { x: r, filter: a }, backend: n, attrs: { strides: u, pad: l, dataFormat: c, dilations: p, dimRoundingMode: d } });
  if (i) {
    let g = m;
    m = Kl({ inputs: { a: m, b: i }, backend: n }), n.disposeIntermediateTensorInfo(g);
  }
  if (h) {
    let g = m;
    m = ov(n, m, h, o, f), n.disposeIntermediateTensorInfo(g);
  }
  return m;
}
var R6 = { kernelName: ia, backendName: "cpu", kernelFunc: E6 };
function D6(e) {
  let { inputs: t, backend: n } = e, { params: s, indices: r } = t, a = w.sizeFromShape(s.shape), i = r.shape, o = i[i.length - 1], [u, l, c, p] = S.prepareAndValidate(s, r);
  if (l === 0)
    return n.makeTensorInfo(u, s.dtype, []);
  let d = n.data.get(r.dataId).values, h = n.bufferSync(s), f = Y0(d, h, s.dtype, l, o, c, p, s.shape, a);
  return n.makeTensorInfo(u, s.dtype, f.values);
}
var F6 = { kernelName: yo, backendName: "cpu", kernelFunc: D6 };
function O6(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r, indices: a } = t, { axis: i, batchDims: o } = s;
  be([r, a], "gatherV2");
  let u = w.parseAxisParam(i, r.shape)[0], l = n.data.get(a.dataId).values, c = r.shape[u];
  for (let x = 0; x < l.length; ++x) {
    let k = l[x];
    w.assert(k <= c - 1 && k >= 0, () => `GatherV2: the index value ${k} is not in [0, ${c - 1}]`);
  }
  let p = o;
  o == null && (p = 0);
  let d = w.sizeFromShape(a.shape), h = S.segment_util.collectGatherOpShapeInfo(r, a, u, p), f = mt({ inputs: { x: r }, backend: n, attrs: { shape: [h.batchSize, h.outerSize, h.dimSize, h.sliceSize] } }), m = mt({ inputs: { x: a }, backend: n, attrs: { shape: [h.batchSize, d / h.batchSize] } }), g = [h.batchSize, h.outerSize, d / h.batchSize, h.sliceSize], b = n.bufferSync(m), y = n.bufferSync(f), v = Q0(y, b, g);
  return n.disposeIntermediateTensorInfo(f), n.disposeIntermediateTensorInfo(m), n.makeTensorInfo(h.outputShape, v.dtype, v.values);
}
var P6 = { kernelName: bo, backendName: "cpu", kernelFunc: O6 };
function z6(e) {
  let { inputs: t, backend: n } = e, { input: s } = t, r = w.sizeFromShape(s.shape), a = s.shape[s.shape.length - 1], i = r / a, o = mt({ inputs: { x: s }, backend: n, attrs: { shape: [i, a] } }), u = FC(o, true, n), l = mt({ inputs: { x: u }, backend: n, attrs: { shape: s.shape } });
  return n.disposeIntermediateTensorInfo(o), n.disposeIntermediateTensorInfo(u), l;
}
var M6 = { kernelName: vg, backendName: "cpu", kernelFunc: z6 };
var L6 = st(gl, (e) => Number.isFinite(e) ? 1 : 0, "bool");
var B6 = { kernelName: gl, backendName: "cpu", kernelFunc: L6 };
var V6 = st(bl, (e) => Math.abs(e) === 1 / 0 ? 1 : 0, "bool");
var W6 = { kernelName: bl, backendName: "cpu", kernelFunc: V6 };
var U6 = st(yl, (e) => Number.isNaN(e) ? 1 : 0, "bool");
var G6 = { kernelName: yl, backendName: "cpu", kernelFunc: U6 };
function H6(e) {
  let { backend: t, attrs: n } = e, { start: s, stop: r, num: a } = n, i = nC(s, r, a);
  return t.makeTensorInfo([i.length], "float32", i);
}
var q6 = { kernelName: xg, backendName: "cpu", kernelFunc: H6 };
var j6 = st(vl, (e) => Math.log1p(e));
var K6 = { kernelName: vl, backendName: "cpu", kernelFunc: j6 };
var X6 = At((e, t) => e && t);
var Y6 = Gt(ko, X6, null, "bool");
var Q6 = { kernelName: ko, backendName: "cpu", kernelFunc: Y6 };
var Z6 = st(xl, (e) => e ? 0 : 1, "bool");
var J6 = { kernelName: xl, backendName: "cpu", kernelFunc: Z6 };
var eq = At((e, t) => e || t);
var tq = Gt(Jd, eq, null, "bool");
var nq = { kernelName: Jd, backendName: "cpu", kernelFunc: tq };
function sq(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { depthRadius: a, bias: i, alpha: o, beta: u } = s;
  be(r, "LRN");
  let l = r.shape[3], c = l - 1, p = n.data.get(r.dataId).values, d = w.sizeFromShape(r.shape), h = new Float32Array(d);
  function f(m) {
    let g = m % l, b = m - g + Math.max(0, g - a), y = m - g + Math.min(g + a, c), v = 0;
    for (; b <= y; b++) {
      let x = p[b];
      v += x * x;
    }
    return v;
  }
  for (let m = 0; m < d; m++) {
    let g = f(m), b = p[m] * Math.pow(i + o * g, -u);
    h[m] = b;
  }
  return n.makeTensorInfo(r.shape, r.dtype, h);
}
var rq = { kernelName: ep, backendName: "cpu", kernelFunc: sq };
function aq(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r, y: a, dy: i } = t, { depthRadius: o, bias: u, alpha: l, beta: c } = s;
  be(i, "LRNGrad");
  let p = w.sizeFromShape(i.shape), d = i.shape[3], h = n.data.get(i.dataId).values, f = n.data.get(r.dataId).values, m = n.data.get(a.dataId).values, g = new Float32Array(p), b = p;
  for (let y = 0; y < b; y++) {
    let v = y % d, x = y - v + Math.max(0, v - o), k = y - v + Math.min(d, v + o + 1), T = 0;
    for (let N = x; N < k; N++)
      T += Math.pow(f[N], 2);
    T = l * T + u;
    for (let N = x; N < k; N++) {
      let E = -2 * l * c * f[N] * m[y] / T;
      y === N && (E += Math.pow(T, -c)), E *= h[y], g[N] += E;
    }
  }
  return n.makeTensorInfo(i.shape, r.dtype, g);
}
var iq = { kernelName: wg, backendName: "cpu", kernelFunc: aq };
function OC(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { reductionIndices: a, keepDims: i } = s, o = n, u = r.shape, l = u.length, c = w.parseAxisParam(a, u), p = c, d = S.getAxesPermutation(p, l), h = o.data.get(r.dataId).values;
  if (d != null) {
    let x = new Array(l);
    for (let k = 0; k < x.length; k++)
      x[k] = u[d[k]];
    h = sv(h, u, r.dtype, d, x), p = S.getInnerMostAxes(p.length, l), u = x;
  }
  be(r, "max"), S.assertAxesAreInnerMostDims("max", p, l);
  let [f, m] = S.computeOutAndReduceShapes(u, p), g = w.sizeFromShape(m), b = rC(h, g, f, r.dtype), y = o.write(b, f, r.dtype), v = f;
  return i && (v = S.expandShapeToKeepDim(f, c)), { dataId: y, shape: v, dtype: r.dtype };
}
var oq = { kernelName: Ua, backendName: "cpu", kernelFunc: OC };
function uq(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t;
  be(r, "maxPool");
  let { filterSize: a, strides: i, pad: o, dimRoundingMode: u } = s, l = 1;
  w.assert(S.eitherStridesOrDilationsAreOne(i, l), () => `Error in maxPool: Either strides or dilations must be 1. Got strides ${i} and dilations '${l}'`);
  let c = S.computePool2DInfo(r.shape, a, i, l, o, u), p;
  if (c.filterWidth === 1 && c.filterHeight === 1 && w.arraysEqual(c.inShape, c.outShape))
    p = Os({ inputs: { x: r }, backend: n });
  else {
    let d = n.data.get(r.dataId).values, h = w.computeStrides(r.shape), f = uv(d, r.shape, r.dtype, h, c, "max");
    p = n.makeTensorInfo(c.outShape, r.dtype, f.values);
  }
  return p;
}
var lq = { kernelName: Ha, backendName: "cpu", kernelFunc: uq };
function cq(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { filterSize: a, strides: i, pad: o, dimRoundingMode: u, dataFormat: l } = s;
  be(r, "maxPool3d");
  let c = S.computePool3DInfo(r.shape, a, i, 1, o, u, l), p = n.data.get(r.dataId).values, d = EC(p, r.shape, r.dtype, w.computeStrides(r.shape), c, "max");
  return n.makeTensorInfo(d.shape, "float32", d.values);
}
var dq = { kernelName: tp, backendName: "cpu", kernelFunc: cq };
function pq(e) {
  let { inputs: t, backend: n, attrs: s } = e, { dy: r, input: a } = t, { filterSize: i, strides: o, pad: u, dimRoundingMode: l } = s;
  be([r, a], "maxPool3DGrad");
  let c = S.computePool3DInfo(a.shape, i, o, 1, u, l), p = n.bufferSync(a), d = JG(p, c), h = c.strideDepth, f = c.strideHeight, m = c.strideWidth, g = c.dilationDepth, b = c.dilationHeight, y = c.dilationWidth, v = c.effectiveFilterDepth, x = c.effectiveFilterHeight, k = c.effectiveFilterWidth, T = v - 1 - c.padInfo.front, N = k - 1 - c.padInfo.left, E = x - 1 - c.padInfo.top, A = De(a.shape, "float32"), P = n.bufferSync(r);
  for (let R = 0; R < c.batchSize; ++R)
    for (let F = 0; F < c.inChannels; ++F)
      for (let $ = 0; $ < c.inDepth; ++$)
        for (let z = 0; z < c.inHeight; ++z)
          for (let W = 0; W < c.inWidth; ++W) {
            let q = $ - T, K = z - E, Y = W - N, Z = 0;
            for (let te = 0; te < v; te += g) {
              let ee = (q + te) / h;
              if (!(ee < 0 || ee >= c.outDepth || Math.floor(ee) !== ee))
                for (let se = 0; se < x; se += b) {
                  let ne = (K + se) / f;
                  if (!(ne < 0 || ne >= c.outHeight || Math.floor(ne) !== ne))
                    for (let oe = 0; oe < k; oe += y) {
                      let re = (Y + oe) / m;
                      if (re < 0 || re >= c.outWidth || Math.floor(re) !== re)
                        continue;
                      let le = v * x * k - 1 - d.get(R, ee, ne, re, F), me = te * x * k + se * k + oe, ke = le === me ? 1 : 0;
                      if (ke === 0)
                        continue;
                      Z += P.get(R, ee, ne, re, F) * ke;
                    }
                }
            }
            A.set(Z, R, $, z, W, F);
          }
  return n.makeTensorInfo(A.shape, A.dtype, A.values);
}
var hq = { kernelName: Ig, backendName: "cpu", kernelFunc: pq };
function fq(e) {
  let { inputs: t, backend: n, attrs: s } = e, { dy: r, input: a, output: i } = t, o = a;
  be([a, i], "maxPoolGrad");
  let { filterSize: u, strides: l, pad: c, dimRoundingMode: p } = s, d = S.computePool2DInfo(o.shape, u, l, 1, c, p), h = n.data.get(o.dataId).values, f = De(d.outShape, o.dtype, AC(h, o.shape, o.dtype, d).values), m = d.strideHeight, g = d.strideWidth, b = d.dilationHeight, y = d.dilationWidth, v = d.effectiveFilterHeight, x = d.effectiveFilterWidth, k = x - 1 - d.padInfo.left, T = v - 1 - d.padInfo.top, N = De(o.shape, "float32"), E = n.data.get(r.dataId).values, A = De(r.shape, "float32", E);
  for (let P = 0; P < d.batchSize; ++P)
    for (let R = 0; R < d.inChannels; ++R)
      for (let F = 0; F < d.inHeight; ++F)
        for (let $ = 0; $ < d.inWidth; ++$) {
          let z = F - T, W = $ - k, q = 0;
          for (let K = 0; K < v; K += b) {
            let Y = (z + K) / m;
            if (!(Y < 0 || Y >= d.outHeight || Math.floor(Y) !== Y))
              for (let Z = 0; Z < x; Z += y) {
                let te = (W + Z) / g;
                if (te < 0 || te >= d.outWidth || Math.floor(te) !== te)
                  continue;
                let ee = v * x - 1 - f.get(P, Y, te, R), se = K * x + Z, ne = ee === se ? 1 : 0;
                if (ne === 0)
                  continue;
                q += A.get(P, Y, te, R) * ne;
              }
          }
          N.set(q, P, F, $, R);
        }
  return n.makeTensorInfo(N.shape, N.dtype, N.values);
}
var mq = { kernelName: kg, backendName: "cpu", kernelFunc: fq };
function gq(e, t, n, s, r) {
  let a = w.computeStrides(t), i = uv(e, t, n, a, r, "max"), o = AC(e, t, n, r, true, s);
  return [i.values, o.values];
}
var bq = { kernelName: Sg, backendName: "cpu", kernelFunc: ({ inputs: e, attrs: t, backend: n }) => {
  let { x: s } = e, { filterSize: r, strides: a, pad: i, includeBatchInIndex: o } = t, u = n;
  be(s, "MaxPoolWithArgmax");
  let l = u.data.get(s.dataId).values, c = S.computePool2DInfo(s.shape, r, a, [1, 1], i), [p, d] = gq(l, s.shape, s.dtype, o, c), h = u.write(p, c.outShape, s.dtype), f = u.write(d, c.outShape, s.dtype);
  return [{ dataId: h, shape: c.outShape, dtype: s.dtype }, { dataId: f, shape: c.outShape, dtype: "int32" }];
} };
function yq(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { axis: a, keepDims: i } = s, o = w.parseAxisParam(a, r.shape), l = S.computeOutAndReduceShapes(r.shape, o)[1], c = w.sizeFromShape(l), p = [], d = n.makeTensorInfo([], "float32", new Float32Array([c]));
  p.push(d);
  let h = xr({ inputs: { x: r }, backend: n, attrs: { dtype: "float32" } });
  p.push(h);
  let f = lv({ inputs: { a: h, b: d }, backend: n });
  p.push(f);
  let m = Xl({ inputs: { x: f }, backend: n, attrs: { axis: a, keepDims: i } });
  return p.forEach((g) => n.disposeIntermediateTensorInfo(g)), m;
}
var vq = { kernelName: qa, backendName: "cpu", kernelFunc: yq };
function xq(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { axis: a, keepDims: i } = s;
  be(r, "min");
  let o = w.parseAxisParam(a, r.shape), u = o, l = S.getAxesPermutation(u, r.shape.length), c = r;
  l != null && (c = wn({ inputs: { x: r }, backend: n, attrs: { perm: l } }), u = S.getInnerMostAxes(u.length, r.shape.length)), S.assertAxesAreInnerMostDims("min", u, c.shape.length);
  let [p, d] = S.computeOutAndReduceShapes(c.shape, u), h = w.sizeFromShape(d), f = w.makeZerosTypedArray(w.sizeFromShape(p), c.dtype), m = n.data.get(c.dataId).values;
  for (let b = 0; b < f.length; ++b) {
    let y = b * h, v = m[y];
    for (let x = 0; x < h; ++x) {
      let k = m[y + x];
      (Number.isNaN(k) || k < v) && (v = k);
    }
    f[b] = v;
  }
  l != null && n.disposeIntermediateTensorInfo(c);
  let g = n.makeTensorInfo(p, c.dtype, f);
  if (i) {
    let b = S.expandShapeToKeepDim(p, o), y = mt({ inputs: { x: g }, backend: n, attrs: { shape: b } });
    return n.disposeIntermediateTensorInfo(g), y;
  }
  return g;
}
var wq = { kernelName: ja, backendName: "cpu", kernelFunc: xq };
function kq(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { paddings: a, mode: i } = s;
  be(r, "mirrorPad");
  let o = a.map((v, x) => v[0] + r.shape[x] + v[1]), u = a.map((v) => v[0]), l = a.map((v, x) => v[0] + r.shape[x]), c = i === "reflect" ? 0 : 1, p = n.data.get(r.dataId).values, d = r.shape.length, h = w.computeStrides(r.shape), f = w.sizeFromShape(o), m = o.length, g = w.computeStrides(o), b = w.getTypedArrayFromDType(r.dtype, f);
  for (let v = 0; v < f; v++) {
    let x = w.indexToLoc(v, m, g);
    for (let T = 0; T < m; T++)
      x[T] < u[T] ? x[T] = u[T] * 2 - x[T] - c : x[T] >= l[T] && (x[T] = (l[T] - 1) * 2 - x[T] + c);
    x = x.map((T, N) => T - u[N]);
    let k = w.locToIndex(x, d, h);
    b[v] = p[k];
  }
  return { dataId: n.write(b, o, r.dtype), shape: o, dtype: r.dtype };
}
var Iq = { kernelName: Xa, backendName: "cpu", kernelFunc: kq };
var Sq = At((e, t) => {
  let n = e % t;
  return e < 0 && t < 0 || e >= 0 && t >= 0 ? n : (n + t) % t;
});
var Cq = Gt(wl, Sq);
var Nq = { kernelName: wl, backendName: "cpu", kernelFunc: Cq };
var Tq = xa(Wd());
function PC(e) {
  let { inputs: t, backend: n, attrs: s } = e, { logits: r } = t, { dim: a } = s, i = r.shape.length, o = a;
  if (o === -1 && (o = i - 1), o !== i - 1)
    throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${i} and dim was ${o}`);
  let u = w.parseAxisParam([o], r.shape), l = OC({ inputs: { x: r }, backend: n, attrs: { reductionIndices: u, keepDims: false } }), c = S.expandShapeToKeepDim(l.shape, u), p = mt({ inputs: { x: l }, backend: n, attrs: { shape: c } }), d = iv({ inputs: { a: r, b: p }, backend: n }), h = j0({ inputs: { x: d }, backend: n }), f = Xl({ inputs: { x: h }, backend: n, attrs: { axis: u, keepDims: false } }), m = mt({ inputs: { x: f }, backend: n, attrs: { shape: c } }), g = lv({ inputs: { a: h, b: m }, backend: n });
  return n.disposeIntermediateTensorInfo(l), n.disposeIntermediateTensorInfo(p), n.disposeIntermediateTensorInfo(d), n.disposeIntermediateTensorInfo(h), n.disposeIntermediateTensorInfo(f), n.disposeIntermediateTensorInfo(m), g;
}
var $q = { kernelName: ui, backendName: "cpu", kernelFunc: PC };
function _q(e) {
  let { inputs: t, backend: n, attrs: s } = e, { logits: r } = t, { numSamples: a, seed: i, normalized: o } = s;
  be(r, "multinomial");
  let u = o ? r : PC({ inputs: { logits: r }, backend: n, attrs: { dim: -1 } }), l = u.shape[0], c = u.shape[1], p = n.data.get(u.dataId).values, d = [l, a], h = w.makeZerosTypedArray(w.sizeFromShape(d), "int32");
  for (let f = 0; f < l; ++f) {
    let m = f * c, g = new Float32Array(c - 1);
    g[0] = p[m];
    for (let v = 1; v < g.length; ++v)
      g[v] = g[v - 1] + p[m + v];
    let b = Tq.alea(i.toString()), y = f * a;
    for (let v = 0; v < a; ++v) {
      let x = b();
      h[y + v] = g.length;
      for (let k = 0; k < g.length; k++)
        if (x < g[k]) {
          h[y + v] = k;
          break;
        }
    }
  }
  return o || n.disposeIntermediateTensorInfo(u), n.makeTensorInfo(d, "int32", h);
}
var Aq = { kernelName: Cg, backendName: "cpu", kernelFunc: _q };
var Eq = xs.nonMaxSuppressionV3Impl;
function Rq(e) {
  let { inputs: t, backend: n, attrs: s } = e, { boxes: r, scores: a } = t, { maxOutputSize: i, iouThreshold: o, scoreThreshold: u } = s;
  be(r, "NonMaxSuppression");
  let l = n.data.get(r.dataId).values, c = n.data.get(a.dataId).values, { selectedIndices: p } = Eq(l, c, i, o, u);
  return n.makeTensorInfo([p.length], "int32", new Int32Array(p));
}
var Dq = { kernelName: Co, backendName: "cpu", kernelFunc: Rq };
var Fq = xs.nonMaxSuppressionV4Impl;
function Oq(e) {
  let { inputs: t, backend: n, attrs: s } = e, { boxes: r, scores: a } = t, { maxOutputSize: i, iouThreshold: o, scoreThreshold: u, padToMaxOutputSize: l } = s;
  be(r, "NonMaxSuppressionPadded");
  let c = n.data.get(r.dataId).values, p = n.data.get(a.dataId).values, { selectedIndices: d, validOutputs: h } = Fq(c, p, i, o, u, l);
  return [n.makeTensorInfo([d.length], "int32", new Int32Array(d)), n.makeTensorInfo([], "int32", new Int32Array([h]))];
}
var Pq = { kernelName: kl, backendName: "cpu", kernelFunc: Oq };
var zq = xs.nonMaxSuppressionV5Impl;
function Mq(e) {
  let { inputs: t, backend: n, attrs: s } = e, { boxes: r, scores: a } = t, { maxOutputSize: i, iouThreshold: o, scoreThreshold: u, softNmsSigma: l } = s;
  be(r, "NonMaxSuppressionWithScore");
  let c = n.data.get(r.dataId).values, p = n.data.get(a.dataId).values, d = i, h = o, f = u, m = l, { selectedIndices: g, selectedScores: b } = zq(c, p, d, h, f, m);
  return [n.makeTensorInfo([g.length], "int32", new Int32Array(g)), n.makeTensorInfo([b.length], "float32", new Float32Array(b))];
}
var Lq = { kernelName: No, backendName: "cpu", kernelFunc: Mq };
function Bq(e) {
  let { inputs: t, backend: n, attrs: s } = e, { indices: r } = t, { depth: a, onValue: i, offValue: o } = s;
  be(r, "oneHot");
  let u = w.sizeFromShape(r.shape), l = new Float32Array(u * a);
  l.fill(o);
  let c = n.data.get(r.dataId).values;
  for (let p = 0; p < u; ++p)
    c[p] >= 0 && c[p] < a && (l[p * a + c[p]] = i);
  return n.makeTensorInfo([...r.shape, a], "int32", l);
}
var Vq = { kernelName: $o, backendName: "cpu", kernelFunc: Bq };
function Pd(e) {
  let { inputs: t, backend: n } = e, { x: s } = t;
  if (s.dtype === "string")
    throw new Error("zerosLike is not supported for string tensors");
  if (s.dtype === "complex64") {
    let r = ma({ inputs: { input: s }, backend: n }), a = Pd({ inputs: { x: r }, backend: n }), i = no({ inputs: { input: s }, backend: n }), o = Pd({ inputs: { x: i }, backend: n }), u = Rn({ inputs: { real: a, imag: o }, backend: n });
    return n.disposeIntermediateTensorInfo(r), n.disposeIntermediateTensorInfo(a), n.disposeIntermediateTensorInfo(i), n.disposeIntermediateTensorInfo(o), u;
  } else
    return cv({ backend: n, attrs: { shape: s.shape, value: 0, dtype: s.dtype } });
}
var Wq = { kernelName: Ho, backendName: "cpu", kernelFunc: Pd };
function zC(e) {
  let { inputs: t, backend: n } = e, { x: s } = t;
  if (s.dtype === "string")
    throw new Error("onesLike is not supported for string tensors");
  if (s.dtype === "complex64") {
    let r = ma({ inputs: { input: s }, backend: n }), a = zC({ inputs: { x: r }, backend: n }), i = no({ inputs: { input: s }, backend: n }), o = Pd({ inputs: { x: i }, backend: n }), u = Rn({ inputs: { real: a, imag: o }, backend: n });
    return n.disposeIntermediateTensorInfo(r), n.disposeIntermediateTensorInfo(a), n.disposeIntermediateTensorInfo(i), n.disposeIntermediateTensorInfo(o), u;
  } else
    return cv({ backend: n, attrs: { shape: s.shape, value: 1, dtype: s.dtype } });
}
var Uq = { kernelName: To, backendName: "cpu", kernelFunc: zC };
function MC(e) {
  let { inputs: t, backend: n, attrs: s } = e, { axis: r } = s;
  if (t.length === 1)
    return Od({ inputs: { input: t[0] }, backend: n, attrs: { dim: r } });
  let a = t[0].shape, i = t[0].dtype;
  t.forEach((c) => {
    w.assertShapesMatch(a, c.shape, "All tensors passed to stack must have matching shapes"), w.assert(i === c.dtype, () => "All tensors passed to stack must have matching dtypes");
  });
  let o = [], u = t.map((c) => {
    let p = Od({ inputs: { input: c }, backend: n, attrs: { dim: r } });
    return o.push(p), p;
  }), l = so({ inputs: u, backend: n, attrs: { axis: r } });
  return o.forEach((c) => n.disposeIntermediateTensorInfo(c)), l;
}
var Gq = { kernelName: _o, backendName: "cpu", kernelFunc: MC };
function Hq(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { paddings: a, constantValue: i } = s;
  be(r, "pad");
  let o = a.map((y, v) => y[0] + r.shape[v] + y[1]), u = a.map((y) => y[0]), l = n.data.get(r.dataId).values, c = w.sizeFromShape(r.shape), p = r.shape.length, d = w.computeStrides(r.shape), h = w.sizeFromShape(o), f = o.length, m = w.computeStrides(o), g = w.getTypedArrayFromDType(r.dtype, h);
  i !== 0 && g.fill(i);
  for (let y = 0; y < c; y++) {
    let x = w.indexToLoc(y, p, d).map((T, N) => T + u[N]), k = w.locToIndex(x, f, m);
    g[k] = l[y];
  }
  return { dataId: n.write(g, o, r.dtype), shape: o, dtype: r.dtype };
}
var LC = { kernelName: Qa, backendName: "cpu", kernelFunc: Hq };
var qq = At((e, t) => Math.pow(e, t));
var jq = Gt(Za, qq);
var Kq = { kernelName: Za, backendName: "cpu", kernelFunc: jq };
function Xq(e) {
  let { backend: t, attrs: n } = e, { start: s, stop: r, dtype: a, step: i } = n, o = rv(s, r, i, a);
  return t.makeTensorInfo([o.length], a, o);
}
var Yq = { kernelName: Il, backendName: "cpu", kernelFunc: Xq };
var Qq = st(Sl, (e) => 1 / e);
var Zq = { kernelName: Sl, backendName: "cpu", kernelFunc: Qq };
function Jq(e) {
  let { inputs: t, backend: n, attrs: s } = e, { images: r } = t, { alignCorners: a, halfPixelCenters: i, size: o } = s;
  be(r, "resizeBilinear");
  let u = w.computeStrides(r.shape), [l, c] = o, [p, d, h, f] = r.shape, m = n.data.get(r.dataId).values, g = new Float32Array(w.sizeFromShape([p, l, c, f])), b = [a && l > 1 ? d - 1 : d, a && c > 1 ? h - 1 : h], y = [a && l > 1 ? l - 1 : l, a && c > 1 ? c - 1 : c], v = 0, x = b[0] / y[0], k = b[1] / y[1];
  for (let T = 0; T < p; T++)
    for (let N = 0; N < l; N++) {
      let E;
      i ? E = x * (N + 0.5) - 0.5 : E = x * N;
      let A = Math.max(0, Math.floor(E)), P = E - A, R = Math.min(d - 1, Math.ceil(E)), F = T * u[0] + A * u[1], $ = T * u[0] + R * u[1];
      for (let z = 0; z < c; z++) {
        let W;
        i ? W = k * (z + 0.5) - 0.5 : W = k * z;
        let q = Math.max(0, Math.floor(W)), K = W - q, Y = Math.min(h - 1, Math.ceil(W)), Z = F + q * u[2], te = $ + q * u[2], ee = F + Y * u[2], se = $ + Y * u[2];
        for (let ne = 0; ne < f; ne++) {
          let oe = m[Z + ne], re = m[te + ne], le = m[ee + ne], me = m[se + ne], ke = oe + (le - oe) * K, Se = re + (me - re) * K, Ee = ke + (Se - ke) * P;
          g[v++] = Ee;
        }
      }
    }
  return n.makeTensorInfo([p, l, c, f], "float32", g);
}
var ej = { kernelName: ti, backendName: "cpu", kernelFunc: Jq };
function tj(e) {
  let { inputs: t, backend: n, attrs: s } = e, { images: r, dy: a } = t, { alignCorners: i } = s;
  be([a, r], "resizeBilinearGrad");
  let o = w.computeStrides(r.shape), [u, l, c, p] = r.shape, [, d, h] = a.shape, f = new Float32Array(u * l * c * p), m = [i && d > 1 ? l - 1 : l, i && h > 1 ? c - 1 : c], g = [i && d > 1 ? d - 1 : d, i && h > 1 ? h - 1 : h], b = m[0] / g[0], y = m[1] / g[1], v = n.data.get(a.dataId).values, x = 0;
  for (let k = 0; k < u; k++) {
    let T = k * o[0];
    for (let N = 0; N < d; N++) {
      let E = N * b, A = Math.floor(E), P = Math.min(Math.ceil(E), l - 1), R = T + A * o[1], F = T + P * o[1], $ = E - A, z = 1 - $;
      for (let W = 0; W < h; W++) {
        let q = W * y, K = Math.floor(q), Y = Math.min(Math.ceil(q), c - 1), Z = q - K, te = 1 - Z, ee = R + K * o[2], se = R + Y * o[2], ne = F + K * o[2], oe = F + Y * o[2], re = z * te, le = z * Z, me = $ * te, ke = $ * Z;
        for (let Se = 0; Se < p; Se++) {
          let Ee = v[x++];
          f[ee + Se] += Ee * re, f[se + Se] += Ee * le, f[ne + Se] += Ee * me, f[oe + Se] += Ee * ke;
        }
      }
    }
  }
  return n.makeTensorInfo([u, c, l, p], "float32", f);
}
var nj = { kernelName: Tg, backendName: "cpu", kernelFunc: tj };
function sj(e) {
  let { inputs: t, backend: n, attrs: s } = e, { images: r } = t, { alignCorners: a, halfPixelCenters: i, size: o } = s;
  be(r, "resizeNearestNeighbor");
  let u = w.computeStrides(r.shape), [l, c] = o, [p, d, h, f] = r.shape, m = n.data.get(r.dataId).values, g = new Float32Array(p * l * c * f), b = [a && l > 1 ? d - 1 : d, a && c > 1 ? h - 1 : h], y = [a && l > 1 ? l - 1 : l, a && c > 1 ? c - 1 : c], v = b[0] / y[0], x = b[1] / y[1], k = 0;
  for (let T = 0; T < p; T++) {
    let N = T * u[0];
    for (let E = 0; E < l; E++) {
      let A = i ? v * (E + 0.5) : v * E, P = Math.min(d - 1, a ? Math.round(A) : Math.floor(A));
      i && (P = Math.max(0, P));
      let R = N + P * u[1];
      for (let F = 0; F < c; F++) {
        let $ = i ? x * (F + 0.5) : x * F, z = Math.min(h - 1, a ? Math.round($) : Math.floor($));
        i && (z = Math.max(0, z));
        let W = R + z * u[2];
        for (let q = 0; q < f; q++) {
          let K = m[W + q];
          g[k++] = K;
        }
      }
    }
  }
  return n.makeTensorInfo([p, l, c, f], r.dtype, g);
}
var rj = { kernelName: Cl, backendName: "cpu", kernelFunc: sj };
function aj(e) {
  let { inputs: t, backend: n, attrs: s } = e, { images: r, dy: a } = t, { alignCorners: i } = s;
  be([a, r], "resizeNearestNeighborGrad");
  let o = w.computeStrides(r.shape), u = w.computeStrides(a.shape), [l, c, p, d] = r.shape, [, h, f] = a.shape, m = new Float32Array(l * c * p * d), g = n.data.get(a.dataId).values, b = [i && h > 1 ? c - 1 : c, i && f > 1 ? p - 1 : p], y = [i && h > 1 ? h - 1 : h, i && f > 1 ? f - 1 : f], v = b[0] / y[0], x = b[1] / y[1], k = 1 / v, T = 1 / x, N = Math.ceil(k) * 2 + 2, E = Math.ceil(T) * 2 + 2;
  for (let A = 0; A < l; A++) {
    let P = A * o[0];
    for (let R = 0; R < c; R++) {
      let F = P + R * o[1], $ = Math.floor(R * k), z = Math.floor($ - N / 2);
      for (let W = 0; W < p; W++) {
        let q = F + W * o[2], K = Math.floor(W * T), Y = Math.floor(K - E / 2);
        for (let Z = 0; Z < d; Z++) {
          let te = 0;
          for (let ee = 0; ee < N; ee++) {
            let se = ee + z;
            if (se < 0 || se >= h)
              continue;
            let ne = P + se * u[1], oe = se * v, re = Math.min(c - 1, i ? Math.round(oe) : Math.floor(oe));
            if (R === re)
              for (let le = 0; le < E; le++) {
                let me = le + Y;
                if (me < 0 || me >= f)
                  continue;
                let ke = ne + me * u[2], Se = me * x, Ee = Math.min(p - 1, i ? Math.round(Se) : Math.floor(Se));
                W === Ee && (te += g[ke + Z]);
              }
          }
          m[q + Z] = te;
        }
      }
    }
  }
  return n.makeTensorInfo(r.shape, r.dtype, m);
}
var ij = { kernelName: Ng, backendName: "cpu", kernelFunc: aj };
function oj(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { dims: a } = s;
  be(r, "reverse");
  let i = r.shape.length, o = w.parseAxisParam(a, r.shape);
  if (i === 0)
    return Os({ inputs: { x: r }, backend: n });
  let u = new Vt(r.shape, r.dtype), l = n.bufferSync(r);
  for (let c = 0; c < u.size; c++) {
    let p = u.indexToLoc(c), d = p.slice();
    o.forEach((h) => d[h] = r.shape[h] - 1 - d[h]), u.set(l.get(...d), ...p);
  }
  return n.makeTensorInfo(u.shape, u.dtype, u.values);
}
var uj = { kernelName: Ro, backendName: "cpu", kernelFunc: oj };
var lj = { kernelName: qo, backendName: "cpu", kernelFunc: ({ inputs: e, attrs: t, backend: n }) => {
  let { image: s } = e, { radians: r, fillValue: a, center: i } = t, o = n, u = w.getTypedArrayFromDType(s.dtype, w.sizeFromShape(s.shape)), [l, c, p, d] = s.shape, [h, f] = S.getImageCenter(i, c, p), m = 255, g = Math.sin(r), b = Math.cos(r), y = o.data.get(s.dataId).values;
  for (let x = 0; x < l; x++) {
    let k = x * p * c * d;
    for (let T = 0; T < c; T++) {
      let N = T * (p * d);
      for (let E = 0; E < p; E++) {
        let A = E * d;
        for (let P = 0; P < d; P++) {
          let R = [l, T, E, P], F = R[2], $ = R[1], z = (F - h) * b - ($ - f) * g, W = (F - h) * g + ($ - f) * b;
          z = Math.round(z + h), W = Math.round(W + f);
          let q = a;
          if (typeof a != "number" && (P === 3 ? q = m : q = a[P]), z >= 0 && z < p && W >= 0 && W < c) {
            let Y = W * (p * d), Z = z * d, te = k + Y + Z + P;
            q = y[te];
          }
          let K = k + N + A + P;
          u[K] = q;
        }
      }
    }
  }
  return { dataId: o.write(u, s.shape, s.dtype), shape: s.shape, dtype: s.dtype };
} };
var cj = st(Do, (e) => {
  let t = Math.floor(e);
  return e - t < 0.5 ? Math.floor(e) : e - t > 0.5 ? Math.ceil(e) : t % 2 === 0 ? t : t + 1;
});
var dj = { kernelName: Do, backendName: "cpu", kernelFunc: cj };
function BC(e, t, n, s, r, a, i, o, u, l) {
  let c = [s / r, r], p = e.values, d = t.values;
  if (s === 0)
    return De(n, t.dtype);
  let h = De(c, t.dtype);
  h.values.fill(u);
  for (let f = 0; f < a; f++) {
    let m = [], g = 0;
    for (let b = 0; b < i; b++) {
      let y = p[f * i + b];
      m.push(y), g += y * o[b];
    }
    if (g < 0 || g >= s / r)
      throw new Error(`Invalid indices: ${m} does not index into ${n}`);
    for (let b = 0; b < r; b++)
      l ? h.values[g * r + b] += d[f * r + b] : h.values[g * r + b] = t.rank === 0 ? d[0] : d[f * r + b];
  }
  return h;
}
function pj(e) {
  let { inputs: t, backend: n, attrs: s } = e, { indices: r, updates: a } = t, { shape: i } = s, { sliceRank: o, numUpdates: u, sliceSize: l, strides: c, outputSize: p } = S.calculateShapes(a, r, i), d = true, h = n.bufferSync(r), f = n.bufferSync(a), m = BC(h, f, i, p, l, u, o, c, 0, d);
  return n.makeTensorInfo(i, m.dtype, m.values);
}
var hj = { kernelName: Fo, backendName: "cpu", kernelFunc: pj };
function fj(e) {
  let { inputs: t, backend: n } = e, { condition: s, t: r, e: a } = t;
  be([s, r, a], "select");
  let i = s.shape.length, o = n.data.get(s.dataId).values, u = n.data.get(r.dataId).values, l = n.data.get(a.dataId).values, c = cn(r.dtype, a.dtype), p = w.makeZerosTypedArray(w.sizeFromShape(r.shape), c), d = 0, h = i === 0 || i > 1 || r.shape.length === 1 ? 1 : w.sizeFromShape(r.shape.slice(1));
  for (let f = 0; f < o.length; f++)
    for (let m = 0; m < h; m++)
      o[f] === 1 ? p[d++] = u[f] : p[d++] = l[f];
  return n.makeTensorInfo(r.shape, c, p);
}
var mj = { kernelName: Oo, backendName: "cpu", kernelFunc: fj };
var gj = S.SELU_SCALEALPHA;
var bj = S.SELU_SCALE;
var yj = st(Nl, (e) => e >= 0 ? bj * e : gj * (Math.exp(e) - 1));
var vj = { kernelName: Nl, backendName: "cpu", kernelFunc: yj };
var xj = st(Tl, (e) => e < 0 ? -1 : e > 0 ? 1 : 0);
var wj = { kernelName: Tl, backendName: "cpu", kernelFunc: xj };
var kj = st(ri, (e) => Math.sin(e));
var Ij = { kernelName: ri, backendName: "cpu", kernelFunc: kj };
var Sj = st(zo, (e) => Math.sinh(e));
var Cj = { kernelName: zo, backendName: "cpu", kernelFunc: Sj };
var Nj = 11920928955078125e-23;
var nw = Math.log(Nj) + 2;
var Tj = st($l, (e) => {
  let t = e > -nw, n = e < nw, s = Math.exp(e), r;
  return n ? r = s : t ? r = e : r = Math.log(1 + s), r;
});
var $j = { kernelName: $l, backendName: "cpu", kernelFunc: Tj };
function _j(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { blockShape: a, paddings: i } = s;
  be([r], "spaceToBatchND");
  let o = w.sizeFromShape(a), u = [[0, 0]];
  u.push(...i);
  for (let T = 1 + a.length; T < r.shape.length; ++T)
    u.push([0, 0]);
  let l = LC.kernelFunc({ inputs: { x: r }, backend: n, attrs: { paddings: u, constantValue: 0 } }), c = S.getReshaped(l.shape, a, o, false), p = S.getPermuted(c.length, a.length, false), d = S.getReshapedPermuted(l.shape, a, o, false), m = mt({ inputs: { x: l }, backend: n, attrs: { shape: c } }), y = wn({ inputs: { x: m }, backend: n, attrs: { perm: p } }), k = mt({ inputs: { x: y }, backend: n, attrs: { shape: d } });
  return n.disposeIntermediateTensorInfo(l), n.disposeIntermediateTensorInfo(m), n.disposeIntermediateTensorInfo(y), k;
}
var Aj = { kernelName: Mo, backendName: "cpu", kernelFunc: _j };
function Ej(e) {
  let { inputs: t, backend: n } = e, { indices: s, values: r, denseShape: a, defaultValue: i } = t;
  if (a.shape.length !== 1)
    throw new Error(`Dense shape must be a vector, saw:
        ${a.shape}`);
  if (s.shape.length !== 2)
    throw new Error(`Indices must be a matrix, saw:
        ${s.shape}`);
  if (r.shape.length !== 1)
    throw new Error(`Values must be a vector, saw:
        ${r.shape}`);
  if (i.shape.length !== 0)
    throw new Error(`Default value must be a scalar, saw:
        ${i.shape}`);
  let o = n.data.get(s.dataId).values, u = n.data.get(r.dataId).values, l = n.data.get(a.dataId).values, c = n.data.get(i.dataId).values[0], [p, d, h, f, m] = pC(o, s.shape, s.dtype, u, r.dtype, l, c);
  return [n.makeTensorInfo(d, s.dtype, p), n.makeTensorInfo([d[0]], r.dtype, h), n.makeTensorInfo([f.length], "bool", new Uint8Array(f.map((g) => Number(g)))), n.makeTensorInfo([m.length], s.dtype, new Int32Array(m))];
}
var Rj = { kernelName: sp, backendName: "cpu", kernelFunc: Ej };
function Dj(e) {
  let { inputs: t, backend: n } = e, { inputIndices: s, inputShape: r, newShape: a } = t;
  if (s.shape.length !== 2)
    throw new Error(`Input indices should be a matrix but received shape
        ${s.shape}`);
  if (r.shape.length !== 1)
    throw new Error(`Input shape should be a vector but received shape
        ${r.shape}`);
  if (a.shape.length !== 1)
    throw new Error(`Target shape should be a vector but received shape ${a.shape}`);
  let i = Array.from(n.data.get(r.dataId).values), o = n.data.get(s.dataId).values, u = Array.from(n.data.get(a.dataId).values), [l, c, p] = hC(o, s.shape, s.dtype, i, u);
  return [n.makeTensorInfo(c, s.dtype, l), n.makeTensorInfo([p.length], a.dtype, new Int32Array(p))];
}
var Fj = { kernelName: _l, backendName: "cpu", kernelFunc: Dj };
function Oj(e) {
  let { inputs: t, backend: n } = e, { data: s, indices: r, segmentIds: a } = t;
  if (s.shape.length < 1)
    throw new Error("Data should be at least 1 dimensional but received scalar");
  if (r.shape.length !== 1)
    throw new Error(`Indices should be a vector but received shape
          ${r.shape}`);
  if (a.shape.length !== 1)
    throw new Error(`Segment ids should be a vector but received shape
          ${a.shape}`);
  if (r.shape[0] !== a.shape[0])
    throw new Error("segmentIds and indices should have same size.");
  let i = n.data.get(s.dataId).values, o = n.data.get(r.dataId).values, u = n.data.get(a.dataId).values, [l, c] = av(i, s.shape, s.dtype, o, u, true);
  return n.makeTensorInfo(c, s.dtype, l);
}
var Pj = { kernelName: rp, backendName: "cpu", kernelFunc: Oj };
function zj(e) {
  let { inputs: t, backend: n } = e, { data: s, indices: r, segmentIds: a } = t;
  if (s.shape.length < 1)
    throw new Error("Data should be at least 1 dimensional but received scalar");
  if (r.shape.length !== 1)
    throw new Error(`Indices should be a vector but received shape
         ${r.shape}`);
  if (a.shape.length !== 1)
    throw new Error(`Segment ids should be a vector but received shape
         ${a.shape}`);
  if (r.shape[0] !== a.shape[0])
    throw new Error("segmentIds and indices should have same size.");
  let i = n.data.get(s.dataId).values, o = n.data.get(r.dataId).values, u = n.data.get(a.dataId).values, [l, c] = av(i, s.shape, s.dtype, o, u);
  return n.makeTensorInfo(c, s.dtype, l);
}
var Mj = { kernelName: ap, backendName: "cpu", kernelFunc: zj };
function Lj(e) {
  let { inputs: t, backend: n, attrs: s } = e, { sparseIndices: r, sparseValues: a, defaultValue: i } = t, { outputShape: o } = s, { sliceRank: u, numUpdates: l, sliceSize: c, strides: p, outputSize: d } = S.calculateShapes(a, r, o), h = false, f = n.bufferSync(r), m = n.bufferSync(a), g = n.data.get(i.dataId).values[0], b = BC(f, m, o, d, c, l, u, p, g, h);
  return n.makeTensorInfo(o, b.dtype, b.values);
}
var Bj = { kernelName: ip, backendName: "cpu", kernelFunc: Lj };
function Vj(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { numOrSizeSplits: a, axis: i } = s, o = w.parseAxisParam(i, r.shape)[0], u = S.prepareSplitSize(r, a, o), l = new Array(r.shape.length).fill(0), c = r.shape.slice();
  return u.map((p) => {
    let d = [...c];
    d[o] = p;
    let h = ga({ inputs: { x: r }, backend: n, attrs: { begin: l, size: d } });
    return l[o] += p, h;
  });
}
var Wj = { kernelName: Lo, backendName: "cpu", kernelFunc: Vj };
var Uj = { kernelName: Al, backendName: "cpu", kernelFunc: ({ inputs: e, backend: t }) => {
  let { x: n } = e, s = t;
  be(n, "square");
  let r = s.data.get(n.dataId).values, a = new Float32Array(r.length);
  for (let o = 0; o < r.length; ++o) {
    let u = r[o];
    a[o] = u * u;
  }
  return { dataId: s.write(a, n.shape, n.dtype), shape: n.shape, dtype: n.dtype };
} };
var Gj = st(hi, (e, t) => {
  let n = t;
  return isNaN(e) ? NaN : e > 0 ? 1 : n.alpha;
});
var Hj = { kernelName: hi, backendName: "cpu", kernelFunc: Gj };
function qj(e) {
  let { inputs: t, backend: n, attrs: s } = e, { x: r } = t, { begin: a, end: i, strides: o, beginMask: u, endMask: l, ellipsisMask: c, newAxisMask: p, shrinkAxisMask: d } = s;
  be(r, "stridedSlice");
  let { finalShapeSparse: h, finalShape: f, isIdentity: m, sliceDim0: g, isSimpleSlice: b, begin: y, end: v, strides: x } = wt.sliceInfo(r.shape, a, i, o, u, l, c, p, d), k;
  if (m)
    k = mt({ inputs: { x: r }, backend: n, attrs: { shape: f } });
  else if (g || b) {
    w.assert(r.shape.length >= 1, () => `Input must have rank at least 1, got: ${r.shape.length}`);
    let T = wt.computeOutShape(y, v, x), N = ga({ inputs: { x: r }, backend: n, attrs: { begin: y, size: T } });
    k = mt({ inputs: { x: N }, backend: n, attrs: { shape: f } }), n.disposeIntermediateTensorInfo(N);
  } else {
    let T = n.bufferSync(r), N = mC(h, T, x, y);
    k = n.makeTensorInfo(f, N.dtype, N.values);
  }
  return k;
}
var jj = { kernelName: Bo, backendName: "cpu", kernelFunc: qj };
function Kj(e) {
  let { inputs: t, backend: n, attrs: s } = e, { separator: r, nGramWidths: a, leftPad: i, rightPad: o, padWidth: u, preserveShortSequences: l } = s, { data: c, dataSplits: p } = t, d = n.data.get(c.dataId).values, h = n.data.get(p.dataId).values, [f, m] = gC(d, h, r, a, i, o, u, l);
  return [n.makeTensorInfo([f.length], "string", f), n.makeTensorInfo(p.shape, "int32", m)];
}
var Xj = { kernelName: op, backendName: "cpu", kernelFunc: Kj };
function Yj(e) {
  let { inputs: t, backend: n, attrs: s } = e, { skipEmpty: r } = s, { input: a, delimiter: i } = t;
  if (a.dtype !== "string")
    throw new Error("Input must be of datatype string");
  if (a.shape.length !== 1)
    throw new Error(`Input must be a vector, got shape: ${a.shape}`);
  if (i.shape.length !== 0)
    throw new Error(`Delimiter must be a scalar, got shape: ${i.shape}`);
  let o = n.data.get(a.dataId).values, u = n.data.get(i.dataId).values[0], [l, c, p] = bC(o, u, r), d = c.length;
  return [n.makeTensorInfo([d, 2], "int32", l), n.makeTensorInfo([d], "string", c), n.makeTensorInfo([2], "int32", new Int32Array(p))];
}
var Qj = { kernelName: $g, backendName: "cpu", kernelFunc: Yj };
function Zj(e) {
  let { inputs: t, backend: n, attrs: s } = e, { numBuckets: r } = s, { input: a } = t;
  if (a.dtype !== "string")
    throw new Error("Input must be of datatype string");
  if (r <= 0)
    throw new Error("Number of buckets must be at least 1");
  let i = n.data.get(a.dataId).values, o = yC(i, r);
  return n.makeTensorInfo(a.shape, "int32", o);
}
var Jj = { kernelName: _g, backendName: "cpu", kernelFunc: Zj };
var e5 = st(Vo, (e) => Math.tan(e));
var t5 = { kernelName: Vo, backendName: "cpu", kernelFunc: e5 };
var n5 = st(di, (e) => Math.tanh(e));
var