/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@tensorflow/tfjs-core"),require("path"),require("fs"),require("worker_threads"),require("perf_hooks"),require("os")):"function"==typeof define&&define.amd?define(["exports","@tensorflow/tfjs-core","path","fs","worker_threads","perf_hooks","os"],t):t(((e=e||self).tf=e.tf||{},e.tf.wasm=e.tf.wasm||{}),e.tf,e.path,e.fs,e.worker_threads,e.perf_hooks,e.os)}(this,(function(e,t,n,a,r,s,u){"use strict";var i,o;let d;n=n&&Object.prototype.hasOwnProperty.call(n,"default")?n.default:n,a=a&&Object.prototype.hasOwnProperty.call(a,"default")?a.default:a,r=r&&Object.prototype.hasOwnProperty.call(r,"default")?r.default:r,s=s&&Object.prototype.hasOwnProperty.call(s,"default")?s.default:s,u=u&&Object.prototype.hasOwnProperty.call(u,"default")?u.default:u,function(e){e[e.float32=0]="float32",e[e.int32=1]="int32",e[e.bool=2]="bool",e[e.string=3]="string",e[e.complex64=4]="complex64"}(i||(i={})),function(e){e[e.linear=0]="linear",e[e.relu=1]="relu",e[e.relu6=2]="relu6",e[e.prelu=3]="prelu",e[e.leakyrelu=4]="leakyrelu",e[e.sigmoid=5]="sigmoid",e[e.elu=6]="elu"}(o||(o={}));const c={kernelName:t._FusedMatMul,backendName:"wasm",setupFunc:function(e){d=e.wasm.cwrap(t._FusedMatMul,null,["number","array","number","number","array","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){const{inputs:n,backend:a,attrs:r}=e,{a:s,b:u,bias:i,preluActivationWeights:c}=n;if("float32"!==s.dtype||"float32"!==u.dtype)throw new Error("_FusedMatMul for non non-float32 tensors not yet supported.");const{transposeA:l,transposeB:p,activation:m,leakyreluAlpha:f}=r,h=a.dataIdMap.get(s.dataId).id,b=a.dataIdMap.get(u.dataId).id;let y=0;if(null!=i){const e=a.dataIdMap.get(i.dataId);if(1!==e.shape.length)throw new Error(`_FusedMatMul only supports rank-1 bias but got rank ${e.shape.length}.`);y=e.id}const g=null==c?0:a.dataIdMap.get(c.dataId).id,_=o[m];if(null==_)throw new Error(`${m} activation not yet supported for FusedConv2D in the wasm backend.`);const k=l?s.shape[2]:s.shape[1],w=p?u.shape[1]:u.shape[2],I=t.broadcast_util.assertAndGetBroadcastShape(s.shape.slice(0,-2),u.shape.slice(0,-2)),S=a.makeOutput([...I,k,w],s.dtype),v=a.dataIdMap.get(S.dataId).id,M=new Uint8Array(new Int32Array(s.shape).buffer),A=new Uint8Array(new Int32Array(u.shape).buffer);return d(h,M,s.shape.length,b,A,u.shape.length,l,p,_,y,g,f||0,v),S}};function l(e,n){let a;return{kernelName:e,backendName:"wasm",setupFunc:function(t){a=t.wasm.cwrap(e,null,["number","number","number"])},kernelFunc:function(e){const{backend:r,inputs:{x:s}}=e,u=r.dataIdMap.get(s.dataId).id,o=r.makeOutput(s.shape,n||s.dtype),d=r.dataIdMap.get(o.dataId).id;return 0===t.util.sizeFromShape(o.shape)||a(u,i[s.dtype],d),o}}}const p=l(t.Abs);function m(e,n,a){let r;return{kernelName:e,backendName:"wasm",setupFunc:function(t){r=t.wasm.cwrap(e,null,["number","array","number","number","array","number","number","number"])},kernelFunc:function(e){const{backend:n,inputs:s}=e,{a:u,b:o}=s,d=n.dataIdMap.get(u.dataId).id,c=n.dataIdMap.get(o.dataId).id,l=null!=a?a:u.dtype,p=t.backend_util.assertAndGetBroadcastShape(u.shape,o.shape),m=n.makeOutput(p,l);if(0===t.util.sizeFromShape(p))return m;const f=new Uint8Array(new Int32Array(u.shape).buffer),h=new Uint8Array(new Int32Array(o.shape).buffer),b=n.dataIdMap.get(m.dataId).id;return r(d,f,u.shape.length,c,h,o.shape.length,i[u.dtype],b),m}}}const f=m(t.Add);let h;const b={kernelName:t.AddN,backendName:"wasm",setupFunc:function(e){h=e.wasm.cwrap(t.AddN,null,["array","number","number","number"])},kernelFunc:function(e){const{inputs:n,backend:a}=e,r=a.makeOutput(n[0].shape,n[0].dtype);if(0===t.util.sizeFromShape(r.shape))return r;const s=n.map((e=>a.dataIdMap.get(e.dataId).id)),u=new Uint8Array(new Int32Array(s).buffer),o=a.dataIdMap.get(r.dataId).id;return h(u,s.length,i[r.dtype],o),r}};function y(e){const{inputs:{x:t},backend:n}=e,a=n.makeOutput(t.shape,t.dtype),r=n.typedArrayFromHeap(t);return n.typedArrayFromHeap(a).set(r),a}const g={kernelName:t.Identity,backendName:"wasm",kernelFunc:y};let _;function k(e){const{inputs:t,backend:n,attrs:a}=e,[r,s]=function(e,t){const n=[],a=[];for(let r=0;r<e.length;++r)1!==e[r]&&n.push(e[r]),1!==e[t[r]]&&a.push(t[r]);for(let e=0;e<a.length;++e){let t=-1;for(let n=0;n<a.length;++n)a[n]>=e&&(-1===t||a[t]>a[n])&&(t=n);a[t]=e}return[n,a]}(t.x.shape,a.perm);let u=!0;for(let e=0;e<s.length;e++)s[e]!==e&&(u=!1);const o=function(e,t){const n=new Array(e.length);for(let a=0;a<n.length;a++)n[a]=e[t[a]];return n}(t.x.shape,a.perm),d={dataId:t.x.dataId,shape:r,dtype:t.x.dtype};if(u){const e=y({inputs:t,backend:n});return e.shape=o,e}const c=n.makeOutput(o,d.dtype),l=n.dataIdMap.get(d.dataId).id,p=n.dataIdMap.get(c.dataId).id,m=new Uint8Array(new Int32Array(s).buffer),f=new Uint8Array(new Int32Array(d.shape).buffer);return _(l,f,d.shape.length,i[d.dtype],p,m,s.length),c}const w={kernelName:t.Transpose,backendName:"wasm",kernelFunc:k,setupFunc:function(e){_=e.wasm.cwrap(t.Transpose,null,["number","array","number","number","number","array","number"])}};function I(e,n,a){const r=e.shape,s=e.shape.length,u=t.util.parseAxisParam(n,r);let i=u;const o=t.backend_util.getAxesPermutation(i,s);let d=null,c=!1;if(null!=o){const n=new Array(s);for(let e=0;e<n.length;e++)n[e]=r[o[e]];i=t.backend_util.getInnerMostAxes(i.length,s),d=k({inputs:{x:e},attrs:{perm:o},backend:a});const u=a.dataIdMap.get(e.dataId).id;a.dataIdMap.get(d.dataId).id!==u&&(c=!0)}return{transposed:d,originalAxes:u,axes:i,inputWasTransposed:c}}let S;const v={kernelName:t.All,backendName:"wasm",setupFunc:function(e){S=e.wasm.cwrap(t.All,null,["number, number, number"])},kernelFunc:function(e){const{backend:n,inputs:a,attrs:r}=e,{axis:s,keepDims:u}=r,{x:i}=a;let o=n.dataIdMap.get(i.dataId).id,d=i;const{transposed:c,axes:l,originalAxes:p,inputWasTransposed:m}=I(i,s,n);if(m){d=c,o=n.dataIdMap.get(c.dataId).id}const f=d.shape.length;t.backend_util.assertAxesAreInnerMostDims("all",l,f);const[h,b]=t.backend_util.computeOutAndReduceShapes(d.shape,l),y=t.util.sizeFromShape(b),g=n.makeOutput(h,i.dtype);if(0!==t.util.sizeFromShape(d.shape)){const e=n.dataIdMap.get(g.dataId).id;S(o,y,e)}if(m&&n.disposeData(c.dataId),u){const e=t.backend_util.expandShapeToKeepDim(g.shape,p);g.shape=e}return g}};let M;const A={kernelName:t.Any,backendName:"wasm",setupFunc:function(e){M=e.wasm.cwrap(t.Any,null,["number, number, number"])},kernelFunc:function(e){const{backend:n,inputs:a,attrs:r}=e,{axis:s,keepDims:u}=r,{x:i}=a;let o=n.dataIdMap.get(i.dataId).id,d=i;const{transposed:c,axes:l,originalAxes:p,inputWasTransposed:m}=I(i,s,n);if(m){d=c,o=n.dataIdMap.get(c.dataId).id}const f=d.shape.length;t.backend_util.assertAxesAreInnerMostDims("any",l,f);const[h,b]=t.backend_util.computeOutAndReduceShapes(d.shape,l),y=t.util.sizeFromShape(b),g=n.makeOutput(h,i.dtype);if(0!==t.util.sizeFromShape(d.shape)){const e=n.dataIdMap.get(g.dataId).id;M(o,y,e)}if(m&&n.disposeData(c.dataId),u){const e=t.backend_util.expandShapeToKeepDim(g.shape,p);g.shape=e}return g}};let E;const x={kernelName:t.ArgMax,backendName:"wasm",kernelFunc:function(e){const{backend:n,inputs:a,attrs:r}=e,{axis:s}=r,{x:u}=a,o=n.dataIdMap.get(u.dataId).id;let d=o,c=u;const{transposed:l,axes:p,inputWasTransposed:m}=I(u,s,n);if(m){const e=n.dataIdMap.get(l.dataId).id;e!==o&&(c=l,d=e)}const f=c.shape.slice(0,-1),h=n.makeOutput(f,"int32"),b=n.dataIdMap.get(h.dataId).id,y=t.util.sizeFromShape(h.shape),g=c.shape[p[0]];return E(d,i[c.dtype],y,g,b),m&&n.disposeData(l.dataId),h},setupFunc:function(e){E=e.wasm.cwrap(t.ArgMax,null,["number","number","number","number","number"])}};let N;const F={kernelName:t.AvgPool,backendName:"wasm",setupFunc:function(e){N=e.wasm.cwrap(t.AvgPool,null,["number","number","number","number","number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){const{inputs:n,attrs:a,backend:r}=e,s=n.x,u=r.dataIdMap.get(s.dataId).id,{filterSize:i,strides:o,pad:d,dimRoundingMode:c}=a,l=t.backend_util.computePool2DInfo(s.shape,i,o,1,d,c),p=l.filterHeight,m=l.filterWidth,f=l.padInfo.top,h=l.padInfo.right,b=l.padInfo.bottom,y=l.padInfo.left,g=l.strideHeight,_=l.strideWidth,k=l.inChannels;if("channelsLast"!==l.dataFormat)throw new Error(`wasm backend does not support dataFormat:'${l.dataFormat}'. Please use 'channelsLast'.`);if(1!==l.dilationWidth||1!==l.dilationHeight)throw new Error(`was backend only supports average pooling with dilation = [1, 1], got [${l.dilationHeight}, ${l.dilationWidth}].`);const w=r.makeOutput(l.outShape,"float32"),I=r.dataIdMap.get(w.dataId).id;return N(u,s.shape[0],s.shape[1],s.shape[2],p,m,f,h,b,y,g,_,k,I),w}};function O(e){const{inputs:n,attrs:a}=e,{x:r}=n,{shape:s}=a,u=t.util.sizeFromShape(r.shape),i=t.util.inferFromImplicitShape(s,u);return t.util.assert(u===t.util.sizeFromShape(i),(()=>`new shape: ${i}, old shape: ${r.shape}. New shape and old shape must have the same number of elements.`)),e.backend.incRef(r.dataId),{dataId:r.dataId,shape:i,dtype:r.dtype}}const T={kernelName:t.Reshape,backendName:"wasm",kernelFunc:O};let R;const C={kernelName:t.BatchMatMul,backendName:"wasm",setupFunc:function(e){R=e.wasm.cwrap(t.BatchMatMul,null,["number","array","number","number","array","number","number","number","number"])},kernelFunc:function(e){const{inputs:n,backend:a,attrs:r}=e,{a:s,b:u}=n,{transposeA:i,transposeB:o}=r;if("float32"!==s.dtype||"float32"!==u.dtype)throw new Error("BatchMatMul for non non-float32 tensors not yet supported.");const d=s.shape.length,c=u.shape.length,l=i?s.shape[d-2]:s.shape[d-1],p=o?u.shape[c-1]:u.shape[c-2],m=i?s.shape[d-1]:s.shape[d-2],f=o?u.shape[c-2]:u.shape[c-1],h=s.shape.slice(0,-2),b=u.shape.slice(0,-2),y=t.util.sizeFromShape(h),g=t.util.sizeFromShape(b),_=t.broadcast_util.assertAndGetBroadcastShape(s.shape.slice(0,-2),u.shape.slice(0,-2)).concat([m,f]);t.util.assert(l===p,(()=>`Error in matMul: inner shapes (${l}) and (${p}) of Tensors with shapes ${s.shape} and ${u.shape} and transposeA=${i} and transposeB=${o} must match.`));const k=o?[g,f,p]:[g,p,f],w=O({inputs:{x:s},backend:a,attrs:{shape:i?[y,l,m]:[y,m,l]}}),I=O({inputs:{x:u},backend:a,attrs:{shape:k}}),S=a.dataIdMap.get(w.dataId).id,v=a.dataIdMap.get(I.dataId).id,M=i?w.shape[2]:w.shape[1],A=o?I.shape[1]:I.shape[2],E=Math.max(y,g),x=a.makeOutput([E,M,A],w.dtype),N=a.dataIdMap.get(x.dataId).id,F=new Uint8Array(new Int32Array(w.shape).buffer),T=new Uint8Array(new Int32Array(I.shape).buffer);return R(S,F,w.shape.length,v,T,I.shape.length,i,o,N),a.disposeData(w.dataId),a.disposeData(I.dataId),x.shape=_,x}};function D(e,n,a,r,s){const u=t.slice_util.isSliceContinous(r,n,a),i=t.util.sizeFromShape(a),o=t.util.computeStrides(r);if(u){const a=t.slice_util.computeFlatOffset(n,o);return"string"===s?e.slice(a,a+i):e.subarray(a,a+i)}const d="string"===s?t.backend_util.fromUint8ToStringArray(e):e,c=t.buffer(r,s,d),l=t.buffer(a,s);for(let e=0;e<l.size;++e){const t=l.indexToLoc(e),a=t.map(((e,t)=>e+n[t]));l.set(c.get(...a),...t)}return"string"===s?t.backend_util.fromStringArrayToUint8(l.values):l.values}function P(e){const{inputs:{x:n},attrs:{begin:a,size:r},backend:s}=e,[u,i]=t.slice_util.parseSliceParams(n,a,r),o=t.slice_util.isSliceContinous(n.shape,u,i),d=s.readSync(n.dataId),c=s.makeOutput(i,n.dtype),l=t.util.computeStrides(n.shape),p=s.dataIdMap.get(c.dataId);if(o){const e=t.slice_util.computeFlatOffset(u,l);if("string"===n.dtype)p.stringBytes=d.slice(e,e+t.util.sizeFromShape(i));else{s.typedArrayFromHeap(c).set(d.subarray(e,e+t.util.sizeFromShape(i)))}return c}if("string"===n.dtype){const e=D(d,u,i,n.shape,n.dtype);return p.stringBytes=e,c}const m=s.typedArrayFromHeap(c),f=n.shape.length;if(2===f)!function(e,t,n,a,r){let s=0;const u=a[0],i=a[1],o=u+r[0];for(let a=u;a<o;a++){const u=a*t+i;n.set(e.subarray(u,u+r[1]),s),s+=r[1]}}(d,l[0],m,u,i);else if(3===f)!function(e,t,n,a,r,s){let u=0;const i=r[0],o=r[1],d=r[2],c=i+s[0],l=o+s[1];for(let r=i;r<c;r++)for(let i=o;i<l;i++){const o=r*t+i*n+d;a.set(e.subarray(o,o+s[2]),u),u+=s[2]}}(d,l[0],l[1],m,u,i);else if(4===f)!function(e,t,n,a,r,s,u){let i=0;const o=s[0],d=s[1],c=s[2],l=o+u[0],p=d+u[1],m=c+u[2],f=s[3];for(let s=o;s<l;s++)for(let o=d;o<p;o++)for(let d=c;d<m;d++){const c=s*t+o*n+d*a+f;r.set(e.subarray(c,c+u[3]),i),i+=u[3]}}(d,l[0],l[1],l[2],m,u,i);else{const e=D(d,u,i,n.shape,n.dtype);m.set(e)}return c}const W={kernelName:t.Slice,backendName:"wasm",kernelFunc:P};const L={kernelName:t.BatchToSpaceND,backendName:"wasm",kernelFunc:function(e){const{inputs:n,backend:a,attrs:r}=e,{x:s}=n,{blockShape:u,crops:i}=r,o=u.reduce(((e,t)=>e*t)),d=t.backend_util.getReshaped(s.shape,u,o),c=t.backend_util.getPermuted(d.length,u.length),l=t.backend_util.getReshapedPermuted(s.shape,u,o),p=t.backend_util.getSliceBeginCoords(i,u.length),m=t.backend_util.getSliceSize(l,i,u.length),f=O({inputs:{x:s},backend:a,attrs:{shape:d}}),h=k({inputs:{x:f},backend:a,attrs:{perm:c}}),b=P({inputs:{x:O({inputs:{x:h},backend:a,attrs:{shape:l}})},backend:a,attrs:{begin:p,size:m}});return a.disposeData(f.dataId),a.disposeData(h.dataId),a.disposeData(f.dataId),b}};function H(e){const{inputs:{x:t},attrs:{dtype:n},backend:a}=e,r=a.makeOutput(t.shape,n),s=a.typedArrayFromHeap(t);return a.typedArrayFromHeap(r).set(s),r}const B={kernelName:t.Cast,backendName:"wasm",kernelFunc:H},U=l(t.Ceil);let z;const j={kernelName:t.ClipByValue,backendName:"wasm",setupFunc:function(e){z=e.wasm.cwrap(t.ClipByValue,null,["number","number","number","number"])},kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:r}=t,{clipValueMin:s,clipValueMax:u}=a,i=n.dataIdMap.get(r.dataId).id,o=n.makeOutput(r.shape,r.dtype),d=n.dataIdMap.get(o.dataId).id;return z(i,s,u,d),o}};function q(e){const{inputs:n,backend:a}=e,r=t.util.parseAxisParam(e.attrs.axis,n[0].shape)[0];let s=t.backend_util.computeOutShape(n.map((e=>e.shape)),r);const u=n.filter((e=>t.util.sizeFromShape(e.shape)>0));if(1===u.length)return y({inputs:{x:u[0]},backend:a});const i=a.makeOutput(s,n[0].dtype);if(0===t.util.sizeFromShape(s))return i;const o=u.map((e=>e.shape));if(t.backend_util.assertParamsConsistent(o,r),"string"===u[0].dtype){const e=u.map((e=>{const n=t.util.sizeFromShape(e.shape.slice(r));return O({inputs:{x:e},backend:a,attrs:{shape:[-1,n]}})})),o=e.map((e=>({vals:a.readSync(e.dataId),shape:e.shape})));s=t.backend_util.computeOutShape(e.map((e=>e.shape)),1);const d=1===e[0].shape[0],c=function(e,n,a,r){const s=t.util.getArrayFromDType(a,t.util.sizeFromShape(n));if(r&&"string"!==a){let n=0;e.forEach((e=>{const a=t.util.sizeFromShape(e.shape);s.set(e.vals,n),n+=a}))}else{let r=0;e.forEach((e=>{const u="string"===a?t.backend_util.fromUint8ToStringArray(e.vals):e.vals;let i=0;for(let t=0;t<e.shape[0];++t){const a=t*n[1]+r;for(let t=0;t<e.shape[1];++t)s[a+t]=u[i++]}r+=e.shape[1]}))}return s}(o,s,n[0].dtype,d),l=t.backend_util.computeOutShape(u.map((e=>e.shape)),r);i.shape=l;return a.dataIdMap.get(i.dataId).stringBytes=t.backend_util.fromStringArrayToUint8(c),e.forEach((e=>a.disposeData(e.dataId))),i}const d=t.util.sizeFromShape(u[0].shape.slice(0,r));let c=0;const l=u.map((e=>{const n=t.util.sizeFromShape(e.shape.slice(r));return c+=n,n})),p=u.map((e=>a.typedArrayFromHeap(e))),m=a.typedArrayFromHeap(i);for(let e=0;e<d;e++){let t=e*c;for(let n=0;n<p.length;n++){const a=l[n],r=e*a,s=p[n].subarray(r,r+a);m.set(s,t),t+=a}}return i}const V={kernelName:t.Concat,backendName:"wasm",kernelFunc:q};let G;const $={kernelName:t.Conv2D,backendName:"wasm",setupFunc:function(e){G=e.wasm.cwrap(t.Conv2D,null,["number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){const{inputs:n,attrs:a,backend:r}=e,{x:s,filter:u}=n,i=r.dataIdMap.get(s.dataId).id,o=r.dataIdMap.get(u.dataId).id,{strides:d,dilations:c,pad:l,dimRoundingMode:p,dataFormat:m}=a,f=t.backend_util.convertConv2DDataFormat(m),h=t.backend_util.computeConv2DInfo(s.shape,u.shape,d,c,l,p,!1,f),b=h.filterHeight,y=h.filterWidth,g=h.padInfo.top,_=h.padInfo.right,k=h.padInfo.bottom,w=h.padInfo.left,I=h.dilationHeight,S=h.dilationWidth,v=h.strideHeight,M=h.strideWidth,A=h.inChannels,E=h.outChannels,x="SAME"===h.padInfo.type?1:0;if("channelsLast"!==h.dataFormat)throw new Error(`wasm backend Conv2D does not support dataFormat:'${h.dataFormat}'. Please use 'channelsLast'.`);const N=r.makeOutput(h.outShape,"float32"),F=r.dataIdMap.get(N.dataId).id;return G(i,s.shape[0],s.shape[1],s.shape[2],o,b,y,g,_,k,w,x,I,S,v,M,A,E,F),N}};let K;const X={kernelName:t.Conv2DBackpropInput,backendName:"wasm",setupFunc:function(e){K=e.wasm.cwrap(t.Conv2DBackpropInput,null,["number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){const{backend:n,inputs:a,attrs:r}=e,{dy:s,filter:u}=a,{strides:i,pad:o,dataFormat:d,dimRoundingMode:c,inputShape:l}=r,p=t.backend_util.convertConv2DDataFormat(d),m=t.backend_util.computeConv2DInfo(l,u.shape,i,1,o,c,!1,p),{batchSize:f,filterHeight:h,filterWidth:b,inChannels:y,inHeight:g,inWidth:_,outChannels:k,outHeight:w,outWidth:I,strideHeight:S,strideWidth:v}=m,M=h-1-m.padInfo.top,A=b-1-m.padInfo.left,E="channelsLast"===m.dataFormat,x=t.util.computeStrides(m.inShape),N=t.util.computeStrides(s.shape),[F,O,T]=t.util.computeStrides(u.shape),R=x[0],C=E?x[1]:x[2],D=E?x[2]:1,P=E?1:x[1],W=N[0],L=E?N[1]:N[2],H=E?N[2]:1,B=E?1:N[1],U=n.makeOutput(m.inShape,"float32"),z=n.dataIdMap.get(U.dataId).id,j=n.dataIdMap.get(s.dataId).id,q=n.dataIdMap.get(u.dataId).id;return K(j,q,f,h,b,g,_,y,w,I,k,S,v,M,A,F,O,T,R,C,D,P,W,L,H,B,z),U}},Q=l(t.Cos),Y=l(t.Cosh);var Z;let J;!function(e){e[e.bilinear=0]="bilinear",e[e.nearest=1]="nearest"}(Z||(Z={}));const ee={kernelName:t.CropAndResize,backendName:"wasm",setupFunc:function(e){J=e.wasm.cwrap(t.CropAndResize,null,["number","number","number","number","array","number","number","number","number","number"])},kernelFunc:function(e){const{backend:t,inputs:n,attrs:a}=e,{method:r,extrapolationValue:s,cropSize:u}=a,{image:i,boxes:o,boxInd:d}=n,c=o.shape[0],[l,p]=u,m=[c,l,p,i.shape[3]];let f,h=t.dataIdMap.get(i.dataId);"float32"!==i.dtype&&(f=H({backend:t,inputs:{x:i},attrs:{dtype:"float32"}}),h=t.dataIdMap.get(f.dataId));const b=h.id,y=t.dataIdMap.get(o.dataId).id,g=t.dataIdMap.get(d.dataId).id,_=t.makeOutput(m,"float32"),k=t.dataIdMap.get(_.dataId).id,w=new Uint8Array(new Int32Array(i.shape).buffer);return J(b,y,g,c,w,l,p,Z[r],s,k),null!=f&&t.disposeData(f.dataId),_}};let te;const ne={kernelName:t.Cumsum,backendName:"wasm",setupFunc:function(e){te=e.wasm.cwrap(t.Cumsum,null,["number","number","number","number","number","number"])},kernelFunc:function(e){const{inputs:n,backend:a,attrs:r}=e,{x:s}=n,{axis:u,exclusive:o,reverse:d}=r,c=s.shape.length;t.util.assert("float32"===s.dtype||"int32"===s.dtype,(()=>`cumsum does not support ${s.dtype} tensors in the WASM backend`));const l=t.backend_util.getAxesPermutation([u],c);let p=s;null!==l&&(p=k({inputs:{x:s},attrs:{perm:l},backend:a}));const m=t.backend_util.getInnerMostAxes(1,c)[0];t.backend_util.assertAxesAreInnerMostDims("cumsum",[m],c);const f=a.makeOutput(p.shape,p.dtype),h=p.shape[m],b=a.dataIdMap.get(p.dataId).id,y=a.dataIdMap.get(f.dataId).id;te(b,o?1:0,d?1:0,h,y,i[s.dtype]);let g=f;if(null!==l){g=k({inputs:{x:f},attrs:{perm:t.backend_util.getUndoAxesPermutation(l)},backend:a}),a.disposeData(p.dataId),a.disposeData(f.dataId)}return g}};let ae;const re={kernelName:t.DepthToSpace,backendName:"wasm",setupFunc:function(e){ae=e.wasm.cwrap(t.DepthToSpace,null,["number","number","number","array","number","array","array","number","number"])},kernelFunc:function(e){const{backend:n,inputs:a,attrs:r}=e,{x:s}=a,{blockSize:u,dataFormat:i}=r,o=s.shape[0],d=("NHWC"===i?s.shape[1]:s.shape[2])*u,c=("NHWC"===i?s.shape[2]:s.shape[3])*u,l=("NHWC"===i?s.shape[3]:s.shape[1])/(u*u),p="NHWC"===i?[o,d,c,l]:[o,l,d,c],m=n.makeOutput(p,"float32"),f=n.dataIdMap.get(s.dataId).id,h=new Uint8Array(new Int32Array(t.util.computeStrides(s.shape)).buffer),b=new Uint8Array(new Int32Array(p).buffer),y=new Uint8Array(new Int32Array(t.util.computeStrides(p)).buffer),g=n.dataIdMap.get(m.dataId).id;return ae(f,u,"NHWC"===i?1:0,h,s.shape.length-1,b,y,p.length,g),m}};let se;const ue={kernelName:t.DepthwiseConv2dNative,backendName:"wasm",setupFunc:function(e){se=e.wasm.cwrap(t.DepthwiseConv2dNative,null,["number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){const{inputs:n,attrs:a,backend:r}=e,{x:s,filter:u}=n,i=r.dataIdMap.get(s.dataId).id,o=r.dataIdMap.get(u.dataId).id,{strides:d,dilations:c,pad:l,dimRoundingMode:p}=a,m=null==c?[1,1]:c,f=t.backend_util.computeConv2DInfo(s.shape,u.shape,d,m,l,p,!0),h=f.filterHeight,b=f.filterWidth,y=f.padInfo.top,g=f.padInfo.right,_=f.padInfo.bottom,k=f.padInfo.left,w=f.dilationHeight,I=f.dilationWidth,S=f.strideHeight,v=f.strideWidth,M=f.inChannels,A=f.outChannels,E="SAME"===f.padInfo.type?1:0;if("channelsLast"!==f.dataFormat)throw new Error(`wasm backend DepthwiseConv2dNative does not support dataFormat:'${f.dataFormat}'. Please use 'channelsLast'.`);const x=r.makeOutput(f.outShape,"float32"),N=r.dataIdMap.get(x.dataId).id;return se(i,s.shape[0],s.shape[1],s.shape[2],o,h,b,y,g,_,k,E,w,I,S,v,M,A,N),x}},ie=l(t.Elu),oe=m(t.Equal,0,"bool"),de=l(t.Exp,"float32");function ce(e){const{inputs:n,attrs:a,backend:r}=e,{input:s}=n,{dim:u}=a,i=s.shape.length,o=s.shape.slice();let d=u;return u<0&&(t.util.assert(-(i+1)<=u,(()=>`Axis must be in the interval [${-(i+1)}, ${i}]`)),d=i+u+1),o.splice(d,0,1),O({inputs:{x:s},backend:r,attrs:{shape:o}})}const le={kernelName:t.ExpandDims,backendName:"wasm",kernelFunc:ce};function pe(e){const{attrs:{shape:t,value:n,dtype:a},backend:r}=e,s=r.makeOutput(t,a);return r.typedArrayFromHeap(s).fill(n),s}const me={kernelName:t.Fill,backendName:"wasm",kernelFunc:pe};let fe;const he={kernelName:t.FlipLeftRight,backendName:"wasm",kernelFunc:function(e){const{inputs:t,backend:n}=e,{image:a}=t,r=n.makeOutput(a.shape,a.dtype),s=n.dataIdMap.get(a.dataId).id,u=n.dataIdMap.get(r.dataId).id,[i,o,d,c]=a.shape;return fe(s,i,o,d,c,u),r},setupFunc:function(e){fe=e.wasm.cwrap(t.FlipLeftRight,null,["number","number","number","number","number","number"])}},be=l(t.Floor),ye=m(t.FloorDiv);let ge;const _e={kernelName:t.FusedBatchNorm,backendName:"wasm",setupFunc:function(e){ge=e.wasm.cwrap(t.FusedBatchNorm,null,["number","number","number","number","number","number","number"])},kernelFunc:function(e){const{backend:n,inputs:a,attrs:r}=e,{varianceEpsilon:s}=r,{x:u,mean:i,variance:o,offset:d,scale:c}=a,l=n.dataIdMap.get(u.dataId).id,p=n.dataIdMap.get(i.dataId).id,m=n.dataIdMap.get(o.dataId).id,f=null!=d?n.dataIdMap.get(d.dataId).id:0,h=null!=c?n.dataIdMap.get(c.dataId).id:0,b=n.makeOutput(u.shape,u.dtype);if(0===t.util.sizeFromShape(u.shape))return b;const y=n.dataIdMap.get(b.dataId).id;return ge(l,p,m,f,h,s,y),b}};let ke;const we={kernelName:t.FusedConv2D,backendName:"wasm",setupFunc:function(e){ke=e.wasm.cwrap(t.FusedConv2D,null,["number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){const{inputs:n,attrs:a,backend:r}=e,{x:s,filter:u,bias:i,preluActivationWeights:d}=n,{strides:c,pad:l,dilations:p,dataFormat:m,dimRoundingMode:f,activation:h,leakyreluAlpha:b}=a,y=t.backend_util.computeConv2DInfo(s.shape,u.shape,c,p,l,f),g=o[h];if(null==g)throw new Error(`${h} activation not yet supported for FusedConv2D in the wasm backend.`);const _=r.dataIdMap.get(s.dataId).id,k=r.dataIdMap.get(u.dataId).id,w=y.outChannels;let I=0;if(null!=i){const e=r.dataIdMap.get(i.dataId);if(1!==e.shape.length)throw new Error(`FusedConv2D only supports rank-1 bias but got rank ${e.shape.length}.`);if(e.shape[0]!==w)throw new Error(`FusedConv2D bias shape (${e.shape}) does not match the number of output channels (${w})`);I=e.id}const S=y.filterHeight,v=y.filterWidth,M=y.padInfo.top,A=y.padInfo.right,E=y.padInfo.bottom,x=y.padInfo.left,N=y.dilationHeight,F=y.dilationWidth,O=y.strideHeight,T=y.strideWidth,R=y.inChannels,C="SAME"===y.padInfo.type?1:0,D=y.batchSize,P=y.inHeight,W=y.inWidth;if("NHWC"!==m)throw new Error(`wasm backend FusedConv2D does not support dataFormat:'${m}'. Please use 'NHWC'.`);const L=r.makeOutput(y.outShape,"float32"),H=r.dataIdMap.get(L.dataId).id,B=null==d?0:r.dataIdMap.get(d.dataId).id;return ke(_,D,P,W,k,S,v,I,M,A,E,x,C,N,F,O,T,R,w,g,B,b||0,H),L}};let Ie;const Se={kernelName:t.FusedDepthwiseConv2D,backendName:"wasm",setupFunc:function(e){Ie=e.wasm.cwrap(t.FusedDepthwiseConv2D,null,["number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){const{inputs:n,attrs:a,backend:r}=e,{x:s,filter:u,bias:i,preluActivationWeights:d}=n,{strides:c,pad:l,dilations:p,dataFormat:m,dimRoundingMode:f,activation:h,leakyreluAlpha:b}=a,y=t.backend_util.computeConv2DInfo(s.shape,u.shape,c,p,l,f,!0),g=o[h];if(null==g)throw new Error(`${h} activation not yet supported for FusedDepthwiseConv2D in the wasm backend.`);const _=r.dataIdMap.get(s.dataId).id,k=r.dataIdMap.get(u.dataId).id,w=y.outChannels;let I=0;if(null!=i){const e=r.dataIdMap.get(i.dataId);if(1!==e.shape.length)throw new Error(`FusedDepthwiseConv2D only supports rank-1 bias but got rank ${e.shape.length}.`);if(e.shape[0]!==w)throw new Error(`FusedDepthwiseConv2D bias shape (${e.shape}) does not match the number of output channels (${w})`);I=e.id}const S=y.filterHeight,v=y.filterWidth,M=y.padInfo.top,A=y.padInfo.right,E=y.padInfo.bottom,x=y.padInfo.left,N=y.dilationHeight,F=y.dilationWidth,O=y.strideHeight,T=y.strideWidth,R=y.inChannels,C="SAME"===y.padInfo.type?1:0,D=y.batchSize,P=y.inHeight,W=y.inWidth;if("NHWC"!==m)throw new Error(`wasm backend FusedDepthwiseConv2D does not support dataFormat:'${m}'. Please use 'NHWC'.`);const L=r.makeOutput(y.outShape,"float32"),H=r.dataIdMap.get(L.dataId).id,B=null==d?0:r.dataIdMap.get(d.dataId).id;return Ie(_,D,P,W,k,S,v,I,M,A,E,x,C,N,F,O,T,R,w,g,B,b||0,H),L}};let ve;const Me={kernelName:t.GatherNd,backendName:"wasm",setupFunc:function(e){ve=e.wasm.cwrap(t.GatherNd,null,["number","number","number","number","number","number","array","number"])},kernelFunc:function(e){const{backend:n,inputs:a}=e,{params:r,indices:s}=a,[u,o,d,c]=t.gather_util.prepareAndValidate(r,s),l=n.makeOutput(u,r.dtype);if(0===o)return l;const p=s.shape,m=p[p.length-1],f=n.dataIdMap.get(r.dataId).id,h=n.dataIdMap.get(s.dataId).id,b=new Uint8Array(new Int32Array(c).buffer),y=n.dataIdMap.get(l.dataId).id;return ve(f,i[r.dtype],h,o,m,d,b,y),l}};let Ae;const Ee={kernelName:t.GatherV2,backendName:"wasm",setupFunc:function(e){Ae=e.wasm.cwrap("Gather",null,["number","number","array","number","number","number","array","number"])},kernelFunc:function(e){const{backend:n,inputs:a,attrs:r}=e,{x:s,indices:u}=a,{axis:o,batchDims:d}=r,c=t.util.parseAxisParam(o,s.shape)[0],l=n.readSync(u.dataId),p=s.shape[c];for(let e=0;e<l.length;++e){const n=l[e];t.util.assert(n<=p-1&&n>=0,(()=>`GatherV2: the index value ${n} is not in [0, ${p-1}]`))}const m=t.backend_util.segment_util.collectGatherOpShapeInfo(s,u,c,d),f=O({inputs:{x:s},attrs:{shape:[m.batchSize,m.outerSize,m.dimSize,m.sliceSize]},backend:n}),h=t.util.sizeFromShape(u.shape),b=O({inputs:{x:u},attrs:{shape:[m.batchSize,h/m.batchSize]},backend:n}),y=[m.batchSize,m.outerSize,h/m.batchSize,m.sliceSize],g=n.makeOutput(y,s.dtype);if(0===t.util.sizeFromShape(s.shape))return g;const _=f.shape.length-1,k=n.dataIdMap.get(f.dataId).id,w=n.dataIdMap.get(b.dataId).id,I=n.dataIdMap.get(g.dataId).id,S=new Uint8Array(new Int32Array(t.util.computeStrides(f.shape)).buffer),v=new Uint8Array(new Int32Array(t.util.computeStrides(y)).buffer);return Ae(k,i[s.dtype],S,_,w,m.batchSize,v,I),n.disposeData(f.dataId),n.disposeData(b.dataId),g.shape=m.outputShape,g}},xe=m(t.Greater,0,"bool"),Ne=m(t.GreaterEqual,0,"bool");let Fe;const Oe={kernelName:t.LeakyRelu,backendName:"wasm",setupFunc:function(e){Fe=e.wasm.cwrap(t.LeakyRelu,null,["number","number","number","number"])},kernelFunc:function(e){const{inputs:{x:n},attrs:{alpha:a},backend:r}=e,s=r.dataIdMap.get(n.dataId).id,u=r.makeOutput(n.shape,"float32");if(0!==t.util.sizeFromShape(n.shape)){const e=r.dataIdMap.get(u.dataId).id;Fe(s,i[n.dtype],a,e)}return u}},Te=m(t.Less,0,"bool"),Re=m(t.LessEqual,0,"bool"),Ce=l(t.Log),De=m(t.LogicalAnd,0,"bool");let Pe;const We={kernelName:t.Max,backendName:"wasm",setupFunc:function(e){Pe=e.wasm.cwrap(t.Max,null,["number","number","number","number"])},kernelFunc:function(e){const{backend:n,inputs:a,attrs:r}=e,{reductionIndices:s,keepDims:u}=r,{x:o}=a;let d=n.dataIdMap.get(o.dataId).id,c=o;const{transposed:l,axes:p,originalAxes:m,inputWasTransposed:f}=I(o,s,n);if(f){c=l,d=n.dataIdMap.get(l.dataId).id}const h=c.shape.length;t.backend_util.assertAxesAreInnerMostDims("max",p,h);const[b,y]=t.backend_util.computeOutAndReduceShapes(c.shape,p),g=t.util.sizeFromShape(y),_=n.makeOutput(b,o.dtype);if(0!==t.util.sizeFromShape(c.shape)){const e=n.dataIdMap.get(_.dataId).id;Pe(d,i[o.dtype],g,e)}if(f&&n.disposeData(l.dataId),u){const e=t.backend_util.expandShapeToKeepDim(_.shape,m);_.shape=e}return _}},Le=m(t.Maximum);let He;const Be={kernelName:t.MaxPool,backendName:"wasm",setupFunc:function(e){He=e.wasm.cwrap(t.MaxPool,null,["number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){const{inputs:n,attrs:a,backend:r}=e,s=n.x,u=r.dataIdMap.get(s.dataId).id;t.util.assert("float32"===s.dtype,(()=>`Error in MaxPool: only float32 input is supported. Got ${s.dtype}.`));const{filterSize:i,strides:o,pad:d,dimRoundingMode:c}=a,l=t.backend_util.computePool2DInfo(s.shape,i,o,1,d,c),p=l.filterHeight,m=l.filterWidth,f=l.padInfo.top,h=l.padInfo.right,b=l.padInfo.bottom,y=l.padInfo.left,g=l.dilationHeight,_=l.dilationWidth,k=l.strideHeight,w=l.strideWidth,I=l.inChannels,S=l.outChannels;if("channelsLast"!==l.dataFormat)throw new Error(`wasm backend does not support dataFormat:'${l.dataFormat}'. Please use 'channelsLast'.`);const v=r.makeOutput(l.outShape,"float32"),M=r.dataIdMap.get(v.dataId).id;return He(u,s.shape[0],s.shape[1],s.shape[2],p,m,f,h,b,y,g,_,k,w,I,S,M),v}};let Ue;const ze={kernelName:t.Mean,backendName:"wasm",setupFunc:function(e){Ue=e.wasm.cwrap(t.Mean,null,["number, number, number"])},kernelFunc:function(e){const{backend:n,inputs:a,attrs:r}=e,{axis:s,keepDims:u}=r,{x:i}=a,o=n.dataIdMap.get(i.dataId).id;let d=o,c=i;const{transposed:l,axes:p,originalAxes:m,inputWasTransposed:f}=I(i,s,n);let h=p;if(f){const e=n.dataIdMap.get(l.dataId).id;e!==o&&(c=l,d=e,h=t.backend_util.getInnerMostAxes(h.length,c.shape.length))}t.backend_util.assertAxesAreInnerMostDims("mean",h,c.shape.length);const[b,y]=t.backend_util.computeOutAndReduceShapes(c.shape,h),g=t.util.sizeFromShape(y);let _=c;"float32"!==c.dtype&&(_=H({backend:n,inputs:{x:c},attrs:{dtype:"float32"}}),d=n.dataIdMap.get(_.dataId).id);const k=n.makeOutput(b,"float32");if(0!==t.util.sizeFromShape(c.shape)){const e=n.dataIdMap.get(k.dataId).id;Ue(d,g,e)}if(f&&n.disposeData(l.dataId),u){const e=t.backend_util.expandShapeToKeepDim(k.shape,m);k.shape=e}return"float32"!==c.dtype&&n.disposeData(_.dataId),k}};let je;const qe={kernelName:t.Min,backendName:"wasm",setupFunc:function(e){je=e.wasm.cwrap(t.Min,null,["number","number","number","number"])},kernelFunc:function(e){const{backend:n,inputs:a,attrs:r}=e,{axis:s,keepDims:u}=r,{x:o}=a,d=n.dataIdMap.get(o.dataId).id;let c=d,l=o;const{transposed:p,axes:m,originalAxes:f,inputWasTransposed:h}=I(o,s,n);if(h){const e=n.dataIdMap.get(p.dataId).id;e!==d&&(l=p,c=e)}const b=l.shape.length;t.backend_util.assertAxesAreInnerMostDims("min",m,b);const[y,g]=t.backend_util.computeOutAndReduceShapes(l.shape,m),_=t.util.sizeFromShape(g),k=n.makeOutput(y,l.dtype);if(0!==t.util.sizeFromShape(l.shape)){const e=n.dataIdMap.get(k.dataId).id;je(c,i[o.dtype],_,e)}if(h&&n.disposeData(p.dataId),u){const e=t.backend_util.expandShapeToKeepDim(k.shape,f);k.shape=e}return k}},Ve=m(t.Minimum);var Ge;let $e;!function(e){e[e.reflect=0]="reflect",e[e.symmetric=1]="symmetric"}(Ge||(Ge={}));const Ke={kernelName:t.MirrorPad,backendName:"wasm",kernelFunc:function(e){const{inputs:{x:t},backend:n,attrs:{paddings:a,mode:r}}=e,s=a.map(((e,n)=>e[0]+t.shape[n]+e[1])),u=n.dataIdMap.get(t.dataId).id,o=n.makeOutput(s,t.dtype),d=n.dataIdMap.get(o.dataId).id,c=new Uint8Array(new Int32Array(t.shape).buffer),l=a.map((e=>e[0])),p=a.map((e=>e[1])),m=new Uint8Array(new Int32Array(l).buffer),f=new Uint8Array(new Int32Array(p).buffer);return $e(u,c,t.shape.length,i[t.dtype],m,f,Ge[r],d),o},setupFunc:function(e){$e=e.wasm.cwrap(t.MirrorPad,null,["number","array","number","number","array","array","number","number"])}},Xe=m(t.Multiply),Qe=l(t.Neg);function Ye(e,t){const n=new Int32Array(e.wasm.HEAPU8.buffer,t,4),a=n[0],r=n[1],s=n[2],u=n[3];return e.wasm._free(t),{pSelectedIndices:a,selectedSize:r,pSelectedScores:s,pValidOutputs:u}}let Ze;const Je={kernelName:t.NonMaxSuppressionV3,backendName:"wasm",setupFunc:function(e){Ze=e.wasm.cwrap(t.NonMaxSuppressionV3,"number",["number","number","number","number","number"])},kernelFunc:function(e){const{backend:t,inputs:n,attrs:a}=e,{iouThreshold:r,maxOutputSize:s,scoreThreshold:u}=a,{boxes:i,scores:o}=n,d=t.dataIdMap.get(i.dataId).id,c=t.dataIdMap.get(o.dataId).id,l=Ze(d,c,s,r,u),{pSelectedIndices:p,selectedSize:m,pSelectedScores:f,pValidOutputs:h}=Ye(t,l);return t.wasm._free(f),t.wasm._free(h),t.makeOutput([m],"int32",p)}};let et;const tt={kernelName:t.NonMaxSuppressionV4,backendName:"wasm",setupFunc:function(e){et=e.wasm.cwrap(t.NonMaxSuppressionV4,"number",["number","number","number","number","number","bool"])},kernelFunc:function(e){const{backend:t,inputs:n,attrs:a}=e,{iouThreshold:r,maxOutputSize:s,scoreThreshold:u,padToMaxOutputSize:i}=a,{boxes:o,scores:d}=n,c=t.dataIdMap.get(o.dataId).id,l=t.dataIdMap.get(d.dataId).id,p=et(c,l,s,r,u,i),{pSelectedIndices:m,selectedSize:f,pSelectedScores:h,pValidOutputs:b}=Ye(t,p);return t.wasm._free(h),[t.makeOutput([f],"int32",m),t.makeOutput([],"int32",b)]}};let nt;const at={kernelName:t.NonMaxSuppressionV5,backendName:"wasm",setupFunc:function(e){nt=e.wasm.cwrap(t.NonMaxSuppressionV5,"number",["number","number","number","number","number","number"])},kernelFunc:function(e){const{backend:t,inputs:n,attrs:a}=e,{iouThreshold:r,maxOutputSize:s,scoreThreshold:u,softNmsSigma:i}=a,{boxes:o,scores:d}=n,c=t.dataIdMap.get(o.dataId).id,l=t.dataIdMap.get(d.dataId).id,p=nt(c,l,s,r,u,i),{pSelectedIndices:m,selectedSize:f,pSelectedScores:h,pValidOutputs:b}=Ye(t,p);return t.wasm._free(b),[t.makeOutput([f],"int32",m),t.makeOutput([f],"float32",h)]}},rt=m(t.NotEqual,0,"bool");let st;const ut={kernelName:t.OneHot,backendName:"wasm",setupFunc:function(e){st=e.wasm.cwrap(t.OneHot,null,["number","number","number","number","number"])},kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{indices:r}=t,{depth:s,onValue:u,offValue:i}=a,o=n.makeOutput([...r.shape,s],"int32"),d=n.dataIdMap.get(o.dataId).id,c=n.dataIdMap.get(r.dataId).id;return st(c,s,u,i,d),o}};const it={kernelName:t.OnesLike,backendName:"wasm",kernelFunc:function(e){const{inputs:{x:t},backend:n}=e,a=n.makeOutput(t.shape,t.dtype);return n.typedArrayFromHeap(a).fill(1),a}};const ot={kernelName:t.Pack,backendName:"wasm",kernelFunc:function(e){const{inputs:n,backend:a,attrs:r}=e,{axis:s}=r;if(1===n.length)return ce({inputs:{input:n[0]},backend:a,attrs:{dim:s}});const u=n[0].shape,i=n[0].dtype;n.forEach((e=>{t.util.assertShapesMatch(u,e.shape,"All tensors passed to stack must have matching shapes"),t.util.assert(i===e.dtype,(()=>"All tensors passed to stack must have matching dtypes"))}));const o=[],d=q({inputs:n.map((e=>{const t=ce({inputs:{input:e},backend:a,attrs:{dim:s}});return o.push(t),t})),backend:a,attrs:{axis:s}});return o.forEach((e=>a.disposeData(e.dataId))),d}};let dt;const ct={kernelName:t.PadV2,backendName:"wasm",kernelFunc:function(e){const{inputs:{x:n},backend:a,attrs:{paddings:r,constantValue:s}}=e,u=r.map(((e,t)=>e[0]+n.shape[t]+e[1]));if(0===t.util.sizeFromShape(n.shape))return pe({backend:a,attrs:{shape:u,value:s,dtype:n.dtype}});const o=a.dataIdMap.get(n.dataId).id,d=a.makeOutput(u,n.dtype),c=a.dataIdMap.get(d.dataId).id,l=new Uint8Array(new Int32Array(n.shape).buffer),p=r.map((e=>e[0])),m=r.map((e=>e[1])),f=new Uint8Array(new Int32Array(p).buffer),h=new Uint8Array(new Int32Array(m).buffer);return dt(o,l,n.shape.length,i[n.dtype],f,h,s,c),d},setupFunc:function(e){dt=e.wasm.cwrap(t.PadV2,null,["number","array","number","number","array","array","number","number"])}},lt=m(t.Pow);let pt;const mt={kernelName:t.Prelu,backendName:"wasm",setupFunc:function(e){pt=e.wasm.cwrap(t.Prelu,null,["number","number","number"])},kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:a,alpha:r}=t,s=n.dataIdMap.get(a.dataId).id,u=n.dataIdMap.get(r.dataId).id;let i=s;const o=a;let d=o;"float32"!==o.dtype&&(d=H({backend:n,inputs:{x:a},attrs:{dtype:"float32"}}),i=n.dataIdMap.get(d.dataId).id);const c=n.makeOutput(a.shape,"float32"),l=n.dataIdMap.get(c.dataId).id;return pt(i,u,l),"float32"!==o.dtype&&n.disposeData(d.dataId),c}};let ft;const ht={kernelName:t.Prod,backendName:"wasm",setupFunc:function(e){ft=e.wasm.cwrap(t.Prod,null,["number","number","number","number"])},kernelFunc:function(e){const{backend:n,inputs:a,attrs:r}=e,{axis:s,keepDims:u}=r,{x:o}=a,d=n.dataIdMap.get(o.dataId).id;let c=d,l=o;const{transposed:p,axes:m,originalAxes:f,inputWasTransposed:h}=I(o,s,n);let b=m;if(h){const e=n.dataIdMap.get(p.dataId).id;e!==d&&(l=p,c=e,b=t.backend_util.getInnerMostAxes(b.length,l.shape.length))}t.backend_util.assertAxesAreInnerMostDims("prod",b,l.shape.length);const[y,g]=t.backend_util.computeOutAndReduceShapes(l.shape,b),_=t.util.sizeFromShape(g),k=n.makeOutput(y,l.dtype);if(0!==t.util.sizeFromShape(l.shape)){const e=n.dataIdMap.get(k.dataId).id;ft(c,_,i[k.dtype],e)}if(h&&n.disposeData(p.dataId),u){const e=t.backend_util.expandShapeToKeepDim(k.shape,f);k.shape=e}return k}},bt={kernelName:t.Range,backendName:"wasm",kernelFunc:e=>{const{backend:n,attrs:a}=e,{start:r,stop:s,step:u,dtype:i}=a,o=function(e,n,a,r){if(e===n||e<n&&a<0||n<e&&a>1)return t.util.makeZerosTypedArray(0,r);const s=Math.abs(Math.ceil((n-e)/a)),u=t.util.makeZerosTypedArray(s,r);n<e&&1===a&&(a=-1),u[0]=e;for(let e=1;e<u.length;e++)u[e]=u[e-1]+a;return u}(r,s,u,i),d=n.makeOutput([o.length],i);return n.typedArrayFromHeap(d).set(o),d}},yt=m(t.RealDiv),gt=l(t.Relu),_t=l(t.Relu6);let kt;const wt={kernelName:t.ResizeBilinear,backendName:"wasm",setupFunc:function(e){kt=e.wasm.cwrap(t.ResizeBilinear,null,["number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){const{backend:n,inputs:a,attrs:r}=e,{images:s}=a,{alignCorners:u,halfPixelCenters:i,size:o}=r,[d,c]=o,[l,p,m,f]=s.shape,h=[l,d,c,f];let b,y=n.dataIdMap.get(s.dataId);"float32"!==y.dtype&&(b=H({backend:n,inputs:{x:s},attrs:{dtype:"float32"}}),y=n.dataIdMap.get(b.dataId));const g=y.id,_=n.makeOutput(h,"float32");if(0===t.util.sizeFromShape(s.shape))return _;const k=n.dataIdMap.get(_.dataId).id;return kt(g,l,p,m,f,d,c,u?1:0,i?1:0,k),null!=b&&n.disposeData(b.dataId),_}};let It;const St={kernelName:t.Reverse,backendName:"wasm",kernelFunc:function(e){const{inputs:n,backend:a,attrs:r}=e,{x:s}=n,{dims:u}=r,i=t.util.parseAxisParam(u,s.shape);if(0===s.shape.length)return y({inputs:{x:s},backend:a});const o=a.makeOutput(s.shape,s.dtype),d=a.dataIdMap.get(s.dataId).id,c=a.dataIdMap.get(o.dataId).id,l=new Uint8Array(new Int32Array(i).buffer),p=new Uint8Array(new Int32Array(s.shape).buffer);It(d,l,i.length,p,s.shape.length,c);const m=O({inputs:{x:o},attrs:{shape:s.shape},backend:a});return a.disposeData(o.dataId),m},setupFunc:function(e){It=e.wasm.cwrap(t.Reverse,null,["number","array","number","array","number","number"])}};let vt;const Mt={kernelName:t.RotateWithOffset,backendName:"wasm",kernelFunc:function(e){const{inputs:n,backend:a,attrs:r}=e,{image:s}=n,{radians:u,fillValue:i,center:o}=r,d=a.makeOutput(s.shape,s.dtype),c=a.dataIdMap.get(s.dataId).id,l=a.dataIdMap.get(d.dataId).id,[p,m,f,h]=s.shape,[b,y]=t.backend_util.getImageCenter(o,m,f),g="number"==typeof i?[i,i,i,0===i?0:255]:[...i,255],_=new Uint8Array(new Int32Array(g).buffer);return vt(c,p,m,f,h,u,b,y,_,g.length,l),d},setupFunc:function(e){vt=e.wasm.cwrap(t.RotateWithOffset,null,["number","number","number","number","number","number","number","number","array","number","number"])}},At=l(t.Round),Et=l(t.Rsqrt);let xt;const Nt={kernelName:t.ScatterNd,backendName:"wasm",setupFunc:function(e){xt=e.wasm.cwrap(t.ScatterNd,null,["number","number","number","number","number","number","array","number","number"])},kernelFunc:function(e){const{backend:n,inputs:a,attrs:r}=e,{indices:s,updates:u}=a,{shape:o}=r,d=n.makeOutput(o,u.dtype);if(0===t.util.sizeFromShape(o))return d;const{sliceRank:c,numUpdates:l,sliceSize:p,strides:m,outputSize:f}=t.scatter_util.calculateShapes(u,s,o),h=n.dataIdMap.get(s.dataId).id,b=n.dataIdMap.get(u.dataId).id,y=new Uint8Array(new Int32Array(m).buffer),g=n.dataIdMap.get(d.dataId).id;return xt(h,b,i[u.dtype],c,l,p,y,f,g),d}};let Ft;const Ot={kernelName:t.Select,backendName:"wasm",kernelFunc:function(e){const{inputs:n,backend:a}=e,{condition:r,t:s,e:u}=n,i=a.dataIdMap.get(r.dataId).id,o=a.dataIdMap.get(s.dataId).id,d=a.dataIdMap.get(u.dataId).id,c=a.makeOutput(s.shape,s.dtype),l=a.dataIdMap.get(c.dataId).id,p=r.shape.length,m=s.shape.length,f=0===p||p>1||1===m?1:t.util.sizeFromShape(s.shape.slice(1));return Ft(i,o,d,f,l),c},setupFunc:function(e){Ft=e.wasm.cwrap("SelectV2",null,["number","number","number","number","number"])}};let Tt;const Rt={kernelName:"Sigmoid",backendName:"wasm",setupFunc:function(e){Tt=e.wasm.cwrap(t.Sigmoid,null,["number","number"])},kernelFunc:function(e){const{backend:n,inputs:{x:a}}=e,r=n.dataIdMap.get(a.dataId).id,s=n.makeOutput(a.shape,a.dtype),u=n.dataIdMap.get(s.dataId).id;return 0===t.util.sizeFromShape(s.shape)||Tt(r,u),s}},Ct=l(t.Sin);let Dt;const Pt={kernelName:t.Softmax,backendName:"wasm",setupFunc:function(e){Dt=e.wasm.cwrap(t.Softmax,null,["number","number","number","number"])},kernelFunc:function(e){const{backend:n,inputs:{logits:a},attrs:{dim:r}}=e,s=n.dataIdMap.get(a.dataId).id,u=n.makeOutput(a.shape,a.dtype),i=n.dataIdMap.get(u.dataId).id,o=a.shape[r],d=t.util.sizeFromShape(a.shape)/o;return 0===t.util.sizeFromShape(u.shape)||Dt(s,i,o,d),u}};const Wt={kernelName:t.SpaceToBatchND,backendName:"wasm",kernelFunc:function(e){const{inputs:n,backend:a,attrs:r}=e,{x:s}=n,{blockShape:u,paddings:i}=r,o=t.util.sizeFromShape(u),d=[[0,0]];d.push(...i);for(let e=1+u.length;e<s.shape.length;++e)d.push([0,0]);const c=ct.kernelFunc({inputs:{x:s},backend:a,attrs:{paddings:d,constantValue:0}}),l=t.backend_util.getReshaped(c.shape,u,o,!1),p=t.backend_util.getPermuted(l.length,u.length,!1),m=t.backend_util.getReshapedPermuted(c.shape,u,o,!1),f=O({inputs:{x:c},backend:a,attrs:{shape:l}}),h=k({inputs:{x:f},backend:a,attrs:{perm:p}}),b=O({inputs:{x:h},backend:a,attrs:{shape:m}});return a.disposeData(c.dataId),a.disposeData(f.dataId),a.disposeData(h.dataId),b}};let Lt;const Ht={kernelName:t.SparseFillEmptyRows,backendName:"wasm",setupFunc:function(e){Lt=e.wasm.cwrap("SparseFillEmptyRows","number",["number","number","number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){const{backend:n,inputs:a}=e,{indices:r,values:s,denseShape:u,defaultValue:o}=a,d=r.shape[0],c=r.shape[1],l=n.readSync(u.dataId)[0],p=[d+l,c],m=n.dataIdMap.get(r.dataId).id,f=n.dataIdMap.get(s.dataId).id,h=n.dataIdMap.get(o.dataId).id,b=n.makeOutput(p,r.dtype),y=n.dataIdMap.get(b.dataId).id,g=n.makeOutput(p.slice(0,1),s.dtype),_=n.dataIdMap.get(g.dataId).id,k=n.makeOutput([l],"bool"),w=n.dataIdMap.get(k.dataId).id,I=n.makeOutput([d],r.dtype),S=n.dataIdMap.get(I.dataId).id,v=n.makeOutput([4],"int32"),M=n.dataIdMap.get(v.dataId).id,A=Lt(m,f,i[s.dtype],d,l,c,h,y,_,w,S,M),E=n.readSync(v.dataId);let x;switch(E[0]){case 1:x=t.backend_util.getSparseFillEmptyRowsIndicesDenseShapeMismatch(E[1]);break;case 2:x=t.backend_util.getSparseFillEmptyRowsNegativeIndexErrorMessage(E[1],E[2]);break;case 3:x=t.backend_util.getSparseFillEmptyRowsOutOfRangeIndexErrorMessage(E[1],E[2],E[3]);break;default:x=""}if(n.disposeData(v.dataId),x)throw n.disposeData(b.dataId),n.disposeData(g.dataId),n.disposeData(k.dataId),n.disposeData(I.dataId),new Error(x);let N=b,F=g;return A!==p[0]&&(N=P({inputs:{x:b},attrs:{begin:0,size:[A,c]},backend:n}),F=P({inputs:{x:g},attrs:{begin:0,size:A},backend:n}),n.disposeData(b.dataId),n.disposeData(g.dataId)),[N,F,k,I]}};let Bt;const Ut={kernelName:t.SparseReshape,backendName:"wasm",setupFunc:function(e){Bt=e.wasm.cwrap(t.SparseReshape,null,["number","number","number","number","number","number","number"])},kernelFunc:function(e){const{backend:n,inputs:a}=e,{inputIndices:r,inputShape:s,newShape:u}=a;if(2!==r.shape.length)throw new Error(`Input indices should be a matrix but received shape\n        ${r.shape}`);if(1!==s.shape.length)throw new Error(`Input shape should be a vector but received shape\n        ${s.shape}`);if(1!==u.shape.length)throw new Error(`Target shape should be a vector but received shape ${u.shape}`);const i=n.dataIdMap.get(r.dataId).id,o=n.dataIdMap.get(s.dataId).id,d=n.dataIdMap.get(u.dataId).id,c=r.shape[0],l=t.util.sizeFromShape(u.shape),p=n.makeOutput([c,l],r.dtype),m=n.dataIdMap.get(p.dataId).id,f=n.makeOutput([l],u.dtype),h=n.dataIdMap.get(f.dataId).id,b=n.makeOutput([3],"int32"),y=n.dataIdMap.get(b.dataId).id;Bt(i,o,d,c,m,h,y);const g=n.readSync(b.dataId);let _;switch(g[0]){case 0:_=t.backend_util.getSparseReshapeMultipleNegativeOneOutputDimErrorMessage(g[1],g[2]);break;case 1:_=t.backend_util.getSparseReshapeNegativeOutputDimErrorMessage(g[1],g[2]);break;case 2:_=t.backend_util.getSparseReshapeEmptyTensorZeroOutputDimErrorMessage();break;case 3:{const e=Array.from(n.readSync(s.dataId)),a=Array.from(n.readSync(f.dataId));_=t.backend_util.getSparseReshapeInputOutputMultipleErrorMessage(e,a);break}case 4:{const e=Array.from(n.readSync(s.dataId)),a=Array.from(n.readSync(f.dataId));_=t.backend_util.getSparseReshapeInputOutputMismatchErrorMessage(e,a);break}default:_=""}if(n.disposeData(b.dataId),_)throw n.disposeData(p.dataId),n.disposeData(f.dataId),new Error(_);return[p,f]}};let zt;function jt(e){zt=e.wasm.cwrap("SparseSegmentReduction",null,["number","number","number","number","number","number","number","number","number"])}function qt(e,n){const{backend:a,inputs:r}=e,{data:s,indices:u,segmentIds:o}=r,d=u.shape[0],c=a.readSync(o.dataId,d-1,d)[0],l=d>0?c+1:0;if(l<0)throw new Error(t.backend_util.getSparseSegmentReductionNegativeSegmentIdsErrorMessage());const p=s.shape.slice();p[0]=l;const m=a.dataIdMap.get(s.dataId).id,f=a.dataIdMap.get(u.dataId).id,h=a.dataIdMap.get(o.dataId).id,b=a.makeOutput(p,s.dtype),y=a.dataIdMap.get(b.dataId).id,g=a.makeOutput([4],"int32"),_=a.dataIdMap.get(g.dataId).id;zt(m,i[s.dtype],s.shape[0],f,h,y,_,n,0);const k=a.readSync(g.dataId);let w;switch(k[0]){case 0:w=t.backend_util.getSparseSegmentReductionNegativeSegmentIdsErrorMessage();break;case 1:w=t.backend_util.getSparseSegmentReductionNonIncreasingSegmentIdsErrorMessage();break;case 2:w=t.backend_util.getSparseSegmentReductionSegmentIdOutOfRangeErrorMessage(k[1],k[2]);break;case 3:w=t.backend_util.getSparseSegmentReductionIndicesOutOfRangeErrorMessage(k[1],k[2],k[3]);break;default:w=""}if(a.disposeData(g.dataId),w)throw a.disposeData(b.dataId),new Error(w);return b}const Vt={kernelName:t.SparseSegmentMean,backendName:"wasm",setupFunc:jt,kernelFunc:function(e){return qt(e,!0)}};const Gt={kernelName:t.SparseSegmentSum,backendName:"wasm",setupFunc:jt,kernelFunc:function(e){return qt(e,!1)}};const $t={kernelName:t.SplitV,backendName:"wasm",kernelFunc:function(e){const{inputs:n,attrs:a,backend:r}=e,{x:s}=n,{numOrSizeSplits:u,axis:i}=a,o=t.util.parseAxisParam(i,s.shape)[0],d=t.backend_util.prepareSplitSize(s,u,o),c=new Array(s.shape.length).fill(0),l=s.shape.slice();return d.map((e=>{const t=[...l];t[o]=e;const n=P({inputs:{x:s},attrs:{begin:c,size:t},backend:r});return c[o]+=e,n}))}},Kt=l(t.Sqrt),Xt=l(t.Square),Qt=m(t.SquaredDifference);let Yt;const Zt={kernelName:t.Step,backendName:"wasm",setupFunc:function(e){Yt=e.wasm.cwrap(t.Step,null,["number","number","number","number"])},kernelFunc:function(e){const{backend:t,inputs:n,attrs:a}=e,{alpha:r}=a,{x:s}=n,u=t.dataIdMap.get(s.dataId).id,o=t.makeOutput(s.shape,s.dtype),d=t.dataIdMap.get(o.dataId).id;return Yt(u,r,i[s.dtype],d),o}};let Jt;const en={kernelName:t.StridedSlice,backendName:"wasm",setupFunc:function(e){Jt=e.wasm.cwrap(t.StridedSlice,null,["number","array","number","array","array","array","array","array","number","number"])},kernelFunc:function(e){const{backend:n,inputs:a,attrs:r}=e,{x:s}=a,{begin:u,end:i,strides:o,beginMask:d,endMask:c,ellipsisMask:l,newAxisMask:p,shrinkAxisMask:m}=r,{finalShapeSparse:f,finalShape:h,isIdentity:b,sliceDim0:y,isSimpleSlice:g,begin:_,end:k,strides:w}=t.slice_util.sliceInfo(s.shape,u,i,o,d,c,l,p,m);let I;if(b)I=O({inputs:{x:s},backend:n,attrs:{shape:h}});else if(y||g){t.util.assert(s.shape.length>=1,(()=>`Input must have rank at least 1, got: ${s.shape.length}`));const e=t.slice_util.computeOutShape(_,k,w),a=P({inputs:{x:s},backend:n,attrs:{begin:_,size:e}});I=O({inputs:{x:a},backend:n,attrs:{shape:h}}),n.disposeData(a.dataId)}else{const e=n.makeOutput(f,"float32"),a=n.dataIdMap.get(s.dataId).id,r=new Uint8Array(new Int32Array(t.util.computeStrides(s.shape)).buffer),u=new Uint8Array(new Int32Array(_).buffer),i=new Uint8Array(new Int32Array(k).buffer),o=new Uint8Array(new Int32Array(w).buffer),d=new Uint8Array(new Int32Array(f).buffer),c=new Uint8Array(new Int32Array(t.util.computeStrides(f)).buffer),l=n.dataIdMap.get(e.dataId).id;Jt(a,r,s.shape.length,u,i,o,d,c,f.length,l),I=O({inputs:{x:e},backend:n,attrs:{shape:h}}),n.disposeData(e.dataId)}return I}},tn=m(t.Sub);let nn;const an={kernelName:t.Sum,backendName:"wasm",setupFunc:function(e){nn=e.wasm.cwrap(t.Sum,null,["number","number","number","number"])},kernelFunc:function(e){const{backend:n,inputs:a,attrs:r}=e,{axis:s,keepDims:u}=r,{x:o}=a,d=n.dataIdMap.get(o.dataId).id;let c=d,l=o;const{transposed:p,axes:m,originalAxes:f,inputWasTransposed:h}=I(o,s,n);let b=m;if(h){const e=n.dataIdMap.get(p.dataId).id;e!==d&&(l=p,c=e,b=t.backend_util.getInnerMostAxes(b.length,l.shape.length))}t.backend_util.assertAxesAreInnerMostDims("sum",b,l.shape.length);const[y,g]=t.backend_util.computeOutAndReduceShapes(l.shape,b),_=t.util.sizeFromShape(g),k=n.makeOutput(y,l.dtype);if(0!==t.util.sizeFromShape(l.shape)){const e=n.dataIdMap.get(k.dataId).id;nn(c,_,i[k.dtype],e)}if(h&&n.disposeData(p.dataId),u){const e=t.backend_util.expandShapeToKeepDim(k.shape,f);k.shape=e}return k}},rn=l(t.Tan),sn=l(t.Tanh);let un;const on={kernelName:t.Tile,backendName:"wasm",setupFunc:function(e){un=e.wasm.cwrap(t.Tile,null,["number","array","number","array","number","number"])},kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:r}=t,s=n.dataIdMap.get(r.dataId).id,{reps:u}=a,o=new Array(r.shape.length);for(let e=0;e<o.length;e++)o[e]=r.shape[e]*u[e];const d=new Uint8Array(new Int32Array(r.shape).buffer),c=new Uint8Array(new Int32Array(o).buffer),l=n.makeOutput(o,r.dtype),p=n.dataIdMap.get(l.dataId).id;return un(s,d,r.shape.length,c,o.length,i[l.dtype],p),l}};let dn;const cn={kernelName:t.TopK,backendName:"wasm",setupFunc:function(e){dn=e.wasm.cwrap(t.TopK,null,["number","array","number","number","number","bool","number","number"])},kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:a}=e,{k:r,sorted:s}=n,u=t.dataIdMap.get(a.dataId).id,o=new Uint8Array(new Int32Array(a.shape).buffer),d=a.shape.slice();d[d.length-1]=r;const c=t.makeOutput(d,a.dtype),l=t.dataIdMap.get(c.dataId).id,p=t.makeOutput(d,"int32"),m=t.dataIdMap.get(p.dataId).id;return dn(u,o,a.shape.length,i[a.dtype],r,s,l,m),[c,p]}};let ln;const pn={kernelName:t.Transform,backendName:"wasm",setupFunc:function(e){ln=e.wasm.cwrap(t.Transform,null,["number","number","bool","number","number","number","number","number","number","array","number","number","number","number","number"])},kernelFunc:function(e){const{backend:n,inputs:a,attrs:r}=e,{image:s,transforms:u}=a,{interpolation:i,fillMode:o,fillValue:d,outputShape:c}=r,[l,p,m,f]=s.shape,[h,b]=null!=c?c:[p,m],y=[l,h,b,f],g=new Uint8Array(new Int32Array(t.util.computeStrides(s.shape)).buffer),_=n.makeOutput(y,s.dtype),k=n.dataIdMap.get(_.dataId).id,w=n.dataIdMap.get(s.dataId).id,I=n.dataIdMap.get(u.dataId).id,S="nearest"===i?1:2;let v;switch(o){case"constant":v=1;break;case"reflect":v=2;break;case"wrap":v=3;break;case"nearest":v=4;break;default:v=1}return ln(w,I,u.shape[0]>1,l,h,b,f,m,p,g,s.shape.length-1,S,v,d,k),_}};const mn={kernelName:t.Unpack,backendName:"wasm",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{value:r}=t;let{axis:s}=a;s<0&&(s+=r.shape.length);const u=r.shape[s],i=r.shape.length,o=new Array(i-1);let d=0;for(let e=0;e<i;e++)e!==s&&(o[d++]=r.shape[e]);const c=new Array(u),l=new Array(i).fill(0),p=r.shape.slice();p[s]=1;for(let e=0;e<c.length;e++)l[s]=e,c[e]=P({inputs:{x:r},attrs:{begin:l,size:p},backend:n});return c.map((({dataId:e,dtype:t})=>({dataId:e,dtype:t,shape:o})))}};const fn={kernelName:t.ZerosLike,backendName:"wasm",kernelFunc:function(e){const{inputs:{x:t},backend:n}=e,a=n.makeOutput(t.shape,t.dtype);return n.typedArrayFromHeap(a).fill(0),a}},hn=[c,p,f,b,v,A,x,F,C,L,B,U,j,V,$,X,Q,Y,ee,ne,re,ue,ie,oe,de,le,me,he,be,ye,_e,we,Se,Me,Ee,xe,Ne,g,Oe,Te,Re,Ce,De,We,Le,Be,ze,qe,Ve,Ke,Xe,Qe,Je,tt,at,rt,ut,it,ot,ct,lt,mt,ht,bt,yt,gt,_t,T,wt,St,Mt,At,Et,Nt,Ot,Rt,Ct,W,Pt,Wt,Ht,Ut,Vt,Gt,$t,Kt,Xt,Qt,Zt,en,tn,an,rn,sn,on,cn,pn,w,mn,fn];for(const e of hn)t.registerKernel(e);const bn=t.env();bn.registerFlag("WASM_HAS_SIMD_SUPPORT",(async()=>WebAssembly.validate(new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,2,1,0,10,9,1,7,0,65,0,253,15,26,11])))),bn.registerFlag("WASM_HAS_MULTITHREAD_SUPPORT",(async()=>{if(bn.get("IS_NODE"))return!1;try{return(new MessageChannel).port1.postMessage(new SharedArrayBuffer(1)),WebAssembly.validate(new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,2,1,0,5,4,1,3,1,1,10,11,1,9,0,65,0,254,16,2,0,26,11]))}catch(e){return!1}}));var yn="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function gn(e,t){return e(t={exports:{}},t.exports),t.exports}var _n=gn((function(e,t){var i,o=(i="undefined"!=typeof document&&document.currentScript?document.currentScript.src:void 0,"undefined"!=typeof __filename&&(i=i||__filename),function(e){function t(){return P.buffer!=H&&ae(P.buffer),B}function o(){return P.buffer!=H&&ae(P.buffer),U}function d(){return P.buffer!=H&&ae(P.buffer),z}function c(){return P.buffer!=H&&ae(P.buffer),j}function l(){return P.buffer!=H&&ae(P.buffer),q}var p,m,f,h="undefined"!=typeof(e=e||{})?e:{};h.ready=new Promise((function(e,t){p=e,m=t})),"undefined"!=typeof process&&process.listeners&&(f={uncaughtException:process.listeners("uncaughtException"),unhandledRejection:process.listeners("unhandledRejection")});var b,y={};for(b in h)h.hasOwnProperty(b)&&(y[b]=h[b]);var g=function(e,t){throw t},_=!1,k=!1,w=!1,I=!1;_="object"==typeof window,k="function"==typeof importScripts,w="object"==typeof process&&"object"==typeof process.versions&&"string"==typeof process.versions.node,I=!_&&!w&&!k;var S=h.ENVIRONMENT_IS_PTHREAD||!1;S&&(H=h.buffer);var v,M,A,E,x,N="";function F(e){return h.locateFile?h.locateFile(e,N):N+e}if(w){var O;N=k?n.dirname(N)+"/":__dirname+"/",v=function(e,t){return E||(E=a),x||(x=n),e=x.normalize(e),E.readFileSync(e,t?null:"utf8")},A=function(e){var t=v(e,!0);return t.buffer||(t=new Uint8Array(t)),G(t.buffer),t},process.argv.length>1&&process.argv[1].replace(/\\/g,"/"),process.argv.slice(2),process.on("uncaughtException",(function(e){if(!(e instanceof gn))throw e})),process.on("unhandledRejection",ke),g=function(e){process.exit(e)},h.inspect=function(){return"[Emscripten Module object]"};try{O=r}catch(e){throw console.error('The "worker_threads" module is not supported in this node.js build - perhaps a newer version is needed?'),e}yn.Worker=O.Worker}else I?("undefined"!=typeof read&&(v=function(e){return read(e)}),A=function(e){var t;return"function"==typeof readbuffer?new Uint8Array(readbuffer(e)):(G("object"==typeof(t=read(e,"binary"))),t)},"undefined"!=typeof scriptArgs&&scriptArgs,"function"==typeof quit&&(g=function(e){quit(e)}),"undefined"!=typeof print&&("undefined"==typeof console&&(console={}),console.log=print,console.warn=console.error="undefined"!=typeof printErr?printErr:print)):(_||k)&&(k?N=self.location.href:"undefined"!=typeof document&&document.currentScript&&(N=document.currentScript.src),"undefined"!=typeof i&&i&&(N=i),N=0!==N.indexOf("blob:")?N.substr(0,N.lastIndexOf("/")+1):"",w?(v=function(e,t){return E||(E=a),x||(x=n),e=x.normalize(e),E.readFileSync(e,t?null:"utf8")},A=function(e){var t=v(e,!0);return t.buffer||(t=new Uint8Array(t)),G(t.buffer),t}):(v=function(e){var t=new XMLHttpRequest;return t.open("GET",e,!1),t.send(null),t.responseText},k&&(A=function(e){var t=new XMLHttpRequest;return t.open("GET",e,!1),t.responseType="arraybuffer",t.send(null),new Uint8Array(t.response)}),M=function(e,t,n){var a=new XMLHttpRequest;a.open("GET",e,!0),a.responseType="arraybuffer",a.onload=function(){200==a.status||0==a.status&&a.response?t(a.response):n()},a.onerror=n,a.send(null)}));w&&"undefined"==typeof performance&&(yn.performance=s.performance);var T,R=h.print||console.log.bind(console),C=h.printErr||console.warn.bind(console);for(b in y)y.hasOwnProperty(b)&&(h[b]=y[b]);function D(e){D.shown||(D.shown={}),D.shown[e]||(D.shown[e]=1,C(e))}y=null,h.arguments&&h.arguments,h.thisProgram&&h.thisProgram,h.quit&&(g=h.quit),h.wasmBinary&&(T=h.wasmBinary);var P,W,L=h.noExitRuntime||!0;"object"!=typeof WebAssembly&&ke("no native wasm support detected");var H,B,U,z,j,q,V=!1;function G(e,t){e||ke("Assertion failed: "+t)}function $(e){var t=h["_"+e];return G(t,"Cannot call unknown function "+e+", make sure it is exported"),t}function K(e,t,n,a,r){var s={string:function(e){var t=0;if(null!=e&&0!==e){var n=1+(e.length<<2);J(e,t=pn(n),n)}return t},array:function(e){var t=pn(e.length);return te(e,t),t}},u=$(e),i=[],o=0;if(a)for(var d=0;d<a.length;d++){var c=s[n[d]];c?(0===o&&(o=cn()),i[d]=c(a[d])):i[d]=a[d]}var l=u.apply(null,i);return l=function(e){return"string"===t?Y(e):"boolean"===t?Boolean(e):e}(l),0!==o&&ln(o),l}function X(e,t,n,a){var r=(n=n||[]).every((function(e){return"number"===e}));return"string"!==t&&r&&!a?$(e):function(){return K(e,t,n,arguments)}}function Q(e,t,n){for(var a=t+n,r="";!(t>=a);){var s=e[t++];if(!s)return r;if(128&s){var u=63&e[t++];if(192!=(224&s)){var i=63&e[t++];if((s=224==(240&s)?(15&s)<<12|u<<6|i:(7&s)<<18|u<<12|i<<6|63&e[t++])<65536)r+=String.fromCharCode(s);else{var o=s-65536;r+=String.fromCharCode(55296|o>>10,56320|1023&o)}}else r+=String.fromCharCode((31&s)<<6|u)}else r+=String.fromCharCode(s)}return r}function Y(e,t){return e?Q(o(),e,t):""}function Z(e,t,n,a){if(!(a>0))return 0;for(var r=n,s=n+a-1,u=0;u<e.length;++u){var i=e.charCodeAt(u);if(i>=55296&&i<=57343&&(i=65536+((1023&i)<<10)|1023&e.charCodeAt(++u)),i<=127){if(n>=s)break;t[n++]=i}else if(i<=2047){if(n+1>=s)break;t[n++]=192|i>>6,t[n++]=128|63&i}else if(i<=65535){if(n+2>=s)break;t[n++]=224|i>>12,t[n++]=128|i>>6&63,t[n++]=128|63&i}else{if(n+3>=s)break;t[n++]=240|i>>18,t[n++]=128|i>>12&63,t[n++]=128|i>>6&63,t[n++]=128|63&i}}return t[n]=0,n-r}function J(e,t,n){return Z(e,o(),t,n)}function ee(e){for(var t=0,n=0;n<e.length;++n){var a=e.charCodeAt(n);a>=55296&&a<=57343&&(a=65536+((1023&a)<<10)|1023&e.charCodeAt(++n)),a<=127?++t:t+=a<=2047?2:a<=65535?3:4}return t}function te(e,n){t().set(e,n)}function ne(e,t){return e%t>0&&(e+=t-e%t),e}function ae(e){H=e,h.HEAP8=B=new Int8Array(e),h.HEAP16=new Int16Array(e),h.HEAP32=z=new Int32Array(e),h.HEAPU8=U=new Uint8Array(e),h.HEAPU16=new Uint16Array(e),h.HEAPU32=j=new Uint32Array(e),h.HEAPF32=new Float32Array(e),h.HEAPF64=q=new Float64Array(e)}var re,se=h.INITIAL_MEMORY||16777216;if(S)P=h.wasmMemory,H=h.buffer;else if(h.wasmMemory)P=h.wasmMemory;else if(!((P=new WebAssembly.Memory({initial:se/65536,maximum:32768,shared:!0})).buffer instanceof SharedArrayBuffer))throw C("requested a shared WebAssembly.Memory but the returned buffer is not a SharedArrayBuffer, indicating that while the browser has SharedArrayBuffer it does not have WebAssembly threads support - you may need to set a flag"),w&&console.log("(on node you may need: --experimental-wasm-threads --experimental-wasm-bulk-memory and also use a recent version)"),Error("bad memory");P&&(H=P.buffer),se=H.byteLength,ae(H);var ue=[],ie=[],oe=[],de=[];function ce(){if(!S){if(h.preRun)for("function"==typeof h.preRun&&(h.preRun=[h.preRun]);h.preRun.length;)fe(h.preRun.shift());Te(ue)}}function le(){S||Te(ie)}function pe(){S||Te(oe)}function me(){if(!S){if(h.postRun)for("function"==typeof h.postRun&&(h.postRun=[h.postRun]);h.postRun.length;)he(h.postRun.shift());Te(de)}}function fe(e){ue.unshift(e)}function he(e){de.unshift(e)}S||ie.push({func:function(){Kt()}});var be=0,ye=null;function ge(e){G(!S,"addRunDependency cannot be used in a pthread worker"),be++,h.monitorRunDependencies&&h.monitorRunDependencies(be)}function _e(e){if(be--,h.monitorRunDependencies&&h.monitorRunDependencies(be),0==be&&ye){var t=ye;ye=null,t()}}function ke(e){h.onAbort&&h.onAbort(e),S&&console.error("Pthread aborting at "+(new Error).stack),C(e+=""),V=!0,e="abort("+e+"). Build with -s ASSERTIONS=1 for more info.";var t=new WebAssembly.RuntimeError(e);throw m(t),t}function we(e,t){return String.prototype.startsWith?e.startsWith(t):0===e.indexOf(t)}h.preloadedImages={},h.preloadedAudios={};var Ie="data:application/octet-stream;base64,";function Se(e){return we(e,Ie)}var ve="file://";function Me(e){return we(e,ve)}var Ae="tfjs-backend-wasm-threaded-simd.wasm";function Ee(e){try{if(e==Ae&&T)return new Uint8Array(T);if(A)return A(e);throw"both async and sync fetching of the wasm failed"}catch(e){ke(e)}}function xe(){if(!T&&(_||k)){if("function"==typeof fetch&&!Me(Ae))return fetch(Ae,{credentials:"same-origin"}).then((function(e){if(!e.ok)throw"failed to load wasm binary file at '"+Ae+"'";return e.arrayBuffer()})).catch((function(){return Ee(Ae)}));if(M)return new Promise((function(e,t){M(Ae,(function(t){e(new Uint8Array(t))}),t)}))}return Promise.resolve().then((function(){return Ee(Ae)}))}function Ne(){var e={a:$t};function t(e,t){var n=e.exports;if(h.asm=n,re=h.asm.I,W=t,!S){var a=He.unusedWorkers.length;He.unusedWorkers.forEach((function(e){He.loadWasmModuleToWorker(e,(function(){--a||_e()}))}))}}function n(e){t(e.instance,e.module)}function a(t){return xe().then((function(t){return WebAssembly.instantiate(t,e)})).then(t,(function(e){C("failed to asynchronously prepare wasm: "+e),ke(e)}))}if(S||ge(),h.instantiateWasm)try{return h.instantiateWasm(e,t)}catch(e){return C("Module.instantiateWasm callback failed with error: "+e),!1}return(T||"function"!=typeof WebAssembly.instantiateStreaming||Se(Ae)||Me(Ae)||"function"!=typeof fetch?a(n):fetch(Ae,{credentials:"same-origin"}).then((function(t){return WebAssembly.instantiateStreaming(t,e).then(n,(function(e){return C("wasm streaming compile failed: "+e),C("falling back to ArrayBuffer instantiation"),a(n)}))}))).catch(m),{}}Se(Ae)||(Ae=F(Ae));var Fe={10664:function(){throw"Canceled!"},10682:function(e,t){setTimeout((function(){rn(e,t)}),0)}};function Oe(){He.initRuntime()}function Te(e){for(;e.length>0;){var t=e.shift();if("function"!=typeof t){var n=t.func;"number"==typeof n?void 0===t.arg?re.get(n)():re.get(n)(t.arg):n(void 0===t.arg?null:t.arg)}else t(h)}}var Re={EPERM:63,ENOENT:44,ESRCH:71,EINTR:27,EIO:29,ENXIO:60,E2BIG:1,ENOEXEC:45,EBADF:8,ECHILD:12,EAGAIN:6,EWOULDBLOCK:6,ENOMEM:48,EACCES:2,EFAULT:21,ENOTBLK:105,EBUSY:10,EEXIST:20,EXDEV:75,ENODEV:43,ENOTDIR:54,EISDIR:31,EINVAL:28,ENFILE:41,EMFILE:33,ENOTTY:59,ETXTBSY:74,EFBIG:22,ENOSPC:51,ESPIPE:70,EROFS:69,EMLINK:34,EPIPE:64,EDOM:18,ERANGE:68,ENOMSG:49,EIDRM:24,ECHRNG:106,EL2NSYNC:156,EL3HLT:107,EL3RST:108,ELNRNG:109,EUNATCH:110,ENOCSI:111,EL2HLT:112,EDEADLK:16,ENOLCK:46,EBADE:113,EBADR:114,EXFULL:115,ENOANO:104,EBADRQC:103,EBADSLT:102,EDEADLOCK:16,EBFONT:101,ENOSTR:100,ENODATA:116,ETIME:117,ENOSR:118,ENONET:119,ENOPKG:120,EREMOTE:121,ENOLINK:47,EADV:122,ESRMNT:123,ECOMM:124,EPROTO:65,EMULTIHOP:36,EDOTDOT:125,EBADMSG:9,ENOTUNIQ:126,EBADFD:127,EREMCHG:128,ELIBACC:129,ELIBBAD:130,ELIBSCN:131,ELIBMAX:132,ELIBEXEC:133,ENOSYS:52,ENOTEMPTY:55,ENAMETOOLONG:37,ELOOP:32,EOPNOTSUPP:138,EPFNOSUPPORT:139,ECONNRESET:15,ENOBUFS:42,EAFNOSUPPORT:5,EPROTOTYPE:67,ENOTSOCK:57,ENOPROTOOPT:50,ESHUTDOWN:140,ECONNREFUSED:14,EADDRINUSE:3,ECONNABORTED:13,ENETUNREACH:40,ENETDOWN:38,ETIMEDOUT:73,EHOSTDOWN:142,EHOSTUNREACH:23,EINPROGRESS:26,EALREADY:7,EDESTADDRREQ:17,EMSGSIZE:35,EPROTONOSUPPORT:66,ESOCKTNOSUPPORT:137,EADDRNOTAVAIL:4,ENETRESET:39,EISCONN:30,ENOTCONN:53,ETOOMANYREFS:141,EUSERS:136,EDQUOT:19,ESTALE:72,ENOTSUP:138,ENOMEDIUM:148,EILSEQ:25,EOVERFLOW:61,ECANCELED:11,ENOTRECOVERABLE:56,EOWNERDEAD:62,ESTRPIPE:135};function Ce(e,n){if(e<=0||e>t().length||!0&e||n<0)return-28;if(0==n)return 0;n>=2147483647&&(n=1/0);var a=Atomics.load(d(),bn>>2),r=0;if(a==e&&Atomics.compareExchange(d(),bn>>2,a,0)==a&&(r=1,--n<=0))return 1;var s=Atomics.notify(d(),e>>2,n);if(s>=0)return s+r;throw"Atomics.notify returned an unexpected value "+s}function De(e){if(S)throw"Internal Error! killThread() can only ever be called from main application thread!";if(!e)throw"Internal Error! Null pthread_ptr in killThread!";d()[e+12>>2]=0;var t=He.pthreads[e];t.worker.terminate(),He.freeThreadData(t),He.runningWorkers.splice(He.runningWorkers.indexOf(t.worker),1),t.worker.pthread=void 0}function Pe(e){if(S)throw"Internal Error! cancelThread() can only ever be called from main application thread!";if(!e)throw"Internal Error! Null pthread_ptr in cancelThread!";He.pthreads[e].worker.postMessage({cmd:"cancel"})}function We(e){if(S)throw"Internal Error! cleanupThread() can only ever be called from main application thread!";if(!e)throw"Internal Error! Null pthread_ptr in cleanupThread!";var t=He.pthreads[e];if(t){d()[e+12>>2]=0;var n=t.worker;He.returnWorkerToPool(n)}}h._emscripten_futex_wake=Ce;var Le,He={unusedWorkers:[],runningWorkers:[],initMainThreadBlock:function(){for(var e=0;e<8;++e)He.allocateUnusedWorker()},initRuntime:function(){for(var e=Xt(228),t=0;t<57;++t)c()[e/4+t]=0;d()[e+12>>2]=e;var n=e+152;d()[n>>2]=n;var a=Xt(512);for(t=0;t<128;++t)c()[a/4+t]=0;Atomics.store(c(),e+100>>2,a),Atomics.store(c(),e+40>>2,e),dn(e,!k,1),nn(e)},initWorker:function(){},pthreads:{},threadExitHandlers:[],setThreadStatus:function(){},runExitHandlers:function(){for(;He.threadExitHandlers.length>0;)He.threadExitHandlers.pop()();S&&Jt()&&en()},runExitHandlersAndDeinitThread:function(e,t){Atomics.store(c(),e+56>>2,1),Atomics.store(c(),e+60>>2,0),He.runExitHandlers(),Atomics.store(c(),e+4>>2,t),Atomics.store(c(),e+0>>2,1),Ce(e+0,2147483647),dn(0,0,0)},threadExit:function(e){var t=Jt();t&&(He.runExitHandlersAndDeinitThread(t,e),S&&postMessage({cmd:"exit"}))},threadCancel:function(){He.runExitHandlersAndDeinitThread(Jt(),-1),postMessage({cmd:"cancelDone"})},terminateAllThreads:function(){for(var e in He.pthreads)(a=He.pthreads[e])&&a.worker&&He.returnWorkerToPool(a.worker);He.pthreads={};for(var t=0;t<He.unusedWorkers.length;++t)(n=He.unusedWorkers[t]).terminate();for(He.unusedWorkers=[],t=0;t<He.runningWorkers.length;++t){var n,a=(n=He.runningWorkers[t]).pthread;He.freeThreadData(a),n.terminate()}He.runningWorkers=[]},freeThreadData:function(e){if(e){if(e.threadInfoStruct){var t=d()[e.threadInfoStruct+100>>2];d()[e.threadInfoStruct+100>>2]=0,Qt(t),Qt(e.threadInfoStruct)}e.threadInfoStruct=0,e.allocatedOwnStack&&e.stackBase&&Qt(e.stackBase),e.stackBase=0,e.worker&&(e.worker.pthread=null)}},returnWorkerToPool:function(e){He.runWithoutMainThreadQueuedCalls((function(){delete He.pthreads[e.pthread.threadInfoStruct],He.unusedWorkers.push(e),He.runningWorkers.splice(He.runningWorkers.indexOf(e),1),He.freeThreadData(e.pthread),e.pthread=void 0}))},runWithoutMainThreadQueuedCalls:function(e){d()[hn>>2]=0;try{e()}finally{d()[hn>>2]=1}},receiveObjectTransfer:function(e){},loadWasmModuleToWorker:function(e,t){e.onmessage=function(n){var a=n.data,r=a.cmd;if(e.pthread&&(He.currentProxiedOperationCallerThread=e.pthread.threadInfoStruct),a.targetThread&&a.targetThread!=Jt()){var s=He.pthreads[a.targetThread];return s?s.worker.postMessage(n.data,a.transferList):console.error('Internal error! Worker sent a message "'+r+'" to target pthread '+a.targetThread+", but that thread no longer exists!"),void(He.currentProxiedOperationCallerThread=void 0)}if("processQueuedMainThreadWork"===r)tn();else if("spawnThread"===r)Pt(n.data);else if("cleanupThread"===r)We(a.thread);else if("killThread"===r)De(a.thread);else if("cancelThread"===r)Pe(a.thread);else if("loaded"===r)e.loaded=!0,t&&t(e),e.runPthread&&(e.runPthread(),delete e.runPthread);else if("print"===r)R("Thread "+a.threadId+": "+a.text);else if("printErr"===r)C("Thread "+a.threadId+": "+a.text);else if("alert"===r)alert("Thread "+a.threadId+": "+a.text);else if("exit"===r)e.pthread&&Atomics.load(c(),e.pthread.threadInfoStruct+64>>2)&&He.returnWorkerToPool(e);else if("exitProcess"===r)try{kn(a.returnCode)}catch(n){if(n instanceof gn)return;throw n}else"cancelDone"===r?He.returnWorkerToPool(e):"objectTransfer"===r?He.receiveObjectTransfer(n.data):"setimmediate"===n.data.target?e.postMessage(n.data):C("worker sent an unknown command "+r);He.currentProxiedOperationCallerThread=void 0},e.onerror=function(e){C("pthread sent an error! "+e.filename+":"+e.lineno+": "+e.message)},w&&(e.on("message",(function(t){e.onmessage({data:t})})),e.on("error",(function(t){e.onerror(t)})),e.on("exit",(function(e){}))),e.postMessage({cmd:"load",urlOrBlob:h.mainScriptUrlOrBlob||i,wasmMemory:P,wasmModule:W})},allocateUnusedWorker:function(){var e=F("tfjs-backend-wasm-threaded-simd.worker.js");He.unusedWorkers.push(new Worker(e))},getNewWorker:function(){return 0==He.unusedWorkers.length&&(He.allocateUnusedWorker(),He.loadWasmModuleToWorker(He.unusedWorkers[0])),He.unusedWorkers.length>0?He.unusedWorkers.pop():null},busySpinWait:function(e){for(var t=performance.now()+e;performance.now()<t;);}};function Be(e,t){mn(e,t),ln(e)}function Ue(){return L}function ze(e,t){return re.get(e)(t)}function je(e,t,n,a){ke("Assertion failed: "+Y(e)+", at: "+[t?Y(t):"unknown filename",n,a?Y(a):"unknown function"])}function qe(e,t){_main(e,t)}function Ve(e){return d()[Yt()>>2]=e,e}function Ge(e,t){if(S)return et(1,1,e,t)}function $e(e,t){if(e==t)postMessage({cmd:"processQueuedMainThreadWork"});else if(S)postMessage({targetThread:e,cmd:"processThreadQueue"});else{var n=He.pthreads[e],a=n&&n.worker;if(!a)return;a.postMessage({cmd:"processThreadQueue"})}return 1}function Ke(){ke()}function Xe(e,t,n){var a=at(t,n);return Fe[e].apply(null,a)}function Qe(e,t){}function Ye(e,n,a){if(e<=0||e>t().length||!0&e)return-28;if(_){if(Atomics.load(d(),e>>2)!=n)return-6;var r=performance.now(),s=r+a;for(Atomics.exchange(d(),bn>>2,e);;){if((r=performance.now())>s)return Atomics.exchange(d(),bn>>2,0),-73;if(0==Atomics.exchange(d(),bn>>2,0))break;if(tn(),Atomics.load(d(),e>>2)!=n)return-6;Atomics.exchange(d(),bn>>2,e)}return 0}var u=Atomics.wait(d(),e>>2,n,a);if("timed-out"===u)return-73;if("not-equal"===u)return-6;if("ok"===u)return 0;throw"Atomics.wait returned an unexpected value "+u}function Ze(e,t,n){o().copyWithin(e,t,t+n)}function Je(){return w?u.cpus().length:navigator.hardwareConcurrency}function et(e,t){for(var n=arguments.length-2,a=cn(),r=n,s=pn(8*r),u=s>>3,i=0;i<n;i++){var o=arguments[2+i];l()[u+i]=o}var d=un(e,r,s,t);return ln(a),d}h.establishStackSpace=Be,h.getNoExitRuntime=Ue,h.invokeEntryPoint=ze,Le=w?function(){var e=process.hrtime();return 1e3*e[0]+e[1]/1e6}:S?function(){return performance.now()-h.__performance_now_clock_drift}:"undefined"!=typeof dateNow?dateNow:function(){return performance.now()};var tt=[],nt=[];function at(e,t){var n;for(nt.length=0,t>>=2;n=o()[e++];){var a=n<105;a&&1&t&&t++,nt.push(a?l()[t++>>1]:d()[t]),++t}return nt}function rt(e,t,n){tt.length=t;for(var a=n>>3,r=0;r<t;r++)tt[r]=l()[a+r];return(e<0?Fe[-e-1]:Gt[e]).apply(null,tt)}function st(){return o().length}function ut(e){try{return P.grow(e-H.byteLength+65535>>>16),ae(P.buffer),1}catch(e){}}function it(e){var t=st();if(e<=t)return!1;var n=2147483648;if(e>n)return!1;for(var a=1;a<=4;a*=2){var r=t*(1+.2/a);if(r=Math.min(r,e+100663296),ut(Math.min(n,ne(Math.max(e,r),65536))))return!0}return!1}var ot={inEventHandler:0,removeAllEventListeners:function(){for(var e=ot.eventHandlers.length-1;e>=0;--e)ot._removeHandler(e);ot.eventHandlers=[],ot.deferredCalls=[]},registerRemoveEventListeners:function(){ot.removeEventListenersRegistered||(ot.removeEventListenersRegistered=!0)},deferredCalls:[],deferCall:function(e,t,n){function a(e,t){if(e.length!=t.length)return!1;for(var n in e)if(e[n]!=t[n])return!1;return!0}for(var r in ot.deferredCalls){var s=ot.deferredCalls[r];if(s.targetFunction==e&&a(s.argsList,n))return}ot.deferredCalls.push({targetFunction:e,precedence:t,argsList:n}),ot.deferredCalls.sort((function(e,t){return e.precedence<t.precedence}))},removeDeferredCalls:function(e){for(var t=0;t<ot.deferredCalls.length;++t)ot.deferredCalls[t].targetFunction==e&&(ot.deferredCalls.splice(t,1),--t)},canPerformEventHandlerRequests:function(){return ot.inEventHandler&&ot.currentEventHandler.allowsDeferredCalls},runDeferredCalls:function(){if(ot.canPerformEventHandlerRequests())for(var e=0;e<ot.deferredCalls.length;++e){var t=ot.deferredCalls[e];ot.deferredCalls.splice(e,1),--e,t.targetFunction.apply(null,t.argsList)}},eventHandlers:[],removeAllHandlersOnTarget:function(e,t){for(var n=0;n<ot.eventHandlers.length;++n)ot.eventHandlers[n].target!=e||t&&t!=ot.eventHandlers[n].eventTypeString||ot._removeHandler(n--)},_removeHandler:function(e){var t=ot.eventHandlers[e];t.target.removeEventListener(t.eventTypeString,t.eventListenerFunc,t.useCapture),ot.eventHandlers.splice(e,1)},registerOrRemoveHandler:function(e){var t=function(t){++ot.inEventHandler,ot.currentEventHandler=e,ot.runDeferredCalls(),e.handlerFunc(t),ot.runDeferredCalls(),--ot.inEventHandler};if(e.callbackfunc)e.eventListenerFunc=t,e.target.addEventListener(e.eventTypeString,t,e.useCapture),ot.eventHandlers.push(e),ot.registerRemoveEventListeners();else for(var n=0;n<ot.eventHandlers.length;++n)ot.eventHandlers[n].target==e.target&&ot.eventHandlers[n].eventTypeString==e.eventTypeString&&ot._removeHandler(n--)},queueEventHandlerOnThread_iiii:function(e,t,n,a,r){var s=cn(),u=pn(12);d()[u>>2]=n,d()[u+4>>2]=a,d()[u+8>>2]=r,on(0,e,637534208,t,a,u),ln(s)},getTargetThreadForEventCallback:function(e){switch(e){case 1:return 0;case 2:return He.currentProxiedOperationCallerThread;default:return e}},getNodeNameForTarget:function(e){return e?e==window?"#window":e==screen?"#screen":e&&e.nodeName?e.nodeName:"":""},fullscreenEnabled:function(){return document.fullscreenEnabled||document.webkitFullscreenEnabled}};function dt(e){var t=ee(e)+1,n=Xt(t);return J(e,n,t),n}function ct(e,t,n,a){var r=cn(),s=pn(12),u=0;t&&(u=dt(t)),d()[s>>2]=u,d()[s+4>>2]=n,d()[s+8>>2]=a,on(0,e,657457152,0,u,s),ln(r)}function lt(e,t,n,a){ct(e,t=t?Y(t):"",n,a)}function pt(e){return e>2?Y(e):e}var mt=[0,"undefined"!=typeof document?document:0,"undefined"!=typeof window?window:0];function ft(e){return e=pt(e),mt[e]||("undefined"!=typeof document?document.querySelector(e):void 0)}function ht(e){return ft(e)}function bt(e,t,n){var a=ht(e);if(!a)return-4;if(a.canvasSharedPtr&&(d()[a.canvasSharedPtr>>2]=t,d()[a.canvasSharedPtr+4>>2]=n),!a.offscreenCanvas&&a.controlTransferredOffscreen)return a.canvasSharedPtr?(lt(d()[a.canvasSharedPtr+8>>2],e,t,n),1):-4;a.offscreenCanvas&&(a=a.offscreenCanvas);var r=!1;if(a.GLctxObject&&a.GLctxObject.GLctx){var s=a.GLctxObject.GLctx.getParameter(2978);r=0===s[0]&&0===s[1]&&s[2]===a.width&&s[3]===a.height}return a.width=t,a.height=n,r&&a.GLctxObject.GLctx.viewport(0,0,t,n),0}function yt(e,t,n){return S?et(2,1,e,t,n):bt(e,t,n)}function gt(e,t,n){return ht(e)?bt(e,t,n):yt(e,t,n)}function _t(e){}function kt(e,t){}function wt(e){var t=e.getExtension("ANGLE_instanced_arrays");if(t)return e.vertexAttribDivisor=function(e,n){t.vertexAttribDivisorANGLE(e,n)},e.drawArraysInstanced=function(e,n,a,r){t.drawArraysInstancedANGLE(e,n,a,r)},e.drawElementsInstanced=function(e,n,a,r,s){t.drawElementsInstancedANGLE(e,n,a,r,s)},1}function It(e){var t=e.getExtension("OES_vertex_array_object");if(t)return e.createVertexArray=function(){return t.createVertexArrayOES()},e.deleteVertexArray=function(e){t.deleteVertexArrayOES(e)},e.bindVertexArray=function(e){t.bindVertexArrayOES(e)},e.isVertexArray=function(e){return t.isVertexArrayOES(e)},1}function St(e){var t=e.getExtension("WEBGL_draw_buffers");if(t)return e.drawBuffers=function(e,n){t.drawBuffersWEBGL(e,n)},1}function vt(e){return!!(e.multiDrawWebgl=e.getExtension("WEBGL_multi_draw"))}var Mt={counter:1,buffers:[],programs:[],framebuffers:[],renderbuffers:[],textures:[],uniforms:[],shaders:[],vaos:[],contexts:{},offscreenCanvases:{},timerQueriesEXT:[],programInfos:{},stringCache:{},unpackAlignment:4,recordError:function(e){Mt.lastError||(Mt.lastError=e)},getNewId:function(e){for(var t=Mt.counter++,n=e.length;n<t;n++)e[n]=null;return t},getSource:function(e,t,n,a){for(var r="",s=0;s<t;++s){var u=a?d()[a+4*s>>2]:-1;r+=Y(d()[n+4*s>>2],u<0?void 0:u)}return r},createContext:function(e,t){var n=e.getContext("webgl",t);return n?Mt.registerContext(n,t):0},registerContext:function(e,t){var n=Xt(8);d()[n+4>>2]=Jt();var a={handle:n,attributes:t,version:t.majorVersion,GLctx:e};return e.canvas&&(e.canvas.GLctxObject=a),Mt.contexts[n]=a,("undefined"==typeof t.enableExtensionsByDefault||t.enableExtensionsByDefault)&&Mt.initExtensions(a),n},makeContextCurrent:function(e){return Mt.currentContext=Mt.contexts[e],h.ctx=Nt=Mt.currentContext&&Mt.currentContext.GLctx,!(e&&!Nt)},getContext:function(e){return Mt.contexts[e]},deleteContext:function(e){Mt.currentContext===Mt.contexts[e]&&(Mt.currentContext=null),"object"==typeof ot&&ot.removeAllHandlersOnTarget(Mt.contexts[e].GLctx.canvas),Mt.contexts[e]&&Mt.contexts[e].GLctx.canvas&&(Mt.contexts[e].GLctx.canvas.GLctxObject=void 0),Qt(Mt.contexts[e].handle),Mt.contexts[e]=null},initExtensions:function(e){if(e||(e=Mt.currentContext),!e.initExtensionsDone){e.initExtensionsDone=!0;var t=e.GLctx;wt(t),It(t),St(t),t.disjointTimerQueryExt=t.getExtension("EXT_disjoint_timer_query"),vt(t),(t.getSupportedExtensions()||[]).forEach((function(e){e.indexOf("lose_context")<0&&e.indexOf("debug")<0&&t.getExtension(e)}))}},populateUniformTable:function(e){for(var t=Mt.programs[e],n=Mt.programInfos[e]={uniforms:{},maxUniformLength:0,maxAttributeLength:-1,maxUniformBlockNameLength:-1},a=n.uniforms,r=Nt.getProgramParameter(t,35718),s=0;s<r;++s){var u=Nt.getActiveUniform(t,s),i=u.name;n.maxUniformLength=Math.max(n.maxUniformLength,i.length+1),"]"==i.slice(-1)&&(i=i.slice(0,i.lastIndexOf("[")));var o=Nt.getUniformLocation(t,i);if(o){var d=Mt.getNewId(Mt.uniforms);a[i]=[u.size,d],Mt.uniforms[d]=o;for(var c=1;c<u.size;++c){var l=i+"["+c+"]";o=Nt.getUniformLocation(t,l),d=Mt.getNewId(Mt.uniforms),Mt.uniforms[d]=o}}}}},At=["default","low-power","high-performance"];function Et(e,t){var n=t>>2,a=d()[n+6],r={alpha:!!d()[n+0],depth:!!d()[n+1],stencil:!!d()[n+2],antialias:!!d()[n+3],premultipliedAlpha:!!d()[n+4],preserveDrawingBuffer:!!d()[n+5],powerPreference:At[a],failIfMajorPerformanceCaveat:!!d()[n+7],majorVersion:d()[n+8],minorVersion:d()[n+9],enableExtensionsByDefault:d()[n+10],explicitSwapControl:d()[n+11],proxyContextToMainThread:d()[n+12],renderViaOffscreenBackBuffer:d()[n+13]},s=ht(e);return s?r.explicitSwapControl?0:Mt.createContext(s,r):0}function xt(e,t){return Et(e,t)}var Nt,Ft={mappings:{},buffers:[null,[],[]],printChar:function(e,t){var n=Ft.buffers[e];0===t||10===t?((1===e?R:C)(Q(n,0)),n.length=0):n.push(t)},varargs:void 0,get:function(){return Ft.varargs+=4,d()[Ft.varargs-4>>2]},getStr:function(e){return Y(e)},get64:function(e,t){return e}};function Ot(e){return S?et(3,1,e):0}function Tt(e,t,n,a,r){if(S)return et(4,1,e,t,n,a,r)}function Rt(e,t,n,a){if(S)return et(5,1,e,t,n,a);for(var r=0,s=0;s<n;s++){for(var u=d()[t+8*s>>2],i=d()[t+(8*s+4)>>2],c=0;c<i;c++)Ft.printChar(e,o()[u+c]);r+=i}return d()[a>>2]=r,0}function Ct(e){var t=He.threadExitHandlers.pop();e&&t()}function Dt(e,t){He.threadExitHandlers.push((function(){re.get(e)(t)}))}function Pt(e){if(S)throw"Internal Error! spawnThread() can only ever be called from main application thread!";var t=He.getNewWorker();if(void 0!==t.pthread)throw"Internal error!";if(!e.pthread_ptr)throw"Internal error, no pthread ptr!";He.runningWorkers.push(t);for(var n=Xt(512),a=0;a<128;++a)d()[n+4*a>>2]=0;var r=e.stackBase+e.stackSize,s=He.pthreads[e.pthread_ptr]={worker:t,stackBase:e.stackBase,stackSize:e.stackSize,allocatedOwnStack:e.allocatedOwnStack,threadInfoStruct:e.pthread_ptr},u=s.threadInfoStruct>>2;Atomics.store(c(),u+16,e.detached),Atomics.store(c(),u+25,n),Atomics.store(c(),u+10,s.threadInfoStruct),Atomics.store(c(),u+20,e.stackSize),Atomics.store(c(),u+19,r),Atomics.store(c(),u+26,e.stackSize),Atomics.store(c(),u+28,r),Atomics.store(c(),u+29,e.detached);var i=Zt()+40;Atomics.store(c(),u+43,i),t.pthread=s;var o={cmd:"run",start_routine:e.startRoutine,arg:e.arg,threadInfoStruct:e.pthread_ptr,stackBase:e.stackBase,stackSize:e.stackSize};t.runPthread=function(){o.time=performance.now(),t.postMessage(o,e.transferList)},t.loaded&&(t.runPthread(),delete t.runPthread)}function Wt(e,t,n,a){if("undefined"==typeof SharedArrayBuffer)return C("Current environment does not support SharedArrayBuffer, pthreads are not available!"),6;if(!e)return C("pthread_create called with a null thread pointer!"),28;var r=[];if(S&&0===r.length)return sn(687865856,e,t,n,a);var s=0,u=0,i=0;t&&-1!=t?(s=d()[t>>2],s+=81920,u=d()[t+8>>2],i=0!==d()[t+12>>2]):s=2097152;var o=0==u;o?u=fn(16,s):G((u-=s)>0);for(var l=Xt(228),p=0;p<57;++p)c()[(l>>2)+p]=0;d()[e>>2]=l,d()[l+12>>2]=l;var m=l+152;d()[m>>2]=m;var f={stackBase:u,stackSize:s,allocatedOwnStack:o,detached:i,startRoutine:n,pthread_ptr:l,arg:a,transferList:r};return S?(f.cmd="spawnThread",postMessage(f,r)):Pt(f),0}function Lt(){if(S){var e=Jt();if(e&&!Atomics.load(c(),e+56>>2)&&2==Atomics.load(c(),e+0>>2))throw"Canceled!"}}function Ht(){w||k||D("Blocking on the main thread is very dangerous, see https://emscripten.org/docs/porting/pthreads.html#blocking-on-the-main-browser-thread")}function Bt(e,t,n){if(!e)return C("pthread_join attempted on a null thread pointer!"),Re.ESRCH;if(S&&Jt()==e)return C("PThread "+e+" is attempting to join to itself!"),Re.EDEADLK;if(!S&&an()==e)return C("Main thread "+e+" is attempting to join to itself!"),Re.EDEADLK;if(d()[e+12>>2]!==e)return C("pthread_join attempted on thread "+e+", which does not point to a valid thread, or does not exist anymore!"),Re.ESRCH;if(Atomics.load(c(),e+64>>2))return C("Attempted to join thread "+e+", which was already detached!"),Re.EINVAL;for(n&&Ht();;){var a=Atomics.load(c(),e+0>>2);if(1==a){var r=Atomics.load(c(),e+4>>2);return t&&(d()[t>>2]=r),Atomics.store(c(),e+64>>2,1),S?postMessage({cmd:"cleanupThread",thread:e}):We(e),0}if(!n)return Re.EBUSY;Lt(),S||tn(),Ye(e+0,a,S?100:1)}}function Ut(e,t){return Bt(e,t,!0)}function zt(e){if(S)return et(6,1,e);switch(e){case 30:return 16384;case 85:return 131072;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:case 80:case 81:case 79:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:return"object"==typeof navigator&&navigator.hardwareConcurrency||1}return Ve(28),-1}S||He.initMainThreadBlock();var jt,qt,Vt,Gt=[null,Ge,yt,Ot,Tt,Rt,zt],$t={e:je,r:qe,x:$e,b:Ke,y:Xe,j:Qe,d:Ye,c:Ce,f:Le,p:Ze,A:Je,u:rt,q:it,v:gt,i:_t,s:kt,w:xt,l:Ot,n:Tt,g:Rt,o:Oe,a:P||h.wasmMemory,z:Ct,k:Dt,h:Wt,m:Ut,t:zt},Kt=(Ne(),h.___wasm_call_ctors=function(){return(Kt=h.___wasm_call_ctors=h.asm.B).apply(null,arguments)}),Xt=(h._init=function(){return(h._init=h.asm.C).apply(null,arguments)},h._init_with_threads_count=function(){return(h._init_with_threads_count=h.asm.D).apply(null,arguments)},h._get_threads_count=function(){return(h._get_threads_count=h.asm.E).apply(null,arguments)},h._register_tensor=function(){return(h._register_tensor=h.asm.F).apply(null,arguments)},h._dispose_data=function(){return(h._dispose_data=h.asm.G).apply(null,arguments)},h._dispose=function(){return(h._dispose=h.asm.H).apply(null,arguments)},h._Abs=function(){return(h._Abs=h.asm.J).apply(null,arguments)},h._Add=function(){return(h._Add=h.asm.K).apply(null,arguments)},h._AddN=function(){return(h._AddN=h.asm.L).apply(null,arguments)},h._All=function(){return(h._All=h.asm.M).apply(null,arguments)},h._Any=function(){return(h._Any=h.asm.N).apply(null,arguments)},h._ArgMax=function(){return(h._ArgMax=h.asm.O).apply(null,arguments)},h._AvgPool=function(){return(h._AvgPool=h.asm.P).apply(null,arguments)},h._BatchMatMul=function(){return(h._BatchMatMul=h.asm.Q).apply(null,arguments)},h._Ceil=function(){return(h._Ceil=h.asm.R).apply(null,arguments)},h._ClipByValue=function(){return(h._ClipByValue=h.asm.S).apply(null,arguments)},h._Conv2D=function(){return(h._Conv2D=h.asm.T).apply(null,arguments)},h._Conv2DBackpropInput=function(){return(h._Conv2DBackpropInput=h.asm.U).apply(null,arguments)},h._Cos=function(){return(h._Cos=h.asm.V).apply(null,arguments)},h._Cosh=function(){return(h._Cosh=h.asm.W).apply(null,arguments)},h._CropAndResize=function(){return(h._CropAndResize=h.asm.X).apply(null,arguments)},h._Cumsum=function(){return(h._Cumsum=h.asm.Y).apply(null,arguments)},h._DepthToSpace=function(){return(h._DepthToSpace=h.asm.Z).apply(null,arguments)},h._DepthwiseConv2dNative=function(){return(h._DepthwiseConv2dNative=h.asm._).apply(null,arguments)},h._Elu=function(){return(h._Elu=h.asm.$).apply(null,arguments)},h._Equal=function(){return(h._Equal=h.asm.aa).apply(null,arguments)},h._Exp=function(){return(h._Exp=h.asm.ba).apply(null,arguments)},h._FlipLeftRight=function(){return(h._FlipLeftRight=h.asm.ca).apply(null,arguments)},h._Floor=function(){return(h._Floor=h.asm.da).apply(null,arguments)},h._FloorDiv=function(){return(h._FloorDiv=h.asm.ea).apply(null,arguments)},h._FusedBatchNorm=function(){return(h._FusedBatchNorm=h.asm.fa).apply(null,arguments)},h._FusedConv2D=function(){return(h._FusedConv2D=h.asm.ga).apply(null,arguments)},h._FusedDepthwiseConv2D=function(){return(h._FusedDepthwiseConv2D=h.asm.ha).apply(null,arguments)},h._Gather=function(){return(h._Gather=h.asm.ia).apply(null,arguments)},h._GatherNd=function(){return(h._GatherNd=h.asm.ja).apply(null,arguments)},h._Greater=function(){return(h._Greater=h.asm.ka).apply(null,arguments)},h._GreaterEqual=function(){return(h._GreaterEqual=h.asm.la).apply(null,arguments)},h._LeakyRelu=function(){return(h._LeakyRelu=h.asm.ma).apply(null,arguments)},h._Less=function(){return(h._Less=h.asm.na).apply(null,arguments)},h._LessEqual=function(){return(h._LessEqual=h.asm.oa).apply(null,arguments)},h._Log=function(){return(h._Log=h.asm.pa).apply(null,arguments)},h._LogicalAnd=function(){return(h._LogicalAnd=h.asm.qa).apply(null,arguments)},h._Max=function(){return(h._Max=h.asm.ra).apply(null,arguments)},h._MaxPool=function(){return(h._MaxPool=h.asm.sa).apply(null,arguments)},h._Maximum=function(){return(h._Maximum=h.asm.ta).apply(null,arguments)},h._Mean=function(){return(h._Mean=h.asm.ua).apply(null,arguments)},h._Min=function(){return(h._Min=h.asm.va).apply(null,arguments)},h._Minimum=function(){return(h._Minimum=h.asm.wa).apply(null,arguments)},h._MirrorPad=function(){return(h._MirrorPad=h.asm.xa).apply(null,arguments)},h._Multiply=function(){return(h._Multiply=h.asm.ya).apply(null,arguments)},h._Neg=function(){return(h._Neg=h.asm.za).apply(null,arguments)},h._NonMaxSuppressionV3=function(){return(h._NonMaxSuppressionV3=h.asm.Aa).apply(null,arguments)},h._NonMaxSuppressionV4=function(){return(h._NonMaxSuppressionV4=h.asm.Ba).apply(null,arguments)},h._NonMaxSuppressionV5=function(){return(h._NonMaxSuppressionV5=h.asm.Ca).apply(null,arguments)},h._NotEqual=function(){return(h._NotEqual=h.asm.Da).apply(null,arguments)},h._OneHot=function(){return(h._OneHot=h.asm.Ea).apply(null,arguments)},h._PadV2=function(){return(h._PadV2=h.asm.Fa).apply(null,arguments)},h._Pow=function(){return(h._Pow=h.asm.Ga).apply(null,arguments)},h._Prelu=function(){return(h._Prelu=h.asm.Ha).apply(null,arguments)},h._Prod=function(){return(h._Prod=h.asm.Ia).apply(null,arguments)},h._RealDiv=function(){return(h._RealDiv=h.asm.Ja).apply(null,arguments)},h._Relu=function(){return(h._Relu=h.asm.Ka).apply(null,arguments)},h._Relu6=function(){return(h._Relu6=h.asm.La).apply(null,arguments)},h._ResizeBilinear=function(){return(h._ResizeBilinear=h.asm.Ma).apply(null,arguments)},h._Reverse=function(){return(h._Reverse=h.asm.Na).apply(null,arguments)},h._RotateWithOffset=function(){return(h._RotateWithOffset=h.asm.Oa).apply(null,arguments)},h._Round=function(){return(h._Round=h.asm.Pa).apply(null,arguments)},h._Rsqrt=function(){return(h._Rsqrt=h.asm.Qa).apply(null,arguments)},h._ScatterNd=function(){return(h._ScatterNd=h.asm.Ra).apply(null,arguments)},h._SelectV2=function(){return(h._SelectV2=h.asm.Sa).apply(null,arguments)},h._Sigmoid=function(){return(h._Sigmoid=h.asm.Ta).apply(null,arguments)},h._Sin=function(){return(h._Sin=h.asm.Ua).apply(null,arguments)},h._Softmax=function(){return(h._Softmax=h.asm.Va).apply(null,arguments)},h._SparseFillEmptyRows=function(){return(h._SparseFillEmptyRows=h.asm.Wa).apply(null,arguments)},h._SparseReshape=function(){return(h._SparseReshape=h.asm.Xa).apply(null,arguments)},h._SparseSegmentReduction=function(){return(h._SparseSegmentReduction=h.asm.Ya).apply(null,arguments)},h._Sqrt=function(){return(h._Sqrt=h.asm.Za).apply(null,arguments)},h._Square=function(){return(h._Square=h.asm._a).apply(null,arguments)},h._SquaredDifference=function(){return(h._SquaredDifference=h.asm.$a).apply(null,arguments)},h._Step=function(){return(h._Step=h.asm.ab).apply(null,arguments)},h._StridedSlice=function(){return(h._StridedSlice=h.asm.bb).apply(null,arguments)},h._Sub=function(){return(h._Sub=h.asm.cb).apply(null,arguments)},h._Sum=function(){return(h._Sum=h.asm.db).apply(null,arguments)},h._Tan=function(){return(h._Tan=h.asm.eb).apply(null,arguments)},h._Tanh=function(){return(h._Tanh=h.asm.fb).apply(null,arguments)},h._Tile=function(){return(h._Tile=h.asm.gb).apply(null,arguments)},h._TopK=function(){return(h._TopK=h.asm.hb).apply(null,arguments)},h._Transform=function(){return(h._Transform=h.asm.ib).apply(null,arguments)},h._Transpose=function(){return(h._Transpose=h.asm.jb).apply(null,arguments)},h.__FusedMatMul=function(){return(h.__FusedMatMul=h.asm.kb).apply(null,arguments)},h._malloc=function(){return(Xt=h._malloc=h.asm.lb).apply(null,arguments)}),Qt=h._free=function(){return(Qt=h._free=h.asm.mb).apply(null,arguments)},Yt=h.___errno_location=function(){return(Yt=h.___errno_location=h.asm.nb).apply(null,arguments)},Zt=h._emscripten_get_global_libc=function(){return(Zt=h._emscripten_get_global_libc=h.asm.ob).apply(null,arguments)},Jt=h._pthread_self=function(){return(Jt=h._pthread_self=h.asm.pb).apply(null,arguments)},en=h.___pthread_tsd_run_dtors=function(){return(en=h.___pthread_tsd_run_dtors=h.asm.qb).apply(null,arguments)},tn=h._emscripten_main_thread_process_queued_calls=function(){return(tn=h._emscripten_main_thread_process_queued_calls=h.asm.rb).apply(null,arguments)},nn=(h._emscripten_current_thread_process_queued_calls=function(){return(h._emscripten_current_thread_process_queued_calls=h.asm.sb).apply(null,arguments)},h._emscripten_register_main_browser_thread_id=function(){return(nn=h._emscripten_register_main_browser_thread_id=h.asm.tb).apply(null,arguments)}),an=h._emscripten_main_browser_thread_id=function(){return(an=h._emscripten_main_browser_thread_id=h.asm.ub).apply(null,arguments)},rn=h.__emscripten_do_dispatch_to_thread=function(){return(rn=h.__emscripten_do_dispatch_to_thread=h.asm.vb).apply(null,arguments)},sn=h._emscripten_sync_run_in_main_thread_4=function(){return(sn=h._emscripten_sync_run_in_main_thread_4=h.asm.wb).apply(null,arguments)},un=h._emscripten_run_in_main_runtime_thread_js=function(){return(un=h._emscripten_run_in_main_runtime_thread_js=h.asm.xb).apply(null,arguments)},on=h.__emscripten_call_on_thread=function(){return(on=h.__emscripten_call_on_thread=h.asm.yb).apply(null,arguments)},dn=(h._emscripten_tls_init=function(){return(h._emscripten_tls_init=h.asm.zb).apply(null,arguments)},h.__emscripten_thread_init=function(){return(dn=h.__emscripten_thread_init=h.asm.Ab).apply(null,arguments)}),cn=h.stackSave=function(){return(cn=h.stackSave=h.asm.Bb).apply(null,arguments)},ln=h.stackRestore=function(){return(ln=h.stackRestore=h.asm.Cb).apply(null,arguments)},pn=h.stackAlloc=function(){return(pn=h.stackAlloc=h.asm.Db).apply(null,arguments)},mn=h._emscripten_stack_set_limits=function(){return(mn=h._emscripten_stack_set_limits=h.asm.Eb).apply(null,arguments)},fn=h._memalign=function(){return(fn=h._memalign=h.asm.Fb).apply(null,arguments)},hn=h.__emscripten_allow_main_runtime_queued_calls=10656,bn=h.__emscripten_main_thread_futex=12292;function gn(e){this.name="ExitStatus",this.message="Program terminated with exit("+e+")",this.status=e}function _n(e){if(!(be>0)){if(S)return p(h),le(),void postMessage({cmd:"loaded"});ce(),be>0||(h.setStatus?(h.setStatus("Running..."),setTimeout((function(){setTimeout((function(){h.setStatus("")}),1),t()}),1)):t())}function t(){jt||(jt=!0,h.calledRun=!0,V||(le(),pe(),p(h),h.onRuntimeInitialized&&h.onRuntimeInitialized(),me()))}}function kn(e,t){if(!t||!L||0!==e){if(!t&&S)throw postMessage({cmd:"exitProcess",returnCode:e}),new gn(e);L||(He.terminateAllThreads(),h.onExit&&h.onExit(e),V=!0),g(e,new gn(e))}}if(h.cwrap=X,h.PThread=He,h.PThread=He,h.wasmMemory=P,h.ExitStatus=gn,ye=function e(){jt||_n(),jt||(ye=e)},h.run=_n,h.preInit)for("function"==typeof h.preInit&&(h.preInit=[h.preInit]);h.preInit.length>0;)h.preInit.pop()();if(S&&(L=!1,He.initWorker()),_n(),f&&(qt={uncaughtException:process.listeners("uncaughtException").filter((function(e){return!f.uncaughtException.indexOf(e)>-1})),unhandledRejection:process.listeners("unhandledRejection").filter((function(e){return!f.unhandledRejection.indexOf(e)>-1}))}),"undefined"!=typeof WasmBackendModule)Vt=WasmBackendModule;else{if("undefined"==typeof e)throw new Error("Could not find wasm module in post.js");Vt=e}if(qt){var wn=Vt._dispose;Vt._dispose=function(){wn(),qt.uncaughtException.forEach((function(e){process.removeListener("uncaughtException",e)})),qt.unhandledRejection.forEach((function(e){process.removeListener("unhandledRejection",e)}))}}return e.ready});e.exports=o}));var kn=gn((function(e,t){var r,s=(r="undefined"!=typeof document&&document.currentScript?document.currentScript.src:void 0,"undefined"!=typeof __filename&&(r=r||__filename),function(e){var t,s,u,i="undefined"!=typeof(e=e||{})?e:{};i.ready=new Promise((function(e,n){t=e,s=n})),"undefined"!=typeof process&&process.listeners&&(u={uncaughtException:process.listeners("uncaughtException"),unhandledRejection:process.listeners("unhandledRejection")});var o,d={};for(o in i)i.hasOwnProperty(o)&&(d[o]=i[o]);var c=!1,l=!1,p=!1,m=!1;c="object"==typeof window,l="function"==typeof importScripts,p="object"==typeof process&&"object"==typeof process.versions&&"string"==typeof process.versions.node,m=!c&&!p&&!l;var f,h,b,y,g,_="";function k(e){return i.locateFile?i.locateFile(e,_):_+e}p?(_=l?n.dirname(_)+"/":__dirname+"/",f=function(e,t){return y||(y=a),g||(g=n),e=g.normalize(e),y.readFileSync(e,t?null:"utf8")},b=function(e){var t=f(e,!0);return t.buffer||(t=new Uint8Array(t)),A(t.buffer),t},process.argv.length>1&&process.argv[1].replace(/\\/g,"/"),process.argv.slice(2),process.on("uncaughtException",(function(e){if(!(e instanceof Pe))throw e})),process.on("unhandledRejection",ae),i.inspect=function(){return"[Emscripten Module object]"}):m?("undefined"!=typeof read&&(f=function(e){return read(e)}),b=function(e){var t;return"function"==typeof readbuffer?new Uint8Array(readbuffer(e)):(A("object"==typeof(t=read(e,"binary"))),t)},"undefined"!=typeof scriptArgs&&scriptArgs,"undefined"!=typeof print&&("undefined"==typeof console&&(console={}),console.log=print,console.warn=console.error="undefined"!=typeof printErr?printErr:print)):(c||l)&&(l?_=self.location.href:"undefined"!=typeof document&&document.currentScript&&(_=document.currentScript.src),r&&(_=r),_=0!==_.indexOf("blob:")?_.substr(0,_.lastIndexOf("/")+1):"",f=function(e){var t=new XMLHttpRequest;return t.open("GET",e,!1),t.send(null),t.responseText},l&&(b=function(e){var t=new XMLHttpRequest;return t.open("GET",e,!1),t.responseType="arraybuffer",t.send(null),new Uint8Array(t.response)}),h=function(e,t,n){var a=new XMLHttpRequest;a.open("GET",e,!0),a.responseType="arraybuffer",a.onload=function(){200==a.status||0==a.status&&a.response?t(a.response):n()},a.onerror=n,a.send(null)});var w,I,S=i.print||console.log.bind(console),v=i.printErr||console.warn.bind(console);for(o in d)d.hasOwnProperty(o)&&(i[o]=d[o]);d=null,i.arguments&&i.arguments,i.thisProgram&&i.thisProgram,i.quit&&i.quit,i.wasmBinary&&(w=i.wasmBinary),i.noExitRuntime,"object"!=typeof WebAssembly&&ae("no native wasm support detected");var M=!1;function A(e,t){e||ae("Assertion failed: "+t)}function E(e){var t=i["_"+e];return A(t,"Cannot call unknown function "+e+", make sure it is exported"),t}function x(e,t,n,a,r){var s={string:function(e){var t=0;if(null!=e&&0!==e){var n=1+(e.length<<2);L(e,t=De(n),n)}return t},array:function(e){var t=De(e.length);return H(e,t),t}},u=E(e),i=[],o=0;if(a)for(var d=0;d<a.length;d++){var c=s[n[d]];c?(0===o&&(o=Re()),i[d]=c(a[d])):i[d]=a[d]}var l=u.apply(null,i);return l=function(e){return"string"===t?P(e):"boolean"===t?Boolean(e):e}(l),0!==o&&Ce(o),l}function N(e,t,n,a){var r=(n=n||[]).every((function(e){return"number"===e}));return"string"!==t&&r&&!a?E(e):function(){return x(e,t,n,arguments)}}var F,O,T,R,C="undefined"!=typeof TextDecoder?new TextDecoder("utf8"):void 0;function D(e,t,n){for(var a=t+n,r=t;e[r]&&!(r>=a);)++r;if(r-t>16&&e.subarray&&C)return C.decode(e.subarray(t,r));for(var s="";t<r;){var u=e[t++];if(128&u){var i=63&e[t++];if(192!=(224&u)){var o=63&e[t++];if((u=224==(240&u)?(15&u)<<12|i<<6|o:(7&u)<<18|i<<12|o<<6|63&e[t++])<65536)s+=String.fromCharCode(u);else{var d=u-65536;s+=String.fromCharCode(55296|d>>10,56320|1023&d)}}else s+=String.fromCharCode((31&u)<<6|i)}else s+=String.fromCharCode(u)}return s}function P(e,t){return e?D(T,e,t):""}function W(e,t,n,a){if(!(a>0))return 0;for(var r=n,s=n+a-1,u=0;u<e.length;++u){var i=e.charCodeAt(u);if(i>=55296&&i<=57343&&(i=65536+((1023&i)<<10)|1023&e.charCodeAt(++u)),i<=127){if(n>=s)break;t[n++]=i}else if(i<=2047){if(n+1>=s)break;t[n++]=192|i>>6,t[n++]=128|63&i}else if(i<=65535){if(n+2>=s)break;t[n++]=224|i>>12,t[n++]=128|i>>6&63,t[n++]=128|63&i}else{if(n+3>=s)break;t[n++]=240|i>>18,t[n++]=128|i>>12&63,t[n++]=128|i>>6&63,t[n++]=128|63&i}}return t[n]=0,n-r}function L(e,t,n){return W(e,T,t,n)}function H(e,t){O.set(e,t)}function B(e,t){return e%t>0&&(e+=t-e%t),e}function U(e){F=e,i.HEAP8=O=new Int8Array(e),i.HEAP16=new Int16Array(e),i.HEAP32=R=new Int32Array(e),i.HEAPU8=T=new Uint8Array(e),i.HEAPU16=new Uint16Array(e),i.HEAPU32=new Uint32Array(e),i.HEAPF32=new Float32Array(e),i.HEAPF64=new Float64Array(e)}i.INITIAL_MEMORY;var z,j=[],q=[],V=[],G=[];function $(){if(i.preRun)for("function"==typeof i.preRun&&(i.preRun=[i.preRun]);i.preRun.length;)Y(i.preRun.shift());me(j)}function K(){me(q)}function X(){me(V)}function Q(){if(i.postRun)for("function"==typeof i.postRun&&(i.postRun=[i.postRun]);i.postRun.length;)Z(i.postRun.shift());me(G)}function Y(e){j.unshift(e)}function Z(e){G.unshift(e)}q.push({func:function(){Oe()}});var J=0,ee=null;function te(e){J++,i.monitorRunDependencies&&i.monitorRunDependencies(J)}function ne(e){if(J--,i.monitorRunDependencies&&i.monitorRunDependencies(J),0==J&&ee){var t=ee;ee=null,t()}}function ae(e){i.onAbort&&i.onAbort(e),v(e+=""),M=!0,e="abort("+e+"). Build with -s ASSERTIONS=1 for more info.";var t=new WebAssembly.RuntimeError(e);throw s(t),t}function re(e,t){return String.prototype.startsWith?e.startsWith(t):0===e.indexOf(t)}i.preloadedImages={},i.preloadedAudios={};var se="data:application/octet-stream;base64,";function ue(e){return re(e,se)}var ie="file://";function oe(e){return re(e,ie)}var de="tfjs-backend-wasm.wasm";function ce(e){try{if(e==de&&w)return new Uint8Array(w);if(b)return b(e);throw"both async and sync fetching of the wasm failed"}catch(e){ae(e)}}function le(){if(!w&&(c||l)){if("function"==typeof fetch&&!oe(de))return fetch(de,{credentials:"same-origin"}).then((function(e){if(!e.ok)throw"failed to load wasm binary file at '"+de+"'";return e.arrayBuffer()})).catch((function(){return ce(de)}));if(h)return new Promise((function(e,t){h(de,(function(t){e(new Uint8Array(t))}),t)}))}return Promise.resolve().then((function(){return ce(de)}))}function pe(){var e={a:Fe};function t(e,t){var n=e.exports;i.asm=n,U((I=i.asm.j).buffer),z=i.asm.r,ne()}function n(e){t(e.instance)}function a(t){return le().then((function(t){return WebAssembly.instantiate(t,e)})).then(t,(function(e){v("failed to asynchronously prepare wasm: "+e),ae(e)}))}if(te(),i.instantiateWasm)try{return i.instantiateWasm(e,t)}catch(e){return v("Module.instantiateWasm callback failed with error: "+e),!1}return(w||"function"!=typeof WebAssembly.instantiateStreaming||ue(de)||oe(de)||"function"!=typeof fetch?a(n):fetch(de,{credentials:"same-origin"}).then((function(t){return WebAssembly.instantiateStreaming(t,e).then(n,(function(e){return v("wasm streaming compile failed: "+e),v("falling back to ArrayBuffer instantiation"),a(n)}))}))).catch(s),{}}function me(e){for(;e.length>0;){var t=e.shift();if("function"!=typeof t){var n=t.func;"number"==typeof n?void 0===t.arg?z.get(n)():z.get(n)(t.arg):n(void 0===t.arg?null:t.arg)}else t(i)}}function fe(){ae()}function he(e,t,n){T.copyWithin(e,t,t+n)}function be(){return T.length}function ye(e){try{return I.grow(e-F.byteLength+65535>>>16),U(I.buffer),1}catch(e){}}function ge(e){var t=be(),n=2147483648;if(e>n)return!1;for(var a=1;a<=4;a*=2){var r=t*(1+.2/a);if(r=Math.min(r,e+100663296),ye(Math.min(n,B(Math.max(e,r),65536))))return!0}return!1}ue(de)||(de=k(de));var _e={mappings:{},buffers:[null,[],[]],printChar:function(e,t){var n=_e.buffers[e];0===t||10===t?((1===e?S:v)(D(n,0)),n.length=0):n.push(t)},varargs:void 0,get:function(){return _e.varargs+=4,R[_e.varargs-4>>2]},getStr:function(e){return P(e)},get64:function(e,t){return e}};function ke(e){return 0}function we(e,t,n,a,r){}function Ie(e,t,n,a){for(var r=0,s=0;s<n;s++){for(var u=R[t+8*s>>2],i=R[t+(8*s+4)>>2],o=0;o<i;o++)_e.printChar(e,T[u+o]);r+=i}return R[a>>2]=r,0}function Se(){return 6}function ve(){return 28}function Me(e){return R[Te()>>2]=e,e}function Ae(e){switch(e){case 30:return 16384;case 85:return 131072;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:case 80:case 81:case 79:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:return"object"==typeof navigator&&navigator.hardwareConcurrency||1}return Me(28),-1}var Ee,xe,Ne,Fe={a:fe,d:he,e:ge,f:ke,c:we,b:Ie,h:Se,g:ve,i:Ae},Oe=(pe(),i.___wasm_call_ctors=function(){return(Oe=i.___wasm_call_ctors=i.asm.k).apply(null,arguments)}),Te=(i._init=function(){return(i._init=i.asm.l).apply(null,arguments)},i._init_with_threads_count=function(){return(i._init_with_threads_count=i.asm.m).apply(null,arguments)},i._get_threads_count=function(){return(i._get_threads_count=i.asm.n).apply(null,arguments)},i._register_tensor=function(){return(i._register_tensor=i.asm.o).apply(null,arguments)},i._dispose_data=function(){return(i._dispose_data=i.asm.p).apply(null,arguments)},i._dispose=function(){return(i._dispose=i.asm.q).apply(null,arguments)},i._Abs=function(){return(i._Abs=i.asm.s).apply(null,arguments)},i._Add=function(){return(i._Add=i.asm.t).apply(null,arguments)},i._AddN=function(){return(i._AddN=i.asm.u).apply(null,arguments)},i._All=function(){return(i._All=i.asm.v).apply(null,arguments)},i._Any=function(){return(i._Any=i.asm.w).apply(null,arguments)},i._ArgMax=function(){return(i._ArgMax=i.asm.x).apply(null,arguments)},i._AvgPool=function(){return(i._AvgPool=i.asm.y).apply(null,arguments)},i._BatchMatMul=function(){return(i._BatchMatMul=i.asm.z).apply(null,arguments)},i._Ceil=function(){return(i._Ceil=i.asm.A).apply(null,arguments)},i._ClipByValue=function(){return(i._ClipByValue=i.asm.B).apply(null,arguments)},i._Conv2D=function(){return(i._Conv2D=i.asm.C).apply(null,arguments)},i._Conv2DBackpropInput=function(){return(i._Conv2DBackpropInput=i.asm.D).apply(null,arguments)},i._Cos=function(){return(i._Cos=i.asm.E).apply(null,arguments)},i._Cosh=function(){return(i._Cosh=i.asm.F).apply(null,arguments)},i._CropAndResize=function(){return(i._CropAndResize=i.asm.G).apply(null,arguments)},i._Cumsum=function(){return(i._Cumsum=i.asm.H).apply(null,arguments)},i._DepthToSpace=function(){return(i._DepthToSpace=i.asm.I).apply(null,arguments)},i._DepthwiseConv2dNative=function(){return(i._DepthwiseConv2dNative=i.asm.J).apply(null,arguments)},i._Elu=function(){return(i._Elu=i.asm.K).apply(null,arguments)},i._Equal=function(){return(i._Equal=i.asm.L).apply(null,arguments)},i._Exp=function(){return(i._Exp=i.asm.M).apply(null,arguments)},i._FlipLeftRight=function(){return(i._FlipLeftRight=i.asm.N).apply(null,arguments)},i._Floor=function(){return(i._Floor=i.asm.O).apply(null,arguments)},i._FloorDiv=function(){return(i._FloorDiv=i.asm.P).apply(null,arguments)},i._FusedBatchNorm=function(){return(i._FusedBatchNorm=i.asm.Q).apply(null,arguments)},i._FusedConv2D=function(){return(i._FusedConv2D=i.asm.R).apply(null,arguments)},i._FusedDepthwiseConv2D=function(){return(i._FusedDepthwiseConv2D=i.asm.S).apply(null,arguments)},i._Gather=function(){return(i._Gather=i.asm.T).apply(null,arguments)},i._GatherNd=function(){return(i._GatherNd=i.asm.U).apply(null,arguments)},i._Greater=function(){return(i._Greater=i.asm.V).apply(null,arguments)},i._GreaterEqual=function(){return(i._GreaterEqual=i.asm.W).apply(null,arguments)},i._LeakyRelu=function(){return(i._LeakyRelu=i.asm.X).apply(null,arguments)},i._Less=function(){return(i._Less=i.asm.Y).apply(null,arguments)},i._LessEqual=function(){return(i._LessEqual=i.asm.Z).apply(null,arguments)},i._Log=function(){return(i._Log=i.asm._).apply(null,arguments)},i._LogicalAnd=function(){return(i._LogicalAnd=i.asm.$).apply(null,arguments)},i._Max=function(){return(i._Max=i.asm.aa).apply(null,arguments)},i._MaxPool=function(){return(i._MaxPool=i.asm.ba).apply(null,arguments)},i._Maximum=function(){return(i._Maximum=i.asm.ca).apply(null,arguments)},i._Mean=function(){return(i._Mean=i.asm.da).apply(null,arguments)},i._Min=function(){return(i._Min=i.asm.ea).apply(null,arguments)},i._Minimum=function(){return(i._Minimum=i.asm.fa).apply(null,arguments)},i._MirrorPad=function(){return(i._MirrorPad=i.asm.ga).apply(null,arguments)},i._Multiply=function(){return(i._Multiply=i.asm.ha).apply(null,arguments)},i._Neg=function(){return(i._Neg=i.asm.ia).apply(null,arguments)},i._NonMaxSuppressionV3=function(){return(i._NonMaxSuppressionV3=i.asm.ja).apply(null,arguments)},i._NonMaxSuppressionV4=function(){return(i._NonMaxSuppressionV4=i.asm.ka).apply(null,arguments)},i._NonMaxSuppressionV5=function(){return(i._NonMaxSuppressionV5=i.asm.la).apply(null,arguments)},i._NotEqual=function(){return(i._NotEqual=i.asm.ma).apply(null,arguments)},i._OneHot=function(){return(i._OneHot=i.asm.na).apply(null,arguments)},i._PadV2=function(){return(i._PadV2=i.asm.oa).apply(null,arguments)},i._Pow=function(){return(i._Pow=i.asm.pa).apply(null,arguments)},i._Prelu=function(){return(i._Prelu=i.asm.qa).apply(null,arguments)},i._Prod=function(){return(i._Prod=i.asm.ra).apply(null,arguments)},i._RealDiv=function(){return(i._RealDiv=i.asm.sa).apply(null,arguments)},i._Relu=function(){return(i._Relu=i.asm.ta).apply(null,arguments)},i._Relu6=function(){return(i._Relu6=i.asm.ua).apply(null,arguments)},i._ResizeBilinear=function(){return(i._ResizeBilinear=i.asm.va).apply(null,arguments)},i._Reverse=function(){return(i._Reverse=i.asm.wa).apply(null,arguments)},i._RotateWithOffset=function(){return(i._RotateWithOffset=i.asm.xa).apply(null,arguments)},i._Round=function(){return(i._Round=i.asm.ya).apply(null,arguments)},i._Rsqrt=function(){return(i._Rsqrt=i.asm.za).apply(null,arguments)},i._ScatterNd=function(){return(i._ScatterNd=i.asm.Aa).apply(null,arguments)},i._SelectV2=function(){return(i._SelectV2=i.asm.Ba).apply(null,arguments)},i._Sigmoid=function(){return(i._Sigmoid=i.asm.Ca).apply(null,arguments)},i._Sin=function(){return(i._Sin=i.asm.Da).apply(null,arguments)},i._Softmax=function(){return(i._Softmax=i.asm.Ea).apply(null,arguments)},i._SparseFillEmptyRows=function(){return(i._SparseFillEmptyRows=i.asm.Fa).apply(null,arguments)},i._SparseReshape=function(){return(i._SparseReshape=i.asm.Ga).apply(null,arguments)},i._SparseSegmentReduction=function(){return(i._SparseSegmentReduction=i.asm.Ha).apply(null,arguments)},i._Sqrt=function(){return(i._Sqrt=i.asm.Ia).apply(null,arguments)},i._Square=function(){return(i._Square=i.asm.Ja).apply(null,arguments)},i._SquaredDifference=function(){return(i._SquaredDifference=i.asm.Ka).apply(null,arguments)},i._Step=function(){return(i._Step=i.asm.La).apply(null,arguments)},i._StridedSlice=function(){return(i._StridedSlice=i.asm.Ma).apply(null,arguments)},i._Sub=function(){return(i._Sub=i.asm.Na).apply(null,arguments)},i._Sum=function(){return(i._Sum=i.asm.Oa).apply(null,arguments)},i._Tan=function(){return(i._Tan=i.asm.Pa).apply(null,arguments)},i._Tanh=function(){return(i._Tanh=i.asm.Qa).apply(null,arguments)},i._Tile=function(){return(i._Tile=i.asm.Ra).apply(null,arguments)},i._TopK=function(){return(i._TopK=i.asm.Sa).apply(null,arguments)},i._Transform=function(){return(i._Transform=i.asm.Ta).apply(null,arguments)},i._Transpose=function(){return(i._Transpose=i.asm.Ua).apply(null,arguments)},i.__FusedMatMul=function(){return(i.__FusedMatMul=i.asm.Va).apply(null,arguments)},i._malloc=function(){return(i._malloc=i.asm.Wa).apply(null,arguments)},i._free=function(){return(i._free=i.asm.Xa).apply(null,arguments)},i.___errno_location=function(){return(Te=i.___errno_location=i.asm.Ya).apply(null,arguments)}),Re=i.stackSave=function(){return(Re=i.stackSave=i.asm.Za).apply(null,arguments)},Ce=i.stackRestore=function(){return(Ce=i.stackRestore=i.asm._a).apply(null,arguments)},De=i.stackAlloc=function(){return(De=i.stackAlloc=i.asm.$a).apply(null,arguments)};function Pe(e){this.name="ExitStatus",this.message="Program terminated with exit("+e+")",this.status=e}function We(e){function n(){Ee||(Ee=!0,i.calledRun=!0,M||(K(),X(),t(i),i.onRuntimeInitialized&&i.onRuntimeInitialized(),Q()))}J>0||($(),J>0||(i.setStatus?(i.setStatus("Running..."),setTimeout((function(){setTimeout((function(){i.setStatus("")}),1),n()}),1)):n()))}if(i.cwrap=N,ee=function e(){Ee||We(),Ee||(ee=e)},i.run=We,i.preInit)for("function"==typeof i.preInit&&(i.preInit=[i.preInit]);i.preInit.length>0;)i.preInit.pop()();if(We(),u&&(xe={uncaughtException:process.listeners("uncaughtException").filter((function(e){return!u.uncaughtException.indexOf(e)>-1})),unhandledRejection:process.listeners("unhandledRejection").filter((function(e){return!u.unhandledRejection.indexOf(e)>-1}))}),"undefined"!=typeof e)Ne=e;else{if("undefined"==typeof WasmBackendModuleThreadedSimd)throw new Error("Could not find wasm module in post.js");Ne=WasmBackendModuleThreadedSimd}if(xe){var Le=Ne._dispose;Ne._dispose=function(){Le(),xe.uncaughtException.forEach((function(e){process.removeListener("uncaughtException",e)})),xe.unhandledRejection.forEach((function(e){process.removeListener("unhandledRejection",e)}))}}return e.ready});e.exports=s}));class wn extends t.KernelBackend{constructor(e){super(),this.wasm=e,this.dataIdNextNumber=1,this.wasm.tfjs.initWithThreadsCount(Fn),On=this.wasm.tfjs.getThreadsCount(),this.dataIdMap=new t.DataStorage(this,t.engine())}write(e,t,n){const a={id:this.dataIdNextNumber++};return this.move(a,e,t,n,1),a}numDataIds(){return this.dataIdMap.numDataIds()}async time(e){const n=t.util.now();e();return{kernelMs:t.util.now()-n}}move(e,n,a,r,s){const u=this.dataIdNextNumber++;if("string"===r){const t=n;return void this.dataIdMap.set(e,{id:u,stringBytes:t,shape:a,dtype:r,memoryOffset:null,refCount:s})}const i=t.util.sizeFromShape(a),o=i*t.util.bytesPerElement(r),d=this.wasm._malloc(o);this.dataIdMap.set(e,{id:u,memoryOffset:d,shape:a,dtype:r,refCount:s}),this.wasm.tfjs.registerTensor(u,i,d),null!=n&&this.wasm.HEAPU8.set(new Uint8Array(n.buffer,n.byteOffset,o),d)}async read(e){return this.readSync(e)}readSync(e,n,a){const{memoryOffset:r,dtype:s,shape:u,stringBytes:i}=this.dataIdMap.get(e);if("string"===s)return null!=n&&0!==n||!(null==a||a>=i.length)?i.slice(n,a):i;n=n||0,a=a||t.util.sizeFromShape(u);const o=t.util.bytesPerElement(s);return function(e,t){switch(t){case"float32":return new Float32Array(e);case"int32":return new Int32Array(e);case"bool":return new Uint8Array(e);default:throw new Error(`Unknown dtype ${t}`)}}(this.wasm.HEAPU8.slice(r+n*o,r+a*o).buffer,s)}disposeData(e,t=!1){if(this.dataIdMap.has(e)){const n=this.dataIdMap.get(e);if(n.refCount--,!t&&n.refCount>0)return!1;this.wasm._free(n.memoryOffset),this.wasm.tfjs.disposeData(n.id),this.dataIdMap.delete(e)}return!0}refCount(e){if(this.dataIdMap.has(e)){return this.dataIdMap.get(e).refCount}return 0}incRef(e){const t=this.dataIdMap.get(e);null!=t&&t.refCount++}floatPrecision(){return 32}getMemoryOffset(e){return this.dataIdMap.get(e).memoryOffset}dispose(){this.wasm.tfjs.dispose(),"PThread"in this.wasm&&this.wasm.PThread.terminateAllThreads(),this.wasm=null}memory(){return{unreliable:!1}}makeOutput(e,n,a){let r;if(null==a)r=this.write(null,e,n);else{const s=this.dataIdNextNumber++;r={id:s},this.dataIdMap.set(r,{id:s,memoryOffset:a,shape:e,dtype:n,refCount:1});const u=t.util.sizeFromShape(e);this.wasm.tfjs.registerTensor(s,u,a)}return{dataId:r,shape:e,dtype:n}}typedArrayFromHeap({shape:e,dtype:n,dataId:a}){const r=this.wasm.HEAPU8.buffer,{memoryOffset:s}=this.dataIdMap.get(a),u=t.util.sizeFromShape(e);switch(n){case"float32":return new Float32Array(r,s,u);case"int32":return new Int32Array(r,s,u);case"bool":return new Uint8Array(r,s,u);default:throw new Error(`Unknown dtype ${n}`)}}}function In(e,t,n){if(null!=Mn)return Mn;let a="tfjs-backend-wasm.wasm";return e&&t?a="tfjs-backend-wasm-threaded-simd.wasm":e&&(a="tfjs-backend-wasm-simd.wasm"),null!=En&&null!=En[a]?En[a]:n+a}async function Sn(){const[e,n]=await Promise.all([t.env().getAsync("WASM_HAS_SIMD_SUPPORT"),t.env().getAsync("WASM_HAS_MULTITHREAD_SUPPORT")]);return new Promise(((a,r)=>{const s={locateFile:(t,a)=>{if(t.endsWith(".worker.js")){const e=new Blob(['var Module={};function threadPrintErr(){var text=Array.prototype.slice.call(arguments).join(" ");console.error(text)}function threadAlert(){var text=Array.prototype.slice.call(arguments).join(" ");postMessage({cmd:"alert",text:text,threadId:Module["_pthread_self"]()})}var err=threadPrintErr;this.alert=threadAlert;Module["instantiateWasm"]=function(info,receiveInstance){var instance=new WebAssembly.Instance(Module["wasmModule"],info);Module["wasmModule"]=null;receiveInstance(instance);return instance.exports};function moduleLoaded(){}this.onmessage=function(e){try{if(e.data.cmd==="load"){Module["wasmModule"]=e.data.wasmModule;Module["wasmMemory"]=e.data.wasmMemory;Module["buffer"]=Module["wasmMemory"].buffer;Module["ENVIRONMENT_IS_PTHREAD"]=true;if(typeof e.data.urlOrBlob==="string"){importScripts(e.data.urlOrBlob)}else{var objectUrl=URL.createObjectURL(e.data.urlOrBlob);importScripts(objectUrl);URL.revokeObjectURL(objectUrl)}WasmBackendModuleThreadedSimd(Module).then(function(instance){Module=instance;moduleLoaded()})}else if(e.data.cmd==="objectTransfer"){Module["PThread"].receiveObjectTransfer(e.data)}else if(e.data.cmd==="run"){Module["__performance_now_clock_drift"]=performance.now()-e.data.time;Module["__emscripten_thread_init"](e.data.threadInfoStruct,0,0);var max=e.data.stackBase;var top=e.data.stackBase+e.data.stackSize;Module["establishStackSpace"](top,max);Module["_emscripten_tls_init"]();Module["PThread"].receiveObjectTransfer(e.data);Module["PThread"].setThreadStatus(Module["_pthread_self"](),1);try{var result=Module["invokeEntryPoint"](e.data.start_routine,e.data.arg);if(!Module["getNoExitRuntime"]())Module["PThread"].threadExit(result)}catch(ex){if(ex==="Canceled!"){Module["PThread"].threadCancel()}else if(ex!="unwind"){if(ex instanceof Module["ExitStatus"]){if(Module["getNoExitRuntime"]()){}else{Module["PThread"].threadExit(ex.status)}}else{Module["PThread"].threadExit(-2);throw ex}}}}else if(e.data.cmd==="cancel"){if(Module["_pthread_self"]()){Module["PThread"].threadCancel()}}else if(e.data.target==="setimmediate"){}else if(e.data.cmd==="processThreadQueue"){if(Module["_pthread_self"]()){Module["_emscripten_current_thread_process_queued_calls"]()}}else{err("worker.js received unknown command "+e.data.cmd);err(e.data)}}catch(ex){err("worker.js onmessage() captured an uncaught exception: "+ex);if(ex&&ex.stack)err(ex.stack);throw ex}};if(typeof process==="object"&&typeof process.versions==="object"&&typeof process.versions.node==="string"){self={location:{href:__filename}};var onmessage=this.onmessage;var nodeWorkerThreads=require("worker_threads");global.Worker=nodeWorkerThreads.Worker;var parentPort=nodeWorkerThreads.parentPort;parentPort.on("message",function(data){onmessage({data:data})});var nodeFS=require("fs");var nodeRead=function(filename){return nodeFS.readFileSync(filename,"utf8")};function globalEval(x){global.require=require;global.Module=Module;eval.call(null,x)}importScripts=function(f){globalEval(nodeRead(f))};postMessage=function(msg){parentPort.postMessage(msg)};if(typeof performance==="undefined"){performance={now:function(){return Date.now()}}}}'],{type:"application/javascript"});return URL.createObjectURL(e)}return t.endsWith(".wasm")?In(e,n,null!=An?An:a):a+t}};Nn&&(s.instantiateWasm=function(e){return(n,a)=>(t.util.fetch(e,{credentials:"same-origin"}).then((t=>{t.ok||n.env.a(`failed to load wasm binary file at '${e}'`),t.arrayBuffer().then((e=>{WebAssembly.instantiate(e,n).then((e=>{a(e.instance,e.module)}))}))})),{})}(In(e,n,null!=An?An:"")));let u,i=!1;s.onAbort=()=>{if(i)return;if(xn)return;xn=!0;r({message:"Make sure the server can serve the `.wasm` file relative to the bundled js file. For more details see https://github.com/tensorflow/tfjs/blob/master/tfjs-backend-wasm/README.md#using-bundlers"})},n&&e&&null==Mn?(s.mainScriptUrlOrBlob=new Blob(["var WasmBackendModuleThreadedSimd = "+_n.toString()],{type:"text/javascript"}),u=_n(s)):u=kn(s),u.then((e=>{i=!0,xn=!1;e.tfjs={init:e.cwrap("init",null,[]),initWithThreadsCount:e.cwrap("init_with_threads_count",null,["number"]),getThreadsCount:e.cwrap("get_threads_count","number",[]),registerTensor:e.cwrap("register_tensor",null,["number","number","number"]),disposeData:e.cwrap("dispose_data",null,["number"]),dispose:e.cwrap("dispose",null,[])},a({wasm:e})}))}))}const vn=["tfjs-backend-wasm.wasm","tfjs-backend-wasm-simd.wasm","tfjs-backend-wasm-threaded-simd.wasm"];let Mn=null,An=null,En={},xn=!1,Nn=!1;let Fn=-1,On=-1;t.registerBackend("wasm",(async()=>{const{wasm:e}=await Sn();return new wn(e)}),2),e.BackendWasm=wn,e.getThreadsCount=function(){if(-1===On)throw new Error("WASM backend not initialized.");return On},e.setThreadsCount=function(e){Fn=e},e.setWasmPath=function(e,n=!1){if(t.deprecationWarn("setWasmPath has been deprecated in favor of setWasmPaths and will be removed in a future release."),xn)throw new Error("The WASM backend was already initialized. Make sure you call `setWasmPath()` before you call `tf.setBackend()` or `tf.ready()`");Mn=e,Nn=n},e.setWasmPaths=function(e,t=!1){if(xn)throw new Error("The WASM backend was already initialized. Make sure you call `setWasmPaths()` before you call `tf.setBackend()` or `tf.ready()`");if("string"==typeof e)An=e;else{En=e;const t=vn.filter((e=>null==En[e]));if(t.length>0)throw new Error(`There were no entries found for the following binaries: ${t.join(",")}. Please either call setWasmPaths with a map providing a path for each binary, or with a string indicating the directory where all the binaries can be found.`)}Nn=t},e.version_wasm="3.13.0",Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-backend-wasm.es2017.min.js.map
