import { unstable_useId as useId } from '@mui/utils';
import { useTabsContext } from '../TabsUnstyled';
import { useCompoundItem } from '../utils/useCompoundItem';
function tabPanelValueGenerator(otherTabPanelValues) {
  return otherTabPanelValues.size;
}

/**
 *
 * Demos:
 *
 * - [Unstyled Tabs](https://mui.com/base/react-tabs/#hooks)
 *
 * API:
 *
 * - [useTabPanel API](https://mui.com/base/react-tabs/hooks-api/#use-tab-panel)
 */
function useTabPanel(parameters) {
  const {
    value: valueParam,
    id: idParam
  } = parameters;
  const context = useTabsContext();
  if (context === null) {
    throw new Error('No TabContext provided');
  }
  const {
    value: selectedTabValue,
    getTabId
  } = context;
  const id = useId(idParam);
  const {
    id: value
  } = useCompoundItem(valueParam, id, tabPanelValueGenerator);
  const hidden = value !== selectedTabValue;
  const correspondingTabId = value !== undefined ? getTabId(value) : undefined;
  const getRootProps = () => {
    return {
      'aria-labelledby': correspondingTabId != null ? correspondingTabId : undefined,
      hidden,
      id: id != null ? id : undefined
    };
  };
  return {
    hidden,
    getRootProps
  };
}
export default useTabPanel;