"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = selectReducer;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _useList = require("../useList");
var _useSelect = require("./useSelect.types");
function selectReducer(state, action) {
  const {
    open
  } = state;
  const {
    context: {
      selectionMode
    }
  } = action;
  switch (action.type) {
    case _useSelect.SelectActionTypes.buttonClick:
      {
        var _state$selectedValues;
        const itemToHighlight = (_state$selectedValues = state.selectedValues[0]) != null ? _state$selectedValues : (0, _useList.moveHighlight)(null, 'start', action.context);
        return (0, _extends2.default)({}, state, {
          open: !open,
          highlightedValue: !open ? itemToHighlight : null
        });
      }
    case _useSelect.SelectActionTypes.buttonArrowKeyDown:
      if (action.key === 'ArrowDown') {
        var _state$selectedValues2;
        const itemToHighlight = (_state$selectedValues2 = state.selectedValues[0]) != null ? _state$selectedValues2 : (0, _useList.moveHighlight)(null, 'start', action.context);
        return (0, _extends2.default)({}, state, {
          open: true,
          highlightedValue: itemToHighlight
        });
      }
      if (action.key === 'ArrowUp') {
        var _state$selectedValues3;
        const itemToHighlight = (_state$selectedValues3 = state.selectedValues[0]) != null ? _state$selectedValues3 : (0, _useList.moveHighlight)(null, 'end', action.context);
        return (0, _extends2.default)({}, state, {
          open: true,
          highlightedValue: itemToHighlight
        });
      }
      break;
    default:
      break;
  }
  const newState = (0, _useList.listReducer)(state, action);
  switch (action.type) {
    case _useList.ListActionTypes.keyDown:
      if (selectionMode === 'single' && (action.event.key === 'Enter' || action.event.key === ' ' || action.event.key === 'Escape')) {
        return (0, _extends2.default)({}, newState, {
          open: false
        });
      }
      break;
    case _useList.ListActionTypes.itemClick:
      if (selectionMode === 'single') {
        return (0, _extends2.default)({}, newState, {
          open: false
        });
      }
      break;
    case _useList.ListActionTypes.blur:
      return (0, _extends2.default)({}, newState, {
        open: false
      });
    default:
      return newState;
  }
  return newState;
}