export interface SelectUnstyledClasses {
    /** Class name applied to the root element. */
    root: string;
    /** Class name applied to the listbox element. */
    listbox: string;
    /** Class name applied to the popper element. */
    popper: string;
    /** State class applied to the root `button` element if `active={true}`. */
    active: string;
    /** State class applied to the root `button` element if `expanded={true}`. */
    expanded: string;
    /** State class applied to the root `button` element and the listbox 'ul' element if `disabled={true}`. */
    disabled: string;
    /** State class applied to the root `button` element if `focusVisible={true}`. */
    focusVisible: string;
}
export type SelectUnstyledClassKey = keyof SelectUnstyledClasses;
export declare function getSelectUnstyledUtilityClass(slot: string): string;
declare const selectUnstyledClasses: SelectUnstyledClasses;
export default selectUnstyledClasses;
