function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from 'react';
import { AppState } from 'react-native';
import { GiphyVideoManager } from './GiphyVideoManager';
import NativeGiphyVideoView from './specs/GiphyVideoViewNativeComponent';
const BACKGROUND_STATE_REGEX = /inactive|background/;
let mountedComponentsCount = 0;
let appStateListenerAdded = false;
let latestAppState = AppState.currentState;
function appStateListener(appState) {
  if (latestAppState === 'active' && appState.match(BACKGROUND_STATE_REGEX)) {
    GiphyVideoManager.pauseAll();
  } else if (appState === 'active' && latestAppState.match(BACKGROUND_STATE_REGEX)) {
    GiphyVideoManager.resume();
    GiphyVideoManager.muteAll();
  }
  latestAppState = appState;
}
function addAppStateListener() {
  latestAppState = AppState.currentState;
  AppState.addEventListener('change', appStateListener);
  appStateListenerAdded = true;
}
function removeAppStateListener() {
  AppState.addEventListener('change', appStateListener);
  appStateListenerAdded = false;
}
function registerComponent() {
  mountedComponentsCount += 1;
  if (!appStateListenerAdded) {
    addAppStateListener();
  }
}
function unregisterComponent() {
  mountedComponentsCount = Math.max(0, mountedComponentsCount - 1);
  if (mountedComponentsCount === 0 && appStateListenerAdded) {
    removeAppStateListener();
  }
}
export class GiphyVideoView extends React.Component {
  componentDidMount() {
    registerComponent();
  }
  componentWillUnmount() {
    unregisterComponent();
  }
  render() {
    const {
      autoPlay = false,
      media,
      muted = false,
      ...other
    } = this.props;
    return /*#__PURE__*/React.createElement(NativeGiphyVideoView, _extends({
      autoPlay: autoPlay,
      mediaId: media?.id,
      muted: muted
    }, other));
  }
}
//# sourceMappingURL=GiphyVideoView.js.map