function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from 'react';
import NativeGiphyMediaView, { Commands } from './specs/GiphyMediaViewNativeComponent';
export class GiphyMediaView extends React.Component {
  ref = /*#__PURE__*/React.createRef();
  pause = () => {
    if (this.ref.current) {
      Commands.pause(this.ref.current);
    }
  };
  resume = () => {
    if (this.ref.current) {
      Commands.resume(this.ref.current);
    }
  };
  render() {
    const {
      autoPlay = true,
      renditionType = 'fixed_width',
      media,
      showCheckeredBackground = false,
      resizeMode = 'cover',
      ...other
    } = this.props;
    return /*#__PURE__*/React.createElement(NativeGiphyMediaView, _extends({
      ref: this.ref,
      autoPlay: autoPlay,
      mediaId: media?.id,
      renditionType: renditionType,
      resizeMode: resizeMode,
      showCheckeredBackground: showCheckeredBackground
    }, other));
  }
}
//# sourceMappingURL=GiphyMediaView.js.map