import { GiphyMediaType } from './dto/giphyMediaType';
import { GiphyContentRequestType } from './dto/giphyContentRequest';
function makeGiphyContentRequest(options) {
  return {
    searchQuery: '',
    mediaType: GiphyMediaType.Gif,
    ...options
  };
}
export class GiphyContent {
  static search(options) {
    return makeGiphyContentRequest({
      ...options,
      requestType: GiphyContentRequestType.Search
    });
  }
  static trending(options) {
    return makeGiphyContentRequest({
      ...options,
      requestType: GiphyContentRequestType.Trending
    });
  }
  static trendingGifs(options) {
    return makeGiphyContentRequest({
      ...options,
      mediaType: GiphyMediaType.Gif,
      requestType: GiphyContentRequestType.Trending
    });
  }
  static trendingStickers(options) {
    return makeGiphyContentRequest({
      ...options,
      mediaType: GiphyMediaType.Sticker,
      requestType: GiphyContentRequestType.Trending
    });
  }
  static trendingText(options) {
    return makeGiphyContentRequest({
      ...options,
      mediaType: GiphyMediaType.Text,
      requestType: GiphyContentRequestType.Trending
    });
  }
  static recents(options) {
    return makeGiphyContentRequest({
      ...options,
      mediaType: GiphyMediaType.Gif,
      requestType: GiphyContentRequestType.Recents
    });
  }
  static emoji(options) {
    return makeGiphyContentRequest({
      ...options,
      mediaType: GiphyMediaType.Sticker,
      requestType: GiphyContentRequestType.Emoji
    });
  }
  static animate(options) {
    return makeGiphyContentRequest({
      ...options,
      requestType: GiphyContentRequestType.Animate
    });
  }
}
//# sourceMappingURL=GiphyContent.js.map