"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializeTheme = serializeTheme;
var _reactNative = require("react-native");
const THEME_COLOR_FIELDS = ['avatarPlaceholderColor', 'backgroundColor', 'backgroundColorForLoadingCells', 'confirmationBackButtonColor', 'confirmationSelectButtonColor', 'confirmationSelectButtonTextColor', 'confirmationViewOnGiphyColor', 'defaultTextColor', 'dialogOverlayBackgroundColor', 'emojiDrawerGradientBottomColor', 'emojiDrawerGradientTopColor', 'emojiDrawerSeparatorColor', 'handleBarColor', 'retryButtonBackgroundColor', 'retryButtonTextColor', 'searchBackButtonColor', 'searchBarBackgroundColor', 'searchPlaceholderTextColor', 'searchTextColor', 'stickerBackgroundColor', 'suggestionCellBackgroundColor', 'suggestionCellTextColor', 'tabBarSwitchDefaultColor', 'tabBarSwitchSelectedColor', 'usernameColor'];
function serializeTheme(theme) {
  if (typeof theme === 'string') {
    return {
      preset: theme
    };
  }
  const rv = {
    ...theme
  };
  THEME_COLOR_FIELDS.forEach(colorField => {
    if (colorField in rv) {
      rv[colorField] = (0, _reactNative.processColor)(theme[colorField]);
    }
  });
  return rv;
}
//# sourceMappingURL=giphyTheme.js.map