"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GiphyMediaView = void 0;
var _react = _interopRequireDefault(require("react"));
var _GiphyMediaViewNativeComponent = _interopRequireWildcard(require("./specs/GiphyMediaViewNativeComponent"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
class GiphyMediaView extends _react.default.Component {
  ref = /*#__PURE__*/_react.default.createRef();
  pause = () => {
    if (this.ref.current) {
      _GiphyMediaViewNativeComponent.Commands.pause(this.ref.current);
    }
  };
  resume = () => {
    if (this.ref.current) {
      _GiphyMediaViewNativeComponent.Commands.resume(this.ref.current);
    }
  };
  render() {
    const {
      autoPlay = true,
      renditionType = 'fixed_width',
      media,
      showCheckeredBackground = false,
      resizeMode = 'cover',
      ...other
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_GiphyMediaViewNativeComponent.default, _extends({
      ref: this.ref,
      autoPlay: autoPlay,
      mediaId: media?.id,
      renditionType: renditionType,
      resizeMode: resizeMode,
      showCheckeredBackground: showCheckeredBackground
    }, other));
  }
}
exports.GiphyMediaView = GiphyMediaView;
//# sourceMappingURL=GiphyMediaView.js.map