"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GiphyGridView = void 0;
var _react = _interopRequireDefault(require("react"));
var _giphyMedia = require("./dto/giphyMedia");
var _giphyTheme = require("./dto/giphyTheme");
var _GiphyGridViewNativeComponent = _interopRequireDefault(require("./specs/GiphyGridViewNativeComponent"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
class GiphyGridView extends _react.default.Component {
  mediaSelectHandler = e => {
    const {
      onMediaSelect
    } = this.props;
    if (!onMediaSelect) {
      return;
    }
    const media = JSON.parse(e.nativeEvent.media ?? '{}') || {};
    e.nativeEvent.media = (0, _giphyMedia.deserializeGiphyMedia)(media);
    return onMediaSelect(e);
  };
  render() {
    const {
      cellPadding = 0,
      clipsPreviewRenditionType = 'fixed_width',
      content,
      disableEmojiVariations = false,
      fixedSizeCells = false,
      onMediaSelect,
      orientation = 'vertical',
      renditionType = 'fixed_width',
      showCheckeredBackground = false,
      theme = 'light',
      ...other
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_GiphyGridViewNativeComponent.default, _extends({
      cellPadding: cellPadding,
      clipsPreviewRenditionType: clipsPreviewRenditionType,
      content: content ? JSON.stringify(content) : '',
      disableEmojiVariations: disableEmojiVariations,
      fixedSizeCells: fixedSizeCells,
      onMediaSelect: onMediaSelect ? this.mediaSelectHandler : undefined,
      orientation: orientation,
      renditionType: renditionType,
      showCheckeredBackground: showCheckeredBackground,
      theme: JSON.stringify((0, _giphyTheme.serializeTheme)(theme))
    }, other));
  }
}
exports.GiphyGridView = GiphyGridView;
//# sourceMappingURL=GiphyGridView.js.map