<p align="center">
<img width="750" height="150" src="https://github.com/Giphy/giphy-react-native-sdk/blob/main/docs/assets/sdk_logo.gif">
</p>

<img align="right" width="300" height="483" src="https://github.com/Giphy/giphy-react-native-sdk/blob/main/docs/assets/example_app.gif">

# GIPHY SDK for React Native

The fastest and easiest way to bring the full GIPHY experience directly to your app is with the GIPHY SDK. Built with
developers and product designers in mind, GIPHY SDK is a top-to-bottom solution for all things GIF in your app.

With support for the React Native developer ecosystem, this project enables you to easily integrate our battle-tested native [iOS](https://github.com/Giphy/giphy-ios-sdk) and [Android](https://github.com/Giphy/giphy-ios-sdk) SDKs, which handle everything from interfacing with the GIPHY API, fetching and caching assets, and displaying GIFs and Stickers on screen in customizable UI templates.
 
With billions of requests a day, it’s safe to say GIPHY knows GIFs. We're excited to share our best-in-class tools with
you so your users can have the best GIF experience possible, with all the same features they're already enjoying on
Facebook, Slack, Instagram, and more – with just a few lines of code.
 
### [Getting Started](docs/getting-started.md)

- [Requirements](docs/getting-started.md#requirements)
- [Installation](docs/getting-started.md#installation)
- [Troubleshooting](docs/getting-started.md#troubleshooting)
- [Basic Usage](docs/getting-started.md#basic-usage)
- [GIPHY Clips: GIFs with Sound](docs/clips.md)
- [GIPHY Animated Text Creation](docs/animated.md)
- [Example App](https://github.com/Giphy/giphy-react-native-sdk/tree/main/example)
- [How to mock the Giphy dependency in Jest](docs/testing-jest.md)
- [How to localize the Giphy SDK](docs/localization.md)

### [API Reference](docs/api.md)

- [GiphySDK](docs/api.md#giphysdk)
- [GiphyDialog](docs/api.md#giphydialog)
- [GiphyMediaView](docs/api.md#giphymediaview)
- [GiphyVideoView](docs/api.md#giphyvideoview)
- [GiphyVideoManager](docs/api.md#giphyvideomanager)
- [GiphyGridView](docs/api.md#giphygridview)
- [GiphyContent](docs/api.md#giphycontent)
- [GiphyTheme](docs/api.md#giphytheme)

### Guides

- [Migrating to GIPHY React Native SDK 2](docs/migrating-to-giphy-react-native-sdk-2.md)
