var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
import { keyframes } from '@emotion/react';
import styled from '@emotion/styled';
import { giphyCharcoal, giphyDarkCharcoal, giphyWhite, giphyWhiteSmoke } from '@giphy/js-brand';
import React, { useContext } from 'react';
import Avatar_ from '../attribution/avatar';
import VerifiedBadge from '../attribution/verified-badge';
import { SearchContext } from './context';
var channelMargin = 6;
var channelSearchHeight = function (theme) { return theme.searchbarHeight - channelMargin * 2; };
var smallChannelSearchHeight = function (theme) { return theme.smallSearchbarHeight - 3 * 2; };
var animateAvatar = function (h) { return keyframes(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\nto {\n    width: ", "px;\n}\n"], ["\nto {\n    width: ", "px;\n}\n"])), h); };
var Avatar = styled(Avatar_)(templateObject_2 || (templateObject_2 = __makeTemplateObject(["\n    height: ", "px;\n    margin: 0;\n    width: 0;\n    animation: ", " 100ms ease-in-out forwards;\n    @media (", ") {\n        height: ", "px;\n        animation: ", " 100ms ease-in-out forwards;\n    }\n"], ["\n    height: ", "px;\n    margin: 0;\n    width: 0;\n    animation: ", " 100ms ease-in-out forwards;\n    @media (", ") {\n        height: ", "px;\n        animation: ", " 100ms ease-in-out forwards;\n    }\n"])), function (props) { return channelSearchHeight(props.theme); }, function (props) { return animateAvatar(channelSearchHeight(props.theme)); }, function (props) { return props.theme.condensedMediaQuery; }, function (props) { return smallChannelSearchHeight(props.theme); }, function (props) { return animateAvatar(smallChannelSearchHeight(props.theme)); });
var Username = styled.div(templateObject_3 || (templateObject_3 = __makeTemplateObject(["\n    background: ", ";\n    display: flex;\n    align-items: center;\n    padding-left: ", "px;\n"], ["\n    background: ", ";\n    display: flex;\n    align-items: center;\n    padding-left: ", "px;\n"])), function (props) { return (props.theme.mode === 'dark' ? giphyCharcoal : giphyWhite); }, channelMargin);
var UsernamePill = styled.div(templateObject_4 || (templateObject_4 = __makeTemplateObject(["\n    background: ", ";\n    display: flex;\n    padding: 0 4px;\n    color: ", ";\n    font-family: interface, Helvetica Neue, helvetica, sans-serif;\n    font-weight: 600;\n    font-size: 12px;\n    align-items: center;\n    height: ", "px;\n    @media (", ") {\n        display: none;\n    }\n"], ["\n    background: ", ";\n    display: flex;\n    padding: 0 4px;\n    color: ", ";\n    font-family: interface, Helvetica Neue, helvetica, sans-serif;\n    font-weight: 600;\n    font-size: 12px;\n    align-items: center;\n    height: ", "px;\n    @media (", ") {\n        display: none;\n    }\n"])), giphyWhiteSmoke, giphyDarkCharcoal, function (props) { return channelSearchHeight(props.theme); }, function (props) { return props.theme.condensedMediaQuery; });
var SearchBarChannel = function (_a) {
    var _b = _a.className, className = _b === void 0 ? '' : _b;
    var activeChannel = useContext(SearchContext).activeChannel;
    return activeChannel ? (React.createElement(Username, { className: className },
        React.createElement(Avatar, { user: activeChannel.user }),
        React.createElement(UsernamePill, { key: activeChannel.id },
            React.createElement("div", null,
                "@",
                activeChannel.user.username),
            activeChannel.user.is_verified && React.createElement(VerifiedBadge, { size: 14 })))) : null;
};
export default SearchBarChannel;
var templateObject_1, templateObject_2, templateObject_3, templateObject_4;
//# sourceMappingURL=search-bar-channel.js.map