import { GifsResult, SearchOptions } from '@giphy/js-fetch-api';
import { IChannel } from '@giphy/js-types';
import React, { ReactNode } from 'react';
import { SearchTheme } from './theme';
export type SearchContextProps = {
    setSearch: (searchTerm: string) => void;
    term: string;
    activeChannel: IChannel | undefined;
    setChannels: (channels: IChannel[]) => void;
    currentChannels: IChannel[];
    setActiveChannel: (channel: IChannel | undefined) => void;
    fetchGifs: (offset: number) => Promise<GifsResult>;
    fetchAnimatedText: (offset: number) => Promise<GifsResult>;
    fetchChannelSearch: (offset: number) => Promise<IChannel[]>;
    isFetching: boolean;
    trendingSearches: string[];
    searchKey: string;
    isFocused: boolean;
};
export type _SearchContextProps = {
    setIsFocused: (focused: boolean) => void;
    _setSearch: (searchTerm: string) => void;
    _inputValOverride: string;
};
export declare const SearchContext: React.Context<SearchContextProps>;
export declare const _SearchContext: React.Context<_SearchContextProps>;
type Props = {
    children: ReactNode;
    options?: SearchOptions;
    apiKey: string;
    theme?: Partial<SearchTheme>;
    initialTerm?: string;
    initialChannel?: IChannel;
    shouldDefaultToTrending?: boolean;
    shouldFetchChannels?: boolean;
};
declare const SearchContextManager: ({ children, options, apiKey, theme, initialTerm, initialChannel, shouldDefaultToTrending, shouldFetchChannels, }: Props) => React.JSX.Element;
export default SearchContextManager;
