import React, { memo } from 'react';
function fillArray(length, columnOffsets) {
    if (columnOffsets === void 0) { columnOffsets = []; }
    return Array.apply(null, Array(length)).map(function (_, index) { return columnOffsets[index] || 0; });
}
var MasonryGrid = function (_a) {
    var columns = _a.columns, gutter = _a.gutter, _b = _a.useTransform, useTransform = _b === void 0 ? true : _b, itemWidth = _a.itemWidth, itemHeights = _a.itemHeights, children = _a.children, _c = _a.columnOffsets, columnOffsets = _c === void 0 ? [] : _c;
    var containerStyle = {};
    function getChildren() {
        var columnTarget;
        var columnHeights = fillArray(columns, columnOffsets);
        var result = React.Children.map(children, function (child, index) {
            var style = {
                position: 'absolute',
            };
            columnTarget = columnHeights.indexOf(Math.min.apply(Math, columnHeights));
            var top = "".concat(columnHeights[columnTarget], "px");
            var left = "".concat(columnTarget * itemWidth + columnTarget * gutter, "px");
            if (useTransform) {
                style.transform = "translate3d(".concat(left, ", ").concat(top, ", 0)");
            }
            else {
                // support positioned elements (default) or transformed elements
                style.top = top;
                style.left = left;
            }
            var height = itemHeights[index];
            if (height) {
                columnHeights[columnTarget] += height + gutter;
            }
            return React.cloneElement(child, { style: style });
        });
        containerStyle.position = 'relative';
        containerStyle.width = "".concat(columns * itemWidth + (columns - 1) * gutter, "px");
        containerStyle.height = "".concat(Math.max.apply(Math, columnHeights) - gutter, "px");
        return result;
    }
    return React.createElement("div", { style: containerStyle }, getChildren());
};
export default memo(MasonryGrid);
//# sourceMappingURL=masonry-grid.js.map