"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.onGifHover = exports.onGifClick = exports.onGifSeen = void 0;
var js_analytics_1 = require("@giphy/js-analytics");
var js_util_1 = require("@giphy/js-util");
var firePingback = function (actionType) { return function (gif, userId, target, attributes) {
    if (attributes === void 0) { attributes = {}; }
    if (!gif.analytics_response_payload) {
        return;
    }
    (0, js_analytics_1.pingback)({
        analyticsResponsePayload: gif.analytics_response_payload,
        userId: userId,
        actionType: actionType,
        attributes: __assign({ position: JSON.stringify((0, js_util_1.getClientRect)(target)) }, attributes),
    });
}; };
// no target on this one
var onGifSeen = function (gif, userId, position, attributes) {
    if (attributes === void 0) { attributes = {}; }
    if (!gif.analytics_response_payload) {
        return;
    }
    (0, js_analytics_1.pingback)({
        analyticsResponsePayload: gif.analytics_response_payload,
        userId: userId,
        actionType: 'SEEN',
        attributes: __assign({ position: JSON.stringify(position) }, attributes),
    });
};
exports.onGifSeen = onGifSeen;
exports.onGifClick = firePingback('CLICK');
exports.onGifHover = firePingback('HOVER');
//# sourceMappingURL=pingback.js.map