"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
function fillArray(length, columnOffsets) {
    if (columnOffsets === void 0) { columnOffsets = []; }
    return Array.apply(null, Array(length)).map(function (_, index) { return columnOffsets[index] || 0; });
}
var MasonryGrid = function (_a) {
    var columns = _a.columns, gutter = _a.gutter, _b = _a.useTransform, useTransform = _b === void 0 ? true : _b, itemWidth = _a.itemWidth, itemHeights = _a.itemHeights, children = _a.children, _c = _a.columnOffsets, columnOffsets = _c === void 0 ? [] : _c;
    var containerStyle = {};
    function getChildren() {
        var columnTarget;
        var columnHeights = fillArray(columns, columnOffsets);
        var result = react_1.default.Children.map(children, function (child, index) {
            var style = {
                position: 'absolute',
            };
            columnTarget = columnHeights.indexOf(Math.min.apply(Math, columnHeights));
            var top = "".concat(columnHeights[columnTarget], "px");
            var left = "".concat(columnTarget * itemWidth + columnTarget * gutter, "px");
            if (useTransform) {
                style.transform = "translate3d(".concat(left, ", ").concat(top, ", 0)");
            }
            else {
                // support positioned elements (default) or transformed elements
                style.top = top;
                style.left = left;
            }
            var height = itemHeights[index];
            if (height) {
                columnHeights[columnTarget] += height + gutter;
            }
            return react_1.default.cloneElement(child, { style: style });
        });
        containerStyle.position = 'relative';
        containerStyle.width = "".concat(columns * itemWidth + (columns - 1) * gutter, "px");
        containerStyle.height = "".concat(Math.max.apply(Math, columnHeights) - gutter, "px");
        return result;
    }
    return react_1.default.createElement("div", { style: containerStyle }, getChildren());
};
exports.default = (0, react_1.memo)(MasonryGrid);
//# sourceMappingURL=masonry-grid.js.map