import { IRendition, IGif, IImage, IImages } from '@giphy/js-types';

declare const setRenditionScaleUpMaxPixels: (pixels: number) => void;
/**
 * Finds image rendition that best fits a given container preferring images
 * ##### Note: all renditions are assumed to have the same aspect ratio
 *
 * When we have a portrait target and landscape gif, we choose a higher rendition to match
 * the height of the portrait target, otherwise it's blurry (same applies for landscape to portrait)
 *
 * @name bestfit
 * @function
 * @param {Array.<Object>} renditions available image renditions each having a width and height property
 * @param {Number} width
 * @param {Number} height
 * @param {Number} scaleUpMaxPixels the maximum pixels an asset should be scaled up
 */
declare function bestfit(renditions: Array<IRendition>, width: number, height: number, scaleUpMaxPixels?: number): IRendition;

declare function mapValues(object: any, mapFn: (val: any, key: string) => any): any;
declare function forEach(object: any, mapFn: (val: any, key: any) => void): void;
declare function take<T>(arr: T[], count?: number): T[];
declare function without<T>(arr: T[], values: T[]): T[];
declare function pick<T extends object, U extends keyof T>(object: T, pick: Array<U>): Pick<T, U>;

/**
 * @param el HTMLElement
 * @returns calculated properties of DOMReact
 */
declare const getClientRect: (el: HTMLElement) => DOMRectReadOnly;

declare const noUUIDRandom: () => string;
declare const getPingbackId: () => string;

declare const getSpecificRendition: ({ images, is_sticker: isSticker }: IGif, renditionLabel: string, isStill?: boolean, useVideo?: boolean) => string;
interface IRenditionWithName extends IRendition {
    renditionName: keyof IImages;
}
declare const getBestVideo: (video: IGif['video'], width: number, height: number) => IImage | undefined;
declare const getBestRendition: (images: IImages, gifWidth: number, gifHeight: number, scaleUpMaxPixels?: number) => IRenditionWithName;
type Options = {
    isStill?: boolean;
    useVideo?: boolean;
    scaleUpMaxPixels?: number;
};
declare const getBestRenditionUrl: ({ images, video, type }: IGif, gifWidth: number, gifHeight: number, options?: Options) => keyof IImages | '';
declare const getGifHeight: ({ images }: IGif, gifWidth: number) => number;
declare const getGifWidth: ({ images }: IGif, gifHeight: number) => number;
/**
 * GIF Text - Alt Text: Generates alt text for
 * GIF images based on username and tags.
 * @prop  {Gif}
 * @return {String} GIF alt text.
 */
declare const getAltText: ({ alt_text, user, tags, is_sticker, title }: IGif) => string;

declare enum LogLevel {
    DEBUG = 0,
    INFO = 1,
    WARN = 2,
    ERROR = 3
}
declare const Logger: {
    ENABLED: boolean;
    LEVEL: number;
    PREFIX: string;
    debug: (...msg: any) => void;
    info: (...msg: any) => void;
    warn: (...msg: any) => void;
    error: (...msg: any) => void;
};

type GiphySDKRequestHeader = 'X-GIPHY-SDK-NAME' | 'X-GIPHY-SDK-VERSION' | 'X-GIPHY-SDK-PLATFORM';
declare const getGiphySDKRequestHeaders: () => Headers | undefined;
declare const appendGiphySDKRequestHeader: (key: GiphySDKRequestHeader, value: string) => void | undefined;
declare const appendGiphySDKRequestParam: (key: GiphySDKRequestHeader, value: string) => void | undefined;

declare const checkIfWebP: Promise<unknown>;

export { LogLevel, Logger, appendGiphySDKRequestHeader, appendGiphySDKRequestParam, bestfit, checkIfWebP, forEach, getAltText, getBestRendition, getBestRenditionUrl, getBestVideo, getClientRect, getGifHeight, getGifWidth, getGiphySDKRequestHeaders, getPingbackId, getSpecificRendition, mapValues, noUUIDRandom, pick, setRenditionScaleUpMaxPixels, take, without };
