"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeGifs = exports.normalizeGif = exports.USER_BOOL_PROPS = exports.BOOL_PROPS = void 0;
/**
 * @hidden
 */
exports.BOOL_PROPS = [
    'is_anonymous',
    'is_community',
    'is_featured',
    'is_hidden',
    'is_indexable',
    'is_preserve_size',
    'is_realtime',
    'is_removed',
    'is_sticker',
    'is_dynamic', // not finalized, and not adding to Gif type until type RFC is finished
];
/**
 * @hidden
 */
exports.USER_BOOL_PROPS = ['suppress_chrome', 'is_public', 'is_verified'];
var makeBool = function (obj) { return function (prop) { return (obj[prop] = !!obj[prop]); }; };
// tags sometimes are objects that have a text prop, sometimes they're strings
var getTag = function (tag) { return (typeof tag === 'string' ? tag : tag.text); };
var normalize = function (gif) {
    var newGif = __assign({}, gif);
    newGif.id = String(newGif.id);
    newGif.tags = (newGif.tags || []).map(getTag);
    exports.BOOL_PROPS.forEach(makeBool(newGif));
    Object.keys(newGif.images || {}).forEach(function (name) {
        var img = newGif.images[name];
        img.width = parseInt(img.width);
        img.height = parseInt(img.height);
    });
    var user = newGif.user;
    if (user) {
        var newUser = __assign({}, user);
        exports.USER_BOOL_PROPS.forEach(makeBool(newUser));
        newGif.user = newUser;
    }
    return newGif;
};
/**
 * @hidden
 */
var normalizeGif = function (result) {
    result.data = normalize(result.data);
    return result;
};
exports.normalizeGif = normalizeGif;
/**
 * @hidden
 */
var normalizeGifs = function (result) {
    result.data = result.data.map(function (gif) { return normalize(gif); });
    return result;
};
exports.normalizeGifs = normalizeGifs;
//# sourceMappingURL=gif.js.map