Object.defineProperty(exports, "__esModule", { value: true });
exports.isValidProperties = void 0;
var tslib_1 = require("tslib");
var logger_1 = require("./logger");
var MAX_PROPERTY_KEYS = 1000;
var _isValidObject = function (properties) {
    if (Object.keys(properties).length > MAX_PROPERTY_KEYS) {
        logger_1.logger.warn('too many properties. Skipping operation');
        return false;
    }
    for (var key in properties) {
        if (typeof key !== 'string') {
            logger_1.logger.warn('invalid properties format. Skipping operation');
            return false;
        }
        var value = properties[key];
        if (!isValidProperties(key, value))
            return false;
    }
    return true;
};
var isValidProperties = function (property, value) {
    var e_1, _a;
    if (typeof property !== 'string')
        return false;
    if (Array.isArray(value)) {
        try {
            for (var value_1 = tslib_1.__values(value), value_1_1 = value_1.next(); !value_1_1.done; value_1_1 = value_1.next()) {
                var valueElement = value_1_1.value;
                if (Array.isArray(valueElement)) {
                    logger_1.logger.warn('invalid array element type ', typeof valueElement);
                    return false;
                }
                else if (typeof valueElement === 'object') {
                    return _isValidObject(value);
                }
                else if (!(typeof valueElement === 'number' || typeof valueElement === 'string' || typeof valueElement === 'boolean')) {
                    logger_1.logger.warn('invalid array element type ', typeof valueElement);
                    return false;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (value_1_1 && !value_1_1.done && (_a = value_1.return)) _a.call(value_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    else if (typeof value === 'object') {
        return _isValidObject(value);
    }
    else if (!(typeof value === 'number' || typeof value === 'string' || typeof value === 'boolean')) {
        logger_1.logger.warn('invalid value type ', typeof value);
        return false;
    }
    return true;
};
exports.isValidProperties = isValidProperties;
//# sourceMappingURL=validateProperties.js.map