"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CookieStorage = void 0;
var tslib_1 = require("tslib");
var global_scope_1 = require("../global-scope");
var CookieStorage = /** @class */ (function () {
    function CookieStorage(options) {
        this.options = tslib_1.__assign({}, options);
    }
    CookieStorage.prototype.isEnabled = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var testStorage, testKey, value, _a;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        /* istanbul ignore if */
                        if (!(0, global_scope_1.getGlobalScope)()) {
                            return [2 /*return*/, false];
                        }
                        CookieStorage.testValue = String(Date.now());
                        testStorage = new CookieStorage(this.options);
                        testKey = 'AMP_TEST';
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 4, 5, 7]);
                        return [4 /*yield*/, testStorage.set(testKey, CookieStorage.testValue)];
                    case 2:
                        _b.sent();
                        return [4 /*yield*/, testStorage.get(testKey)];
                    case 3:
                        value = _b.sent();
                        return [2 /*return*/, value === CookieStorage.testValue];
                    case 4:
                        _a = _b.sent();
                        /* istanbul ignore next */
                        return [2 /*return*/, false];
                    case 5: return [4 /*yield*/, testStorage.remove(testKey)];
                    case 6:
                        _b.sent();
                        return [7 /*endfinally*/];
                    case 7: return [2 /*return*/];
                }
            });
        });
    };
    CookieStorage.prototype.get = function (key) {
        var _a;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var value, decodedValue;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, this.getRaw(key)];
                    case 1:
                        value = _b.sent();
                        if (!value) {
                            return [2 /*return*/, undefined];
                        }
                        try {
                            decodedValue = (_a = decodeCookiesAsDefault(value)) !== null && _a !== void 0 ? _a : decodeCookiesWithDoubleUrlEncoding(value);
                            if (decodedValue === undefined) {
                                console.error("Amplitude Logger [Error]: Failed to decode cookie value for key: ".concat(key, ", value: ").concat(value));
                                return [2 /*return*/, undefined];
                            }
                            // eslint-disable-next-line @typescript-eslint/no-unsafe-return
                            return [2 /*return*/, JSON.parse(decodedValue)];
                        }
                        catch (_c) {
                            console.error("Amplitude Logger [Error]: Failed to parse cookie value for key: ".concat(key, ", value: ").concat(value));
                            return [2 /*return*/, undefined];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    CookieStorage.prototype.getRaw = function (key) {
        var _a, _b;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var globalScope, cookie, match;
            return tslib_1.__generator(this, function (_c) {
                globalScope = (0, global_scope_1.getGlobalScope)();
                cookie = (_b = (_a = globalScope === null || globalScope === void 0 ? void 0 : globalScope.document) === null || _a === void 0 ? void 0 : _a.cookie.split('; ')) !== null && _b !== void 0 ? _b : [];
                match = cookie.find(function (c) { return c.indexOf(key + '=') === 0; });
                if (!match) {
                    return [2 /*return*/, undefined];
                }
                return [2 /*return*/, match.substring(key.length + 1)];
            });
        });
    };
    CookieStorage.prototype.set = function (key, value) {
        var _a;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var expirationDays, expires, expireDate, date, str, globalScope, errorMessage;
            return tslib_1.__generator(this, function (_b) {
                try {
                    expirationDays = (_a = this.options.expirationDays) !== null && _a !== void 0 ? _a : 0;
                    expires = value !== null ? expirationDays : -1;
                    expireDate = undefined;
                    if (expires) {
                        date = new Date();
                        date.setTime(date.getTime() + expires * 24 * 60 * 60 * 1000);
                        expireDate = date;
                    }
                    str = "".concat(key, "=").concat(btoa(encodeURIComponent(JSON.stringify(value))));
                    if (expireDate) {
                        str += "; expires=".concat(expireDate.toUTCString());
                    }
                    str += '; path=/';
                    if (this.options.domain) {
                        str += "; domain=".concat(this.options.domain);
                    }
                    if (this.options.secure) {
                        str += '; Secure';
                    }
                    if (this.options.sameSite) {
                        str += "; SameSite=".concat(this.options.sameSite);
                    }
                    globalScope = (0, global_scope_1.getGlobalScope)();
                    if (globalScope) {
                        globalScope.document.cookie = str;
                    }
                }
                catch (error) {
                    errorMessage = error instanceof Error ? error.message : String(error);
                    console.error("Amplitude Logger [Error]: Failed to set cookie for key: ".concat(key, ". Error: ").concat(errorMessage));
                }
                return [2 /*return*/];
            });
        });
    };
    CookieStorage.prototype.remove = function (key) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.set(key, null)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    CookieStorage.prototype.reset = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/];
            });
        });
    };
    return CookieStorage;
}());
exports.CookieStorage = CookieStorage;
var decodeCookiesAsDefault = function (value) {
    try {
        return decodeURIComponent(atob(value));
    }
    catch (_a) {
        return undefined;
    }
};
var decodeCookiesWithDoubleUrlEncoding = function (value) {
    // Modern Ruby (v7+) automatically encodes cookies with URL encoding by
    // https://api.rubyonrails.org/classes/ActionDispatch/Cookies.html
    try {
        return decodeURIComponent(atob(decodeURIComponent(value)));
    }
    catch (_a) {
        return undefined;
    }
};
//# sourceMappingURL=cookie.js.map