type BlobSafe = {
    size: number;
};
type ArrayBufferSafe = {
    byteLength: number;
};
type ArrayBufferViewSafe = {
    byteLength: number;
};
type URLSearchParamsSafe = {
    toString(): string;
};
type FormDataEntryValueSafe = string | BlobSafe | null;
type BodyInitSafe = string | Blob | ArrayBufferSafe | FormDataSafe | URLSearchParamsSafe | ArrayBufferViewSafe | null | undefined;
type HeadersRequestSafe = {
    entries(): IterableIterator<[string, string]>;
    forEach(callbackfn: (value: string, key: string) => void): void;
};
type HeadersResponseSafe = {
    get(name: string): string | null;
    forEach(callbackfn: (value: string, key: string) => void): void;
};
type HeadersInitSafe = HeadersRequestSafe | Record<string, string> | string[][];
type ResponseSafe = {
    status: number;
    headers: HeadersResponseSafe | undefined;
};
export type RequestInitSafe = {
    method?: string;
    headers?: HeadersInitSafe;
    body?: BodyInitSafe;
};
export interface FormDataSafe {
    entries(): IterableIterator<[string, FormDataEntryValueSafe]>;
}
export type XMLHttpRequestBodyInitSafe = BlobSafe | FormDataSafe | URLSearchParamsSafe | string;
export type FetchRequestBody = string | BlobSafe | ArrayBufferSafe | FormDataSafe | URLSearchParamsSafe | ArrayBufferViewSafe | null | undefined;
export interface IRequestWrapper {
    headers?: Record<string, string>;
    bodySize?: number;
    method?: string;
    body?: FetchRequestBody | XMLHttpRequestBodyInitSafe | null;
}
export declare const MAXIMUM_ENTRIES = 100;
/**
 * This class encapsulates the RequestInit (https://developer.mozilla.org/en-US/docs/Web/API/RequestInit)
 * object so that the consumer can only get access to the headers, method and body size.
 *
 * This is to prevent consumers from directly accessing the Request object
 * and mutating it or running costly operations on it.
 *
 * IMPORTANT:
 *    * Do not make changes to this class without careful consideration
 *      of performance implications, memory usage and potential to mutate the customer's
 *      request.
 *   * NEVER .clone() the RequestInit object. This will 2x's the memory overhead of the request
 *   * NEVER: call .arrayBuffer(), text(), json() or any other method on the body that
 *     consumes the body's stream. This will cause the response to be consumed
 *     meaning the body will be empty when the customer tries to access it.
 *     (ie: if the body is an instanceof https://developer.mozilla.org/en-US/docs/Web/API/ReadableStream
 *      never call any of the methods on it)
 */
export declare class RequestWrapperFetch implements IRequestWrapper {
    private request;
    private _headers;
    private _bodySize;
    constructor(request: RequestInitSafe);
    get headers(): Record<string, string> | undefined;
    get bodySize(): number | undefined;
    get method(): string | undefined;
}
export declare class RequestWrapperXhr implements IRequestWrapper {
    readonly body: XMLHttpRequestBodyInitSafe | null;
    constructor(body: XMLHttpRequestBodyInitSafe | null);
    get bodySize(): number | undefined;
}
export interface IResponseWrapper {
    headers?: Record<string, string>;
    bodySize?: number;
    status?: number;
    body?: string | Blob | ReadableStream | ArrayBuffer | FormDataSafe | URLSearchParams | ArrayBufferView | null;
}
/**
 * This class encapsulates the Fetch API Response object
 * (https://developer.mozilla.org/en-US/docs/Web/API/Response) so that the consumer can
 * only get access to the headers and body size.
 *
 * This is to prevent consumers from directly accessing the Response object
 * and mutating it or running costly operations on it.
 *
 * IMPORTANT:
 *   * Do not make changes to this class without careful consideration
 *     of performance implications, memory usage and potential to mutate the customer's
 *     response.
 *   * NEVER .clone() the Response object. This will 2x's the memory overhead of the response
 *   * NEVER consume the body's stream. This will cause the response to be consumed
 *     meaning the body will be empty when the customer tries to access it.
 *     (ie: if the body is an instanceof https://developer.mozilla.org/en-US/docs/Web/API/ReadableStream
 *      never call any of the methods on it)
 */
export declare class ResponseWrapperFetch implements IResponseWrapper {
    private response;
    private _headers;
    private _bodySize;
    constructor(response: ResponseSafe);
    get headers(): Record<string, string> | undefined;
    get bodySize(): number | undefined;
    get status(): number;
}
export declare class ResponseWrapperXhr implements IResponseWrapper {
    readonly statusCode: number;
    readonly headersString: string;
    readonly size: number | undefined;
    constructor(statusCode: number, headersString: string, size: number | undefined);
    get bodySize(): number | undefined;
    get status(): number;
    get headers(): Record<string, string> | undefined;
}
export declare class NetworkRequestEvent {
    readonly type: 'xhr' | 'fetch';
    readonly method: string;
    readonly timestamp: number;
    readonly startTime: number;
    readonly url?: string | undefined;
    readonly requestWrapper?: IRequestWrapper | undefined;
    readonly status: number;
    readonly duration?: number | undefined;
    readonly responseWrapper?: IResponseWrapper | undefined;
    readonly error?: {
        name: string;
        message: string;
    } | undefined;
    readonly endTime?: number | undefined;
    constructor(type: 'xhr' | 'fetch', method: string, timestamp: number, startTime: number, url?: string | undefined, requestWrapper?: IRequestWrapper | undefined, status?: number, duration?: number | undefined, responseWrapper?: IResponseWrapper | undefined, error?: {
        name: string;
        message: string;
    } | undefined, endTime?: number | undefined);
    toSerializable(): Record<string, any>;
}
export {};
//# sourceMappingURL=network-request-event.d.ts.map