import { BrowserClient, NetworkRequestEvent, NetworkTrackingOptions } from '@amplitude/analytics-core';
import { AllWindowObservables } from './network-capture-plugin';
export declare function shouldTrackNetworkEvent(networkEvent: NetworkRequestEvent, options?: NetworkTrackingOptions): boolean;
export type NetworkAnalyticsEvent = {
    ['[Amplitude] URL']: string;
    ['[Amplitude] URL Query']?: string;
    ['[Amplitude] URL Fragment']?: string;
    ['[Amplitude] Request Method']: string;
    ['[Amplitude] Status Code']?: number;
    ['[Amplitude] Start Time']?: number;
    ['[Amplitude] Completion Time']?: number;
    ['[Amplitude] Duration']?: number;
    ['[Amplitude] Request Body Size']?: number;
    ['[Amplitude] Response Body Size']?: number;
    ['[Amplitude] Request Type']?: 'xhr' | 'fetch';
};
export declare function trackNetworkEvents({ allObservables, networkTrackingOptions, amplitude, }: {
    allObservables: AllWindowObservables;
    networkTrackingOptions: NetworkTrackingOptions;
    amplitude: BrowserClient;
}): import("rxjs").Subscription;
//# sourceMappingURL=track-network-event.d.ts.map