import { __assign } from "tslib";
import { filter, map, bufferTime } from 'rxjs';
import { filterOutNonTrackableEvents } from '../helpers';
import { AMPLITUDE_ELEMENT_RAGE_CLICKED_EVENT } from '../constants';
import { DEFAULT_RAGE_CLICK_THRESHOLD, DEFAULT_RAGE_CLICK_WINDOW_MS } from '@amplitude/analytics-core';
var RAGE_CLICK_THRESHOLD = DEFAULT_RAGE_CLICK_THRESHOLD;
var RAGE_CLICK_WINDOW_MS = DEFAULT_RAGE_CLICK_WINDOW_MS;
// allow override of rage click config for testing only
export function _overrideRageClickConfig(rageClickThreshold, rageClickWindowMs) {
    RAGE_CLICK_THRESHOLD = rageClickThreshold;
    RAGE_CLICK_WINDOW_MS = rageClickWindowMs;
}
export function trackRageClicks(_a) {
    var amplitude = _a.amplitude, allObservables = _a.allObservables, shouldTrackRageClick = _a.shouldTrackRageClick;
    var clickObservable = allObservables.clickObservable;
    // Buffer clicks within a RAGE_CLICK_WINDOW_MS window and filter for rage clicks
    var rageClickObservable = clickObservable.pipe(filter(filterOutNonTrackableEvents), filter(function (click) {
        return shouldTrackRageClick('click', click.closestTrackedAncestor);
    }), bufferTime(RAGE_CLICK_WINDOW_MS), filter(function (clicks) {
        // filter if not enough clicks to be a rage click
        if (clicks.length < RAGE_CLICK_THRESHOLD) {
            return false;
        }
        // filter if the last RAGE_CLICK_THRESHOLD clicks were not all on the same element
        var trailingIndex = clicks.length - 1;
        var lastClickTarget = clicks[trailingIndex].event.target;
        while (--trailingIndex >= clicks.length - RAGE_CLICK_THRESHOLD) {
            if (clicks[trailingIndex].event.target !== lastClickTarget) {
                return false;
            }
        }
        // if we reach here that means the last RAGE_CLICK_THRESHOLD clicks were all on the same element
        // and thus we have a rage click
        return true;
    }), map(function (clicks) {
        var firstClick = clicks[0];
        var lastClick = clicks[clicks.length - 1];
        var rageClickEvent = __assign({ '[Amplitude] Begin Time': new Date(firstClick.timestamp).toISOString(), '[Amplitude] End Time': new Date(lastClick.timestamp).toISOString(), '[Amplitude] Duration': lastClick.timestamp - firstClick.timestamp, '[Amplitude] Clicks': clicks.map(function (click) { return ({
                X: click.event.clientX,
                Y: click.event.clientY,
                Time: click.timestamp,
            }); }), '[Amplitude] Click Count': clicks.length }, firstClick.targetElementProperties);
        return { rageClickEvent: rageClickEvent, time: firstClick.timestamp };
    }));
    return rageClickObservable.subscribe(function (_a) {
        var rageClickEvent = _a.rageClickEvent, time = _a.time;
        amplitude.track(AMPLITUDE_ELEMENT_RAGE_CLICKED_EVENT, rageClickEvent, { time: time });
    });
}
//# sourceMappingURL=track-rage-click.js.map