"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Context = void 0;
var _analyticsTypes = require("@amplitude/analytics-types");
var _uaParserJs = _interopRequireDefault(require("@amplitude/ua-parser-js"));
var _analyticsCore = require("@amplitude/analytics-core");
var _analyticsClientCommon = require("@amplitude/analytics-client-common");
var _version = require("../version");
var _reactNative = require("react-native");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
const BROWSER_PLATFORM = 'Web';
const IP_ADDRESS = '$remote';
class Context {
  // this.config is defined in setup() which will always be called first
  // eslint-disable-next-line @typescript-eslint/ban-ts-comment
  // @ts-ignore

  constructor() {
    _defineProperty(this, "name", 'context');
    _defineProperty(this, "type", _analyticsTypes.PluginType.BEFORE);
    _defineProperty(this, "config", void 0);
    _defineProperty(this, "uaResult", void 0);
    _defineProperty(this, "nativeModule", _reactNative.NativeModules.AmplitudeReactNative);
    _defineProperty(this, "library", `amplitude-react-native-ts/${_version.VERSION}`);
    let agent;
    /* istanbul ignore else */
    if (typeof navigator !== 'undefined') {
      agent = navigator.userAgent;
    }
    this.uaResult = new _uaParserJs.default(agent).getResult();
  }
  setup(config) {
    this.config = config;
    return Promise.resolve(undefined);
  }
  async execute(context) {
    var _this$nativeModule;
    const time = new Date().getTime();
    const nativeContext = await ((_this$nativeModule = this.nativeModule) === null || _this$nativeModule === void 0 ? void 0 : _this$nativeModule.getApplicationContext(this.config.trackingOptions));
    const appVersion = this.config.appVersion || (nativeContext === null || nativeContext === void 0 ? void 0 : nativeContext.version);
    const platform = (nativeContext === null || nativeContext === void 0 ? void 0 : nativeContext.platform) || BROWSER_PLATFORM;
    const osName = (nativeContext === null || nativeContext === void 0 ? void 0 : nativeContext.osName) || this.uaResult.browser.name;
    const osVersion = (nativeContext === null || nativeContext === void 0 ? void 0 : nativeContext.osVersion) || this.uaResult.browser.version;
    const deviceVendor = (nativeContext === null || nativeContext === void 0 ? void 0 : nativeContext.deviceManufacturer) || this.uaResult.device.vendor;
    const deviceModel = (nativeContext === null || nativeContext === void 0 ? void 0 : nativeContext.deviceModel) || this.uaResult.device.model || this.uaResult.os.name;
    const language = (nativeContext === null || nativeContext === void 0 ? void 0 : nativeContext.language) || (0, _analyticsClientCommon.getLanguage)();
    const country = nativeContext === null || nativeContext === void 0 ? void 0 : nativeContext.country;
    const carrier = nativeContext === null || nativeContext === void 0 ? void 0 : nativeContext.carrier;
    const adid = nativeContext === null || nativeContext === void 0 ? void 0 : nativeContext.adid;
    const appSetId = nativeContext === null || nativeContext === void 0 ? void 0 : nativeContext.appSetId;
    const idfv = nativeContext === null || nativeContext === void 0 ? void 0 : nativeContext.idfv;
    const event = {
      user_id: this.config.userId,
      device_id: this.config.deviceId,
      session_id: this.config.sessionId,
      time,
      ...(appVersion && {
        app_version: appVersion
      }),
      ...(this.config.trackingOptions.platform && {
        platform: platform
      }),
      ...(this.config.trackingOptions.osName && {
        os_name: osName
      }),
      ...(this.config.trackingOptions.osVersion && {
        os_version: osVersion
      }),
      ...(this.config.trackingOptions.deviceManufacturer && {
        device_manufacturer: deviceVendor
      }),
      ...(this.config.trackingOptions.deviceModel && {
        device_model: deviceModel
      }),
      ...(this.config.trackingOptions.language && {
        language: language
      }),
      ...(this.config.trackingOptions.country && {
        country: country
      }),
      ...(this.config.trackingOptions.carrier && {
        carrier: carrier
      }),
      ...(this.config.trackingOptions.ipAddress && {
        ip: IP_ADDRESS
      }),
      ...(this.config.trackingOptions.adid && {
        adid: adid
      }),
      ...(this.config.trackingOptions.appSetId && {
        android_app_set_id: appSetId
      }),
      ...(this.config.trackingOptions.idfv && {
        idfv: idfv
      }),
      insert_id: (0, _analyticsCore.UUID)(),
      partner_id: this.config.partnerId,
      plan: this.config.plan,
      ...(this.config.ingestionMetadata && {
        ingestion_metadata: {
          source_name: this.config.ingestionMetadata.sourceName,
          source_version: this.config.ingestionMetadata.sourceVersion
        }
      }),
      ...context,
      library: this.library
    };
    return event;
  }
}
exports.Context = Context;
//# sourceMappingURL=context.js.map