import { CoreClient, Config, Event, BaseEvent, EventOptions, Identify, Plugin, Revenue, Result } from '@amplitude/analytics-types';
import { Timeline } from './timeline';
export declare class AmplitudeCore implements CoreClient {
    protected initializing: boolean;
    protected name: string;
    config: Config;
    timeline: Timeline;
    protected q: CallableFunction[];
    protected dispatchQ: CallableFunction[];
    constructor(name?: string);
    protected _init(config: Config): Promise<void>;
    runQueuedFunctions(queueName: 'q' | 'dispatchQ'): Promise<void>;
    track(eventInput: BaseEvent | string, eventProperties?: Record<string, any>, eventOptions?: EventOptions): import("@amplitude/analytics-types").AmplitudeReturn<Result>;
    logEvent: (eventInput: BaseEvent | string, eventProperties?: Record<string, any>, eventOptions?: EventOptions) => import("@amplitude/analytics-types").AmplitudeReturn<Result>;
    identify(identify: Identify, eventOptions?: EventOptions): import("@amplitude/analytics-types").AmplitudeReturn<Result>;
    groupIdentify(groupType: string, groupName: string | string[], identify: Identify, eventOptions?: EventOptions): import("@amplitude/analytics-types").AmplitudeReturn<Result>;
    setGroup(groupType: string, groupName: string | string[], eventOptions?: EventOptions): import("@amplitude/analytics-types").AmplitudeReturn<Result>;
    revenue(revenue: Revenue, eventOptions?: EventOptions): import("@amplitude/analytics-types").AmplitudeReturn<Result>;
    add(plugin: Plugin): import("@amplitude/analytics-types").AmplitudeReturn<void>;
    remove(pluginName: string): import("@amplitude/analytics-types").AmplitudeReturn<void>;
    dispatchWithCallback(event: Event, callback: (result: Result) => void): void;
    dispatch(event: Event): Promise<Result>;
    process(event: Event): Promise<Result>;
    setOptOut(optOut: boolean): void;
    flush(): import("@amplitude/analytics-types").AmplitudeReturn<void>;
}
//# sourceMappingURL=core-client.d.ts.map