import { BrowserOptions, DefaultTrackingOptions, PageTrackingOptions } from '@amplitude/analytics-types';
export declare const isFileDownloadTrackingEnabled: (defaultTracking: DefaultTrackingOptions | boolean | undefined) => boolean;
export declare const isFormInteractionTrackingEnabled: (defaultTracking: DefaultTrackingOptions | boolean | undefined) => boolean;
export declare const isPageViewTrackingEnabled: (defaultTracking: DefaultTrackingOptions | boolean | undefined) => boolean;
export declare const isSessionTrackingEnabled: (defaultTracking: DefaultTrackingOptions | boolean | undefined) => boolean;
/**
 * Returns page view tracking config
 *
 * if config.attribution.trackPageViews and config.defaultTracking.pageViews are both TRUE
 * then always track page views
 *
 * if config.attribution.trackPageViews is TRUE and config.defaultTracking.pageViews is FALSE
 * then only track page views on attribution
 *
 * if config.attribution.trackPageViews is FALSE and config.defaultTracking.pageViews is TRUE
 * then always track page views
 *
 * if config.attribution.trackPageViews and config.defaultTracking.pageViews are both FALSE
 * then never track page views
 */
export declare const getPageViewTrackingConfig: (config: BrowserOptions) => PageTrackingOptions;
//# sourceMappingURL=default-tracking.d.ts.map