import { AmplitudeCore, Event, EventOptions, IIdentify, IRevenue, TransportType, Result, BrowserOptions, BrowserConfig, BrowserClient } from '@amplitude/analytics-core';
import { WebAttribution } from './attribution/web-attribution';
/**
 * Exported for `@amplitude/unified` or integration with blade plugins.
 * If you only use `@amplitude/analytics-browser`, use `amplitude.init()` or `amplitude.createInstance()` instead.
 */
export declare class AmplitudeBrowser extends AmplitudeCore implements BrowserClient {
    config: BrowserConfig;
    previousSessionDeviceId: string | undefined;
    previousSessionUserId: string | undefined;
    webAttribution: WebAttribution | undefined;
    init(apiKey?: string, userIdOrOptions?: string | BrowserOptions, maybeOptions?: BrowserOptions): import("@amplitude/analytics-core").AmplitudeReturn<void>;
    protected _init(options: BrowserOptions & {
        apiKey: string;
    }): Promise<void>;
    getUserId(): string | undefined;
    setUserId(userId: string | undefined): void;
    getDeviceId(): string | undefined;
    setDeviceId(deviceId: string): void;
    reset(): void;
    getSessionId(): number | undefined;
    setSessionId(sessionId: number): import("@amplitude/analytics-core").AmplitudeReturn<void> | import("@amplitude/analytics-core").AmplitudeReturn<Result[]>;
    extendSession(): void;
    setTransport(transport: TransportType): void;
    identify(identify: IIdentify, eventOptions?: EventOptions): import("@amplitude/analytics-core").AmplitudeReturn<Result>;
    groupIdentify(groupType: string, groupName: string | string[], identify: IIdentify, eventOptions?: EventOptions): import("@amplitude/analytics-core").AmplitudeReturn<Result>;
    revenue(revenue: IRevenue, eventOptions?: EventOptions): import("@amplitude/analytics-core").AmplitudeReturn<Result>;
    private trackCampaignEventIfNeeded;
    process(event: Event): Promise<Result>;
    private logBrowserOptions;
}
//# sourceMappingURL=browser-client.d.ts.map