<h1 align="center">Loop Habit Tracker</h1>
<p align="center">
  <a href="https://github.com/iSoron/uhabits/actions?query=workflow%3A%22Build+%26+Test%22">
    <img src="https://github.com/iSoron/uhabits/workflows/Build%20&%20Test/badge.svg" />
  </a>
  <a href="https://github.com/iSoron/uhabits/releases/latest">
    <img src="https://img.shields.io/github/v/release/iSoron/uhabits" />
  </a>
  <a href="https://github.com/iSoron/uhabits/discussions">
    <img src="https://img.shields.io/badge/GitHub-Discussions-%23fc4ebc" />
  </a>
</p>

Loop is a mobile app that helps you create and maintain good habits,
allowing you to achieve your long-term goals. Detailed graphs and statistics
show you how your habits improved over time. It is completely ad-free and open
source.

<p align="center">
  <a href="https://play.google.com/store/apps/details?id=org.isoron.uhabits&utm_source=global_co&utm_medium=prtnr&utm_content=Mar2515&utm_campaign=PartBadge&pcampaignid=MKT-AC-global-none-all-co-pr-py-PartBadges-Oct1515-1"><img alt="Get it on Google Play" src="https://play.google.com/intl/en_us/badges/images/generic/en_badge_web_generic.png" height="80px"/></a>
  <a href="https://f-droid.org/app/org.isoron.uhabits"><img alt="Get it on F-Droid" src="https://f-droid.org/badge/get-it-on.png" height="80px"/></a>
</p>

## Screenshots

[![Main screen][screen1th]][screen1]
[![Edit habit][screen2th]][screen2]
[![Habit strength][screen3th]][screen3]
[![Habit history and streaks][screen4th]][screen4]
[![Widgets][screen5th]][screen5]
[![Night mode][screen6th]][screen6]

## Features

* <b>Beautiful, minimalistic and lightweight interface.</b>
Loop has an elegant and minimalistic interface that is very easy to use, even for first-time users. Highly optimized for speed, the app works well even on older phones.

* <b>Habit score.</b>
Loop has an advanced formula for calculating the strength of your habits. Every repetition makes your habit stronger and every missed day makes it weaker. A few missed days after a long streak, however, will not completely destroy your progress, unlike many other don't-break-the-chain apps.

* <b>Flexible schedules.</b>
In addition to daily habits, Loop supports habits with more complex schedules, such as 3 times per week or every other day.

* <b>Reminders.</b>
Schedule notifications to remind you of your habits. Each habit can have its own reminder, at a chosen time of the day. Easily check or dismiss your habit directly from the notification.

* <b>Widgets.</b>
Be reminded of your habits whenever you unlock your phone. Colorful widgets allow you to track your habits directly from your home screen, without even opening the app.

* <b>Take control of your data.</b>
If you want to further analyze your data, or move it to another service, Loop allows you to export it to spreadsheets (CSV) or to a database file (SQLite). For power users, checkmarks can be added through other apps, such as Tasker.

* <b>No limitations.</b>
Track as many habits as you wish. Loop imposes no artificial limits on how many habits you can have. All features are available to all users. There are no in-app purchases.

* <b>Completely ad-free and open source.</b>
There are no advertisements, annoying notifications or intrusive permissions in this app, and there will never be. The app is completely open-source (GPLv3).

* <b>Works offline and respects your privacy.</b>
Loop doesn't require an Internet connection or online account registration. Your confidential data is never sent to anyone. Neither the developers nor any third-parties have access to it.

## Installing

The easiest way to install Loop is through the [Google Play Store][playstore] or [F-Droid][fdroid].
You may also download and install the APK from the [releases page][releases];
note, however, that the app will not be updated automatically.  To build this
app from the source code, see [build instructions][build].

## Contributing

Loop is an open source project developed entirely by volunteers. If you would
like to contribute to the project, you are very welcome. There are many ways to
contribute, even if you are not a software developer.

* **Report bugs, suggest features.** The easiest way to contribute is to simply
  use the app and let us know if you find any problems or have any suggestions
  to improve it. To report a problem, please [create a new bug report](https://github.com/iSoron/uhabits/issues/new/choose).
  To request a new feature or vote on existing feature requests, please visit
  our [GitHub Discussions page](https://github.com/iSoron/uhabits/discussions/categories/feature-requests).
  If you would like to receive the newest versions of the app
  earlier than everyone else, [join our open beta on Google Play][beta].

* **Spread the word.** If you like the app, share it with your family, friends
  and colleagues. You can also rate and review the app on Google Play Store, to help
  other users find it more easily.

* **Translate the app into your own language.** If you are not a native English
  speaker, and would like to see the app translated into your own language,
  please join our [open translation project][poedit]. If the translation
  is already completed, you are also very welcome to join and proofread it.

* **Write some code.** If you are an Android developer, you are very welcome to
  contribute with code. Please see the [guidelines](https://github.com/iSoron/uhabits/blob/dev/docs/GUIDELINES.md).

## License

<img align="right" src="https://www.gnu.org/graphics/gplv3-88x31.png">

  Copyright (C) 2016-2021 Álinson Santos Xavier <isoron@gmail.com>

  Loop Habit Tracker is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by the
  Free Software Foundation, either version 3 of the License, or (at your
  option) any later version.

  Loop Habit Tracker is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program. If not, see <https://www.gnu.org/licenses/>.

[screen1]: screenshots/1.png
[screen2]: screenshots/2.png
[screen3]: screenshots/3.png
[screen4]: screenshots/4.png
[screen5]: screenshots/5.png
[screen6]: screenshots/6.png
[screen1th]: screenshots/1.thumb.png
[screen2th]: screenshots/2.thumb.png
[screen3th]: screenshots/3.thumb.png
[screen4th]: screenshots/4.thumb.png
[screen5th]: screenshots/5.thumb.png
[screen6th]: screenshots/6.thumb.png
[poedit]: https://translate.loophabits.org
[playstore]: https://play.google.com/store/apps/details?id=org.isoron.uhabits
[releases]: https://github.com/iSoron/uhabits/releases
[fdroid]: https://f-droid.org/app/org.isoron.uhabits
[build]: https://github.com/iSoron/uhabits/blob/dev/docs/BUILD.md
[beta]: https://play.google.com/apps/testing/org.isoron.uhabits
