package org.ironrabbit.tbchat.app.im.ui;

import org.ironrabbit.tbchat.R;
import org.ironrabbit.tbchat.app.im.app.ChatListActivity;
import org.ironrabbit.tbchat.app.im.app.ContactListActivity;
import org.ironrabbit.tbchat.app.lang.BhoTab;

import android.app.TabActivity;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.widget.TabHost;

public class TabbedContainer extends TabActivity {

    @Override
    public void onCreate(Bundle smurfy) {
        super.onCreate(smurfy);

        // Create an bundle  to recieve the intent sent in from the launching activity
        String passThruAction = getIntent().getAction();
        Uri passThruData = getIntent().getData();
        Bundle passThruExtras = getIntent().getExtras();

        setContentView(R.layout.tab_container);

        Resources res = getResources(); // Resource object to get Drawables 
        TabHost tabHost = getTabHost(); // The activity TabHost
        TabHost.TabSpec spec; // Resusable TabSpec for each tab
        Intent intent; // Reusable Intent for each tab

        // Do the same for the other tabs
        intent = new Intent().setClass(this, ContactListActivity.class);
        intent.setAction(passThruAction);
        intent.setData(passThruData);
        intent.putExtras(passThruExtras);
        spec = tabHost
                .newTabSpec("contacts")
                .setIndicator(new BhoTab(this, getTabWidget(), getString(R.string.menu_contact_list),
                        R.drawable.ic_tab_contacts).tab).setContent(intent);
        tabHost.addTab(spec);

        // Create an Intent to launch an Activity for the tab (to be reused)
        intent = new Intent().setClass(this, ChatListActivity.class);
        intent.setAction(passThruAction);
        intent.setData(passThruData);
        intent.putExtras(passThruExtras);

        // Initialize a TabSpec for each tab and add it to the TabHost
        spec = tabHost
                .newTabSpec("chats")
                .setIndicator(new BhoTab(this, getTabWidget(), getString(R.string.title_chats),
                        R.drawable.ic_tab_chats).tab).setContent(intent);
        tabHost.addTab(spec);

        //Value in parathes controls which tab element to view 
        tabHost.setCurrentTab(0);
    }
}
